/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.drf;

import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsRegression;
import hex.SplitFrame;
import hex.tree.SharedTreeModel;
import hex.tree.drf.DRF;
import hex.tree.drf.DRFModel;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import water.DKV;
import water.H2O;
import water.Iced;
import water.Key;
import water.Keyed;
import water.Scope;
import water.TestUtil;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.fvec.Frame;
import water.fvec.RebalanceDataSet;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.Triple;
import water.util.VecUtils;

public class DRFTest
extends TestUtil {
    static double _AUC = 1.0;
    static double _MSE = 0.041294642857142856;
    static double _LogLoss = 0.14472835908293025;

    @BeforeClass
    public static void stall() {
        DRFTest.stall_till_cloudsize((int)1);
    }

    static String[] s(String ... arr) {
        return arr;
    }

    @Test
    public void testClassIris1() throws Throwable {
        this.basicDRFTestOOBE_Classification("./smalldata/iris/iris.csv", "iris.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                return fr.numCols() - 1;
            }
        }, 1, 20, 1, 20, DRFTest.ard((double[][])new double[][]{DRFTest.ard((double[])new double[]{15.0, 0.0, 0.0}), DRFTest.ard((double[])new double[]{0.0, 18.0, 0.0}), DRFTest.ard((double[])new double[]{0.0, 1.0, 17.0})}), DRFTest.s("Iris-setosa", "Iris-versicolor", "Iris-virginica"));
    }

    @Test
    public void testClassIris5() throws Throwable {
        this.basicDRFTestOOBE_Classification("./smalldata/iris/iris.csv", "iris5.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                return fr.numCols() - 1;
            }
        }, 5, 20, 1, 20, DRFTest.ard((double[][])new double[][]{DRFTest.ard((double[])new double[]{43.0, 0.0, 0.0}), DRFTest.ard((double[])new double[]{0.0, 37.0, 4.0}), DRFTest.ard((double[])new double[]{0.0, 4.0, 39.0})}), DRFTest.s("Iris-setosa", "Iris-versicolor", "Iris-virginica"));
    }

    @Test
    public void testClassCars1() throws Throwable {
        this.basicDRFTestOOBE_Classification("./smalldata/junit/cars.csv", "cars.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("name").remove();
                return fr.find("cylinders");
            }
        }, 1, 20, 1, 20, DRFTest.ard((double[][])new double[][]{DRFTest.ard((double[])new double[]{0.0, 2.0, 0.0, 0.0, 0.0}), DRFTest.ard((double[])new double[]{0.0, 58.0, 6.0, 4.0, 0.0}), DRFTest.ard((double[])new double[]{0.0, 1.0, 0.0, 0.0, 0.0}), DRFTest.ard((double[])new double[]{1.0, 3.0, 4.0, 25.0, 1.0}), DRFTest.ard((double[])new double[]{0.0, 0.0, 0.0, 2.0, 37.0})}), DRFTest.s("3", "4", "5", "6", "8"));
    }

    @Test
    public void testClassCars5() throws Throwable {
        this.basicDRFTestOOBE_Classification("./smalldata/junit/cars.csv", "cars5.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("name").remove();
                return fr.find("cylinders");
            }
        }, 5, 20, 1, 20, DRFTest.ard((double[][])new double[][]{DRFTest.ard((double[])new double[]{1.0, 2.0, 0.0, 0.0, 0.0}), DRFTest.ard((double[])new double[]{0.0, 177.0, 1.0, 5.0, 0.0}), DRFTest.ard((double[])new double[]{0.0, 2.0, 0.0, 0.0, 0.0}), DRFTest.ard((double[])new double[]{0.0, 6.0, 1.0, 67.0, 1.0}), DRFTest.ard((double[])new double[]{0.0, 0.0, 0.0, 2.0, 84.0})}), DRFTest.s("3", "4", "5", "6", "8"));
    }

    @Test
    public void testConstantCols() throws Throwable {
        try {
            this.basicDRFTestOOBE_Classification("./smalldata/poker/poker100", "poker.hex", new PrepData(){

                @Override
                int prep(Frame fr) {
                    for (int i = 0; i < 7; ++i) {
                        fr.remove(3).remove();
                    }
                    return 3;
                }
            }, 1, 20, 1, 20, null, null);
            Assert.fail();
        }
        catch (H2OModelBuilderIllegalArgumentException h2OModelBuilderIllegalArgumentException) {
            // empty catch block
        }
    }

    @Ignore
    @Test
    public void testBadData() throws Throwable {
        this.basicDRFTestOOBE_Classification("./smalldata/junit/drf_infinities.csv", "infinitys.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                return fr.find("DateofBirth");
            }
        }, 1, 20, 1, 20, DRFTest.ard((double[][])new double[][]{DRFTest.ard((double[])new double[]{6.0, 0.0}), DRFTest.ard((double[])new double[]{9.0, 1.0})}), DRFTest.s("0", "1"));
    }

    public void testCreditSample1() throws Throwable {
        this.basicDRFTestOOBE_Classification("./smalldata/kaggle/creditsample-training.csv.gz", "credit.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("MonthlyIncome").remove();
                return fr.find("SeriousDlqin2yrs");
            }
        }, 1, 20, 1, 20, DRFTest.ard((double[][])new double[][]{DRFTest.ard((double[])new double[]{46294.0, 202.0}), DRFTest.ard((double[])new double[]{3187.0, 107.0})}), DRFTest.s("0", "1"));
    }

    @Test
    public void testCreditProstate1() throws Throwable {
        this.basicDRFTestOOBE_Classification("./smalldata/logreg/prostate.csv", "prostate.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("ID").remove();
                return fr.find("CAPSULE");
            }
        }, 1, 20, 1, 20, DRFTest.ard((double[][])new double[][]{DRFTest.ard((double[])new double[]{0.0, 70.0}), DRFTest.ard((double[])new double[]{0.0, 59.0})}), DRFTest.s("0", "1"));
    }

    @Test
    public void testCreditProstateRegression1() throws Throwable {
        this.basicDRFTestOOBE_Regression("./smalldata/logreg/prostate.csv", "prostateRegression.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("ID").remove();
                return fr.find("AGE");
            }
        }, 1, 20, 1, 10, 63.13182273942728);
    }

    @Test
    public void testCreditProstateRegression5() throws Throwable {
        this.basicDRFTestOOBE_Regression("./smalldata/logreg/prostate.csv", "prostateRegression5.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("ID").remove();
                return fr.find("AGE");
            }
        }, 5, 20, 1, 10, 59.713095855920244);
    }

    @Test
    public void testCreditProstateRegression50() throws Throwable {
        this.basicDRFTestOOBE_Regression("./smalldata/logreg/prostate.csv", "prostateRegression50.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("ID").remove();
                return fr.find("AGE");
            }
        }, 50, 20, 1, 10, 46.88452885668735);
    }

    @Test
    public void testCzechboard() throws Throwable {
        this.basicDRFTestOOBE_Classification("./smalldata/gbm_test/czechboard_300x300.csv", "czechboard_300x300.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                Vec resp = fr.remove("C2");
                fr.add("C2", VecUtils.toCategoricalVec((Vec)resp));
                resp.remove();
                return fr.find("C3");
            }
        }, 50, 20, 1, 20, DRFTest.ard((double[][])new double[][]{DRFTest.ard((double[])new double[]{0.0, 45000.0}), DRFTest.ard((double[])new double[]{0.0, 45000.0})}), DRFTest.s("0", "1"));
    }

    @Test
    public void test30kUnseenLevels() throws Throwable {
        this.basicDRFTestOOBE_Regression("./smalldata/gbm_test/30k_cattest.csv", "cat30k", new PrepData(){

            @Override
            int prep(Frame fr) {
                return fr.find("C3");
            }
        }, 50, 20, 10, 5, 0.25040633586487);
    }

    @Test
    public void testProstate() throws Throwable {
        this.basicDRFTestOOBE_Classification("./smalldata/prostate/prostate.csv.zip", "prostate2.zip.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                String[] names = (String[])fr.names().clone();
                Vec[] en = fr.remove(new int[]{1, 4, 5, 8});
                fr.add(names[1], VecUtils.toCategoricalVec((Vec)en[0]));
                fr.add(names[4], VecUtils.toCategoricalVec((Vec)en[1]));
                fr.add(names[5], VecUtils.toCategoricalVec((Vec)en[2]));
                fr.add(names[8], VecUtils.toCategoricalVec((Vec)en[3]));
                for (Vec v : en) {
                    v.remove();
                }
                fr.remove(0).remove();
                return 4;
            }
        }, 4, 2, 1, 1, null, DRFTest.s("0", "1"));
    }

    @Test
    public void testAlphabet() throws Throwable {
        this.basicDRFTestOOBE_Classification("./smalldata/gbm_test/alphabet_cattest.csv", "alphabetClassification.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                return fr.find("y");
            }
        }, 1, 20, 1, 20, DRFTest.ard((double[][])new double[][]{DRFTest.ard((double[])new double[]{670.0, 0.0}), DRFTest.ard((double[])new double[]{0.0, 703.0})}), DRFTest.s("0", "1"));
    }

    @Test
    public void testAlphabetRegression() throws Throwable {
        this.basicDRFTestOOBE_Regression("./smalldata/gbm_test/alphabet_cattest.csv", "alphabetRegression.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                return fr.find("y");
            }
        }, 1, 20, 1, 10, 0.0);
    }

    @Test
    public void testAlphabetRegression2() throws Throwable {
        this.basicDRFTestOOBE_Regression("./smalldata/gbm_test/alphabet_cattest.csv", "alphabetRegression2.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                return fr.find("y");
            }
        }, 1, 26, 1, 1, 0.0);
    }

    @Test
    public void testAlphabetRegression3() throws Throwable {
        this.basicDRFTestOOBE_Regression("./smalldata/gbm_test/alphabet_cattest.csv", "alphabetRegression3.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                return fr.find("y");
            }
        }, 1, 25, 1, 1, 0.24007225096411577);
    }

    @Ignore
    @Test
    public void testAirlines() throws Throwable {
        this.basicDRFTestOOBE_Classification("./smalldata/airlines/allyears2k_headers.zip", "airlines.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                for (String s : new String[]{"DepTime", "ArrTime", "ActualElapsedTime", "AirTime", "ArrDelay", "DepDelay", "Cancelled", "CancellationCode", "CarrierDelay", "WeatherDelay", "NASDelay", "SecurityDelay", "LateAircraftDelay", "IsArrDelayed"}) {
                    fr.remove(s).remove();
                }
                return fr.find("IsDepDelayed");
            }
        }, 7, 20, 1, 20, DRFTest.ard((double[][])new double[][]{DRFTest.ard((double[])new double[]{7958.0, 11707.0}), DRFTest.ard((double[])new double[]{2709.0, 19024.0})}), DRFTest.s("NO", "YES"));
    }

    static Vec unifyFrame(DRFModel.DRFParameters drf, Frame fr, PrepData prep, boolean classification) {
        int idx = prep.prep(fr);
        if (idx < 0) {
            idx ^= 0xFFFFFFFF;
        }
        String rname = fr._names[idx];
        drf._response_column = fr.names()[idx];
        Vec resp = fr.vecs()[idx];
        Vec ret = null;
        if (classification) {
            ret = fr.remove(idx);
            fr.add(rname, VecUtils.toCategoricalVec((Vec)resp));
        } else {
            fr.remove(idx);
            fr.add(rname, resp);
        }
        return ret;
    }

    public void basicDRFTestOOBE_Classification(String fnametrain, String hexnametrain, PrepData prep, int ntree, int nbins, int min_rows, int max_depth, double[][] expCM, String[] expRespDom) throws Throwable {
        this.basicDRF(fnametrain, hexnametrain, null, prep, ntree, max_depth, nbins, true, min_rows, expCM, -1.0, expRespDom);
    }

    public void basicDRFTestOOBE_Regression(String fnametrain, String hexnametrain, PrepData prep, int ntree, int nbins, int min_rows, int max_depth, double expMSE) throws Throwable {
        this.basicDRF(fnametrain, hexnametrain, null, prep, ntree, max_depth, nbins, false, min_rows, null, expMSE, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicDRF(String fnametrain, String hexnametrain, String fnametest, PrepData prep, int ntree, int max_depth, int nbins, boolean classification, int min_rows, double[][] expCM, double expMSE, String[] expRespDom) throws Throwable {
        Scope.enter();
        DRFModel.DRFParameters drf = new DRFModel.DRFParameters();
        Frame frTest = null;
        Frame pred = null;
        Frame frTrain = null;
        Frame test = null;
        Frame res = null;
        DRFModel model = null;
        try {
            ModelMetrics mm;
            frTrain = DRFTest.parse_test_file((String)fnametrain);
            Vec removeme = DRFTest.unifyFrame(drf, frTrain, prep, classification);
            if (removeme != null) {
                Scope.track((Vec)removeme);
            }
            DKV.put((Key)frTrain._key, (Iced)frTrain);
            drf._train = frTrain._key;
            drf._response_column = ((Frame)DKV.getGet((Key)drf._train)).lastVecName();
            drf._ntrees = ntree;
            drf._max_depth = max_depth;
            drf._min_rows = min_rows;
            drf._stopping_rounds = 0;
            drf._nbins = nbins;
            drf._nbins_cats = nbins;
            drf._mtries = -1;
            drf._sample_rate = 0.66667f;
            drf._seed = 0x100000002L;
            DRF job = new DRF(drf);
            model = (DRFModel)job.trainModel().get();
            Log.info((Object[])new Object[]{model._output});
            Assert.assertTrue((boolean)job.isStopped());
            if (fnametest != null) {
                frTest = DRFTest.parse_test_file((String)fnametest);
                pred = model.score(frTest);
                mm = ModelMetrics.getFromDKV((Model)model, (Frame)frTest);
            } else {
                mm = ModelMetrics.getFromDKV((Model)model, (Frame)frTrain);
            }
            Assert.assertEquals((String)"Number of trees differs!", (long)ntree, (long)((DRFModel.DRFOutput)model._output)._ntrees);
            test = DRFTest.parse_test_file((String)fnametrain);
            res = model.score(test);
            Assert.assertTrue((boolean)model.testJavaScoring(test, res, 1.0E-15));
            if (classification && expCM != null) {
                Assert.assertTrue((String)("Expected: " + Arrays.deepToString((Object[])expCM) + ", Got: " + Arrays.deepToString((Object[])mm.cm()._cm)), (boolean)Arrays.deepEquals((Object[])mm.cm()._cm, (Object[])expCM));
                Object[] cmDom = ((DRFModel.DRFOutput)model._output)._domains[((DRFModel.DRFOutput)model._output)._domains.length - 1];
                Assert.assertArrayEquals((String)"CM domain differs!", (Object[])expRespDom, (Object[])cmDom);
                Log.info((Object[])new Object[]{"\nOOB Training CM:\n" + mm.cm().toASCII()});
                Log.info((Object[])new Object[]{"\nTraining CM:\n" + ModelMetrics.getFromDKV((Model)model, (Frame)test).cm().toASCII()});
            } else if (!classification) {
                Assert.assertTrue((String)("Expected: " + expMSE + ", Got: " + mm.mse()), (Math.abs(expMSE - mm.mse()) <= 1.0E-10 * Math.abs(expMSE + mm.mse()) ? 1 : 0) != 0);
                Log.info((Object[])new Object[]{"\nOOB Training MSE: " + mm.mse()});
                Log.info((Object[])new Object[]{"\nTraining MSE: " + ModelMetrics.getFromDKV((Model)model, (Frame)test).mse()});
            }
            ModelMetrics.getFromDKV((Model)model, (Frame)test);
        }
        finally {
            if (frTrain != null) {
                frTrain.remove();
            }
            if (frTest != null) {
                frTest.remove();
            }
            if (model != null) {
                model.delete();
            }
            if (pred != null) {
                pred.delete();
            }
            if (test != null) {
                test.delete();
            }
            if (res != null) {
                res.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void testAutoRebalance() {
        boolean warmUp = true;
        if (warmUp) {
            int[] warmUpChunks;
            for (int chunk : warmUpChunks = new int[]{1, 2, 3, 4, 5}) {
                Frame tfr = null;
                Scope.enter();
                try {
                    tfr = DRFTest.parse_test_file((String)"/Users/ludirehak/Downloads/train.csv.zip");
                    DRFModel.DRFParameters parms = new DRFModel.DRFParameters();
                    parms._train = tfr._key;
                    parms._response_column = "Sales";
                    parms._nbins = 1000;
                    parms._ntrees = 10;
                    parms._max_depth = 20;
                    parms._mtries = -1;
                    parms._min_rows = 10.0;
                    parms._seed = 1234L;
                    DRF job = new DRF(parms);
                    DRFModel drf = (DRFModel)job.trainModel().get();
                    drf.delete();
                }
                finally {
                    if (tfr != null) {
                        tfr.remove();
                    }
                }
                Scope.exit((Key[])new Key[0]);
            }
        }
        int[] max_depths = new int[]{2, 5, 10, 15, 20};
        int[] chunks = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32};
        boolean[] rebalanceMes = new boolean[]{true};
        int[] ntrees = new int[]{10};
        int totalLength = chunks.length * max_depths.length * rebalanceMes.length * ntrees.length;
        double[] executionTimes = new double[totalLength];
        int[] outputchunks = new int[totalLength];
        int[] outputdepths = new int[totalLength];
        boolean[] outputrebalanceme = new boolean[totalLength];
        int[] outputntrees = new int[totalLength];
        int c = 0;
        for (int max_depth : max_depths) {
            for (int ntree : ntrees) {
                for (boolean rebalanceMe : rebalanceMes) {
                    for (int chunk : chunks) {
                        long startTime = System.currentTimeMillis();
                        Scope.enter();
                        Frame tfr = DRFTest.parse_test_file((String)"/Users/ludirehak/Downloads/train.csv.zip");
                        DRFModel.DRFParameters parms = new DRFModel.DRFParameters();
                        parms._train = tfr._key;
                        parms._response_column = "Sales";
                        parms._nbins = 1000;
                        parms._mtries = -1;
                        parms._min_rows = 10.0;
                        parms._seed = 1234L;
                        parms._ntrees = ntree;
                        parms._max_depth = max_depth;
                        DRF job = new DRF(parms);
                        DRFModel drf = (DRFModel)job.trainModel().get();
                        Assert.assertEquals((long)((DRFModel.DRFOutput)drf._output)._ntrees, (long)parms._ntrees);
                        ModelMetricsRegression mm = (ModelMetricsRegression)((DRFModel.DRFOutput)drf._output)._training_metrics;
                        int actualChunk = job.train().anyVec().nChunks();
                        drf.delete();
                        tfr.remove();
                        Scope.exit((Key[])new Key[0]);
                        executionTimes[c] = (double)(System.currentTimeMillis() - startTime) / 1000.0;
                        if (!rebalanceMe) assert (actualChunk == 22);
                        outputchunks[c] = actualChunk;
                        outputdepths[c] = max_depth;
                        outputrebalanceme[c] = rebalanceMe;
                        outputntrees[c] = ((DRFModel.DRFOutput)drf._output)._ntrees;
                        Log.info((Object[])new Object[]{"Iteration " + (c + 1) + " out of " + executionTimes.length});
                        Log.info((Object[])new Object[]{" DEPTH: " + outputdepths[c] + " NTREES: " + outputntrees[c] + " CHUNKS: " + outputchunks[c] + " EXECUTION TIME: " + executionTimes[c] + " Rebalanced: " + rebalanceMe + " WarmedUp: " + warmUp});
                        ++c;
                    }
                }
            }
        }
        String fileName = "/Users/ludirehak/Desktop/DRFTestRebalance3.txt";
        try {
            FileWriter fileWriter = new FileWriter(fileName);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write("max_depth,ntrees,nbins,min_rows,chunks,execution_time,rebalanceMe,warmUp");
            bufferedWriter.newLine();
            for (int i = 0; i < executionTimes.length; ++i) {
                bufferedWriter.write(outputdepths[i] + "," + outputntrees[i] + "," + 1000 + "," + 10 + "," + outputchunks[i] + "," + executionTimes[i] + ",," + (outputrebalanceme[i] ? 1 : 0) + "," + (warmUp ? 1 : 0));
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (Exception e) {
            Log.info((Object[])new Object[]{"Fail"});
        }
    }

    @Test
    public void testChunks() {
        int i;
        int N = 4;
        double[] mses = new double[4];
        int[] chunks = new int[]{1, 13, 19, 39, 500};
        for (i = 0; i < 4; ++i) {
            Scope.enter();
            Frame tfr = DRFTest.parse_test_file((String)"smalldata/covtype/covtype.20k.data");
            Key dest = Key.make((String)"df.rebalanced.hex");
            RebalanceDataSet rb = new RebalanceDataSet(tfr, dest, chunks[i]);
            H2O.submitTask((H2O.H2OCountedCompleter)rb);
            rb.join();
            tfr.delete();
            tfr = (Frame)DKV.get((Key)dest).get();
            Scope.track((Vec)tfr.replace(54, tfr.vecs()[54].toCategoricalVec()));
            DKV.put((Keyed)tfr);
            DRFModel.DRFParameters parms = new DRFModel.DRFParameters();
            parms._train = tfr._key;
            parms._response_column = "C55";
            parms._ntrees = 10;
            parms._seed = 1234L;
            parms._auto_rebalance = false;
            DRF job = new DRF(parms);
            DRFModel drf = (DRFModel)job.trainModel().get();
            Assert.assertEquals((long)((DRFModel.DRFOutput)drf._output)._ntrees, (long)parms._ntrees);
            mses[i] = ((DRFModel.DRFOutput)drf._output)._scored_train[((DRFModel.DRFOutput)drf._output)._scored_train.length - 1]._mse;
            drf.delete();
            if (tfr != null) {
                tfr.remove();
            }
            Scope.exit((Key[])new Key[0]);
        }
        for (i = 0; i < mses.length; ++i) {
            Log.info((Object[])new Object[]{"trial: " + i + " -> MSE: " + mses[i]});
        }
        for (double mse : mses) {
            Assert.assertEquals((double)mse, (double)mses[0], (double)1.0E-10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReproducibility() {
        Frame tfr = null;
        int N = 5;
        double[] mses = new double[5];
        Scope.enter();
        try {
            tfr = DRFTest.parse_test_file((String)"smalldata/covtype/covtype.20k.data");
            Key dest = Key.make((String)"df.rebalanced.hex");
            RebalanceDataSet rb = new RebalanceDataSet(tfr, dest, 256);
            H2O.submitTask((H2O.H2OCountedCompleter)rb);
            rb.join();
            tfr.delete();
            tfr = (Frame)DKV.get((Key)dest).get();
            for (int i = 0; i < 5; ++i) {
                DRFModel.DRFParameters parms = new DRFModel.DRFParameters();
                parms._train = tfr._key;
                parms._response_column = "C55";
                parms._nbins = 1000;
                parms._ntrees = 1;
                parms._max_depth = 8;
                parms._mtries = -1;
                parms._min_rows = 10.0;
                parms._seed = 1234L;
                DRFModel drf = (DRFModel)new DRF(parms).trainModel().get();
                Assert.assertEquals((long)((DRFModel.DRFOutput)drf._output)._ntrees, (long)parms._ntrees);
                mses[i] = ((DRFModel.DRFOutput)drf._output)._scored_train[((DRFModel.DRFOutput)drf._output)._scored_train.length - 1]._mse;
                drf.delete();
            }
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
        }
        Scope.exit((Key[])new Key[0]);
        for (int i = 0; i < mses.length; ++i) {
            Log.info((Object[])new Object[]{"trial: " + i + " -> MSE: " + mses[i]});
        }
        for (double mse : mses) {
            Assert.assertEquals((double)mse, (double)mses[0], (double)1.0E-15);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReproducibilityAirline() {
        int i;
        Frame tfr = null;
        boolean N = true;
        double[] mses = new double[1];
        Scope.enter();
        try {
            tfr = DRFTest.parse_test_file((String)"./smalldata/airlines/allyears2k_headers.zip");
            Key dest = Key.make((String)"df.rebalanced.hex");
            RebalanceDataSet rb = new RebalanceDataSet(tfr, dest, 256);
            H2O.submitTask((H2O.H2OCountedCompleter)rb);
            rb.join();
            tfr.delete();
            tfr = (Frame)DKV.get((Key)dest).get();
            for (String s : new String[]{"DepTime", "ArrTime", "ActualElapsedTime", "AirTime", "ArrDelay", "DepDelay", "Cancelled", "CancellationCode", "CarrierDelay", "WeatherDelay", "NASDelay", "SecurityDelay", "LateAircraftDelay", "IsArrDelayed"}) {
                tfr.remove(s).remove();
            }
            DKV.put((Keyed)tfr);
            for (int i2 = 0; i2 < 1; ++i2) {
                DRFModel.DRFParameters parms = new DRFModel.DRFParameters();
                parms._train = tfr._key;
                parms._response_column = "IsDepDelayed";
                parms._nbins = 10;
                parms._nbins_cats = 1024;
                parms._ntrees = 7;
                parms._max_depth = 10;
                parms._binomial_double_trees = false;
                parms._mtries = -1;
                parms._min_rows = 1.0;
                parms._sample_rate = 0.632f;
                parms._balance_classes = true;
                parms._seed = 0x100000002L;
                DRFModel drf = (DRFModel)new DRF(parms).trainModel().get();
                Assert.assertEquals((long)((DRFModel.DRFOutput)drf._output)._ntrees, (long)parms._ntrees);
                mses[i2] = ((DRFModel.DRFOutput)drf._output)._training_metrics.mse();
                drf.delete();
            }
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
        }
        Scope.exit((Key[])new Key[0]);
        for (i = 0; i < mses.length; ++i) {
            Log.info((Object[])new Object[]{"trial: " + i + " -> MSE: " + mses[i]});
        }
        for (i = 0; i < mses.length; ++i) {
            Assert.assertEquals((double)0.20377446328850304, (double)mses[i], (double)1.0E-4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void testAirline() {
        Frame tfr = null;
        Frame test = null;
        Scope.enter();
        try {
            tfr = DRFTest.parse_test_file((Key)Key.make((String)"air.hex"), (String)"/users/arno/sz_bench_data/train-1m.csv");
            test = DRFTest.parse_test_file((Key)Key.make((String)"airt.hex"), (String)"/users/arno/sz_bench_data/test.csv");
            DRFModel.DRFParameters parms = new DRFModel.DRFParameters();
            parms._train = tfr._key;
            parms._valid = test._key;
            parms._ignored_columns = new String[]{"Origin", "Dest"};
            parms._response_column = "dep_delayed_15min";
            parms._nbins = 20;
            parms._nbins_cats = 1024;
            parms._binomial_double_trees = new Random().nextBoolean();
            parms._ntrees = 1;
            parms._max_depth = 3;
            parms._mtries = -1;
            parms._sample_rate = 0.632f;
            parms._min_rows = 10.0;
            parms._seed = 12L;
            DRFModel drf = (DRFModel)new DRF(parms).trainModel().get();
            Log.info((Object[])new Object[]{"Training set AUC:   " + ((DRFModel.DRFOutput)drf._output)._training_metrics.auc_obj()._auc});
            Log.info((Object[])new Object[]{"Validation set AUC: " + ((DRFModel.DRFOutput)drf._output)._validation_metrics.auc_obj()._auc});
            Assert.assertEquals((double)((DRFModel.DRFOutput)drf._output)._training_metrics.auc_obj()._auc, (double)0.6498819479528417, (double)1.0E-8);
            Assert.assertEquals((double)((DRFModel.DRFOutput)drf._output)._validation_metrics.auc_obj()._auc, (double)0.6479974533672835, (double)1.0E-8);
            drf.delete();
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (test != null) {
                test.remove();
            }
        }
        Scope.exit((Key[])new Key[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoRowWeights() {
        Frame tfr = null;
        Object vfr = null;
        DRFModel drf = null;
        Scope.enter();
        try {
            tfr = DRFTest.parse_test_file((String)"smalldata/junit/no_weights.csv");
            DKV.put((Keyed)tfr);
            DRFModel.DRFParameters parms = new DRFModel.DRFParameters();
            parms._train = tfr._key;
            parms._response_column = "response";
            parms._seed = 234L;
            parms._min_rows = 1.0;
            parms._max_depth = 2;
            parms._ntrees = 3;
            drf = (DRFModel)new DRF(parms).trainModel().get();
            ModelMetricsBinomial mm = (ModelMetricsBinomial)((DRFModel.DRFOutput)drf._output)._training_metrics;
            Assert.assertEquals((double)_AUC, (double)mm.auc_obj()._auc, (double)1.0E-8);
            Assert.assertEquals((double)_MSE, (double)mm.mse(), (double)1.0E-8);
            Assert.assertEquals((double)_LogLoss, (double)mm.logloss(), (double)1.0E-6);
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (vfr != null) {
                vfr.remove();
            }
            if (drf != null) {
                drf.remove();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRowWeightsOne() {
        Frame tfr = null;
        Object vfr = null;
        DRFModel drf = null;
        Scope.enter();
        try {
            tfr = DRFTest.parse_test_file((String)"smalldata/junit/weights_all_ones.csv");
            DKV.put((Keyed)tfr);
            DRFModel.DRFParameters parms = new DRFModel.DRFParameters();
            parms._train = tfr._key;
            parms._response_column = "response";
            parms._weights_column = "weight";
            parms._seed = 234L;
            parms._min_rows = 1.0;
            parms._max_depth = 2;
            parms._ntrees = 3;
            drf = (DRFModel)new DRF(parms).trainModel().get();
            ModelMetricsBinomial mm = (ModelMetricsBinomial)((DRFModel.DRFOutput)drf._output)._training_metrics;
            Assert.assertEquals((double)_AUC, (double)mm.auc_obj()._auc, (double)1.0E-8);
            Assert.assertEquals((double)_MSE, (double)mm.mse(), (double)1.0E-8);
            Assert.assertEquals((double)_LogLoss, (double)mm.logloss(), (double)1.0E-6);
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (vfr != null) {
                vfr.remove();
            }
            if (drf != null) {
                drf.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRowWeightsTwo() {
        Frame tfr = null;
        Object vfr = null;
        DRFModel drf = null;
        Scope.enter();
        try {
            tfr = DRFTest.parse_test_file((String)"smalldata/junit/weights_all_twos.csv");
            DKV.put((Keyed)tfr);
            DRFModel.DRFParameters parms = new DRFModel.DRFParameters();
            parms._train = tfr._key;
            parms._response_column = "response";
            parms._weights_column = "weight";
            parms._seed = 234L;
            parms._min_rows = 2.0;
            parms._max_depth = 2;
            parms._ntrees = 3;
            drf = (DRFModel)new DRF(parms).trainModel().get();
            ModelMetricsBinomial mm = (ModelMetricsBinomial)((DRFModel.DRFOutput)drf._output)._training_metrics;
            Assert.assertEquals((double)_AUC, (double)mm.auc_obj()._auc, (double)1.0E-8);
            Assert.assertEquals((double)_MSE, (double)mm.mse(), (double)1.0E-8);
            Assert.assertEquals((double)_LogLoss, (double)mm.logloss(), (double)1.0E-6);
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (vfr != null) {
                vfr.remove();
            }
            if (drf != null) {
                drf.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRowWeightsTiny() {
        Frame tfr = null;
        Object vfr = null;
        DRFModel drf = null;
        Scope.enter();
        try {
            tfr = DRFTest.parse_test_file((String)"smalldata/junit/weights_all_tiny.csv");
            DKV.put((Keyed)tfr);
            DRFModel.DRFParameters parms = new DRFModel.DRFParameters();
            parms._train = tfr._key;
            parms._response_column = "response";
            parms._weights_column = "weight";
            parms._seed = 234L;
            parms._min_rows = 0.01242;
            parms._max_depth = 2;
            parms._ntrees = 3;
            drf = (DRFModel)new DRF(parms).trainModel().get();
            ModelMetricsBinomial mm = (ModelMetricsBinomial)((DRFModel.DRFOutput)drf._output)._training_metrics;
            Assert.assertEquals((double)_AUC, (double)mm.auc_obj()._auc, (double)1.0E-8);
            Assert.assertEquals((double)_MSE, (double)mm.mse(), (double)1.0E-8);
            Assert.assertEquals((double)_LogLoss, (double)mm.logloss(), (double)1.0E-6);
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (vfr != null) {
                vfr.remove();
            }
            if (drf != null) {
                drf.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoRowWeightsShuffled() {
        Frame tfr = null;
        Object vfr = null;
        DRFModel drf = null;
        Scope.enter();
        try {
            tfr = DRFTest.parse_test_file((String)"smalldata/junit/no_weights_shuffled.csv");
            DKV.put((Keyed)tfr);
            DRFModel.DRFParameters parms = new DRFModel.DRFParameters();
            parms._train = tfr._key;
            parms._response_column = "response";
            parms._seed = 234L;
            parms._min_rows = 1.0;
            parms._max_depth = 2;
            parms._ntrees = 3;
            drf = (DRFModel)new DRF(parms).trainModel().get();
            ModelMetricsBinomial mm = (ModelMetricsBinomial)((DRFModel.DRFOutput)drf._output)._training_metrics;
            Assert.assertEquals((double)1.0, (double)mm.auc_obj()._auc, (double)1.0E-8);
            Assert.assertEquals((double)0.029017857142857144, (double)mm.mse(), (double)1.0E-8);
            Assert.assertEquals((double)0.10824081452821664, (double)mm.logloss(), (double)1.0E-6);
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (vfr != null) {
                vfr.remove();
            }
            if (drf != null) {
                drf.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRowWeights() {
        Frame tfr = null;
        Object vfr = null;
        DRFModel drf = null;
        Scope.enter();
        try {
            tfr = DRFTest.parse_test_file((String)"smalldata/junit/weights.csv");
            DKV.put((Keyed)tfr);
            DRFModel.DRFParameters parms = new DRFModel.DRFParameters();
            parms._train = tfr._key;
            parms._response_column = "response";
            parms._weights_column = "weight";
            parms._seed = 234L;
            parms._min_rows = 1.0;
            parms._max_depth = 2;
            parms._ntrees = 3;
            drf = (DRFModel)new DRF(parms).trainModel().get();
            ModelMetricsBinomial mm = (ModelMetricsBinomial)((DRFModel.DRFOutput)drf._output)._training_metrics;
            Assert.assertEquals((double)1.0, (double)mm.auc_obj()._auc, (double)1.0E-8);
            Assert.assertEquals((double)0.05823863636363636, (double)mm.mse(), (double)1.0E-8);
            Assert.assertEquals((double)0.21035264541934587, (double)mm.logloss(), (double)1.0E-6);
            Frame pred = drf.score(parms.train());
            ModelMetricsBinomial mm2 = ModelMetricsBinomial.getFromDKV((Model)drf, (Frame)parms.train());
            Assert.assertEquals((double)1.0, (double)mm2.auc_obj()._auc, (double)1.0E-8);
            Assert.assertEquals((double)0.0154320987654321, (double)mm2.mse(), (double)1.0E-8);
            Assert.assertEquals((double)0.08349430638608361, (double)mm2.logloss(), (double)1.0E-8);
            pred.remove();
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (vfr != null) {
                vfr.remove();
            }
            if (drf != null) {
                drf.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void testNFold() {
        Frame tfr = null;
        Object vfr = null;
        DRFModel drf = null;
        Scope.enter();
        try {
            tfr = DRFTest.parse_test_file((String)"./smalldata/airlines/allyears2k_headers.zip");
            for (String s : new String[]{"DepTime", "ArrTime", "ActualElapsedTime", "AirTime", "ArrDelay", "DepDelay", "Cancelled", "CancellationCode", "CarrierDelay", "WeatherDelay", "NASDelay", "SecurityDelay", "LateAircraftDelay", "IsArrDelayed"}) {
                tfr.remove(s).remove();
            }
            DKV.put((Keyed)tfr);
            DRFModel.DRFParameters parms = new DRFModel.DRFParameters();
            parms._train = tfr._key;
            parms._response_column = "IsDepDelayed";
            parms._seed = 234L;
            parms._min_rows = 2.0;
            parms._nfolds = 3;
            parms._max_depth = 5;
            parms._ntrees = 5;
            drf = (DRFModel)new DRF(parms).trainModel().get();
            ModelMetricsBinomial mm = (ModelMetricsBinomial)((DRFModel.DRFOutput)drf._output)._cross_validation_metrics;
            Assert.assertEquals((double)0.7276154565296726, (double)mm.auc_obj()._auc, (double)1.0E-8);
            Assert.assertEquals((double)0.21211607823987555, (double)mm.mse(), (double)1.0E-8);
            Assert.assertEquals((double)0.6121968624307211, (double)mm.logloss(), (double)1.0E-6);
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (vfr != null) {
                vfr.remove();
            }
            if (drf != null) {
                drf.deleteCrossValidationModels();
                drf.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNFoldBalanceClasses() {
        Frame tfr = null;
        Object vfr = null;
        DRFModel drf = null;
        Scope.enter();
        try {
            tfr = DRFTest.parse_test_file((String)"./smalldata/airlines/allyears2k_headers.zip");
            for (String s : new String[]{"DepTime", "ArrTime", "ActualElapsedTime", "AirTime", "ArrDelay", "DepDelay", "Cancelled", "CancellationCode", "CarrierDelay", "WeatherDelay", "NASDelay", "SecurityDelay", "LateAircraftDelay", "IsArrDelayed"}) {
                tfr.remove(s).remove();
            }
            DKV.put((Keyed)tfr);
            DRFModel.DRFParameters parms = new DRFModel.DRFParameters();
            parms._train = tfr._key;
            parms._response_column = "IsDepDelayed";
            parms._seed = 234L;
            parms._min_rows = 2.0;
            parms._nfolds = 3;
            parms._max_depth = 5;
            parms._balance_classes = true;
            parms._ntrees = 5;
            drf = (DRFModel)new DRF(parms).trainModel().get();
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (vfr != null) {
                vfr.remove();
            }
            if (drf != null) {
                drf.deleteCrossValidationModels();
                drf.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNfoldsOneVsRest() {
        Frame tfr = null;
        DRFModel drf1 = null;
        DRFModel drf2 = null;
        Scope.enter();
        try {
            tfr = DRFTest.parse_test_file((String)"smalldata/junit/weights.csv");
            DKV.put((Keyed)tfr);
            DRFModel.DRFParameters parms = new DRFModel.DRFParameters();
            parms._train = tfr._key;
            parms._response_column = "response";
            parms._seed = 9999L;
            parms._min_rows = 2.0;
            parms._nfolds = (int)tfr.numRows();
            parms._fold_assignment = Model.Parameters.FoldAssignmentScheme.Modulo;
            parms._max_depth = 5;
            parms._ntrees = 5;
            drf1 = (DRFModel)new DRF(parms).trainModel().get();
            drf2 = (DRFModel)new DRF(parms).trainModel().get();
            ModelMetricsBinomial mm1 = (ModelMetricsBinomial)((DRFModel.DRFOutput)drf1._output)._cross_validation_metrics;
            ModelMetricsBinomial mm2 = (ModelMetricsBinomial)((DRFModel.DRFOutput)drf2._output)._cross_validation_metrics;
            Assert.assertEquals((double)mm1.auc_obj()._auc, (double)mm2.auc_obj()._auc, (double)1.0E-12);
            Assert.assertEquals((double)mm1.mse(), (double)mm2.mse(), (double)1.0E-12);
            Assert.assertEquals((double)mm1.logloss(), (double)mm2.logloss(), (double)1.0E-12);
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (drf1 != null) {
                drf1.deleteCrossValidationModels();
                drf1.delete();
            }
            if (drf2 != null) {
                drf2.deleteCrossValidationModels();
                drf2.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNfoldsInvalidValues() {
        Frame tfr = null;
        DRFModel drf1 = null;
        DRFModel drf2 = null;
        DRFModel drf3 = null;
        Scope.enter();
        try {
            tfr = DRFTest.parse_test_file((String)"./smalldata/airlines/allyears2k_headers.zip");
            for (String s : new String[]{"DepTime", "ArrTime", "ActualElapsedTime", "AirTime", "ArrDelay", "DepDelay", "Cancelled", "CancellationCode", "CarrierDelay", "WeatherDelay", "NASDelay", "SecurityDelay", "LateAircraftDelay", "IsArrDelayed"}) {
                tfr.remove(s).remove();
            }
            DKV.put((Keyed)tfr);
            DRFModel.DRFParameters parms = new DRFModel.DRFParameters();
            parms._train = tfr._key;
            parms._response_column = "IsDepDelayed";
            parms._seed = 234L;
            parms._min_rows = 2.0;
            parms._max_depth = 5;
            parms._ntrees = 5;
            parms._nfolds = 0;
            drf1 = (DRFModel)new DRF(parms).trainModel().get();
            parms._nfolds = 1;
            try {
                Log.info((Object[])new Object[]{"Trying nfolds==1."});
                drf2 = (DRFModel)new DRF(parms).trainModel().get();
                Assert.fail((String)"Should toss H2OModelBuilderIllegalArgumentException instead of reaching here");
            }
            catch (H2OModelBuilderIllegalArgumentException h2OModelBuilderIllegalArgumentException) {
                // empty catch block
            }
            parms._nfolds = -99;
            try {
                Log.info((Object[])new Object[]{"Trying nfolds==-99."});
                drf3 = (DRFModel)new DRF(parms).trainModel().get();
                Assert.fail((String)"Should toss H2OModelBuilderIllegalArgumentException instead of reaching here");
            }
            catch (H2OModelBuilderIllegalArgumentException h2OModelBuilderIllegalArgumentException) {
                // empty catch block
            }
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (drf1 != null) {
                drf1.delete();
            }
            if (drf2 != null) {
                drf2.delete();
            }
            if (drf3 != null) {
                drf3.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNfoldsCVAndValidation() {
        Frame tfr = null;
        Frame vfr = null;
        DRFModel drf = null;
        Scope.enter();
        try {
            tfr = DRFTest.parse_test_file((String)"smalldata/junit/weights.csv");
            vfr = DRFTest.parse_test_file((String)"smalldata/junit/weights.csv");
            DKV.put((Keyed)tfr);
            DRFModel.DRFParameters parms = new DRFModel.DRFParameters();
            parms._train = tfr._key;
            parms._valid = vfr._key;
            parms._response_column = "response";
            parms._min_rows = 2.0;
            parms._max_depth = 2;
            parms._nfolds = 2;
            parms._ntrees = 3;
            parms._seed = 11233L;
            try {
                Log.info((Object[])new Object[]{"Trying N-fold cross-validation AND Validation dataset provided."});
                drf = (DRFModel)new DRF(parms).trainModel().get();
            }
            catch (H2OModelBuilderIllegalArgumentException e) {
                Assert.fail((String)"Should not toss H2OModelBuilderIllegalArgumentException.");
            }
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (vfr != null) {
                vfr.remove();
            }
            if (drf != null) {
                drf.deleteCrossValidationModels();
                drf.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNfoldsConsecutiveModelsSame() {
        Frame tfr = null;
        Vec old = null;
        DRFModel drf1 = null;
        DRFModel drf2 = null;
        Scope.enter();
        try {
            tfr = DRFTest.parse_test_file((String)"smalldata/junit/cars_20mpg.csv");
            tfr.remove("name").remove();
            tfr.remove("economy").remove();
            old = tfr.remove("economy_20mpg");
            tfr.add("economy_20mpg", VecUtils.toCategoricalVec((Vec)old));
            DKV.put((Keyed)tfr);
            DRFModel.DRFParameters parms = new DRFModel.DRFParameters();
            parms._train = tfr._key;
            parms._response_column = "economy_20mpg";
            parms._min_rows = 2.0;
            parms._max_depth = 2;
            parms._nfolds = 3;
            parms._ntrees = 3;
            parms._seed = 77777L;
            drf1 = (DRFModel)new DRF(parms).trainModel().get();
            drf2 = (DRFModel)new DRF(parms).trainModel().get();
            ModelMetricsBinomial mm1 = (ModelMetricsBinomial)((DRFModel.DRFOutput)drf1._output)._cross_validation_metrics;
            ModelMetricsBinomial mm2 = (ModelMetricsBinomial)((DRFModel.DRFOutput)drf2._output)._cross_validation_metrics;
            Assert.assertEquals((double)mm1.auc_obj()._auc, (double)mm2.auc_obj()._auc, (double)1.0E-12);
            Assert.assertEquals((double)mm1.mse(), (double)mm2.mse(), (double)1.0E-12);
            Assert.assertEquals((double)mm1.logloss(), (double)mm2.logloss(), (double)1.0E-12);
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (old != null) {
                old.remove();
            }
            if (drf1 != null) {
                drf1.deleteCrossValidationModels();
                drf1.delete();
            }
            if (drf2 != null) {
                drf2.deleteCrossValidationModels();
                drf2.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMTrys() {
        Frame tfr = null;
        Vec old = null;
        DRFModel drf1 = null;
        for (int i = 1; i <= 6; ++i) {
            Scope.enter();
            try {
                tfr = DRFTest.parse_test_file((String)"smalldata/junit/cars_20mpg.csv");
                tfr.remove("name").remove();
                tfr.remove("economy").remove();
                old = tfr.remove("economy_20mpg");
                tfr.add("economy_20mpg", VecUtils.toCategoricalVec((Vec)old));
                DKV.put((Keyed)tfr);
                DRFModel.DRFParameters parms = new DRFModel.DRFParameters();
                parms._train = tfr._key;
                parms._response_column = "economy_20mpg";
                parms._min_rows = 2.0;
                parms._ntrees = 5;
                parms._max_depth = 5;
                parms._nfolds = 3;
                parms._mtries = i;
                drf1 = (DRFModel)new DRF(parms).trainModel().get();
                ModelMetricsBinomial mm1 = (ModelMetricsBinomial)((DRFModel.DRFOutput)drf1._output)._cross_validation_metrics;
                Assert.assertTrue((mm1._auc != null ? 1 : 0) != 0);
                continue;
            }
            finally {
                if (tfr != null) {
                    tfr.remove();
                }
                if (old != null) {
                    old.remove();
                }
                if (drf1 != null) {
                    drf1.deleteCrossValidationModels();
                    drf1.delete();
                }
                Scope.exit((Key[])new Key[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMTryNegTwo() {
        Frame tfr = null;
        Vec old = null;
        DRFModel drf1 = null;
        Scope.enter();
        try {
            tfr = DRFTest.parse_test_file((String)"smalldata/junit/cars_20mpg.csv");
            tfr.remove("name").remove();
            tfr.remove("economy").remove();
            old = tfr.remove("economy_20mpg");
            tfr.add("economy_20mpg", VecUtils.toCategoricalVec((Vec)old));
            tfr.add("constantCol", tfr.anyVec().makeCon(1.0));
            DKV.put((Keyed)tfr);
            DRFModel.DRFParameters parms = new DRFModel.DRFParameters();
            parms._train = tfr._key;
            parms._response_column = "economy_20mpg";
            parms._ignored_columns = new String[]{"year"};
            parms._min_rows = 2.0;
            parms._ntrees = 5;
            parms._max_depth = 5;
            parms._nfolds = 3;
            parms._mtries = -2;
            drf1 = (DRFModel)new DRF(parms).trainModel().get();
            ModelMetricsBinomial mm1 = (ModelMetricsBinomial)((DRFModel.DRFOutput)drf1._output)._cross_validation_metrics;
            Assert.assertTrue((mm1._auc != null ? 1 : 0) != 0);
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (old != null) {
                old.remove();
            }
            if (drf1 != null) {
                drf1.deleteCrossValidationModels();
                drf1.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStochasticDRFEquivalent() {
        Frame tfr = null;
        Object vfr = null;
        DRFModel drf = null;
        Scope.enter();
        try {
            tfr = DRFTest.parse_test_file((String)"./smalldata/junit/cars.csv");
            for (String s : new String[]{"name"}) {
                tfr.remove(s).remove();
            }
            DKV.put((Keyed)tfr);
            DRFModel.DRFParameters parms = new DRFModel.DRFParameters();
            parms._train = tfr._key;
            parms._response_column = "cylinders";
            parms._seed = 234L;
            parms._min_rows = 2.0;
            parms._max_depth = 5;
            parms._ntrees = 5;
            parms._mtries = 3;
            parms._sample_rate = 0.5;
            drf = (DRFModel)new DRF(parms).trainModel().get();
            ModelMetricsRegression mm = (ModelMetricsRegression)((DRFModel.DRFOutput)drf._output)._training_metrics;
            Assert.assertEquals((double)0.12358322821934015, (double)mm.mse(), (double)1.0E-4);
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (vfr != null) {
                vfr.remove();
            }
            if (drf != null) {
                drf.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testColSamplingPerTree() {
        Frame tfr = null;
        Key[] ksplits = new Key[]{};
        try {
            tfr = DRFTest.parse_test_file((String)"./smalldata/gbm_test/ecology_model.csv");
            SplitFrame sf = new SplitFrame(tfr, new double[]{0.5, 0.5}, new Key[]{Key.make((String)"train.hex"), Key.make((String)"test.hex")});
            sf.exec().get();
            ksplits = sf._destination_frames;
            DRFModel drf = null;
            float[] sample_rates = new float[]{0.2f, 0.4f, 0.6f, 0.8f, 1.0f};
            float[] col_sample_rates = new float[]{0.4f, 0.6f, 0.8f, 1.0f};
            float[] col_sample_rates_per_tree = new float[]{0.4f, 0.6f, 0.8f, 1.0f};
            TreeMap<Double, Triple> hm = new TreeMap<Double, Triple>();
            for (float sample_rate : sample_rates) {
                for (float col_sample_rate : col_sample_rates) {
                    for (float col_sample_rate_per_tree : col_sample_rates_per_tree) {
                        Scope.enter();
                        try {
                            DRFModel.DRFParameters parms = new DRFModel.DRFParameters();
                            parms._train = ksplits[0];
                            parms._valid = ksplits[1];
                            parms._response_column = "Angaus";
                            parms._seed = 12345L;
                            parms._min_rows = 1.0;
                            parms._max_depth = 15;
                            parms._ntrees = 2;
                            parms._mtries = Math.max(1, (int)(col_sample_rate * (float)(tfr.numCols() - 1)));
                            parms._col_sample_rate_per_tree = col_sample_rate_per_tree;
                            parms._sample_rate = sample_rate;
                            DRF job = new DRF(parms);
                            drf = (DRFModel)job.trainModel().get();
                            ModelMetricsRegression mm = (ModelMetricsRegression)((DRFModel.DRFOutput)drf._output)._validation_metrics;
                            hm.put(mm.mse(), new Triple((Object)Float.valueOf(sample_rate), (Object)Float.valueOf(col_sample_rate), (Object)Float.valueOf(col_sample_rate_per_tree)));
                        }
                        finally {
                            if (drf != null) {
                                drf.delete();
                            }
                            Scope.exit((Key[])new Key[0]);
                        }
                    }
                }
            }
            Triple last = null;
            for (Map.Entry n : hm.entrySet()) {
                Log.info((Object[])new Object[]{"MSE: " + n.getKey() + ", row sample: " + ((Triple)n.getValue()).v1 + ", col sample: " + ((Triple)n.getValue()).v2 + ", col sample per tree: " + ((Triple)n.getValue()).v3});
                last = (Triple)n.getValue();
            }
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            for (Key k : ksplits) {
                if (k == null) continue;
                k.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void minSplitImprovement() {
        Frame tfr = null;
        Key[] ksplits = null;
        DRFModel drf = null;
        try {
            int i;
            Scope.enter();
            tfr = DRFTest.parse_test_file((String)"smalldata/covtype/covtype.20k.data");
            int resp = 54;
            Scope.track((Vec)tfr.replace(resp, tfr.vecs()[resp].toCategoricalVec()));
            DKV.put((Keyed)tfr);
            SplitFrame sf = new SplitFrame(tfr, new double[]{0.5, 0.5}, new Key[]{Key.make((String)"train.hex"), Key.make((String)"valid.hex")});
            sf.exec().get();
            ksplits = sf._destination_frames;
            double[] msi = new double[]{0.0, 1.0E-10, 1.0E-8, 1.0E-6, 1.0E-4, 0.01};
            int N = msi.length;
            double[] loglosses = new double[N];
            for (i = 0; i < N; ++i) {
                DRFModel.DRFParameters parms = new DRFModel.DRFParameters();
                parms._train = ksplits[0];
                parms._valid = ksplits[1];
                parms._response_column = tfr.names()[resp];
                parms._min_split_improvement = msi[i];
                parms._score_tree_interval = parms._ntrees = 20;
                parms._max_depth = 15;
                parms._seed = 1234L;
                DRF job = new DRF(parms);
                drf = (DRFModel)job.trainModel().get();
                loglosses[i] = ((DRFModel.DRFOutput)drf._output)._scored_valid[((DRFModel.DRFOutput)drf._output)._scored_valid.length - 1]._logloss;
                if (drf == null) continue;
                drf.delete();
            }
            for (i = 0; i < msi.length; ++i) {
                Log.info((Object[])new Object[]{"min_split_improvement: " + msi[i] + " -> validation logloss: " + loglosses[i]});
            }
            int idx = ArrayUtils.minIndex((double[])loglosses);
            Log.info((Object[])new Object[]{"Optimal min_split_improvement: " + msi[idx]});
            Assert.assertTrue((0 != idx ? 1 : 0) != 0);
        }
        finally {
            if (drf != null) {
                drf.delete();
            }
            if (tfr != null) {
                tfr.delete();
            }
            if (ksplits[0] != null) {
                ksplits[0].remove();
            }
            if (ksplits[1] != null) {
                ksplits[1].remove();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void histoTypes() {
        Frame tfr = null;
        Key[] ksplits = null;
        DRFModel drf = null;
        try {
            int i;
            Scope.enter();
            tfr = DRFTest.parse_test_file((String)"smalldata/covtype/covtype.20k.data");
            int resp = 54;
            Scope.track((Vec)tfr.replace(resp, tfr.vecs()[resp].toCategoricalVec()));
            DKV.put((Keyed)tfr);
            SplitFrame sf = new SplitFrame(tfr, new double[]{0.5, 0.5}, new Key[]{Key.make((String)"train.hex"), Key.make((String)"valid.hex")});
            sf.exec().get();
            ksplits = sf._destination_frames;
            SharedTreeModel.SharedTreeParameters.HistogramType[] histoType = SharedTreeModel.SharedTreeParameters.HistogramType.values();
            int N = histoType.length;
            double[] loglosses = new double[N];
            for (i = 0; i < N; ++i) {
                DRFModel.DRFParameters parms = new DRFModel.DRFParameters();
                parms._train = ksplits[0];
                parms._valid = ksplits[1];
                parms._response_column = tfr.names()[resp];
                parms._histogram_type = histoType[i];
                parms._score_tree_interval = parms._ntrees = 10;
                parms._max_depth = 10;
                parms._seed = 12345L;
                parms._nbins = 20;
                parms._nbins_top_level = 20;
                DRF job = new DRF(parms);
                drf = (DRFModel)job.trainModel().get();
                loglosses[i] = ((DRFModel.DRFOutput)drf._output)._scored_valid[((DRFModel.DRFOutput)drf._output)._scored_valid.length - 1]._logloss;
                if (drf == null) continue;
                drf.delete();
            }
            for (i = 0; i < histoType.length; ++i) {
                Log.info((Object[])new Object[]{"histoType: " + histoType[i] + " -> validation logloss: " + loglosses[i]});
            }
            int idx = ArrayUtils.minIndex((double[])loglosses);
            Log.info((Object[])new Object[]{"Optimal randomization: " + histoType[idx]});
            Assert.assertTrue((4 == idx ? 1 : 0) != 0);
        }
        finally {
            if (drf != null) {
                drf.delete();
            }
            if (tfr != null) {
                tfr.delete();
            }
            if (ksplits[0] != null) {
                ksplits[0].remove();
            }
            if (ksplits[1] != null) {
                ksplits[1].remove();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void sampleRatePerClass() {
        Frame tfr = null;
        Key[] ksplits = null;
        DRFModel drf = null;
        try {
            Scope.enter();
            tfr = DRFTest.parse_test_file((String)"smalldata/covtype/covtype.20k.data");
            int resp = 54;
            Scope.track((Vec)tfr.replace(resp, tfr.vecs()[resp].toCategoricalVec()));
            DKV.put((Keyed)tfr);
            SplitFrame sf = new SplitFrame(tfr, new double[]{0.5, 0.5}, new Key[]{Key.make((String)"train.hex"), Key.make((String)"valid.hex")});
            sf.exec().get();
            ksplits = sf._destination_frames;
            DRFModel.DRFParameters parms = new DRFModel.DRFParameters();
            parms._train = ksplits[0];
            parms._valid = ksplits[1];
            parms._response_column = tfr.names()[resp];
            parms._min_split_improvement = 1.0E-5;
            parms._score_tree_interval = parms._ntrees = 20;
            parms._max_depth = 15;
            parms._seed = 1234L;
            parms._sample_rate_per_class = new double[]{0.1f, 0.1f, 0.2f, 0.4f, 1.0, 0.3f, 0.2f};
            DRF job = new DRF(parms);
            drf = (DRFModel)job.trainModel().get();
            if (drf != null) {
                drf.delete();
            }
        }
        finally {
            if (drf != null) {
                drf.delete();
            }
            if (tfr != null) {
                tfr.delete();
            }
            if (ksplits[0] != null) {
                ksplits[0].remove();
            }
            if (ksplits[1] != null) {
                ksplits[1].remove();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConstantResponse() {
        Scope.enter();
        Frame tfr = null;
        DRFModel drf = null;
        try {
            tfr = DRFTest.parse_test_file((Key)Key.make((String)"iris.hex"), (String)"./smalldata/iris/iris.csv");
            tfr.add("constantCol", tfr.anyVec().makeCon(1.0));
            DKV.put((Keyed)tfr);
            DRFModel.DRFParameters parms = new DRFModel.DRFParameters();
            parms._train = tfr._key;
            parms._response_column = "constantCol";
            parms._ntrees = 1;
            parms._max_depth = 3;
            parms._seed = 12L;
            parms._check_constant_response = false;
            drf = (DRFModel)new DRF(parms).trainModel().get();
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (drf != null) {
                drf.remove();
            }
        }
        Scope.exit((Key[])new Key[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScoreFeatureFrequencies() {
        Scope.enter();
        try {
            Frame train = DRFTest.parse_test_file((String)"./smalldata/logreg/prostate.csv");
            train.toCategoricalCol("CAPSULE");
            Scope.track((Frame[])new Frame[]{train});
            DRFModel.DRFParameters parms = new DRFModel.DRFParameters();
            parms._train = train._key;
            parms._response_column = "CAPSULE";
            parms._ntrees = 5;
            parms._seed = 49328L;
            parms._ignored_columns = new String[]{"ID"};
            SharedTreeModel model = (SharedTreeModel)new DRF(parms).trainModel().get();
            Scope.track_generic((Keyed)model);
            Frame ff = model.scoreFeatureFrequencies(train, Key.make((String)"ff_prostate"));
            Scope.track((Frame[])new Frame[]{ff});
            Assert.assertArrayEquals((Object[])((SharedTreeModel.SharedTreeOutput)model._output).features(), (Object[])ff.names());
            Assert.assertEquals((long)train.numRows(), (long)ff.numRows());
            Frame testRow = Scope.track((Frame[])new Frame[]{train.deepSlice((Object)new long[]{0L}, null)});
            Frame ffTestRow = model.scoreFeatureFrequencies(testRow, Key.make((String)"ff_prostate"));
            Scope.track((Frame[])new Frame[]{ffTestRow});
            long ffTotal = 0L;
            for (int i = 0; i < ffTestRow.numCols(); ++i) {
                ffTotal += ffTestRow.vec(i).at8(0L);
            }
            Frame lnAssignment = model.scoreLeafNodeAssignment(testRow, Model.LeafNodeAssignment.LeafNodeAssignmentType.Path, Key.make((String)"lna_prostate"));
            Scope.track((Frame[])new Frame[]{lnAssignment});
            long totalPathLength = 0L;
            for (String path : (String[])ArrayUtils.flat((Object[][])lnAssignment.domains())) {
                totalPathLength += (long)path.length();
            }
            Assert.assertEquals((long)totalPathLength, (long)ffTotal);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    static abstract class PrepData {
        PrepData() {
        }

        abstract int prep(Frame var1);
    }
}

