/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.drf;

import hex.tree.drf.DRF;
import hex.tree.drf.DRFModel;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import water.DKV;
import water.H2O;
import water.Key;
import water.Keyed;
import water.LocalMR;
import water.MrFun;
import water.Scope;
import water.TestUtil;
import water.fvec.Frame;
import water.util.Log;

public class DRFConcurrentTest
extends TestUtil {
    @BeforeClass
    public static void setup() {
        DRFConcurrentTest.stall_till_cloudsize((int)1);
    }

    @Test
    public void testBuildSingle() {
        Scope.enter();
        try {
            Frame fr = DRFConcurrentTest.parse_test_file((Key)Key.make((String)"prostate_single.hex"), (String)"smalldata/logreg/prostate.csv");
            fr.remove("ID").remove();
            Scope.track((Frame[])new Frame[]{fr});
            DKV.put((Keyed)fr);
            DRFConcurrentTest.buildXValDRF(fr, "AGE");
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    @Test
    public void testBuildConcurrent() {
        Scope.enter();
        try {
            Frame fr = DRFConcurrentTest.parse_test_file((Key)Key.make((String)"prostate_concurrent.hex"), (String)"smalldata/logreg/prostate.csv");
            Scope.track((Frame[])new Frame[]{fr});
            fr.remove("ID").remove();
            DKV.put((Keyed)fr);
            TrainSingleFun fun = new TrainSingleFun(fr);
            ((LocalMR)H2O.submitTask((H2O.H2OCountedCompleter)new LocalMR((MrFun)fun, 100))).join();
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void buildXValDRF(Frame train, String response) {
        DRFModel model = null;
        try {
            Scope.enter();
            DRFModel.DRFParameters drf = new DRFModel.DRFParameters();
            drf._train = train._key;
            drf._response_column = response;
            drf._seed = 0x100000002L;
            drf._nfolds = 5;
            drf._ntrees = 7;
            model = (DRFModel)new DRF(drf).trainModel().get();
            Assert.assertNotNull((Object)model);
            Log.info((Object[])new Object[]{model._output});
            Assert.assertEquals((long)5L, (long)((DRFModel.DRFOutput)model._output)._cross_validation_models.length);
        }
        finally {
            if (model != null) {
                model.delete();
                model.deleteCrossValidationModels();
                model.deleteCrossValidationPreds();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    private static class TrainSingleFun
    extends MrFun<TrainSingleFun> {
        private final Frame _train;

        private TrainSingleFun(Frame train) {
            this._train = train;
        }

        public TrainSingleFun() {
            this._train = null;
        }

        protected void map(int id) {
            assert (this._train != null);
            DRFConcurrentTest.buildXValDRF(this._train, "AGE");
        }
    }
}

