/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.drf;

import hex.tree.drf.DRF;
import hex.tree.drf.DRFModel;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import water.H2O;
import water.Key;
import water.TestUtil;
import water.fvec.Frame;
import water.parser.ParseSetup;

@RunWith(value=Parameterized.class)
public class DRFConcurrent2Test
extends TestUtil {
    private static final int REPEAT_N = 3;
    @Parameterized.Parameter
    public Object run;

    @Parameterized.Parameters
    public static Object[] repeated() {
        return new Object[3];
    }

    @BeforeClass
    public static void setup() {
        DRFConcurrent2Test.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrent() throws Exception {
        Assume.assumeTrue((H2O.getCloudSize() == 1 ? 1 : 0) != 0);
        Frame fr = null;
        try {
            fr = DRFConcurrent2Test.parse_test_file((String)"./smalldata/jira/pubdev_7193.csv", (TestUtil.ParseSetupTransformer)new TestUtil.ParseSetupTransformer(){

                public ParseSetup transformSetup(ParseSetup guessedSetup) {
                    return guessedSetup.setCheckHeader(1);
                }
            });
            ExecutorService executor = Executors.newFixedThreadPool(2);
            ArrayList<DRFBuilder> runnables = new ArrayList<DRFBuilder>();
            for (int i = 0; i < 50; ++i) {
                runnables.add(new DRFBuilder(fr));
            }
            for (Future future : executor.invokeAll(runnables)) {
                Assert.assertNotNull(future.get());
            }
        }
        finally {
            if (fr != null) {
                fr.delete();
            }
        }
    }

    private static class DRFBuilder
    implements Callable<DRFModel> {
        private final Key<Frame> _train;

        private DRFBuilder(Frame trainingFrame) {
            this._train = trainingFrame._key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DRFModel call() {
            DRFModel.DRFParameters params = new DRFModel.DRFParameters();
            params._response_column = "C2";
            params._train = this._train;
            DRF builder = new DRF(params);
            DRFModel model = null;
            try {
                model = (DRFModel)builder.trainModel().get();
            }
            finally {
                if (model != null) {
                    model.delete();
                }
            }
            return model;
        }
    }
}

