/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.Model;
import hex.genmodel.tools.PrintMojo;
import hex.tree.gbm.GBM;
import hex.tree.gbm.GBMModel;
import hex.tree.isofor.IsolationForest;
import hex.tree.isofor.IsolationForestModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.Permission;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import water.Key;
import water.Scope;
import water.TestUtil;
import water.fvec.Frame;

public class PrintMojoTreeTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    private SecurityManager originalSecurityManager;

    @Before
    public void setUp() throws Exception {
        TestUtil.stall_till_cloudsize((int)1);
        this.originalSecurityManager = System.getSecurityManager();
        System.setSecurityManager(new PreventExitSecurityManager());
    }

    @After
    public void tearDown() throws Exception {
        System.setSecurityManager(this.originalSecurityManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMojoCategoricalPrint() throws IOException {
        try {
            Scope.enter();
            Frame train = Scope.track((Frame[])new Frame[]{TestUtil.parse_test_file((String)"smalldata/iris/iris.csv")});
            IsolationForestModel.IsolationForestParameters p = new IsolationForestModel.IsolationForestParameters();
            p._train = train._key;
            p._ignored_columns = new String[]{"C1", "C2", "C3", "C4"};
            p._seed = 65261L;
            p._ntrees = 1;
            IsolationForestModel model = (IsolationForestModel)new IsolationForest(p).trainModel().get();
            File modelFile = this.folder.newFile();
            model.exportMojo(modelFile.getAbsolutePath(), true);
            File treeOutput = this.folder.newFile();
            try {
                PrintMojo.main((String[])new String[]{"--input", modelFile.getAbsolutePath(), "--output", treeOutput.getAbsolutePath()});
                Assert.fail((String)"Expected PrintMojo to call System.exit()");
            }
            catch (PreventedExitException preventedExitException) {
                // empty catch block
            }
            String treeDotz = FileUtils.readFileToString((File)treeOutput);
            System.out.println(treeDotz);
            Assert.assertFalse((boolean)treeDotz.isEmpty());
            Pattern labelPattern = Pattern.compile("label{1}=\\\"(.*?)\\\"");
            Pattern labelContentPattern = Pattern.compile(".*[<>=].*");
            Matcher matcher = labelPattern.matcher(treeDotz);
            Assert.assertEquals((long)1L, (long)matcher.groupCount());
            while (matcher.find()) {
                Assert.assertFalse((boolean)labelContentPattern.matcher(matcher.group(1)).matches());
            }
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMojoCategoricalPrint_limitedLevels() throws IOException {
        try {
            Scope.enter();
            Frame train = Scope.track((Frame[])new Frame[]{TestUtil.parse_test_file((String)"smalldata/iris/iris.csv")});
            IsolationForestModel.IsolationForestParameters p = new IsolationForestModel.IsolationForestParameters();
            p._train = train._key;
            p._ignored_columns = new String[]{"C1", "C2", "C3", "C4"};
            p._seed = 65261L;
            p._ntrees = 1;
            IsolationForestModel model = (IsolationForestModel)new IsolationForest(p).trainModel().get();
            File modelFile = this.folder.newFile();
            model.exportMojo(modelFile.getAbsolutePath(), true);
            File treeOutput = this.folder.newFile();
            try {
                PrintMojo.main((String[])new String[]{"--input", modelFile.getAbsolutePath(), "--output", treeOutput.getAbsolutePath(), "--levels", "1"});
                Assert.fail((String)"Expected PrintMojo to call System.exit()");
            }
            catch (PreventedExitException preventedExitException) {
                // empty catch block
            }
            String treeDotz = FileUtils.readFileToString((File)treeOutput);
            Assert.assertTrue((boolean)treeDotz.contains("\"SG_0_Node_0\" -> \"SG_0_Node_1\" [fontsize=14, label=\"[NA]\n2 levels\n\"]\n\"SG_0_Node_0\" -> \"SG_0_Node_4\" [fontsize=14, label=\"Iris-virginica\n\"]\n\"SG_0_Node_1\" -> \"SG_0_Node_5\" [fontsize=14, label=\"Iris-versicolor\n\"]\n\"SG_0_Node_1\" -> \"SG_0_Node_6\" [fontsize=14, label=\"[NA]\nIris-setosa\n\"]"));
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMojoCategoricalPrint_internalRepresentationOutput() throws IOException {
        try {
            Scope.enter();
            Frame train = Scope.track((Frame[])new Frame[]{TestUtil.parse_test_file((String)"smalldata/iris/iris.csv")});
            IsolationForestModel.IsolationForestParameters p = new IsolationForestModel.IsolationForestParameters();
            p._train = train._key;
            p._ignored_columns = new String[]{"C1", "C2", "C3", "C4"};
            p._seed = 65261L;
            p._ntrees = 1;
            IsolationForestModel model = (IsolationForestModel)new IsolationForest(p).trainModel().get();
            File modelFile = this.folder.newFile();
            model.exportMojo(modelFile.getAbsolutePath(), true);
            File treeOutput = this.folder.newFile();
            try {
                PrintMojo.main((String[])new String[]{"--input", modelFile.getAbsolutePath(), "--output", treeOutput.getAbsolutePath(), "--internal"});
                Assert.fail((String)"Expected PrintMojo to call System.exit()");
            }
            catch (PreventedExitException preventedExitException) {
                // empty catch block
            }
            String treeDotz = FileUtils.readFileToString((File)treeOutput);
            Assert.assertFalse((boolean)treeDotz.isEmpty());
            System.out.println(treeDotz);
            Pattern labelPattern = Pattern.compile("label{1}=\\\"(.*?)\\\"");
            Pattern labelContentPattern = Pattern.compile(".*[<>=].*");
            Matcher matcher = labelPattern.matcher(treeDotz);
            Assert.assertEquals((long)1L, (long)matcher.groupCount());
            int matches = 0;
            while (matcher.find()) {
                if (!labelContentPattern.matcher(matcher.group(1)).matches()) continue;
                ++matches;
            }
            Assert.assertTrue((matches > 0 ? 1 : 0) != 0);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    private void assertMojoJSONEqualsFixture(Model model, String fixtureFile) throws IOException {
        File modelFile = this.folder.newFile();
        model.exportMojo(modelFile.getAbsolutePath(), true);
        File treeOutput = this.folder.newFile();
        try {
            PrintMojo.main((String[])new String[]{"--input", modelFile.getAbsolutePath(), "--output", treeOutput.getAbsolutePath(), "--format", "json"});
            Assert.fail((String)"Expected PrintMojo to call System.exit()");
        }
        catch (PreventedExitException preventedExitException) {
            // empty catch block
        }
        String treeJson = FileUtils.readFileToString((File)treeOutput);
        Assert.assertFalse((boolean)treeJson.isEmpty());
        String expectedTreeJson = IOUtils.toString((InputStream)this.getClass().getResourceAsStream(fixtureFile));
        Assert.assertEquals((Object)this.removeH2OVersion(expectedTreeJson), (Object)this.removeH2OVersion(treeJson));
    }

    private void assertMojoPngGenerated(Model model, String[] expectedFileNames) throws IOException {
        Path modelPath = this.folder.newFile().toPath();
        model.exportMojo(modelPath.toAbsolutePath().toString(), true);
        Path treeOutputPath = this.folder.newFile("exampleh2o.png").toPath();
        try {
            PrintMojo.main((String[])new String[]{"--input", modelPath.toAbsolutePath().toString(), "--output", treeOutputPath.toAbsolutePath().toString(), "--format", "png"});
            Assert.fail((String)"Expected PrintMojo to call System.exit()");
        }
        catch (PreventedExitException preventedExitException) {
            // empty catch block
        }
        int numberOfFiles = expectedFileNames.length;
        if (numberOfFiles > 1) {
            List fileNames = Files.list(treeOutputPath).sorted(Comparator.reverseOrder()).collect(Collectors.toList());
            for (int i = 0; i < numberOfFiles; ++i) {
                Assert.assertTrue((boolean)((Path)fileNames.get(i)).endsWith(expectedFileNames[i]));
            }
        } else {
            Assert.assertTrue((boolean)treeOutputPath.endsWith(expectedFileNames[0]));
        }
    }

    private String removeH2OVersion(String json) {
        return json.replaceAll("\"h2o_version\": \"[\\d\\.]+\"", "h2o_version");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMojoCategoricalJson() throws IOException {
        try {
            Scope.enter();
            Frame train = Scope.track((Frame[])new Frame[]{TestUtil.parse_test_file((String)"smalldata/testng/airlines.csv")});
            IsolationForestModel.IsolationForestParameters p = new IsolationForestModel.IsolationForestParameters();
            p._train = train._key;
            p._seed = 65261L;
            p._response_column = "IsDepDelayed";
            p._ntrees = 1;
            p._max_depth = 3;
            p._ignored_columns = new String[]{"Origin", "Dest", "IsDepDelayed"};
            IsolationForestModel model = (IsolationForestModel)new IsolationForest(p).trainModel().get();
            this.assertMojoJSONEqualsFixture((Model)model, "categorical.json");
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMojoCategoricalOneHotJson() throws IOException {
        try {
            Scope.enter();
            Frame train = Scope.track((Frame[])new Frame[]{TestUtil.parse_test_file((String)"smalldata/testng/airlines.csv")});
            GBMModel.GBMParameters p = new GBMModel.GBMParameters();
            p._train = train._key;
            p._seed = 65261L;
            p._response_column = "IsDepDelayed";
            p._categorical_encoding = Model.Parameters.CategoricalEncodingScheme.OneHotExplicit;
            p._ntrees = 2;
            p._max_depth = 3;
            p._ignored_columns = new String[]{"Origin", "Dest"};
            GBMModel model = (GBMModel)new GBM(p).trainModel().get();
            this.assertMojoJSONEqualsFixture((Model)model, "categoricalOneHot.json");
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMojoGBMJson() throws IOException {
        try {
            Scope.enter();
            Frame train = Scope.track((Frame[])new Frame[]{TestUtil.parse_test_file((String)"smalldata/extdata/prostate.csv")});
            GBMModel.GBMParameters p = new GBMModel.GBMParameters();
            p._train = train._key;
            p._response_column = "CAPSULE";
            p._ignored_columns = new String[]{"ID"};
            p._seed = 1L;
            p._ntrees = 2;
            p._max_depth = 3;
            GBMModel model = (GBMModel)new GBM(p).trainModel().get();
            this.assertMojoJSONEqualsFixture((Model)model, "gbmProstate.json");
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMojoCategoricalPng() throws IOException {
        try {
            Scope.enter();
            String[] expectedFileNames = new String[]{"exampleh2o.png"};
            Frame train = Scope.track((Frame[])new Frame[]{TestUtil.parse_test_file((String)"smalldata/testng/airlines.csv")});
            IsolationForestModel.IsolationForestParameters p = new IsolationForestModel.IsolationForestParameters();
            p._train = train._key;
            p._seed = 65261L;
            p._response_column = "IsDepDelayed";
            p._ntrees = 1;
            p._max_depth = 3;
            p._ignored_columns = new String[]{"Origin", "Dest", "IsDepDelayed"};
            IsolationForestModel model = (IsolationForestModel)new IsolationForest(p).trainModel().get();
            this.assertMojoPngGenerated((Model)model, expectedFileNames);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMojoCategoricalOneHotPng() throws IOException {
        try {
            Scope.enter();
            String[] expectedFileNames = new String[]{"Tree1_ClassNO.png", "Tree0_ClassNO.png"};
            Frame train = Scope.track((Frame[])new Frame[]{TestUtil.parse_test_file((String)"smalldata/testng/airlines.csv")});
            GBMModel.GBMParameters p = new GBMModel.GBMParameters();
            p._train = train._key;
            p._seed = 65261L;
            p._response_column = "IsDepDelayed";
            p._categorical_encoding = Model.Parameters.CategoricalEncodingScheme.OneHotExplicit;
            p._ntrees = 2;
            p._max_depth = 3;
            p._ignored_columns = new String[]{"Origin", "Dest"};
            GBMModel model = (GBMModel)new GBM(p).trainModel().get();
            this.assertMojoPngGenerated((Model)model, expectedFileNames);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMojoGBMPng() throws IOException {
        try {
            Scope.enter();
            String[] expectedFileNames = new String[]{"Tree1.png", "Tree0.png"};
            Frame train = Scope.track((Frame[])new Frame[]{TestUtil.parse_test_file((String)"smalldata/extdata/prostate.csv")});
            GBMModel.GBMParameters p = new GBMModel.GBMParameters();
            p._train = train._key;
            p._response_column = "CAPSULE";
            p._ignored_columns = new String[]{"ID"};
            p._seed = 1L;
            p._ntrees = 2;
            p._max_depth = 3;
            GBMModel model = (GBMModel)new GBM(p).trainModel().get();
            this.assertMojoPngGenerated((Model)model, expectedFileNames);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    private static class PreventExitSecurityManager
    extends SecurityManager {
        private PreventExitSecurityManager() {
        }

        @Override
        public void checkPermission(Permission perm) {
        }

        @Override
        public void checkPermission(Permission perm, Object context) {
        }

        @Override
        public void checkExit(int status) {
            throw new PreventedExitException(status);
        }
    }

    protected static class PreventedExitException
    extends SecurityException {
        public final int status;

        public PreventedExitException(int status) {
            this.status = status;
        }
    }
}

