/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.tree.DHistogram;
import hex.tree.SharedTreeModel;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Key;
import water.Keyed;
import water.TestUtil;
import water.util.ArrayUtils;
import water.util.AtomicUtils;
import water.util.Log;
import water.util.PrettyPrint;
import water.util.RandomUtils;

public class HistogramTest
extends TestUtil {
    static final int BUCKETS = 100;
    static final int THREADS = 100;
    static final int THREAD_LOOPS = 100;

    @BeforeClass
    public static void stall() {
        HistogramTest.stall_till_cloudsize((int)1);
    }

    @Test
    public void run() {
        Futures fs = new Futures();
        long seed = 912559L;
        Log.info((Object[])new Object[]{"Histogram size: 100"});
        Log.info((Object[])new Object[]{"Threads: 100"});
        Log.info((Object[])new Object[]{"Loops per Thread: 100"});
        Histo hist = new Histo(100);
        for (int i = 0; i < 100; ++i) {
            fs.add((Future)H2O.submitTask((H2O.H2OCountedCompleter)new Filler(hist, seed + (long)i)));
        }
        fs.blockForPending();
        Histo hist2 = new Histo(100);
        for (int i = 0; i < 100; ++i) {
            fs.add((Future)H2O.submitTask((H2O.H2OCountedCompleter)new Filler(hist2, seed + (long)i)));
        }
        fs.blockForPending();
        double maxRelErrorDD = 0.0;
        for (int i = 0; i < hist._sumsD.length; ++i) {
            maxRelErrorDD = Math.max(Math.abs(hist._sumsD[i] - hist2._sumsD[i]) / Math.abs(hist._sumsD[i]), maxRelErrorDD);
        }
        Log.info((Object[])new Object[]{"Max rel. error between D and D: " + maxRelErrorDD});
        assert (!Arrays.equals(hist._sumsD, hist2._sumsD));
        double maxRelErrorFF = 0.0;
        for (int i = 0; i < hist._sumsF.length; ++i) {
            maxRelErrorFF = Math.max(Math.abs(hist._sumsF[i] - hist2._sumsF[i]) / Math.abs(hist._sumsF[i]), maxRelErrorFF);
        }
        Log.info((Object[])new Object[]{"Max rel. error between F and F: " + maxRelErrorFF});
        assert (maxRelErrorDD > maxRelErrorFF);
        double maxRelErrorDF = 0.0;
        for (Histo h : new Histo[]{hist, hist2}) {
            for (int i = 0; i < h._sumsD.length; ++i) {
                maxRelErrorDF = Math.max(Math.abs(h._sumsD[i] - h._sumsF[i]) / Math.abs(h._sumsD[i]), maxRelErrorDF);
            }
        }
        Log.info((Object[])new Object[]{"Max rel. error between D and F: " + maxRelErrorDF});
        assert (maxRelErrorDF < 1.0E-6);
    }

    @Test
    public void testSplits() {
        int nbins;
        int nbins_cats = nbins = 13;
        byte isInt = 0;
        double min = 1.0;
        double maxEx = 6.900000000000001;
        for (SharedTreeModel.SharedTreeParameters.HistogramType histoType : SharedTreeModel.SharedTreeParameters.HistogramType.values()) {
            int i;
            Log.info((Object[])new Object[0]);
            Log.info((Object[])new Object[]{"random split points: " + histoType});
            long seed = new Random().nextLong();
            if (histoType == SharedTreeModel.SharedTreeParameters.HistogramType.Random) {
                Log.info((Object[])new Object[]{"random seed: " + seed});
            }
            double[] splitPts = null;
            if (histoType == SharedTreeModel.SharedTreeParameters.HistogramType.QuantilesGlobal) {
                splitPts = new double[]{1.0, 1.5, 2.0, 2.5, 3.0, 4.0, 5.0, 6.1, 6.2, 6.3, 6.7, 6.8, 6.85};
            }
            Key k = Key.make();
            DKV.put((Keyed)new DHistogram.HistoQuantiles(k, splitPts));
            DHistogram hist = new DHistogram("myhisto", nbins, nbins_cats, isInt, min, maxEx, 0.0, histoType, seed, k, null);
            hist.init();
            int N = 10000000;
            int bin = -1;
            double[] l1 = new double[nbins];
            for (int i2 = 0; i2 < N; ++i2) {
                double col_data = min + (double)i2 / (double)N * (maxEx - min);
                int b = hist.bin(col_data);
                if (b <= bin) continue;
                bin = b;
                Log.info((Object[])new Object[]{"Histogram maps " + col_data + " to bin  : " + hist.bin(col_data)});
                l1[b] = col_data;
            }
            double[] l2 = new double[nbins];
            for (i = 0; i < nbins; ++i) {
                double col_data = hist.binAt(i);
                Log.info((Object[])new Object[]{"Histogram maps bin " + i + " to col_data: " + col_data});
                l2[i] = col_data;
            }
            for (i = 0; i < nbins; ++i) {
                Assert.assertTrue((Math.abs(l1[i] - l2[i]) < 1.0E-6 ? 1 : 0) != 0);
            }
            k.remove();
        }
    }

    @Test
    public void testUniformAdaptiveRange() {
        int nbins;
        int nbins_cats = nbins = 13;
        byte isInt = 0;
        double min = 1.0;
        double maxEx = 6.900000000000001;
        long seed = 1234L;
        SharedTreeModel.SharedTreeParameters.HistogramType histoType = SharedTreeModel.SharedTreeParameters.HistogramType.UniformAdaptive;
        DHistogram hist = new DHistogram("myhisto", nbins, nbins_cats, isInt, min, maxEx, 0.0, histoType, seed, null, null);
        hist.init();
        assert (hist.binAt(0) == min);
        assert (hist.binAt(nbins - 1) < maxEx);
        assert (hist.bin(min) == 0);
        assert (hist.bin(maxEx - 1.0E-15) == nbins - 1);
    }

    @Test
    public void testRandomRange() {
        int nbins;
        int nbins_cats = nbins = 13;
        byte isInt = 0;
        double min = 1.0;
        double maxEx = 6.900000000000001;
        long seed = 1234L;
        SharedTreeModel.SharedTreeParameters.HistogramType histoType = SharedTreeModel.SharedTreeParameters.HistogramType.Random;
        DHistogram hist = new DHistogram("myhisto", nbins, nbins_cats, isInt, min, maxEx, 0.0, histoType, seed, null, null);
        hist.init();
        assert (hist.binAt(0) == min);
        assert (hist.binAt(nbins - 1) < maxEx);
        assert (hist.bin(min) == 0);
        assert (hist.bin(maxEx - 1.0E-15) == nbins - 1);
    }

    @Test
    public void testQuantilesRange() {
        int nbins;
        int nbins_cats = nbins = 13;
        byte isInt = 0;
        double min = 1.0;
        double maxEx = 6.900000000000001;
        long seed = 1234L;
        SharedTreeModel.SharedTreeParameters.HistogramType histoType = SharedTreeModel.SharedTreeParameters.HistogramType.QuantilesGlobal;
        double[] splitPts = new double[]{1.0, 1.5, 2.0, 2.5, 3.0, 4.0, 5.0, 6.1, 6.2, 6.3, 6.7, 6.8, 6.85};
        Key k = Key.make();
        DKV.put((Keyed)new DHistogram.HistoQuantiles(k, splitPts));
        DHistogram hist = new DHistogram("myhisto", nbins, nbins_cats, isInt, min, maxEx, 0.0, histoType, seed, k, null);
        hist.init();
        assert (hist.binAt(0) == min);
        assert (hist.binAt(nbins - 1) < maxEx);
        assert (hist.bin(min) == 0);
        assert (hist.bin(maxEx - 1.0E-15) == nbins - 1);
        k.remove();
    }

    @Test
    public void testShrinking() {
        double[] before = new double[]{0.2, 0.28, 0.31, 0.32, 0.32, 0.4, 0.7, 0.81, 0.84};
        double[] after = ArrayUtils.makeUniqueAndLimitToRange((double[])before, (double)0.3, (double)0.8);
        assert (Arrays.equals(after, new double[]{0.3, 0.31, 0.32, 0.4, 0.7}));
    }

    @Test
    public void testShrinking2() {
        double[] before = new double[]{-0.3, 0.2, 0.28, 0.28, 0.3, 0.3, 0.31, 0.32, 0.32, 0.4, 0.7, 0.7, 0.8, 0.8, 0.81, 0.84};
        double[] after = ArrayUtils.makeUniqueAndLimitToRange((double[])before, (double)0.3, (double)0.8);
        assert (Arrays.equals(after, new double[]{0.3, 0.31, 0.32, 0.4, 0.7}));
    }

    @Test
    public void testShrinking3() {
        double[] before = new double[]{-0.3, 0.2, 0.28, 0.28, 0.3, 0.3, 0.31, 0.32, 0.32, 0.4, 0.7, 0.7, 0.8, 0.8, 0.81, 0.84};
        double[] after = ArrayUtils.makeUniqueAndLimitToRange((double[])before, (double)0.3, (double)0.9);
        assert (Arrays.equals(after, new double[]{0.3, 0.31, 0.32, 0.4, 0.7, 0.8, 0.81, 0.84}));
    }

    @Test
    public void testShrinking4() {
        double[] before = new double[]{0.31, 0.32, 0.32, 0.4, 0.7, 0.7};
        double[] after = ArrayUtils.makeUniqueAndLimitToRange((double[])before, (double)0.3, (double)0.9);
        assert (Arrays.equals(after, new double[]{0.3, 0.31, 0.32, 0.4, 0.7}));
    }

    @Test
    public void testShrinking5() {
        double[] before = new double[]{0.3, 0.31, 0.32, 0.4, 0.7};
        double[] after = ArrayUtils.limitToRange((double[])before, (double)0.31, (double)0.9);
        assert (Arrays.equals(after, new double[]{0.31, 0.32, 0.4, 0.7}));
    }

    @Test
    public void testShrinking6() {
        double[] before = new double[]{0.3, 0.31, 0.32, 0.4, 0.7};
        double[] after = ArrayUtils.limitToRange((double[])before, (double)0.305, (double)0.9);
        assert (Arrays.equals(after, new double[]{0.3, 0.31, 0.32, 0.4, 0.7}));
    }

    @Test
    public void testShrinking7() {
        double[] before = new double[]{0.3, 0.31, 0.32, 0.4, 0.7};
        double[] after = ArrayUtils.limitToRange((double[])before, (double)0.305, (double)0.699);
        assert (Arrays.equals(after, new double[]{0.3, 0.31, 0.32, 0.4}));
    }

    @Test
    public void testShrinking8() {
        double[] before = new double[]{0.3, 0.31, 0.32, 0.4, 0.7};
        double[] after = ArrayUtils.limitToRange((double[])before, (double)0.7, (double)0.9);
        assert (Arrays.equals(after, new double[]{0.7}));
    }

    @Test
    public void testShrinking9() {
        double[] before = new double[]{0.3, 0.31, 0.32, 0.4, 0.7};
        double[] after = ArrayUtils.limitToRange((double[])before, (double)0.8, (double)0.9);
        assert (Arrays.equals(after, new double[]{0.7}));
    }

    @Test
    public void testPadding() {
        double[] before = new double[]{0.3, 0.31, 0.32, 0.4, 0.7};
        double[] after = ArrayUtils.padUniformly((double[])before, (int)9);
        assert (Arrays.equals(after, new double[]{0.3, 0.305, 0.31, 0.315, 0.32, 0.36, 0.4, 0.55, 0.7}));
    }

    @Test
    public void testPadding2() {
        double[] before = new double[]{0.3, 0.31, 0.32, 0.4, 0.7};
        double[] after = ArrayUtils.padUniformly((double[])before, (int)10);
        assert (Arrays.equals(after, new double[]{0.3, 0.3025, 0.3075, 0.31, 0.315, 0.32, 0.36, 0.4, 0.55, 0.7}));
    }

    @Test
    public void testPadding3() {
        double[] before = new double[]{0.3, 0.31, 0.32, 0.4, 0.7};
        double[] after = ArrayUtils.padUniformly((double[])before, (int)8);
        assert (Arrays.equals(after, new double[]{0.3, 0.305, 0.31, 0.315, 0.32, 0.36, 0.4, 0.7}));
    }

    @Test
    public void binarySearch() {
        int R = 1000000;
        for (int N : new int[]{20, 50, 100}) {
            double[] vals = new double[N];
            for (int i = 0; i < N; ++i) {
                vals[i] = (double)i * 1.0 / (double)N;
            }
            double[] pts = new double[N];
            Random rnd = RandomUtils.getRNG((long[])new long[]{123L});
            for (int i = 0; i < N; ++i) {
                pts[i] = (double)rnd.nextInt(N) * 1.0 / (double)N;
            }
            long sum = 0L;
            for (int r = 0; r < R; ++r) {
                sum += (long)Arrays.binarySearch(vals, pts[r % N]);
            }
            long start = System.currentTimeMillis();
            for (int r = 0; r < R; ++r) {
                sum += (long)Arrays.binarySearch(vals, pts[r % N]);
            }
            long done = System.currentTimeMillis();
            Log.info((Object[])new Object[]{"N=" + N + " Sum:" + sum + " Time: " + PrettyPrint.msecs((long)(done - start), (boolean)true)});
        }
    }

    @Test
    public void linearSearch() {
        int R = 1000000;
        for (int N : new int[]{20, 50, 100}) {
            double[] vals = new double[N];
            for (int i = 0; i < N; ++i) {
                vals[i] = (double)i * 1.0 / (double)N;
            }
            double[] pts = new double[N];
            Random rnd = RandomUtils.getRNG((long[])new long[]{123L});
            for (int i = 0; i < N; ++i) {
                pts[i] = (double)rnd.nextInt(N) * 1.0 / (double)N;
            }
            long sum = 0L;
            for (int r = 0; r < R; ++r) {
                sum += (long)ArrayUtils.linearSearch((double[])vals, (double)pts[r % N]);
            }
            long start = System.currentTimeMillis();
            for (int r = 0; r < R; ++r) {
                sum += (long)ArrayUtils.linearSearch((double[])vals, (double)pts[r % N]);
            }
            long done = System.currentTimeMillis();
            Log.info((Object[])new Object[]{"N=" + N + " Sum:" + sum + " Time: " + PrettyPrint.msecs((long)(done - start), (boolean)true)});
        }
    }

    public static class Filler
    extends H2O.H2OCountedCompleter<Filler> {
        private final long _seed;
        private final Histo _histo;

        Filler(Histo histo, long seed) {
            this._seed = seed;
            this._histo = histo;
        }

        public void compute2() {
            Random rng = new Random(this._seed);
            for (int loop = 0; loop < 100; ++loop) {
                for (int b = 0; b < this._histo._sumsD.length; ++b) {
                    double val = rng.nextDouble();
                    this._histo.incrDouble(b, val);
                    this._histo.incrFloat(b, val);
                }
            }
            this.tryComplete();
        }
    }

    private class Histo {
        public double[] _sumsD;
        public double[] _sumsF;

        Histo(int len) {
            this._sumsD = new double[len];
            this._sumsF = new double[len];
        }

        public void incrDouble(int b, double y) {
            AtomicUtils.DoubleArray.add((double[])this._sumsD, (int)b, (double)y);
        }

        public void incrFloat(int b, double y) {
            AtomicUtils.DoubleArray.add((double[])this._sumsF, (int)b, (double)((float)y));
        }
    }
}

