/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.tree.DHistogram;
import hex.tree.SharedTreeModel;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import water.DKV;
import water.Key;
import water.Keyed;
import water.Scope;
import water.TestUtil;

public class DHistogramTest
extends TestUtil {
    @BeforeClass
    public static void setup() {
        DHistogramTest.stall_till_cloudsize((int)1);
    }

    @Test
    public void showBinarySearchFailsOnNegativeZero() {
        double val = -0.0;
        double[] ary = new double[]{0.0};
        Assert.assertTrue((ary[0] == -0.0 ? 1 : 0) != 0);
        int pos = Arrays.binarySearch(ary, -0.0);
        Assert.assertEquals((long)-1L, (long)pos);
        Assert.assertNotEquals((long)Double.doubleToLongBits(-0.0), (long)Double.doubleToLongBits(0.0));
    }

    @Test
    public void initCachesZeroPosition() {
        Scope.enter();
        try {
            DHistogram.HistoQuantiles hq = new DHistogram.HistoQuantiles(Key.make(), new double[]{-1.0, -0.3, -0.0, 1.0, 1.2, 1.8});
            DKV.put((Keyed)hq);
            Scope.track_generic((Keyed)hq);
            DHistogram histo = new DHistogram("test", 20, 1024, 1, -1.0, 2.0, -0.001, SharedTreeModel.SharedTreeParameters.HistogramType.QuantilesGlobal, 42L, hq._key, null);
            histo.init();
            Assert.assertEquals((long)-3L, (long)Arrays.binarySearch(histo._splitPts, -0.0));
            Assert.assertEquals((long)2L, (long)Arrays.binarySearch(histo._splitPts, 0.0));
            Assert.assertEquals((long)2L, (long)histo._zeroSplitPntPos);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void findBinForNegativeZero() {
        Scope.enter();
        try {
            DHistogram.HistoQuantiles hq = new DHistogram.HistoQuantiles(Key.make(), new double[]{-1.0, -0.0, 1.0});
            DKV.put((Keyed)hq);
            Scope.track_generic((Keyed)hq);
            DHistogram histo = new DHistogram("test", 20, 1024, 1, -1.0, 2.0, -0.001, SharedTreeModel.SharedTreeParameters.HistogramType.QuantilesGlobal, 42L, hq._key, null);
            histo.init();
            int bin = histo.bin(-0.0);
            Assert.assertEquals((long)1L, (long)bin);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }
}

