/*
 * Decompiled with CFR 0.152.
 */
package hex.svd;

import hex.DataInfo;
import hex.SplitFrame;
import hex.svd.SVD;
import hex.svd.SVDModel;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import water.DKV;
import water.Iced;
import water.Key;
import water.Keyed;
import water.Scope;
import water.TestUtil;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.FrameUtils;
import water.util.Log;

public class SVDTest
extends TestUtil {
    public static final double TOLERANCE = 1.0E-6;

    @BeforeClass
    public static void setup() {
        SVDTest.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArrests() throws InterruptedException, ExecutionException {
        double[] d_expected = new double[]{1419.0613951, 194.82584611, 45.66133763, 18.06955662};
        double[][] v_expected = SVDTest.ard((double[][])new double[][]{SVDTest.ard((double[])new double[]{-0.04239181, 0.01616262, -0.06588426, 0.99679535}), SVDTest.ard((double[])new double[]{-0.94395706, 0.3206858, 0.0665517, -0.04094568}), SVDTest.ard((double[])new double[]{-0.30842767, -0.93845891, 0.15496743, 0.01234261}), SVDTest.ard((double[])new double[]{-0.10963744, -0.12725666, -0.98347101, -0.06760284})});
        SVDModel model = null;
        Frame train = null;
        try {
            train = SVDTest.parse_test_file((Key)Key.make((String)"arrests.hex"), (String)"smalldata/pca_test/USArrests.csv");
            SVDModel.SVDParameters parms = new SVDModel.SVDParameters();
            parms._train = train._key;
            parms._nv = 4;
            parms._seed = 1234L;
            parms._only_v = false;
            parms._transform = DataInfo.TransformType.NONE;
            parms._svd_method = SVDModel.SVDParameters.Method.GramSVD;
            parms._save_v_frame = false;
            model = (SVDModel)new SVD(parms).trainModel().get();
            TestUtil.checkEigvec((double[][])v_expected, (double[][])((SVDModel.SVDOutput)model._output)._v, (double)1.0E-6);
            Assert.assertArrayEquals((double[])d_expected, (double[])((SVDModel.SVDOutput)model._output)._d, (double)1.0E-6);
        }
        finally {
            if (train != null) {
                train.delete();
            }
            if (model != null) {
                model.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArrestsOnlyV() throws InterruptedException, ExecutionException {
        double[][] svec = SVDTest.ard((double[][])new double[][]{SVDTest.ard((double[])new double[]{-0.04239181, 0.01616262, -0.06588426, 0.99679535}), SVDTest.ard((double[])new double[]{-0.94395706, 0.3206858, 0.0665517, -0.04094568}), SVDTest.ard((double[])new double[]{-0.30842767, -0.93845891, 0.15496743, 0.01234261}), SVDTest.ard((double[])new double[]{-0.10963744, -0.12725666, -0.98347101, -0.06760284})});
        SVDModel model = null;
        Frame train = null;
        try {
            train = SVDTest.parse_test_file((Key)Key.make((String)"arrests.hex"), (String)"smalldata/pca_test/USArrests.csv");
            SVDModel.SVDParameters parms = new SVDModel.SVDParameters();
            parms._train = train._key;
            parms._nv = 4;
            parms._seed = 1234L;
            parms._only_v = true;
            parms._transform = DataInfo.TransformType.NONE;
            parms._svd_method = SVDModel.SVDParameters.Method.Power;
            parms._save_v_frame = false;
            model = (SVDModel)new SVD(parms).trainModel().get();
            TestUtil.checkEigvec((double[][])svec, (double[][])((SVDModel.SVDOutput)model._output)._v, (double)1.0E-6);
            assert (((SVDModel.SVDOutput)model._output)._d == null);
        }
        finally {
            if (train != null) {
                train.delete();
            }
            if (model != null) {
                model.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArrestsScoring() throws InterruptedException, ExecutionException {
        double[] stddev = new double[]{202.7230564, 27.8322637, 6.5230482, 2.5813652};
        double[][] eigvec = SVDTest.ard((double[][])new double[][]{SVDTest.ard((double[])new double[]{-0.04239181, 0.01616262, -0.06588426, 0.99679535}), SVDTest.ard((double[])new double[]{-0.94395706, 0.3206858, 0.0665517, -0.04094568}), SVDTest.ard((double[])new double[]{-0.30842767, -0.93845891, 0.15496743, 0.01234261}), SVDTest.ard((double[])new double[]{-0.10963744, -0.12725666, -0.98347101, -0.06760284})});
        SVDModel model = null;
        Frame train = null;
        Frame score = null;
        Frame scoreR = null;
        try {
            train = SVDTest.parse_test_file((Key)Key.make((String)"arrests.hex"), (String)"smalldata/pca_test/USArrests.csv");
            SVDModel.SVDParameters parms = new SVDModel.SVDParameters();
            parms._train = train._key;
            parms._nv = 4;
            parms._transform = DataInfo.TransformType.NONE;
            parms._svd_method = SVDModel.SVDParameters.Method.Power;
            parms._only_v = false;
            parms._keep_u = false;
            parms._save_v_frame = false;
            model = (SVDModel)new SVD(parms).trainModel().get();
            boolean[] flippedEig = TestUtil.checkEigvec((double[][])eigvec, (double[][])((SVDModel.SVDOutput)model._output)._v, (double)1.0E-6);
            score = model.score(train);
            scoreR = SVDTest.parse_test_file((Key)Key.make((String)"scoreR.hex"), (String)"smalldata/pca_test/USArrests_PCAscore.csv");
            TestUtil.checkProjection((Frame)scoreR, (Frame)score, (double)1.0E-6, (boolean[])flippedEig);
        }
        finally {
            if (train != null) {
                train.delete();
            }
            if (score != null) {
                score.delete();
            }
            if (scoreR != null) {
                scoreR.delete();
            }
            if (model != null) {
                model.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testArrestsMissing() throws InterruptedException, ExecutionException {
        SVDModel model = null;
        SVDModel.SVDParameters parms = null;
        Frame train = null;
        long seed = 1234L;
        for (double missing_fraction : new double[]{0.0, 0.1, 0.25, 0.5, 0.75, 0.9}) {
            try {
                Scope.enter();
                train = SVDTest.parse_test_file((Key)Key.make((String)"arrests.hex"), (String)"smalldata/pca_test/USArrests.csv");
                if (missing_fraction > 0.0) {
                    Frame frtmp = new Frame(Key.make(), train.names(), train.vecs());
                    DKV.put((Key)frtmp._key, (Iced)frtmp);
                    FrameUtils.MissingInserter j = new FrameUtils.MissingInserter(frtmp._key, seed, missing_fraction);
                    j.execImpl().get();
                    DKV.remove((Key)frtmp._key);
                }
                parms = new SVDModel.SVDParameters();
                parms._train = train._key;
                parms._nv = train.numCols();
                parms._transform = DataInfo.TransformType.STANDARDIZE;
                parms._svd_method = SVDModel.SVDParameters.Method.Power;
                parms._max_iterations = 1000;
                parms._seed = seed;
                parms._save_v_frame = false;
                model = (SVDModel)new SVD(parms).trainModel().get();
                Log.info((Object[])new Object[]{100.0 * missing_fraction + "% missing values: Singular values = " + Arrays.toString(((SVDModel.SVDOutput)model._output)._d)});
                Scope.exit((Key[])new Key[0]);
            }
            finally {
                if (train != null) {
                    train.delete();
                }
                if (model != null) {
                    model.delete();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArrestsProb() throws InterruptedException, ExecutionException {
        double[] d_expected = new double[]{11.024148, 6.964086, 4.179904, 2.915146};
        double[][] v_expected = SVDTest.ard((double[][])new double[][]{SVDTest.ard((double[])new double[]{-0.5358995, 0.4181809, -0.3412327, 0.6492278}), SVDTest.ard((double[])new double[]{-0.5831836, 0.1879856, -0.2681484, -0.74340748}), SVDTest.ard((double[])new double[]{-0.2781909, -0.8728062, -0.3780158, 0.13387773}), SVDTest.ard((double[])new double[]{-0.5434321, -0.1673186, 0.8177779, 0.08902432})});
        SVDModel model = null;
        Frame train = null;
        Frame score = null;
        try {
            train = SVDTest.parse_test_file((Key)Key.make((String)"arrests.hex"), (String)"smalldata/pca_test/USArrests.csv");
            SVDModel.SVDParameters parms = new SVDModel.SVDParameters();
            parms._train = train._key;
            parms._nv = 4;
            parms._keep_u = true;
            parms._transform = DataInfo.TransformType.STANDARDIZE;
            parms._svd_method = SVDModel.SVDParameters.Method.Randomized;
            parms._max_iterations = 4;
            parms._save_v_frame = false;
            model = (SVDModel)new SVD(parms).trainModel().get();
            Assert.assertArrayEquals((double[])d_expected, (double[])((SVDModel.SVDOutput)model._output)._d, (double)1.0E-6);
            TestUtil.checkEigvec((double[][])v_expected, (double[][])((SVDModel.SVDOutput)model._output)._v, (double)1.0E-6);
            score = model.score(train);
        }
        finally {
            if (train != null) {
                train.delete();
            }
            if (score != null) {
                score.delete();
            }
            if (model != null) {
                model.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIrisGram() throws InterruptedException, ExecutionException {
        double[] d_expected = new double[]{96.2090445, 19.0425654, 7.2250378, 3.1636131, 1.8816739, 1.1451307, 0.5820806};
        double[][] v_expected = SVDTest.ard((double[][])new double[][]{SVDTest.ard((double[])new double[]{-0.03169051, -0.3230586, 0.185100382, -0.12336685, -0.14867156, 0.75932119, -0.496462912}), SVDTest.ard((double[])new double[]{-0.04289677, 0.04037565, -0.780961964, 0.19727933, 0.07251338, -0.12216945, -0.572298338}), SVDTest.ard((double[])new double[]{-0.05019689, 0.16836717, 0.551432201, -0.07122329, 0.08454116, -0.4832701, -0.647522462}), SVDTest.ard((double[])new double[]{-0.74915107, -0.2662942, -0.101102186, -0.48920057, 0.3245846, -0.09176909, 0.067412858}), SVDTest.ard((double[])new double[]{-0.37877011, -0.5063606, 0.142219195, 0.69081642, -0.26312992, -0.17811871, 0.041411296}), SVDTest.ard((double[])new double[]{-0.51177078, 0.65945159, -0.005079934, 0.048819, -0.52128288, 0.17038367, 0.006223427}), SVDTest.ard((double[])new double[]{-0.16742875, 0.32166036, 0.145893901, 0.47102115, 0.72052968, 0.32523458, 0.020389463})});
        SVDModel model = null;
        Frame train = null;
        try {
            train = SVDTest.parse_test_file((Key)Key.make((String)"iris.hex"), (String)"smalldata/iris/iris_wheader.csv");
            SVDModel.SVDParameters parms = new SVDModel.SVDParameters();
            parms._train = train._key;
            parms._nv = 7;
            parms._use_all_factor_levels = true;
            parms._keep_u = true;
            parms._transform = DataInfo.TransformType.NONE;
            parms._svd_method = SVDModel.SVDParameters.Method.GramSVD;
            parms._save_v_frame = false;
            model = (SVDModel)new SVD(parms).trainModel().get();
            TestUtil.checkEigvec((double[][])v_expected, (double[][])((SVDModel.SVDOutput)model._output)._v, (double)1.0E-6);
            Assert.assertArrayEquals((double[])d_expected, (double[])((SVDModel.SVDOutput)model._output)._d, (double)1.0E-6);
        }
        finally {
            if (train != null) {
                train.delete();
            }
            if (model != null) {
                model.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIrisSVDScore() throws InterruptedException, ExecutionException {
        double[] d_expected = new double[]{96.2090445, 19.0425654, 7.2250378, 3.1636131, 1.8816739, 1.1451307, 0.5820806};
        double[][] v_expected = SVDTest.ard((double[][])new double[][]{SVDTest.ard((double[])new double[]{-0.03169051, -0.3230586, 0.185100382, -0.12336685, -0.14867156, 0.75932119, -0.496462912}), SVDTest.ard((double[])new double[]{-0.04289677, 0.04037565, -0.780961964, 0.19727933, 0.07251338, -0.12216945, -0.572298338}), SVDTest.ard((double[])new double[]{-0.05019689, 0.16836717, 0.551432201, -0.07122329, 0.08454116, -0.4832701, -0.647522462}), SVDTest.ard((double[])new double[]{-0.74915107, -0.2662942, -0.101102186, -0.48920057, 0.3245846, -0.09176909, 0.067412858}), SVDTest.ard((double[])new double[]{-0.37877011, -0.5063606, 0.142219195, 0.69081642, -0.26312992, -0.17811871, 0.041411296}), SVDTest.ard((double[])new double[]{-0.51177078, 0.65945159, -0.005079934, 0.048819, -0.52128288, 0.17038367, 0.006223427}), SVDTest.ard((double[])new double[]{-0.16742875, 0.32166036, 0.145893901, 0.47102115, 0.72052968, 0.32523458, 0.020389463})});
        SVDModel model = null;
        Frame train = null;
        Frame score = null;
        try {
            train = SVDTest.parse_test_file((Key)Key.make((String)"iris.hex"), (String)"smalldata/iris/iris_wheader.csv");
            SVDModel.SVDParameters parms = new SVDModel.SVDParameters();
            parms._train = train._key;
            parms._nv = 7;
            parms._use_all_factor_levels = true;
            parms._transform = DataInfo.TransformType.NONE;
            parms._svd_method = SVDModel.SVDParameters.Method.Power;
            parms._save_v_frame = false;
            model = (SVDModel)new SVD(parms).trainModel().get();
            TestUtil.checkEigvec((double[][])v_expected, (double[][])((SVDModel.SVDOutput)model._output)._v, (double)1.0E-6);
            Assert.assertArrayEquals((double[])d_expected, (double[])((SVDModel.SVDOutput)model._output)._d, (double)1.0E-6);
            score = model.score(train);
        }
        finally {
            if (train != null) {
                train.delete();
            }
            if (score != null) {
                score.delete();
            }
            if (model != null) {
                model.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIrisSplitScoring() throws InterruptedException, ExecutionException {
        SVDModel model = null;
        Frame fr = null;
        Frame fr2 = null;
        Frame tr = null;
        Frame te = null;
        try {
            fr = SVDTest.parse_test_file((String)"smalldata/iris/iris_wheader.csv");
            SplitFrame sf = new SplitFrame(fr, new double[]{0.5, 0.5}, new Key[]{Key.make((String)"train.hex"), Key.make((String)"test.hex")});
            sf.exec().get();
            Key[] ksplits = sf._destination_frames;
            tr = (Frame)DKV.get((Key)ksplits[0]).get();
            te = (Frame)DKV.get((Key)ksplits[1]).get();
            SVDModel.SVDParameters parms = new SVDModel.SVDParameters();
            parms._train = ksplits[0];
            parms._valid = ksplits[1];
            parms._nv = 4;
            parms._max_iterations = 1000;
            parms._svd_method = SVDModel.SVDParameters.Method.Power;
            parms._save_v_frame = false;
            model = (SVDModel)new SVD(parms).trainModel().get();
            fr2 = model.score(te);
            Assert.assertTrue((boolean)model.testJavaScoring(te, fr2, 1.0E-5));
        }
        finally {
            if (fr != null) {
                fr.delete();
            }
            if (fr2 != null) {
                fr2.delete();
            }
            if (tr != null) {
                tr.delete();
            }
            if (te != null) {
                te.delete();
            }
            if (model != null) {
                model.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIrisProb() throws InterruptedException, ExecutionException {
        double[] d_expected = new double[]{96.2090445, 19.0425654, 7.2250378, 3.1636131, 1.8816739, 1.1451307, 0.5820806};
        double[][] v_expected = SVDTest.ard((double[][])new double[][]{SVDTest.ard((double[])new double[]{-0.03169051, -0.3230586, 0.185100382, -0.12336685, -0.14867156, 0.75932119, -0.496462912}), SVDTest.ard((double[])new double[]{-0.04289677, 0.04037565, -0.780961964, 0.19727933, 0.07251338, -0.12216945, -0.572298338}), SVDTest.ard((double[])new double[]{-0.05019689, 0.16836717, 0.551432201, -0.07122329, 0.08454116, -0.4832701, -0.647522462}), SVDTest.ard((double[])new double[]{-0.74915107, -0.2662942, -0.101102186, -0.48920057, 0.3245846, -0.09176909, 0.067412858}), SVDTest.ard((double[])new double[]{-0.37877011, -0.5063606, 0.142219195, 0.69081642, -0.26312992, -0.17811871, 0.041411296}), SVDTest.ard((double[])new double[]{-0.51177078, 0.65945159, -0.005079934, 0.048819, -0.52128288, 0.17038367, 0.006223427}), SVDTest.ard((double[])new double[]{-0.16742875, 0.32166036, 0.145893901, 0.47102115, 0.72052968, 0.32523458, 0.020389463})});
        SVDModel model = null;
        Frame train = null;
        Frame score = null;
        try {
            train = SVDTest.parse_test_file((Key)Key.make((String)"iris.hex"), (String)"smalldata/iris/iris_wheader.csv");
            SVDModel.SVDParameters parms = new SVDModel.SVDParameters();
            parms._train = train._key;
            parms._nv = 7;
            parms._use_all_factor_levels = true;
            parms._keep_u = false;
            parms._transform = DataInfo.TransformType.NONE;
            parms._svd_method = SVDModel.SVDParameters.Method.Randomized;
            parms._max_iterations = 7;
            parms._save_v_frame = false;
            model = (SVDModel)new SVD(parms).trainModel().get();
            TestUtil.checkEigvec((double[][])v_expected, (double[][])((SVDModel.SVDOutput)model._output)._v, (double)1.0E-6);
            Assert.assertArrayEquals((double[])d_expected, (double[])((SVDModel.SVDOutput)model._output)._d, (double)1.0E-6);
            score = model.score(train);
        }
        finally {
            if (train != null) {
                train.delete();
            }
            if (score != null) {
                score.delete();
            }
            if (model != null) {
                model.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBenignProb() throws InterruptedException, ExecutionException {
        double[] d_expected = new double[]{450.809529, 212.934956, 155.60826, 64.528823, 52.334624};
        SVDModel model = null;
        Frame train = null;
        Frame score = null;
        try {
            train = SVDTest.parse_test_file((Key)Key.make((String)"benign.hex"), (String)"smalldata/logreg/benign.csv");
            SVDModel.SVDParameters parms = new SVDModel.SVDParameters();
            parms._train = train._key;
            parms._nv = 5;
            parms._keep_u = true;
            parms._transform = DataInfo.TransformType.DEMEAN;
            parms._svd_method = SVDModel.SVDParameters.Method.Randomized;
            parms._impute_missing = true;
            parms._max_iterations = 20;
            parms._save_v_frame = false;
            model = (SVDModel)new SVD(parms).trainModel().get();
            score = model.score(train);
        }
        finally {
            if (train != null) {
                train.delete();
            }
            if (score != null) {
                score.delete();
            }
            if (model != null) {
                model.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProstateMissingProb() throws InterruptedException, ExecutionException {
        long seed = 1234L;
        Frame train = null;
        Frame score = null;
        SVDModel model = null;
        try {
            train = SVDTest.parse_test_file((Key)Key.make((String)"prostate.hex"), (String)"smalldata/prostate/prostate_cat.csv");
            Frame frtmp = new Frame(Key.make(), train.names(), train.vecs());
            DKV.put((Key)frtmp._key, (Iced)frtmp);
            FrameUtils.MissingInserter j = new FrameUtils.MissingInserter(frtmp._key, seed, 0.25);
            j.execImpl().get();
            DKV.remove((Key)frtmp._key);
            SVDModel.SVDParameters parms = new SVDModel.SVDParameters();
            parms._train = train._key;
            parms._nv = 8;
            parms._only_v = false;
            parms._keep_u = true;
            parms._svd_method = SVDModel.SVDParameters.Method.Randomized;
            parms._impute_missing = true;
            parms._max_iterations = 20;
            parms._save_v_frame = false;
            model = (SVDModel)new SVD(parms).trainModel().get();
            score = model.score(train);
        }
        finally {
            if (train != null) {
                train.delete();
            }
            if (score != null) {
                score.delete();
            }
            if (model != null) {
                model.delete();
            }
        }
    }

    @Test
    public void testIVVSum() {
        double[][] res = SVDTest.ard((double[][])new double[][]{SVDTest.ard((double[])new double[]{1.0, 2.0, 3.0}), SVDTest.ard((double[])new double[]{2.0, 5.0, 6.0}), SVDTest.ard((double[])new double[]{3.0, 6.0, 9.0})});
        double[] v = new double[]{7.0, 8.0, 9.0};
        double[][] xvv = SVDTest.ard((double[][])new double[][]{SVDTest.ard((double[])new double[]{-48.0, -54.0, -60.0}), SVDTest.ard((double[])new double[]{-54.0, -59.0, -66.0}), SVDTest.ard((double[])new double[]{-60.0, -66.0, -72.0})});
        SVD.updateIVVSum((double[][])res, (double[])v);
        Assert.assertArrayEquals((Object[])xvv, (Object[])res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCatOnlyPUBDEV3988() throws InterruptedException, ExecutionException {
        SVDModel model = null;
        Frame train = null;
        Frame score = null;
        try {
            train = SVDTest.parse_test_file((Key)Key.make((String)"prostate_cat.hex"), (String)"smalldata/prostate/prostate_cat.csv");
            for (int i = train.numCols() - 1; i > 0; --i) {
                Vec v = train.vec(i);
                if (v.get_type() == 4) continue;
                train.remove(i);
                Vec.remove((Key)v._key);
            }
            DKV.put((Keyed)train);
            SVDModel.SVDParameters parms = new SVDModel.SVDParameters();
            parms._train = train._key;
            parms._nv = 2;
            parms._only_v = false;
            parms._keep_u = true;
            parms._svd_method = SVDModel.SVDParameters.Method.Randomized;
            parms._impute_missing = true;
            parms._max_iterations = 20;
            parms._save_v_frame = false;
            model = (SVDModel)new SVD(parms).trainModel().get();
            score = model.score(train);
            Assert.assertTrue((boolean)model.testJavaScoring(train, score, 1.0E-6));
        }
        finally {
            if (train != null) {
                train.delete();
            }
            if (score != null) {
                score.delete();
            }
            if (model != null) {
                model.delete();
            }
        }
    }
}

