/*
 * Decompiled with CFR 0.152.
 */
package hex.splitframe;

import hex.splitframe.ShuffleSplitFrame;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import water.Key;
import water.MRTask;
import water.TestUtil;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.FrameTestUtil;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.util.ArrayUtils;

public class ShuffleSplitFrameTest
extends TestUtil {
    @BeforeClass
    public static void setup() {
        ShuffleSplitFrameTest.stall_till_cloudsize((int)1);
    }

    @Test
    public void testShuffleSplitOnStringColumn() {
        long[] chunkLayout = ShuffleSplitFrameTest.ar((long[])new long[]{2L, 2L, 3L});
        Object[][] data = ShuffleSplitFrameTest.ar((String[][])new String[][]{ShuffleSplitFrameTest.ar((String[])new String[]{"A", "B"}), ShuffleSplitFrameTest.ar((String[])new String[]{null, "C"}), ShuffleSplitFrameTest.ar((String[])new String[]{"D", "E", "F"})});
        Frame f = FrameTestUtil.createFrame((String)"ShuffleSplitTest1.hex", (long[])chunkLayout, (String[][])data);
        ShuffleSplitFrameTest.testScenario(f, (String[])ArrayUtils.flat((Object[][])data));
        chunkLayout = ShuffleSplitFrameTest.ar((long[])new long[]{3L, 3L});
        data = ShuffleSplitFrameTest.ar((String[][])new String[][]{ShuffleSplitFrameTest.ar((String[])new String[]{"A", null, "B"}), ShuffleSplitFrameTest.ar((String[])new String[]{"C", "D", "E"})});
        f = FrameTestUtil.createFrame((String)"test2.hex", (long[])chunkLayout, (String[][])data);
        ShuffleSplitFrameTest.testScenario(f, (String[])ArrayUtils.flat((Object[][])data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShuffleSplitWithMultipleColumns() {
        long[] chunkLayout = ShuffleSplitFrameTest.ar((long[])new long[]{2L, 2L, 3L});
        Object[][] data = ShuffleSplitFrameTest.ar((String[][])new String[][]{ShuffleSplitFrameTest.ar((String[])new String[]{"1", "2"}), ShuffleSplitFrameTest.ar((String[])new String[]{null, "3"}), ShuffleSplitFrameTest.ar((String[])new String[]{"4", "5", "6"})});
        Frame f = null;
        Frame tmpFrm = FrameTestUtil.createFrame((String)"ShuffleSplitMCTest1.hex", (long[])chunkLayout, (String[][])data);
        try {
            f = new MRTask(){

                public void map(Chunk[] cs, NewChunk[] ncs) {
                    for (int i = 0; i < cs[0]._len; ++i) {
                        BufferedString bs = cs[0].atStr(new BufferedString(), i);
                        int val = bs == null ? 0 : Integer.parseInt(bs.toString());
                        ncs[0].addStr((Object)bs);
                        ncs[1].addNum((double)val);
                        ncs[2].addNum((double)i);
                        ncs[3].addUUID((long)i, (long)val);
                    }
                }
            }.doAll(new byte[]{2, 3, 3, 1}, tmpFrm).outputFrame();
        }
        finally {
            tmpFrm.delete();
        }
        ShuffleSplitFrameTest.testScenario(f, (String[])ArrayUtils.flat((Object[][])data), new MRTask(){

            public void map(Chunk[] cs) {
                for (int i = 0; i < cs[0]._len; ++i) {
                    BufferedString bs = cs[0].atStr(new BufferedString(), i);
                    int expectedVal = bs == null ? 0 : Integer.parseInt(bs.toString());
                    int expectedIndex = (int)cs[2].atd(i);
                    Assert.assertEquals((double)expectedVal, (double)cs[1].atd(i), (double)1.0E-5);
                    Assert.assertEquals((long)expectedIndex, (long)((int)cs[3].at16l(i)));
                    Assert.assertEquals((long)expectedVal, (long)((int)cs[3].at16h(i)));
                }
            }
        });
    }

    static void testScenario(Frame f, String[] expValues) {
        ShuffleSplitFrameTest.testScenario(f, expValues, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void testScenario(Frame f, String[] expValues, MRTask chunkAssertions) {
        double[] ratios = ShuffleSplitFrameTest.ard((double[])new double[]{0.5, 0.5});
        Key[] keys = (Key[])ShuffleSplitFrameTest.aro((Object[])new Key[]{Key.make((String)"test.hex"), Key.make((String)"train.hex")});
        Frame[] splits = null;
        try {
            splits = ShuffleSplitFrame.shuffleSplitFrame((Frame)f, (Key[])keys, (double[])ratios, (long)42L);
            Assert.assertEquals((String)"Expecting 2 splits", (long)2L, (long)splits.length);
            Object[] values = ArrayUtils.append((String[])FrameTestUtil.collectS((Vec)splits[0].vec(0)), (String[])FrameTestUtil.collectS((Vec)splits[1].vec(0)));
            Arrays.sort(ShuffleSplitFrameTest.replaceNulls(expValues));
            Arrays.sort(ShuffleSplitFrameTest.replaceNulls((String[])values));
            Assert.assertArrayEquals((String)"Values should match", (Object[])expValues, (Object[])values);
            if (chunkAssertions != null) {
                for (Frame s : splits) {
                    chunkAssertions.doAll(s).getResult();
                }
            }
        }
        finally {
            f.delete();
            if (splits != null) {
                for (Frame s : splits) {
                    s.delete();
                }
            }
        }
    }

    private static String[] replaceNulls(String[] ary) {
        return ShuffleSplitFrameTest.replaceNulls(ary, "_NA_#");
    }

    private static String[] replaceNulls(String[] ary, String replacement) {
        for (int i = 0; i < ary.length; ++i) {
            if (ary[i] != null) continue;
            ary[i] = replacement;
        }
        return ary;
    }
}

