/*
 * Decompiled with CFR 0.152.
 */
package hex.quantile;

import hex.quantile.Quantile;
import hex.quantile.QuantileModel;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import water.Job;
import water.TestUtil;
import water.fvec.Frame;
import water.util.ArrayUtils;

public class QuantileTest
extends TestUtil {
    @BeforeClass
    public static void setup() {
        QuantileTest.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIris() {
        QuantileModel kmm = null;
        Frame fr = null;
        try {
            long start = System.currentTimeMillis();
            System.out.println("Start Parse");
            fr = QuantileTest.parse_test_file((String)"smalldata/iris/iris_wheader.csv");
            System.out.println("Done Parse: " + (System.currentTimeMillis() - start));
            QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
            parms._train = fr._key;
            Job job = new Quantile(parms).trainModel();
            kmm = (QuantileModel)job.get();
            job.remove();
        }
        finally {
            if (fr != null) {
                fr.remove();
            }
            if (kmm != null) {
                kmm.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllNAS() {
        QuantileModel kmm = null;
        Frame fr = null;
        try {
            fr = ArrayUtils.frame((double[][])new double[][]{{Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}, {Double.NaN}});
            QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
            parms._train = fr._key;
            Job job = new Quantile(parms).trainModel();
            kmm = (QuantileModel)job.get();
            job.remove();
            for (int i = 0; i < 11; ++i) {
                Assert.assertTrue((boolean)Double.isNaN(((QuantileModel.QuantileOutput)kmm._output)._quantiles[0][i]));
            }
        }
        finally {
            if (fr != null) {
                fr.remove();
            }
            if (kmm != null) {
                kmm.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInts() {
        QuantileModel kmm = null;
        Frame fr = null;
        try {
            fr = ArrayUtils.frame((double[][])new double[][]{{0.0}, {0.0}, {0.0}, {0.0}, {0.0}, {0.0}, {0.0}, {0.0}, {0.0}, {0.0}, {1.0}, {1.0}, {1.0}, {1.0}, {1.0}, {1.0}, {1.0}, {1.0}, {1.0}, {1.0}, {2.0}, {2.0}, {2.0}, {2.0}, {2.0}, {2.0}, {2.0}, {2.0}, {2.0}, {2.0}});
            QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
            parms._train = fr._key;
            Job job = new Quantile(parms).trainModel();
            kmm = (QuantileModel)job.get();
            job.remove();
        }
        finally {
            if (fr != null) {
                fr.remove();
            }
            if (kmm != null) {
                kmm.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test50pct() {
        QuantileModel kmm = null;
        Frame fr = null;
        try {
            double[][] d = new double[][]{{1.56386606237}, {0.812834256224}, {3.68417563302}, {3.1270221088}, {5.51277746586}};
            fr = ArrayUtils.frame((double[][])d);
            QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
            parms._train = fr._key;
            Job job = new Quantile(parms).trainModel();
            kmm = (QuantileModel)job.get();
            job.remove();
            Assert.assertTrue((((QuantileModel.QuantileOutput)kmm._output)._quantiles[0][5] == d[3][0] ? 1 : 0) != 0);
        }
        finally {
            if (fr != null) {
                fr.remove();
            }
            if (kmm != null) {
                kmm.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDirectMatch() {
        QuantileModel kmm = null;
        Frame fr = null;
        try {
            double[][] d = new double[][]{{1.0}, {1.0}, {1.0}, {2.0}};
            fr = ArrayUtils.frame((double[][])d);
            QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
            parms._train = fr._key;
            parms._probs = new double[]{0.5};
            Job job = new Quantile(parms).trainModel();
            kmm = (QuantileModel)job.get();
            job.remove();
            Assert.assertTrue((((QuantileModel.QuantileOutput)kmm._output)._quantiles[0][0] == 1.0 ? 1 : 0) != 0);
        }
        finally {
            if (fr != null) {
                fr.remove();
            }
            if (kmm != null) {
                kmm.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterpolate1() {
        QuantileModel kmm = null;
        Frame fr = null;
        try {
            double[][] d = new double[][]{{1.0}, {1.0}, {2.0}, {2.0}};
            fr = ArrayUtils.frame((double[][])d);
            QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
            parms._train = fr._key;
            parms._probs = new double[]{0.5};
            Job job = new Quantile(parms).trainModel();
            kmm = (QuantileModel)job.get();
            job.remove();
            Assert.assertTrue((((QuantileModel.QuantileOutput)kmm._output)._quantiles[0][0] == 1.5 ? 1 : 0) != 0);
        }
        finally {
            if (fr != null) {
                fr.remove();
            }
            if (kmm != null) {
                kmm.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterpolate2() {
        QuantileModel kmm = null;
        Frame fr = null;
        try {
            double[][] d = new double[][]{{1.0}, {1.0}, {3.0}, {2.0}};
            fr = ArrayUtils.frame((double[][])d);
            QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
            parms._train = fr._key;
            parms._probs = new double[]{0.5};
            Job job = new Quantile(parms).trainModel();
            kmm = (QuantileModel)job.get();
            job.remove();
            Assert.assertTrue((((QuantileModel.QuantileOutput)kmm._output)._quantiles[0][0] == 1.5 ? 1 : 0) != 0);
        }
        finally {
            if (fr != null) {
                fr.remove();
            }
            if (kmm != null) {
                kmm.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterpolateLow() {
        QuantileModel kmm = null;
        Frame fr = null;
        try {
            double[][] d = new double[][]{{1.0}, {2.0}, {3.0}};
            fr = ArrayUtils.frame((double[][])d);
            QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
            parms._train = fr._key;
            parms._probs = new double[]{0.49};
            Job job = new Quantile(parms).trainModel();
            kmm = (QuantileModel)job.get();
            job.remove();
            Assert.assertTrue((((QuantileModel.QuantileOutput)kmm._output)._quantiles[0][0] == 1.98 ? 1 : 0) != 0);
        }
        finally {
            if (fr != null) {
                fr.remove();
            }
            if (kmm != null) {
                kmm.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterpolateHigh() {
        QuantileModel kmm = null;
        Frame fr = null;
        try {
            double[][] d = new double[][]{{1.0}, {2.0}, {3.0}};
            fr = ArrayUtils.frame((double[][])d);
            QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
            parms._train = fr._key;
            parms._probs = new double[]{0.51};
            Job job = new Quantile(parms).trainModel();
            kmm = (QuantileModel)job.get();
            job.remove();
            Assert.assertTrue((((QuantileModel.QuantileOutput)kmm._output)._quantiles[0][0] == 2.02 ? 1 : 0) != 0);
        }
        finally {
            if (fr != null) {
                fr.remove();
            }
            if (kmm != null) {
                kmm.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterpolateHighWeighted() {
        QuantileModel kmm = null;
        Frame fr = null;
        try {
            double[][] d = new double[][]{{1.0, 0.0}, {2.0, 1.0}, {3.0, 1.0}};
            fr = ArrayUtils.frame((String[])new String[]{"x", "weights"}, (double[][])d);
            QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
            parms._train = fr._key;
            parms._weights_column = "weights";
            parms._probs = new double[]{0.51};
            Job job = new Quantile(parms).trainModel();
            kmm = (QuantileModel)job.get();
            job.remove();
            Assert.assertTrue((((QuantileModel.QuantileOutput)kmm._output)._quantiles[0][0] == 2.51 ? 1 : 0) != 0);
        }
        finally {
            if (fr != null) {
                fr.remove();
            }
            if (kmm != null) {
                kmm.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterpolateHighWeighted2() {
        QuantileModel kmm = null;
        Frame fr = null;
        try {
            double[][] d = new double[][]{{1.0, 2.0}, {2.0, 1.0}, {3.0, 1.0}};
            fr = ArrayUtils.frame((String[])new String[]{"x", "weights"}, (double[][])d);
            QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
            parms._train = fr._key;
            parms._weights_column = "weights";
            parms._probs = new double[]{0.43};
            Job job = new Quantile(parms).trainModel();
            kmm = (QuantileModel)job.get();
            job.remove();
            Assert.assertTrue((((QuantileModel.QuantileOutput)kmm._output)._quantiles[0][0] == 1.29 ? 1 : 0) != 0);
        }
        finally {
            if (fr != null) {
                fr.remove();
            }
            if (kmm != null) {
                kmm.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterpolateHighWeighted3() {
        QuantileModel kmm = null;
        Frame fr = null;
        try {
            double[][] d = new double[][]{{1.0, 3.0}, {2.0, 2.0}, {3.0, 5.0}};
            fr = ArrayUtils.frame((String[])new String[]{"x", "weights"}, (double[][])d);
            QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
            parms._train = fr._key;
            parms._weights_column = "weights";
            parms._probs = new double[]{0.31};
            Job job = new Quantile(parms).trainModel();
            kmm = (QuantileModel)job.get();
            job.remove();
            Assert.assertTrue((((QuantileModel.QuantileOutput)kmm._output)._quantiles[0][0] == 1.79 ? 1 : 0) != 0);
        }
        finally {
            if (fr != null) {
                fr.remove();
            }
            if (kmm != null) {
                kmm.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterpolateHighWeighted4() {
        QuantileModel kmm = null;
        Frame fr = null;
        try {
            double[][] d = new double[][]{{1.0, 1.005}, {2.0, 1.0}, {3.0, 1.0}};
            fr = ArrayUtils.frame((String[])new String[]{"x", "weights"}, (double[][])d);
            QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
            parms._train = fr._key;
            parms._weights_column = "weights";
            parms._probs = new double[]{0.71};
            Job job = new Quantile(parms).trainModel();
            kmm = (QuantileModel)job.get();
            job.remove();
            Assert.assertTrue((String)("Got: " + ((QuantileModel.QuantileOutput)kmm._output)._quantiles[0][0]), (Math.abs(((QuantileModel.QuantileOutput)kmm._output)._quantiles[0][0] - 2.42355) < 1.0E-10 ? 1 : 0) != 0);
        }
        finally {
            if (fr != null) {
                fr.remove();
            }
            if (kmm != null) {
                kmm.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterpolateHighWeighted5() {
        QuantileModel kmm = null;
        Frame fr = null;
        try {
            double[][] d = new double[][]{{1.0, 5.0}, {2.0, 4.0}, {3.0, 3.0}};
            fr = ArrayUtils.frame((String[])new String[]{"x", "weights"}, (double[][])d);
            QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
            parms._train = fr._key;
            parms._weights_column = "weights";
            parms._probs = new double[]{0.43};
            Job job = new Quantile(parms).trainModel();
            kmm = (QuantileModel)job.get();
            job.remove();
            Assert.assertTrue((((QuantileModel.QuantileOutput)kmm._output)._quantiles[0][0] == 1.73 ? 1 : 0) != 0);
        }
        finally {
            if (fr != null) {
                fr.remove();
            }
            if (kmm != null) {
                kmm.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterpolateHighWeighted6() {
        QuantileModel kmm = null;
        Frame fr = null;
        try {
            double[][] d = new double[][]{{1.0, 2.0}, {2.0, 2.0}, {3.0, 2.0}};
            fr = ArrayUtils.frame((String[])new String[]{"x", "weights"}, (double[][])d);
            QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
            parms._train = fr._key;
            parms._weights_column = "weights";
            parms._probs = new double[]{0.33};
            Job job = new Quantile(parms).trainModel();
            kmm = (QuantileModel)job.get();
            job.remove();
            Assert.assertTrue((((QuantileModel.QuantileOutput)kmm._output)._quantiles[0][0] == 1.65 ? 1 : 0) != 0);
        }
        finally {
            if (fr != null) {
                fr.remove();
            }
            if (kmm != null) {
                kmm.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterpolateHighWeighted7() {
        QuantileModel kmm = null;
        Frame fr = null;
        try {
            double[][] d = new double[][]{{1.0, 1.0}, {2.0, 1.0}, {3.0, 1.0}};
            fr = ArrayUtils.frame((String[])new String[]{"x", "weights"}, (double[][])d);
            QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
            parms._train = fr._key;
            parms._weights_column = "weights";
            parms._probs = new double[]{0.0, 0.25, 0.5, 0.75, 1.0};
            Job job = new Quantile(parms).trainModel();
            kmm = (QuantileModel)job.get();
            job.remove();
            Assert.assertTrue((boolean)Arrays.equals(((QuantileModel.QuantileOutput)kmm._output)._quantiles[0], new double[]{1.0, 1.5, 2.0, 2.5, 3.0}));
        }
        finally {
            if (fr != null) {
                fr.remove();
            }
            if (kmm != null) {
                kmm.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterpolateHighWeighted8() {
        QuantileModel kmm = null;
        Frame fr = null;
        try {
            double[][] d = new double[][]{{1.0, 2.0}, {2.0, 2.0}, {3.0, 2.0}};
            fr = ArrayUtils.frame((String[])new String[]{"x", "weights"}, (double[][])d);
            QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
            parms._train = fr._key;
            parms._weights_column = "weights";
            parms._probs = new double[]{0.0, 0.25, 0.5, 0.75, 1.0};
            Job job = new Quantile(parms).trainModel();
            kmm = (QuantileModel)job.get();
            job.remove();
            Assert.assertTrue((boolean)Arrays.equals(((QuantileModel.QuantileOutput)kmm._output)._quantiles[0], new double[]{1.0, 1.25, 2.0, 2.75, 3.0}));
        }
        finally {
            if (fr != null) {
                fr.remove();
            }
            if (kmm != null) {
                kmm.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterpolateWideRangeWeighted() {
        QuantileModel kmm = null;
        Frame fr = null;
        try {
            double[][] d = new double[][]{{1.0E-100, 1.0}, {1.0E-10, 4.0}, {1.0E-4, 2.0}, {0.01, 4.0}, {0.1, 5.0}, {1.0, 3.0}};
            fr = ArrayUtils.frame((String[])new String[]{"x", "weights"}, (double[][])d);
            QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
            parms._train = fr._key;
            parms._weights_column = "weights";
            parms._probs = new double[]{0.25, 0.5, 0.75, 1.0};
            Job job = new Quantile(parms).trainModel();
            kmm = (QuantileModel)job.get();
            job.remove();
            double[] exp = new double[]{5.0E-5, 0.01, 0.1, 1.0};
            double[] act = ((QuantileModel.QuantileOutput)kmm._output)._quantiles[0];
            for (int i = 0; i < exp.length; ++i) {
                Assert.assertTrue((String)("Got " + act[i] + " but expected " + exp[i]), (Math.abs(act[i] - exp[i]) / exp[i] < 1.0E-5 ? 1 : 0) != 0);
            }
        }
        finally {
            if (fr != null) {
                fr.remove();
            }
            if (kmm != null) {
                kmm.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterpolateWideRange() {
        QuantileModel kmm = null;
        Frame fr = null;
        try {
            double[][] d = new double[][]{{1.0E-100}, {1.0E-10}, {1.0E-4}, {0.01}, {0.1}, {1.0}};
            fr = ArrayUtils.frame((String[])new String[]{"x"}, (double[][])d);
            QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
            parms._train = fr._key;
            parms._probs = new double[]{0.0, 0.25, 0.5, 0.75, 1.0};
            Job job = new Quantile(parms).trainModel();
            kmm = (QuantileModel)job.get();
            job.remove();
            double[] exp = new double[]{1.0E-100, 2.5E-5, 0.00505, 0.0775, 1.0};
            double[] act = ((QuantileModel.QuantileOutput)kmm._output)._quantiles[0];
            for (int i = 0; i < exp.length; ++i) {
                Assert.assertTrue((String)("Got " + act[i] + " but expected " + exp[i]), (Math.abs(act[i] - exp[i]) / exp[i] < 1.0E-5 ? 1 : 0) != 0);
            }
        }
        finally {
            if (fr != null) {
                fr.remove();
            }
            if (kmm != null) {
                kmm.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterpolateWideRangeWeighted2() {
        QuantileModel kmm = null;
        Frame fr = null;
        try {
            double[][] d = new double[][]{{1.0E-100, 10.0}, {1.0E-10, 4.0}, {1.0E-4, 2.0}, {0.01, 4.0}, {0.1, 5.0}, {1.0, 3.0}};
            fr = ArrayUtils.frame((String[])new String[]{"x", "weights"}, (double[][])d);
            QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
            parms._train = fr._key;
            parms._weights_column = "weights";
            parms._probs = new double[]{0.0, 0.25, 0.5, 0.75, 1.0};
            Job job = new Quantile(parms).trainModel();
            kmm = (QuantileModel)job.get();
            job.remove();
            double[] exp = new double[]{1.0E-100, 1.0E-100, 5.000005E-5, 0.1, 1.0};
            double[] act = ((QuantileModel.QuantileOutput)kmm._output)._quantiles[0];
            for (int i = 0; i < exp.length; ++i) {
                Assert.assertTrue((String)("Got " + act[i] + " but expected " + exp[i]), (Math.abs(act[i] - exp[i]) / exp[i] < 1.0E-5 ? 1 : 0) != 0);
            }
        }
        finally {
            if (fr != null) {
                fr.remove();
            }
            if (kmm != null) {
                kmm.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterpolateLargeWeights() {
        QuantileModel kmm = null;
        Frame fr = null;
        try {
            double[][] d = new double[][]{{0.0, 10.0}, {1.0, 10.0}};
            fr = ArrayUtils.frame((String[])new String[]{"x", "weights"}, (double[][])d);
            QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
            parms._train = fr._key;
            parms._weights_column = "weights";
            parms._probs = new double[]{0.475, 0.48, 0.49};
            Job job = new Quantile(parms).trainModel();
            kmm = (QuantileModel)job.get();
            job.remove();
            double[] exp = new double[]{0.025, 0.12, 0.31};
            double[] act = ((QuantileModel.QuantileOutput)kmm._output)._quantiles[0];
            for (int i = 0; i < exp.length; ++i) {
                Assert.assertTrue((String)("Got " + act[i] + " but expected " + exp[i]), (Math.abs(act[i] - exp[i]) / exp[i] < 1.0E-5 ? 1 : 0) != 0);
            }
        }
        finally {
            if (fr != null) {
                fr.remove();
            }
            if (kmm != null) {
                kmm.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShuffled() {
        Frame fr1 = null;
        Frame fr2 = null;
        try {
            fr1 = QuantileTest.parse_test_file((String)"smalldata/junit/no_weights.csv");
            fr2 = QuantileTest.parse_test_file((String)"smalldata/junit/no_weights_shuffled.csv");
            for (QuantileModel.CombineMethod comb : new QuantileModel.CombineMethod[]{QuantileModel.CombineMethod.AVERAGE, QuantileModel.CombineMethod.LOW, QuantileModel.CombineMethod.HIGH, QuantileModel.CombineMethod.INTERPOLATE}) {
                QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
                parms._train = fr1._key;
                parms._combine_method = comb;
                Job job1 = new Quantile(parms).trainModel();
                QuantileModel kmm1 = (QuantileModel)job1.get();
                job1.remove();
                parms = new QuantileModel.QuantileParameters();
                parms._train = fr2._key;
                parms._combine_method = comb;
                Job job2 = new Quantile(parms).trainModel();
                QuantileModel kmm2 = (QuantileModel)job2.get();
                job2.remove();
                try {
                    Assert.assertTrue((boolean)Arrays.deepEquals((Object[])((QuantileModel.QuantileOutput)kmm1._output)._quantiles, (Object[])((QuantileModel.QuantileOutput)kmm2._output)._quantiles));
                }
                finally {
                    if (kmm1 != null) {
                        kmm1.delete();
                    }
                    if (kmm2 != null) {
                        kmm2.delete();
                    }
                }
            }
        }
        finally {
            if (fr1 != null) {
                fr1.remove();
            }
            if (fr2 != null) {
                fr2.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWeights0() {
        Frame fr1 = null;
        Frame fr2 = null;
        try {
            fr1 = QuantileTest.parse_test_file((String)"smalldata/junit/no_weights.csv");
            fr2 = QuantileTest.parse_test_file((String)"smalldata/junit/weights_all_ones.csv");
            for (QuantileModel.CombineMethod comb : new QuantileModel.CombineMethod[]{QuantileModel.CombineMethod.AVERAGE, QuantileModel.CombineMethod.LOW, QuantileModel.CombineMethod.HIGH, QuantileModel.CombineMethod.INTERPOLATE}) {
                QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
                parms._train = fr1._key;
                parms._combine_method = comb;
                parms._weights_column = null;
                Job job1 = new Quantile(parms).trainModel();
                QuantileModel kmm1 = (QuantileModel)job1.get();
                job1.remove();
                parms = new QuantileModel.QuantileParameters();
                parms._train = fr2._key;
                parms._combine_method = comb;
                parms._weights_column = "weight";
                Job job2 = new Quantile(parms).trainModel();
                QuantileModel kmm2 = (QuantileModel)job2.get();
                job2.remove();
                try {
                    Assert.assertTrue((boolean)Arrays.deepEquals((Object[])((QuantileModel.QuantileOutput)kmm1._output)._quantiles, (Object[])((QuantileModel.QuantileOutput)kmm2._output)._quantiles));
                }
                finally {
                    if (kmm1 != null) {
                        kmm1.delete();
                    }
                    if (kmm2 != null) {
                        kmm2.delete();
                    }
                }
            }
        }
        finally {
            if (fr1 != null) {
                fr1.remove();
            }
            if (fr2 != null) {
                fr2.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWeights1() {
        Frame fr1 = null;
        Frame fr2 = null;
        try {
            fr1 = QuantileTest.parse_test_file((String)"smalldata/junit/no_weights.csv");
            fr2 = QuantileTest.parse_test_file((String)"smalldata/junit/weights.csv");
            for (QuantileModel.CombineMethod comb : new QuantileModel.CombineMethod[]{QuantileModel.CombineMethod.AVERAGE, QuantileModel.CombineMethod.LOW, QuantileModel.CombineMethod.HIGH, QuantileModel.CombineMethod.INTERPOLATE}) {
                QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
                parms._train = fr1._key;
                parms._combine_method = comb;
                parms._weights_column = null;
                Job job1 = new Quantile(parms).trainModel();
                QuantileModel kmm1 = (QuantileModel)job1.get();
                job1.remove();
                parms = new QuantileModel.QuantileParameters();
                parms._train = fr2._key;
                parms._combine_method = comb;
                parms._weights_column = "weight";
                Job job2 = new Quantile(parms).trainModel();
                QuantileModel kmm2 = (QuantileModel)job2.get();
                job2.remove();
                try {
                    Assert.assertTrue((boolean)Arrays.deepEquals((Object[])((QuantileModel.QuantileOutput)kmm1._output)._quantiles, (Object[])((QuantileModel.QuantileOutput)kmm2._output)._quantiles));
                }
                finally {
                    if (kmm1 != null) {
                        kmm1.delete();
                    }
                    if (kmm2 != null) {
                        kmm2.delete();
                    }
                }
            }
        }
        finally {
            if (fr1 != null) {
                fr1.remove();
            }
            if (fr2 != null) {
                fr2.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void testWeights2() {
        Frame fr1 = null;
        Frame fr2 = null;
        try {
            fr1 = QuantileTest.parse_test_file((String)"smalldata/junit/weights_all_twos.csv");
            fr2 = QuantileTest.parse_test_file((String)"smalldata/junit/weights_all_ones.csv");
            for (QuantileModel.CombineMethod comb : new QuantileModel.CombineMethod[]{QuantileModel.CombineMethod.AVERAGE, QuantileModel.CombineMethod.LOW, QuantileModel.CombineMethod.HIGH, QuantileModel.CombineMethod.INTERPOLATE}) {
                QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
                parms._train = fr1._key;
                parms._combine_method = comb;
                parms._weights_column = "weight";
                Job job1 = new Quantile(parms).trainModel();
                QuantileModel kmm1 = (QuantileModel)job1.get();
                job1.remove();
                parms = new QuantileModel.QuantileParameters();
                parms._train = fr2._key;
                parms._combine_method = comb;
                parms._weights_column = "weight";
                Job job2 = new Quantile(parms).trainModel();
                QuantileModel kmm2 = (QuantileModel)job2.get();
                job2.remove();
                try {
                    assert (Arrays.deepEquals((Object[])((QuantileModel.QuantileOutput)kmm1._output)._quantiles, (Object[])((QuantileModel.QuantileOutput)kmm2._output)._quantiles));
                    Assert.assertTrue((boolean)Arrays.deepEquals((Object[])((QuantileModel.QuantileOutput)kmm1._output)._quantiles, (Object[])((QuantileModel.QuantileOutput)kmm2._output)._quantiles));
                }
                finally {
                    if (kmm1 != null) {
                        kmm1.delete();
                    }
                    if (kmm2 != null) {
                        kmm2.delete();
                    }
                }
            }
        }
        finally {
            if (fr1 != null) {
                fr1.remove();
            }
            if (fr2 != null) {
                fr2.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void testWeights3() {
        Frame fr1 = null;
        Frame fr2 = null;
        try {
            fr1 = QuantileTest.parse_test_file((String)"smalldata/junit/weights_all_tiny.csv");
            fr2 = QuantileTest.parse_test_file((String)"smalldata/junit/weights_all_ones.csv");
            for (QuantileModel.CombineMethod comb : new QuantileModel.CombineMethod[]{QuantileModel.CombineMethod.AVERAGE, QuantileModel.CombineMethod.LOW, QuantileModel.CombineMethod.HIGH, QuantileModel.CombineMethod.INTERPOLATE}) {
                QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
                parms._train = fr1._key;
                parms._combine_method = comb;
                parms._weights_column = "weight";
                Job job1 = new Quantile(parms).trainModel();
                QuantileModel kmm1 = (QuantileModel)job1.get();
                job1.remove();
                parms = new QuantileModel.QuantileParameters();
                parms._train = fr2._key;
                parms._combine_method = comb;
                parms._weights_column = "weight";
                Job job2 = new Quantile(parms).trainModel();
                QuantileModel kmm2 = (QuantileModel)job2.get();
                job2.remove();
                try {
                    Assert.assertTrue((boolean)Arrays.deepEquals((Object[])((QuantileModel.QuantileOutput)kmm1._output)._quantiles, (Object[])((QuantileModel.QuantileOutput)kmm2._output)._quantiles));
                }
                finally {
                    if (kmm1 != null) {
                        kmm1.delete();
                    }
                    if (kmm2 != null) {
                        kmm2.delete();
                    }
                }
            }
        }
        finally {
            if (fr1 != null) {
                fr1.remove();
            }
            if (fr2 != null) {
                fr2.remove();
            }
        }
    }
}

