/*
 * Decompiled with CFR 0.152.
 */
package hex.psvm.psvm;

import Jama.CholeskyDecomposition;
import Jama.Matrix;
import hex.psvm.psvm.LLMatrix;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class LLMatrixTest {
    @Test
    public void cholSolve_identity() {
        int N = 10;
        LLMatrix matrix = new LLMatrix(10);
        double[] b = new double[10];
        Random r = new Random(10L);
        for (int i = 0; i < 10; ++i) {
            matrix.set(i, i, 1.0);
            b[i] = r.nextDouble();
        }
        double[] expected_x = (double[])b.clone();
        double[] x = matrix.cholSolve(b);
        Assert.assertArrayEquals((double[])expected_x, (double[])x, (double)0.0);
    }

    @Test
    public void cholSolve() {
        int N = 10;
        Random r = new Random(10L);
        Matrix spd = this.makeSPD(r, 10);
        Matrix L = new CholeskyDecomposition(spd).getL();
        LLMatrix matrix = new LLMatrix(10);
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j <= i; ++j) {
                matrix.set(i, j, L.get(i, j));
            }
        }
        double[] b = new double[10];
        for (int i = 0; i < 10; ++i) {
            b[i] = r.nextDouble();
        }
        Matrix B = new Matrix((double[][])new double[][]{b});
        Matrix X = new CholeskyDecomposition(spd).solve(B.transpose());
        double[] x = matrix.cholSolve(b);
        Assert.assertArrayEquals((double[])X.transpose().getArray()[0], (double[])x, (double)0.0);
    }

    @Test
    public void cf() {
        int N = 10;
        Random r = new Random(10L);
        Matrix spd = this.makeSPD(r, 10);
        LLMatrix matrix = new LLMatrix(10);
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j <= i; ++j) {
                matrix.set(i, j, spd.get(i, j));
            }
        }
        Matrix expectedL = new CholeskyDecomposition(spd).getL();
        LLMatrix L = matrix.cf();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j <= i; ++j) {
                Assert.assertEquals((double)expectedL.get(i, j), (double)L.get(i, j), (double)1.0E-8);
            }
        }
    }

    private Matrix makeSPD(Random r, int N) {
        int j;
        int i;
        double[][] A = new double[N][];
        double[][] At = new double[N][];
        for (i = 0; i < N; ++i) {
            A[i] = new double[N];
            At[i] = new double[N];
            for (j = 0; j < N; ++j) {
                A[i][j] = r.nextDouble();
            }
        }
        for (i = 0; i < N; ++i) {
            for (j = 0; j < N; ++j) {
                At[j][i] = A[i][j];
            }
        }
        return new Matrix((double[][])A).times(new Matrix((double[][])At));
    }
}

