/*
 * Decompiled with CFR 0.152.
 */
package hex.psvm.psvm;

import hex.DataInfo;
import hex.psvm.psvm.GaussianKernel;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import water.Keyed;
import water.ScopeTracker;
import water.TestFrameCatalog;
import water.TestUtil;
import water.fvec.Chunk;
import water.fvec.Frame;

public class KernelTest
extends TestUtil {
    @Rule
    public ScopeTracker scope = new ScopeTracker();

    @BeforeClass
    public static void setup() {
        KernelTest.stall_till_cloudsize((int)1);
    }

    @Test
    public void testGaussianKernel() {
        DataInfo.Row[] rs = this.makeRows();
        GaussianKernel gk = new GaussianKernel(0.01);
        for (DataInfo.Row r : rs) {
            Assert.assertEquals((double)1.0, (double)gk.calcKernel(r, r), (double)0.0);
            Assert.assertEquals((double)1.0, (double)gk.calcKernelWithLabel(r, r), (double)0.0);
        }
        Assert.assertEquals((double)0.924594, (double)gk.calcKernel(rs[0], rs[1]), (double)1.0E-6);
        Assert.assertEquals((double)0.924594, (double)gk.calcKernelWithLabel(rs[0], rs[1]), (double)1.0E-6);
        Assert.assertEquals((double)0.791678, (double)gk.calcKernel(rs[0], rs[2]), (double)1.0E-6);
        Assert.assertEquals((double)-0.791678, (double)gk.calcKernelWithLabel(rs[0], rs[2]), (double)1.0E-6);
    }

    private DataInfo.Row[] makeRows() {
        DataInfo.Row[] rs;
        Frame f = TestFrameCatalog.oneChunkFewRows();
        f.add("two_norm_sq", f.anyVec().makeZero());
        this.scope.track((Keyed)f);
        DataInfo di = new DataInfo(f, null, 2, true, DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, true, false, false, false, false, false, null).disableIntercept();
        Chunk[] chks = new Chunk[f.numCols()];
        for (int i = 0; i < chks.length; ++i) {
            chks[i] = di._adaptedFrame.vec(i).chunkForChunkIdx(0);
        }
        for (DataInfo.Row r : rs = new DataInfo.Row[]{di.extractDenseRow(chks, 0, di.newDenseRow()), di.extractDenseRow(chks, 1, di.newDenseRow()), di.extractDenseRow(chks, 2, di.newDenseRow())}) {
            r.response[1] = r.twoNormSq();
        }
        return rs;
    }
}

