/*
 * Decompiled with CFR 0.152.
 */
package hex.psvm.psvm;

import hex.psvm.psvm.GaussianKernel;
import hex.psvm.psvm.IncompleteCholeskyFactorization;
import hex.psvm.psvm.Kernel;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import water.H2O;
import water.TestUtil;
import water.fvec.Frame;

public class IncompleteCholeskyFactorizationTest
extends TestUtil {
    @BeforeClass
    public static void setup() {
        IncompleteCholeskyFactorizationTest.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSmallICF() {
        Frame icf = null;
        Frame expected = null;
        Frame fr = IncompleteCholeskyFactorizationTest.parse_test_file((String)"./smalldata/splice/splice.svm");
        try {
            icf = ((ICFTask)H2O.runOnLeaderNode((H2O.RemoteRunnable)new ICFTask(fr)))._icf;
            expected = IncompleteCholeskyFactorizationTest.parse_test_file((String)"./smalldata/splice/splice_icf3.csv");
            Assert.assertTrue((boolean)IncompleteCholeskyFactorizationTest.compareFrames((Frame)expected, (Frame)icf, (double)1.0E-6));
        }
        finally {
            if (expected != null) {
                expected.delete();
            }
            if (fr != null) {
                fr.delete();
            }
            if (icf != null) {
                icf.delete();
            }
        }
    }

    private static class ICFTask
    extends H2O.RemoteRunnable<ICFTask> {
        private final Frame _fr;
        private Frame _icf;

        ICFTask(Frame fr) {
            this._fr = fr;
        }

        public void run() {
            GaussianKernel kernel = new GaussianKernel(0.01);
            this._icf = IncompleteCholeskyFactorization.icf((Frame)this._fr, (String)"C1", (Kernel)kernel, (int)3, (double)1.0E-6);
        }
    }
}

