/*
 * Decompiled with CFR 0.152.
 */
package hex.pca;

import hex.DataInfo;
import hex.pca.ActualPCATests;
import hex.pca.PCAImplementation;
import hex.pca.PCAModel;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import water.TestUtil;
import water.util.Log;

@RunWith(value=Parameterized.class)
public class PCAWideDataSetsTests
extends TestUtil {
    public static final double _TOLERANCE = 1.0E-6;
    public static String _smallDataset = "smalldata/pca_test/decathlon.csv";
    public static final String _prostateDataset = "smalldata/prostate/prostate_cat.csv";
    public static final DataInfo.TransformType[] _transformTypes = new DataInfo.TransformType[]{DataInfo.TransformType.NONE, DataInfo.TransformType.STANDARDIZE, DataInfo.TransformType.DEMEAN, DataInfo.TransformType.DESCALE};
    public Random _rand = new Random();
    public PCAModel _golden = null;
    private PCAModel.PCAParameters pcaParameters;
    @Parameterized.Parameter
    public PCAImplementation PCAImplementation;

    @Parameterized.Parameters
    public static PCAImplementation[] parametersForSvdImplementation() {
        return hex.pca.PCAImplementation.values();
    }

    @BeforeClass
    public static void setup() {
        PCAWideDataSetsTests.stall_till_cloudsize((int)1);
    }

    @Before
    public void setupPcaParameters() {
        this.pcaParameters = new PCAModel.PCAParameters();
        this.pcaParameters._pca_implementation = this.PCAImplementation;
        Log.info((Object[])new Object[]{"pcaParameters._PCAImplementation: " + this.pcaParameters._pca_implementation.name()});
    }

    @Test
    public void testWideDataSetGramSVD() throws InterruptedException, ExecutionException {
        ActualPCATests.testWideDataSets(PCAModel.PCAParameters.Method.GramSVD, PCAModel.PCAParameters.Method.GramSVD, 1.0E-6, _smallDataset, false, true, _transformTypes[this._rand.nextInt(_transformTypes.length)], this.pcaParameters);
        ActualPCATests.testWideDataSets(PCAModel.PCAParameters.Method.GramSVD, PCAModel.PCAParameters.Method.GramSVD, 1.0E-6, _smallDataset, true, true, _transformTypes[this._rand.nextInt(_transformTypes.length)], this.pcaParameters);
        ActualPCATests.testWideDataSets(PCAModel.PCAParameters.Method.GramSVD, PCAModel.PCAParameters.Method.GramSVD, 1.0E-6, _smallDataset, false, false, _transformTypes[this._rand.nextInt(_transformTypes.length)], this.pcaParameters);
        ActualPCATests.testWideDataSets(PCAModel.PCAParameters.Method.GramSVD, PCAModel.PCAParameters.Method.GramSVD, 1.0E-6, _smallDataset, true, false, _transformTypes[this._rand.nextInt(_transformTypes.length)], this.pcaParameters);
        ActualPCATests.testWideDataSets(PCAModel.PCAParameters.Method.GramSVD, PCAModel.PCAParameters.Method.GramSVD, 1.0E-6, _prostateDataset, false, false, _transformTypes[this._rand.nextInt(_transformTypes.length)], this.pcaParameters);
        ActualPCATests.testWideDataSets(PCAModel.PCAParameters.Method.GramSVD, PCAModel.PCAParameters.Method.GramSVD, 1.0E-6, _prostateDataset, true, false, _transformTypes[this._rand.nextInt(_transformTypes.length)], this.pcaParameters);
    }

    @Test
    public void testWideDataSetPower() throws InterruptedException, ExecutionException {
        ActualPCATests.testWideDataSets(PCAModel.PCAParameters.Method.GramSVD, PCAModel.PCAParameters.Method.Power, 1.0E-6, _smallDataset, false, true, _transformTypes[this._rand.nextInt(_transformTypes.length)], this.pcaParameters);
        ActualPCATests.testWideDataSets(PCAModel.PCAParameters.Method.GramSVD, PCAModel.PCAParameters.Method.Power, 1.0E-6, _smallDataset, true, true, _transformTypes[this._rand.nextInt(_transformTypes.length)], this.pcaParameters);
        ActualPCATests.testWideDataSets(PCAModel.PCAParameters.Method.GramSVD, PCAModel.PCAParameters.Method.Power, 1.0E-6, _smallDataset, false, false, _transformTypes[this._rand.nextInt(_transformTypes.length)], this.pcaParameters);
        ActualPCATests.testWideDataSets(PCAModel.PCAParameters.Method.GramSVD, PCAModel.PCAParameters.Method.Power, 1.0E-6, _smallDataset, true, false, _transformTypes[this._rand.nextInt(_transformTypes.length)], this.pcaParameters);
        ActualPCATests.testWideDataSets(PCAModel.PCAParameters.Method.GramSVD, PCAModel.PCAParameters.Method.Power, 1.0E-6, _prostateDataset, false, false, _transformTypes[this._rand.nextInt(_transformTypes.length)], this.pcaParameters);
        ActualPCATests.testWideDataSets(PCAModel.PCAParameters.Method.GramSVD, PCAModel.PCAParameters.Method.Power, 1.0E-6, _prostateDataset, true, false, _transformTypes[this._rand.nextInt(_transformTypes.length)], this.pcaParameters);
    }

    @Test
    public void testWideDataSetRandomized() throws InterruptedException, ExecutionException {
        ActualPCATests.testWideDataSets(PCAModel.PCAParameters.Method.GramSVD, PCAModel.PCAParameters.Method.Randomized, 1.0E-6, _smallDataset, false, true, _transformTypes[this._rand.nextInt(_transformTypes.length)], this.pcaParameters);
        ActualPCATests.testWideDataSets(PCAModel.PCAParameters.Method.GramSVD, PCAModel.PCAParameters.Method.Randomized, 1.0E-6, _smallDataset, true, true, _transformTypes[this._rand.nextInt(_transformTypes.length)], this.pcaParameters);
        ActualPCATests.testWideDataSets(PCAModel.PCAParameters.Method.GramSVD, PCAModel.PCAParameters.Method.Randomized, 1.0E-6, _smallDataset, false, false, _transformTypes[this._rand.nextInt(_transformTypes.length)], this.pcaParameters);
        ActualPCATests.testWideDataSets(PCAModel.PCAParameters.Method.GramSVD, PCAModel.PCAParameters.Method.Randomized, 1.0E-6, _smallDataset, true, false, _transformTypes[this._rand.nextInt(_transformTypes.length)], this.pcaParameters);
        ActualPCATests.testWideDataSets(PCAModel.PCAParameters.Method.GramSVD, PCAModel.PCAParameters.Method.Randomized, 1.0E-6, _prostateDataset, false, false, _transformTypes[this._rand.nextInt(_transformTypes.length)], this.pcaParameters);
        ActualPCATests.testWideDataSets(PCAModel.PCAParameters.Method.GramSVD, PCAModel.PCAParameters.Method.Randomized, 1.0E-6, _prostateDataset, true, false, _transformTypes[this._rand.nextInt(_transformTypes.length)], this.pcaParameters);
    }

    @Test
    public void testWideDataSetGLRM() throws InterruptedException, ExecutionException {
        ActualPCATests.testWideDataSets(PCAModel.PCAParameters.Method.GramSVD, PCAModel.PCAParameters.Method.GLRM, 1.0E-4, _smallDataset, false, true, _transformTypes[1], this.pcaParameters);
        ActualPCATests.testWideDataSets(PCAModel.PCAParameters.Method.GLRM, PCAModel.PCAParameters.Method.GLRM, 1.0E-6, _smallDataset, true, true, _transformTypes[this._rand.nextInt(_transformTypes.length)], this.pcaParameters);
        ActualPCATests.testWideDataSets(PCAModel.PCAParameters.Method.GLRM, PCAModel.PCAParameters.Method.GLRM, 1.0E-6, _smallDataset, false, false, _transformTypes[this._rand.nextInt(_transformTypes.length)], this.pcaParameters);
        ActualPCATests.testWideDataSets(PCAModel.PCAParameters.Method.GLRM, PCAModel.PCAParameters.Method.GLRM, 1.0E-6, _smallDataset, true, false, _transformTypes[this._rand.nextInt(_transformTypes.length)], this.pcaParameters);
        ActualPCATests.testWideDataSets(PCAModel.PCAParameters.Method.GLRM, PCAModel.PCAParameters.Method.GLRM, 1.0E-6, _prostateDataset, false, false, _transformTypes[this._rand.nextInt(_transformTypes.length)], this.pcaParameters);
        ActualPCATests.testWideDataSets(PCAModel.PCAParameters.Method.GLRM, PCAModel.PCAParameters.Method.GLRM, 1.0E-6, _prostateDataset, true, false, _transformTypes[this._rand.nextInt(_transformTypes.length)], this.pcaParameters);
    }
}

