/*
 * Decompiled with CFR 0.152.
 */
package hex.pca;

import hex.CreateFrame;
import hex.DataInfo;
import hex.SplitFrame;
import hex.generic.Generic;
import hex.generic.GenericModel;
import hex.genmodel.MojoPipelineBuilder;
import hex.kmeans.KMeans;
import hex.kmeans.KMeansModel;
import hex.pca.PCA;
import hex.pca.PCAImplementation;
import hex.pca.PCAModel;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import water.DKV;
import water.Iced;
import water.Key;
import water.Keyed;
import water.Scope;
import water.TestUtil;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.FrameUtils;
import water.util.Log;
import water.util.TwoDimTable;

@RunWith(value=Parameterized.class)
public class PCATest
extends TestUtil {
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();
    public static final double TOLERANCE = 1.0E-6;
    private PCAModel.PCAParameters pcaParameters;
    @Parameterized.Parameter
    public PCAImplementation PCAImplementation;

    @Parameterized.Parameters
    public static PCAImplementation[] parametersForSvdImplementation() {
        return hex.pca.PCAImplementation.values();
    }

    @BeforeClass
    public static void setup() {
        PCATest.stall_till_cloudsize((int)1);
    }

    @Before
    public void setupPcaParameters() {
        this.pcaParameters = new PCAModel.PCAParameters();
        this.pcaParameters._pca_implementation = this.PCAImplementation;
        Log.info((Object[])new Object[]{"pcaParameters._PCAImplementation: " + this.pcaParameters._pca_implementation.name()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArrestsScoring() throws InterruptedException, ExecutionException {
        double[] stddev = new double[]{202.7230564, 27.8322637, 6.5230482, 2.5813652};
        double[][] eigvec = PCATest.ard((double[][])new double[][]{PCATest.ard((double[])new double[]{-0.04239181, 0.01616262, -0.06588426, 0.99679535}), PCATest.ard((double[])new double[]{-0.94395706, 0.3206858, 0.0665517, -0.04094568}), PCATest.ard((double[])new double[]{-0.30842767, -0.93845891, 0.15496743, 0.01234261}), PCATest.ard((double[])new double[]{-0.10963744, -0.12725666, -0.98347101, -0.06760284})});
        PCAModel model = null;
        Frame train = null;
        Frame score = null;
        Frame scoreR = null;
        try {
            train = PCATest.parse_test_file((Key)Key.make((String)"arrests.hex"), (String)"smalldata/pca_test/USArrests.csv");
            this.pcaParameters._train = train._key;
            this.pcaParameters._k = 4;
            this.pcaParameters._transform = DataInfo.TransformType.NONE;
            this.pcaParameters._pca_method = PCAModel.PCAParameters.Method.GramSVD;
            model = (PCAModel)new PCA(this.pcaParameters).trainModel().get();
            TestUtil.checkStddev((double[])stddev, (double[])((PCAModel.PCAOutput)model._output)._std_deviation, (double)1.0E-5);
            boolean[] flippedEig = TestUtil.checkEigvec((double[][])eigvec, (TwoDimTable)((PCAModel.PCAOutput)model._output)._eigenvectors, (double)1.0E-5);
            score = model.score(train);
            scoreR = PCATest.parse_test_file((Key)Key.make((String)"scoreR.hex"), (String)"smalldata/pca_test/USArrests_PCAscore.csv");
            TestUtil.checkProjection((Frame)scoreR, (Frame)score, (double)1.0E-6, (boolean[])flippedEig);
            Assert.assertTrue((boolean)model.testJavaScoring(train, score, 1.0E-5));
        }
        finally {
            if (train != null) {
                train.delete();
            }
            if (score != null) {
                score.delete();
            }
            if (scoreR != null) {
                scoreR.delete();
            }
            if (model != null) {
                model.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPCAwithNoK() throws InterruptedException, ExecutionException {
        Scope.enter();
        PCAModel modelNok = null;
        PCAModel modelK = null;
        Frame train = null;
        Frame score = null;
        Frame scoreK = null;
        try {
            train = PCATest.parse_test_file((Key)Key.make((String)"arrests.hex"), (String)"smalldata/pca_test/USArrests.csv");
            Scope.track((Frame[])new Frame[]{train});
            this.pcaParameters._train = train._key;
            this.pcaParameters._transform = DataInfo.TransformType.NONE;
            this.pcaParameters._pca_method = PCAModel.PCAParameters.Method.GramSVD;
            this.pcaParameters._seed = 12345L;
            modelNok = (PCAModel)new PCA(this.pcaParameters).trainModel().get();
            Scope.track_generic((Keyed)modelNok);
            score = modelNok.score(train);
            Scope.track((Frame[])new Frame[]{score});
            this.pcaParameters._k = 1;
            modelK = (PCAModel)new PCA(this.pcaParameters).trainModel().get();
            Scope.track_generic((Keyed)modelK);
            scoreK = modelK.score(train);
            Scope.track((Frame[])new Frame[]{scoreK});
            PCATest.assertBitIdentical((Frame)score, (Frame)scoreK);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIrisSplitScoring() throws InterruptedException, ExecutionException {
        PCAModel model = null;
        Frame fr = null;
        Frame fr2 = null;
        Frame tr = null;
        Frame te = null;
        try {
            fr = PCATest.parse_test_file((String)"smalldata/iris/iris_wheader.csv");
            SplitFrame sf = new SplitFrame(fr, new double[]{0.5, 0.5}, new Key[]{Key.make((String)"train.hex"), Key.make((String)"test.hex")});
            sf.exec().get();
            Key[] ksplits = sf._destination_frames;
            tr = (Frame)DKV.get((Key)ksplits[0]).get();
            te = (Frame)DKV.get((Key)ksplits[1]).get();
            this.pcaParameters._train = ksplits[0];
            this.pcaParameters._valid = ksplits[1];
            this.pcaParameters._k = 4;
            this.pcaParameters._max_iterations = 1000;
            this.pcaParameters._pca_method = PCAModel.PCAParameters.Method.GramSVD;
            model = (PCAModel)new PCA(this.pcaParameters).trainModel().get();
            fr2 = model.score(te);
            Assert.assertTrue((boolean)model.testJavaScoring(te, fr2, 1.0E-5));
        }
        finally {
            if (fr != null) {
                fr.delete();
            }
            if (fr2 != null) {
                fr2.delete();
            }
            if (tr != null) {
                tr.delete();
            }
            if (te != null) {
                te.delete();
            }
            if (model != null) {
                model.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImputeMissing() throws InterruptedException, ExecutionException {
        Frame train = null;
        double missing_fraction = 0.75;
        long seed = 12345L;
        try {
            train = PCATest.parse_test_file((Key)Key.make((String)"arrests.hex"), (String)"smalldata/pca_test/USArrests.csv");
            if (missing_fraction > 0.0) {
                Frame frtmp = new Frame(Key.make(), train.names(), train.vecs());
                DKV.put((Key)frtmp._key, (Iced)frtmp);
                FrameUtils.MissingInserter j = new FrameUtils.MissingInserter(frtmp._key, seed, missing_fraction);
                j.execImpl().get();
                DKV.remove((Key)frtmp._key);
            }
            this.pcaParameters._train = train._key;
            this.pcaParameters._k = 4;
            this.pcaParameters._transform = DataInfo.TransformType.NONE;
            this.pcaParameters._pca_method = PCAModel.PCAParameters.Method.GramSVD;
            this.pcaParameters._impute_missing = true;
            this.pcaParameters._seed = seed;
            PCAModel pca = null;
            pca = (PCAModel)new PCA(this.pcaParameters).trainModel().get();
            if (pca != null) {
                pca.remove();
            }
        }
        finally {
            if (train != null) {
                train.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCatOnlyPUBDEV3988() throws InterruptedException, ExecutionException {
        PCAModel model = null;
        Frame train = null;
        Frame score = null;
        try {
            train = PCATest.parse_test_file((Key)Key.make((String)"prostate_cat.hex"), (String)"smalldata/prostate/prostate_cat.csv");
            for (int i = train.numCols() - 1; i > 0; --i) {
                Vec v = train.vec(i);
                if (v.get_type() == 4) continue;
                train.remove(i);
                Vec.remove((Key)v._key);
            }
            DKV.put((Keyed)train);
            this.pcaParameters._train = train._key;
            this.pcaParameters._k = 2;
            this.pcaParameters._transform = DataInfo.TransformType.STANDARDIZE;
            this.pcaParameters._use_all_factor_levels = true;
            this.pcaParameters._pca_method = PCAModel.PCAParameters.Method.GramSVD;
            this.pcaParameters._impute_missing = false;
            this.pcaParameters._seed = 12345L;
            PCA pcaParms = new PCA(this.pcaParameters);
            model = (PCAModel)pcaParms.trainModel().get();
            score = model.score(train);
            Assert.assertTrue((boolean)model.testJavaScoring(train, score, 1.0E-6));
        }
        finally {
            if (train != null) {
                train.delete();
            }
            if (score != null) {
                score.delete();
            }
            if (model != null) {
                model.delete();
            }
        }
    }

    @Test
    public void testPUBDEV3500NoLeakage() throws InterruptedException, ExecutionException {
        Scope.enter();
        Frame train = null;
        try {
            train = PCATest.parse_test_file((Key)Key.make((String)"prostate_cat.hex"), (String)"smalldata/prostate/prostate_cat.csv");
            Scope.track((Frame[])new Frame[]{train});
            this.pcaParameters._train = train._key;
            this.pcaParameters._k = 3;
            this.pcaParameters._transform = DataInfo.TransformType.NONE;
            this.pcaParameters._pca_method = PCAModel.PCAParameters.Method.Randomized;
            this.pcaParameters._impute_missing = true;
            this.pcaParameters._seed = 12345L;
            this.pcaParameters._use_all_factor_levels = true;
            PCAModel pca = null;
            pca = (PCAModel)new PCA(this.pcaParameters).trainModel().get();
            Scope.track_generic((Keyed)pca);
            Assert.assertTrue((((PCAModel.PCAParameters)pca._parms)._k == ((PCAModel.PCAOutput)pca._output)._std_deviation.length ? 1 : 0) != 0);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIrisScoreWarning() throws InterruptedException, ExecutionException {
        PCAModel model = null;
        Frame fr = null;
        Frame fr2 = null;
        Frame tr = null;
        Object te = null;
        Scope.enter();
        try {
            fr = PCATest.parse_test_file((String)"smalldata/iris/iris_wheader.csv");
            tr = PCATest.parse_test_file((String)"smalldata/iris/iris_wheader_bad_cnames.csv");
            Scope.track((Frame[])new Frame[]{fr});
            Scope.track((Frame[])new Frame[]{tr});
            PCAModel.PCAParameters parms = new PCAModel.PCAParameters();
            parms._train = fr._key;
            parms._k = 4;
            parms._max_iterations = 1000;
            parms._pca_method = PCAModel.PCAParameters.Method.GramSVD;
            model = (PCAModel)new PCA(parms).trainModel().get();
            Scope.track_generic((Keyed)model);
            fr2 = model.score(tr);
            Scope.track((Frame[])new Frame[]{fr2});
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArrests() throws InterruptedException, ExecutionException {
        double[] stddev = new double[]{83.7324, 14.212402, 6.489426, 2.48279};
        double[][] eigvec = PCATest.ard((double[][])new double[][]{PCATest.ard((double[])new double[]{0.04170432, -0.04482166, 0.07989066, -0.99492173}), PCATest.ard((double[])new double[]{0.99522128, -0.05876003, -0.06756974, 0.0389383}), PCATest.ard((double[])new double[]{0.04633575, 0.97685748, -0.20054629, -0.05816914}), PCATest.ard((double[])new double[]{0.0751555, 0.20071807, 0.97408059, 0.07232502})});
        double[] stddev_std = new double[]{1.5748783, 0.9948694, 0.5971291, 0.4164494};
        double[][] eigvec_std = PCATest.ard((double[][])new double[][]{PCATest.ard((double[])new double[]{-0.5358995, 0.4181809, -0.3412327, 0.6492278}), PCATest.ard((double[])new double[]{-0.5831836, 0.1879856, -0.2681484, -0.74340748}), PCATest.ard((double[])new double[]{-0.2781909, -0.8728062, -0.3780158, 0.13387773}), PCATest.ard((double[])new double[]{-0.5434321, -0.1673186, 0.8177779, 0.08902432})});
        Frame train = null;
        try {
            train = PCATest.parse_test_file((Key)Key.make((String)"arrests.hex"), (String)"smalldata/pca_test/USArrests.csv");
            for (DataInfo.TransformType std : new DataInfo.TransformType[]{DataInfo.TransformType.DEMEAN, DataInfo.TransformType.STANDARDIZE}) {
                PCAModel model = null;
                try {
                    this.pcaParameters._train = train._key;
                    this.pcaParameters._k = 4;
                    this.pcaParameters._transform = std;
                    this.pcaParameters._max_iterations = 1000;
                    this.pcaParameters._pca_method = PCAModel.PCAParameters.Method.Power;
                    model = (PCAModel)new PCA(this.pcaParameters).trainModel().get();
                    if (std == DataInfo.TransformType.DEMEAN) {
                        TestUtil.checkStddev((double[])stddev, (double[])((PCAModel.PCAOutput)model._output)._std_deviation, (double)1.0E-6);
                        TestUtil.checkEigvec((double[][])eigvec, (TwoDimTable)((PCAModel.PCAOutput)model._output)._eigenvectors, (double)1.0E-6);
                        continue;
                    }
                    if (std != DataInfo.TransformType.STANDARDIZE) continue;
                    TestUtil.checkStddev((double[])stddev_std, (double[])((PCAModel.PCAOutput)model._output)._std_deviation, (double)1.0E-6);
                    TestUtil.checkEigvec((double[][])eigvec_std, (TwoDimTable)((PCAModel.PCAOutput)model._output)._eigenvectors, (double)1.0E-6);
                }
                finally {
                    if (model != null) {
                        model.delete();
                    }
                }
            }
        }
        finally {
            if (train != null) {
                train.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIrisScoring() throws InterruptedException, ExecutionException {
        double[] stddev = new double[]{7.88175203, 1.56002774, 0.59189816, 0.25917329, 0.15415273, 0.09381276, 0.0476859};
        double[][] eigvec = PCATest.ard((double[][])new double[][]{PCATest.ard((double[])new double[]{-0.03169051, -0.3230586, 0.185100382, -0.12336685, -0.14867156, 0.75932119, -0.496462912}), PCATest.ard((double[])new double[]{-0.04289677, 0.04037565, -0.780961964, 0.19727933, 0.07251338, -0.12216945, -0.572298338}), PCATest.ard((double[])new double[]{-0.05019689, 0.16836717, 0.551432201, -0.07122329, 0.08454116, -0.4832701, -0.647522462}), PCATest.ard((double[])new double[]{-0.74915107, -0.2662942, -0.101102186, -0.48920057, 0.3245846, -0.09176909, 0.067412858}), PCATest.ard((double[])new double[]{-0.37877011, -0.5063606, 0.142219195, 0.69081642, -0.26312992, -0.17811871, 0.041411296}), PCATest.ard((double[])new double[]{-0.51177078, 0.65945159, -0.005079934, 0.048819, -0.52128288, 0.17038367, 0.006223427}), PCATest.ard((double[])new double[]{-0.16742875, 0.32166036, 0.145893901, 0.47102115, 0.72052968, 0.32523458, 0.020389463})});
        PCAModel model = null;
        Frame train = null;
        Frame score = null;
        Frame scoreR = null;
        try {
            train = PCATest.parse_test_file((Key)Key.make((String)"iris.hex"), (String)"smalldata/iris/iris_wheader.csv");
            this.pcaParameters._train = train._key;
            this.pcaParameters._k = 7;
            this.pcaParameters._transform = DataInfo.TransformType.NONE;
            this.pcaParameters._use_all_factor_levels = true;
            this.pcaParameters._pca_method = PCAModel.PCAParameters.Method.Power;
            model = (PCAModel)new PCA(this.pcaParameters).trainModel().get();
            TestUtil.checkStddev((double[])stddev, (double[])((PCAModel.PCAOutput)model._output)._std_deviation, (double)1.0E-5);
            boolean[] flippedEig = TestUtil.checkEigvec((double[][])eigvec, (TwoDimTable)((PCAModel.PCAOutput)model._output)._eigenvectors, (double)1.0E-5);
            score = model.score(train);
            scoreR = PCATest.parse_test_file((Key)Key.make((String)"scoreR.hex"), (String)"smalldata/pca_test/iris_PCAscore.csv");
            TestUtil.checkProjection((Frame)scoreR, (Frame)score, (double)1.0E-6, (boolean[])flippedEig);
            Assert.assertTrue((boolean)model.testJavaScoring(train, score, 1.0E-5));
        }
        finally {
            if (train != null) {
                train.delete();
            }
            if (score != null) {
                score.delete();
            }
            if (scoreR != null) {
                scoreR.delete();
            }
            if (model != null) {
                model.delete();
            }
        }
    }

    @Test
    public void testGram() {
        double[][] x = PCATest.ard((double[][])new double[][]{PCATest.ard((double[])new double[]{1.0, 2.0, 3.0}), PCATest.ard((double[])new double[]{4.0, 5.0, 6.0})});
        double[][] xgram = PCATest.ard((double[][])new double[][]{PCATest.ard((double[])new double[]{17.0, 22.0, 27.0}), PCATest.ard((double[])new double[]{22.0, 29.0, 36.0}), PCATest.ard((double[])new double[]{27.0, 36.0, 45.0})});
        double[][] xtgram = PCATest.ard((double[][])new double[][]{PCATest.ard((double[])new double[]{14.0, 32.0}), PCATest.ard((double[])new double[]{32.0, 77.0})});
        double[][] xgram_glrm = ArrayUtils.formGram((double[][])x, (boolean)false);
        double[][] xtgram_glrm = ArrayUtils.formGram((double[][])x, (boolean)true);
        Assert.assertArrayEquals((Object[])xgram, (Object[])xgram_glrm);
        Assert.assertArrayEquals((Object[])xtgram, (Object[])xtgram_glrm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPCAPredMojoPojo() {
        Scope.enter();
        try {
            CreateFrame cf = new CreateFrame();
            Random generator = new Random();
            int numRows = 8000;
            int numCols = 8;
            cf.rows = numRows;
            cf.cols = numCols;
            cf.factors = 8;
            cf.has_response = false;
            cf.seed = 12345L;
            cf.missing_fraction = 0.0;
            System.out.println("Createframe parameters: rows: " + numRows + " cols:" + numCols + " seed: " + cf.seed);
            Frame trainPCA = Scope.track((Frame[])new Frame[]{(Frame)cf.execImpl().get()});
            SplitFrame sf = new SplitFrame(trainPCA, new double[]{0.8, 0.2}, new Key[]{Key.make((String)"train.hex"), Key.make((String)"test.hex")});
            sf.exec().get();
            Key[] ksplits = sf._destination_frames;
            Frame tr = (Frame)DKV.get((Key)ksplits[0]).get();
            Frame te = (Frame)DKV.get((Key)ksplits[1]).get();
            Scope.track((Frame[])new Frame[]{tr});
            Scope.track((Frame[])new Frame[]{te});
            PCAModel.PCAParameters parms = new PCAModel.PCAParameters();
            parms._train = tr._key;
            parms._k = 4;
            parms._max_iterations = 1000;
            parms._pca_method = PCAModel.PCAParameters.Method.GramSVD;
            PCAModel model = (PCAModel)new PCA(parms).trainModel().get();
            Scope.track_generic((Keyed)model);
            Frame pred = model.score(te);
            Scope.track((Frame[])new Frame[]{pred});
            Assert.assertTrue((boolean)model.testJavaScoring(te, pred, 1.0E-6));
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPCAPredMojoPojoNumericsOnly() {
        Scope.enter();
        try {
            Frame trainPCA = PCATest.generate_real_only((int)8, (int)8000, (double)0.0, (long)12345L);
            SplitFrame sf = new SplitFrame(trainPCA, new double[]{0.8, 0.2}, new Key[]{Key.make((String)"train.hex"), Key.make((String)"test.hex")});
            sf.exec().get();
            Key[] ksplits = sf._destination_frames;
            Frame tr = (Frame)DKV.get((Key)ksplits[0]).get();
            Frame te = (Frame)DKV.get((Key)ksplits[1]).get();
            Scope.track((Frame[])new Frame[]{tr});
            Scope.track((Frame[])new Frame[]{te});
            Scope.track((Frame[])new Frame[]{trainPCA});
            PCAModel.PCAParameters parms = new PCAModel.PCAParameters();
            parms._train = tr._key;
            parms._k = 4;
            parms._max_iterations = 1000;
            parms._pca_method = PCAModel.PCAParameters.Method.GramSVD;
            PCAModel model = (PCAModel)new PCA(parms).trainModel().get();
            Scope.track_generic((Keyed)model);
            Frame pred = model.score(te);
            Scope.track((Frame[])new Frame[]{pred});
            Assert.assertTrue((boolean)model.testJavaScoring(te, pred, 1.0E-6));
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPCAPipeline() throws IOException {
        try {
            Scope.enter();
            Frame train = PCATest.parse_test_file((Key)Key.make((String)"arrests.hex"), (String)"smalldata/pca_test/USArrests.csv");
            Scope.track((Frame[])new Frame[]{train});
            this.pcaParameters._train = train._key;
            this.pcaParameters._k = 4;
            this.pcaParameters._transform = DataInfo.TransformType.NONE;
            this.pcaParameters._pca_method = PCAModel.PCAParameters.Method.GramSVD;
            PCAModel pca = (PCAModel)new PCA(this.pcaParameters).trainModel().get();
            Scope.track_generic((Keyed)pca);
            Frame reduced = pca.score(train);
            Scope.track((Frame[])new Frame[]{reduced});
            KMeansModel.KMeansParameters kmeansParameters = new KMeansModel.KMeansParameters();
            kmeansParameters._train = reduced._key;
            kmeansParameters._k = 2;
            KMeansModel kmeans = (KMeansModel)new KMeans(kmeansParameters).trainModel().get();
            Scope.track_generic((Keyed)kmeans);
            Frame clusters = kmeans.score(reduced);
            Scope.track((Frame[])new Frame[]{clusters});
            URI pcaMojoUri = pca.exportMojo(this.tmp.newFolder("pca").getAbsolutePath() + "/pca.zip", false);
            URI kmeansMojoUri = kmeans.exportMojo(this.tmp.newFolder("kmeans").getAbsolutePath() + "/kmeans.zip", false);
            File pipelineFile = this.tmp.newFile("pipeline.zip");
            new MojoPipelineBuilder().addModel("pca", new File(pcaMojoUri)).addMapping("PC1", "pca", 0).addMapping("PC2", "pca", 1).addMapping("PC3", "pca", 2).addMapping("PC4", "pca", 3).addMainModel("kmeans", new File(kmeansMojoUri)).buildPipeline(pipelineFile);
            GenericModel pipelineModel = Generic.importMojoModel((String)pipelineFile.getAbsolutePath(), (boolean)true);
            Scope.track_generic((Keyed)pipelineModel);
            Frame pipelinePreds = pipelineModel.score(train, null, null, false);
            Scope.track((Frame[])new Frame[]{pipelinePreds});
            PCATest.assertVecEquals((Vec)clusters.vec(0), (Vec)pipelinePreds.vec(0), (double)0.0);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }
}

