/*
 * Decompiled with CFR 0.152.
 */
package hex.pca;

import hex.DataInfo;
import hex.pca.PCA;
import hex.pca.PCAModel;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import water.DKV;
import water.Key;
import water.Keyed;
import water.Scope;
import water.TestUtil;
import water.fvec.Frame;
import water.util.Log;
import water.util.TwoDimTable;

class ActualPCATests {
    ActualPCATests() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testWideDataSets(PCAModel.PCAParameters.Method pcaMethod, PCAModel.PCAParameters.Method pcaMethod2, double tolerance, String datafile, boolean addNAs, boolean removeColumns, DataInfo.TransformType transformType, PCAModel.PCAParameters pcaParameters) throws InterruptedException, ExecutionException {
        Scope.enter();
        PCAModel modelN = null;
        PCAModel modelW = null;
        Frame train = null;
        Frame scoreN = null;
        Frame scoreW = null;
        try {
            train = TestUtil.parse_test_file((Key)Key.make((String)datafile), (String)datafile);
            Scope.track((Frame[])new Frame[]{train});
            if (removeColumns) {
                train.remove(12).remove();
                train.remove(11).remove();
                train.remove(10).remove();
            }
            if (addNAs) {
                train.vec(0).setNA(0L);
                train.vec(3).setNA(10L);
                train.vec(5).setNA(20L);
            }
            DKV.put((Keyed)train);
            pcaParameters._train = train._key;
            pcaParameters._k = 3;
            pcaParameters._transform = transformType;
            Log.info((Object[])new Object[]{"Data transformation applied is " + pcaParameters._transform.name()});
            pcaParameters._use_all_factor_levels = true;
            pcaParameters._pca_method = pcaMethod;
            pcaParameters._impute_missing = false;
            pcaParameters._seed = 12345L;
            PCA pcaParms = new PCA(pcaParameters);
            modelN = (PCAModel)pcaParms.trainModel().get();
            scoreN = modelN.score(train);
            Scope.track((Frame[])new Frame[]{scoreN});
            Scope.track_generic((Keyed)modelN);
            pcaParameters._pca_method = pcaMethod2;
            PCA pcaParmsW = new PCA(pcaParameters);
            pcaParmsW.setWideDataset(true);
            modelW = (PCAModel)pcaParmsW.trainModel().get();
            scoreW = modelW.score(train);
            Scope.track((Frame[])new Frame[]{scoreW});
            Scope.track_generic((Keyed)modelW);
            TestUtil.checkStddev((double[])((PCAModel.PCAOutput)modelW._output)._std_deviation, (double[])((PCAModel.PCAOutput)modelN._output)._std_deviation, (double)tolerance);
            boolean[] flippedEig = TestUtil.checkEigvec((TwoDimTable)((PCAModel.PCAOutput)modelW._output)._eigenvectors, (TwoDimTable)((PCAModel.PCAOutput)modelN._output)._eigenvectors, (double)tolerance);
            TestUtil.checkProjection((Frame)scoreW, (Frame)scoreN, (double)tolerance, (boolean[])flippedEig);
            if (pcaMethod != PCAModel.PCAParameters.Method.GLRM) {
                Assert.assertTrue((boolean)modelN.testJavaScoring(train, scoreN, tolerance));
                Assert.assertTrue((boolean)modelW.testJavaScoring(train, scoreW, tolerance));
            }
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }
}

