/*
 * Decompiled with CFR 0.152.
 */
package hex.optimization;

import hex.optimization.OptimizationUtils;
import org.junit.Assert;
import org.junit.Test;
import water.TestUtil;

public class LineSearchTest
extends TestUtil {
    @Test
    public void testMoreThuenteMethod() {
        Object f = new OptimizationUtils.GradientSolver(){

            public OptimizationUtils.GradientInfo getGradient(double[] beta) {
                OptimizationUtils.GradientInfo ginfo = new OptimizationUtils.GradientInfo(0.0, new double[1]);
                double x = beta[0];
                double b = 2.0;
                double xx = x * x;
                ginfo._gradient[0] = (xx - b) / ((b + xx) * (b + xx));
                ginfo._objVal = -x / (xx + b);
                return ginfo;
            }

            public OptimizationUtils.GradientInfo getObjective(double[] beta) {
                return this.getGradient(beta);
            }
        };
        double stp = 1.0;
        double x = 100.0;
        OptimizationUtils.MoreThuente ls = new OptimizationUtils.MoreThuente(f, new double[]{x}, f.getGradient(new double[]{x}), 0.1, 0.1, 1.0E-5).setInitialStep(stp);
        boolean succ = ls.evaluate(new double[]{-1.0});
        Assert.assertTrue((boolean)succ);
        Assert.assertEquals((long)1L, (long)ls._returnStatus);
        Assert.assertEquals((long)18L, (long)ls.nfeval());
        Assert.assertEquals((double)-0.35355, (double)ls.ginfo()._objVal, (double)1.0E-5);
        Assert.assertEquals((double)98586.0, (double)Math.round(1000.0 * ls.step()), (double)1.0E-5);
        x = 0.0;
        stp = 100.0;
        ls = new OptimizationUtils.MoreThuente(f, new double[]{x}, f.getGradient(new double[]{x}), 0.1, 0.1, 1.0E-5).setInitialStep(stp);
        succ = ls.evaluate(new double[]{1.0});
        Assert.assertTrue((boolean)succ);
        Assert.assertEquals((long)ls._returnStatus, (long)1L);
        Assert.assertEquals((long)5L, (long)ls.nfeval());
        Assert.assertEquals((double)-0.34992, (double)ls.ginfo()._objVal, (double)1.0E-5);
        Assert.assertEquals((double)1.6331, (double)ls.step(), (double)1.0E-5);
        x = 0.0;
        stp = 10.0;
        ls = new OptimizationUtils.MoreThuente(f, new double[]{x}, f.getGradient(new double[]{x}), 0.001, 0.1, 1.0E-5).setInitialStep(stp);
        succ = ls.evaluate(new double[]{1.0});
        Assert.assertTrue((boolean)succ);
        Assert.assertEquals((long)1L, (long)ls.nfeval());
        x = 0.0;
        stp = 1000.0;
        ls = new OptimizationUtils.MoreThuente(f, new double[]{x}, f.getGradient(new double[]{x}), 0.001, 0.1, 1.0E-5).setInitialStep(stp);
        succ = ls.evaluate(new double[]{1.0});
        Assert.assertEquals((long)ls._returnStatus, (long)1L);
        Assert.assertTrue((boolean)succ);
        Assert.assertEquals((long)4L, (long)ls.nfeval());
        Assert.assertEquals((long)37L, (long)Math.round(ls.step()));
        x = 0.0;
        stp = 0.001;
        ls = new OptimizationUtils.MoreThuente(f, new double[]{x}, f.getGradient(new double[]{x}), 0.001, 0.1, 1.0E-5).setInitialStep(stp);
        succ = ls.evaluate(new double[]{1.0});
        Assert.assertEquals((long)ls._returnStatus, (long)1L);
        Assert.assertTrue((boolean)succ);
        Assert.assertEquals((long)6L, (long)ls.nfeval());
        Assert.assertEquals((long)14L, (long)Math.round(10.0 * ls.step()));
        f = new OptimizationUtils.GradientSolver(){

            public OptimizationUtils.GradientInfo getGradient(double[] beta) {
                OptimizationUtils.GradientInfo ginfo = new OptimizationUtils.GradientInfo(0.0, new double[1]);
                double x = beta[0];
                double b = 0.004;
                ginfo._objVal = Math.pow(x + b, 5.0) - 2.0 * Math.pow(x + b, 4.0);
                ginfo._gradient[0] = Math.pow(b + x, 3.0) * (5.0 * (b + x) - 8.0);
                return ginfo;
            }

            public OptimizationUtils.GradientInfo getObjective(double[] beta) {
                return this.getGradient(beta);
            }
        };
        ls = new OptimizationUtils.MoreThuente(f, new double[]{x}, f.getGradient(new double[]{x}), 0.1, 0.1, 1.0E-5).setInitialStep(stp);
        succ = ls.evaluate(new double[]{1.0});
        Assert.assertTrue((boolean)succ);
        Assert.assertEquals((long)ls._returnStatus, (long)1L);
        Assert.assertEquals((long)12L, (long)ls.nfeval());
        Assert.assertEquals((long)16L, (long)Math.round(10.0 * ls.step()));
        stp = 0.1;
        ls = new OptimizationUtils.MoreThuente(f, new double[]{x}, f.getGradient(new double[]{x}), 0.1, 0.1, 1.0E-5).setInitialStep(stp);
        succ = ls.evaluate(new double[]{1.0});
        Assert.assertTrue((boolean)succ);
        Assert.assertEquals((long)8L, (long)ls.nfeval());
        Assert.assertEquals((long)16L, (long)Math.round(10.0 * ls.step()));
        stp = 10.0;
        ls = new OptimizationUtils.MoreThuente(f, new double[]{x}, f.getGradient(new double[]{x}), 0.1, 0.1, 1.0E-5).setInitialStep(stp);
        succ = ls.evaluate(new double[]{1.0});
        Assert.assertTrue((boolean)succ);
        Assert.assertEquals((long)ls._returnStatus, (long)1L);
        Assert.assertEquals((long)8L, (long)ls.nfeval());
        Assert.assertEquals((long)16L, (long)Math.round(10.0 * ls.step()));
        stp = 1000.0;
        ls = new OptimizationUtils.MoreThuente(f, new double[]{x}, f.getGradient(new double[]{x}), 0.1, 0.1, 1.0E-5).setInitialStep(stp);
        succ = ls.evaluate(new double[]{1.0});
        Assert.assertTrue((boolean)succ);
        Assert.assertEquals((long)ls._returnStatus, (long)1L);
        Assert.assertEquals((long)11L, (long)ls.nfeval());
        Assert.assertEquals((long)16L, (long)Math.round(10.0 * ls.step()));
        f = new OptimizationUtils.GradientSolver(){
            final double beta = 0.01;
            final double l = 39.0;

            double phi0(double x) {
                if (x <= 0.99) {
                    return 1.0 - x;
                }
                if (x >= 1.01) {
                    return x - 1.0;
                }
                return 0.5 * ((x - 1.0) * (x - 1.0) / 0.01 + 0.01);
            }

            double phi0Prime(double x) {
                if (x <= 0.99) {
                    return -1.0;
                }
                if (x >= 1.01) {
                    return 1.0;
                }
                return (x - 1.0) / 0.01;
            }

            public OptimizationUtils.GradientInfo getGradient(double[] ary) {
                OptimizationUtils.GradientInfo ginfo = new OptimizationUtils.GradientInfo(0.0, new double[1]);
                double x = ary[0];
                double a = 0.01616034806779245;
                double b = 61.261056745000964;
                ginfo._objVal = this.phi0(x) + a * Math.sin(b * x);
                ginfo._gradient[0] = this.phi0Prime(x) + a * b * Math.cos(b * x);
                return ginfo;
            }

            public OptimizationUtils.GradientInfo getObjective(double[] beta) {
                return this.getGradient(beta);
            }
        };
        stp = 0.001;
        ls = new OptimizationUtils.MoreThuente(f, new double[]{x}, f.getGradient(new double[]{x}), 0.1, 0.1, 1.0E-5).setInitialStep(stp);
        succ = ls.evaluate(new double[]{1.0});
        Assert.assertEquals((long)ls._returnStatus, (long)1L);
        Assert.assertTrue((boolean)succ);
        Assert.assertEquals((long)12L, (long)ls.nfeval());
        Assert.assertEquals((long)10L, (long)Math.round(10.0 * ls.step()));
        stp = 0.1;
        ls = new OptimizationUtils.MoreThuente(f, new double[]{x}, f.getGradient(new double[]{x}), 0.1, 0.1, 1.0E-5).setInitialStep(stp);
        succ = ls.evaluate(new double[]{1.0});
        Assert.assertTrue((boolean)succ);
        Assert.assertEquals((long)ls._returnStatus, (long)1L);
        Assert.assertEquals((long)12L, (long)ls.nfeval());
        Assert.assertEquals((long)10L, (long)Math.round(10.0 * ls.step()));
        stp = 10.0;
        ls = new OptimizationUtils.MoreThuente(f, new double[]{x}, f.getGradient(new double[]{x}), 0.1, 0.1, 1.0E-5).setInitialStep(stp);
        succ = ls.evaluate(new double[]{1.0});
        Assert.assertEquals((long)ls._returnStatus, (long)1L);
        Assert.assertTrue((boolean)succ);
        Assert.assertEquals((long)10L, (long)ls.nfeval());
        Assert.assertEquals((long)10L, (long)Math.round(10.0 * ls.step()));
        stp = 1000.0;
        ls = new OptimizationUtils.MoreThuente(f, new double[]{x}, f.getGradient(new double[]{x}), 0.1, 0.1, 1.0E-5).setInitialStep(stp);
        succ = ls.evaluate(new double[]{1.0});
        Assert.assertTrue((boolean)succ);
        Assert.assertEquals((long)ls._returnStatus, (long)1L);
        Assert.assertEquals((long)13L, (long)ls.nfeval());
        Assert.assertEquals((long)10L, (long)Math.round(10.0 * ls.step()));
        f = new F(0.001, 0.001);
        stp = 0.001;
        ls = new OptimizationUtils.MoreThuente(f, new double[]{x}, f.getGradient(new double[]{x}), 0.001, 0.001, 1.0E-5).setInitialStep(stp);
        succ = ls.evaluate(new double[]{1.0});
        Assert.assertTrue((boolean)succ);
        Assert.assertEquals((long)ls._returnStatus, (long)1L);
        Assert.assertEquals((long)4L, (long)ls.nfeval());
        Assert.assertEquals((long)9L, (long)Math.round(100.0 * ls.step()));
        stp = 0.1;
        ls = new OptimizationUtils.MoreThuente(f, new double[]{x}, f.getGradient(new double[]{x}), 0.001, 0.001, 1.0E-5).setInitialStep(stp);
        succ = ls.evaluate(new double[]{1.0});
        Assert.assertTrue((boolean)succ);
        Assert.assertEquals((long)ls._returnStatus, (long)1L);
        Assert.assertEquals((long)1L, (long)ls.nfeval());
        Assert.assertEquals((long)10L, (long)Math.round(100.0 * ls.step()));
        stp = 10.0;
        ls = new OptimizationUtils.MoreThuente(f, new double[]{x}, f.getGradient(new double[]{x}), 0.001, 0.001, 1.0E-5).setInitialStep(stp);
        succ = ls.evaluate(new double[]{1.0});
        Assert.assertTrue((boolean)succ);
        Assert.assertEquals((long)3L, (long)ls.nfeval());
        Assert.assertEquals((long)35L, (long)Math.round(100.0 * ls.step()));
        stp = 1000.0;
        ls = new OptimizationUtils.MoreThuente(f, new double[]{x}, f.getGradient(new double[]{x}), 0.001, 0.001, 1.0E-5).setInitialStep(stp);
        succ = ls.evaluate(new double[]{1.0});
        Assert.assertTrue((boolean)succ);
        Assert.assertEquals((long)ls._returnStatus, (long)1L);
        Assert.assertEquals((long)4L, (long)ls.nfeval());
        Assert.assertEquals((long)83L, (long)Math.round(100.0 * ls.step()));
        f = new F(0.01, 0.001);
        stp = 0.001;
        ls = new OptimizationUtils.MoreThuente(f, new double[]{x}, f.getGradient(new double[]{x}), 0.001, 0.001, 1.0E-5).setInitialStep(stp);
        succ = ls.evaluate(new double[]{1.0});
        Assert.assertTrue((boolean)succ);
        Assert.assertEquals((long)6L, (long)ls.nfeval());
        Assert.assertEquals((long)75L, (long)Math.round(1000.0 * ls.step()));
        stp = 0.1;
        ls = new OptimizationUtils.MoreThuente(f, new double[]{x}, f.getGradient(new double[]{x}), 0.001, 0.001, 1.0E-5).setInitialStep(stp);
        succ = ls.evaluate(new double[]{1.0});
        Assert.assertTrue((boolean)succ);
        Assert.assertEquals((long)ls._returnStatus, (long)1L);
        Assert.assertEquals((long)3L, (long)ls.nfeval());
        Assert.assertEquals((long)78L, (long)Math.round(1000.0 * ls.step()));
        stp = 10.0;
        ls = new OptimizationUtils.MoreThuente(f, new double[]{x}, f.getGradient(new double[]{x}), 0.001, 0.001, 1.0E-5).setInitialStep(stp);
        succ = ls.evaluate(new double[]{1.0});
        Assert.assertTrue((boolean)succ);
        Assert.assertEquals((long)ls._returnStatus, (long)1L);
        Assert.assertEquals((long)7L, (long)ls.nfeval());
        Assert.assertEquals((long)73L, (long)Math.round(1000.0 * ls.step()));
        stp = 1000.0;
        ls = new OptimizationUtils.MoreThuente(f, new double[]{x}, f.getGradient(new double[]{x}), 0.001, 0.001, 1.0E-5).setInitialStep(stp);
        succ = ls.evaluate(new double[]{1.0});
        Assert.assertTrue((boolean)succ);
        Assert.assertEquals((long)ls._returnStatus, (long)1L);
        Assert.assertEquals((long)8L, (long)ls.nfeval());
        Assert.assertEquals((long)76L, (long)Math.round(1000.0 * ls.step()));
        f = new F(0.001, 0.01);
        stp = 0.001;
        ls = new OptimizationUtils.MoreThuente(f, new double[]{x}, f.getGradient(new double[]{x}), 0.001, 0.001, 1.0E-5).setInitialStep(stp);
        succ = ls.evaluate(new double[]{1.0});
        Assert.assertTrue((boolean)succ);
        Assert.assertEquals((long)ls._returnStatus, (long)1L);
        Assert.assertEquals((long)13L, (long)ls.nfeval());
        Assert.assertEquals((long)93L, (long)Math.round(100.0 * ls.step()));
        stp = 0.1;
        ls = new OptimizationUtils.MoreThuente(f, new double[]{x}, f.getGradient(new double[]{x}), 0.001, 0.001, 1.0E-5).setInitialStep(stp);
        succ = ls.evaluate(new double[]{1.0});
        Assert.assertTrue((boolean)succ);
        Assert.assertEquals((long)ls._returnStatus, (long)1L);
        Assert.assertEquals((long)11L, (long)ls.nfeval());
        Assert.assertEquals((long)93L, (long)Math.round(100.0 * ls.step()));
        stp = 10.0;
        ls = new OptimizationUtils.MoreThuente(f, new double[]{x}, f.getGradient(new double[]{x}), 0.001, 0.001, 1.0E-5).setInitialStep(stp);
        succ = ls.evaluate(new double[]{1.0});
        Assert.assertTrue((boolean)succ);
        Assert.assertEquals((long)8L, (long)ls.nfeval());
        Assert.assertEquals((long)92L, (long)Math.round(100.0 * ls.step()));
        stp = 1000.0;
        ls = new OptimizationUtils.MoreThuente(f, new double[]{x}, f.getGradient(new double[]{x}), 0.001, 0.001, 1.0E-5).setInitialStep(stp);
        succ = ls.evaluate(new double[]{1.0});
        Assert.assertTrue((boolean)succ);
        Assert.assertEquals((long)ls._returnStatus, (long)1L);
        Assert.assertEquals((long)11L, (long)ls.nfeval());
        Assert.assertEquals((long)92L, (long)Math.round(100.0 * ls.step()));
    }

    private static class F
    implements OptimizationUtils.GradientSolver {
        final double a;
        final double b;

        public F(double a, double b) {
            this.a = a;
            this.b = b;
        }

        private double gamma(double x) {
            return Math.sqrt(x * x + 1.0) - x;
        }

        public OptimizationUtils.GradientInfo getGradient(double[] beta) {
            double x = beta[0];
            double ga = this.gamma(this.a);
            double gb = this.gamma(this.b);
            OptimizationUtils.GradientInfo ginfo = new OptimizationUtils.GradientInfo(0.0, new double[1]);
            ginfo._objVal = ga * Math.sqrt((1.0 - x) * (1.0 - x) + this.b * this.b) + gb * Math.sqrt(x * x + this.a * this.a);
            ginfo._gradient[0] = ga * (x - 1.0) / Math.sqrt((1.0 - x) * (1.0 - x) + this.b * this.b) + gb * x / Math.sqrt(x * x + this.a * this.a);
            return ginfo;
        }

        public OptimizationUtils.GradientInfo getObjective(double[] beta) {
            return this.getGradient(beta);
        }
    }
}

