/*
 * Decompiled with CFR 0.152.
 */
package hex.naivebayes;

import hex.SplitFrame;
import hex.naivebayes.NaiveBayes;
import hex.naivebayes.NaiveBayesModel;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import water.DKV;
import water.Iced;
import water.Key;
import water.Keyed;
import water.Scope;
import water.TestUtil;
import water.fvec.Frame;
import water.fvec.Vec;

public class NaiveBayesTest
extends TestUtil {
    @BeforeClass
    public static void setup() {
        NaiveBayesTest.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIris() throws InterruptedException, ExecutionException {
        NaiveBayesModel model = null;
        Frame train = null;
        Frame score = null;
        try {
            train = NaiveBayesTest.parse_test_file((Key)Key.make((String)"iris_wheader.hex"), (String)"smalldata/iris/iris_wheader.csv");
            NaiveBayesModel.NaiveBayesParameters parms = new NaiveBayesModel.NaiveBayesParameters();
            parms._train = train._key;
            parms._laplace = 0.0;
            parms._response_column = train._names[4];
            parms._compute_metrics = false;
            model = (NaiveBayesModel)new NaiveBayes(parms).trainModel().get();
            score = model.score(train);
            Assert.assertTrue((boolean)model.testJavaScoring(train, score, 1.0E-6));
        }
        finally {
            if (train != null) {
                train.delete();
            }
            if (score != null) {
                score.delete();
            }
            if (model != null) {
                model.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIrisValidation() throws InterruptedException, ExecutionException {
        NaiveBayesModel model = null;
        Frame fr = null;
        Frame fr2 = null;
        Frame tr = null;
        Frame te = null;
        try {
            fr = NaiveBayesTest.parse_test_file((String)"smalldata/iris/iris_wheader.csv");
            SplitFrame sf = new SplitFrame(fr, new double[]{0.5, 0.5}, new Key[]{Key.make((String)"train.hex"), Key.make((String)"test.hex")});
            sf.exec().get();
            Key[] ksplits = sf._destination_frames;
            tr = (Frame)DKV.get((Key)ksplits[0]).get();
            te = (Frame)DKV.get((Key)ksplits[1]).get();
            NaiveBayesModel.NaiveBayesParameters parms = new NaiveBayesModel.NaiveBayesParameters();
            parms._train = ksplits[0];
            parms._valid = ksplits[1];
            parms._laplace = 0.01;
            parms._response_column = fr._names[4];
            parms._compute_metrics = true;
            model = (NaiveBayesModel)new NaiveBayes(parms).trainModel().get();
            fr2 = model.score(te);
            Assert.assertTrue((boolean)model.testJavaScoring(te, fr2, 1.0E-6));
        }
        finally {
            if (fr != null) {
                fr.delete();
            }
            if (fr2 != null) {
                fr2.delete();
            }
            if (tr != null) {
                tr.delete();
            }
            if (te != null) {
                te.delete();
            }
            if (model != null) {
                model.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProstate() throws InterruptedException, ExecutionException {
        NaiveBayesModel model = null;
        Frame train = null;
        Frame score = null;
        int[] cats = new int[]{1, 3, 4, 5};
        try {
            Scope.enter();
            train = NaiveBayesTest.parse_test_file((Key)Key.make((String)"prostate.hex"), (String)"smalldata/logreg/prostate.csv");
            for (int i = 0; i < cats.length; ++i) {
                Scope.track((Vec)train.replace(cats[i], train.vec(cats[i]).toCategoricalVec()));
            }
            train.remove("ID").remove();
            DKV.put((Key)train._key, (Iced)train);
            NaiveBayesModel.NaiveBayesParameters parms = new NaiveBayesModel.NaiveBayesParameters();
            parms._train = train._key;
            parms._laplace = 0.0;
            parms._response_column = train._names[0];
            parms._compute_metrics = true;
            model = (NaiveBayesModel)new NaiveBayes(parms).trainModel().get();
            score = model.score(train);
            Assert.assertTrue((boolean)model.testJavaScoring(train, score, 1.0E-6));
        }
        finally {
            if (train != null) {
                train.delete();
            }
            if (score != null) {
                score.delete();
            }
            if (model != null) {
                model.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCovtype() throws InterruptedException, ExecutionException {
        NaiveBayesModel model = null;
        Frame train = null;
        Frame score = null;
        try {
            Scope.enter();
            train = NaiveBayesTest.parse_test_file((Key)Key.make((String)"covtype.hex"), (String)"smalldata/covtype/covtype.20k.data");
            Scope.track((Vec)train.replace(54, train.vecs()[54].toCategoricalVec()));
            DKV.put((Keyed)train);
            NaiveBayesModel.NaiveBayesParameters parms = new NaiveBayesModel.NaiveBayesParameters();
            parms._train = train._key;
            parms._laplace = 0.0;
            parms._response_column = train._names[54];
            parms._compute_metrics = false;
            model = (NaiveBayesModel)new NaiveBayes(parms).trainModel().get();
            score = model.score(train);
            Assert.assertTrue((boolean)model.testJavaScoring(train, score, 1.0E-6));
        }
        finally {
            if (train != null) {
                train.delete();
            }
            if (score != null) {
                score.delete();
            }
            if (model != null) {
                model.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }
}

