/*
 * Decompiled with CFR 0.152.
 */
package hex.mojo;

import hex.genmodel.tools.PredictCsv;
import hex.tree.gbm.GBM;
import hex.tree.gbm.GBMModel;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.security.Permission;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import water.Key;
import water.Keyed;
import water.Scope;
import water.TestUtil;
import water.fvec.Frame;

public class PredictCsvTest
extends TestUtil {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    private SecurityManager originalSecurityManager;

    @Before
    public void setUp() {
        TestUtil.stall_till_cloudsize((int)1);
        this.originalSecurityManager = System.getSecurityManager();
        System.setSecurityManager(new PreventExitSecurityManager());
    }

    @After
    public void tearDown() {
        System.setSecurityManager(this.originalSecurityManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScoreMissingColumns() throws IOException {
        PrintStream originaOutputStream = System.out;
        String predictCsvOutput = null;
        try {
            Scope.enter();
            Frame train = Scope.track((Frame[])new Frame[]{TestUtil.parse_test_file((String)"smalldata/iris/iris.csv")});
            GBMModel.GBMParameters p = new GBMModel.GBMParameters();
            p._train = train._key;
            p._seed = 49374L;
            p._response_column = "C5";
            p._ntrees = 1;
            GBMModel model = (GBMModel)new GBM(p).trainModel().get();
            Scope.track_generic((Keyed)model);
            File modelFile = this.folder.newFile();
            model.exportMojo(modelFile.getAbsolutePath(), true);
            File outputFile = this.folder.newFile();
            ByteArrayOutputStream outputBytes = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(outputBytes);
            System.setOut(printStream);
            try {
                PredictCsv.main((String[])new String[]{"--mojo", modelFile.getAbsolutePath(), "--input", TestUtil.makeNfsFileVec((String)"smalldata/iris/iris_test.csv").getPath(), "--output", outputFile.getAbsolutePath()});
                Assert.fail((String)"Expected PredictCSV to exit");
            }
            catch (PreventedExitException e) {
                Assert.assertEquals((long)0L, (long)e.status);
            }
            predictCsvOutput = new String(outputBytes.toByteArray());
            Assert.assertTrue((boolean)predictCsvOutput.contains("There were 4 missing columns found in the input data set:"));
            Assert.assertTrue((boolean)predictCsvOutput.contains("C1"));
            Assert.assertTrue((boolean)predictCsvOutput.contains("C2"));
            Assert.assertTrue((boolean)predictCsvOutput.contains("C3"));
            Assert.assertTrue((boolean)predictCsvOutput.contains("C4"));
            Assert.assertTrue((boolean)predictCsvOutput.contains("Detected 5 unused columns in the input data set:"));
            Assert.assertTrue((boolean)predictCsvOutput.contains("petal_wid"));
            Assert.assertTrue((boolean)predictCsvOutput.contains("sepal_len"));
            Assert.assertTrue((boolean)predictCsvOutput.contains("species"));
            Assert.assertTrue((boolean)predictCsvOutput.contains("petal_len"));
            Assert.assertTrue((boolean)predictCsvOutput.contains("sepal_wid"));
        }
        catch (Throwable throwable) {
            System.setOut(originaOutputStream);
            System.out.print(predictCsvOutput);
            Scope.exit((Key[])new Key[0]);
            throw throwable;
        }
        System.setOut(originaOutputStream);
        System.out.print(predictCsvOutput);
        Scope.exit((Key[])new Key[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScoreNoMissingColumns() throws IOException {
        PrintStream originaOutputStream = System.out;
        String predictCsvOutput = null;
        try {
            Scope.enter();
            Frame train = Scope.track((Frame[])new Frame[]{TestUtil.parse_test_file((String)"smalldata/junit/iris.csv")});
            GBMModel.GBMParameters p = new GBMModel.GBMParameters();
            p._train = train._key;
            p._seed = 49374L;
            p._response_column = "class";
            p._ntrees = 1;
            GBMModel model = (GBMModel)new GBM(p).trainModel().get();
            File modelFile = this.folder.newFile();
            model.exportMojo(modelFile.getAbsolutePath(), true);
            File outputFile = this.folder.newFile();
            ByteArrayOutputStream outputBytes = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(outputBytes);
            System.setOut(printStream);
            try {
                PredictCsv.main((String[])new String[]{"--mojo", modelFile.getAbsolutePath(), "--input", TestUtil.makeNfsFileVec((String)"smalldata/junit/iris.csv").getPath(), "--output", outputFile.getAbsolutePath()});
                Assert.fail((String)"Expected PredictCSV to exit");
            }
            catch (PreventedExitException e) {
                Assert.assertEquals((long)0L, (long)e.status);
            }
            predictCsvOutput = new String(outputBytes.toByteArray());
            Assert.assertTrue((boolean)predictCsvOutput.isEmpty());
        }
        catch (Throwable throwable) {
            System.setOut(originaOutputStream);
            System.out.print(predictCsvOutput);
            Scope.exit((Key[])new Key[0]);
            throw throwable;
        }
        System.setOut(originaOutputStream);
        System.out.print(predictCsvOutput);
        Scope.exit((Key[])new Key[0]);
    }

    private static class PreventExitSecurityManager
    extends SecurityManager {
        private PreventExitSecurityManager() {
        }

        @Override
        public void checkPermission(Permission perm) {
        }

        @Override
        public void checkPermission(Permission perm, Object context) {
        }

        @Override
        public void checkExit(int status) {
            throw new PreventedExitException(status);
        }
    }

    protected static class PreventedExitException
    extends SecurityException {
        public final int status;

        public PreventedExitException(int status) {
            this.status = status;
        }
    }
}

