/*
 * Decompiled with CFR 0.152.
 */
package hex.mojo;

import hex.genmodel.MojoModel;
import hex.tree.gbm.GBM;
import hex.tree.gbm.GBMModel;
import hex.tree.gbm.GbmMojoWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import water.Key;
import water.Keyed;
import water.Scope;
import water.TestUtil;
import water.fvec.Frame;
import water.fvec.TestFrameBuilder;

public class MojoIntegrationTest
extends TestUtil {
    @Before
    public void setUp() throws Exception {
        MojoIntegrationTest.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMojo_MultilineCategoricals() throws IOException {
        try {
            Scope.enter();
            Frame trainingFrame = new TestFrameBuilder().withDataForCol(0, new String[]{"L1\n \"\"L1", "L2\n\r", "\nL3\n", "L4\r", "\\", "L6\f", "\rL7\b"}).withDataForCol(1, new String[]{"\"R1", "R2", "R3", "", "   ", "R6\t", "R7\b"}).withUniformVecTypes(2, (byte)4).build();
            Scope.track((Frame[])new Frame[]{trainingFrame});
            GBMModel.GBMParameters parameters = new GBMModel.GBMParameters();
            parameters._train = trainingFrame._key;
            parameters._response_column = trainingFrame._names[trainingFrame.numCols() - 1];
            parameters._seed = 65261L;
            parameters._max_depth = 1;
            parameters._ntrees = 1;
            parameters._min_rows = 1.0;
            GBM gbm = new GBM(parameters);
            GBMModel gbmModel = (GBMModel)gbm.trainModel().get();
            Assert.assertNotNull((Object)gbmModel);
            File originalModelMojoFile = File.createTempFile("mojo", "zip");
            gbmModel.getMojo().writeTo((OutputStream)new FileOutputStream(originalModelMojoFile));
            MojoModel mojoModel = MojoModel.load((String)originalModelMojoFile.getAbsolutePath());
            Assert.assertNotNull((Object)mojoModel);
            for (int i = 0; i < ((GBMModel.GBMOutput)gbmModel._output)._domains.length; ++i) {
                Assert.assertArrayEquals((Object[])((GBMModel.GBMOutput)gbmModel._output)._domains[i], (Object[])mojoModel._domains[i]);
            }
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMojo_parseUnquoted() throws IOException {
        try {
            Scope.enter();
            Frame trainingFrame = new TestFrameBuilder().withDataForCol(0, new String[]{"LVL1", " LVL2  ", "LVL 3 ", " LVL4 "}).withDataForCol(1, new String[]{"RLVL1", "RLVL2", "", "RLVL4"}).withUniformVecTypes(2, (byte)4).build();
            Scope.track((Frame[])new Frame[]{trainingFrame});
            GBMModel.GBMParameters parameters = new GBMModel.GBMParameters();
            parameters._train = trainingFrame._key;
            parameters._response_column = trainingFrame._names[trainingFrame.numCols() - 1];
            parameters._seed = 65261L;
            parameters._max_depth = 1;
            parameters._ntrees = 1;
            parameters._min_rows = 1.0;
            GBM gbm = new GBM(parameters);
            GBMModel gbmModel = (GBMModel)gbm.trainModel().get();
            Scope.track_generic((Keyed)gbmModel);
            Assert.assertNotNull((Object)gbmModel);
            File originalModelMojoFile = File.createTempFile("mojo", "zip");
            new OldDomainSerializationGBMMojoWriter(gbmModel).writeTo(new FileOutputStream(originalModelMojoFile));
            MojoModel mojoModel = MojoModel.load((String)originalModelMojoFile.getAbsolutePath());
            Assert.assertNotNull((Object)mojoModel);
            for (int i = 0; i < ((GBMModel.GBMOutput)gbmModel._output)._domains.length; ++i) {
                Assert.assertArrayEquals((Object[])((GBMModel.GBMOutput)gbmModel._output)._domains[i], (Object[])mojoModel._domains[i]);
            }
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    private static final class OldDomainSerializationGBMMojoWriter
    extends GbmMojoWriter {
        public OldDomainSerializationGBMMojoWriter(GBMModel model) {
            super(model);
        }

        protected void writeDomains() throws IOException {
            int domIndex = 0;
            for (String[] domain : ((GBMModel.GBMOutput)((GBMModel)this.model)._output)._domains) {
                if (domain == null) continue;
                this.startWritingTextFile(String.format("domains/d%03d.txt", domIndex++));
                for (String category : domain) {
                    this.writeln(category.replaceAll("\n", "\\n"));
                }
                this.finishWritingTextFile();
            }
        }
    }
}

