/*
 * Decompiled with CFR 0.152.
 */
package hex.kmeans;

import hex.ModelMetricsClustering;
import hex.SplitFrame;
import hex.genmodel.easy.EasyPredictModelWrapper;
import hex.kmeans.KMeans;
import hex.kmeans.KMeansModel;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import water.DKV;
import water.Key;
import water.Keyed;
import water.Scope;
import water.TestUtil;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.fvec.Frame;
import water.fvec.NFSFileVec;
import water.fvec.Vec;
import water.parser.ParseDataset;
import water.util.ArrayUtils;
import water.util.FileUtils;
import water.util.FrameUtils;
import water.util.JCodeGen;
import water.util.Log;
import water.util.MathUtils;
import water.util.RandomUtils;

public class KMeansTest
extends TestUtil {
    public final double threshold = 1.0E-6;
    double _ref_betweenss = 429.75370357154713;
    double _ref_tot_withinss = 266.24628336259855;
    double _ref_totss = 695.9999869341457;
    double[] _ref_withinss = new double[]{195.73312749536535, 17.291967560290328, 27.73183120896519};
    long[] _ref_size = new long[]{96L, 32L, 22L};

    @BeforeClass
    public static void setup() {
        KMeansTest.stall_till_cloudsize((int)1);
    }

    private static KMeansModel doSeed(KMeansModel.KMeansParameters parms, long seed) {
        parms._seed = seed;
        KMeans job = new KMeans(parms);
        KMeansModel kmm = (KMeansModel)job.trainModel().get();
        KMeansTest.checkConsistency(kmm);
        for (int i = 0; i < ((KMeansModel.KMeansOutput)kmm._output)._k[((KMeansModel.KMeansOutput)kmm._output)._k.length - 1]; ++i) {
            Assert.assertTrue((String)("Seed: " + seed), (((KMeansModel.KMeansOutput)kmm._output)._size[i] != 0L ? 1 : 0) != 0);
        }
        return kmm;
    }

    private static void checkConsistency(KMeansModel kmm) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIris() {
        KMeansModel kmm = null;
        Frame fr = null;
        Frame fr2 = null;
        try {
            fr = KMeansTest.parse_test_file((String)"smalldata/iris/iris_wheader.csv");
            KMeansModel.KMeansParameters parms = new KMeansModel.KMeansParameters();
            parms._train = fr._key;
            parms._k = 3;
            parms._standardize = true;
            parms._max_iterations = 10;
            parms._init = KMeans.Initialization.Random;
            kmm = KMeansTest.doSeed(parms, 0L);
            double[][] centers = ((KMeansModel.KMeansOutput)kmm._output)._centers_raw;
            for (int k = 0; k < parms._k; ++k) {
                double flower = centers[k][4];
                Assert.assertTrue((String)"categorical column expected", (flower == (double)((int)flower) ? 1 : 0) != 0);
            }
            fr2 = kmm.score(fr);
        }
        finally {
            if (fr != null) {
                fr.delete();
            }
            if (fr2 != null) {
                fr2.delete();
            }
            if (kmm != null) {
                kmm.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIrisAutoK() {
        KMeansModel kmm = null;
        Frame fr = null;
        Frame fr2 = null;
        try {
            fr = KMeansTest.parse_test_file((String)"smalldata/iris/iris_wheader_correct.csv");
            KMeansModel.KMeansParameters parms = new KMeansModel.KMeansParameters();
            parms._train = fr._key;
            parms._ignored_columns = new String[]{"species"};
            parms._k = 100;
            parms._standardize = false;
            parms._estimate_k = true;
            kmm = KMeansTest.doSeed(parms, 0L);
            for (int i = 0; i < ((KMeansModel.KMeansOutput)kmm._output)._centers_raw.length; ++i) {
                Log.info((Object[])new Object[]{Arrays.toString(((KMeansModel.KMeansOutput)kmm._output)._centers_raw[i])});
            }
            Assert.assertEquals((String)"expected 3 centroids", (long)3L, (long)((KMeansModel.KMeansOutput)kmm._output)._k[((KMeansModel.KMeansOutput)kmm._output)._k.length - 1]);
            fr2 = kmm.score(fr);
        }
        finally {
            if (fr != null) {
                fr.delete();
            }
            if (fr2 != null) {
                fr2.delete();
            }
            if (kmm != null) {
                kmm.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWeatherAutoK() {
        KMeansModel kmm = null;
        KMeansModel kmm2 = null;
        Frame fr = null;
        try {
            fr = KMeansTest.parse_test_file((String)"smalldata/junit/weather.csv");
            KMeansModel.KMeansParameters parms = new KMeansModel.KMeansParameters();
            parms._train = fr._key;
            parms._ignored_columns = new String[]{"Date"};
            parms._k = 100;
            parms._max_iterations = 20;
            parms._standardize = true;
            parms._estimate_k = true;
            kmm = KMeansTest.doSeed(parms, 0L);
            for (int i = 0; i < ((KMeansModel.KMeansOutput)kmm._output)._centers_raw.length; ++i) {
                Log.info((Object[])new Object[]{Arrays.toString(((KMeansModel.KMeansOutput)kmm._output)._centers_raw[i])});
            }
            Assert.assertEquals((String)"expected 5 centroids", (long)5L, (long)((KMeansModel.KMeansOutput)kmm._output)._k[((KMeansModel.KMeansOutput)kmm._output)._k.length - 1]);
            double auto = ((KMeansModel.KMeansOutput)kmm._output)._tot_withinss;
            parms._estimate_k = false;
            parms._k = ((KMeansModel.KMeansOutput)kmm._output)._k[((KMeansModel.KMeansOutput)kmm._output)._k.length - 1];
            Random rnd = RandomUtils.getRNG((long[])new long[]{1234L});
            double manual = 0.0;
            double N = 10.0;
            int i = 0;
            while ((double)i < N) {
                kmm2 = KMeansTest.doSeed(parms, rnd.nextLong());
                manual += ((KMeansModel.KMeansOutput)kmm2._output)._tot_withinss;
                Assert.assertEquals((String)"expected 5 centroids", (long)5L, (long)((KMeansModel.KMeansOutput)kmm2._output)._k[((KMeansModel.KMeansOutput)kmm2._output)._k.length - 1]);
                kmm2.remove();
                ++i;
            }
            Log.info((Object[])new Object[]{"estimate_k tot_within_ss: " + auto});
            Log.info((Object[])new Object[]{"manual k=4 tot_within_ss (mean over " + N + " trials): " + (manual /= N)});
        }
        finally {
            if (fr != null) {
                fr.remove();
            }
            if (kmm != null) {
                kmm.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArrests() {
        Frame init = ArrayUtils.frame((double[][])KMeansTest.ard((double[][])new double[][]{KMeansTest.ard((double[])new double[]{13.2, 236.0, 58.0, 21.2}), KMeansTest.ard((double[])new double[]{10.0, 263.0, 48.0, 44.5}), KMeansTest.ard((double[])new double[]{8.1, 294.0, 80.0, 31.0}), KMeansTest.ard((double[])new double[]{8.8, 190.0, 50.0, 19.5})}));
        double totssR = 355807.8216;
        double btwssR = 318155.162076;
        double[] wssR = new double[]{2546.35, 6705.906667, 9136.642857, 19263.76};
        double[][] centersR = KMeansTest.ard((double[][])new double[][]{KMeansTest.ard((double[])new double[]{4.27, 87.55, 59.75, 14.39}), KMeansTest.ard((double[])new double[]{8.214286, 173.285714, 70.642857, 22.842857}), KMeansTest.ard((double[])new double[]{11.766667, 257.916667, 68.416667, 28.933333}), KMeansTest.ard((double[])new double[]{11.95, 316.5, 68.0, 26.7})});
        Frame predR = ArrayUtils.frame((String[])KMeansTest.ar((String[])new String[]{"predict"}), (double[][])KMeansTest.ear((double[])new double[]{1.0, 1.0, 2.0, 0.0, 1.0, 0.0, 3.0, 1.0, 2.0, 0.0, 3.0, 3.0, 1.0, 3.0, 3.0, 3.0, 3.0, 1.0, 3.0, 2.0, 0.0, 1.0, 3.0, 1.0, 0.0, 3.0, 3.0, 1.0, 3.0, 0.0, 1.0, 1.0, 2.0, 3.0, 3.0, 0.0, 0.0, 3.0, 0.0, 1.0, 3.0, 0.0, 0.0, 3.0, 3.0, 0.0, 0.0, 3.0, 3.0, 0.0}));
        KMeansModel kmm = null;
        Frame fr = null;
        Frame fr2 = null;
        try {
            int i;
            fr = KMeansTest.parse_test_file((String)"smalldata/pca_test/USArrests.csv");
            KMeansModel.KMeansParameters parms = new KMeansModel.KMeansParameters();
            parms._train = fr._key;
            parms._k = 4;
            parms._standardize = false;
            parms._init = KMeans.Initialization.User;
            parms._user_points = init._key;
            kmm = KMeansTest.doSeed(parms, 0L);
            double[][] centers = new double[parms._k][];
            for (i = 0; i < parms._k; ++i) {
                centers[i] = (double[])((KMeansModel.KMeansOutput)kmm._output)._centers_raw[i].clone();
            }
            Arrays.sort(centers, new Comparator<double[]>(){

                @Override
                public int compare(double[] a, double[] b) {
                    Double d1 = a[0];
                    Double d2 = b[0];
                    return d1.compareTo(d2);
                }
            });
            for (i = 0; i < centers.length; ++i) {
                Assert.assertArrayEquals((double[])centersR[i], (double[])centers[i], (double)1.0E-6);
            }
            Arrays.sort(((KMeansModel.KMeansOutput)kmm._output)._withinss);
            Assert.assertArrayEquals((double[])wssR, (double[])((KMeansModel.KMeansOutput)kmm._output)._withinss, (double)1.0E-6);
            Assert.assertEquals((double)totssR, (double)((KMeansModel.KMeansOutput)kmm._output)._totss, (double)1.0E-6);
            Assert.assertEquals((double)btwssR, (double)((KMeansModel.KMeansOutput)kmm._output)._betweenss, (double)1.0E-6);
            fr2 = kmm.score(fr);
            Assert.assertTrue((boolean)kmm.testJavaScoring(fr, fr2, 1.0E-15));
            KMeansTest.assertVecEquals((Vec)predR.vec(0), (Vec)fr2.vec(0), (double)1.0E-6);
        }
        finally {
            init.delete();
            predR.delete();
            if (fr != null) {
                fr.delete();
            }
            if (fr2 != null) {
                fr2.delete();
            }
            if (kmm != null) {
                kmm.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBadCluster() {
        Frame fr = null;
        try {
            fr = KMeansTest.parse_test_file((String)"smalldata/iris/iris_wheader.csv");
            KMeansModel.KMeansParameters parms = new KMeansModel.KMeansParameters();
            parms._train = fr._key;
            parms._ignored_columns = new String[]{"class"};
            parms._k = 3;
            parms._standardize = true;
            parms._max_iterations = 10;
            parms._init = KMeans.Initialization.Random;
            KMeansTest.doSeed(parms, 341534765239617L).delete();
            KMeansTest.doSeed(parms, 341579128111283L).delete();
            for (int i = 0; i < 10; ++i) {
                KMeansTest.doSeed(parms, System.nanoTime()).delete();
            }
        }
        finally {
            if (fr != null) {
                fr.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testCovtype() {
        Frame fr = null;
        try {
            File f = FileUtils.locateFile((String)"../datasets/UCI/UCI-large/covtype/covtype.data");
            if (f == null) {
                return;
            }
            NFSFileVec nfs = NFSFileVec.make((File)f);
            fr = ParseDataset.parse((Key)Key.make(), (Key[])new Key[]{nfs._key});
            KMeansModel.KMeansParameters parms = new KMeansModel.KMeansParameters();
            parms._train = fr._key;
            parms._k = 7;
            parms._standardize = true;
            parms._max_iterations = 100;
            parms._init = KMeans.Initialization.Random;
            for (int i = 0; i < 10; ++i) {
                KMeansTest.doSeed(parms, System.nanoTime()).delete();
            }
        }
        finally {
            if (fr != null) {
                fr.delete();
            }
        }
    }

    private double[] d(double ... ds) {
        return ds;
    }

    boolean close(double[] a, double[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (!(Math.abs(a[i] - b[i]) > 1.0E-8)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCentroids() {
        Frame fr = ArrayUtils.frame((double[][])KMeansTest.ard((double[][])new double[][]{this.d(1.0, 0.0, 0.0), this.d(0.0, 1.0, 0.0), this.d(0.0, 0.0, 1.0)}));
        try {
            KMeansModel.KMeansParameters parms = new KMeansModel.KMeansParameters();
            parms._train = fr._key;
            parms._k = 3;
            parms._standardize = true;
            parms._max_iterations = 100;
            parms._init = KMeans.Initialization.Random;
            double[][] exp1 = new double[][]{this.d(1.0, 0.0, 0.0), this.d(0.0, 1.0, 0.0), this.d(0.0, 0.0, 1.0)};
            double[][] exp2 = new double[][]{this.d(0.0, 1.0, 0.0), this.d(1.0, 0.0, 0.0), this.d(0.0, 0.0, 1.0)};
            double[][] exp3 = new double[][]{this.d(0.0, 1.0, 0.0), this.d(0.0, 0.0, 1.0), this.d(1.0, 0.0, 0.0)};
            double[][] exp4 = new double[][]{this.d(1.0, 0.0, 0.0), this.d(0.0, 0.0, 1.0), this.d(0.0, 1.0, 0.0)};
            double[][] exp5 = new double[][]{this.d(0.0, 0.0, 1.0), this.d(1.0, 0.0, 0.0), this.d(0.0, 1.0, 0.0)};
            double[][] exp6 = new double[][]{this.d(0.0, 0.0, 1.0), this.d(0.0, 1.0, 0.0), this.d(1.0, 0.0, 0.0)};
            for (int i = 0; i < 10; ++i) {
                int j;
                KMeansModel kmm = KMeansTest.doSeed(parms, System.nanoTime());
                Assert.assertTrue((((KMeansModel.KMeansOutput)kmm._output)._centers_raw.length == 3 ? 1 : 0) != 0);
                Frame fr2 = kmm.score(fr);
                Assert.assertTrue((boolean)kmm.testJavaScoring(fr, fr2, 1.0E-15));
                fr2.delete();
                boolean gotit = false;
                for (j = 0; j < parms._k; ++j) {
                    gotit |= this.close(exp1[j], ((KMeansModel.KMeansOutput)kmm._output)._centers_raw[j]);
                }
                for (j = 0; j < parms._k; ++j) {
                    gotit |= this.close(exp2[j], ((KMeansModel.KMeansOutput)kmm._output)._centers_raw[j]);
                }
                for (j = 0; j < parms._k; ++j) {
                    gotit |= this.close(exp3[j], ((KMeansModel.KMeansOutput)kmm._output)._centers_raw[j]);
                }
                for (j = 0; j < parms._k; ++j) {
                    gotit |= this.close(exp4[j], ((KMeansModel.KMeansOutput)kmm._output)._centers_raw[j]);
                }
                for (j = 0; j < parms._k; ++j) {
                    gotit |= this.close(exp5[j], ((KMeansModel.KMeansOutput)kmm._output)._centers_raw[j]);
                }
                for (j = 0; j < parms._k; ++j) {
                    gotit |= this.close(exp6[j], ((KMeansModel.KMeansOutput)kmm._output)._centers_raw[j]);
                }
                Assert.assertTrue((boolean)gotit);
                kmm.delete();
            }
        }
        finally {
            if (fr != null) {
                fr.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test1Dimension() {
        Frame fr = ArrayUtils.frame((double[][])KMeansTest.ard((double[][])new double[][]{this.d(1.0, 0.0), this.d(0.0, 0.0), this.d(-1.0, 0.0), this.d(4.0, 0.0), this.d(1.0, 0.0), this.d(2.0, 0.0), this.d(0.0, 0.0), this.d(0.0, 0.0)}));
        Frame fr2 = null;
        try {
            KMeansModel.KMeansParameters parms = new KMeansModel.KMeansParameters();
            parms._train = fr._key;
            parms._k = 2;
            parms._standardize = true;
            parms._max_iterations = 100;
            parms._init = KMeans.Initialization.Furthest;
            for (int i = 0; i < 10; ++i) {
                KMeansModel kmm = KMeansTest.doSeed(parms, System.nanoTime());
                Assert.assertTrue((((KMeansModel.KMeansOutput)kmm._output)._centers_raw.length == 2 ? 1 : 0) != 0);
                fr2 = kmm.score(fr);
                Assert.assertTrue((boolean)kmm.testJavaScoring(fr, fr2, 1.0E-15));
                fr2.delete();
                kmm.delete();
            }
        }
        finally {
            if (fr != null) {
                fr.delete();
            }
            if (fr2 != null) {
                fr2.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=H2OModelBuilderIllegalArgumentException.class)
    public void testTooManyK() {
        Frame fr = ArrayUtils.frame((double[][])KMeansTest.ard((double[][])new double[][]{this.d(1.0, 0.0), this.d(0.0, 0.0), this.d(1.0, 0.0), this.d(2.0, 0.0), this.d(0.0, 0.0), this.d(0.0, 0.0)}));
        Frame fr2 = null;
        KMeansModel kmm = null;
        try {
            KMeansModel.KMeansParameters parms = new KMeansModel.KMeansParameters();
            parms._train = fr._key;
            parms._k = 10;
            kmm = KMeansTest.doSeed(parms, System.nanoTime());
            fr2 = kmm.score(fr);
            Assert.assertTrue((boolean)kmm.testJavaScoring(fr, fr2, 1.0E-15));
        }
        finally {
            if (fr != null) {
                fr.delete();
            }
            if (fr2 != null) {
                fr2.delete();
            }
            if (kmm != null) {
                kmm.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPOJO() {
        Assume.assumeTrue((boolean)JCodeGen.canCompile());
        KMeansModel kmm = null;
        Frame fr = null;
        Frame fr2 = null;
        try {
            fr = KMeansTest.parse_test_file((String)"smalldata/iris/iris_wheader.csv");
            KMeansModel.KMeansParameters parms = new KMeansModel.KMeansParameters();
            parms._train = fr._key;
            parms._k = 3;
            parms._standardize = true;
            parms._max_iterations = 10;
            parms._init = KMeans.Initialization.Random;
            kmm = KMeansTest.doSeed(parms, 0L);
            fr2 = kmm.score(fr);
            Assert.assertTrue((boolean)kmm.testJavaScoring(fr, fr2, 1.0E-15));
        }
        finally {
            if (fr != null) {
                fr.delete();
            }
            if (fr2 != null) {
                fr2.delete();
            }
            if (kmm != null) {
                kmm.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPOJOWithDistances() {
        Assume.assumeTrue((boolean)JCodeGen.canCompile());
        KMeansModel kmm = null;
        Frame fr = null;
        Frame fr2 = null;
        try {
            fr = KMeansTest.parse_test_file((String)"smalldata/iris/iris_wheader.csv");
            KMeansModel.KMeansParameters parms = new KMeansModel.KMeansParameters();
            parms._train = fr._key;
            parms._k = 3;
            parms._standardize = true;
            parms._max_iterations = 10;
            parms._init = KMeans.Initialization.Random;
            kmm = KMeansTest.doSeed(parms, 0L);
            fr2 = kmm.score(fr);
            EasyPredictModelWrapper.Config config = new EasyPredictModelWrapper.Config().setUseExtendedOutput(true);
            Assert.assertTrue((boolean)kmm.testJavaScoring(fr, fr2, config, 1.0E-15, 1.0E-15, 0.1));
        }
        finally {
            if (fr != null) {
                fr.delete();
            }
            if (fr2 != null) {
                fr2.delete();
            }
            if (kmm != null) {
                kmm.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testValidation() {
        KMeansModel kmm = null;
        for (boolean standardize : new boolean[]{true, false}) {
            Frame fr = null;
            Frame fr2 = null;
            Frame tr = null;
            Frame te = null;
            try {
                fr = KMeansTest.parse_test_file((String)"smalldata/iris/iris_wheader.csv");
                SplitFrame sf = new SplitFrame(fr, new double[]{0.5, 0.5}, new Key[]{Key.make((String)"train.hex"), Key.make((String)"test.hex")});
                sf.exec().get();
                Key[] ksplits = sf._destination_frames;
                tr = (Frame)DKV.get((Key)ksplits[0]).get();
                te = (Frame)DKV.get((Key)ksplits[1]).get();
                KMeansModel.KMeansParameters parms = new KMeansModel.KMeansParameters();
                parms._train = ksplits[0];
                parms._valid = ksplits[1];
                parms._k = 3;
                parms._standardize = standardize;
                parms._max_iterations = 10;
                parms._init = KMeans.Initialization.Random;
                kmm = KMeansTest.doSeed(parms, 0L);
                double[][] centers = ((KMeansModel.KMeansOutput)kmm._output)._centers_raw;
                for (int k = 0; k < parms._k; ++k) {
                    double flower = centers[k][4];
                    Assert.assertTrue((String)"categorical column expected", (flower == (double)((int)flower) ? 1 : 0) != 0);
                }
                fr2 = kmm.score(te);
                Assert.assertTrue((boolean)kmm.testJavaScoring(te, fr2, 1.0E-15));
            }
            finally {
                if (tr != null) {
                    tr.delete();
                }
                if (te != null) {
                    te.delete();
                }
                if (fr2 != null) {
                    fr2.delete();
                }
                if (fr != null) {
                    fr.delete();
                }
                if (kmm != null) {
                    kmm.delete();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testValidationSame() {
        for (boolean categorical : new boolean[]{true, false}) {
            for (boolean missing : new boolean[]{false}) {
                for (boolean standardize : new boolean[]{true, false}) {
                    Log.info((Object[])new Object[]{"categorical: " + categorical});
                    Log.info((Object[])new Object[]{"missing: " + missing});
                    Log.info((Object[])new Object[]{"standardize: " + standardize});
                    KMeansModel kmm = null;
                    Frame fr = null;
                    Frame fr2 = null;
                    Frame train = null;
                    Frame valid = null;
                    try {
                        fr = KMeansTest.parse_test_file((String)"smalldata/iris/iris_wheader.csv");
                        if (missing) {
                            FrameUtils.MissingInserter mi = new FrameUtils.MissingInserter(fr._key, 1234L, (double)0.1f);
                            fr = (Frame)mi.execImpl().get();
                        }
                        train = new Frame(Key.make((String)"train"), fr.names(), fr.vecs());
                        DKV.put((Keyed)train);
                        valid = new Frame(Key.make((String)"valid"), fr.names(), fr.vecs());
                        DKV.put((Keyed)valid);
                        KMeansModel.KMeansParameters parms = new KMeansModel.KMeansParameters();
                        parms._train = train._key;
                        parms._valid = valid._key;
                        if (!categorical) {
                            parms._ignored_columns = new String[]{fr._names[4]};
                        }
                        parms._k = 3;
                        parms._standardize = standardize;
                        parms._max_iterations = 10;
                        parms._init = KMeans.Initialization.PlusPlus;
                        kmm = KMeansTest.doSeed(parms, 0L);
                        if (categorical) {
                            double[][] centers = ((KMeansModel.KMeansOutput)kmm._output)._centers_raw;
                            for (int k = 0; k < parms._k; ++k) {
                                double flower = centers[k][4];
                                Assert.assertTrue((String)"categorical column expected", (flower == (double)((int)flower) ? 1 : 0) != 0);
                            }
                        }
                        Assert.assertTrue((boolean)MathUtils.compare((double)((ModelMetricsClustering)((KMeansModel.KMeansOutput)kmm._output)._training_metrics)._totss, (double)((ModelMetricsClustering)((KMeansModel.KMeansOutput)kmm._output)._validation_metrics)._totss, (double)1.0E-6, (double)1.0E-6));
                        Assert.assertTrue((boolean)MathUtils.compare((double)((ModelMetricsClustering)((KMeansModel.KMeansOutput)kmm._output)._training_metrics)._betweenss, (double)((ModelMetricsClustering)((KMeansModel.KMeansOutput)kmm._output)._validation_metrics)._betweenss, (double)1.0E-6, (double)1.0E-6));
                        Assert.assertTrue((boolean)MathUtils.compare((double)((ModelMetricsClustering)((KMeansModel.KMeansOutput)kmm._output)._training_metrics)._tot_withinss, (double)((ModelMetricsClustering)((KMeansModel.KMeansOutput)kmm._output)._validation_metrics)._tot_withinss, (double)1.0E-6, (double)1.0E-6));
                        for (int i = 0; i < parms._k; ++i) {
                            Assert.assertTrue((boolean)MathUtils.compare((double)((ModelMetricsClustering)((KMeansModel.KMeansOutput)kmm._output)._training_metrics)._withinss[i], (double)((ModelMetricsClustering)((KMeansModel.KMeansOutput)kmm._output)._validation_metrics)._withinss[i], (double)1.0E-6, (double)1.0E-6));
                            Assert.assertEquals((long)((ModelMetricsClustering)((KMeansModel.KMeansOutput)kmm._output)._training_metrics)._size[i], (long)((ModelMetricsClustering)((KMeansModel.KMeansOutput)kmm._output)._validation_metrics)._size[i]);
                        }
                        fr2 = kmm.score(fr);
                        Assert.assertTrue((boolean)kmm.testJavaScoring(fr, fr2, 1.0E-15));
                    }
                    finally {
                        if (fr != null) {
                            fr.delete();
                        }
                        if (fr2 != null) {
                            fr2.delete();
                        }
                        if (train != null) {
                            train.delete();
                        }
                        if (valid != null) {
                            valid.delete();
                        }
                        if (kmm != null) {
                            kmm.delete();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNfolds() {
        Frame tfr = null;
        KMeansModel kmeans = null;
        Scope.enter();
        try {
            tfr = KMeansTest.parse_test_file((String)"smalldata/iris/iris_wheader.csv");
            DKV.put((Keyed)tfr);
            KMeansModel.KMeansParameters parms = new KMeansModel.KMeansParameters();
            parms._train = tfr._key;
            parms._seed = 912559L;
            parms._k = 3;
            parms._nfolds = 3;
            KMeans job = new KMeans(parms);
            kmeans = (KMeansModel)job.trainModel().get();
            KMeansTest.checkConsistency(kmeans);
            ModelMetricsClustering mm = (ModelMetricsClustering)((KMeansModel.KMeansOutput)kmeans._output)._cross_validation_metrics;
            Assert.assertEquals((double)this._ref_betweenss, (double)mm._betweenss, (double)1.0E-5);
            Assert.assertEquals((double)this._ref_tot_withinss, (double)mm._tot_withinss, (double)1.0E-5);
            Assert.assertEquals((double)this._ref_totss, (double)mm._totss, (double)1.0E-4);
            for (int i = 0; i < parms._k; ++i) {
                Assert.assertTrue((boolean)MathUtils.compare((double)((ModelMetricsClustering)((KMeansModel.KMeansOutput)kmeans._output)._training_metrics)._withinss[i], (double)this._ref_withinss[i], (double)1.0E-6, (double)1.0E-6));
                Assert.assertEquals((long)((ModelMetricsClustering)((KMeansModel.KMeansOutput)kmeans._output)._training_metrics)._size[i], (long)this._ref_size[i]);
            }
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (kmeans != null) {
                kmeans.deleteCrossValidationModels();
                kmeans.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeColumnPubdev6264() {
        try {
            Scope.enter();
            Frame f = Scope.track((Frame[])new Frame[]{KMeansTest.parse_test_file((String)"smalldata/chicago/chicagoAllWeather.csv")});
            Assert.assertEquals((Object)"Time", (Object)f.vec("date").get_type_str());
            KMeansModel.KMeansParameters parms = new KMeansModel.KMeansParameters();
            parms._train = f._key;
            parms._seed = 3247L;
            parms._k = 3;
            KMeans job = new KMeans(parms);
            KMeansModel kmeans = (KMeansModel)Scope.track_generic((Keyed)job.trainModel().get());
            KMeansTest.checkConsistency(kmeans);
            Assert.assertEquals((Object)"date", (Object)((KMeansModel.KMeansOutput)kmeans._output)._names[0]);
            Assert.assertEquals((long)-1L, (long)((KMeansModel.KMeansOutput)kmeans._output)._mode[0]);
            double minTime = f.vec("date").min();
            double maxTime = f.vec("date").max();
            Assert.assertEquals((long)3L, (long)((KMeansModel.KMeansOutput)kmeans._output)._centers_raw.length);
            for (double[] center : ((KMeansModel.KMeansOutput)kmeans._output)._centers_raw) {
                Assert.assertTrue((center[0] >= minTime ? 1 : 0) != 0);
                Assert.assertTrue((center[0] <= maxTime ? 1 : 0) != 0);
            }
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTrainingMetricFrameIsNotNullPubdev6996() {
        KMeansModel kmeans = null;
        Frame fr = null;
        try {
            fr = KMeansTest.parse_test_file((String)"smalldata/iris/iris_wheader.csv");
            KMeansModel.KMeansParameters parms = new KMeansModel.KMeansParameters();
            parms._train = fr._key;
            parms._k = 3;
            parms._standardize = true;
            parms._max_iterations = 1;
            parms._init = KMeans.Initialization.Random;
            parms._seed = 42L;
            KMeans job = new KMeans(parms);
            kmeans = (KMeansModel)job.trainModel().get();
            Assert.assertNotNull((String)"The training metrics frame key should not be null.", (Object)((KMeansModel.KMeansOutput)kmeans._output)._training_metrics.frame()._key);
        }
        finally {
            if (fr != null) {
                fr.delete();
            }
            if (kmeans != null) {
                kmeans.delete();
            }
        }
    }
}

