/*
 * Decompiled with CFR 0.152.
 */
package hex.kmeans;

import hex.Model;
import hex.kmeans.KMeans;
import hex.kmeans.KMeansModel;
import java.util.Random;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import water.TestUtil;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.Log;

public class KMeansRandomTest
extends TestUtil {
    @BeforeClass
    public static void setup() {
        KMeansRandomTest.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Test
    public void run() {
        long seed = 912559L;
        Random rng = new Random(seed);
        String[] datasets = new String[]{"smalldata/logreg/prostate.csv", "smalldata/iris/iris_wheader.csv", "smalldata/junit/weather.csv"};
        int testcount = 0;
        int count = 0;
        for (String dataset : datasets) {
            Frame frame = KMeansRandomTest.parse_test_file((String)dataset);
            try {
                for (int centers : new int[]{1, 2, 10, 100}) {
                    for (int max_iter : new int[]{1, 10}) {
                        for (boolean estimate_k : new boolean[]{false, true}) {
                            for (boolean standardize : new boolean[]{false, true}) {
                                for (Model.Parameters.CategoricalEncodingScheme catEncoding : Model.Parameters.CategoricalEncodingScheme.values()) {
                                    for (KMeans.Initialization init : new KMeans.Initialization[]{KMeans.Initialization.Random, KMeans.Initialization.Furthest, KMeans.Initialization.PlusPlus}) {
                                        if (catEncoding == Model.Parameters.CategoricalEncodingScheme.SortByResponse) continue;
                                        ++count;
                                        if (rng.nextDouble() > 0.2) continue;
                                        Frame score = null;
                                        KMeansModel m = null;
                                        try {
                                            void var40_41;
                                            KMeansModel.KMeansParameters parms = new KMeansModel.KMeansParameters();
                                            parms._train = frame._key;
                                            if (dataset != null && dataset.equals("smalldata/iris/iris_wheader.csv")) {
                                                parms._ignored_columns = new String[]{"class"};
                                            }
                                            parms._k = centers;
                                            parms._seed = rng.nextLong();
                                            parms._max_iterations = max_iter;
                                            parms._standardize = standardize;
                                            parms._init = init;
                                            parms._estimate_k = estimate_k;
                                            parms._categorical_encoding = catEncoding;
                                            KMeans job = new KMeans(parms);
                                            m = (KMeansModel)job.trainModel().get();
                                            Assert.assertTrue((String)("Progress not 100%, but " + job._job.progress() * 100.0f), ((double)job._job.progress() == 1.0 ? 1 : 0) != 0);
                                            boolean bl = false;
                                            while (var40_41 < ((KMeansModel.KMeansOutput)m._output)._k[((KMeansModel.KMeansOutput)m._output)._k.length - 1]) {
                                                Assert.assertTrue((((KMeansModel.KMeansOutput)m._output)._size[var40_41] != 0L ? 1 : 0) != 0);
                                                ++var40_41;
                                            }
                                            Assert.assertTrue((((KMeansModel.KMeansOutput)m._output)._iterations <= max_iter ? 1 : 0) != 0);
                                            for (double d : ((KMeansModel.KMeansOutput)m._output)._withinss) {
                                                Assert.assertFalse((boolean)Double.isNaN(d));
                                            }
                                            Assert.assertFalse((boolean)Double.isNaN(((KMeansModel.KMeansOutput)m._output)._tot_withinss));
                                            for (long o : ((KMeansModel.KMeansOutput)m._output)._size) {
                                                Assert.assertTrue((o > 0L ? 1 : 0) != 0);
                                            }
                                            double[][] dArray = ((KMeansModel.KMeansOutput)m._output)._centers_raw;
                                            int n = dArray.length;
                                            for (int i = 0; i < n; ++i) {
                                                double[] dc;
                                                for (double d : dc = dArray[i]) {
                                                    Assert.assertFalse((boolean)Double.isNaN(d));
                                                }
                                            }
                                            score = m.score(frame);
                                            Vec.Reader reader = new Vec.Reader(score.anyVec());
                                            for (long j2 = 0L; j2 < score.numRows(); ++j2) {
                                                Assert.assertTrue((reader.at8(j2) >= 0L && reader.at8(j2) < (long)((KMeansModel.KMeansOutput)m._output)._k[((KMeansModel.KMeansOutput)m._output)._k.length - 1] ? 1 : 0) != 0);
                                            }
                                            Log.info((Object[])new Object[]{"Parameters combination " + count + ": PASS"});
                                            ++testcount;
                                        }
                                        finally {
                                            if (m != null) {
                                                m.delete();
                                            }
                                            if (score != null) {
                                                score.delete();
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            finally {
                frame.delete();
            }
        }
        Log.info((Object[])new Object[]{"\n\n============================================="});
        Log.info((Object[])new Object[]{"Tested " + testcount + " out of " + count + " parameter combinations."});
        Log.info((Object[])new Object[]{"============================================="});
    }
}

