/*
 * Decompiled with CFR 0.152.
 */
package hex.grid;

import hex.Model;
import hex.ModelParametersBuilderFactory;
import hex.genmodel.utils.DistributionFamily;
import hex.grid.Grid;
import hex.grid.GridSearch;
import hex.grid.HyperSpaceSearchCriteria;
import hex.tree.gbm.GBMModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import water.AutoBuffer;
import water.Freezable;
import water.Job;
import water.Key;
import water.Keyed;
import water.Scope;
import water.TestUtil;
import water.fvec.Frame;

public class GridTest
extends TestUtil {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Before
    public void setUp() {
        TestUtil.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParallelModelTimeConstraint() {
        try {
            Scope.enter();
            Frame trainingFrame = GridTest.parse_test_file((String)"./smalldata/testng/airlines_train.csv");
            Scope.track((Frame[])new Frame[]{trainingFrame});
            final Integer[] ntreesArr = new Integer[]{5, 50, 7, 8, 9, 10, 500};
            final Integer[] maxDepthArr = new Integer[]{2, 3, 4};
            HashMap<String, Object[]> hyperParms = new HashMap<String, Object[]>(){
                {
                    this.put("_distribution", new DistributionFamily[]{DistributionFamily.multinomial});
                    this.put("_ntrees", ntreesArr);
                    this.put("_max_depth", maxDepthArr);
                }
            };
            GBMModel.GBMParameters params = new GBMModel.GBMParameters();
            params._train = trainingFrame._key;
            params._response_column = "IsDepDelayed";
            params._seed = 42L;
            HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria searchCriteria = new HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria();
            Job gridSearch = GridSearch.startGridSearch(null, (Model.Parameters)params, (Map)hyperParms, (ModelParametersBuilderFactory)new GridSearch.SimpleParametersBuilderFactory(), (HyperSpaceSearchCriteria)searchCriteria, (int)2);
            searchCriteria.set_max_runtime_secs(1.0);
            Scope.track_generic((Keyed)gridSearch);
            Grid grid = (Grid)gridSearch.get();
            Scope.track_generic((Keyed)grid);
            Assert.assertNotEquals((long)(ntreesArr.length * maxDepthArr.length), (long)grid.getModelCount());
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParallelUserStopRequest() {
        try {
            Scope.enter();
            Frame trainingFrame = GridTest.parse_test_file((String)"./smalldata/testng/airlines_train.csv");
            Scope.track((Frame[])new Frame[]{trainingFrame});
            final Integer[] ntreesArr = new Integer[]{5, 50, 7, 8, 9, 10, 500};
            final Integer[] maxDepthArr = new Integer[]{2, 3, 4, 50};
            HashMap<String, Object[]> hyperParms = new HashMap<String, Object[]>(){
                {
                    this.put("_distribution", new DistributionFamily[]{DistributionFamily.multinomial});
                    this.put("_ntrees", ntreesArr);
                    this.put("_max_depth", maxDepthArr);
                }
            };
            GBMModel.GBMParameters params = new GBMModel.GBMParameters();
            params._train = trainingFrame._key;
            params._response_column = "IsDepDelayed";
            params._seed = 42L;
            Job gridSearch = GridSearch.startGridSearch(null, (Model.Parameters)params, (Map)hyperParms, (ModelParametersBuilderFactory)new GridSearch.SimpleParametersBuilderFactory(), (HyperSpaceSearchCriteria)new HyperSpaceSearchCriteria.CartesianSearchCriteria(), (int)2);
            Scope.track_generic((Keyed)gridSearch);
            gridSearch.stop();
            Grid grid = (Grid)gridSearch.get();
            Scope.track_generic((Keyed)grid);
            for (Model m : grid.getModels()) {
                Scope.track_generic((Keyed)m);
            }
            Assert.assertNotEquals((long)(ntreesArr.length * maxDepthArr.length), (long)grid.getModelCount());
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParallelGridSearch() {
        try {
            Scope.enter();
            Frame trainingFrame = GridTest.parse_test_file((String)"./smalldata/testng/airlines_train.csv");
            Scope.track((Frame[])new Frame[]{trainingFrame});
            final Integer[] ntreesArr = new Integer[]{5, 50, 7, 8, 9, 10};
            final Integer[] maxDepthArr = new Integer[]{2, 3, 4};
            HashMap<String, Object[]> hyperParms = new HashMap<String, Object[]>(){
                {
                    this.put("_distribution", new DistributionFamily[]{DistributionFamily.multinomial});
                    this.put("_ntrees", ntreesArr);
                    this.put("_max_depth", maxDepthArr);
                }
            };
            GBMModel.GBMParameters params = new GBMModel.GBMParameters();
            params._train = trainingFrame._key;
            params._response_column = "IsDepDelayed";
            params._seed = 42L;
            Job gs = GridSearch.startGridSearch(null, (Model.Parameters)params, (Map)hyperParms, (int)5);
            Scope.track_generic((Keyed)gs);
            Grid grid = (Grid)gs.get();
            Scope.track_generic((Keyed)grid);
            Assert.assertEquals((long)(ntreesArr.length * maxDepthArr.length), (long)grid.getModelCount());
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdaptiveParallelGridSearch() {
        try {
            Scope.enter();
            Frame trainingFrame = GridTest.parse_test_file((String)"./smalldata/testng/airlines_train.csv");
            Scope.track((Frame[])new Frame[]{trainingFrame});
            final Integer[] ntreesArr = new Integer[]{5, 50, 7, 8, 9, 10};
            final Integer[] maxDepthArr = new Integer[]{2, 3, 4};
            HashMap<String, Object[]> hyperParms = new HashMap<String, Object[]>(){
                {
                    this.put("_distribution", new DistributionFamily[]{DistributionFamily.multinomial});
                    this.put("_ntrees", ntreesArr);
                    this.put("_max_depth", maxDepthArr);
                }
            };
            GBMModel.GBMParameters params = new GBMModel.GBMParameters();
            params._train = trainingFrame._key;
            params._response_column = "IsDepDelayed";
            params._seed = 42L;
            Job gs = GridSearch.startGridSearch(null, (Model.Parameters)params, (Map)hyperParms, (int)GridSearch.getAdaptiveParallelism());
            Scope.track_generic((Keyed)gs);
            Grid secondGrid = (Grid)gs.get();
            Scope.track_generic((Keyed)secondGrid);
            Assert.assertEquals((long)(ntreesArr.length * maxDepthArr.length), (long)secondGrid.getModelCount());
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFaileH2OdParamsCleanup() {
        try {
            Scope.enter();
            Frame trainingFrame = GridTest.parse_test_file((String)"smalldata/iris/iris_train.csv");
            Scope.track((Frame[])new Frame[]{trainingFrame});
            HashMap<String, Object[]> hyperParms = new HashMap<String, Object[]>(){
                {
                    this.put("_distribution", new DistributionFamily[]{DistributionFamily.multinomial});
                    this.put("_ntrees", new Integer[]{5});
                    this.put("_max_depth", new Integer[]{2});
                    this.put("_min_rows", new Integer[]{5000000});
                    this.put("_learn_rate", new Double[]{0.7});
                }
            };
            GBMModel.GBMParameters params = new GBMModel.GBMParameters();
            params._train = trainingFrame._key;
            params._response_column = "species";
            Job gs = GridSearch.startGridSearch(null, (Model.Parameters)params, (Map)hyperParms);
            Scope.track_generic((Keyed)gs);
            Grid errGrid = (Grid)gs.get();
            Scope.track_generic((Keyed)errGrid);
            Assert.assertEquals((long)0L, (long)errGrid.getModelCount());
            Grid.SearchFailure failures = errGrid.getFailures();
            Assert.assertEquals((long)1L, (long)failures.getFailureCount());
            Assert.assertEquals((long)1L, (long)failures.getFailedParameters().length);
            Assert.assertEquals((long)1L, (long)failures.getFailedRawParameters().length);
            Assert.assertEquals((long)1L, (long)failures.getFailureDetails().length);
            Assert.assertEquals((long)1L, (long)failures.getFailureStackTraces().length);
            String expectedErr = "Details: ERRR on field: _min_rows: The dataset size is too small to split for min_rows=5000000.0: must have at least 1.0E7 (weighted) rows";
            Assert.assertTrue((boolean)failures.getFailureStackTraces()[0].contains("Details: ERRR on field: _min_rows: The dataset size is too small to split for min_rows=5000000.0: must have at least 1.0E7 (weighted) rows"));
            hyperParms.put("_min_rows", new Integer[]{10});
            gs = GridSearch.startGridSearch((Key)errGrid._key, (Model.Parameters)params, (Map)hyperParms);
            Scope.track_generic((Keyed)gs);
            Grid grid = (Grid)gs.get();
            Scope.track_generic((Keyed)grid);
            Assert.assertEquals((long)1L, (long)grid.getModelCount());
            Assert.assertTrue((boolean)(grid.getModels()[0] instanceof GBMModel));
            Assert.assertEquals((double)10.0, (double)((GBMModel.GBMParameters)((GBMModel)grid.getModels()[0])._parms)._min_rows, (double)0.0);
            Grid.SearchFailure secondRunFailures = grid.getFailures();
            Assert.assertEquals((long)0L, (long)secondRunFailures.getFailureCount());
            Assert.assertEquals((long)0L, (long)secondRunFailures.getFailedParameters().length);
            Assert.assertEquals((long)0L, (long)secondRunFailures.getFailedRawParameters().length);
            Assert.assertEquals((long)0L, (long)secondRunFailures.getFailureDetails().length);
            Assert.assertEquals((long)0L, (long)secondRunFailures.getFailureStackTraces().length);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void gridSearchExportCheckpointsDir() throws IOException {
        try {
            Scope.enter();
            Frame trainingFrame = GridTest.parse_test_file((String)"smalldata/iris/iris_train.csv");
            Scope.track((Frame[])new Frame[]{trainingFrame});
            HashMap<String, Object[]> hyperParms = new HashMap<String, Object[]>(){
                {
                    this.put("_distribution", new DistributionFamily[]{DistributionFamily.multinomial});
                    this.put("_ntrees", new Integer[]{5});
                    this.put("_max_depth", new Integer[]{2});
                    this.put("_learn_rate", new Double[]{0.7});
                }
            };
            GBMModel.GBMParameters params = new GBMModel.GBMParameters();
            params._train = trainingFrame._key;
            params._response_column = "species";
            params._export_checkpoints_dir = this.temporaryFolder.newFolder().getAbsolutePath();
            Job gs = GridSearch.startGridSearch(null, (Model.Parameters)params, (Map)hyperParms);
            Scope.track_generic((Keyed)gs);
            Grid originalGrid = (Grid)gs.get();
            Scope.track_generic((Keyed)originalGrid);
            File serializedGridFile = new File(params._export_checkpoints_dir, originalGrid._key.toString());
            Assert.assertTrue((boolean)serializedGridFile.exists());
            Assert.assertTrue((boolean)serializedGridFile.isFile());
            Grid grid = GridTest.loadGridFromFile(serializedGridFile);
            Assert.assertArrayEquals((Object[])originalGrid.getModelKeys(), (Object[])grid.getModelKeys());
            Scope.track_generic((Keyed)grid);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void gridSearchManualExport() throws IOException {
        try {
            Scope.enter();
            Frame trainingFrame = GridTest.parse_test_file((String)"smalldata/iris/iris_train.csv");
            Scope.track((Frame[])new Frame[]{trainingFrame});
            HashMap<String, Object[]> hyperParms = new HashMap<String, Object[]>(){
                {
                    this.put("_distribution", new DistributionFamily[]{DistributionFamily.multinomial});
                    this.put("_ntrees", new Integer[]{5});
                    this.put("_max_depth", new Integer[]{2});
                    this.put("_learn_rate", new Double[]{0.7});
                }
            };
            GBMModel.GBMParameters params = new GBMModel.GBMParameters();
            params._train = trainingFrame._key;
            params._response_column = "species";
            String exportDir = this.temporaryFolder.newFolder().getAbsolutePath();
            Job gs = GridSearch.startGridSearch(null, (Model.Parameters)params, (Map)hyperParms, (int)1);
            Scope.track_generic((Keyed)gs);
            Grid originalGrid = (Grid)gs.get();
            Scope.track_generic((Keyed)originalGrid);
            String originalGridPath = exportDir + "/" + originalGrid._key.toString();
            originalGrid.exportBinary(originalGridPath);
            Assert.assertTrue((boolean)Files.exists(Paths.get(originalGridPath, new String[0]), new LinkOption[0]));
            originalGrid.exportModelsBinary(exportDir);
            for (Model model : originalGrid.getModels()) {
                Assert.assertTrue((boolean)Files.exists(Paths.get(exportDir, model._key.toString()), new LinkOption[0]));
            }
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void gridSearchExportCheckpointsDirParallel() throws IOException {
        try {
            Scope.enter();
            Frame trainingFrame = GridTest.parse_test_file((String)"smalldata/iris/iris_train.csv");
            Scope.track((Frame[])new Frame[]{trainingFrame});
            HashMap<String, Object[]> hyperParms = new HashMap<String, Object[]>(){
                {
                    this.put("_distribution", new DistributionFamily[]{DistributionFamily.multinomial});
                    this.put("_ntrees", new Integer[]{5, 10, 50});
                    this.put("_max_depth", new Integer[]{2, 3});
                    this.put("_learn_rate", new Double[]{0.7});
                }
            };
            GBMModel.GBMParameters params = new GBMModel.GBMParameters();
            params._train = trainingFrame._key;
            params._response_column = "species";
            params._export_checkpoints_dir = this.temporaryFolder.newFolder().getAbsolutePath();
            Job gs = GridSearch.startGridSearch(null, (Model.Parameters)params, (Map)hyperParms, (int)2);
            Scope.track_generic((Keyed)gs);
            Grid originalGrid = (Grid)gs.get();
            Scope.track_generic((Keyed)originalGrid);
            File serializedGridFile = new File(params._export_checkpoints_dir, originalGrid._key.toString());
            Assert.assertTrue((boolean)serializedGridFile.exists());
            Assert.assertTrue((boolean)serializedGridFile.isFile());
            Grid grid = GridTest.loadGridFromFile(serializedGridFile);
            Assert.assertArrayEquals((Object[])originalGrid.getModelKeys(), (Object[])grid.getModelKeys());
            Scope.track_generic((Keyed)grid);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    private static Grid loadGridFromFile(File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            AutoBuffer autoBuffer = new AutoBuffer((InputStream)fileInputStream);
            Freezable possibleGrid = autoBuffer.get();
            Assert.assertTrue((boolean)(possibleGrid instanceof Grid));
            Grid grid = (Grid)possibleGrid;
            return grid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailedParamsRetention() {
        try {
            Scope.enter();
            Frame trainingFrame = GridTest.parse_test_file((String)"smalldata/iris/iris_train.csv");
            Scope.track((Frame[])new Frame[]{trainingFrame});
            HashMap<String, Object[]> hyperParms = new HashMap<String, Object[]>(){
                {
                    this.put("_distribution", new DistributionFamily[]{DistributionFamily.multinomial});
                    this.put("_ntrees", new Integer[]{5});
                    this.put("_max_depth", new Integer[]{2});
                    this.put("_min_rows", new Integer[]{10});
                    this.put("_learn_rate", new Double[]{0.7});
                }
            };
            GBMModel.GBMParameters params = new GBMModel.GBMParameters();
            params._train = trainingFrame._key;
            params._response_column = "species";
            Job gs = GridSearch.startGridSearch(null, (Model.Parameters)params, (Map)hyperParms);
            Scope.track_generic((Keyed)gs);
            Grid errGrid = (Grid)gs.get();
            Scope.track_generic((Keyed)errGrid);
            Assert.assertEquals((long)1L, (long)errGrid.getModelCount());
            Grid.SearchFailure failures = errGrid.getFailures();
            Assert.assertEquals((long)0L, (long)failures.getFailureCount());
            errGrid.appendFailedModelParameters(errGrid.getModels()[0]._key, (Model.Parameters)params, (Throwable)new RuntimeException("Test exception"));
            failures = errGrid.getFailures();
            Assert.assertEquals((long)1L, (long)failures.getFailureCount());
            hyperParms.put("_learn_rate", new Double[]{0.5});
            gs = GridSearch.startGridSearch((Key)errGrid._key, (Model.Parameters)params, (Map)hyperParms);
            Scope.track_generic((Keyed)gs);
            Grid grid = (Grid)gs.get();
            Scope.track_generic((Keyed)grid);
            Assert.assertEquals((long)2L, (long)grid.getModelCount());
            Assert.assertTrue((boolean)(grid.getModels()[0] instanceof GBMModel));
            Assert.assertTrue((boolean)(grid.getModels()[1] instanceof GBMModel));
            Grid.SearchFailure secondRunFailures = grid.getFailures();
            Assert.assertEquals((long)1L, (long)secondRunFailures.getFailureCount());
            String expectedErr = "Test exception";
            Assert.assertTrue((boolean)failures.getFailureStackTraces()[0].contains("Test exception"));
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    @Test
    public void testGetModelKeys() {
        Grid grid = new Grid(null, null, null, null);
        grid.putModel(3L, Key.make((String)"2"));
        grid.putModel(2L, Key.make((String)"1"));
        grid.putModel(1L, Key.make((String)"3"));
        Assert.assertArrayEquals((Object[])new Key[]{Key.make((String)"1"), Key.make((String)"2"), Key.make((String)"3")}, (Object[])grid.getModelKeys());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParallelCartesian() {
        try {
            Scope.enter();
            Frame trainingFrame = GridTest.parse_test_file((String)"smalldata/iris/iris_train.csv");
            Scope.track((Frame[])new Frame[]{trainingFrame});
            HashMap<String, Object[]> hyperParms = new HashMap<String, Object[]>(){
                {
                    this.put("_distribution", new DistributionFamily[]{DistributionFamily.multinomial});
                    this.put("_ntrees", new Integer[]{5});
                    this.put("_max_depth", new Integer[]{2});
                    this.put("_min_rows", new Integer[]{10, 11, 12, 13, 14});
                    this.put("_learn_rate", new Double[]{0.7});
                }
            };
            GBMModel.GBMParameters params = new GBMModel.GBMParameters();
            params._train = trainingFrame._key;
            params._response_column = "species";
            Job gs = GridSearch.startGridSearch(null, (Model.Parameters)params, (Map)hyperParms, (int)2);
            Scope.track_generic((Keyed)gs);
            Grid grid1 = (Grid)gs.get();
            Scope.track_generic((Keyed)grid1);
            Assert.assertEquals((long)5L, (long)grid1.getModelCount());
            hyperParms.put("_learn_rate", new Double[]{0.5});
            gs = GridSearch.startGridSearch((Key)grid1._key, (Model.Parameters)params, (Map)hyperParms, (int)2);
            Scope.track_generic((Keyed)gs);
            Grid grid = (Grid)gs.get();
            Scope.track_generic((Keyed)grid);
            int expectedNumberOfModelsFromTwoGrids = 10;
            Assert.assertEquals((long)expectedNumberOfModelsFromTwoGrids, (long)grid.getModelCount());
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_parallel_random_search_with_max_models_being_less_than_parallelism() {
        try {
            Scope.enter();
            Frame trainingFrame = GridTest.parse_test_file((String)"smalldata/iris/iris_train.csv");
            Scope.track((Frame[])new Frame[]{trainingFrame});
            HashMap<String, Object[]> hyperParms = new HashMap<String, Object[]>(){
                {
                    this.put("_distribution", new DistributionFamily[]{DistributionFamily.multinomial});
                    this.put("_ntrees", new Integer[]{5});
                    this.put("_max_depth", new Integer[]{2});
                    this.put("_min_rows", new Integer[]{10, 11, 12, 13, 14});
                    this.put("_learn_rate", new Double[]{0.7});
                }
            };
            GBMModel.GBMParameters params = new GBMModel.GBMParameters();
            params._train = trainingFrame._key;
            params._response_column = "species";
            GridSearch.SimpleParametersBuilderFactory simpleParametersBuilderFactory = new GridSearch.SimpleParametersBuilderFactory();
            HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria hyperSpaceSearchCriteria = new HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria();
            int custom_max_model = 2;
            hyperSpaceSearchCriteria.set_max_models(custom_max_model);
            Job gs = GridSearch.startGridSearch(null, (Model.Parameters)params, (Map)hyperParms, (ModelParametersBuilderFactory)simpleParametersBuilderFactory, (HyperSpaceSearchCriteria)hyperSpaceSearchCriteria, (int)4);
            Scope.track_generic((Keyed)gs);
            Grid grid1 = (Grid)gs.get();
            Scope.track_generic((Keyed)grid1);
            Assert.assertEquals((long)custom_max_model, (long)grid1.getModelCount());
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_parallel_random_search_with_max_models_being_greater_than_parallelism() {
        try {
            Scope.enter();
            Frame trainingFrame = GridTest.parse_test_file((String)"smalldata/iris/iris_train.csv");
            Scope.track((Frame[])new Frame[]{trainingFrame});
            HashMap<String, Object[]> hyperParms = new HashMap<String, Object[]>(){
                {
                    this.put("_distribution", new DistributionFamily[]{DistributionFamily.multinomial});
                    this.put("_ntrees", new Integer[]{5});
                    this.put("_max_depth", new Integer[]{2});
                    this.put("_min_rows", new Integer[]{10, 11, 12, 13, 14});
                    this.put("_learn_rate", new Double[]{0.7});
                }
            };
            GBMModel.GBMParameters params = new GBMModel.GBMParameters();
            params._train = trainingFrame._key;
            params._response_column = "species";
            GridSearch.SimpleParametersBuilderFactory simpleParametersBuilderFactory = new GridSearch.SimpleParametersBuilderFactory();
            HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria hyperSpaceSearchCriteria = new HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria();
            int custom_max_model = 3;
            hyperSpaceSearchCriteria.set_max_models(custom_max_model);
            Job gs = GridSearch.startGridSearch(null, (Model.Parameters)params, (Map)hyperParms, (ModelParametersBuilderFactory)simpleParametersBuilderFactory, (HyperSpaceSearchCriteria)hyperSpaceSearchCriteria, (int)2);
            Scope.track_generic((Keyed)gs);
            Grid grid1 = (Grid)gs.get();
            Scope.track_generic((Keyed)grid1);
            Assert.assertEquals((long)custom_max_model, (long)grid1.getModelCount());
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }
}

