/*
 * Decompiled with CFR 0.152.
 */
package hex.glrm;

import hex.CreateFrame;
import hex.DataInfo;
import hex.Model;
import hex.ModelMetrics;
import hex.SplitFrame;
import hex.genmodel.algos.glrm.GlrmInitialization;
import hex.genmodel.algos.glrm.GlrmLoss;
import hex.genmodel.algos.glrm.GlrmRegularizer;
import hex.glrm.GLRM;
import hex.glrm.GLRMModel;
import hex.glrm.ModelMetricsGLRM;
import hex.pca.PCA;
import hex.pca.PCAModel;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import water.DKV;
import water.Iced;
import water.IcedWrapper;
import water.Key;
import water.Keyed;
import water.Scope;
import water.TestUtil;
import water.fvec.Frame;
import water.fvec.UploadFileVec;
import water.fvec.Vec;
import water.parser.ParseDataset;
import water.rapids.Rapids;
import water.rapids.Val;
import water.util.ArrayUtils;
import water.util.FileUtils;
import water.util.FrameUtils;
import water.util.Log;
import water.util.TwoDimTable;

public class GLRMTest
extends TestUtil {
    public final double TOLERANCE = 1.0E-6;

    @BeforeClass
    public static void setup() {
        GLRMTest.stall_till_cloudsize((int)1);
    }

    public double errStddev(double[] expected, double[] actual) {
        double err = 0.0;
        for (int i = 0; i < actual.length; ++i) {
            double diff = expected[i] - actual[i];
            err += diff * diff;
        }
        return err;
    }

    public double errEigvec(double[][] expected, double[][] actual) {
        return this.errEigvec(expected, actual, 1.0E-6);
    }

    public double errEigvec(double[][] expected, double[][] actual, double threshold) {
        double err = 0.0;
        for (int j = 0; j < actual[0].length; ++j) {
            boolean flipped = Math.abs(expected[0][j] - actual[0][j]) > threshold;
            for (int i = 0; i < actual.length; ++i) {
                double diff = expected[i][j] - (flipped ? -actual[i][j] : actual[i][j]);
                err += diff * diff;
            }
        }
        return err;
    }

    public static void checkLossbyCol(GLRMModel.GLRMParameters parms, GLRMModel model) {
        int idx;
        int i;
        int ncats = ((GLRMModel.GLRMOutput)model._output)._ncats;
        GlrmLoss[] actual = ((GLRMModel.GLRMOutput)model._output)._lossFunc;
        assert (ncats >= 0 && ncats <= actual.length);
        if (null == parms._loss_by_col || null == parms._loss_by_col_idx) {
            return;
        }
        Assert.assertEquals((long)parms._loss_by_col.length, (long)parms._loss_by_col_idx.length);
        int[] loss_idx_adapt = new int[parms._loss_by_col_idx.length];
        for (i = 0; i < parms._loss_by_col_idx.length; ++i) {
            int idx_adapt = -1;
            for (int j = 0; j < ((GLRMModel.GLRMOutput)model._output)._permutation.length; ++j) {
                if (((GLRMModel.GLRMOutput)model._output)._permutation[j] != parms._loss_by_col_idx[i]) continue;
                idx_adapt = j;
                break;
            }
            loss_idx_adapt[i] = idx_adapt;
        }
        Arrays.sort(loss_idx_adapt);
        for (i = 0; i < ncats; ++i) {
            idx = Arrays.binarySearch(loss_idx_adapt, i);
            GlrmLoss comp = idx >= 0 ? parms._loss_by_col[idx] : parms._multi_loss;
            Assert.assertEquals((Object)comp, (Object)actual[i]);
        }
        for (i = ncats; i < actual.length; ++i) {
            idx = Arrays.binarySearch(loss_idx_adapt, i);
            GlrmLoss comp = idx >= 0 ? parms._loss_by_col[idx] : parms._loss;
            Assert.assertEquals((Object)comp, (Object)actual[i]);
        }
    }

    @Ignore
    @Test
    public void testSubset() throws InterruptedException, ExecutionException {
        GLRM job = null;
        GLRMModel model = null;
        try {
            FileInputStream is = new FileInputStream(FileUtils.getFile((String)"bigdata/laptop/census/ACS_13_5YR_DP02_cleaned.zip"));
            UploadFileVec.ReadPutStats stats = new UploadFileVec.ReadPutStats();
            UploadFileVec.readPut((String)"train", (InputStream)is, (UploadFileVec.ReadPutStats)stats);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ParseDataset.parse((Key)Key.make((String)"train_parsed"), (Key[])new Key[]{Key.make((String)"train")});
        Frame train = (Frame)DKV.getGet((String)"train_parsed");
        try {
            Log.info((Object[])new Object[]{"num chunks: ", train.anyVec().nChunks()});
            Vec[] acs_zcta_vec = new Vec[]{train.vec(0).toCategoricalVec()};
            Frame acs_zcta_fr = new Frame(Key.make((String)"acs_zcta_fr"), new String[]{"name"}, acs_zcta_vec);
            DKV.put((Keyed)acs_zcta_fr);
            train.remove(0).remove();
            DKV.put((Keyed)train);
            GLRMModel.GLRMParameters parms = new GLRMModel.GLRMParameters();
            parms._train = train._key;
            parms._gamma_x = 0.25;
            parms._gamma_y = 0.5;
            parms._regularization_x = GlrmRegularizer.Quadratic;
            parms._regularization_y = GlrmRegularizer.L1;
            parms._k = 10;
            parms._transform = DataInfo.TransformType.STANDARDIZE;
            parms._max_iterations = 1;
            parms._loss = GlrmLoss.Quadratic;
            try {
                Scope.enter();
                job = new GLRM(parms);
                model = (GLRMModel)job.trainModel().get();
                String s = "(tmp= py_4 (rows (cols_py " + ((GLRMModel.GLRMOutput)model._output)._representation_key + " [0 1]) (tmp= py_3 (| (| (| (| (| (== (tmp= py_2 " + acs_zcta_fr._key + ") \"10065\") (== py_2 \"11219\")) (== py_2 \"66753\")) (== py_2 \"84104\")) (== py_2 \"94086\")) (== py_2 \"95014\")))))";
                Val val = Rapids.exec((String)s);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new RuntimeException(t);
            }
            finally {
                acs_zcta_fr.delete();
                Scope.exit((Key[])new Key[0]);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
        finally {
            if (train != null) {
                train.delete();
            }
            if (model != null) {
                model.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArrests() throws InterruptedException, ExecutionException {
        Frame yinit = ArrayUtils.frame((double[][])GLRMTest.ard((double[][])new double[][]{GLRMTest.ard((double[])new double[]{1.24256408, 0.7828393, -0.5209066, -0.003416473}), GLRMTest.ard((double[])new double[]{0.50786248, 1.1068225, -1.2117642, 2.484202941}), GLRMTest.ard((double[])new double[]{0.07163341, 1.4788032, 0.9989801, 1.042878388})}));
        GLRM job = null;
        GLRMModel model = null;
        Frame train = null;
        long seed = 1234L;
        try {
            train = GLRMTest.parse_test_file((Key)Key.make((String)"arrests.hex"), (String)"smalldata/pca_test/USArrests.csv");
            GLRMModel.GLRMParameters parms = new GLRMModel.GLRMParameters();
            parms._train = train._key;
            parms._gamma_y = 0.5;
            parms._gamma_x = 0.5;
            parms._regularization_x = GlrmRegularizer.Quadratic;
            parms._regularization_y = GlrmRegularizer.Quadratic;
            parms._k = 3;
            parms._transform = DataInfo.TransformType.STANDARDIZE;
            parms._init = GlrmInitialization.User;
            parms._recover_svd = false;
            parms._user_y = yinit._key;
            parms._seed = seed;
            job = new GLRM(parms);
            model = (GLRMModel)job.trainModel().get();
            Log.info((Object[])new Object[]{"Iteration " + ((GLRMModel.GLRMOutput)model._output)._iterations + ": Objective value = " + ((GLRMModel.GLRMOutput)model._output)._objective});
            model.score(train).delete();
            ModelMetricsGLRM mm = (ModelMetricsGLRM)ModelMetrics.getFromDKV((Model)model, (Frame)train);
            Log.info((Object[])new Object[]{"Numeric Sum of Squared Error = " + mm._numerr + "\tCategorical Misclassification Error = " + mm._caterr});
        }
        finally {
            yinit.delete();
            if (train != null) {
                train.delete();
            }
            if (model != null) {
                model.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBenignSVD() throws InterruptedException, ExecutionException {
        GLRM job = null;
        GLRMModel model = null;
        Frame train = null;
        try {
            train = GLRMTest.parse_test_file((Key)Key.make((String)"benign.hex"), (String)"smalldata/logreg/benign.csv");
            GLRMModel.GLRMParameters parms = new GLRMModel.GLRMParameters();
            parms._train = train._key;
            parms._k = 10;
            parms._gamma_y = 0.25;
            parms._gamma_x = 0.25;
            parms._regularization_x = GlrmRegularizer.Quadratic;
            parms._regularization_y = GlrmRegularizer.Quadratic;
            parms._transform = DataInfo.TransformType.STANDARDIZE;
            parms._init = GlrmInitialization.SVD;
            parms._min_step_size = 1.0E-5;
            parms._recover_svd = false;
            parms._max_iterations = 2000;
            job = new GLRM(parms);
            model = (GLRMModel)job.trainModel().get();
            Log.info((Object[])new Object[]{"Iteration " + ((GLRMModel.GLRMOutput)model._output)._iterations + ": Objective value = " + ((GLRMModel.GLRMOutput)model._output)._objective});
            model.score(train).delete();
            ModelMetricsGLRM mm = (ModelMetricsGLRM)ModelMetrics.getFromDKV((Model)model, (Frame)train);
            Log.info((Object[])new Object[]{"Numeric Sum of Squared Error = " + mm._numerr + "\tCategorical Misclassification Error = " + mm._caterr});
        }
        finally {
            if (train != null) {
                train.delete();
            }
            if (model != null) {
                model.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArrestsSVD() throws InterruptedException, ExecutionException {
        Frame yinit = ArrayUtils.frame((double[][])GLRMTest.ard((double[][])new double[][]{GLRMTest.ard((double[])new double[]{1.24256408, 0.7828393, -0.5209066, -0.003416473}), GLRMTest.ard((double[])new double[]{0.50786248, 1.1068225, -1.2117642, 2.484202941}), GLRMTest.ard((double[])new double[]{0.07163341, 1.4788032, 0.9989801, 1.042878388}), GLRMTest.ard((double[])new double[]{0.23234938, 0.230868, -1.0735927, -0.184916602})}));
        double[] sval = new double[]{11.024148, 6.964086, 4.179904, 2.915146};
        double[][] eigvec = GLRMTest.ard((double[][])new double[][]{GLRMTest.ard((double[])new double[]{-0.5358995, 0.4181809, -0.3412327, 0.6492278}), GLRMTest.ard((double[])new double[]{-0.5831836, 0.1879856, -0.2681484, -0.74340748}), GLRMTest.ard((double[])new double[]{-0.2781909, -0.8728062, -0.3780158, 0.13387773}), GLRMTest.ard((double[])new double[]{-0.5434321, -0.1673186, 0.8177779, 0.08902432})});
        GLRMModel model = null;
        Frame train = null;
        try {
            train = GLRMTest.parse_test_file((Key)Key.make((String)"arrests.hex"), (String)"smalldata/pca_test/USArrests.csv");
            GLRMModel.GLRMParameters parms = new GLRMModel.GLRMParameters();
            parms._train = train._key;
            parms._k = 4;
            parms._transform = DataInfo.TransformType.STANDARDIZE;
            parms._init = GlrmInitialization.User;
            parms._user_y = yinit._key;
            parms._max_iterations = 1000;
            parms._min_step_size = 1.0E-8;
            parms._recover_svd = true;
            GLRM job = new GLRM(parms);
            model = (GLRMModel)job.trainModel().get();
            Log.info((Object[])new Object[]{"Iteration " + ((GLRMModel.GLRMOutput)model._output)._iterations + ": Objective value = " + ((GLRMModel.GLRMOutput)model._output)._objective});
            model.score(train).delete();
            ModelMetricsGLRM mm = (ModelMetricsGLRM)ModelMetrics.getFromDKV((Model)model, (Frame)train);
            Log.info((Object[])new Object[]{"Numeric Sum of Squared Error = " + mm._numerr + "\tCategorical Misclassification Error = " + mm._caterr});
            Assert.assertEquals((double)((GLRMModel.GLRMOutput)model._output)._objective, (double)mm._numerr, (double)1.0E-6);
        }
        finally {
            yinit.delete();
            if (train != null) {
                train.delete();
            }
            if (model != null) {
                model.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArrestsPlusPlus() throws InterruptedException, ExecutionException {
        GLRMModel model = null;
        Frame train = null;
        try {
            train = GLRMTest.parse_test_file((Key)Key.make((String)"arrests.hex"), (String)"smalldata/pca_test/USArrests.csv");
            GLRMModel.GLRMParameters parms = new GLRMModel.GLRMParameters();
            parms._train = train._key;
            parms._k = 4;
            parms._loss = GlrmLoss.Huber;
            parms._regularization_x = GlrmRegularizer.NonNegative;
            parms._regularization_y = GlrmRegularizer.NonNegative;
            parms._gamma_y = 1.0;
            parms._gamma_x = 1.0;
            parms._transform = DataInfo.TransformType.STANDARDIZE;
            parms._init = GlrmInitialization.PlusPlus;
            parms._max_iterations = 100;
            parms._min_step_size = 1.0E-8;
            parms._recover_svd = true;
            GLRM job = new GLRM(parms);
            model = (GLRMModel)job.trainModel().get();
            Log.info((Object[])new Object[]{"Iteration " + ((GLRMModel.GLRMOutput)model._output)._iterations + ": Objective value = " + ((GLRMModel.GLRMOutput)model._output)._objective});
        }
        finally {
            if (train != null) {
                train.delete();
            }
            if (model != null) {
                model.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArrestsMissing() throws InterruptedException, ExecutionException {
        double[] sval = new double[]{11.024148, 6.964086, 4.179904, 2.915146};
        double[][] eigvec = GLRMTest.ard((double[][])new double[][]{GLRMTest.ard((double[])new double[]{-0.5358995, 0.4181809, -0.3412327, 0.6492278}), GLRMTest.ard((double[])new double[]{-0.5831836, 0.1879856, -0.2681484, -0.74340748}), GLRMTest.ard((double[])new double[]{-0.2781909, -0.8728062, -0.3780158, 0.13387773}), GLRMTest.ard((double[])new double[]{-0.5434321, -0.1673186, 0.8177779, 0.08902432})});
        long seed = 1234L;
        Frame train = null;
        GLRMModel model = null;
        TreeMap<Double, Double> sd_map = new TreeMap<Double, Double>();
        TreeMap<Double, Double> ev_map = new TreeMap<Double, Double>();
        StringBuilder sb = new StringBuilder();
        for (double missing_fraction : new double[]{0.0, 0.1, 0.25, 0.5, 0.75, 0.9}) {
            try {
                Scope.enter();
                train = GLRMTest.parse_test_file((Key)Key.make((String)"arrests.hex"), (String)"smalldata/pca_test/USArrests.csv");
                if (missing_fraction > 0.0) {
                    Frame frtmp = new Frame(Key.make(), train.names(), train.vecs());
                    DKV.put((Key)frtmp._key, (Iced)frtmp);
                    FrameUtils.MissingInserter j = new FrameUtils.MissingInserter(frtmp._key, seed, missing_fraction);
                    j.execImpl().get();
                    DKV.remove((Key)frtmp._key);
                }
                GLRMModel.GLRMParameters parms = new GLRMModel.GLRMParameters();
                parms._train = train._key;
                parms._k = train.numCols();
                parms._loss = GlrmLoss.Quadratic;
                parms._regularization_x = GlrmRegularizer.None;
                parms._regularization_y = GlrmRegularizer.None;
                parms._transform = DataInfo.TransformType.STANDARDIZE;
                parms._init = GlrmInitialization.PlusPlus;
                parms._max_iterations = 1000;
                parms._seed = seed;
                parms._recover_svd = true;
                GLRM job = new GLRM(parms);
                model = (GLRMModel)job.trainModel().get();
                Log.info((Object[])new Object[]{100.0 * missing_fraction + "% missing values: Objective = " + ((GLRMModel.GLRMOutput)model._output)._objective});
                double sd_err = this.errStddev(sval, ((GLRMModel.GLRMOutput)model._output)._singular_vals) / (double)parms._k;
                double ev_err = this.errEigvec(eigvec, ((GLRMModel.GLRMOutput)model._output)._eigenvectors_raw) / (double)parms._k;
                Log.info((Object[])new Object[]{"Avg SSE in Std Dev = " + sd_err + "\tAvg SSE in Eigenvectors = " + ev_err});
                sd_map.put(missing_fraction, sd_err);
                ev_map.put(missing_fraction, ev_err);
                model.score(train).delete();
                ModelMetricsGLRM mm = (ModelMetricsGLRM)ModelMetrics.getFromDKV((Model)model, (Frame)train);
                Log.info((Object[])new Object[]{"Numeric Sum of Squared Error = " + mm._numerr + "\tCategorical Misclassification Error = " + mm._caterr});
                Assert.assertEquals((double)((GLRMModel.GLRMOutput)model._output)._objective, (double)mm._numerr, (double)1.0E-6);
                Scope.exit((Key[])new Key[0]);
            }
            finally {
                if (train != null) {
                    train.delete();
                }
                if (model != null) {
                    model.delete();
                }
            }
        }
        sb.append("\nMissing Fraction --> Avg SSE in Std Dev\n");
        for (String s : Arrays.toString(sd_map.entrySet().toArray()).split(",")) {
            sb.append(s.replace("=", " --> ")).append("\n");
        }
        sb.append("\n");
        sb.append("Missing Fraction --> Avg SSE in Eigenvectors\n");
        for (String s : Arrays.toString(ev_map.entrySet().toArray()).split(",")) {
            sb.append(s.replace("=", " --> ")).append("\n");
        }
        Log.info((Object[])new Object[]{sb.toString()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetColumnLoss() throws InterruptedException, ExecutionException {
        GLRM job = null;
        GLRMModel model = null;
        Frame train = null;
        try {
            train = GLRMTest.parse_test_file((Key)Key.make((String)"benign.hex"), (String)"smalldata/logreg/benign.csv");
            GLRMModel.GLRMParameters parms = new GLRMModel.GLRMParameters();
            parms._train = train._key;
            parms._k = 12;
            parms._loss = GlrmLoss.Quadratic;
            parms._loss_by_col = new GlrmLoss[]{GlrmLoss.Absolute, GlrmLoss.Huber};
            parms._loss_by_col_idx = new int[]{2, 5};
            parms._transform = DataInfo.TransformType.STANDARDIZE;
            parms._init = GlrmInitialization.PlusPlus;
            parms._min_step_size = 1.0E-5;
            parms._recover_svd = false;
            parms._max_iterations = 2000;
            job = new GLRM(parms);
            model = (GLRMModel)job.trainModel().get();
            Log.info((Object[])new Object[]{"Iteration " + ((GLRMModel.GLRMOutput)model._output)._iterations + ": Objective value = " + ((GLRMModel.GLRMOutput)model._output)._objective});
            GLRMTest.checkLossbyCol(parms, model);
            model.score(train).delete();
            ModelMetricsGLRM mm = (ModelMetricsGLRM)ModelMetrics.getFromDKV((Model)model, (Frame)train);
            Log.info((Object[])new Object[]{"Numeric Sum of Squared Error = " + mm._numerr + "\tCategorical Misclassification Error = " + mm._caterr});
        }
        finally {
            if (train != null) {
                train.delete();
            }
            if (model != null) {
                model.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGLRMPredMojo() {
        try {
            Scope.enter();
            CreateFrame cf = new CreateFrame();
            Random generator = new Random();
            int numRows = generator.nextInt(10000) + 50000;
            int numCols = generator.nextInt(17) + 3;
            cf.rows = numRows;
            cf.cols = numCols;
            cf.binary_fraction = 0.0;
            cf.string_fraction = 0.0;
            cf.time_fraction = 0.0;
            cf.has_response = false;
            cf.positive_response = true;
            cf.missing_fraction = 0.1;
            cf.seed = System.currentTimeMillis();
            System.out.println("Createframe parameters: rows: " + numRows + " cols:" + numCols + " seed: " + cf.seed);
            Frame trainMultinomial = Scope.track((Frame[])new Frame[]{(Frame)cf.execImpl().get()});
            double tfrac = 0.2;
            SplitFrame sf = new SplitFrame(trainMultinomial, new double[]{1.0 - tfrac, tfrac}, new Key[]{Key.make((String)"train.hex"), Key.make((String)"test.hex")});
            sf.exec().get();
            Key[] ksplits = sf._destination_frames;
            Frame tr = (Frame)DKV.get((Key)ksplits[0]).get();
            Frame te = (Frame)DKV.get((Key)ksplits[1]).get();
            Scope.track((Frame[])new Frame[]{tr});
            Scope.track((Frame[])new Frame[]{te});
            GLRMModel.GLRMParameters parms = new GLRMModel.GLRMParameters();
            parms._train = tr._key;
            parms._k = 3;
            parms._loss = GlrmLoss.Quadratic;
            parms._init = GlrmInitialization.SVD;
            parms._max_iterations = 10;
            parms._regularization_x = GlrmRegularizer.Quadratic;
            parms._gamma_x = 0.0;
            parms._gamma_y = 0.0;
            parms._seed = cf.seed;
            GLRM glrm = new GLRM(parms);
            GLRMModel model = (GLRMModel)glrm.trainModel().get();
            Scope.track_generic((Keyed)model);
            Frame xfactorTr = (Frame)DKV.get((Key)model.gen_representation_key(tr)).get();
            Scope.track((Frame[])new Frame[]{xfactorTr});
            Frame predTr = model.score(tr);
            Scope.track((Frame[])new Frame[]{predTr});
            Assert.assertEquals((long)predTr.numRows(), (long)xfactorTr.numRows());
            Frame predT = model.score(te);
            Scope.track((Frame[])new Frame[]{predT});
            Frame xfactorTe = (Frame)DKV.get((Key)model.gen_representation_key(te)).get();
            Scope.track((Frame[])new Frame[]{xfactorTe});
            Assert.assertEquals((long)predT.numRows(), (long)xfactorTe.numRows());
            Assert.assertTrue((boolean)model.testJavaScoring(te, predT, 1.0E-6, 1.0E-6, 1.0));
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegularizers() throws InterruptedException, ExecutionException {
        Frame init = ArrayUtils.frame((double[][])GLRMTest.ard((double[][])new double[][]{GLRMTest.ard((double[])new double[]{13.2, 236.0, 58.0, 21.2}), GLRMTest.ard((double[])new double[]{10.0, 263.0, 48.0, 44.5}), GLRMTest.ard((double[])new double[]{8.1, 294.0, 80.0, 31.0}), GLRMTest.ard((double[])new double[]{8.8, 190.0, 50.0, 19.5})}));
        GLRM job = null;
        GLRMModel model = null;
        Frame train = null;
        long seed = 1234L;
        try {
            ModelMetricsGLRM mm;
            Scope.enter();
            train = GLRMTest.parse_test_file((Key)Key.make((String)"arrests.hex"), (String)"smalldata/pca_test/USArrests.csv");
            GLRMModel.GLRMParameters parms = new GLRMModel.GLRMParameters();
            parms._train = train._key;
            parms._k = 4;
            parms._init = GlrmInitialization.User;
            parms._user_y = init._key;
            parms._transform = DataInfo.TransformType.NONE;
            parms._recover_svd = false;
            parms._max_iterations = 1000;
            parms._seed = seed;
            Log.info((Object[])new Object[]{"\nNon-negative matrix factorization"});
            parms._gamma_y = 1.0;
            parms._gamma_x = 1.0;
            parms._regularization_x = GlrmRegularizer.NonNegative;
            parms._regularization_y = GlrmRegularizer.NonNegative;
            try {
                job = new GLRM(parms);
                model = (GLRMModel)job.trainModel().get();
                Log.info((Object[])new Object[]{"Iteration " + ((GLRMModel.GLRMOutput)model._output)._iterations + ": Objective value = " + ((GLRMModel.GLRMOutput)model._output)._objective});
                Log.info((Object[])new Object[]{"Archetypes:\n" + ((GLRMModel.GLRMOutput)model._output)._archetypes.toString()});
                model.score(train).delete();
                mm = (ModelMetricsGLRM)ModelMetrics.getFromDKV((Model)model, (Frame)train);
                Log.info((Object[])new Object[]{"Numeric Sum of Squared Error = " + mm._numerr + "\tCategorical Misclassification Error = " + mm._caterr});
            }
            finally {
                if (model != null) {
                    model.delete();
                }
            }
            Log.info((Object[])new Object[]{"\nOrthogonal non-negative matrix factorization"});
            parms._gamma_y = 1.0;
            parms._gamma_x = 1.0;
            parms._regularization_x = GlrmRegularizer.OneSparse;
            parms._regularization_y = GlrmRegularizer.NonNegative;
            try {
                job = new GLRM(parms);
                model = (GLRMModel)job.trainModel().get();
                Log.info((Object[])new Object[]{"Iteration " + ((GLRMModel.GLRMOutput)model._output)._iterations + ": Objective value = " + ((GLRMModel.GLRMOutput)model._output)._objective});
                Log.info((Object[])new Object[]{"Archetypes:\n" + ((GLRMModel.GLRMOutput)model._output)._archetypes.toString()});
                model.score(train).delete();
                mm = (ModelMetricsGLRM)ModelMetrics.getFromDKV((Model)model, (Frame)train);
                Log.info((Object[])new Object[]{"Numeric Sum of Squared Error = " + mm._numerr + "\tCategorical Misclassification Error = " + mm._caterr});
            }
            finally {
                if (model != null) {
                    model.delete();
                }
            }
            Log.info((Object[])new Object[]{"\nQuadratic clustering (k-means)"});
            parms._gamma_x = 1.0;
            parms._gamma_y = 0.0;
            parms._regularization_x = GlrmRegularizer.UnitOneSparse;
            parms._regularization_y = GlrmRegularizer.None;
            try {
                job = new GLRM(parms);
                model = (GLRMModel)job.trainModel().get();
                Log.info((Object[])new Object[]{"Iteration " + ((GLRMModel.GLRMOutput)model._output)._iterations + ": Objective value = " + ((GLRMModel.GLRMOutput)model._output)._objective});
                Log.info((Object[])new Object[]{"Archetypes:\n" + ((GLRMModel.GLRMOutput)model._output)._archetypes.toString()});
                model.score(train).delete();
                mm = (ModelMetricsGLRM)ModelMetrics.getFromDKV((Model)model, (Frame)train);
                Log.info((Object[])new Object[]{"Numeric Sum of Squared Error = " + mm._numerr + "\tCategorical Misclassification Error = " + mm._caterr});
            }
            finally {
                if (model != null) {
                    model.delete();
                }
            }
            Log.info((Object[])new Object[]{"\nQuadratic mixture (soft k-means)"});
            parms._gamma_x = 1.0;
            parms._gamma_y = 0.0;
            parms._regularization_x = GlrmRegularizer.UnitOneSparse;
            parms._regularization_y = GlrmRegularizer.None;
            try {
                job = new GLRM(parms);
                model = (GLRMModel)job.trainModel().get();
                Log.info((Object[])new Object[]{"Iteration " + ((GLRMModel.GLRMOutput)model._output)._iterations + ": Objective value = " + ((GLRMModel.GLRMOutput)model._output)._objective});
                Log.info((Object[])new Object[]{"Archetypes:\n" + ((GLRMModel.GLRMOutput)model._output)._archetypes.toString()});
                model.score(train).delete();
                mm = (ModelMetricsGLRM)ModelMetrics.getFromDKV((Model)model, (Frame)train);
                Log.info((Object[])new Object[]{"Numeric Sum of Squared Error = " + mm._numerr + "\tCategorical Misclassification Error = " + mm._caterr});
            }
            finally {
                if (model != null) {
                    model.delete();
                }
            }
        }
        finally {
            init.delete();
            if (train != null) {
                train.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArrestsVarianceMetrics() throws InterruptedException, ExecutionException {
        double[] stddev = new double[]{83.7324, 14.212402, 6.489426, 2.48279};
        double[][] eigvec = GLRMTest.ard((double[][])new double[][]{GLRMTest.ard((double[])new double[]{0.04170432, -0.04482166, 0.07989066, -0.99492173}), GLRMTest.ard((double[])new double[]{0.99522128, -0.05876003, -0.06756974, 0.0389383}), GLRMTest.ard((double[])new double[]{0.04633575, 0.97685748, -0.20054629, -0.05816914}), GLRMTest.ard((double[])new double[]{0.0751555, 0.20071807, 0.97408059, 0.07232502})});
        double[] stddev_std = new double[]{1.5748783, 0.9948694, 0.5971291, 0.4164494};
        double[][] eigvec_std = GLRMTest.ard((double[][])new double[][]{GLRMTest.ard((double[])new double[]{-0.5358995, 0.4181809, -0.3412327, 0.6492278}), GLRMTest.ard((double[])new double[]{-0.5831836, 0.1879856, -0.2681484, -0.74340748}), GLRMTest.ard((double[])new double[]{-0.2781909, -0.8728062, -0.3780158, 0.13387773}), GLRMTest.ard((double[])new double[]{-0.5434321, -0.1673186, 0.8177779, 0.08902432})});
        Frame train = null;
        PCAModel model = null;
        GLRMModel gmodel = null;
        try {
            train = GLRMTest.parse_test_file((Key)Key.make((String)"arrests.hex"), (String)"smalldata/pca_test/USArrests.csv");
            for (DataInfo.TransformType std : new DataInfo.TransformType[]{DataInfo.TransformType.DEMEAN, DataInfo.TransformType.STANDARDIZE}) {
                try {
                    PCAModel.PCAParameters parms = new PCAModel.PCAParameters();
                    parms._train = train._key;
                    parms._k = 4;
                    parms._transform = std;
                    parms._max_iterations = 1000;
                    parms._pca_method = PCAModel.PCAParameters.Method.Power;
                    model = (PCAModel)new PCA(parms).trainModel().get();
                    GLRMModel.GLRMParameters gparms = new GLRMModel.GLRMParameters();
                    gparms._train = train._key;
                    gparms._k = 4;
                    gparms._transform = std;
                    gparms._loss = GlrmLoss.Quadratic;
                    gparms._init = GlrmInitialization.SVD;
                    gparms._max_iterations = 2000;
                    gparms._gamma_x = 0.0;
                    gparms._gamma_y = 0.0;
                    gparms._recover_svd = true;
                    gmodel = (GLRMModel)new GLRM(gparms).trainModel().get();
                    assert (gmodel != null);
                    IcedWrapper[][] pcaInfo = ((PCAModel.PCAOutput)model._output)._importance.getCellValues();
                    IcedWrapper[][] glrmInfo = ((GLRMModel.GLRMOutput)gmodel._output)._importance.getCellValues();
                    if (std == DataInfo.TransformType.DEMEAN) {
                        TestUtil.checkStddev((double[])stddev, (double[])((PCAModel.PCAOutput)model._output)._std_deviation, (double)1.0E-6);
                        TestUtil.checkEigvec((double[][])eigvec, (TwoDimTable)((PCAModel.PCAOutput)model._output)._eigenvectors, (double)1.0E-6);
                    } else if (std == DataInfo.TransformType.STANDARDIZE) {
                        TestUtil.checkStddev((double[])stddev_std, (double[])((PCAModel.PCAOutput)model._output)._std_deviation, (double)1.0E-6);
                        TestUtil.checkEigvec((double[][])eigvec_std, (TwoDimTable)((PCAModel.PCAOutput)model._output)._eigenvectors, (double)1.0E-6);
                    }
                    TestUtil.checkIcedArrays((IcedWrapper[][])((PCAModel.PCAOutput)model._output)._importance.getCellValues(), (IcedWrapper[][])((GLRMModel.GLRMOutput)gmodel._output)._importance.getCellValues(), (double)1.0E-6);
                }
                finally {
                    if (model != null) {
                        model.delete();
                    }
                    if (gmodel != null) {
                        gmodel.delete();
                    }
                }
            }
        }
        finally {
            if (train != null) {
                train.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWideDataSetGLRMCat() throws InterruptedException, ExecutionException {
        Scope.enter();
        GLRMModel modelN = null;
        GLRMModel modelW = null;
        Frame train = null;
        Frame scoreN = null;
        Frame scoreW = null;
        double tolerance = 1.0E-6;
        try {
            train = GLRMTest.parse_test_file((Key)Key.make((String)"Prostrate_CAT"), (String)"smalldata/prostate/prostate_cat.csv");
            train.vec(0).setNA(0L);
            train.vec(3).setNA(10L);
            train.vec(5).setNA(20L);
            Scope.track((Frame[])new Frame[]{train});
            DKV.put((Keyed)train);
            GLRMModel.GLRMParameters parms = new GLRMModel.GLRMParameters();
            parms._train = train._key;
            parms._k = 3;
            parms._transform = DataInfo.TransformType.DEMEAN;
            parms._seed = 12345L;
            parms._gamma_x = 1.0;
            parms._gamma_y = 0.5;
            if (!Arrays.asList(train.typesStr()).contains("Enum")) {
                parms._init = GlrmInitialization.SVD;
            }
            parms._regularization_x = GlrmRegularizer.Quadratic;
            parms._regularization_y = GlrmRegularizer.Quadratic;
            parms._recover_svd = true;
            GLRM glrmParms = new GLRM(parms);
            modelN = (GLRMModel)glrmParms.trainModel().get();
            scoreN = modelN.score(train);
            Scope.track((Frame[])new Frame[]{scoreN});
            Scope.track_generic((Keyed)modelN);
            GLRM glrmParmsW = new GLRM(parms);
            glrmParmsW.setWideDataset(true);
            modelW = (GLRMModel)glrmParmsW.trainModel().get();
            scoreW = modelW.score(train);
            Scope.track((Frame[])new Frame[]{scoreW});
            Scope.track_generic((Keyed)modelW);
            TestUtil.checkStddev((double[])((GLRMModel.GLRMOutput)modelW._output)._std_deviation, (double[])((GLRMModel.GLRMOutput)modelN._output)._std_deviation, (double)tolerance);
            boolean[] flippedArch = TestUtil.checkEigvec((double[][])((GLRMModel.GLRMOutput)modelN._output)._archetypes_raw._archetypes, (double[][])((GLRMModel.GLRMOutput)modelW._output)._archetypes_raw._archetypes, (double)tolerance);
            boolean[] flippedEig = TestUtil.checkEigvec((TwoDimTable)((GLRMModel.GLRMOutput)modelW._output)._eigenvectors, (TwoDimTable)((GLRMModel.GLRMOutput)modelN._output)._eigenvectors, (double)tolerance);
            Assert.assertTrue((boolean)Arrays.equals(flippedArch, flippedEig));
            TestUtil.assertIdenticalUpToRelTolerance((Frame)scoreW, (Frame)scoreN, (double)tolerance);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWideDataSetGLRMDec() throws InterruptedException, ExecutionException {
        Scope.enter();
        GLRMModel modelN = null;
        GLRMModel modelW = null;
        Frame train = null;
        Frame scoreN = null;
        Frame scoreW = null;
        double tolerance = 1.0E-6;
        try {
            train = GLRMTest.parse_test_file((Key)Key.make((String)"deacathlon"), (String)"smalldata/pca_test/decathlon.csv");
            Scope.track((Frame[])new Frame[]{train});
            DKV.put((Keyed)train);
            GLRMModel.GLRMParameters parms = new GLRMModel.GLRMParameters();
            parms._train = train._key;
            parms._k = 3;
            parms._transform = DataInfo.TransformType.NONE;
            parms._seed = 12345L;
            parms._gamma_x = 1.0;
            parms._gamma_y = 0.5;
            if (!Arrays.asList(train.typesStr()).contains("Enum")) {
                parms._init = GlrmInitialization.SVD;
            }
            parms._regularization_x = GlrmRegularizer.Quadratic;
            parms._regularization_y = GlrmRegularizer.Quadratic;
            parms._recover_svd = true;
            GLRM glrmParms = new GLRM(parms);
            modelN = (GLRMModel)glrmParms.trainModel().get();
            scoreN = modelN.score(train);
            Scope.track((Frame[])new Frame[]{scoreN});
            Scope.track_generic((Keyed)modelN);
            GLRM glrmParmsW = new GLRM(parms);
            glrmParmsW.setWideDataset(true);
            modelW = (GLRMModel)glrmParmsW.trainModel().get();
            scoreW = modelW.score(train);
            Scope.track((Frame[])new Frame[]{scoreW});
            Scope.track_generic((Keyed)modelW);
            TestUtil.checkStddev((double[])((GLRMModel.GLRMOutput)modelW._output)._std_deviation, (double[])((GLRMModel.GLRMOutput)modelN._output)._std_deviation, (double)tolerance);
            boolean[] flippedArch = TestUtil.checkEigvec((double[][])((GLRMModel.GLRMOutput)modelN._output)._archetypes_raw._archetypes, (double[][])((GLRMModel.GLRMOutput)modelW._output)._archetypes_raw._archetypes, (double)tolerance);
            boolean[] flippedEig = TestUtil.checkEigvec((TwoDimTable)((GLRMModel.GLRMOutput)modelW._output)._eigenvectors, (TwoDimTable)((GLRMModel.GLRMOutput)modelN._output)._eigenvectors, (double)tolerance);
            Assert.assertTrue((boolean)Arrays.equals(flippedArch, flippedEig));
            TestUtil.assertIdenticalUpToRelTolerance((Frame)scoreW, (Frame)scoreN, (double)tolerance);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }
}

