/*
 * Decompiled with CFR 0.152.
 */
package hex.glrm;

import hex.DataInfo;
import hex.Model;
import hex.genmodel.algos.glrm.GlrmInitialization;
import hex.genmodel.algos.glrm.GlrmLoss;
import hex.glrm.GLRMModel;
import hex.grid.Grid;
import hex.grid.GridSearch;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import water.Job;
import water.Key;
import water.TestUtil;
import water.fvec.Frame;
import water.util.ArrayUtils;

public class GLRMGridTest
extends TestUtil {
    @BeforeClass
    public static void setup() {
        GLRMGridTest.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleGridInvocation() {
        Grid grid = null;
        Frame fr = null;
        try {
            fr = GLRMGridTest.parse_test_file((String)"smalldata/iris/iris_wheader.csv");
            HashMap<String, Object[]> hyperParms = new HashMap<String, Object[]>(){
                {
                    this.put("_k", new Integer[]{2, 4});
                    this.put("_transform", new DataInfo.TransformType[]{DataInfo.TransformType.NONE, DataInfo.TransformType.DEMEAN});
                }
            };
            Object[] hyperParamNames = hyperParms.keySet().toArray(new String[hyperParms.size()]);
            Arrays.sort(hyperParamNames);
            int hyperSpaceSize = ArrayUtils.crossProductSize((Map)hyperParms);
            GLRMModel.GLRMParameters params = new GLRMModel.GLRMParameters();
            params._train = fr._key;
            params._seed = 4224L;
            params._loss = GlrmLoss.Absolute;
            params._init = GlrmInitialization.SVD;
            int ITER_CNT = 2;
            Key[][] modelKeys = new Key[2][];
            Key gridKey = Key.make((String)("GLRM_grid_iris" + Key.rand()));
            for (int i = 0; i < 2; ++i) {
                Job gs = GridSearch.startGridSearch((Key)gridKey, (Model.Parameters)params, (Map)hyperParms);
                grid = (Grid)gs.get();
                modelKeys[i] = grid.getModelKeys();
                Grid.SearchFailure failures = grid.getFailures();
                Assert.assertEquals((String)"Size of grid should match to size of hyper space", (long)hyperSpaceSize, (long)(grid.getModelCount() + failures.getFailureCount()));
                Object[] gridHyperNames = grid.getHyperNames();
                Arrays.sort(gridHyperNames);
                Assert.assertArrayEquals((String)"Hyper parameters names should match!", (Object[])hyperParamNames, (Object[])gridHyperNames);
            }
            Assert.assertArrayEquals((String)"The model keys should be same between two iterations!", (Object[])modelKeys[0], (Object[])modelKeys[1]);
        }
        finally {
            if (fr != null) {
                fr.remove();
            }
            if (grid != null) {
                grid.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGridAppend() {
        Grid grid = null;
        Frame fr = null;
        try {
            fr = GLRMGridTest.parse_test_file((String)"smalldata/iris/iris_wheader.csv");
            HashMap<String, Object[]> hyperParms = new HashMap<String, Object[]>(){
                {
                    this.put("_k", new Integer[]{2, 4});
                    this.put("_transform", new DataInfo.TransformType[]{DataInfo.TransformType.NONE, DataInfo.TransformType.DEMEAN});
                }
            };
            Object[] hyperParamNames1 = hyperParms.keySet().toArray(new String[hyperParms.size()]);
            Arrays.sort(hyperParamNames1);
            int hyperSpaceSize1 = ArrayUtils.crossProductSize((Map)hyperParms);
            GLRMModel.GLRMParameters params = new GLRMModel.GLRMParameters();
            params._train = fr._key;
            params._seed = 4224L;
            params._loss = GlrmLoss.Absolute;
            params._init = GlrmInitialization.SVD;
            Key gridKey = Key.make((String)("GLRM_grid_iris" + Key.rand()));
            Job gs1 = GridSearch.startGridSearch((Key)gridKey, (Model.Parameters)params, (Map)hyperParms);
            grid = (Grid)gs1.get();
            Grid.SearchFailure failures = grid.getFailures();
            Assert.assertEquals((String)"Size of grid should match to size of hyper space", (long)hyperSpaceSize1, (long)(grid.getModelCount() + failures.getFailureCount()));
            Object[] gridHyperNames1 = grid.getHyperNames();
            Arrays.sort(gridHyperNames1);
            Assert.assertArrayEquals((String)"Hyper parameters names should match!", (Object[])hyperParamNames1, (Object[])gridHyperNames1);
            hyperParms.put("_k", new Integer[]{3});
            Object[] hyperParamNames2 = hyperParms.keySet().toArray(new String[hyperParms.size()]);
            Arrays.sort(hyperParamNames2);
            int hyperSpaceSize2 = ArrayUtils.crossProductSize((Map)hyperParms);
            Assert.assertArrayEquals((String)"Names of hyperspaces should be same!", (Object[])hyperParamNames1, (Object[])hyperParamNames2);
            Job gs2 = GridSearch.startGridSearch((Key)gridKey, (Model.Parameters)params, (Map)hyperParms);
            grid = (Grid)gs2.get();
            failures = grid.getFailures();
            Assert.assertEquals((String)"Size of grid should match to size of hyper space", (long)(hyperSpaceSize1 + hyperSpaceSize2), (long)(grid.getModelCount() + failures.getFailureCount()));
            Object[] gridHyperNames2 = grid.getHyperNames();
            Arrays.sort(gridHyperNames2);
            Assert.assertArrayEquals((String)"Hyper parameters names should match!", (Object[])hyperParamNames2, (Object[])gridHyperNames2);
            HashSet<String> modelNames = new HashSet<String>(grid.getModelCount());
            for (Key modelKey : grid.getModelKeys()) {
                modelNames.add(modelKey.toString());
            }
            Assert.assertEquals((String)"Model names should be unique!", (long)grid.getModelCount(), (long)modelNames.size());
        }
        finally {
            if (fr != null) {
                fr.remove();
            }
            if (grid != null) {
                grid.remove();
            }
        }
    }
}

