/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import hex.AUC2;
import hex.DataInfo;
import hex.GLMMetrics;
import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsBinomialGLM;
import hex.ModelMetricsMultinomial;
import hex.ModelMetricsRegression;
import hex.ModelMetricsRegressionGLM;
import hex.glm.GLM;
import hex.glm.GLMMetricBuilder;
import hex.glm.GLMModel;
import hex.glm.GLMTask;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import water.DKV;
import water.H2O;
import water.Iced;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.MemoryManager;
import water.Scope;
import water.TestUtil;
import water.fvec.C0DChunk;
import water.fvec.Chunk;
import water.fvec.FVecTest;
import water.fvec.Frame;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.parser.ParseDataset;
import water.util.ArrayUtils;

public class GLMTest
extends TestUtil {
    @BeforeClass
    public static void setup() {
        GLMTest.stall_till_cloudsize((int)1);
    }

    public static void testScoring(GLMModel m, Frame fr) {
        Scope.enter();
        Frame fr2 = new Frame(fr);
        fr2.remove(((GLMModel.GLMOutput)m._output).responseName());
        Frame preds = Scope.track((Frame[])new Frame[]{m.score(fr2)});
        m.adaptTestForTrain(fr2, true, false);
        fr2.remove(fr2.numCols() - 1);
        int p = ((GLMModel.GLMOutput)m._output)._dinfo._cats + ((GLMModel.GLMOutput)m._output)._dinfo._nums;
        int p2 = fr2.numCols() - (((GLMModel.GLMOutput)m._output)._dinfo._weights ? 1 : 0) - (((GLMModel.GLMOutput)m._output)._dinfo._offset ? 1 : 0);
        assert (p == p2) : p + " != " + p2;
        fr2.add(preds.names(), preds.vecs());
        new TestScore0(m, ((GLMModel.GLMOutput)m._output)._dinfo._weights, ((GLMModel.GLMOutput)m._output)._dinfo._offset).doAll(fr2);
        if (!((GLMModel.GLMOutput)m._output)._dinfo._weights && !((GLMModel.GLMOutput)m._output)._dinfo._offset) {
            Assert.assertTrue((boolean)m.testJavaScoring(fr, preds, 1.0E-15));
        }
        Scope.exit((Key[])new Key[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGaussianRegression() throws InterruptedException, ExecutionException {
        Key raw = Key.make((String)"gaussian_test_data_raw");
        Key parsed = Key.make((String)"gaussian_test_data_parsed");
        GLMModel model = null;
        Frame fr = null;
        Object res = null;
        try {
            FVecTest.makeByteVec((Key)raw, (String[])new String[]{"x,y\n0,0\n1,0.1\n2,0.2\n3,0.3\n4,0.4\n5,0.5\n6,0.6\n7,0.7\n8,0.8\n9,0.9"});
            fr = ParseDataset.parse((Key)parsed, (Key[])new Key[]{raw});
            GLMModel.GLMParameters params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.gaussian);
            params._train = fr._key;
            params._response_column = fr._names[1];
            params._lambda = new double[]{0.0};
            model = (GLMModel)new GLM(params).trainModel().get();
            HashMap coefs = model.coefficients();
            Assert.assertEquals((double)0.0, (double)((Double)coefs.get("Intercept")), (double)1.0E-4);
            Assert.assertEquals((double)0.1, (double)((Double)coefs.get("x")), (double)1.0E-4);
            GLMTest.testScoring(model, fr);
        }
        finally {
            if (fr != null) {
                fr.remove();
            }
            if (res != null) {
                res.remove();
            }
            if (model != null) {
                model.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPoissonRegression() throws InterruptedException, ExecutionException {
        Key raw = Key.make((String)"poisson_test_data_raw");
        Key parsed = Key.make((String)"poisson_test_data_parsed");
        GLMModel model = null;
        Frame fr = null;
        Object res = null;
        try {
            FVecTest.makeByteVec((Key)raw, (String[])new String[]{"x,y\n0,2\n1,4\n2,8\n3,16\n4,32\n5,64\n6,128\n7,256"});
            fr = ParseDataset.parse((Key)parsed, (Key[])new Key[]{raw});
            Vec v = fr.vec(0);
            System.out.println(v.min() + ", " + v.max() + ", mean = " + v.mean());
            GLMModel.GLMParameters params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.poisson);
            params._train = fr._key;
            params._response_column = fr._names[1];
            params._lambda = new double[]{0.0};
            params._standardize = false;
            model = (GLMModel)new GLM(params).trainModel().get();
            for (double c : model.beta()) {
                Assert.assertEquals((double)Math.log(2.0), (double)c, (double)0.01);
            }
            GLMTest.testScoring(model, fr);
            model.delete();
            fr.delete();
            FVecTest.makeByteVec((Key)raw, (String[])new String[]{"x,y\n1,0\n2,1\n3,2\n4,3\n5,1\n6,4\n7,9\n8,18\n9,23\n10,31\n11,20\n12,25\n13,37\n14,45\n150,7.193936e+16\n"});
            fr = ParseDataset.parse((Key)parsed, (Key[])new Key[]{raw});
            GLMModel.GLMParameters params2 = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.poisson);
            params2._train = fr._key;
            params2._response_column = fr._names[1];
            params2._lambda = new double[]{0.0};
            params2._standardize = true;
            params2._beta_epsilon = 1.0E-5;
            model = (GLMModel)new GLM(params2).trainModel().get();
            Assert.assertEquals((double)0.3396, (double)model.beta()[1], (double)0.1);
            Assert.assertEquals((double)0.2565, (double)model.beta()[0], (double)0.1);
            GLMTest.testScoring(model, fr);
        }
        finally {
            if (fr != null) {
                fr.delete();
            }
            if (res != null) {
                res.delete();
            }
            if (model != null) {
                model.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGammaRegression() throws InterruptedException, ExecutionException {
        GLMModel model = null;
        Frame fr = null;
        Object res = null;
        try {
            Key raw = Key.make((String)"gamma_test_data_raw");
            Key parsed = Key.make((String)"gamma_test_data_parsed");
            FVecTest.makeByteVec((Key)raw, (String[])new String[]{"x,y\n0,1\n1,0.5\n2,0.3333333\n3,0.25\n4,0.2\n5,0.1666667\n6,0.1428571\n7,0.125"});
            fr = ParseDataset.parse((Key)parsed, (Key[])new Key[]{raw});
            GLMModel.GLMParameters params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.gamma);
            params._response_column = fr._names[1];
            params._train = parsed;
            params._lambda = new double[]{0.0};
            model = (GLMModel)new GLM(params).trainModel().get();
            for (double c : model.beta()) {
                Assert.assertEquals((double)1.0, (double)c, (double)1.0E-4);
            }
            GLMTest.testScoring(model, fr);
        }
        finally {
            if (fr != null) {
                fr.delete();
            }
            if (res != null) {
                res.delete();
            }
            if (model != null) {
                model.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllNAs() {
        Key raw = Key.make((String)"gamma_test_data_raw");
        Key parsed = Key.make((String)"gamma_test_data_parsed");
        FVecTest.makeByteVec((Key)raw, (String[])new String[]{"x,y,z\n1,0,NA\n2,NA,1\nNA,3,2\n4,3,NA\n5,NA,1\nNA,6,4\n7,NA,9\n8,NA,18\nNA,9,23\n10,31,NA\nNA,11,20\n12,NA,25\nNA,13,37\n14,45,NA\n"});
        Frame fr = ParseDataset.parse((Key)parsed, (Key[])new Key[]{raw});
        Object job = null;
        try {
            GLMModel.GLMParameters params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.poisson);
            params._response_column = fr._names[1];
            params._train = parsed;
            params._lambda = new double[]{0.0};
            params._missing_values_handling = GLMModel.GLMParameters.MissingValuesHandling.Skip;
            GLM glm = new GLM(params);
            glm.trainModel().get();
            Assert.assertFalse((String)"should've thrown IAE", (boolean)true);
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("No rows left in the dataset"));
        }
        finally {
            fr.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGradientTask() {
        Key parsed = Key.make((String)"cars_parsed");
        Frame fr = null;
        DataInfo dinfo = null;
        try {
            int i;
            fr = GLMTest.parse_test_file((Key)parsed, (String)"smalldata/junit/mixcat_train.csv");
            GLMModel.GLMParameters params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.binomial, GLMModel.GLMParameters.Family.binomial.defaultLink, new double[]{0.0}, new double[]{0.0}, 0.0, 0.0);
            params._train = parsed;
            params._lambda = new double[]{0.0};
            params._use_all_factor_levels = true;
            fr.add("Useless", fr.remove("Useless"));
            dinfo = new DataInfo(fr, null, 1, params._use_all_factor_levels || params._lambda_search, params._standardize ? DataInfo.TransformType.STANDARDIZE : DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, true, false, false, false, false, false);
            DKV.put((Key)dinfo._key, (Iced)dinfo);
            double[] beta = MemoryManager.malloc8d((int)(dinfo.fullN() + 1));
            Random rnd = new Random(987654321L);
            for (int i2 = 0; i2 < beta.length; ++i2) {
                beta[i2] = 1.0 - 2.0 * rnd.nextDouble();
            }
            GLMTask.GLMGradientTask grtSpc = (GLMTask.GLMGradientTask)new GLMTask.GLMBinomialGradientTask(null, dinfo, params, params._lambda[0], beta).doAll(dinfo._adaptedFrame);
            GLMTask.GLMGradientTask grtGen = (GLMTask.GLMGradientTask)new GLMTask.GLMGenericGradientTask(null, dinfo, params, params._lambda[0], beta).doAll(dinfo._adaptedFrame);
            for (i = 0; i < beta.length; ++i) {
                Assert.assertEquals((String)"gradients differ", (double)grtSpc._gradient[i], (double)grtGen._gradient[i], (double)1.0E-4);
            }
            params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.gaussian, GLMModel.GLMParameters.Family.gaussian.defaultLink, new double[]{0.0}, new double[]{0.0}, 0.0, 0.0);
            params._use_all_factor_levels = false;
            dinfo.remove();
            dinfo = new DataInfo(fr, null, 1, params._use_all_factor_levels || params._lambda_search, params._standardize ? DataInfo.TransformType.STANDARDIZE : DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, true, false, false, false, false, false);
            DKV.put((Key)dinfo._key, (Iced)dinfo);
            beta = MemoryManager.malloc8d((int)(dinfo.fullN() + 1));
            rnd = new Random(1987654321L);
            for (i = 0; i < beta.length; ++i) {
                beta[i] = 1.0 - 2.0 * rnd.nextDouble();
            }
            grtSpc = (GLMTask.GLMGradientTask)new GLMTask.GLMGaussianGradientTask(null, dinfo, params, params._lambda[0], beta).doAll(dinfo._adaptedFrame);
            grtGen = (GLMTask.GLMGradientTask)new GLMTask.GLMGenericGradientTask(null, dinfo, params, params._lambda[0], beta).doAll(dinfo._adaptedFrame);
            for (i = 0; i < beta.length; ++i) {
                Assert.assertEquals((String)("gradients differ: " + Arrays.toString(grtSpc._gradient) + " != " + Arrays.toString(grtGen._gradient)), (double)grtSpc._gradient[i], (double)grtGen._gradient[i], (double)1.0E-4);
            }
            dinfo.remove();
        }
        finally {
            if (fr != null) {
                fr.delete();
            }
            if (dinfo != null) {
                dinfo.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultinomialGradient() {
        Key parsed = Key.make((String)"covtype");
        Frame fr = null;
        double[][] beta = new double[][]{{5.886754459, -0.27047962, -0.075466082, -0.157524534, -0.225843747, -0.975387326, -0.018808013, -0.597839451, 0.931896624, 1.06000601, 1.513888539, 0.58880278, 0.157815155, -2.158268564, -0.504962385, -1.218970183, -0.840958642, -0.425931637, -0.355548831, -0.845035489, -0.065364107, 0.215897656, 0.213009374, 0.006831714, 1.212368946, 0.006106444, -0.350643486, -0.268207009, -0.252099054, -1.374010836, 0.25793586, 0.397459631, 0.411530391, 0.728368253, 0.292076224, 0.170774269, -0.059574793, 0.273670163, 0.180844505, -0.186483071, 0.369186813, 0.161909512, 0.249411716, -0.094481604, 0.41335436, -0.419043967, 0.044517794, -0.252596992, -0.371926422, 0.253835004, 0.58816209, 0.123330837, 2.856812217}, {1.89790254, -0.29776886, 0.15613197, 0.37602123, -0.36464436, -0.30240244, -0.5728437, 0.62408956, -0.22369305, 0.33644602, 0.798864, 0.65351945, -0.53682819, -0.58319898, -1.07762513, -0.2852747, 0.46563482, -0.76956081, -0.72513805, 0.29857876, 0.03993456, 0.15835864, -0.24797599, -0.02483503, 0.9382249, -0.12406087, -0.75837978, -0.23516944, -0.48520212, 0.73571466, 0.19652011, 0.21602846, -0.32743154, 0.49421903, -0.02262943, 0.08093216, 0.11524497, 0.21657128, 0.18072853, 0.30872666, 0.17947687, 0.20156151, 0.16812179, -0.12286908, 0.29630502, 0.09992565, -0.00603293, 0.20700058, -0.49706211, -0.14534034, -0.18819217, 0.0364268, 7.3182834}, {-6.098728943, 0.284144173, 0.114373474, 0.328977319, 0.417830082, 0.28569615, -0.652674822, 0.319136906, -0.942440279, -1.619235397, -1.272568201, -0.079855555, 1.19126355, 0.205102353, 0.991773314, 0.930363203, 1.014021007, 0.651243292, 0.646532457, 0.91433603, 0.012171754, -0.053042102, 0.777710362, 0.527369151, -0.019496049, 0.186290583, 0.554926655, 0.476911685, 0.52920752, -0.13324306, -0.198957274, -0.561552913, -0.069239959, -0.23660087, -0.969503908, -0.848089244, 0.001498592, -0.241007311, -0.129271912, -0.259961677, -0.895676033, -0.865827509, -0.972629899, 0.307756211, -1.809423763, -0.199557594, 0.024221965, -0.024834485, 0.047044475, 0.028951561, -0.157701002, 0.007940593, -2.073329675}, {-8.3604444, 0.10541672, -0.0162868, -0.43787017, 0.42383466, 2.45802808, 0.59818831, 0.61971728, -0.62598983, 0.20261555, -0.21909545, 0.35125447, -3.29155913, 3.74668257, 0.18126128, -0.13948924, 0.20465077, -0.39930635, 0.1570457, -0.01036891, 0.02822546, -0.02349234, -0.93922249, -0.2002591, 0.25184125, 0.06415974, 0.3527129, 0.0460906, 0.03018497, -0.1064154, 0.00354805, -0.12194129, 0.05115876, 0.23981864, -0.10007012, 0.04773226, 0.01217421, 0.02367464, 0.05552397, 0.05343606, -0.05818705, -0.30055029, -0.03898723, 0.02322906, -0.04908215, 0.04274038, 0.25045428, 0.08561191, 0.1522816, 0.67005377, 0.59311621, 0.58814959, -4.83776046}, {-0.39251919, 0.07053038, 0.09397355, 0.19394977, -0.02030732, -0.87489691, 0.21295049, 0.31800509, -0.05347208, -1.03491602, 2.20106706, -1.20895873, 1.06158893, -3.29214054, -0.69334082, 0.62309414, -1.64753442, 0.10189669, -0.44746013, -1.04084383, -0.01997483, -0.2335618, 0.34384724, 0.37566329, -1.7931651, 0.46183758, -0.58814389, 0.12072985, 0.48349078, 1.18956325, 0.41962148, 0.1876716, -0.25252495, -1.1367154, 0.71488183, 0.27405258, -0.03527945, 0.43124949, -0.28740586, 0.35165348, 1.17594079, 1.13893507, 0.49423372, 0.30525649, 0.7080968, 0.1666033, -0.37726163, -0.14687217, -0.17079711, -1.01897715, -1.17494223, -0.72698683, 1.64022531}, {-5.892381502, 0.295534637, -0.112763568, 0.080283203, 0.197113227, 0.525435203, 0.727252262, -1.190672917, 1.137103389, -0.648526151, -2.581362158, -0.268338673, 2.010179009, 0.90207445, 0.816138328, 0.55707147, 0.389932578, 0.009422297, 0.542270816, 0.550653667, 0.00521172, -0.071954379, 0.320008238, 0.155814784, -0.264213966, 0.320538295, 0.569730803, 0.444518874, 0.247279544, -0.31948433, -0.372129988, 0.340944707, -0.158424299, -0.479426774, 0.026966661, 0.273389077, -0.004744599, -0.339321329, -0.119323949, -0.210123558, -1.218998166, -0.740525896, 0.134778587, 0.252701229, 0.527468284, 0.214164427, -0.080104361, -0.021448994, 0.004509104, -0.189729053, -0.335041198, -0.080698796, -1.192518082}, {12.9594170391, -0.18737743, -0.159962536, -0.3838368119, -0.427982539, -1.1164727575, -0.2940645257, -0.0924364781, -0.223404772, 1.7036099945, -0.4407937881, -0.0364237384, -0.5924593214, 1.1797487023, 0.2867554171, -0.46679469, 0.4142538835, 0.8322365174, 0.1822980332, 0.1326797653, -2.045542E-4, 0.0077943238, -0.4673767424, -0.840584814, -0.3255599769, -0.9148717663, 0.2197967986, -0.5848745645, -0.552861643, 0.0078757154, -0.3065382365, -0.4586101971, 0.3449315968, 0.39033712, 0.0582787537, 0.0012089013, -0.0293189213, -0.3648369414, 0.1189047254, -0.0572478953, 0.4482567793, 0.4044976082, -0.0349286763, -0.6715923088, -0.0867185553, 0.0951677966, 0.1442048837, 0.1531401571, 0.8359504674, 0.4012062075, 0.6745982951, 0.051837806, -3.7117127004}};
        double[] exp_grad = new double[]{-8.955455E-5, 6.429112E-4, 4.384381E-4, 0.001363695, 4.714468E-4, -0.002264769, 4.412849E-4, 0.00146176, -2.957754E-5, -0.002244325, -0.002744438, 9.109376E-4, 0.001920764, 7.562221E-4, 1.840414E-4, 2.455081E-4, 3.077885E-4, 2.833261E-4, 1.248686E-4, 2.509248E-4, 9.68126E-6, -1.097335E-4, 0.001005934, 5.623159E-4, -0.002568397, 0.0011139, 1.263858E-4, 9.075801E-5, 8.056571E-5, 1.848318E-4, -1.291357E-4, -3.71057E-4, 5.693621E-5, 1.328082E-4, 3.244018E-4, 4.130594E-4, 9.681066E-6, 5.21526E-4, 4.054695E-4, 2.904901E-5, -0.003074865, -1.247025E-4, 0.001044981, 8.612937E-4, 0.001376526, 4.543256E-5, -4.596319E-6, 3.062111E-5, 5.649646E-5, 5.392599E-4, 9.681357E-4, 2.298219E-4, -0.001369109, -6.884926E-4, -9.921529E-4, -5.369346E-4, -0.001732447, 5.677645E-4, 0.001655432, -4.78689E-4, -8.688757E-4, 2.922016E-4, 0.00360121, 0.004050781, -6.409806E-4, -0.002788663, -0.001426483, -1.946904E-4, -8.279536E-4, -3.148338E-4, 2.263577E-6, -1.320917E-4, 3.635088E-4, -1.024655E-5, 1.079612E-4, -0.001607591, -1.801967E-4, 0.002548311, -0.001007139, -1.33699E-4, 2.538803E-4, -4.851292E-4, -9.168206E-4, 1.027708E-4, 0.001061545, -4.098038E-5, 1.070448E-4, 3.220238E-4, -7.011285E-4, -1.024153E-5, -7.96738E-4, -2.708138E-4, -2.698165E-4, 0.003088978, 4.260939E-4, -5.868815E-4, -0.001562233, -0.001007565, -2.034456E-4, -6.198011E-4, -3.277194E-5, -5.976557E-5, -0.001143198, -0.001025416, 3.671158E-4, 0.001448332, 0.001940231, -6.130695E-4, -0.00208646, -2.969848E-4, 1.455597E-4, 0.001745515, 0.002123991, 9.036201E-4, -5.270206E-4, 0.001053891, 0.001358911, 2.528711E-4, 1.326987E-4, -0.001825879, -6.085616E-4, -1.347628E-4, 3.499544E-4, 3.616313E-4, -7.008672E-4, -0.001211077, 1.117824E-5, 3.535679E-5, -0.002668903, -2.399884E-4, 3.979678E-4, 2.519517E-4, 1.113206E-4, 6.029871E-4, 3.512828E-4, 2.134159E-4, 7.590052E-5, 1.729959E-4, 4.472972E-5, 2.094373E-4, 3.136961E-4, 1.83553E-4, 1.117824E-5, 8.225263E-5, 4.330828E-5, 3.354142E-5, 7.452883E-4, 4.631413E-4, 2.054077E-4, -5.520636E-5, 2.818063E-4, 5.246077E-5, 1.131811E-4, 3.535664E-5, 6.52336E-5, 3.072416E-4, 2.913399E-4, 2.42276E-4, -0.001580841, -1.117356E-4, 2.573351E-4, 8.117137E-4, 1.168873E-4, -4.216143E-4, -5.847717E-5, 3.501109E-4, 2.344622E-4, -1.330097E-4, -5.948309E-4, -2.349808E-4, -4.495448E-5, -1.916493E-4, 5.017336E-4, -8.440468E-5, 4.767465E-4, 2.485018E-4, 2.060573E-4, -1.527142E-4, -9.268231E-6, -1.985972E-6, -6.285478E-6, -2.214673E-5, 5.82225E-4, -7.069316E-5, -4.387924E-5, -2.774128E-4, -5.455282E-4, 3.186328E-4, -3.793242E-5, -1.349306E-5, -3.070112E-5, -7.951882E-6, -3.723186E-5, -5.571437E-5, -3.26078E-5, -1.987225E-6, -1.462245E-5, -7.699184E-6, -5.962867E-6, -1.316053E-4, -8.10857E-5, -3.651228E-5, -5.312255E-5, -5.009791E-5, -9.325808E-6, -2.012086E-5, -6.285571E-6, -1.159698E-5, -5.462022E-5, -5.17931E-5, -4.307092E-5, 2.81036E-4, 3.869942E-4, -3.450936E-5, -7.805675E-5, 6.405561E-4, -2.284402E-4, -1.866295E-4, -4.858359E-4, 3.49689E-4, 7.35278E-4, 5.767877E-4, -8.477014E-4, -5.512698E-5, 0.001091158, -1.900036E-4, -4.632766E-5, 1.086153E-5, -7.743051E-5, -7.545391E-4, -3.143243E-5, -6.316374E-5, -2.435782E-6, -7.707894E-6, 4.451785E-4, 2.043479E-4, -8.673378E-5, -3.314975E-5, -3.181369E-5, -5.422704E-4, -9.020739E-5, 6.747588E-4, 5.997742E-6, -9.729086E-4, -9.75149E-6, -4.565744E-5, -4.181943E-4, 7.522183E-4, -2.436958E-6, 2.531532E-4, -9.4416E-6, 2.317743E-4, 4.254207E-4, -3.224488E-4, 3.979052E-4, 2.066697E-4, 2.486194E-5, 1.189306E-4, -2.465884E-5, -7.708071E-6, -1.422152E-5, -6.697064E-5, -6.351172E-5, -5.28106E-5, 3.446379E-4, -0.001212986, 9.206612E-4, 6.469824E-4, -6.605882E-4, -1.646537E-5, -6.854543E-4, -0.002079925, -0.001031449, 3.926585E-4, -0.001556234, -0.001129748, -2.11348E-4, -4.922559E-4, 0.001938461, 6.900824E-4, 1.497533E-4, -6.140808E-4, -3.365137E-4, 8.516225E-4, 5.874586E-4, -9.342693E-6, -2.955083E-5, 0.002692614, -9.928211E-4, -3.326157E-4, -3.572773E-4, 1.641113E-4, 7.442831E-5, -2.543959E-4, -1.783712E-4, -6.343638E-5, 9.077554E-5, -3.73848E-5, -1.750387E-4, -6.56848E-4, -2.035799E-4, -9.342694E-6, -6.874421E-5, -3.619677E-5, -2.803369E-5, -6.228932E-4, -3.870861E-4, -0.001103792, 9.58536E-4, -7.037269E-5, 2.736606E-4, -9.459508E-5, -2.955084E-5, -5.45218E-5, -2.567899E-4, -2.43493E-4, -2.024919E-4, 0.001321256, -2.244563E-4, -1.811758E-4, 8.043173E-4, 5.68882E-4, -5.182511E-4, -2.056167E-4, 1.290635E-4, -0.001049207, -7.305304E-4, -8.364983E-4, -4.528248E-4, -2.113987E-4, 3.279472E-4, 2.459491E-4, 5.986061E-5, 7.984705E-5, 1.001005E-4, 2.377746E-4, 4.061439E-5, 8.161668E-5, 3.151497E-6, 9.959707E-6, 1.54914E-4, 6.411739E-5, 1.121613E-4, 7.559378E-5, 4.110778E-5, 6.574476E-5, 7.925128E-5, 6.01177E-5, 2.139605E-5, 4.934971E-5, -5.597385E-6, -1.913622E-4, 1.706349E-4, -4.115145E-4, 3.149101E-6, 2.317293E-5, -1.246264E-4, 9.448371E-6, -4.303234E-4, 2.608783E-5, 7.889196E-5, -3.559375E-4, -5.551586E-4, -2.777131E-4, 6.505911E-4, 1.033867E-5, 1.837583E-5, 6.750772E-4, 1.247379E-4, -5.408403E-4, -4.453114E-4};
        Vec origRes = null;
        try {
            fr = GLMTest.parse_test_file((Key)parsed, (String)"smalldata/covtype/covtype.20k.data");
            fr.remove("C21").remove();
            fr.remove("C29").remove();
            GLMModel.GLMParameters params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.multinomial);
            params._response_column = "C55";
            params._ignored_columns = new String[0];
            params._train = parsed;
            params._lambda = new double[]{0.0};
            params._alpha = new double[]{0.0};
            origRes = fr.remove("C55");
            Vec res = fr.add("C55", origRes.toCategoricalVec());
            double[] means = new double[res.domain().length];
            long[] bins = res.bins();
            double sumInv = 1.0 / (double)ArrayUtils.sum((long[])bins);
            for (int i = 0; i < bins.length; ++i) {
                means[i] = (double)bins[i] * sumInv;
            }
            DataInfo dinfo = new DataInfo(fr, null, 1, true, DataInfo.TransformType.STANDARDIZE, DataInfo.TransformType.NONE, true, false, false, false, false, false);
            GLMTask.GLMMultinomialGradientBaseTask gmt = (GLMTask.GLMMultinomialGradientBaseTask)new GLMTask.GLMMultinomialGradientTask(null, dinfo, 0.0, (double[][])beta, 1.0 / (double)fr.numRows()).doAll(dinfo._adaptedFrame);
            Assert.assertEquals((double)0.6421113, (double)(gmt._likelihood / (double)fr.numRows()), (double)1.0E-8);
            System.out.println("likelihood = " + gmt._likelihood / (double)fr.numRows());
            double[] g = gmt.gradient();
            for (int i = 0; i < g.length; ++i) {
                Assert.assertEquals((String)("Mismatch at coefficient '' (" + i + ")"), (double)exp_grad[i], (double)g[i], (double)1.0E-8);
            }
        }
        finally {
            if (origRes != null) {
                origRes.remove();
            }
            if (fr != null) {
                fr.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCars() throws InterruptedException, ExecutionException {
        Scope.enter();
        Key parsed = Key.make((String)"cars_parsed");
        Frame fr = null;
        GLMModel model = null;
        Object score = null;
        try {
            fr = GLMTest.parse_test_file((Key)parsed, (String)"smalldata/junit/cars.csv");
            GLMModel.GLMParameters params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.poisson, GLMModel.GLMParameters.Family.poisson.defaultLink, new double[]{0.0}, new double[]{0.0}, 0.0, 0.0);
            params._response_column = "power (hp)";
            params._ignored_columns = new String[]{"name"};
            params._train = parsed;
            params._lambda = new double[]{0.0};
            params._alpha = new double[]{0.0};
            params._missing_values_handling = GLMModel.GLMParameters.MissingValuesHandling.Skip;
            model = (GLMModel)new GLM(params).trainModel().get();
            HashMap coefs = model.coefficients();
            String[] cfs1 = new String[]{"Intercept", "economy (mpg)", "cylinders", "displacement (cc)", "weight (lb)", "0-60 mph (s)", "year"};
            double[] vls1 = new double[]{4.9504805, -0.0095859, -0.0063046, 4.392E-4, 1.762E-4, -0.046981, 2.891E-4};
            for (int i = 0; i < cfs1.length; ++i) {
                Assert.assertEquals((double)vls1[i], (double)((Double)coefs.get(cfs1[i])), (double)1.0E-4);
            }
            double[] vls2 = new double[]{0.008992, 1.818E-4, -1.125E-4, 1.505E-6, -1.284E-6, 4.51E-4, -7.254E-5};
            GLMTest.testScoring(model, fr);
            model.delete();
            params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.gamma, GLMModel.GLMParameters.Family.gamma.defaultLink, new double[]{0.0}, new double[]{0.0}, 0.0, 0.0);
            params._response_column = "power (hp)";
            params._ignored_columns = new String[]{"name"};
            params._train = parsed;
            params._lambda = new double[]{0.0};
            params._beta_epsilon = 1.0E-5;
            params._missing_values_handling = GLMModel.GLMParameters.MissingValuesHandling.Skip;
            model = (GLMModel)new GLM(params).trainModel().get();
            coefs = model.coefficients();
            for (int i = 0; i < cfs1.length; ++i) {
                Assert.assertEquals((double)vls2[i], (double)((Double)coefs.get(cfs1[i])), (double)1.0E-4);
            }
            GLMTest.testScoring(model, fr);
            model.delete();
            double[] vls3 = new double[]{166.95862, -0.00531, -2.4669, 0.12635, 0.02159, -4.66995, -0.85724};
            params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.gaussian);
            params._response_column = "power (hp)";
            params._ignored_columns = new String[]{"name"};
            params._train = parsed;
            params._lambda = new double[]{0.0};
            params._missing_values_handling = GLMModel.GLMParameters.MissingValuesHandling.Skip;
            model = (GLMModel)new GLM(params).trainModel().get();
            coefs = model.coefficients();
            for (int i = 0; i < cfs1.length; ++i) {
                Assert.assertEquals((double)vls3[i], (double)((Double)coefs.get(cfs1[i])), (double)1.0E-4);
            }
        }
        finally {
            if (fr != null) {
                fr.delete();
            }
            if (score != null) {
                score.delete();
            }
            if (model != null) {
                model.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBounds() {
        GLMModel model = null;
        Key parsed = Key.make((String)"prostate_parsed");
        Key modelKey = Key.make((String)"prostate_model");
        Frame fr = GLMTest.parse_test_file((Key)parsed, (String)"smalldata/logreg/prostate.csv");
        Key betaConsKey = Key.make((String)"beta_constraints");
        String[] cfs1 = new String[]{"AGE", "RACE", "DPROS", "DCAPS", "PSA", "VOL", "GLEASON", "Intercept"};
        double[] vals = new double[]{-0.006502588, -0.5, 0.5, 0.4, 0.034826559, -0.011661747, 0.5, -4.564024};
        FVecTest.makeByteVec((Key)betaConsKey, (String[])new String[]{"names, lower_bounds, upper_bounds\n AGE, -.5, .5\n RACE, -.5, .5\n DCAPS, -.4, .4\n DPROS, -.5, .5 \nPSA, -.5, .5\n VOL, -.5, .5\nGLEASON, -.5, .5"});
        Frame betaConstraints = ParseDataset.parse((Key)Key.make((String)"beta_constraints.hex"), (Key[])new Key[]{betaConsKey});
        try {
            GLMModel.GLMParameters params = new GLMModel.GLMParameters();
            params._standardize = true;
            params._family = GLMModel.GLMParameters.Family.binomial;
            params._beta_constraints = betaConstraints._key;
            params._response_column = "CAPSULE";
            params._ignored_columns = new String[]{"ID"};
            params._train = fr._key;
            params._objective_epsilon = 0.0;
            params._alpha = new double[]{1.0};
            params._lambda = new double[]{0.001607};
            params._obj_reg = 0.002631578947368421;
            GLM glm = new GLM(params, modelKey);
            model = (GLMModel)glm.trainModel().get();
            Assert.assertTrue((boolean)glm.isStopped());
            ModelMetricsBinomialGLM val = (ModelMetricsBinomialGLM)((GLMModel.GLMOutput)model._output)._training_metrics;
            Assert.assertEquals((double)512.2888, (double)val._nullDev, (double)0.1);
            Assert.assertTrue((val._resDev <= 388.5 ? 1 : 0) != 0);
            model.delete();
            params._lambda = new double[]{0.0};
            params._alpha = new double[]{0.0};
            FVecTest.makeByteVec((Key)betaConsKey, (String[])new String[]{"names, lower_bounds, upper_bounds\n RACE, -.5, .5\n DCAPS, -.4, .4\n DPROS, -.5, .5 \nPSA, -.5, .5\n VOL, -.5, .5"});
            betaConstraints = ParseDataset.parse((Key)Key.make((String)"beta_constraints.hex"), (Key[])new Key[]{betaConsKey});
            glm = new GLM(params, modelKey);
            model = (GLMModel)glm.trainModel().get();
            Assert.assertTrue((boolean)glm.isStopped());
            double[] beta = model.beta();
            System.out.println("beta = " + Arrays.toString(beta));
            fr.add("CAPSULE", fr.remove("CAPSULE"));
            fr.remove("ID").remove();
            DKV.put((Key)fr._key, (Iced)fr);
            DataInfo dinfo = new DataInfo(fr, null, 1, true, DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, true, false, false, false, false, false);
            GLMTask.GLMGradientTask lt = (GLMTask.GLMGradientTask)new GLMTask.GLMBinomialGradientTask(null, dinfo, params, 0.0, beta).doAll(dinfo._adaptedFrame);
            double[] grad = lt._gradient;
            String[] names = model.dinfo().coefNames();
            BufferedString tmpStr = new BufferedString();
            block3: for (int i = 0; i < names.length; ++i) {
                int j = 0;
                while ((long)j < betaConstraints.numRows()) {
                    if (betaConstraints.vec("names").atStr(tmpStr, (long)j).toString().equals(names[i]) && (Math.abs(beta[i] - betaConstraints.vec("lower_bounds").at((long)j)) < 1.0E-4 || Math.abs(beta[i] - betaConstraints.vec("upper_bounds").at((long)j)) < 1.0E-4)) continue block3;
                    ++j;
                }
                Assert.assertEquals((double)0.0, (double)grad[i], (double)0.01);
            }
        }
        finally {
            fr.delete();
            betaConstraints.delete();
            if (model != null) {
                model.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoordinateDescent_airlines() {
        GLMModel model = null;
        Key parsed = Key.make((String)"airlines_parsed");
        Key modelKey = Key.make((String)"airlines_model");
        Frame fr = GLMTest.parse_test_file((Key)parsed, (String)"smalldata/airlines/AirlinesTrain.csv.zip");
        try {
            GLMModel.GLMParameters params = new GLMModel.GLMParameters();
            params._standardize = true;
            params._family = GLMModel.GLMParameters.Family.binomial;
            params._solver = GLMModel.GLMParameters.Solver.COORDINATE_DESCENT_NAIVE;
            params._response_column = "IsDepDelayed";
            params._ignored_columns = new String[]{"IsDepDelayed_REC"};
            params._train = fr._key;
            GLM glm = new GLM(params, modelKey);
            model = (GLMModel)glm.trainModel().get();
            Assert.assertTrue((boolean)glm.isStopped());
            System.out.println(((GLMModel.GLMOutput)model._output)._training_metrics);
        }
        finally {
            fr.delete();
            if (model != null) {
                model.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoordinateDescent_airlines_CovUpdates() {
        GLMModel model = null;
        Key parsed = Key.make((String)"airlines_parsed");
        Key modelKey = Key.make((String)"airlines_model");
        Frame fr = GLMTest.parse_test_file((Key)parsed, (String)"smalldata/airlines/AirlinesTrain.csv.zip");
        try {
            GLMModel.GLMParameters params = new GLMModel.GLMParameters();
            params._standardize = true;
            params._family = GLMModel.GLMParameters.Family.binomial;
            params._solver = GLMModel.GLMParameters.Solver.COORDINATE_DESCENT;
            params._response_column = "IsDepDelayed";
            params._ignored_columns = new String[]{"IsDepDelayed_REC"};
            params._train = fr._key;
            GLM glm = new GLM(params, modelKey);
            model = (GLMModel)glm.trainModel().get();
            Assert.assertTrue((boolean)glm.isStopped());
            System.out.println(((GLMModel.GLMOutput)model._output)._training_metrics);
        }
        finally {
            fr.delete();
            if (model != null) {
                model.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoordinateDescent_anomaly() {
        GLMModel model = null;
        Key parsed = Key.make((String)"anomaly_parsed");
        Key modelKey = Key.make((String)"anomaly_model");
        Frame fr = GLMTest.parse_test_file((Key)parsed, (String)"smalldata/anomaly/ecg_discord_train.csv");
        try {
            GLMModel.GLMParameters params = new GLMModel.GLMParameters();
            params._standardize = true;
            params._family = GLMModel.GLMParameters.Family.gaussian;
            params._solver = GLMModel.GLMParameters.Solver.COORDINATE_DESCENT_NAIVE;
            params._response_column = "C1";
            params._train = fr._key;
            GLM glm = new GLM(params, modelKey);
            model = (GLMModel)glm.trainModel().get();
            Assert.assertTrue((boolean)glm.isStopped());
            System.out.println(((GLMModel.GLMOutput)model._output)._training_metrics);
        }
        finally {
            fr.delete();
            if (model != null) {
                model.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoordinateDescent_anomaly_CovUpdates() {
        GLMModel model = null;
        Key parsed = Key.make((String)"anomaly_parsed");
        Key modelKey = Key.make((String)"anomaly_model");
        Frame fr = GLMTest.parse_test_file((Key)parsed, (String)"smalldata/anomaly/ecg_discord_train.csv");
        try {
            GLMModel.GLMParameters params = new GLMModel.GLMParameters();
            params._standardize = true;
            params._family = GLMModel.GLMParameters.Family.gaussian;
            params._solver = GLMModel.GLMParameters.Solver.COORDINATE_DESCENT;
            params._response_column = "C1";
            params._train = fr._key;
            GLM glm = new GLM(params, modelKey);
            model = (GLMModel)glm.trainModel().get();
            Assert.assertTrue((boolean)glm.isStopped());
            System.out.println(((GLMModel.GLMOutput)model._output)._training_metrics);
        }
        finally {
            fr.delete();
            if (model != null) {
                model.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProximal() {
        Key parsed = Key.make((String)"prostate_parsed");
        Key modelKey = Key.make((String)"prostate_model");
        GLMModel model = null;
        Frame fr = GLMTest.parse_test_file((Key)parsed, (String)"smalldata/logreg/prostate.csv");
        fr.remove("ID").remove();
        DKV.put((Key)fr._key, (Iced)fr);
        Key betaConsKey = Key.make((String)"beta_constraints");
        FVecTest.makeByteVec((Key)betaConsKey, (String[])new String[]{"names, beta_given, rho\n AGE, 0.1, 1\n RACE, -0.1, 1 \n DPROS, 10, 1 \n DCAPS, -10, 1 \n PSA, 0, 1\n VOL, 0, 1\nGLEASON, 0, 1\n Intercept, 0, 0 \n"});
        Frame betaConstraints = ParseDataset.parse((Key)Key.make((String)"beta_constraints.hex"), (Key[])new Key[]{betaConsKey});
        try {
            GLMModel.GLMParameters params = new GLMModel.GLMParameters();
            params._standardize = false;
            params._family = GLMModel.GLMParameters.Family.binomial;
            params._beta_constraints = betaConstraints._key;
            params._response_column = "CAPSULE";
            params._ignored_columns = new String[]{"ID"};
            params._train = fr._key;
            params._alpha = new double[]{0.0};
            params._lambda = new double[]{0.0};
            params._obj_reg = 0.002631578947368421;
            params._objective_epsilon = 0.0;
            GLM glm = new GLM(params, modelKey);
            model = (GLMModel)glm.trainModel().get();
            double[] beta_1 = model.beta();
            params._solver = GLMModel.GLMParameters.Solver.L_BFGS;
            params._max_iterations = 1000;
            glm = new GLM(params, modelKey);
            model = (GLMModel)glm.trainModel().get();
            fr.add("CAPSULE", fr.remove("CAPSULE"));
            DataInfo dinfo = new DataInfo(fr, null, 1, true, DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, true, false, false, false, false, false);
            GLMTask.GLMGradientTask lt = (GLMTask.GLMGradientTask)new GLMTask.GLMBinomialGradientTask(null, dinfo, params, 0.0, beta_1).doAll(dinfo._adaptedFrame);
            double[] grad = lt._gradient;
            for (int i = 0; i < beta_1.length; ++i) {
                Assert.assertEquals((double)0.0, (double)(grad[i] + betaConstraints.vec("rho").at((long)i) * (beta_1[i] - betaConstraints.vec("beta_given").at((long)i))), (double)1.0E-4);
            }
        }
        finally {
            betaConstraints.delete();
            fr.delete();
            if (model != null) {
                model.delete();
            }
        }
    }

    @Test
    public void testSparseGramComputation() {
        int i;
        Random rnd = new Random(123456789L);
        double[] d0 = MemoryManager.malloc8d((int)1000);
        double[] d1 = MemoryManager.malloc8d((int)1000);
        double[] d2 = MemoryManager.malloc8d((int)1000);
        double[] d3 = MemoryManager.malloc8d((int)1000);
        double[] d4 = MemoryManager.malloc8d((int)1000);
        double[] d5 = MemoryManager.malloc8d((int)1000);
        double[] d6 = MemoryManager.malloc8d((int)1000);
        double[] d7 = MemoryManager.malloc8d((int)1000);
        double[] d8 = MemoryManager.malloc8d((int)1000);
        double[] d9 = MemoryManager.malloc8d((int)1000);
        long[] c1 = MemoryManager.malloc8((int)1000);
        long[] c2 = MemoryManager.malloc8((int)1000);
        String[] dom = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
        for (i = 0; i < d1.length; ++i) {
            c1[i] = rnd.nextInt(dom.length);
            c2[i] = rnd.nextInt(dom.length);
            d0[i] = rnd.nextDouble();
            d1[i] = rnd.nextDouble();
        }
        for (i = 0; i < 30; ++i) {
            d2[rnd.nextInt((int)d2.length)] = rnd.nextDouble();
            d3[rnd.nextInt((int)d2.length)] = rnd.nextDouble();
            d4[rnd.nextInt((int)d2.length)] = rnd.nextDouble();
            d5[rnd.nextInt((int)d2.length)] = rnd.nextDouble();
            d6[rnd.nextInt((int)d2.length)] = rnd.nextDouble();
            d7[rnd.nextInt((int)d2.length)] = rnd.nextDouble();
            d8[rnd.nextInt((int)d2.length)] = rnd.nextDouble();
            d9[rnd.nextInt((int)d2.length)] = 1.0;
        }
        Vec.VectorGroup vg_1 = Vec.VectorGroup.VG_LEN1;
        Vec v01 = Vec.makeVec((long[])c1, (String[])dom, (Key)vg_1.addVec());
        Vec v02 = Vec.makeVec((long[])c2, (String[])dom, (Key)vg_1.addVec());
        Vec v03 = Vec.makeVec((double[])d0, (Key)vg_1.addVec());
        Vec v04 = Vec.makeVec((double[])d1, (Key)vg_1.addVec());
        Vec v05 = Vec.makeVec((double[])d2, (Key)vg_1.addVec());
        Vec v06 = Vec.makeVec((double[])d3, (Key)vg_1.addVec());
        Vec v07 = Vec.makeVec((double[])d4, (Key)vg_1.addVec());
        Vec v08 = Vec.makeVec((double[])d5, (Key)vg_1.addVec());
        Vec v09 = Vec.makeVec((double[])d6, (Key)vg_1.addVec());
        Vec v10 = Vec.makeVec((double[])d7, (Key)vg_1.addVec());
        Vec v11 = Vec.makeVec((double[])d8, (Key)vg_1.addVec());
        Vec v12 = Vec.makeVec((double[])d9, (Key)vg_1.addVec());
        Frame f = new Frame(Key.make((String)"TestData"), null, new Vec[]{v01, v02, v03, v04, v05, v05, v06, v07, v08, v09, v10, v11, v12});
        DKV.put((Keyed)f);
        DataInfo dinfo = new DataInfo(f, null, 1, true, DataInfo.TransformType.STANDARDIZE, DataInfo.TransformType.NONE, true, false, false, false, false, false);
        GLMModel.GLMParameters params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.gaussian);
        GLMTask.GLMIterationTask glmtSparse = (GLMTask.GLMIterationTask)((GLMTask.GLMIterationTask)new GLMTask.GLMIterationTask(null, dinfo, new GLMModel.GLMWeightsFun(params), null).setSparse(true)).doAll(dinfo._adaptedFrame);
        final GLMTask.GLMIterationTask glmtDense = (GLMTask.GLMIterationTask)((GLMTask.GLMIterationTask)new GLMTask.GLMIterationTask(null, dinfo, new GLMModel.GLMWeightsFun(params), null).setSparse(false)).doAll(dinfo._adaptedFrame);
        for (int i2 = 0; i2 < glmtDense._xy.length; ++i2) {
            for (int j = 0; j <= i2; ++j) {
                Assert.assertEquals((double)glmtDense._gram.get(i2, j), (double)glmtSparse._gram.get(i2, j), (double)1.0E-8);
            }
            Assert.assertEquals((double)glmtDense._xy[i2], (double)glmtSparse._xy[i2], (double)1.0E-8);
        }
        final double[] beta = MemoryManager.malloc8d((int)(dinfo.fullN() + 1));
        (H2O.submitTask((H2O.H2OCountedCompleter)new H2O.H2OCountedCompleter(){

            public void compute2() {
                new GLM.GramSolver(glmtDense._gram, glmtDense._xy, true, 1.0E-5, 0.0, null, null, null, null).solve(null, beta);
                this.tryComplete();
            }
        })).join();
        GLMTask.GLMIterationTask glmtSparse2 = (GLMTask.GLMIterationTask)((GLMTask.GLMIterationTask)new GLMTask.GLMIterationTask(null, dinfo, new GLMModel.GLMWeightsFun(params), beta).setSparse(true)).doAll(dinfo._adaptedFrame);
        GLMTask.GLMIterationTask glmtDense2 = (GLMTask.GLMIterationTask)((GLMTask.GLMIterationTask)new GLMTask.GLMIterationTask(null, dinfo, new GLMModel.GLMWeightsFun(params), beta).setSparse(false)).doAll(dinfo._adaptedFrame);
        for (int i3 = 0; i3 < glmtDense2._xy.length; ++i3) {
            for (int j = 0; j <= i3; ++j) {
                Assert.assertEquals((double)glmtDense2._gram.get(i3, j), (double)glmtSparse2._gram.get(i3, j), (double)1.0E-8);
            }
            Assert.assertEquals((double)glmtDense2._xy[i3], (double)glmtSparse2._xy[i3], (double)1.0E-8);
        }
        dinfo.remove();
        f.delete();
    }

    @Test
    @Ignore
    public void testConstantColumns() {
        GLMModel model1 = null;
        Object model2 = null;
        Object model3 = null;
        Object model4 = null;
        Frame fr = GLMTest.parse_test_file((Key)Key.make((String)"Airlines"), (String)"smalldata/airlines/allyears2k_headers.zip");
        Vec y = fr.vec("IsDepDelayed").makeCopy(null);
        fr.replace(fr.find("IsDepDelayed"), y).remove();
        Vec weights = fr.anyVec().makeZero();
        new MRTask(){

            public void map(Chunk c) {
                long rid;
                int i = 0;
                for (i = 0; i < c._len && (rid = c.start() + (long)i) < 1999L; ++i) {
                    c.set(i, 1L);
                }
            }
        }.doAll(new Vec[]{weights});
        fr.add("weights", weights);
        DKV.put((Keyed)fr);
        GLMModel.GLMParameters parms = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.gaussian);
        parms._train = fr._key;
        parms._weights_column = "weights";
        parms._lambda_search = true;
        parms._alpha = new double[]{0.0};
        parms._response_column = "IsDepDelayed";
        parms._ignored_columns = new String[]{"DepTime", "ArrTime", "Cancelled", "CancellationCode", "DepDelay", "Diverted", "CarrierDelay", "WeatherDelay", "NASDelay", "SecurityDelay", "LateAircraftDelay", "IsArrDelayed"};
        parms._standardize = true;
        model1 = (GLMModel)new GLM(parms).trainModel().get();
        model1.delete();
        fr.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAirlines() {
        GLMModel model1 = null;
        GLMModel model2 = null;
        GLMModel model3 = null;
        GLMModel model4 = null;
        Frame frMM = GLMTest.parse_test_file((Key)Key.make((String)"AirlinesMM"), (String)"smalldata/airlines/AirlinesTrainMM.csv.zip");
        Frame frG = GLMTest.parse_test_file((Key)Key.make((String)"gram"), (String)"smalldata/airlines/gram_std.csv");
        Vec xy = frG.remove("xy");
        frMM.remove("C1").remove();
        Vec v = frMM.remove("IsDepDelayed");
        frMM.add("IsDepDelayed", v.makeCopy(null));
        v.remove();
        DKV.put((Key)frMM._key, (Iced)frMM);
        Frame fr = GLMTest.parse_test_file((Key)Key.make((String)"Airlines"), (String)"smalldata/airlines/AirlinesTrain.csv.zip");
        Frame res = null;
        v = fr.remove("IsDepDelayed");
        fr.add("IsDepDelayed", v.makeCopy(null));
        v.remove();
        DKV.put((Key)fr._key, (Iced)fr);
        String[] ignoredCols = new String[]{"fYear", "fMonth", "fDayofMonth", "fDayOfWeek", "DepTime", "ArrTime", "IsDepDelayed_REC"};
        try {
            Scope.enter();
            GLMModel.GLMParameters params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.gaussian);
            params._response_column = "IsDepDelayed";
            params._ignored_columns = ignoredCols;
            params._train = fr._key;
            params._lambda = new double[]{0.0};
            params._alpha = new double[]{0.0};
            params._standardize = false;
            params._use_all_factor_levels = false;
            model1 = (GLMModel)new GLM(params).trainModel().get();
            GLMTest.testScoring(model1, fr);
            Frame score1 = model1.score(fr);
            ModelMetricsRegressionGLM mm = (ModelMetricsRegressionGLM)ModelMetrics.getFromDKV((Model)model1, (Frame)fr);
            Assert.assertEquals((double)((ModelMetricsRegressionGLM)((GLMModel.GLMOutput)model1._output)._training_metrics)._resDev, (double)mm._resDev, (double)1.0E-4);
            Assert.assertEquals((double)((ModelMetricsRegressionGLM)((GLMModel.GLMOutput)model1._output)._training_metrics)._resDev, (double)(mm._MSE * (double)score1.numRows()), (double)1.0E-4);
            score1.delete();
            mm.remove();
            res = model1.score(fr);
            params._train = frMM._key;
            params._ignored_columns = new String[]{"X"};
            model2 = (GLMModel)new GLM(params).trainModel().get();
            HashMap coefs1 = model1.coefficients();
            GLMTest.testScoring(model2, frMM);
            HashMap coefs2 = model2.coefficients();
            boolean failed = false;
            Iterator iterator = coefs2.keySet().iterator();
            while (iterator.hasNext()) {
                String s;
                String s1 = s = (String)iterator.next();
                if (s.startsWith("Origin")) {
                    s1 = "Origin." + s.substring(6);
                }
                if (s.startsWith("Dest")) {
                    s1 = "Dest." + s.substring(4);
                }
                if (s.startsWith("UniqueCarrier")) {
                    s1 = "UniqueCarrier." + s.substring(13);
                }
                if (!(Math.abs((Double)coefs1.get(s1) - (Double)coefs2.get(s)) > 1.0E-4)) continue;
                System.out.println("coeff " + s1 + " differs, " + coefs1.get(s1) + " != " + coefs2.get(s));
                failed = true;
            }
            Assert.assertFalse((boolean)failed);
            params._standardize = true;
            params._train = frMM._key;
            params._use_all_factor_levels = true;
            DataInfo dinfo = new DataInfo(frMM, null, 1, true, DataInfo.TransformType.STANDARDIZE, DataInfo.TransformType.NONE, true, false, false, false, false, false);
            GLMTask.GLMIterationTask glmt = (GLMTask.GLMIterationTask)new GLMTask.GLMIterationTask(null, dinfo, new GLMModel.GLMWeightsFun(params), null).doAll(dinfo._adaptedFrame);
            for (int i = 0; i < glmt._xy.length; ++i) {
                for (int j = 0; j <= i; ++j) {
                    Assert.assertEquals((double)frG.vec(j).at((long)i), (double)glmt._gram.get(i, j), (double)1.0E-5);
                }
                Assert.assertEquals((double)xy.at((long)i), (double)glmt._xy[i], (double)1.0E-5);
            }
            xy.remove();
            params = (GLMModel.GLMParameters)params.clone();
            params._standardize = false;
            params._family = GLMModel.GLMParameters.Family.binomial;
            params._link = GLMModel.GLMParameters.Link.logit;
            model3 = (GLMModel)new GLM(params).trainModel().get();
            GLMTest.testScoring(model3, frMM);
            params._train = fr._key;
            params._ignored_columns = ignoredCols;
            model4 = (GLMModel)new GLM(params).trainModel().get();
            GLMTest.testScoring(model4, fr);
            Assert.assertEquals((double)GLMTest.nullDeviance(model3), (double)GLMTest.nullDeviance(model4), (double)1.0E-4);
            Assert.assertEquals((double)GLMTest.residualDeviance(model4), (double)GLMTest.residualDeviance(model3), (double)(GLMTest.nullDeviance(model3) * 0.001));
            Assert.assertEquals((double)GLMTest.nullDeviance(model1), (double)GLMTest.nullDeviance(model2), (double)1.0E-4);
            Assert.assertEquals((double)GLMTest.residualDeviance(model1), (double)GLMTest.residualDeviance(model2), (double)1.0E-4);
            Assert.assertEquals((double)5336.918, (double)GLMTest.residualDeviance(model1), (double)1.0);
            Assert.assertEquals((double)6051.613, (double)GLMTest.nullDeviance(model2), (double)1.0);
        }
        finally {
            fr.delete();
            frMM.delete();
            frG.delete();
            if (res != null) {
                res.delete();
            }
            if (model1 != null) {
                model1.delete();
            }
            if (model2 != null) {
                model2.delete();
            }
            if (model3 != null) {
                model3.delete();
            }
            if (model4 != null) {
                model4.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_COD_Airlines_SingleLambda() {
        GLMModel model1 = null;
        Frame fr = GLMTest.parse_test_file((Key)Key.make((String)"Airlines"), (String)"smalldata/airlines/AirlinesTrain.csv.zip");
        String[] ignoredCols = new String[]{"IsDepDelayed_REC"};
        try {
            Scope.enter();
            GLMModel.GLMParameters params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.binomial);
            params._response_column = "IsDepDelayed";
            params._ignored_columns = ignoredCols;
            params._train = fr._key;
            params._valid = fr._key;
            params._lambda = new double[]{0.01};
            params._alpha = new double[]{1.0};
            params._standardize = false;
            params._solver = GLMModel.GLMParameters.Solver.COORDINATE_DESCENT_NAIVE;
            params._lambda_search = true;
            params._nlambdas = 5;
            GLM glm = new GLM(params);
            model1 = (GLMModel)glm.trainModel().get();
            double[] beta = model1.beta();
            double l1pen = ArrayUtils.l1norm((double[])beta, (boolean)true);
            double d = ArrayUtils.l2norm2((double[])beta, (boolean)true);
        }
        finally {
            fr.delete();
            if (model1 != null) {
                model1.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_COD_Airlines_SingleLambda_CovUpdates() {
        GLMModel model1 = null;
        Frame fr = GLMTest.parse_test_file((Key)Key.make((String)"Airlines"), (String)"smalldata/airlines/AirlinesTrain.csv.zip");
        String[] ignoredCols = new String[]{"IsDepDelayed_REC"};
        try {
            Scope.enter();
            GLMModel.GLMParameters params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.binomial);
            params._response_column = "IsDepDelayed";
            params._ignored_columns = ignoredCols;
            params._train = fr._key;
            params._valid = fr._key;
            params._lambda = new double[]{0.01};
            params._alpha = new double[]{1.0};
            params._standardize = false;
            params._solver = GLMModel.GLMParameters.Solver.COORDINATE_DESCENT;
            params._lambda_search = true;
            GLM glm = new GLM(params);
            model1 = (GLMModel)glm.trainModel().get();
            double[] beta = model1.beta();
            double l1pen = ArrayUtils.l1norm((double[])beta, (boolean)true);
            double d = ArrayUtils.l2norm2((double[])beta, (boolean)true);
        }
        finally {
            fr.delete();
            if (model1 != null) {
                model1.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_COD_Airlines_LambdaSearch() {
        GLMModel model1 = null;
        Frame fr = GLMTest.parse_test_file((Key)Key.make((String)"Airlines"), (String)"smalldata/airlines/AirlinesTrain.csv.zip");
        String[] ignoredCols = new String[]{"IsDepDelayed_REC"};
        try {
            Scope.enter();
            GLMModel.GLMParameters params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.binomial);
            params._response_column = "IsDepDelayed";
            params._ignored_columns = ignoredCols;
            params._train = fr._key;
            params._valid = fr._key;
            params._lambda = null;
            params._alpha = new double[]{1.0};
            params._standardize = false;
            params._solver = GLMModel.GLMParameters.Solver.COORDINATE_DESCENT_NAIVE;
            params._lambda_search = true;
            params._nlambdas = 5;
            GLM glm = new GLM(params);
            model1 = (GLMModel)glm.trainModel().get();
            GLMModel.Submodel sm = ((GLMModel.GLMOutput)model1._output)._submodels[((GLMModel.GLMOutput)model1._output)._submodels.length - 1];
            double[] beta = sm.beta;
            System.out.println("lambda " + sm.lambda_value);
            double l1pen = ArrayUtils.l1norm((double[])beta, (boolean)true);
            double d = ArrayUtils.l2norm2((double[])beta, (boolean)true);
        }
        finally {
            fr.delete();
            if (model1 != null) {
                model1.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_COD_Airlines_LambdaSearch_CovUpdates() {
        GLMModel model1 = null;
        Frame fr = GLMTest.parse_test_file((Key)Key.make((String)"Airlines"), (String)"smalldata/airlines/AirlinesTrain.csv.zip");
        String[] ignoredCols = new String[]{"IsDepDelayed_REC"};
        try {
            Scope.enter();
            GLMModel.GLMParameters params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.binomial);
            params._response_column = "IsDepDelayed";
            params._ignored_columns = ignoredCols;
            params._train = fr._key;
            params._valid = fr._key;
            params._lambda = null;
            params._alpha = new double[]{1.0};
            params._standardize = false;
            params._solver = GLMModel.GLMParameters.Solver.COORDINATE_DESCENT;
            params._lambda_search = true;
            params._nlambdas = 5;
            GLM glm = new GLM(params);
            model1 = (GLMModel)glm.trainModel().get();
            GLMModel.Submodel sm = ((GLMModel.GLMOutput)model1._output)._submodels[((GLMModel.GLMOutput)model1._output)._submodels.length - 1];
            double[] beta = sm.beta;
            System.out.println("lambda " + sm.lambda_value);
            double l1pen = ArrayUtils.l1norm((double[])beta, (boolean)true);
            double d = ArrayUtils.l2norm2((double[])beta, (boolean)true);
        }
        finally {
            fr.delete();
            if (model1 != null) {
                model1.delete();
            }
        }
    }

    public static double residualDeviance(GLMModel m) {
        if (((GLMModel.GLMParameters)m._parms)._family == GLMModel.GLMParameters.Family.binomial || ((GLMModel.GLMParameters)m._parms)._family == GLMModel.GLMParameters.Family.quasibinomial) {
            ModelMetricsBinomialGLM metrics = (ModelMetricsBinomialGLM)((GLMModel.GLMOutput)m._output)._training_metrics;
            return metrics._resDev;
        }
        ModelMetricsRegressionGLM metrics = (ModelMetricsRegressionGLM)((GLMModel.GLMOutput)m._output)._training_metrics;
        return metrics._resDev;
    }

    public static double residualDevianceTest(GLMModel m) {
        if (((GLMModel.GLMParameters)m._parms)._family == GLMModel.GLMParameters.Family.binomial) {
            ModelMetricsBinomialGLM metrics = (ModelMetricsBinomialGLM)((GLMModel.GLMOutput)m._output)._validation_metrics;
            return metrics._resDev;
        }
        ModelMetricsRegressionGLM metrics = (ModelMetricsRegressionGLM)((GLMModel.GLMOutput)m._output)._validation_metrics;
        return metrics._resDev;
    }

    public static double nullDevianceTest(GLMModel m) {
        if (((GLMModel.GLMParameters)m._parms)._family == GLMModel.GLMParameters.Family.binomial) {
            ModelMetricsBinomialGLM metrics = (ModelMetricsBinomialGLM)((GLMModel.GLMOutput)m._output)._validation_metrics;
            return metrics._nullDev;
        }
        ModelMetricsRegressionGLM metrics = (ModelMetricsRegressionGLM)((GLMModel.GLMOutput)m._output)._validation_metrics;
        return metrics._nullDev;
    }

    public static double aic(GLMModel m) {
        if (((GLMModel.GLMParameters)m._parms)._family == GLMModel.GLMParameters.Family.binomial) {
            ModelMetricsBinomialGLM metrics = (ModelMetricsBinomialGLM)((GLMModel.GLMOutput)m._output)._training_metrics;
            return metrics._AIC;
        }
        ModelMetricsRegressionGLM metrics = (ModelMetricsRegressionGLM)((GLMModel.GLMOutput)m._output)._training_metrics;
        return metrics._AIC;
    }

    public static double nullDOF(GLMModel m) {
        if (((GLMModel.GLMParameters)m._parms)._family == GLMModel.GLMParameters.Family.binomial) {
            ModelMetricsBinomialGLM metrics = (ModelMetricsBinomialGLM)((GLMModel.GLMOutput)m._output)._training_metrics;
            return metrics._nullDegressOfFreedom;
        }
        ModelMetricsRegressionGLM metrics = (ModelMetricsRegressionGLM)((GLMModel.GLMOutput)m._output)._training_metrics;
        return metrics._nullDegressOfFreedom;
    }

    public static double resDOF(GLMModel m) {
        if (((GLMModel.GLMParameters)m._parms)._family == GLMModel.GLMParameters.Family.binomial || ((GLMModel.GLMParameters)m._parms)._family == GLMModel.GLMParameters.Family.quasibinomial) {
            ModelMetricsBinomialGLM metrics = (ModelMetricsBinomialGLM)((GLMModel.GLMOutput)m._output)._training_metrics;
            return metrics._residualDegressOfFreedom;
        }
        ModelMetricsRegressionGLM metrics = (ModelMetricsRegressionGLM)((GLMModel.GLMOutput)m._output)._training_metrics;
        return metrics._residualDegressOfFreedom;
    }

    public static double auc(GLMModel m) {
        ModelMetricsBinomialGLM metrics = (ModelMetricsBinomialGLM)((GLMModel.GLMOutput)m._output)._training_metrics;
        return metrics.auc_obj()._auc;
    }

    public static double logloss(GLMModel m) {
        ModelMetricsBinomialGLM metrics = (ModelMetricsBinomialGLM)((GLMModel.GLMOutput)m._output)._training_metrics;
        return metrics._logloss;
    }

    public static double mse(GLMModel m) {
        if (((GLMModel.GLMParameters)m._parms)._family == GLMModel.GLMParameters.Family.binomial) {
            ModelMetricsBinomialGLM metrics = (ModelMetricsBinomialGLM)((GLMModel.GLMOutput)m._output)._training_metrics;
            return metrics._MSE;
        }
        ModelMetricsRegressionGLM metrics = (ModelMetricsRegressionGLM)((GLMModel.GLMOutput)m._output)._training_metrics;
        return metrics._MSE;
    }

    public static double nullDeviance(GLMModel m) {
        if (((GLMModel.GLMParameters)m._parms)._family == GLMModel.GLMParameters.Family.binomial || ((GLMModel.GLMParameters)m._parms)._family == GLMModel.GLMParameters.Family.quasibinomial) {
            ModelMetricsBinomialGLM metrics = (ModelMetricsBinomialGLM)((GLMModel.GLMOutput)m._output)._training_metrics;
            return metrics._nullDev;
        }
        ModelMetricsRegressionGLM metrics = (ModelMetricsRegressionGLM)((GLMModel.GLMOutput)m._output)._training_metrics;
        return metrics._nullDev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProstate() throws InterruptedException, ExecutionException {
        GLMModel model = null;
        GLMModel model2 = null;
        GLMModel model3 = null;
        GLMModel model4 = null;
        Frame fr = GLMTest.parse_test_file((String)"smalldata/glm_test/prostate_cat_replaced.csv");
        try {
            double prior;
            Scope.enter();
            String[] cfs1 = new String[]{"Intercept", "AGE", "RACE.R2", "RACE.R3", "DPROS", "DCAPS", "PSA", "VOL", "GLEASON"};
            double[] vals = new double[]{-8.14867, -0.01368, 0.32337, -0.38028, 0.55964, 0.49548, 0.02794, -0.01104, 0.97704};
            GLMModel.GLMParameters params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.binomial);
            params._response_column = "CAPSULE";
            params._ignored_columns = new String[]{"ID"};
            params._train = fr._key;
            params._lambda = new double[]{0.0};
            params._standardize = false;
            GLM glm = new GLM(params);
            model = (GLMModel)glm.trainModel().get();
            Assert.assertTrue((((GLMModel.GLMOutput)model._output).bestSubmodel().iteration == 5 ? 1 : 0) != 0);
            model.delete();
            params._max_iterations = 4;
            glm = new GLM(params);
            model = (GLMModel)glm.trainModel().get();
            Assert.assertTrue((((GLMModel.GLMOutput)model._output).bestSubmodel().iteration == 4 ? 1 : 0) != 0);
            System.out.println(((GLMModel.GLMOutput)model._output)._model_summary);
            HashMap coefs = model.coefficients();
            System.out.println(coefs);
            for (int i = 0; i < cfs1.length; ++i) {
                Assert.assertEquals((double)vals[i], (double)((Double)coefs.get(cfs1[i])), (double)1.0E-4);
            }
            Assert.assertEquals((double)512.3, (double)GLMTest.nullDeviance(model), (double)0.1);
            Assert.assertEquals((double)378.3, (double)GLMTest.residualDeviance(model), (double)0.1);
            Assert.assertEquals((double)371.0, (double)GLMTest.resDOF(model), (double)0.0);
            Assert.assertEquals((double)396.3, (double)GLMTest.aic(model), (double)0.1);
            GLMTest.testScoring(model, fr);
            model.score(fr).delete();
            ModelMetricsBinomial mm = ModelMetricsBinomial.getFromDKV((Model)model, (Frame)fr);
            AUC2 adata = mm._auc;
            Assert.assertEquals((double)((GLMModel.GLMOutput)model._output)._training_metrics.auc_obj()._auc, (double)adata._auc, (double)1.0E-8);
            Assert.assertEquals((double)0.7588625640559653, (double)adata.pr_auc(), (double)1.0E-8);
            Assert.assertEquals((double)((GLMModel.GLMOutput)model._output)._training_metrics._MSE, (double)mm._MSE, (double)1.0E-8);
            Assert.assertEquals((double)((ModelMetricsBinomialGLM)((GLMModel.GLMOutput)model._output)._training_metrics)._resDev, (double)((ModelMetricsBinomialGLM)mm)._resDev, (double)1.0E-8);
            model.score(fr).delete();
            mm = ModelMetricsBinomial.getFromDKV((Model)model, (Frame)fr);
            Assert.assertEquals((double)((GLMModel.GLMOutput)model._output)._training_metrics.auc_obj()._auc, (double)adata._auc, (double)1.0E-8);
            Assert.assertEquals((double)((GLMModel.GLMOutput)model._output)._training_metrics._MSE, (double)mm._MSE, (double)1.0E-8);
            Assert.assertEquals((double)((ModelMetricsBinomialGLM)((GLMModel.GLMOutput)model._output)._training_metrics)._resDev, (double)((ModelMetricsBinomialGLM)mm)._resDev, (double)1.0E-8);
            params._prior = prior = 1.0E-5;
            glm = new GLM(params);
            model2 = (GLMModel)glm.trainModel().get();
            for (int i = 0; i < model2.beta().length - 1; ++i) {
                Assert.assertEquals((double)model.beta()[i], (double)model2.beta()[i], (double)1.0E-8);
            }
            Assert.assertEquals((double)(model.beta()[model.beta().length - 1] - Math.log(model._ymu[0] * (1.0 - prior) / (prior * (1.0 - model._ymu[0])))), (double)model2.beta()[model.beta().length - 1], (double)1.0E-10);
            params._lambda_search = true;
            params._lambda = null;
            params._alpha = new double[]{0.0};
            params._prior = -1.0;
            params._obj_reg = -1.0;
            params._max_iterations = 500;
            params._objective_epsilon = 1.0E-6;
            glm = new GLM(params);
            model3 = (GLMModel)glm.trainModel().get();
            double lambda = ((GLMModel.GLMOutput)model3._output)._submodels[((GLMModel.GLMOutput)model3._output)._best_lambda_idx].lambda_value;
            params._lambda_search = false;
            params._lambda = new double[]{lambda};
            ModelMetrics mm3 = ModelMetrics.getFromDKV((Model)model3, (Frame)fr);
            Assert.assertEquals((String)("mse don't match, " + ((GLMModel.GLMOutput)model3._output)._training_metrics._MSE + " != " + mm3._MSE), (double)((GLMModel.GLMOutput)model3._output)._training_metrics._MSE, (double)mm3._MSE, (double)1.0E-8);
            Assert.assertEquals((String)("res-devs don't match, " + ((ModelMetricsBinomialGLM)((GLMModel.GLMOutput)model3._output)._training_metrics)._resDev + " != " + ((ModelMetricsBinomialGLM)mm3)._resDev), (double)((ModelMetricsBinomialGLM)((GLMModel.GLMOutput)model3._output)._training_metrics)._resDev, (double)((ModelMetricsBinomialGLM)mm3)._resDev, (double)1.0E-4);
            fr.add("CAPSULE", fr.remove("CAPSULE"));
            fr.remove("ID").remove();
            DKV.put((Key)fr._key, (Iced)fr);
            DataInfo dinfo = new DataInfo(fr, null, 1, true, DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, true, false, false, false, false, false);
            model3.score(fr).delete();
            mm3 = ModelMetrics.getFromDKV((Model)model3, (Frame)fr);
            Assert.assertEquals((String)("mse don't match, " + ((GLMModel.GLMOutput)model3._output)._training_metrics._MSE + " != " + mm3._MSE), (double)((GLMModel.GLMOutput)model3._output)._training_metrics._MSE, (double)mm3._MSE, (double)1.0E-8);
            Assert.assertEquals((String)("res-devs don't match, " + ((ModelMetricsBinomialGLM)((GLMModel.GLMOutput)model3._output)._training_metrics)._resDev + " != " + ((ModelMetricsBinomialGLM)mm3)._resDev), (double)((ModelMetricsBinomialGLM)((GLMModel.GLMOutput)model3._output)._training_metrics)._resDev, (double)((ModelMetricsBinomialGLM)mm3)._resDev, (double)1.0E-4);
            glm = new GLM(params);
            model4 = (GLMModel)glm.trainModel().get();
            Assert.assertEquals((String)("mse don't match, " + ((GLMModel.GLMOutput)model3._output)._training_metrics._MSE + " != " + ((GLMModel.GLMOutput)model4._output)._training_metrics._MSE), (double)((GLMModel.GLMOutput)model3._output)._training_metrics._MSE, (double)((GLMModel.GLMOutput)model4._output)._training_metrics._MSE, (double)1.0E-6);
            Assert.assertEquals((String)("res-devs don't match, " + ((ModelMetricsBinomialGLM)((GLMModel.GLMOutput)model3._output)._training_metrics)._resDev + " != " + ((ModelMetricsBinomialGLM)((GLMModel.GLMOutput)model4._output)._training_metrics)._resDev), (double)((ModelMetricsBinomialGLM)((GLMModel.GLMOutput)model3._output)._training_metrics)._resDev, (double)((ModelMetricsBinomialGLM)((GLMModel.GLMOutput)model4._output)._training_metrics)._resDev, (double)1.0E-4);
            model4.score(fr).delete();
            ModelMetrics mm4 = ModelMetrics.getFromDKV((Model)model4, (Frame)fr);
            Assert.assertEquals((String)("mse don't match, " + mm3._MSE + " != " + mm4._MSE), (double)mm3._MSE, (double)mm4._MSE, (double)1.0E-6);
            Assert.assertEquals((String)("res-devs don't match, " + ((ModelMetricsBinomialGLM)mm3)._resDev + " != " + ((ModelMetricsBinomialGLM)mm4)._resDev), (double)((ModelMetricsBinomialGLM)mm3)._resDev, (double)((ModelMetricsBinomialGLM)mm4)._resDev, (double)1.0E-4);
        }
        finally {
            fr.delete();
            if (model != null) {
                model.delete();
            }
            if (model2 != null) {
                model2.delete();
            }
            if (model3 != null) {
                model3.delete();
            }
            if (model4 != null) {
                model4.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQuasibinomial() {
        GLMModel.GLMParameters params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.quasibinomial);
        GLM glm = new GLM(params);
        params.validate(glm);
        params._link = GLMModel.GLMParameters.Link.log;
        try {
            params.validate(glm);
            Assert.assertTrue((String)"should've thrown IAE", (boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        GLMModel model = null;
        Frame fr = GLMTest.parse_test_file((String)"smalldata/glm_test/prostate_cat_replaced.csv");
        try {
            Scope.enter();
            String[] cfs1 = new String[]{"Intercept", "AGE", "RACE.R2", "RACE.R3", "DPROS", "DCAPS", "PSA", "VOL", "GLEASON"};
            double[] vals = new double[]{-8.14867, -0.01368, 0.32337, -0.38028, 0.55964, 0.49548, 0.02794, -0.01104, 0.97704};
            params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.quasibinomial);
            params._response_column = "CAPSULE";
            params._ignored_columns = new String[]{"ID"};
            params._train = fr._key;
            params._lambda = new double[]{0.0};
            params._nfolds = 5;
            params._standardize = false;
            params._link = GLMModel.GLMParameters.Link.logit;
            glm = new GLM(params);
            model = (GLMModel)glm.trainModel().get();
            HashMap coefs = model.coefficients();
            System.out.println(coefs);
            for (int i = 0; i < cfs1.length; ++i) {
                Assert.assertEquals((double)vals[i], (double)((Double)coefs.get(cfs1[i])), (double)1.0E-4);
            }
            Assert.assertEquals((double)512.3, (double)GLMTest.nullDeviance(model), (double)0.1);
            Assert.assertEquals((double)378.3, (double)GLMTest.residualDeviance(model), (double)0.1);
            Assert.assertEquals((double)371.0, (double)GLMTest.resDOF(model), (double)0.0);
        }
        finally {
            fr.delete();
            if (model != null) {
                model.deleteCrossValidationModels();
                model.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSynthetic() throws Exception {
        GLMModel model = null;
        Frame fr = GLMTest.parse_test_file((String)"smalldata/glm_test/glm_test2.csv");
        Frame score = null;
        try {
            Scope.enter();
            GLMModel.GLMParameters params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.binomial);
            params._response_column = "response";
            params._ignored_columns = new String[]{"ID"};
            params._train = fr._key;
            params._lambda = new double[]{0.0};
            params._standardize = false;
            params._max_iterations = 20;
            GLM glm = new GLM(params);
            model = (GLMModel)glm.trainModel().get();
            double[] beta = model.beta();
            System.out.println("beta = " + Arrays.toString(beta));
            Assert.assertEquals((double)GLMTest.auc(model), (double)1.0, (double)1.0E-4);
            score = model.score(fr);
            ModelMetricsBinomial mm = ModelMetricsBinomial.getFromDKV((Model)model, (Frame)fr);
            AUC2 adata = mm._auc;
            Assert.assertEquals((double)GLMTest.auc(model), (double)adata._auc, (double)0.01);
        }
        finally {
            fr.remove();
            if (model != null) {
                model.delete();
            }
            if (score != null) {
                score.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCitibikeReproPUBDEV1839() throws Exception {
        GLMModel model = null;
        Frame tfr = GLMTest.parse_test_file((String)"smalldata/jira/pubdev_1839_repro_train.csv");
        Frame vfr = GLMTest.parse_test_file((String)"smalldata/jira/pubdev_1839_repro_test.csv");
        try {
            Scope.enter();
            GLMModel.GLMParameters params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.poisson);
            params._response_column = "bikes";
            params._train = tfr._key;
            params._valid = vfr._key;
            GLM glm = new GLM(params);
            model = (GLMModel)glm.trainModel().get();
            GLMTest.testScoring(model, vfr);
        }
        finally {
            tfr.remove();
            vfr.remove();
            if (model != null) {
                model.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCitibikeReproPUBDEV1953() throws Exception {
        GLMModel model = null;
        Frame tfr = GLMTest.parse_test_file((String)"smalldata/glm_test/citibike_small_train.csv");
        Frame vfr = GLMTest.parse_test_file((String)"smalldata/glm_test/citibike_small_test.csv");
        try {
            Scope.enter();
            GLMModel.GLMParameters params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.poisson);
            params._response_column = "bikes";
            params._train = tfr._key;
            params._valid = vfr._key;
            params._family = GLMModel.GLMParameters.Family.poisson;
            GLM glm = new GLM(params);
            model = (GLMModel)glm.trainModel().get();
            GLMTest.testScoring(model, vfr);
        }
        finally {
            tfr.remove();
            vfr.remove();
            if (model != null) {
                model.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testXval() {
        GLMModel model = null;
        Frame fr = GLMTest.parse_test_file((String)"smalldata/glm_test/prostate_cat_replaced.csv");
        try {
            GLMModel.GLMParameters params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.binomial);
            params._response_column = "CAPSULE";
            params._ignored_columns = new String[]{"ID"};
            params._train = fr._key;
            params._lambda_search = true;
            params._nfolds = 3;
            params._standardize = false;
            params._keep_cross_validation_models = true;
            GLM glm = new GLM(params);
            model = (GLMModel)glm.trainModel().get();
        }
        finally {
            fr.delete();
            if (model != null) {
                for (Key k : ((GLMModel.GLMOutput)model._output)._cross_validation_models) {
                    Keyed.remove((Key)k);
                }
                model.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomLambdaSearch() {
        Key pros = Key.make((String)"prostate");
        Frame f = GLMTest.parse_test_file((Key)pros, (String)"smalldata/glm_test/prostate_cat_replaced.csv");
        for (GLMModel.GLMParameters.Family fam : new GLMModel.GLMParameters.Family[]{GLMModel.GLMParameters.Family.multinomial, GLMModel.GLMParameters.Family.binomial}) {
            for (double alpha : new double[]{0.0, 0.5, 1.0}) {
                for (GLMModel.GLMParameters.Solver s : GLMModel.GLMParameters.Solver.values()) {
                    if (s == GLMModel.GLMParameters.Solver.COORDINATE_DESCENT_NAIVE || s == GLMModel.GLMParameters.Solver.AUTO || s.equals((Object)GLMModel.GLMParameters.Solver.GRADIENT_DESCENT_LH) || s.equals((Object)GLMModel.GLMParameters.Solver.GRADIENT_DESCENT_SQERR)) continue;
                    try {
                        Scope.enter();
                        GLMModel.GLMParameters parms = new GLMModel.GLMParameters(fam);
                        parms._train = pros;
                        parms._alpha = new double[]{alpha};
                        parms._solver = s;
                        parms._lambda = new double[]{10.0, 1.0, 0.1, 1.0E-5, 0.0};
                        parms._lambda_search = true;
                        parms._response_column = fam == GLMModel.GLMParameters.Family.multinomial ? "RACE" : "CAPSULE";
                        GLMModel model = (GLMModel)new GLM(parms).trainModel().get();
                        GLMModel.RegularizationPath rp = model.getRegularizationPath();
                        for (int i = 0; i < parms._lambda.length; ++i) {
                            GLMModel.GLMParameters parms2 = new GLMModel.GLMParameters(fam);
                            parms2._train = pros;
                            parms2._alpha = new double[]{alpha};
                            parms2._solver = s;
                            parms2._lambda = new double[]{parms._lambda[i]};
                            parms2._lambda_search = false;
                            parms2._response_column = fam == GLMModel.GLMParameters.Family.multinomial ? "RACE" : "CAPSULE";
                            parms2._beta_epsilon = 1.0E-5;
                            parms2._objective_epsilon = 1.0E-8;
                            GLMModel model2 = (GLMModel)new GLM(parms2).trainModel().get();
                            double[] beta_ls = rp._coefficients_std[i];
                            double[] beta = fam == GLMModel.GLMParameters.Family.multinomial ? ArrayUtils.flat((double[][])((GLMModel.GLMOutput)model2._output).getNormBetaMultinomial()) : ((GLMModel.GLMOutput)model2._output).getNormBeta();
                            System.out.println(ArrayUtils.pprint((double[][])new double[][]{beta, beta_ls}));
                            double null_dev = ((GLMMetrics)((GLMModel.GLMOutput)model2._output)._training_metrics).null_deviance();
                            double res_dev_ls = null_dev * (1.0 - rp._explained_deviance_train[i]);
                            double likelihood_ls = 0.5 * res_dev_ls;
                            double likelihood = 0.5 * ((GLMMetrics)((GLMModel.GLMOutput)model2._output)._training_metrics).residual_deviance();
                            double nobs = model._nobs;
                            if (fam == GLMModel.GLMParameters.Family.multinomial) {
                                beta = (double[])beta.clone();
                                beta_ls = (double[])beta_ls.clone();
                                int P = beta.length / ((GLMModel.GLMOutput)model._output).nclasses();
                                assert (beta.length == P * ((GLMModel.GLMOutput)model._output).nclasses());
                                for (int j = P - 1; j < beta.length; j += P) {
                                    beta[j] = 0.0;
                                    beta_ls[j] = 0.0;
                                }
                            }
                            double obj_ls = likelihood_ls / nobs + (1.0 - alpha) * parms._lambda[i] * 0.5 * ArrayUtils.l2norm2((double[])beta_ls, (boolean)true) + alpha * parms._lambda[i] * ArrayUtils.l1norm((double[])beta_ls, (boolean)true);
                            double obj = likelihood / nobs + (1.0 - alpha) * parms._lambda[i] * 0.5 * ArrayUtils.l2norm2((double[])beta, (boolean)true) + alpha * parms._lambda[i] * ArrayUtils.l1norm((double[])beta, (boolean)true);
                            Assert.assertEquals((double)obj, (double)obj_ls, (double)(2.0 * parms._objective_epsilon));
                            model2.delete();
                        }
                        model.delete();
                    }
                    finally {
                        Scope.exit((Key[])new Key[0]);
                    }
                }
            }
        }
        f.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArcene() throws InterruptedException, ExecutionException {
        Key parsed = Key.make((String)"arcene_parsed");
        Key modelKey = Key.make((String)"arcene_model");
        GLMModel model = null;
        Frame fr = GLMTest.parse_test_file((Key)parsed, (String)"smalldata/glm_test/arcene.csv");
        try {
            Scope.enter();
            GLMModel.GLMParameters params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.gaussian);
            params._lambda = null;
            params._response_column = fr._names[0];
            params._train = parsed;
            params._lambda_search = true;
            params._nlambdas = 35;
            params._lambda_min_ratio = 0.18;
            params._max_iterations = 100000;
            params._max_active_predictors = 10000;
            params._alpha = new double[]{1.0};
            GLMModel.GLMParameters.Solver[] solverArray = new GLMModel.GLMParameters.Solver[]{GLMModel.GLMParameters.Solver.IRLSM, GLMModel.GLMParameters.Solver.COORDINATE_DESCENT};
            int n = solverArray.length;
            for (int i = 0; i < n; ++i) {
                GLMModel.GLMParameters.Solver s;
                params._solver = s = solverArray[i];
                GLM glm = new GLM(params, modelKey);
                glm.trainModel().get();
                model = (GLMModel)DKV.get((Key)modelKey).get();
                System.out.println(((GLMModel.GLMOutput)model._output)._model_summary);
                Assert.assertEquals((long)params._nlambdas, (long)((GLMModel.GLMOutput)model._output)._submodels.length);
                System.out.println(((GLMModel.GLMOutput)model._output)._training_metrics);
            }
            model.delete();
            params._solver = GLMModel.GLMParameters.Solver.COORDINATE_DESCENT;
            params._max_active_predictors = 100;
            params._lambda_min_ratio = 0.01;
            params._nlambdas = 100;
            GLM glm = new GLM(params, modelKey);
            glm.trainModel().get();
            model = (GLMModel)DKV.get((Key)modelKey).get();
            Assert.assertTrue((((GLMModel.GLMOutput)model._output).rank() <= params._max_active_predictors ? 1 : 0) != 0);
            System.out.println(((GLMModel.GLMOutput)model._output)._model_summary);
            System.out.println(((GLMModel.GLMOutput)model._output)._training_metrics);
            System.out.println("============================================================================================================");
            model.delete();
            params._max_active_predictors = 250;
            params._lambda = null;
            params._lambda_search = false;
            glm = new GLM(params, modelKey);
            glm.trainModel().get();
            model = (GLMModel)DKV.get((Key)modelKey).get();
            Assert.assertTrue((((GLMModel.GLMOutput)model._output).rank() <= params._max_active_predictors ? 1 : 0) != 0);
            System.out.println(((GLMModel.GLMOutput)model._output)._model_summary);
            System.out.println(((GLMModel.GLMOutput)model._output)._training_metrics);
            System.out.println("============================================================================================================");
            model.delete();
        }
        finally {
            fr.delete();
            if (model != null) {
                model.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBigPOJO() {
        GLMModel model = null;
        Frame fr = GLMTest.parse_test_file((Key)Key.make((String)"arcene_parsed"), (String)"smalldata/glm_test/arcene.csv");
        Frame res = null;
        try {
            Scope.enter();
            GLMModel.GLMParameters params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.gaussian);
            params._lambda = null;
            params._response_column = fr._names[0];
            params._train = fr._key;
            params._max_active_predictors = 100000;
            params._alpha = new double[]{0.0};
            params._solver = GLMModel.GLMParameters.Solver.L_BFGS;
            GLM glm = new GLM(params);
            model = (GLMModel)glm.trainModel().get();
            res = model.score(fr);
            model.testJavaScoring(fr, res, 0.0);
        }
        finally {
            fr.delete();
            if (model != null) {
                model.delete();
            }
            if (res != null) {
                res.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAbalone() {
        Scope.enter();
        GLMModel model = null;
        try {
            Frame fr = GLMTest.parse_test_file((String)"smalldata/glm_test/Abalone.gz");
            Scope.track((Frame[])new Frame[]{fr});
            GLMModel.GLMParameters params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.gaussian);
            params._train = fr._key;
            params._response_column = fr._names[8];
            params._alpha = new double[]{1.0};
            params._lambda_search = true;
            GLM glm = new GLM(params);
            model = (GLMModel)glm.trainModel().get();
            GLMTest.testScoring(model, fr);
        }
        finally {
            if (model != null) {
                model.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    @Test
    public void testZeroedColumn() {
        Vec x = Vec.makeCon((Key)Vec.newKey(), (double[])new double[]{1.0, 2.0, 3.0, 4.0, 5.0});
        Vec y = Vec.makeCon((Key)x.group().addVec(), (double[])new double[]{0.0, 1.0, 0.0, 1.0, 0.0});
        Vec z = Vec.makeCon((Key)Vec.newKey(), (double[])new double[]{1.0, 2.0, 3.0, 4.0, 5.0});
        Vec w = Vec.makeCon((Key)x.group().addVec(), (double[])new double[]{1.0, 0.0, 1.0, 0.0, 1.0});
        Frame fr = new Frame(Key.make((String)"test"), new String[]{"x", "y", "z", "w"}, new Vec[]{x, y, z, w});
        DKV.put((Keyed)fr);
        GLMModel.GLMParameters parms = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.gaussian);
        parms._train = fr._key;
        parms._lambda = new double[]{0.0};
        parms._alpha = new double[]{0.0};
        parms._compute_p_values = true;
        parms._response_column = "z";
        parms._weights_column = "w";
        GLMModel m = (GLMModel)new GLM(parms).trainModel().get();
        System.out.println(m.coefficients());
        m.delete();
        fr.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeviances() {
        for (GLMModel.GLMParameters.Family fam : GLMModel.GLMParameters.Family.values()) {
            if (fam == GLMModel.GLMParameters.Family.quasibinomial || fam == GLMModel.GLMParameters.Family.ordinal) continue;
            Frame tfr = null;
            Frame res = null;
            Frame preds = null;
            GLMModel gbm = null;
            try {
                tfr = GLMTest.parse_test_file((String)"./smalldata/gbm_test/BostonHousing.csv");
                GLMModel.GLMParameters parms = new GLMModel.GLMParameters();
                parms._train = tfr._key;
                String resp = tfr.lastVecName();
                if (fam == GLMModel.GLMParameters.Family.binomial || fam == GLMModel.GLMParameters.Family.multinomial) {
                    resp = fam == GLMModel.GLMParameters.Family.multinomial ? "rad" : "chas";
                    Vec v = tfr.remove(resp);
                    tfr.add(resp, v.toCategoricalVec());
                    v.remove();
                    DKV.put((Keyed)tfr);
                }
                parms._response_column = resp;
                parms._family = fam;
                gbm = (GLMModel)new GLM(parms).trainModel().get();
                preds = gbm.score(tfr);
                res = gbm.computeDeviances(tfr, preds, "myDeviances");
                double meanDeviances = res.anyVec().mean();
                if (((GLMModel.GLMOutput)gbm._output).nclasses() == 2) {
                    Assert.assertEquals((double)meanDeviances, (double)((ModelMetricsBinomial)((GLMModel.GLMOutput)gbm._output)._training_metrics)._logloss, (double)(1.0E-6 * Math.abs(meanDeviances)));
                    continue;
                }
                if (((GLMModel.GLMOutput)gbm._output).nclasses() > 2) {
                    Assert.assertEquals((double)meanDeviances, (double)((ModelMetricsMultinomial)((GLMModel.GLMOutput)gbm._output)._training_metrics)._logloss, (double)(1.0E-6 * Math.abs(meanDeviances)));
                    continue;
                }
                Assert.assertEquals((double)meanDeviances, (double)((ModelMetricsRegression)((GLMModel.GLMOutput)gbm._output)._training_metrics)._mean_residual_deviance, (double)(1.0E-6 * Math.abs(meanDeviances)));
            }
            finally {
                if (tfr != null) {
                    tfr.delete();
                }
                if (res != null) {
                    res.delete();
                }
                if (preds != null) {
                    preds.delete();
                }
                if (gbm != null) {
                    gbm.delete();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnseenLevels() {
        Scope.enter();
        try {
            Vec v0 = Vec.makeCon((Key)Vec.newKey(), (double[])new double[]{1.0, 0.0, 0.0, 1.0, 1.0});
            v0.setDomain(new String[]{"blue", "red"});
            Frame trn = new Frame(Key.make((String)"train"), new String[]{"color", "label"}, new Vec[]{v0, v0.makeCopy(null)});
            DKV.put((Keyed)trn);
            Vec v3 = Vec.makeCon((Key)Vec.newKey(), (double[])new double[]{1.0, 0.0, 0.0, 2.0});
            v3.setDomain(new String[]{"blue", "red", "yellow"});
            Vec v5 = Vec.makeCon((Key)v3.group().addVec(), (double[])new double[]{1.0, 0.0, 0.0, 0.0});
            Frame tst = new Frame(Key.make((String)"test"), new String[]{"color", "label"}, new Vec[]{v3, v5});
            DKV.put((Keyed)tst);
            GLMModel.GLMParameters parms = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.gaussian);
            parms._train = trn._key;
            parms._response_column = "label";
            parms._missing_values_handling = GLMModel.GLMParameters.MissingValuesHandling.Skip;
            GLMModel m = (GLMModel)new GLM(parms).trainModel().get();
            System.out.println("coefficients = " + m.coefficients());
            double icpt = (Double)m.coefficients().get("Intercept");
            Frame preds = m.score(tst);
            Assert.assertEquals((double)(icpt + (Double)m.coefficients().get("color.red")), (double)preds.vec(0).at(0L), (double)0.0);
            Assert.assertEquals((double)(icpt + (Double)m.coefficients().get("color.blue")), (double)preds.vec(0).at(1L), (double)0.0);
            Assert.assertEquals((double)(icpt + (Double)m.coefficients().get("color.blue")), (double)preds.vec(0).at(2L), (double)0.0);
            Assert.assertEquals((double)icpt, (double)preds.vec(0).at(3L), (double)0.0);
            parms._missing_values_handling = GLMModel.GLMParameters.MissingValuesHandling.MeanImputation;
            GLMModel m2 = (GLMModel)new GLM(parms).trainModel().get();
            Frame preds2 = m2.score(tst);
            icpt = (Double)m2.coefficients().get("Intercept");
            System.out.println("coefficients = " + m2.coefficients());
            Assert.assertEquals((double)(icpt + (Double)m2.coefficients().get("color.red")), (double)preds2.vec(0).at(0L), (double)0.0);
            Assert.assertEquals((double)(icpt + (Double)m2.coefficients().get("color.blue")), (double)preds2.vec(0).at(1L), (double)0.0);
            Assert.assertEquals((double)(icpt + (Double)m2.coefficients().get("color.blue")), (double)preds2.vec(0).at(2L), (double)0.0);
            Assert.assertEquals((double)(icpt + (Double)m2.coefficients().get("color.red")), (double)preds2.vec(0).at(3L), (double)0.0);
            trn.delete();
            tst.delete();
            m.delete();
            preds.delete();
            preds2.delete();
            m2.delete();
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    private static final class GLMIterationTaskTest
    extends GLMTask.GLMIterationTask {
        final GLMModel _m;
        GLMMetricBuilder _val2;

        public GLMIterationTaskTest(Key jobKey, DataInfo dinfo, double lambda, GLMModel.GLMParameters glm, boolean validate, double[] beta, double ymu, GLMModel m) {
            super(jobKey, dinfo, new GLMModel.GLMWeightsFun(glm), beta);
            this._m = m;
        }

        public void map(Chunk[] chks) {
            super.map(chks);
            this._val2 = (GLMMetricBuilder)this._m.makeMetricBuilder(chks[chks.length - 1].vec().domain());
            double[] ds = new double[3];
            float[] actual = new float[1];
            for (int i = 0; i < chks[0]._len; ++i) {
                this._m.score0(chks, i, null, ds);
                actual[0] = (float)chks[chks.length - 1].atd(i);
                this._val2.perRow(ds, actual, (Model)this._m);
            }
        }

        public void reduce(GLMTask.GLMIterationTask gmt) {
            super.reduce(gmt);
            GLMIterationTaskTest g = (GLMIterationTaskTest)gmt;
            this._val2.reduce(g._val2);
        }
    }

    public static class TestScore0
    extends MRTask {
        final GLMModel _m;
        final boolean _weights;
        final boolean _offset;

        public TestScore0(GLMModel m, boolean w, boolean o) {
            this._m = m;
            this._weights = w;
            this._offset = o;
        }

        private void checkScore(long rid, double[] predictions, double[] outputs) {
            int start = 0;
            if (((GLMModel.GLMParameters)this._m._parms)._family == GLMModel.GLMParameters.Family.binomial && Math.abs(predictions[2] - this._m.defaultThreshold()) < 1.0E-10) {
                start = 1;
            }
            if (((GLMModel.GLMParameters)this._m._parms)._family == GLMModel.GLMParameters.Family.multinomial) {
                double[] maxs = new double[2];
                for (int j = 1; j < predictions.length; ++j) {
                    if (!(predictions[j] > maxs[0])) continue;
                    if (predictions[j] > maxs[1]) {
                        maxs[0] = maxs[1];
                        maxs[1] = predictions[j];
                        continue;
                    }
                    maxs[0] = predictions[j];
                }
                if (maxs[1] - maxs[0] < 1.0E-10) {
                    start = 1;
                }
            }
            for (int j = start; j < predictions.length; ++j) {
                Assert.assertEquals((String)("mismatch at row " + rid + ", p = " + j + ": " + outputs[j] + " != " + predictions[j] + ", predictions = " + Arrays.toString(predictions) + ", output = " + Arrays.toString(outputs)), (double)outputs[j], (double)predictions[j], (double)1.0E-6);
            }
        }

        public void map(Chunk[] chks) {
            int nout = ((GLMModel.GLMParameters)this._m._parms)._family == GLMModel.GLMParameters.Family.multinomial ? ((GLMModel.GLMOutput)this._m._output).nclasses() + 1 : (((GLMModel.GLMParameters)this._m._parms)._family == GLMModel.GLMParameters.Family.binomial ? 3 : 1);
            Chunk[] outputChks = Arrays.copyOfRange(chks, chks.length - nout, chks.length);
            chks = Arrays.copyOf(chks, chks.length - nout);
            C0DChunk off = new C0DChunk(0.0, chks[0]._len);
            double[] tmp = new double[((GLMModel.GLMOutput)this._m._output)._dinfo._cats + ((GLMModel.GLMOutput)this._m._output)._dinfo._nums];
            double[] predictions = new double[nout];
            double[] outputs = new double[nout];
            if (this._offset) {
                off = chks[chks.length - 1];
                chks = Arrays.copyOf(chks, chks.length - 1);
            }
            if (this._weights) {
                chks = Arrays.copyOf(chks, chks.length - 1);
            }
            for (int i = 0; i < chks[0]._len; ++i) {
                if (this._weights || this._offset) {
                    this._m.score0(chks, off.atd(i), i, tmp, predictions);
                } else {
                    this._m.score0(chks, i, tmp, predictions);
                }
                for (int j = 0; j < predictions.length; ++j) {
                    outputs[j] = outputChks[j].atd(i);
                }
                this.checkScore((long)i + chks[0].start(), predictions, outputs);
            }
        }
    }
}

