/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import hex.CreateFrame;
import hex.DataInfo;
import hex.SplitFrame;
import hex.glm.GLM;
import hex.glm.GLMModel;
import hex.glm.GLMTask;
import java.util.Arrays;
import java.util.Random;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import water.DKV;
import water.Iced;
import water.Key;
import water.Keyed;
import water.MemoryManager;
import water.Scope;
import water.TestUtil;
import water.fvec.Frame;
import water.util.Log;
import water.util.RandomUtils;

public class GLMBasicTestOrdinal
extends TestUtil {
    private static final double _tol = 1.0E-10;

    @BeforeClass
    public static void stall() {
        GLMBasicTestOrdinal.stall_till_cloudsize((int)1);
    }

    private void convert2Enum(Frame f, int[] cols) {
        for (int col : cols) {
            f.replace(col, f.vec(col).toCategoricalVec()).remove();
        }
        DKV.put((Keyed)f);
    }

    @Test
    public void testCheckGradientBinomial() {
        try {
            Scope.enter();
            Frame trainBinomialEnum = GLMBasicTestOrdinal.parse_test_file((String)"smalldata/glm_ordinal_logit/ordinal_binomial_training_set_enum_small.csv");
            this.convert2Enum(trainBinomialEnum, new int[]{0, 1, 2, 3, 4, 5, 6, 34});
            Frame trainBinomial = GLMBasicTestOrdinal.parse_test_file((String)"smalldata/glm_ordinal_logit/ordinal_binomial_training_set_small.csv");
            this.convert2Enum(trainBinomial, new int[]{34});
            Scope.track((Frame[])new Frame[]{trainBinomialEnum});
            Scope.track((Frame[])new Frame[]{trainBinomial});
            this.checkGradientWithBinomial(trainBinomial, 34, "C35");
            this.checkGradientWithBinomial(trainBinomialEnum, 34, "C35");
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    @Test
    public void testOrdinalPredMojoPojo() {
        this.testOrdinalMojoPojo(GLMModel.GLMParameters.Solver.AUTO);
        this.testOrdinalMojoPojo(GLMModel.GLMParameters.Solver.GRADIENT_DESCENT_SQERR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOrdinalMojoPojo(GLMModel.GLMParameters.Solver sol) {
        try {
            Scope.enter();
            CreateFrame cf = new CreateFrame();
            Random generator = new Random();
            int numRows = generator.nextInt(10000) + 15000 + 200;
            int numCols = generator.nextInt(17) + 3;
            int response_factors = generator.nextInt(7) + 3;
            cf.rows = numRows;
            cf.cols = numCols;
            cf.factors = 10;
            cf.has_response = true;
            cf.response_factors = response_factors;
            cf.positive_response = true;
            cf.missing_fraction = 0.0;
            cf.seed = System.currentTimeMillis();
            System.out.println("Createframe parameters: rows: " + numRows + " cols:" + numCols + " response number:" + response_factors + " seed: " + cf.seed);
            Frame trainMultinomial = Scope.track((Frame[])new Frame[]{(Frame)cf.execImpl().get()});
            SplitFrame sf = new SplitFrame(trainMultinomial, new double[]{0.8, 0.2}, new Key[]{Key.make((String)"train.hex"), Key.make((String)"test.hex")});
            sf.exec().get();
            Key[] ksplits = sf._destination_frames;
            Frame tr = (Frame)DKV.get((Key)ksplits[0]).get();
            Frame te = (Frame)DKV.get((Key)ksplits[1]).get();
            Scope.track((Frame[])new Frame[]{tr});
            Scope.track((Frame[])new Frame[]{te});
            GLMModel.GLMParameters paramsO = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.ordinal, GLMModel.GLMParameters.Family.ordinal.defaultLink, new double[]{0.0}, new double[]{0.0}, 0.0, 0.0);
            paramsO._train = tr._key;
            paramsO._lambda_search = false;
            paramsO._response_column = "response";
            paramsO._lambda = new double[]{0.0};
            paramsO._alpha = new double[]{0.001};
            paramsO._objective_epsilon = 1.0E-6;
            paramsO._beta_epsilon = 1.0E-4;
            paramsO._standardize = false;
            paramsO._solver = sol;
            GLMModel model = (GLMModel)new GLM(paramsO).trainModel().get();
            Scope.track_generic((Keyed)model);
            Frame pred = model.score(te);
            Scope.track((Frame[])new Frame[]{pred});
            Assert.assertTrue((boolean)model.testJavaScoring(te, pred, 1.0E-10));
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrdinalMultinomial() {
        try {
            Scope.enter();
            Frame trainMultinomial = Scope.track((Frame[])new Frame[]{GLMBasicTestOrdinal.parse_test_file((String)"smalldata/glm_ordinal_logit/ordinal_multinomial_training_set_small.csv")});
            this.convert2Enum(trainMultinomial, new int[]{25});
            int iterNum = new Random().nextInt(10) + 2;
            Log.info((Object[])new Object[]{"testOrdinalMultinomial will use iterNum = " + iterNum});
            GLMModel.GLMParameters paramsO = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.ordinal, GLMModel.GLMParameters.Family.ordinal.defaultLink, new double[]{0.0}, new double[]{0.0}, 0.0, 0.0);
            paramsO._train = trainMultinomial._key;
            paramsO._lambda_search = false;
            paramsO._response_column = "C26";
            paramsO._lambda = new double[]{1.0E-6};
            paramsO._alpha = new double[]{1.0E-5};
            paramsO._objective_epsilon = 1.0E-6;
            paramsO._beta_epsilon = 1.0E-4;
            paramsO._max_iterations = iterNum;
            paramsO._standardize = false;
            paramsO._seed = 987654321L;
            paramsO._obj_reg = 1.0E-7;
            GLMModel model = (GLMModel)new GLM(paramsO).trainModel().get();
            Scope.track_generic((Keyed)model);
            double[] interceptPDF = model._ymu;
            double[][] coeffs = ((GLMModel.GLMOutput)model._output)._global_beta_multinomial;
            double[] beta = new double[coeffs[0].length - 1];
            double[] icpt = new double[coeffs.length - 1];
            this.updateOrdinalCoeff(trainMultinomial, 25, paramsO, interceptPDF, coeffs[0].length, Integer.parseInt(((GLMModel.GLMOutput)model._output)._model_summary.getCellValues()[0][5].toString()), beta, icpt);
            this.compareMultCoeffs(coeffs, beta, icpt);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    public void compareMultCoeffs(double[][] coeffs, double[] beta, double[] icpt) {
        for (int predInd = 0; predInd < beta.length; ++predInd) {
            Assert.assertEquals((double)coeffs[0][predInd], (double)beta[predInd], (double)1.0E-10);
        }
        for (int icptInd = 0; icptInd < icpt.length; ++icptInd) {
            Assert.assertEquals((double)coeffs[icptInd][beta.length], (double)icpt[icptInd], (double)1.0E-10);
        }
    }

    public void updateOrdinalCoeff(Frame fr, int respCol, GLMModel.GLMParameters params, double[] icptPDF, int npred, int numRuns, double[] beta, double[] intercpts) {
        int nclass = icptPDF.length;
        int lastClass = nclass - 1;
        int lastPred = npred - 1;
        double[] betaGrad = new double[lastPred];
        double[] icptGrad = new double[lastClass];
        double multiplier = 0.0;
        double[] multiplierI = new double[2];
        double l2pen = params._lambda[0] * (1.0 - params._alpha[0]);
        double l1pen = params._lambda[0] * params._alpha[0];
        double reg = params._obj_reg;
        Random rng = RandomUtils.getRNG((long[])new long[]{params._seed});
        double[] tempIcpt = new double[lastClass];
        for (int i = 0; i < lastClass; ++i) {
            tempIcpt[i] = (-1.0 + 2.0 * rng.nextDouble()) * (double)nclass;
        }
        Arrays.sort(tempIcpt);
        for (int index = 0; index < lastClass; ++index) {
            intercpts[index] = tempIcpt[index];
        }
        int rowNum = (int)fr.numRows();
        for (int iter = 0; iter < numRuns; ++iter) {
            for (int row = 0; row < rowNum; ++row) {
                int yresp = (int)fr.vec(respCol).at((long)row);
                Arrays.fill(multiplierI, 0.0);
                if (yresp == 0) {
                    multiplierI[0] = multiplier = this.getCDF(fr, row, beta, intercpts, yresp) - 1.0;
                } else if (yresp == lastClass) {
                    multiplierI[0] = multiplier = this.getCDF(fr, row, beta, intercpts, yresp - 1);
                } else {
                    int pC = yresp - 1;
                    double cdfC = this.getCDF(fr, row, beta, intercpts, yresp);
                    double cdfPC = this.getCDF(fr, row, beta, intercpts, pC);
                    multiplier = cdfC + cdfPC - 1.0;
                    double delta = cdfC - cdfPC;
                    double oneODelta = 1.0 / (delta == 0.0 ? 1.0E-10 : delta);
                    multiplierI[0] = -this.getCDFDeriv(cdfC) * oneODelta;
                    multiplierI[1] = this.getCDFDeriv(cdfPC) * oneODelta;
                }
                if (multiplier != 0.0) {
                    for (int predInd = 0; predInd < lastPred; ++predInd) {
                        int n = predInd;
                        betaGrad[n] = betaGrad[n] + multiplier * fr.vec(predInd).at((long)row);
                    }
                }
                if (yresp < lastClass) {
                    int n = yresp;
                    icptGrad[n] = icptGrad[n] + multiplierI[0];
                    if (yresp <= 0) continue;
                    int n2 = yresp - 1;
                    icptGrad[n2] = icptGrad[n2] + multiplierI[1];
                    continue;
                }
                int n = yresp - 1;
                icptGrad[n] = icptGrad[n] + multiplierI[0];
            }
            this.addGradChange(beta, betaGrad, intercpts, icptGrad, l2pen, l1pen, reg);
            Arrays.fill(betaGrad, 0.0);
            Arrays.fill(icptGrad, 0.0);
        }
    }

    public void addGradChange(double[] beta, double[] betaGrad, double[] icpt, double[] icptGrad, double l2pen, double l1pen, double reg) {
        int npred = beta.length;
        int nicpt = icpt.length;
        for (int npredInd = 0; npredInd < npred; ++npredInd) {
            int n = npredInd;
            betaGrad[n] = betaGrad[n] * reg;
            int n2 = npredInd;
            betaGrad[n2] = betaGrad[n2] + l2pen * beta[npredInd];
            int n3 = npredInd;
            betaGrad[n3] = betaGrad[n3] + (l1pen == 0.0 ? 0.0 : (beta[npredInd] > 0.0 ? l1pen : -l1pen));
            int n4 = npredInd;
            beta[n4] = beta[n4] - betaGrad[npredInd];
        }
        for (int icptInd = 0; icptInd < nicpt; ++icptInd) {
            int n = icptInd;
            icpt[n] = icpt[n] - icptGrad[icptInd] * reg;
        }
    }

    double getCDFDeriv(double x) {
        return x * (1.0 - x);
    }

    double getCDF(Frame fr, int row, double[] beta, double[] icpt, int respClass) {
        int colNum = fr.numCols() - 1;
        double eta = 0.0;
        for (int colInd = 0; colInd < colNum; ++colInd) {
            eta += beta[colInd] * fr.vec(colInd).at((long)row);
        }
        if (respClass < icpt.length) {
            double expEta = Math.exp(eta += icpt[respClass]);
            return expEta / (1.0 + expEta);
        }
        double expEta = Math.exp(eta += icpt[icpt.length - 1]);
        return 1.0 - expEta / (1.0 + expEta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkGradientWithBinomial(Frame fr, int respCol, String resp) {
        DataInfo dinfo = null;
        DataInfo odinfo = null;
        try {
            int nclasses = fr.vec(respCol).domain().length;
            GLMModel.GLMParameters params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.binomial, GLMModel.GLMParameters.Family.binomial.defaultLink, new double[]{0.0}, new double[]{0.0}, 0.0, 0.0);
            params._train = fr._key;
            params._lambda = new double[]{1.0E-4};
            params._alpha = new double[]{0.5};
            params._lambda_search = false;
            params._response_column = resp;
            params._obj_reg = 1.0E-5;
            double lAmbda = 1.0E-4;
            dinfo = new DataInfo(fr, null, 1, params._use_all_factor_levels || params._lambda_search, params._standardize ? DataInfo.TransformType.STANDARDIZE : DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, true, false, false, false, false, false);
            DKV.put((Key)dinfo._key, (Iced)dinfo);
            GLMModel.GLMParameters paramsO = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.ordinal, GLMModel.GLMParameters.Family.ordinal.defaultLink, new double[]{0.0}, new double[]{0.0}, 0.0, 0.0);
            paramsO._train = fr._key;
            paramsO._lambda = new double[]{1.0E-4};
            paramsO._lambda_search = false;
            paramsO._response_column = resp;
            paramsO._alpha = new double[]{0.5};
            paramsO._obj_reg = params._obj_reg;
            odinfo = new DataInfo(fr, null, 1, paramsO._use_all_factor_levels || paramsO._lambda_search, paramsO._standardize ? DataInfo.TransformType.STANDARDIZE : DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, true, false, false, false, false, false);
            DKV.put((Key)odinfo._key, (Iced)odinfo);
            double[][] _betaMultinomial = new double[nclasses][];
            for (int i = 0; i < nclasses; ++i) {
                _betaMultinomial[i] = MemoryManager.malloc8d((int)(odinfo.fullN() + 1));
            }
            double[] beta = new double[_betaMultinomial[0].length];
            GLMTask.GLMGradientTask grBinomial = (GLMTask.GLMGradientTask)new GLMTask.GLMBinomialGradientTask(null, dinfo, params, lAmbda, beta).doAll(dinfo._adaptedFrame);
            GLMTask.GLMMultinomialGradientBaseTask grOrdinal = (GLMTask.GLMMultinomialGradientBaseTask)new GLMTask.GLMMultinomialGradientTask(null, odinfo, lAmbda, (double[][])_betaMultinomial, paramsO).doAll(odinfo._adaptedFrame);
            this.compareBinomalOrdinalGradients(grBinomial, grOrdinal);
        }
        finally {
            dinfo.remove();
            odinfo.remove();
        }
    }

    public void compareBinomalOrdinalGradients(GLMTask.GLMGradientTask bGr, GLMTask.GLMMultinomialGradientBaseTask oGr) {
        Assert.assertEquals((double)bGr._likelihood, (double)oGr._likelihood, (double)1.0E-10);
        double[] binomialG = bGr._gradient;
        double[] ordinalG = oGr.gradient();
        for (int index = 0; index < binomialG.length; ++index) {
            Assert.assertEquals((double)binomialG[index], (double)(-ordinalG[index]), (double)1.0E-10);
        }
    }
}

