/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import hex.CreateFrame;
import hex.DataInfo;
import hex.glm.GLM;
import hex.glm.GLMModel;
import hex.glm.GLMTask;
import java.util.Random;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import water.DKV;
import water.Iced;
import water.Key;
import water.Keyed;
import water.MemoryManager;
import water.Scope;
import water.TestUtil;
import water.fvec.Frame;
import water.fvec.Vec;

public class GLMBasicTestNegativebinomial
extends TestUtil {
    @BeforeClass
    public static void setup() {
        GLMBasicTestNegativebinomial.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMojoPojoPredict() {
        try {
            Scope.enter();
            Frame tfr = this.createData(5000L, 11, 0.4, 0.5, 0.0);
            Vec v = tfr.remove("response");
            tfr.add("response", v.toNumericVec());
            Scope.track((Vec)v);
            Scope.track((Frame[])new Frame[]{tfr});
            DKV.put((Keyed)tfr);
            GLMModel.GLMParameters params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.negativebinomial, GLMModel.GLMParameters.Family.negativebinomial.defaultLink, new double[]{0.0}, new double[]{0.0}, 0.0, 0.0);
            params._train = tfr._key;
            params._lambda = new double[]{0.0};
            params._use_all_factor_levels = true;
            params._standardize = false;
            params._theta = 0.5;
            params._response_column = "response";
            GLM glm = new GLM(params);
            GLMModel model = (GLMModel)glm.trainModel().get();
            Frame pred = model.score(tfr);
            Scope.track_generic((Keyed)pred);
            Scope.track_generic((Keyed)model);
            Assert.assertTrue((boolean)model.testJavaScoring(tfr, pred, 1.0E-6));
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGradientLikelihoodTask() {
        DataInfo dinfo = null;
        try {
            Scope.enter();
            Frame tfr = this.createData(500L, 8, 0.0, 0.5, 0.0);
            Vec v = tfr.remove("response");
            Scope.track((Frame[])new Frame[]{tfr});
            DKV.put((Keyed)tfr);
            Scope.track((Vec)v);
            tfr.add("response", v.toNumericVec());
            GLMModel.GLMParameters params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.negativebinomial, GLMModel.GLMParameters.Family.negativebinomial.defaultLink, new double[]{0.0}, new double[]{0.0}, 0.0, 0.0);
            params._train = tfr._key;
            params._lambda = new double[]{0.0};
            params._use_all_factor_levels = true;
            params._standardize = false;
            params._theta = 0.5;
            params._response_column = "response";
            params._obj_reg = 1.0;
            dinfo = new DataInfo(tfr, null, 1, params._use_all_factor_levels || params._lambda_search, params._standardize ? DataInfo.TransformType.STANDARDIZE : DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, true, false, false, false, false, false);
            DKV.put((Key)dinfo._key, (Iced)dinfo);
            Scope.track_generic((Keyed)dinfo);
            int betaSize = dinfo.fullN() + 1;
            double[] beta = MemoryManager.malloc8d((int)betaSize);
            Random rnd = new Random(987654321L);
            for (int i = 0; i < beta.length; ++i) {
                beta[i] = 1.0 - 2.0 * rnd.nextDouble();
            }
            GLMTask.GLMGradientTask grtGen = (GLMTask.GLMGradientTask)new GLMTask.GLMNegativeBinomialGradientTask(null, dinfo, params, params._lambda[0], beta).doAll(dinfo._adaptedFrame);
            GLMTask.GLMIterationTask heg = (GLMTask.GLMIterationTask)new GLMTask.GLMIterationTask(null, dinfo, new GLMModel.GLMWeightsFun(params), beta).doAll(dinfo._adaptedFrame);
            double[][] hessian = new double[betaSize][];
            for (int i = 0; i < betaSize; ++i) {
                hessian[i] = new double[betaSize];
            }
            double[] gradient = new double[betaSize];
            double manualLLH = this.manualGradientNHess(tfr, beta, hessian, gradient, params._theta);
            Assert.assertTrue((String)"Likelihood from GLMIterationTask and GLMGradientTask should equal but not...", (Math.abs(grtGen._likelihood - heg._likelihood) < 1.0E-10 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Likelihood from GLMIterationTask and Manual calculation should equal but not...", (Math.abs(grtGen._likelihood - manualLLH) < 1.0E-10 ? 1 : 0) != 0);
            this.compareArrays(grtGen._gradient, gradient, 1.0E-10, true);
            double[][] hess = heg.getGram().getXX();
            for (int index = 0; index < betaSize; ++index) {
                this.compareArrays(hess[index], hessian[index], 1.0E-10, false);
            }
        }
        finally {
            Scope.exit((Key[])new Key[0]);
            DKV.remove((Key)dinfo._key);
            if (dinfo != null) {
                dinfo.remove();
            }
        }
    }

    void compareArrays(double[] arr1, double[] arr2, double eps, boolean careAboutLengths) {
        int arrLength = arr1.length;
        if (careAboutLengths) {
            Assert.assertTrue((String)"Array lengths should be equal but not.", (arrLength == arr2.length ? 1 : 0) != 0);
        }
        for (int index = 0; index < arrLength; ++index) {
            Assert.assertTrue((String)"Array elements should be equal within tolerance but not...", (Math.abs(arr1[index] - arr2[index]) < eps ? 1 : 0) != 0);
        }
    }

    double manualGradientNHess(Frame fr, double[] beta, double[][] hessian, double[] gradient, double theta) {
        int nrow = (int)fr.numRows();
        int numBeta = beta.length;
        int interceptInd = numBeta - 1;
        double likelihood = 0.0;
        Vec respVec = fr.vec(interceptInd);
        for (int rowInd = 0; rowInd < nrow; ++rowInd) {
            double he;
            double es;
            double temp = 0.0;
            for (int colInd = 0; colInd < interceptInd; ++colInd) {
                temp += fr.vec(colInd).at((long)rowInd) * beta[colInd];
            }
            double eta = Math.exp(temp += beta[interceptInd]);
            if (respVec.at((long)rowInd) == 0.0) {
                es = eta / (1.0 + theta * eta);
                he = eta / Math.pow(1.0 + theta * eta, 2.0);
                likelihood += Math.log(1.0 + theta * eta) / theta;
            } else {
                es = (eta - respVec.at((long)rowInd)) / (1.0 + theta * eta);
                he = eta * (1.0 + theta * respVec.at((long)rowInd)) / Math.pow(1.0 + theta * eta, 2.0);
                likelihood -= this.logGammas(respVec.at((long)rowInd), 1.0 / theta) - (respVec.at((long)rowInd) + 1.0 / theta) * Math.log(1.0 + theta * eta) + respVec.at((long)rowInd) * Math.log(eta) + respVec.at((long)rowInd) * Math.log(theta);
            }
            for (int colInd = 0; colInd < interceptInd; ++colInd) {
                int n = colInd;
                gradient[n] = gradient[n] + fr.vec(colInd).at((long)rowInd) * es;
                for (int colInd2 = 0; colInd2 < interceptInd; ++colInd2) {
                    double[] dArray = hessian[colInd];
                    int n2 = colInd2;
                    dArray[n2] = dArray[n2] + fr.vec(colInd).at((long)rowInd) * fr.vec(colInd2).at((long)rowInd) * he;
                }
                double[] dArray = hessian[interceptInd];
                int n3 = colInd;
                dArray[n3] = dArray[n3] + he * fr.vec(colInd).at((long)rowInd);
                hessian[colInd][interceptInd] = hessian[interceptInd][colInd];
            }
            int n = interceptInd;
            gradient[n] = gradient[n] + es;
            double[] dArray = hessian[interceptInd];
            int n4 = interceptInd;
            dArray[n4] = dArray[n4] + he;
        }
        return likelihood;
    }

    double logGammas(double resp, double invTheta) {
        double result = 0.0;
        int rep = (int)resp;
        for (int j = 0; j < rep; ++j) {
            result += Math.log(((double)j + invTheta) / (double)(j + 1));
        }
        return result;
    }

    public Frame createData(long nrow, int ncol, double catFrac, double intFrac, double missFrac) {
        CreateFrame cf = new CreateFrame();
        cf.rows = nrow;
        cf.cols = ncol;
        cf.categorical_fraction = catFrac;
        cf.integer_fraction = intFrac;
        cf.string_fraction = 0.0;
        cf.time_fraction = 0.0;
        cf.real_range = 10L;
        cf.integer_range = 10L;
        cf.seed = 1234L;
        cf.has_response = true;
        cf.response_factors = 20;
        cf.missing_fraction = missFrac;
        return (Frame)cf.execImpl().get();
    }
}

