/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import hex.CreateFrame;
import hex.DataInfo;
import hex.FrameSplitter;
import hex.Model;
import hex.ModelMetricsBinomialGLM;
import hex.ModelMetricsMultinomial;
import hex.SplitFrame;
import hex.glm.GLM;
import hex.glm.GLMModel;
import hex.optimization.ADMM;
import java.util.Random;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import water.DKV;
import water.H2O;
import water.Key;
import water.Keyed;
import water.Scope;
import water.TestUtil;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Frame;
import water.fvec.Vec;

public class GLMBasicTestMultinomial
extends TestUtil {
    static Frame _covtype;
    static Frame _train;
    static Frame _test;
    double _tol = 1.0E-10;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @BeforeClass
    public static void setup() {
        GLMBasicTestMultinomial.stall_till_cloudsize((int)1);
        _covtype = GLMBasicTestMultinomial.parse_test_file((String)"smalldata/covtype/covtype.20k.data");
        _covtype.replace(_covtype.numCols() - 1, _covtype.lastVec().toCategoricalVec()).remove();
        Key[] keys = new Key[]{Key.make((String)"train"), Key.make((String)"test")};
        ((FrameSplitter)H2O.submitTask((H2O.H2OCountedCompleter)new FrameSplitter(_covtype, new double[]{0.8}, keys, null))).join();
        _train = (Frame)DKV.getGet((Key)keys[0]);
        _test = (Frame)DKV.getGet((Key)keys[1]);
    }

    @AfterClass
    public static void cleanUp() {
        if (_covtype != null) {
            _covtype.delete();
        }
        if (_train != null) {
            _train.delete();
        }
        if (_test != null) {
            _test.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultinomialPredMojoPojo() {
        try {
            Scope.enter();
            CreateFrame cf = new CreateFrame();
            Random generator = new Random();
            int numRows = generator.nextInt(10000) + 15000 + 200;
            int numCols = generator.nextInt(17) + 3;
            int response_factors = generator.nextInt(7) + 3;
            cf.rows = numRows;
            cf.cols = numCols;
            cf.factors = 10;
            cf.has_response = true;
            cf.response_factors = response_factors;
            cf.positive_response = true;
            cf.missing_fraction = 0.0;
            cf.seed = System.currentTimeMillis();
            System.out.println("Createframe parameters: rows: " + numRows + " cols:" + numCols + " response number:" + response_factors + " seed: " + cf.seed);
            Frame trainMultinomial = Scope.track((Frame[])new Frame[]{(Frame)cf.execImpl().get()});
            SplitFrame sf = new SplitFrame(trainMultinomial, new double[]{0.8, 0.2}, new Key[]{Key.make((String)"train.hex"), Key.make((String)"test.hex")});
            sf.exec().get();
            Key[] ksplits = sf._destination_frames;
            Frame tr = (Frame)DKV.get((Key)ksplits[0]).get();
            Frame te = (Frame)DKV.get((Key)ksplits[1]).get();
            Scope.track((Frame[])new Frame[]{tr});
            Scope.track((Frame[])new Frame[]{te});
            GLMModel.GLMParameters paramsO = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.multinomial, GLMModel.GLMParameters.Family.multinomial.defaultLink, new double[]{0.0}, new double[]{0.0}, 0.0, 0.0);
            paramsO._train = tr._key;
            paramsO._lambda_search = false;
            paramsO._response_column = "response";
            paramsO._lambda = new double[]{0.0};
            paramsO._alpha = new double[]{0.001};
            paramsO._objective_epsilon = 1.0E-6;
            paramsO._beta_epsilon = 1.0E-4;
            paramsO._standardize = false;
            GLMModel model = (GLMModel)new GLM(paramsO).trainModel().get();
            Scope.track_generic((Keyed)model);
            Frame pred = model.score(te);
            Scope.track((Frame[])new Frame[]{pred});
            Assert.assertTrue((boolean)model.testJavaScoring(te, pred, this._tol));
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCovtypeNoIntercept() {
        GLMModel.GLMParameters params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.multinomial);
        GLMModel model = null;
        Frame preds = null;
        Vec weights = _covtype.anyVec().makeCon(1.0);
        Key k = Key.make((String)"cov_with_weights");
        Frame f = new Frame(k, _covtype.names(), _covtype.vecs());
        f.add("weights", weights);
        DKV.put((Keyed)f);
        try {
            params._response_column = "C55";
            params._train = k;
            params._valid = GLMBasicTestMultinomial._covtype._key;
            params._objective_epsilon = 1.0E-6;
            params._beta_epsilon = 1.0E-4;
            params._weights_column = "weights";
            params._missing_values_handling = GLMModel.GLMParameters.MissingValuesHandling.Skip;
            params._intercept = false;
            double[] alpha = new double[]{0.0, 0.5, 0.1};
            GLMModel.GLMParameters.Solver s = GLMModel.GLMParameters.Solver.L_BFGS;
            System.out.println("solver = " + s);
            params._solver = s;
            params._max_iterations = 5000;
            for (int i = 0; i < alpha.length; ++i) {
                double[][] bs;
                params._alpha = new double[]{alpha[i]};
                model = (GLMModel)new GLM(params).trainModel().get();
                System.out.println(model.coefficients());
                for (double[] b : bs = ((GLMModel.GLMOutput)model._output).getNormBetaMultinomial()) {
                    Assert.assertEquals((double)0.0, (double)b[b.length - 1], (double)0.0);
                }
                System.out.println(((GLMModel.GLMOutput)model._output)._model_summary);
                System.out.println(((GLMModel.GLMOutput)model._output)._training_metrics);
                System.out.println(((GLMModel.GLMOutput)model._output)._validation_metrics);
                preds = model.score(_covtype);
                ModelMetricsBinomialGLM.ModelMetricsMultinomialGLM mmTrain = (ModelMetricsBinomialGLM.ModelMetricsMultinomialGLM)ModelMetricsMultinomial.getFromDKV((Model)model, (Frame)_covtype);
                Assert.assertTrue((boolean)((GLMModel.GLMOutput)model._output)._training_metrics.equals(mmTrain));
                model.delete();
                model = null;
                preds.delete();
                preds = null;
            }
        }
        finally {
            weights.remove();
            DKV.remove((Key)k);
            if (model != null) {
                model.delete();
            }
            if (preds != null) {
                preds.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCovtypeBasic() {
        GLMModel.GLMParameters params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.multinomial);
        GLMModel model = null;
        Frame preds = null;
        Vec weights = _covtype.anyVec().makeCon(1.0);
        Key k = Key.make((String)"cov_with_weights");
        Frame f = new Frame(k, _covtype.names(), _covtype.vecs());
        f.add("weights", weights);
        DKV.put((Keyed)f);
        try {
            params._response_column = "C55";
            params._train = k;
            params._valid = GLMBasicTestMultinomial._covtype._key;
            params._lambda = new double[]{4.881E-5};
            params._alpha = new double[]{1.0};
            params._objective_epsilon = 1.0E-6;
            params._beta_epsilon = 1.0E-4;
            params._weights_column = "weights";
            params._missing_values_handling = GLMModel.GLMParameters.MissingValuesHandling.Skip;
            double[] alpha = new double[]{1.0};
            double[] expected_deviance = new double[]{25499.76};
            double[] lambda = new double[]{2.54475E-5};
            for (GLMModel.GLMParameters.Solver s : new GLMModel.GLMParameters.Solver[]{GLMModel.GLMParameters.Solver.IRLSM, GLMModel.GLMParameters.Solver.COORDINATE_DESCENT, GLMModel.GLMParameters.Solver.L_BFGS}) {
                System.out.println("solver = " + s);
                params._solver = s;
                params._max_iterations = params._solver == GLMModel.GLMParameters.Solver.L_BFGS ? 300 : 10;
                for (int i = 0; i < alpha.length; ++i) {
                    params._alpha[0] = alpha[i];
                    params._lambda[0] = lambda[i];
                    model = (GLMModel)new GLM(params).trainModel().get();
                    System.out.println(((GLMModel.GLMOutput)model._output)._model_summary);
                    System.out.println(((GLMModel.GLMOutput)model._output)._training_metrics);
                    System.out.println(((GLMModel.GLMOutput)model._output)._validation_metrics);
                    Assert.assertTrue((boolean)((GLMModel.GLMOutput)model._output)._training_metrics.equals(((GLMModel.GLMOutput)model._output)._validation_metrics));
                    Assert.assertTrue((((ModelMetricsBinomialGLM.ModelMetricsMultinomialGLM)((GLMModel.GLMOutput)model._output)._training_metrics)._resDev <= expected_deviance[i] * 1.1 ? 1 : 0) != 0);
                    preds = model.score(_covtype);
                    ModelMetricsBinomialGLM.ModelMetricsMultinomialGLM mmTrain = (ModelMetricsBinomialGLM.ModelMetricsMultinomialGLM)ModelMetricsMultinomial.getFromDKV((Model)model, (Frame)_covtype);
                    Assert.assertTrue((boolean)((GLMModel.GLMOutput)model._output)._training_metrics.equals(mmTrain));
                    model.delete();
                    model = null;
                    preds.delete();
                    preds = null;
                }
            }
        }
        finally {
            weights.remove();
            DKV.remove((Key)k);
            if (model != null) {
                model.delete();
            }
            if (preds != null) {
                preds.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCODGradients() {
        Scope.enter();
        GLMModel.GLMParameters params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.multinomial);
        GLMModel model = null;
        double[] oldGLMCoeffs = new double[]{0.059094274726151426, 0.013361781886804975, -0.00798977427248744, 0.007467359562151555, 0.06737827548293934, -1.002393430927568, -0.04066511294457045, -0.018960901996125427, 0.07330281133353159, -0.02285669809606731, 0.002805290931441751, -1.1394632268347782, 0.021976767313534512, 0.01013967640490087, -0.03999288928633559, 0.012385348397898913, -0.0017922461738315199, -1.159667420372168};
        try {
            Frame train = GLMBasicTestMultinomial.parse_test_file((String)"smalldata/glm_test/multinomial_3_class.csv");
            Scope.track((Frame[])new Frame[]{train});
            params._response_column = "response";
            params._train = train._key;
            params._lambda = new double[]{4.881E-5};
            params._alpha = new double[]{0.5};
            params._objective_epsilon = 1.0E-6;
            params._beta_epsilon = 1.0E-4;
            params._max_iterations = 1;
            params._seed = 12345L;
            GLMModel.GLMParameters.Solver s = GLMModel.GLMParameters.Solver.COORDINATE_DESCENT;
            System.out.println("solver = " + s);
            params._solver = s;
            model = (GLMModel)new GLM(params).trainModel().get();
            Scope.track_generic((Keyed)model);
            DataInfo tinfo = new DataInfo((Frame)train.clone(), null, 0, true, DataInfo.TransformType.STANDARDIZE, DataInfo.TransformType.NONE, false, false, false, false, false, false);
            double[] manualCoeff = this.getCODCoeff(train, params._alpha[0], params._lambda[0], model._ymu, tinfo);
            Scope.track_generic((Keyed)tinfo);
            this.compareGLMCoeffs(manualCoeff, ((GLMModel.GLMOutput)model._output)._submodels[0].beta, 0.02);
            this.compareGLMCoeffs(((GLMModel.GLMOutput)model._output)._submodels[0].beta, oldGLMCoeffs, 1.0E-10);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    public void compareGLMCoeffs(double[] coeff1, double[] coeff2, double tol) {
        Assert.assertTrue((coeff1.length == coeff2.length ? 1 : 0) != 0);
        for (int index = 0; index < coeff1.length; ++index) {
            assert (Math.abs(coeff1[index] - coeff2[index]) < tol) : "coefficient difference " + Math.abs(coeff1[index] - coeff2[index]) + " exceeded tolerance of " + tol;
        }
    }

    public double[] getCODCoeff(Frame train, double alpha, double lambda, double[] ymu, DataInfo tinfo) {
        int numClass = train.vec("response").domain().length;
        int numPred = train.numCols() - 1;
        int numRow = (int)train.numRows();
        double[] beta = new double[numClass * (numPred + 1)];
        double reg = 1.0 / (double)train.numRows();
        for (int index = 0; index < numClass; ++index) {
            beta[(index + 1) * (numPred + 1) - 1] = Math.log(ymu[index]);
        }
        for (int iter = 0; iter < 3; ++iter) {
            for (int cindex = 0; cindex < numClass; ++cindex) {
                for (int pindex = 0; pindex < numPred; ++pindex) {
                    double grad = 0.0;
                    double hess = 0.0;
                    for (int rindex = 0; rindex < numRow; ++rindex) {
                        int resp = (int)train.vec("response").at((long)rindex);
                        double predProb = this.calProb(train, rindex, beta, numClass, numPred, cindex, tinfo);
                        double entry = (train.vec(pindex).at((long)rindex) - tinfo._numMeans[pindex]) * tinfo._normMul[pindex];
                        grad -= entry * ((double)(resp == cindex ? 1 : 0) - predProb);
                        hess += entry * entry * (predProb - predProb * predProb);
                    }
                    grad = grad * reg + lambda * (1.0 - alpha) * beta[cindex * (numPred + 1) + pindex];
                    hess = hess * reg + lambda * (1.0 - alpha);
                    int n = cindex * (numPred + 1) + pindex;
                    beta[n] = beta[n] - ADMM.shrinkage((double)grad, (double)(lambda * alpha)) / hess;
                }
                double grad = 0.0;
                double hess = 0.0;
                for (int rindex = 0; rindex < numRow; ++rindex) {
                    int resp = (int)train.vec("response").at((long)rindex);
                    double predProb = this.calProb(train, rindex, beta, numClass, numPred, cindex, tinfo);
                    grad -= (double)(resp == cindex ? 1 : 0) - predProb;
                    hess += predProb - predProb * predProb;
                }
                int n = (cindex + 1) * (numPred + 1) - 1;
                beta[n] = beta[n] - (grad *= reg) / (hess *= reg);
            }
        }
        return beta;
    }

    public double calProb(Frame train, int rowIndex, double[] beta, int numClass, int numPred, int classNo, DataInfo tinfo) {
        double prob = 0.0;
        double sum = 0.0;
        for (int cindex = 0; cindex < numClass; ++cindex) {
            double temp = 0.0;
            for (int pindex = 0; pindex < numPred; ++pindex) {
                double entry = (train.vec(pindex).at((long)rowIndex) - tinfo._numMeans[pindex]) * tinfo._normMul[pindex];
                temp += entry * beta[cindex * (numPred + 1) + pindex];
            }
            temp += beta[(cindex + 1) * (numPred + 1) - 1];
            if (classNo == cindex) {
                prob = Math.exp(temp);
            }
            sum += Math.exp(temp);
        }
        return prob / sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCovtypeMinActivePredictors() {
        GLMModel.GLMParameters params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.multinomial);
        GLMModel model = null;
        Frame preds = null;
        try {
            params._response_column = "C55";
            params._train = GLMBasicTestMultinomial._covtype._key;
            params._valid = GLMBasicTestMultinomial._covtype._key;
            params._lambda = new double[]{4.881E-5};
            params._alpha = new double[]{1.0};
            params._objective_epsilon = 1.0E-6;
            params._beta_epsilon = 1.0E-4;
            params._max_active_predictors = 50;
            params._max_iterations = 10;
            double[] alpha = new double[]{0.99};
            double expected_deviance = 33000.0;
            double[] lambda = new double[]{2.54475E-5};
            GLMModel.GLMParameters.Solver s = GLMModel.GLMParameters.Solver.COORDINATE_DESCENT;
            System.out.println("solver = " + s);
            params._solver = s;
            model = (GLMModel)new GLM(params).trainModel().get();
            System.out.println(((GLMModel.GLMOutput)model._output)._model_summary);
            System.out.println(((GLMModel.GLMOutput)model._output)._training_metrics);
            System.out.println(((GLMModel.GLMOutput)model._output)._validation_metrics);
            System.out.println("rank = " + ((GLMModel.GLMOutput)model._output).rank() + ", max active preds = " + (params._max_active_predictors + ((GLMModel.GLMOutput)model._output).nclasses()));
            Assert.assertTrue((((GLMModel.GLMOutput)model._output).rank() <= params._max_active_predictors + ((GLMModel.GLMOutput)model._output).nclasses() ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((GLMModel.GLMOutput)model._output)._training_metrics.equals(((GLMModel.GLMOutput)model._output)._validation_metrics));
            Assert.assertTrue((((ModelMetricsBinomialGLM.ModelMetricsMultinomialGLM)((GLMModel.GLMOutput)model._output)._training_metrics)._resDev <= expected_deviance * 1.1 ? 1 : 0) != 0);
            preds = model.score(_covtype);
            ModelMetricsBinomialGLM.ModelMetricsMultinomialGLM mmTrain = (ModelMetricsBinomialGLM.ModelMetricsMultinomialGLM)ModelMetricsMultinomial.getFromDKV((Model)model, (Frame)_covtype);
            Assert.assertTrue((boolean)((GLMModel.GLMOutput)model._output)._training_metrics.equals(mmTrain));
            model.delete();
            model = null;
            preds.delete();
            preds = null;
        }
        finally {
            if (model != null) {
                model.delete();
            }
            if (preds != null) {
                preds.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCovtypeLS() {
        GLMModel.GLMParameters params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.multinomial);
        GLMModel model = null;
        Frame preds = null;
        try {
            double expected_deviance = 33000.0;
            params._nlambdas = 3;
            params._response_column = "C55";
            params._train = GLMBasicTestMultinomial._covtype._key;
            params._valid = GLMBasicTestMultinomial._covtype._key;
            params._alpha = new double[]{0.99};
            params._objective_epsilon = 1.0E-6;
            params._beta_epsilon = 1.0E-4;
            params._max_active_predictors = 50;
            params._max_iterations = 500;
            params._solver = GLMModel.GLMParameters.Solver.AUTO;
            params._lambda_search = true;
            model = (GLMModel)new GLM(params).trainModel().get();
            System.out.println(((GLMModel.GLMOutput)model._output)._training_metrics);
            System.out.println(((GLMModel.GLMOutput)model._output)._validation_metrics);
            Assert.assertTrue((boolean)((GLMModel.GLMOutput)model._output)._training_metrics.equals(((GLMModel.GLMOutput)model._output)._validation_metrics));
            preds = model.score(_covtype);
            ModelMetricsBinomialGLM.ModelMetricsMultinomialGLM mmTrain = (ModelMetricsBinomialGLM.ModelMetricsMultinomialGLM)ModelMetricsMultinomial.getFromDKV((Model)model, (Frame)_covtype);
            Assert.assertTrue((boolean)((GLMModel.GLMOutput)model._output)._training_metrics.equals(mmTrain));
            Assert.assertTrue((((ModelMetricsBinomialGLM.ModelMetricsMultinomialGLM)((GLMModel.GLMOutput)model._output)._training_metrics)._resDev <= expected_deviance ? 1 : 0) != 0);
            System.out.println(((GLMModel.GLMOutput)model._output)._model_summary);
            model.delete();
            model = null;
            preds.delete();
            preds = null;
        }
        finally {
            if (model != null) {
                model.delete();
            }
            if (preds != null) {
                preds.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCovtypeNAs() {
        GLMModel.GLMParameters params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.multinomial);
        GLMModel model = null;
        Frame preds = null;
        Frame covtype_subset = null;
        Frame covtype_copy = null;
        try {
            double expected_deviance = 26000.0;
            covtype_copy = _covtype.deepCopy("covtype_copy");
            DKV.put((Keyed)covtype_copy);
            Vec.Writer w = covtype_copy.vec(54).open();
            w.setNA(10L);
            w.setNA(20L);
            w.setNA(30L);
            w.close();
            covtype_subset = new Frame(Key.make((String)"covtype_subset"), new String[]{"C51", "C52", "C53", "C54", "C55"}, covtype_copy.vecs(new int[]{50, 51, 52, 53, 54}));
            DKV.put((Keyed)covtype_subset);
            params._response_column = "C55";
            params._train = covtype_copy._key;
            params._valid = covtype_copy._key;
            params._alpha = new double[]{0.99};
            params._objective_epsilon = 1.0E-6;
            params._beta_epsilon = 1.0E-4;
            params._max_active_predictors = 50;
            params._max_iterations = 500;
            params._solver = GLMModel.GLMParameters.Solver.L_BFGS;
            params._missing_values_handling = GLMModel.GLMParameters.MissingValuesHandling.Skip;
            model = (GLMModel)new GLM(params).trainModel().get();
            Assert.assertEquals((long)(covtype_copy.numRows() - 3L - 1L), (long)model._nullDOF);
            System.out.println(((GLMModel.GLMOutput)model._output)._training_metrics);
            System.out.println(((GLMModel.GLMOutput)model._output)._validation_metrics);
            Assert.assertTrue((boolean)((GLMModel.GLMOutput)model._output)._training_metrics.equals(((GLMModel.GLMOutput)model._output)._validation_metrics));
            preds = model.score(covtype_copy);
            ModelMetricsBinomialGLM.ModelMetricsMultinomialGLM mmTrain = (ModelMetricsBinomialGLM.ModelMetricsMultinomialGLM)ModelMetricsMultinomial.getFromDKV((Model)model, (Frame)covtype_copy);
            Assert.assertTrue((boolean)((GLMModel.GLMOutput)model._output)._training_metrics.equals(mmTrain));
            Assert.assertTrue((((ModelMetricsBinomialGLM.ModelMetricsMultinomialGLM)((GLMModel.GLMOutput)model._output)._training_metrics)._resDev <= expected_deviance ? 1 : 0) != 0);
            System.out.println(((GLMModel.GLMOutput)model._output)._model_summary);
            model.delete();
            model = null;
            preds.delete();
            preds = null;
            params._train = covtype_subset._key;
            model = (GLMModel)new GLM(params).trainModel().get();
            Assert.assertEquals((long)(covtype_copy.numRows() - 3L - 1L), (long)model._nullDOF);
            System.out.println(((GLMModel.GLMOutput)model._output)._training_metrics);
            System.out.println(((GLMModel.GLMOutput)model._output)._validation_metrics);
            Assert.assertTrue((boolean)((GLMModel.GLMOutput)model._output)._training_metrics.equals(((GLMModel.GLMOutput)model._output)._validation_metrics));
            preds = model.score(_covtype);
            System.out.println(((GLMModel.GLMOutput)model._output)._model_summary);
            Assert.assertTrue((((ModelMetricsBinomialGLM.ModelMetricsMultinomialGLM)((GLMModel.GLMOutput)model._output)._training_metrics)._resDev <= 66000.0 ? 1 : 0) != 0);
            model.delete();
            model = null;
            preds.delete();
            preds = null;
        }
        finally {
            if (covtype_subset != null) {
                covtype_subset.delete();
            }
            if (covtype_copy != null) {
                covtype_copy.delete();
            }
            if (model != null) {
                model.delete();
            }
            if (preds != null) {
                preds.delete();
            }
        }
    }

    @Test
    public void testNaiveCoordinateDescent() {
        this.expectedException.expect(H2OIllegalArgumentException.class);
        this.expectedException.expectMessage("Naive coordinate descent is not supported for multinomial.");
        GLMModel.GLMParameters params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.multinomial);
        params._solver = GLMModel.GLMParameters.Solver.COORDINATE_DESCENT_NAIVE;
        new GLM(params);
    }

    @Test
    public void testNaiveCoordinateDescent_families() {
        GLMModel.GLMParameters params = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.binomial);
        params._solver = GLMModel.GLMParameters.Solver.COORDINATE_DESCENT_NAIVE;
        GLMModel.GLMParameters.Family[] families = new GLMModel.GLMParameters.Family[]{GLMModel.GLMParameters.Family.binomial, GLMModel.GLMParameters.Family.gaussian, GLMModel.GLMParameters.Family.gamma, GLMModel.GLMParameters.Family.tweedie, GLMModel.GLMParameters.Family.poisson, GLMModel.GLMParameters.Family.ordinal, GLMModel.GLMParameters.Family.quasibinomial};
        GLMModel.GLMParameters.Link[] linkingfuncs = new GLMModel.GLMParameters.Link[]{GLMModel.GLMParameters.Link.logit, GLMModel.GLMParameters.Link.identity, GLMModel.GLMParameters.Link.log, GLMModel.GLMParameters.Link.tweedie, GLMModel.GLMParameters.Link.log, GLMModel.GLMParameters.Link.ologit, GLMModel.GLMParameters.Link.logit};
        for (int i = 0; i < families.length; ++i) {
            params._family = families[i];
            params._link = linkingfuncs[i];
            new GLM(params);
        }
    }
}

