/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import hex.ModelMetricsHGLMGaussianGaussian;
import hex.glm.GLM;
import hex.glm.GLMModel;
import java.io.IOException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import water.DKV;
import water.Key;
import water.Keyed;
import water.Scope;
import water.TestUtil;
import water.fvec.Frame;

public class GLMBasicTestHGLM
extends TestUtil {
    @BeforeClass
    public static void setup() throws IOException {
        GLMBasicTestHGLM.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSemiconductor() {
        try {
            Scope.enter();
            Frame fr = GLMBasicTestHGLM.parse_test_file((String)"smalldata/glm_test/semiconductor.csv");
            fr.replace(0, fr.vec(0).toCategoricalVec()).remove();
            DKV.put((Keyed)fr);
            Scope.track((Frame[])new Frame[]{fr});
            GLMModel.GLMParameters parms = new GLMModel.GLMParameters();
            parms._train = fr._key;
            parms._response_column = "y";
            parms._ignored_columns = new String[]{"x2", "x4", "Device"};
            parms._ignore_const_cols = true;
            parms._family = GLMModel.GLMParameters.Family.gaussian;
            parms._link = GLMModel.GLMParameters.Link.identity;
            parms._HGLM = true;
            parms._rand_family = new GLMModel.GLMParameters.Family[]{GLMModel.GLMParameters.Family.gaussian};
            parms._rand_link = new GLMModel.GLMParameters.Link[]{GLMModel.GLMParameters.Link.identity};
            parms._random_columns = new int[]{0};
            parms._calc_like = true;
            GLMModel model = (GLMModel)new GLM(parms).trainModel().get();
            Scope.track_generic((Keyed)model);
            ModelMetricsHGLMGaussianGaussian mmetrics = (ModelMetricsHGLMGaussianGaussian)((GLMModel.GLMOutput)model._output)._training_metrics;
            Scope.track_generic((Keyed)mmetrics);
            Assert.assertEquals((double)363.6833, (double)mmetrics._hlik, (double)1.0E-4);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiChunkData() {
        try {
            Scope.enter();
            Frame fr = GLMBasicTestHGLM.parse_test_file((String)"smalldata/glm_test/HGLM_5KRows_100Z.csv");
            fr.replace(0, fr.vec(0).toCategoricalVec()).remove();
            fr.replace(1, fr.vec(1).toCategoricalVec()).remove();
            fr.replace(2, fr.vec(2).toCategoricalVec()).remove();
            fr.replace(3, fr.vec(3).toCategoricalVec()).remove();
            DKV.put((Keyed)fr);
            Scope.track((Frame[])new Frame[]{fr});
            GLMModel.GLMParameters parms = new GLMModel.GLMParameters();
            parms._train = fr._key;
            parms._response_column = "response";
            parms._ignored_columns = new String[]{"Z"};
            parms._ignore_const_cols = true;
            parms._family = GLMModel.GLMParameters.Family.gaussian;
            parms._link = GLMModel.GLMParameters.Link.identity;
            parms._HGLM = true;
            parms._rand_family = new GLMModel.GLMParameters.Family[]{GLMModel.GLMParameters.Family.gaussian};
            parms._rand_link = new GLMModel.GLMParameters.Link[]{GLMModel.GLMParameters.Link.identity};
            parms._random_columns = new int[]{0};
            parms._calc_like = true;
            GLMModel model = (GLMModel)new GLM(parms).trainModel().get();
            Scope.track_generic((Keyed)model);
            ModelMetricsHGLMGaussianGaussian mmetrics = (ModelMetricsHGLMGaussianGaussian)((GLMModel.GLMOutput)model._output)._training_metrics;
            Scope.track_generic((Keyed)mmetrics);
            Assert.assertEquals((double)-23643.3076231, (double)mmetrics._hlik, (double)1.0E-4);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }
}

