/*
 * Decompiled with CFR 0.152.
 */
package hex.generic;

import hex.ModelCategory;
import hex.ModelMetricsBinomial;
import hex.generic.Generic;
import hex.generic.GenericModel;
import hex.generic.GenericModelOutput;
import hex.generic.GenericModelParameters;
import hex.genmodel.utils.DistributionFamily;
import hex.glm.GLM;
import hex.glm.GLMModel;
import hex.tree.drf.DRF;
import hex.tree.drf.DRFModel;
import hex.tree.gbm.GBM;
import hex.tree.gbm.GBMModel;
import hex.tree.isofor.IsolationForest;
import hex.tree.isofor.IsolationForestModel;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import water.DKV;
import water.H2O;
import water.Key;
import water.TestUtil;
import water.fvec.Frame;

public class GenericModelTest
extends TestUtil {
    @Before
    public void setUp() {
        TestUtil.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJavaScoring_gbm_binomial() throws Exception {
        Key<Frame> mojo = null;
        GBMModel model = null;
        GenericModel genericModel = null;
        Frame trainingFrame = null;
        Frame testFrame = null;
        Frame predictions = null;
        try {
            trainingFrame = GenericModelTest.parse_test_file((String)"./smalldata/testng/airlines_train.csv");
            testFrame = GenericModelTest.parse_test_file((String)"./smalldata/testng/airlines_test.csv");
            GBMModel.GBMParameters parms = new GBMModel.GBMParameters();
            parms._train = trainingFrame._key;
            parms._distribution = DistributionFamily.AUTO;
            parms._response_column = "IsDepDelayed";
            parms._ntrees = 1;
            GBM job = new GBM(parms);
            model = (GBMModel)job.trainModel().get();
            Assert.assertEquals((Object)((GBMModel.GBMOutput)model._output).getModelCategory(), (Object)ModelCategory.Binomial);
            ByteArrayOutputStream originalModelMojo = new ByteArrayOutputStream();
            File originalModelMojoFile = File.createTempFile("mojo", "zip");
            model.getMojo().writeTo((OutputStream)originalModelMojo);
            model.getMojo().writeTo((OutputStream)new FileOutputStream(originalModelMojoFile));
            mojo = this.importMojo(originalModelMojoFile.getAbsolutePath());
            GenericModelParameters genericModelParameters = new GenericModelParameters();
            genericModelParameters._model_key = mojo;
            Generic generic = new Generic(genericModelParameters);
            genericModel = (GenericModel)generic.trainModel().get();
            Assert.assertNotNull((Object)((GenericModelOutput)genericModel._output)._training_metrics);
            Assert.assertTrue((boolean)(((GenericModelOutput)genericModel._output)._training_metrics instanceof ModelMetricsBinomial));
            predictions = genericModel.score(testFrame);
            boolean equallyScored = genericModel.testJavaScoring(testFrame, predictions, 0.0);
            Assert.assertTrue((boolean)equallyScored);
        }
        finally {
            if (model != null) {
                model.remove();
            }
            if (mojo != null) {
                mojo.remove();
            }
            if (genericModel != null) {
                genericModel.remove();
            }
            if (trainingFrame != null) {
                trainingFrame.remove();
            }
            if (testFrame != null) {
                testFrame.remove();
            }
            if (predictions != null) {
                predictions.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJavaScoring_drf_binomial() throws Exception {
        Key<Frame> mojo = null;
        DRFModel model = null;
        GenericModel genericModel = null;
        Frame trainingFrame = null;
        Frame testFrame = null;
        Frame predictions = null;
        try {
            trainingFrame = GenericModelTest.parse_test_file((String)"./smalldata/testng/airlines_train.csv");
            testFrame = GenericModelTest.parse_test_file((String)"./smalldata/testng/airlines_test.csv");
            DRFModel.DRFParameters parms = new DRFModel.DRFParameters();
            parms._train = trainingFrame._key;
            parms._distribution = DistributionFamily.AUTO;
            parms._response_column = "IsDepDelayed";
            parms._ntrees = 1;
            DRF job = new DRF(parms);
            model = (DRFModel)job.trainModel().get();
            Assert.assertEquals((Object)((DRFModel.DRFOutput)model._output).getModelCategory(), (Object)ModelCategory.Binomial);
            ByteArrayOutputStream originalModelMojo = new ByteArrayOutputStream();
            File originalModelMojoFile = File.createTempFile("mojo", "zip");
            model.getMojo().writeTo((OutputStream)originalModelMojo);
            model.getMojo().writeTo((OutputStream)new FileOutputStream(originalModelMojoFile));
            mojo = this.importMojo(originalModelMojoFile.getAbsolutePath());
            GenericModelParameters genericModelParameters = new GenericModelParameters();
            genericModelParameters._model_key = mojo;
            Generic generic = new Generic(genericModelParameters);
            genericModel = (GenericModel)generic.trainModel().get();
            predictions = genericModel.score(testFrame);
            Assert.assertEquals((long)2691L, (long)predictions.numRows());
            boolean equallyScored = genericModel.testJavaScoring(testFrame, predictions, 0.0);
            Assert.assertTrue((boolean)equallyScored);
        }
        finally {
            if (model != null) {
                model.remove();
            }
            if (mojo != null) {
                mojo.remove();
            }
            if (genericModel != null) {
                genericModel.remove();
            }
            if (trainingFrame != null) {
                trainingFrame.remove();
            }
            if (testFrame != null) {
                testFrame.remove();
            }
            if (predictions != null) {
                predictions.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJavaScoring_irf_binomial() throws Exception {
        Key<Frame> mojo = null;
        IsolationForestModel model = null;
        GenericModel genericModel = null;
        Frame trainingFrame = null;
        Frame testFrame = null;
        Frame predictions = null;
        try {
            trainingFrame = GenericModelTest.parse_test_file((String)"./smalldata/testng/airlines_train.csv");
            testFrame = GenericModelTest.parse_test_file((String)"./smalldata/testng/airlines_test.csv");
            IsolationForestModel.IsolationForestParameters parms = new IsolationForestModel.IsolationForestParameters();
            parms._train = trainingFrame._key;
            parms._distribution = DistributionFamily.AUTO;
            parms._response_column = "IsDepDelayed";
            parms._ntrees = 1;
            IsolationForest job = new IsolationForest(parms);
            model = (IsolationForestModel)job.trainModel().get();
            Assert.assertEquals((Object)((IsolationForestModel.IsolationForestOutput)model._output).getModelCategory(), (Object)ModelCategory.AnomalyDetection);
            ByteArrayOutputStream originalModelMojo = new ByteArrayOutputStream();
            File originalModelMojoFile = File.createTempFile("mojo", "zip");
            model.getMojo().writeTo((OutputStream)originalModelMojo);
            model.getMojo().writeTo((OutputStream)new FileOutputStream(originalModelMojoFile));
            mojo = this.importMojo(originalModelMojoFile.getAbsolutePath());
            GenericModelParameters genericModelParameters = new GenericModelParameters();
            genericModelParameters._model_key = mojo;
            Generic generic = new Generic(genericModelParameters);
            genericModel = (GenericModel)generic.trainModel().get();
            predictions = genericModel.score(testFrame);
            Assert.assertEquals((long)2691L, (long)predictions.numRows());
            boolean equallyScored = genericModel.testJavaScoring(testFrame, predictions, 0.0);
            Assert.assertTrue((boolean)equallyScored);
        }
        finally {
            if (model != null) {
                model.remove();
            }
            if (mojo != null) {
                mojo.remove();
            }
            if (genericModel != null) {
                genericModel.remove();
            }
            if (trainingFrame != null) {
                trainingFrame.remove();
            }
            if (testFrame != null) {
                testFrame.remove();
            }
            if (predictions != null) {
                predictions.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJavaScoring_gbm_regression() throws Exception {
        Key<Frame> mojo = null;
        GBMModel model = null;
        GenericModel genericModel = null;
        Frame trainingFrame = null;
        Frame testFrame = null;
        Frame predictions = null;
        try {
            trainingFrame = GenericModelTest.parse_test_file((String)"./smalldata/testng/airlines_train.csv");
            testFrame = GenericModelTest.parse_test_file((String)"./smalldata/testng/airlines_test.csv");
            GBMModel.GBMParameters parms = new GBMModel.GBMParameters();
            parms._train = trainingFrame._key;
            parms._distribution = DistributionFamily.AUTO;
            parms._response_column = "Distance";
            parms._ntrees = 1;
            GBM job = new GBM(parms);
            model = (GBMModel)job.trainModel().get();
            Assert.assertEquals((Object)((GBMModel.GBMOutput)model._output).getModelCategory(), (Object)ModelCategory.Regression);
            ByteArrayOutputStream originalModelMojo = new ByteArrayOutputStream();
            File originalModelMojoFile = File.createTempFile("mojo", "zip");
            model.getMojo().writeTo((OutputStream)originalModelMojo);
            model.getMojo().writeTo((OutputStream)new FileOutputStream(originalModelMojoFile));
            mojo = this.importMojo(originalModelMojoFile.getAbsolutePath());
            GenericModelParameters genericModelParameters = new GenericModelParameters();
            genericModelParameters._model_key = mojo;
            Generic generic = new Generic(genericModelParameters);
            genericModel = (GenericModel)generic.trainModel().get();
            predictions = genericModel.score(testFrame);
            Assert.assertEquals((long)2691L, (long)predictions.numRows());
            boolean equallyScored = genericModel.testJavaScoring(testFrame, predictions, 0.0);
            Assert.assertTrue((boolean)equallyScored);
        }
        finally {
            if (model != null) {
                model.remove();
            }
            if (mojo != null) {
                mojo.remove();
            }
            if (genericModel != null) {
                genericModel.remove();
            }
            if (trainingFrame != null) {
                trainingFrame.remove();
            }
            if (testFrame != null) {
                testFrame.remove();
            }
            if (predictions != null) {
                predictions.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJavaScoring_drf_regression() throws Exception {
        Key<Frame> mojo = null;
        DRFModel model = null;
        GenericModel genericModel = null;
        Frame trainingFrame = null;
        Frame testFrame = null;
        Frame predictions = null;
        try {
            trainingFrame = GenericModelTest.parse_test_file((String)"./smalldata/testng/airlines_train.csv");
            testFrame = GenericModelTest.parse_test_file((String)"./smalldata/testng/airlines_test.csv");
            DRFModel.DRFParameters parms = new DRFModel.DRFParameters();
            parms._train = trainingFrame._key;
            parms._distribution = DistributionFamily.AUTO;
            parms._response_column = "Distance";
            parms._ntrees = 1;
            DRF job = new DRF(parms);
            model = (DRFModel)job.trainModel().get();
            Assert.assertEquals((Object)((DRFModel.DRFOutput)model._output).getModelCategory(), (Object)ModelCategory.Regression);
            ByteArrayOutputStream originalModelMojo = new ByteArrayOutputStream();
            File originalModelMojoFile = File.createTempFile("mojo", "zip");
            model.getMojo().writeTo((OutputStream)originalModelMojo);
            model.getMojo().writeTo((OutputStream)new FileOutputStream(originalModelMojoFile));
            mojo = this.importMojo(originalModelMojoFile.getAbsolutePath());
            GenericModelParameters genericModelParameters = new GenericModelParameters();
            genericModelParameters._model_key = mojo;
            Generic generic = new Generic(genericModelParameters);
            genericModel = (GenericModel)generic.trainModel().get();
            predictions = genericModel.score(testFrame);
            Assert.assertEquals((long)2691L, (long)predictions.numRows());
            boolean equallyScored = genericModel.testJavaScoring(testFrame, predictions, 0.0);
            Assert.assertTrue((boolean)equallyScored);
        }
        finally {
            if (model != null) {
                model.remove();
            }
            if (mojo != null) {
                mojo.remove();
            }
            if (genericModel != null) {
                genericModel.remove();
            }
            if (trainingFrame != null) {
                trainingFrame.remove();
            }
            if (testFrame != null) {
                testFrame.remove();
            }
            if (predictions != null) {
                predictions.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJavaScoring_irf_numerical() throws Exception {
        Key<Frame> mojo = null;
        IsolationForestModel model = null;
        GenericModel genericModel = null;
        Frame trainingFrame = null;
        Frame testFrame = null;
        Frame predictions = null;
        try {
            trainingFrame = GenericModelTest.parse_test_file((String)"./smalldata/testng/airlines_train.csv");
            testFrame = GenericModelTest.parse_test_file((String)"./smalldata/testng/airlines_test.csv");
            IsolationForestModel.IsolationForestParameters parms = new IsolationForestModel.IsolationForestParameters();
            parms._train = trainingFrame._key;
            parms._distribution = DistributionFamily.AUTO;
            parms._response_column = "Distance";
            parms._ntrees = 1;
            IsolationForest job = new IsolationForest(parms);
            model = (IsolationForestModel)job.trainModel().get();
            Assert.assertEquals((Object)((IsolationForestModel.IsolationForestOutput)model._output).getModelCategory(), (Object)ModelCategory.AnomalyDetection);
            ByteArrayOutputStream originalModelMojo = new ByteArrayOutputStream();
            File originalModelMojoFile = File.createTempFile("mojo", "zip");
            model.getMojo().writeTo((OutputStream)originalModelMojo);
            model.getMojo().writeTo((OutputStream)new FileOutputStream(originalModelMojoFile));
            mojo = this.importMojo(originalModelMojoFile.getAbsolutePath());
            GenericModelParameters genericModelParameters = new GenericModelParameters();
            genericModelParameters._model_key = mojo;
            Generic generic = new Generic(genericModelParameters);
            genericModel = (GenericModel)generic.trainModel().get();
            predictions = genericModel.score(testFrame);
            Assert.assertEquals((long)2691L, (long)predictions.numRows());
            boolean equallyScored = genericModel.testJavaScoring(testFrame, predictions, 0.0);
            Assert.assertTrue((boolean)equallyScored);
        }
        finally {
            if (model != null) {
                model.remove();
            }
            if (mojo != null) {
                mojo.remove();
            }
            if (genericModel != null) {
                genericModel.remove();
            }
            if (trainingFrame != null) {
                trainingFrame.remove();
            }
            if (testFrame != null) {
                testFrame.remove();
            }
            if (predictions != null) {
                predictions.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJavaScoring_glm() throws Exception {
        Key<Frame> mojo = null;
        GLMModel model = null;
        GenericModel genericModel = null;
        Frame trainingFrame = null;
        Frame testFrame = null;
        Frame predictions = null;
        try {
            trainingFrame = GenericModelTest.parse_test_file((String)"./smalldata/testng/airlines_train.csv");
            testFrame = GenericModelTest.parse_test_file((String)"./smalldata/testng/airlines_test.csv");
            GLMModel.GLMParameters parms = new GLMModel.GLMParameters();
            parms._train = trainingFrame._key;
            parms._distribution = DistributionFamily.AUTO;
            parms._response_column = "Distance";
            GLM job = new GLM(parms);
            model = (GLMModel)job.trainModel().get();
            Assert.assertEquals((Object)((GLMModel.GLMOutput)model._output).getModelCategory(), (Object)ModelCategory.Regression);
            ByteArrayOutputStream originalModelMojo = new ByteArrayOutputStream();
            File originalModelMojoFile = File.createTempFile("mojo", "zip");
            model.getMojo().writeTo((OutputStream)originalModelMojo);
            model.getMojo().writeTo((OutputStream)new FileOutputStream(originalModelMojoFile));
            mojo = this.importMojo(originalModelMojoFile.getAbsolutePath());
            GenericModelParameters genericModelParameters = new GenericModelParameters();
            genericModelParameters._model_key = mojo;
            Generic generic = new Generic(genericModelParameters);
            genericModel = (GenericModel)generic.trainModel().get();
            predictions = genericModel.score(testFrame);
            Assert.assertEquals((long)2691L, (long)predictions.numRows());
            boolean equallyScored = genericModel.testJavaScoring(testFrame, predictions, 0.0);
            Assert.assertTrue((boolean)equallyScored);
        }
        finally {
            if (model != null) {
                model.remove();
            }
            if (mojo != null) {
                mojo.remove();
            }
            if (genericModel != null) {
                genericModel.remove();
            }
            if (trainingFrame != null) {
                trainingFrame.remove();
            }
            if (testFrame != null) {
                testFrame.remove();
            }
            if (predictions != null) {
                predictions.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJavaScoring_gbm_multinomial() throws Exception {
        Key<Frame> mojo = null;
        GBMModel model = null;
        GenericModel genericModel = null;
        Frame trainingFrame = null;
        Frame testFrame = null;
        Frame predictions = null;
        try {
            trainingFrame = GenericModelTest.parse_test_file((String)"./smalldata/testng/airlines_train.csv");
            testFrame = GenericModelTest.parse_test_file((String)"./smalldata/testng/airlines_test.csv");
            GBMModel.GBMParameters parms = new GBMModel.GBMParameters();
            parms._train = trainingFrame._key;
            parms._distribution = DistributionFamily.AUTO;
            parms._response_column = "Origin";
            parms._ntrees = 1;
            GBM job = new GBM(parms);
            model = (GBMModel)job.trainModel().get();
            Assert.assertEquals((Object)((GBMModel.GBMOutput)model._output).getModelCategory(), (Object)ModelCategory.Multinomial);
            ByteArrayOutputStream originalModelMojo = new ByteArrayOutputStream();
            File originalModelMojoFile = File.createTempFile("mojo", "zip");
            model.getMojo().writeTo((OutputStream)originalModelMojo);
            model.getMojo().writeTo((OutputStream)new FileOutputStream(originalModelMojoFile));
            mojo = this.importMojo(originalModelMojoFile.getAbsolutePath());
            GenericModelParameters genericModelParameters = new GenericModelParameters();
            genericModelParameters._model_key = mojo;
            Generic generic = new Generic(genericModelParameters);
            genericModel = (GenericModel)generic.trainModel().get();
            Assert.assertNotNull((Object)((GenericModelOutput)genericModel._output)._model_summary);
            Assert.assertNotNull((Object)((GenericModelOutput)genericModel._output)._variable_importances);
            predictions = genericModel.score(testFrame);
            Assert.assertEquals((long)2691L, (long)predictions.numRows());
            boolean equallyScored = genericModel.testJavaScoring(testFrame, predictions, 0.0);
            Assert.assertTrue((boolean)equallyScored);
        }
        finally {
            if (model != null) {
                model.remove();
            }
            if (mojo != null) {
                mojo.remove();
            }
            if (genericModel != null) {
                genericModel.remove();
            }
            if (trainingFrame != null) {
                trainingFrame.remove();
            }
            if (testFrame != null) {
                testFrame.remove();
            }
            if (predictions != null) {
                predictions.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJavaScoring_drf_multinomial() throws Exception {
        Key<Frame> mojo = null;
        DRFModel model = null;
        GenericModel genericModel = null;
        Frame trainingFrame = null;
        Frame testFrame = null;
        Frame predictions = null;
        try {
            trainingFrame = GenericModelTest.parse_test_file((String)"./smalldata/testng/airlines_train.csv");
            testFrame = GenericModelTest.parse_test_file((String)"./smalldata/testng/airlines_test.csv");
            DRFModel.DRFParameters parms = new DRFModel.DRFParameters();
            parms._train = trainingFrame._key;
            parms._distribution = DistributionFamily.AUTO;
            parms._response_column = "Origin";
            parms._ntrees = 1;
            DRF job = new DRF(parms);
            model = (DRFModel)job.trainModel().get();
            Assert.assertEquals((Object)((DRFModel.DRFOutput)model._output).getModelCategory(), (Object)ModelCategory.Multinomial);
            ByteArrayOutputStream originalModelMojo = new ByteArrayOutputStream();
            File originalModelMojoFile = File.createTempFile("mojo", "zip");
            model.getMojo().writeTo((OutputStream)originalModelMojo);
            model.getMojo().writeTo((OutputStream)new FileOutputStream(originalModelMojoFile));
            mojo = this.importMojo(originalModelMojoFile.getAbsolutePath());
            GenericModelParameters genericModelParameters = new GenericModelParameters();
            genericModelParameters._model_key = mojo;
            Generic generic = new Generic(genericModelParameters);
            genericModel = (GenericModel)generic.trainModel().get();
            predictions = genericModel.score(testFrame);
            Assert.assertEquals((long)2691L, (long)predictions.numRows());
            boolean equallyScored = genericModel.testJavaScoring(testFrame, predictions, 0.0);
            Assert.assertTrue((boolean)equallyScored);
        }
        finally {
            if (model != null) {
                model.remove();
            }
            if (mojo != null) {
                mojo.remove();
            }
            if (genericModel != null) {
                genericModel.remove();
            }
            if (trainingFrame != null) {
                trainingFrame.remove();
            }
            if (testFrame != null) {
                testFrame.remove();
            }
            if (predictions != null) {
                predictions.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJavaScoring_irf_multinomial() throws Exception {
        Key<Frame> mojo = null;
        IsolationForestModel model = null;
        GenericModel genericModel = null;
        Frame trainingFrame = null;
        Frame testFrame = null;
        Frame predictions = null;
        try {
            trainingFrame = GenericModelTest.parse_test_file((String)"./smalldata/testng/airlines_train.csv");
            testFrame = GenericModelTest.parse_test_file((String)"./smalldata/testng/airlines_test.csv");
            IsolationForestModel.IsolationForestParameters parms = new IsolationForestModel.IsolationForestParameters();
            parms._train = trainingFrame._key;
            parms._distribution = DistributionFamily.AUTO;
            parms._response_column = "Origin";
            parms._ntrees = 1;
            IsolationForest job = new IsolationForest(parms);
            model = (IsolationForestModel)job.trainModel().get();
            Assert.assertEquals((Object)((IsolationForestModel.IsolationForestOutput)model._output).getModelCategory(), (Object)ModelCategory.AnomalyDetection);
            ByteArrayOutputStream originalModelMojo = new ByteArrayOutputStream();
            File originalModelMojoFile = File.createTempFile("mojo", "zip");
            model.getMojo().writeTo((OutputStream)originalModelMojo);
            model.getMojo().writeTo((OutputStream)new FileOutputStream(originalModelMojoFile));
            mojo = this.importMojo(originalModelMojoFile.getAbsolutePath());
            GenericModelParameters genericModelParameters = new GenericModelParameters();
            genericModelParameters._model_key = mojo;
            Generic generic = new Generic(genericModelParameters);
            genericModel = (GenericModel)generic.trainModel().get();
            predictions = genericModel.score(testFrame);
            Assert.assertEquals((long)2691L, (long)predictions.numRows());
            boolean equallyScored = genericModel.testJavaScoring(testFrame, predictions, 0.0);
            Assert.assertTrue((boolean)equallyScored);
        }
        finally {
            if (model != null) {
                model.remove();
            }
            if (mojo != null) {
                mojo.remove();
            }
            if (genericModel != null) {
                genericModel.remove();
            }
            if (trainingFrame != null) {
                trainingFrame.remove();
            }
            if (testFrame != null) {
                testFrame.remove();
            }
            if (predictions != null) {
                predictions.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void downloadable_mojo_gbm() throws IOException {
        GBMModel gbm = null;
        Key<Frame> mojo = null;
        GenericModel genericModel = null;
        Frame trainingFrame = null;
        try {
            trainingFrame = GenericModelTest.parse_test_file((String)"./smalldata/gbm_test/Mfgdata_gaussian_GBM_testing.csv");
            GBMModel.GBMParameters parms = new GBMModel.GBMParameters();
            parms._train = trainingFrame._key;
            parms._distribution = DistributionFamily.AUTO;
            parms._response_column = trainingFrame._names[1];
            parms._ntrees = 1;
            GBM job = new GBM(parms);
            gbm = (GBMModel)job.trainModel().get();
            File originalModelMojoFile = File.createTempFile("mojo", "zip");
            gbm.getMojo().writeTo((OutputStream)new FileOutputStream(originalModelMojoFile));
            mojo = this.importMojo(originalModelMojoFile.getAbsolutePath());
            GenericModelParameters genericModelParameters = new GenericModelParameters();
            genericModelParameters._model_key = mojo;
            Generic generic = new Generic(genericModelParameters);
            genericModel = (GenericModel)generic.trainModel().get();
            File genericModelMojoFile = File.createTempFile("mojo", "zip");
            genericModel.getMojo().writeTo((OutputStream)new FileOutputStream(genericModelMojoFile));
            Assert.assertArrayEquals((byte[])FileUtils.readFileToByteArray((File)originalModelMojoFile), (byte[])FileUtils.readFileToByteArray((File)genericModelMojoFile));
        }
        finally {
            if (gbm != null) {
                gbm.remove();
            }
            if (mojo != null) {
                mojo.remove();
            }
            if (genericModel != null) {
                genericModel.remove();
            }
            if (trainingFrame != null) {
                trainingFrame.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void downloadable_mojo_drf() throws IOException {
        DRFModel originalModel = null;
        Key<Frame> mojo = null;
        GenericModel genericModel = null;
        Frame trainingFrame = null;
        try {
            trainingFrame = GenericModelTest.parse_test_file((String)"./smalldata/gbm_test/Mfgdata_gaussian_GBM_testing.csv");
            DRFModel.DRFParameters parms = new DRFModel.DRFParameters();
            parms._train = trainingFrame._key;
            parms._distribution = DistributionFamily.AUTO;
            parms._response_column = trainingFrame._names[1];
            parms._ntrees = 1;
            DRF job = new DRF(parms);
            originalModel = (DRFModel)job.trainModel().get();
            File originalModelMojoFile = File.createTempFile("mojo", "zip");
            originalModel.getMojo().writeTo((OutputStream)new FileOutputStream(originalModelMojoFile));
            mojo = this.importMojo(originalModelMojoFile.getAbsolutePath());
            GenericModelParameters genericModelParameters = new GenericModelParameters();
            genericModelParameters._model_key = mojo;
            Generic generic = new Generic(genericModelParameters);
            genericModel = (GenericModel)generic.trainModel().get();
            File genericModelMojoFile = File.createTempFile("mojo", "zip");
            genericModel.getMojo().writeTo((OutputStream)new FileOutputStream(genericModelMojoFile));
            Assert.assertArrayEquals((byte[])FileUtils.readFileToByteArray((File)originalModelMojoFile), (byte[])FileUtils.readFileToByteArray((File)genericModelMojoFile));
        }
        finally {
            if (originalModel != null) {
                originalModel.remove();
            }
            if (mojo != null) {
                mojo.remove();
            }
            if (genericModel != null) {
                genericModel.remove();
            }
            if (trainingFrame != null) {
                trainingFrame.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void downloadable_mojo_irf() throws IOException {
        IsolationForestModel originalModel = null;
        Key<Frame> mojo = null;
        GenericModel genericModel = null;
        Frame trainingFrame = null;
        try {
            trainingFrame = GenericModelTest.parse_test_file((String)"./smalldata/gbm_test/Mfgdata_gaussian_GBM_testing.csv");
            IsolationForestModel.IsolationForestParameters parms = new IsolationForestModel.IsolationForestParameters();
            parms._train = trainingFrame._key;
            parms._distribution = DistributionFamily.AUTO;
            parms._response_column = trainingFrame._names[1];
            parms._ntrees = 1;
            IsolationForest job = new IsolationForest(parms);
            originalModel = (IsolationForestModel)job.trainModel().get();
            File originalModelMojoFile = File.createTempFile("mojo", "zip");
            originalModel.getMojo().writeTo((OutputStream)new FileOutputStream(originalModelMojoFile));
            mojo = this.importMojo(originalModelMojoFile.getAbsolutePath());
            GenericModelParameters genericModelParameters = new GenericModelParameters();
            genericModelParameters._model_key = mojo;
            Generic generic = new Generic(genericModelParameters);
            genericModel = (GenericModel)generic.trainModel().get();
            File genericModelMojoFile = File.createTempFile("mojo", "zip");
            genericModel.getMojo().writeTo((OutputStream)new FileOutputStream(genericModelMojoFile));
            Assert.assertArrayEquals((byte[])FileUtils.readFileToByteArray((File)originalModelMojoFile), (byte[])FileUtils.readFileToByteArray((File)genericModelMojoFile));
        }
        finally {
            if (originalModel != null) {
                originalModel.remove();
            }
            if (mojo != null) {
                mojo.remove();
            }
            if (genericModel != null) {
                genericModel.remove();
            }
            if (trainingFrame != null) {
                trainingFrame.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void downloadable_mojo_glm() throws IOException {
        GLMModel originalModel = null;
        Key<Frame> mojo = null;
        GenericModel genericModel = null;
        Frame trainingFrame = null;
        try {
            trainingFrame = GenericModelTest.parse_test_file((String)"./smalldata/gbm_test/Mfgdata_gaussian_GBM_testing.csv");
            GLMModel.GLMParameters parms = new GLMModel.GLMParameters();
            parms._train = trainingFrame._key;
            parms._distribution = DistributionFamily.AUTO;
            parms._response_column = trainingFrame._names[1];
            GLM job = new GLM(parms);
            originalModel = (GLMModel)job.trainModel().get();
            File originalModelMojoFile = File.createTempFile("mojo", "zip");
            originalModel.getMojo().writeTo((OutputStream)new FileOutputStream(originalModelMojoFile));
            mojo = this.importMojo(originalModelMojoFile.getAbsolutePath());
            GenericModelParameters genericModelParameters = new GenericModelParameters();
            genericModelParameters._model_key = mojo;
            Generic generic = new Generic(genericModelParameters);
            genericModel = (GenericModel)generic.trainModel().get();
            File genericModelMojoFile = File.createTempFile("mojo", "zip");
            genericModel.getMojo().writeTo((OutputStream)new FileOutputStream(genericModelMojoFile));
            Assert.assertArrayEquals((byte[])FileUtils.readFileToByteArray((File)originalModelMojoFile), (byte[])FileUtils.readFileToByteArray((File)genericModelMojoFile));
        }
        finally {
            if (originalModel != null) {
                originalModel.remove();
            }
            if (mojo != null) {
                mojo.remove();
            }
            if (genericModel != null) {
                genericModel.remove();
            }
            if (trainingFrame != null) {
                trainingFrame.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void downloadable_mojo_glm_binomial() throws IOException {
        GLMModel originalModel = null;
        Key<Frame> mojo = null;
        GenericModel genericModel = null;
        Frame trainingFrame = null;
        try {
            trainingFrame = GenericModelTest.parse_test_file((String)"./smalldata/testng/airlines_train.csv");
            GLMModel.GLMParameters parms = new GLMModel.GLMParameters();
            parms._train = trainingFrame._key;
            parms._distribution = DistributionFamily.AUTO;
            parms._family = GLMModel.GLMParameters.Family.binomial;
            parms._response_column = "IsDepDelayed";
            GLM job = new GLM(parms);
            originalModel = (GLMModel)job.trainModel().get();
            File originalModelMojoFile = File.createTempFile("mojo", "zip");
            originalModel.getMojo().writeTo((OutputStream)new FileOutputStream(originalModelMojoFile));
            mojo = this.importMojo(originalModelMojoFile.getAbsolutePath());
            GenericModelParameters genericModelParameters = new GenericModelParameters();
            genericModelParameters._model_key = mojo;
            Generic generic = new Generic(genericModelParameters);
            genericModel = (GenericModel)generic.trainModel().get();
            File genericModelMojoFile = File.createTempFile("mojo", "zip");
            genericModel.getMojo().writeTo((OutputStream)new FileOutputStream(genericModelMojoFile));
            Assert.assertArrayEquals((byte[])FileUtils.readFileToByteArray((File)originalModelMojoFile), (byte[])FileUtils.readFileToByteArray((File)genericModelMojoFile));
        }
        finally {
            if (originalModel != null) {
                originalModel.remove();
            }
            if (mojo != null) {
                mojo.remove();
            }
            if (genericModel != null) {
                genericModel.remove();
            }
            if (trainingFrame != null) {
                trainingFrame.remove();
            }
        }
    }

    private Key<Frame> importMojo(String mojoAbsolutePath) {
        ArrayList keys = new ArrayList(1);
        H2O.getPM().importFiles(mojoAbsolutePath, "", new ArrayList(), keys, new ArrayList(), new ArrayList());
        Assert.assertEquals((long)1L, (long)keys.size());
        return DKV.get((String)((String)keys.get((int)0)))._key;
    }
}

