/*
 * Decompiled with CFR 0.152.
 */
package hex.example;

import hex.genmodel.utils.DistributionFamily;
import hex.glm.GLM;
import hex.glm.GLMModel;
import hex.quantile.Quantile;
import hex.quantile.QuantileModel;
import hex.splitframe.ShuffleSplitFrame;
import hex.tree.gbm.GBM;
import hex.tree.gbm.GBMModel;
import java.io.File;
import java.util.Arrays;
import org.joda.time.MutableDateTime;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import water.DKV;
import water.Futures;
import water.Job;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.Scope;
import water.TestUtil;
import water.fvec.AppendableVec;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NFSFileVec;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.ParseDataset;
import water.util.ArrayUtils;

@Ignore(value="Test DS end-to-end workflow; not intended as a junit yet")
public class WorkFlowTest
extends TestUtil {
    @BeforeClass
    public static void setup() {
        WorkFlowTest.stall_till_cloudsize((int)1);
    }

    @Test
    public void testWorkFlowSmall() {
        String[] files = new String[]{"bigdata/laptop/citibike-nyc/2013-10.csv"};
        this.testWorkFlow(files);
    }

    @Test
    @Ignore
    public void testWorkFlowBig() {
        String[] files = new String[]{"bigdata/laptop/citibike-nyc/2013-07.csv", "bigdata/laptop/citibike-nyc/2013-08.csv", "bigdata/laptop/citibike-nyc/2013-09.csv", "bigdata/laptop/citibike-nyc/2013-10.csv", "bigdata/laptop/citibike-nyc/2013-11.csv", "bigdata/laptop/citibike-nyc/2013-12.csv", "bigdata/laptop/citibike-nyc/2014-01.csv", "bigdata/laptop/citibike-nyc/2014-02.csv", "bigdata/laptop/citibike-nyc/2014-03.csv", "bigdata/laptop/citibike-nyc/2014-04.csv", "bigdata/laptop/citibike-nyc/2014-05.csv", "bigdata/laptop/citibike-nyc/2014-06.csv", "bigdata/laptop/citibike-nyc/2014-07.csv", "bigdata/laptop/citibike-nyc/2014-08.csv"};
        this.testWorkFlow(files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testWorkFlow(String[] files) {
        try {
            Scope.enter();
            Frame data = this.load_files("data.hex", files);
            if (data == null) {
                return;
            }
            Vec startime = data.vec("starttime");
            data.add(new TimeSplit().doIt(startime));
            Vec days = data.vec("Days");
            long start = System.currentTimeMillis();
            Frame bph = ((CountBikes)new CountBikes(days).doAll(new Vec[]{days, data.vec("start station name")})).makeFrame(Key.make((String)"bph.hex"));
            System.out.println("Groupby took " + (System.currentTimeMillis() - start));
            System.out.println(bph);
            System.out.println(bph.toString(10000L, 20));
            data.remove();
            QuantileModel.QuantileParameters quantile_parms = new QuantileModel.QuantileParameters();
            quantile_parms._train = bph._key;
            Job job2 = new Quantile(quantile_parms).trainModel();
            QuantileModel quantile = (QuantileModel)job2.get();
            job2.remove();
            System.out.println(Arrays.deepToString((Object[])((QuantileModel.QuantileOutput)quantile._output)._quantiles));
            quantile.remove();
            Key[] keys = new Key[]{Key.make((String)"train.hex"), Key.make((String)"test.hex"), Key.make((String)"hold.hex")};
            double[] ratios = new double[]{0.6, 0.3, 0.1};
            Frame[] frs = ShuffleSplitFrame.shuffleSplitFrame((Frame)bph, (Key[])keys, (double[])ratios, (long)1234567689L);
            Frame train = frs[0];
            Frame test = frs[1];
            Frame hold = frs[2];
            bph.remove();
            System.out.println(train);
            System.out.println(test);
            GBMModel.GBMParameters gbm_parms = new GBMModel.GBMParameters();
            gbm_parms._train = train._key;
            gbm_parms._valid = test._key;
            gbm_parms._score_each_iteration = false;
            gbm_parms._response_column = "bikes";
            gbm_parms._ntrees = 500;
            gbm_parms._max_depth = 6;
            gbm_parms._min_rows = 10.0;
            gbm_parms._nbins = 20;
            gbm_parms._distribution = DistributionFamily.gaussian;
            gbm_parms._learn_rate = 0.1f;
            Job job = new GBM(gbm_parms).trainModel();
            GBMModel gbm = (GBMModel)job.get();
            job.remove();
            GLMModel.GLMParameters glm_parms = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.gaussian);
            glm_parms._train = train._key;
            glm_parms._valid = test._key;
            glm_parms._score_each_iteration = false;
            glm_parms._response_column = "bikes";
            glm_parms._use_all_factor_levels = true;
            Job glm_job = new GLM(glm_parms).trainModel();
            GLMModel glm = (GLMModel)glm_job.get();
            glm_job.remove();
            gbm.score(train).remove();
            glm.score(train).remove();
            train.remove();
            test.remove();
            hold.remove();
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Frame load_files(String hex, String[] fnames) {
        long start = System.currentTimeMillis();
        System.out.print("Loading " + hex + "...");
        try {
            Key[] keys = new Key[fnames.length];
            for (int i = 0; i < fnames.length; ++i) {
                File f = new File(fnames[i]);
                if (!f.exists()) {
                    System.out.println("File " + fnames[i] + " missing, aborting test");
                    Frame frame = null;
                    return frame;
                }
                keys[i] = NFSFileVec.make((File)f)._key;
            }
            Frame frame = ParseDataset.parse((Key)Key.make((String)hex), (Key[])keys);
            return frame;
        }
        finally {
            System.out.println("loaded in " + (double)(System.currentTimeMillis() - start) / 1000.0 + "secs");
        }
    }

    class CountBikes
    extends MRTask<CountBikes> {
        int[] _bikes;
        final int _day0;
        final int _last_day;
        int _num_sid;

        private int idx(long day, long sid) {
            return (int)((day - (long)this._day0) * (long)this._num_sid + sid);
        }

        CountBikes(Vec vday) {
            this._day0 = (int)vday.at8(0L);
            this._last_day = (int)vday.at8((long)((int)vday.length() - 1)) + 1;
        }

        public void map(Chunk[] chk) {
            Chunk day = chk[0];
            Chunk sid = chk[1];
            this._num_sid = sid.vec().cardinality();
            int len = chk[0]._len;
            this._bikes = new int[this.idx(this._last_day, 0L)];
            for (int i = 0; i < len; ++i) {
                int n = this.idx(day.at8(i), sid.at8(i));
                this._bikes[n] = this._bikes[n] + 1;
            }
        }

        public void reduce(CountBikes cb) {
            ArrayUtils.add((int[])this._bikes, (int[])cb._bikes);
        }

        Frame makeFrame(Key key) {
            int ncols = 4;
            AppendableVec[] avecs = new AppendableVec[4];
            NewChunk[] ncs = new NewChunk[4];
            Key[] keys = Vec.VectorGroup.VG_LEN1.addVecs(4);
            for (int c = 0; c < avecs.length; ++c) {
                avecs[c] = new AppendableVec(keys[c], 3);
            }
            Futures fs = new Futures();
            int chunknum = 0;
            MutableDateTime mdt = new MutableDateTime();
            for (int day = this._day0; day < this._last_day; ++day) {
                for (int sid = 0; sid < this._num_sid; ++sid) {
                    int bikecnt = this._bikes[this.idx(day, sid)];
                    if (bikecnt == 0) continue;
                    if (ncs[0] == null) {
                        for (int c = 0; c < 4; ++c) {
                            ncs[c] = new NewChunk((Vec)avecs[c], chunknum);
                        }
                    }
                    ncs[0].addNum((double)sid);
                    ncs[1].addNum((double)bikecnt);
                    long msec = (long)day * 86400000L;
                    mdt.setMillis(msec);
                    ncs[2].addNum((double)(mdt.getMonthOfYear() - 1));
                    ncs[3].addNum((double)(mdt.getDayOfWeek() - 1));
                }
                if (ncs[0] == null) continue;
                for (int c = 0; c < 4; ++c) {
                    ncs[c].close(chunknum, fs);
                }
                ++chunknum;
                ncs[0] = null;
            }
            Vec[] vecs = new Vec[4];
            int rowLayout = avecs[0].compute_rowLayout();
            for (int c = 0; c < avecs.length; ++c) {
                vecs[c] = avecs[c].close(rowLayout, fs);
            }
            vecs[0].setDomain(this._fr.vec(1).domain());
            vecs[1].setDomain(null);
            vecs[2].setDomain(new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"});
            vecs[3].setDomain(new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"});
            fs.blockForPending();
            Frame fr = new Frame(key, new String[]{"Station", "bikes", "Month", "DayOfWeek"}, vecs);
            DKV.put((Keyed)fr);
            return fr;
        }
    }

    class TimeSplit
    extends MRTask<TimeSplit> {
        TimeSplit() {
        }

        public Frame doIt(Vec time) {
            return ((TimeSplit)this.doAll(new byte[]{3}, new Vec[]{time})).outputFrame(new String[]{"Days"}, null);
        }

        public void map(Chunk msec, NewChunk day) {
            for (int i = 0; i < msec._len; ++i) {
                day.addNum((double)(msec.at8(i) / 86400000L));
            }
        }
    }
}

