/*
 * Decompiled with CFR 0.152.
 */
package hex.ensemble;

import hex.GLMHelper;
import hex.Model;
import hex.ModelMetrics;
import hex.SplitFrame;
import hex.ensemble.Metalearner;
import hex.ensemble.StackedEnsemble;
import hex.ensemble.StackedEnsembleModel;
import hex.genmodel.utils.DistributionFamily;
import hex.glm.GLM;
import hex.glm.GLMModel;
import hex.grid.Grid;
import hex.grid.GridSearch;
import hex.splitframe.ShuffleSplitFrame;
import hex.tree.drf.DRF;
import hex.tree.drf.DRFModel;
import hex.tree.gbm.GBM;
import hex.tree.gbm.GBMModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import water.DKV;
import water.H2O;
import water.Job;
import water.Key;
import water.Keyed;
import water.Lockable;
import water.MRTask;
import water.Scope;
import water.TestUtil;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.Log;

public class StackedEnsembleTest
extends TestUtil {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    static final String[] ignored_aircols = new String[]{"DepTime", "ArrTime", "AirTime", "ArrDelay", "DepDelay", "TaxiIn", "TaxiOut", "Cancelled", "CancellationCode", "Diverted", "CarrierDelay", "WeatherDelay", "NASDelay", "SecurityDelay", "LateAircraftDelay", "IsDepDelayed"};

    @BeforeClass
    public static void stall() {
        StackedEnsembleTest.stall_till_cloudsize((int)1);
    }

    @Test
    public void testBasicEnsembleAUTOMetalearner() {
        this.basicEnsemble("./smalldata/junit/cars.csv", null, new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("name").remove();
                return ~fr.find("economy (mpg)");
            }
        }, false, DistributionFamily.gaussian, Metalearner.Algorithm.AUTO, false);
        this.basicEnsemble("./smalldata/airlines/allyears2k_headers.zip", null, new PrepData(){

            @Override
            int prep(Frame fr) {
                for (String s : ignored_aircols) {
                    fr.remove(s).remove();
                }
                return fr.find("IsArrDelayed");
            }
        }, false, DistributionFamily.bernoulli, Metalearner.Algorithm.AUTO, false);
        this.basicEnsemble("./smalldata/iris/iris_wheader.csv", null, new PrepData(){

            @Override
            int prep(Frame fr) {
                return fr.find("class");
            }
        }, false, DistributionFamily.multinomial, Metalearner.Algorithm.AUTO, false);
        this.basicEnsemble("./smalldata/logreg/prostate_train.csv", "./smalldata/logreg/prostate_test.csv", new PrepData(){

            @Override
            int prep(Frame fr) {
                return fr.find("CAPSULE");
            }
        }, false, DistributionFamily.bernoulli, Metalearner.Algorithm.AUTO, false);
    }

    @Test
    public void testBasicEnsembleGBMMetalearner() {
        this.basicEnsemble("./smalldata/junit/cars.csv", null, new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("name").remove();
                return ~fr.find("economy (mpg)");
            }
        }, false, DistributionFamily.gaussian, Metalearner.Algorithm.gbm, false);
        this.basicEnsemble("./smalldata/airlines/allyears2k_headers.zip", null, new PrepData(){

            @Override
            int prep(Frame fr) {
                for (String s : ignored_aircols) {
                    fr.remove(s).remove();
                }
                return fr.find("IsArrDelayed");
            }
        }, false, DistributionFamily.bernoulli, Metalearner.Algorithm.gbm, false);
        this.basicEnsemble("./smalldata/iris/iris_wheader.csv", null, new PrepData(){

            @Override
            int prep(Frame fr) {
                return fr.find("class");
            }
        }, false, DistributionFamily.multinomial, Metalearner.Algorithm.gbm, false);
        this.basicEnsemble("./smalldata/logreg/prostate_train.csv", "./smalldata/logreg/prostate_test.csv", new PrepData(){

            @Override
            int prep(Frame fr) {
                return fr.find("CAPSULE");
            }
        }, false, DistributionFamily.bernoulli, Metalearner.Algorithm.gbm, false);
    }

    @Test
    public void testBasicEnsembleDRFMetalearner() {
        this.basicEnsemble("./smalldata/junit/cars.csv", null, new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("name").remove();
                return ~fr.find("economy (mpg)");
            }
        }, false, DistributionFamily.gaussian, Metalearner.Algorithm.drf, false);
        this.basicEnsemble("./smalldata/airlines/allyears2k_headers.zip", null, new PrepData(){

            @Override
            int prep(Frame fr) {
                for (String s : ignored_aircols) {
                    fr.remove(s).remove();
                }
                return fr.find("IsArrDelayed");
            }
        }, false, DistributionFamily.bernoulli, Metalearner.Algorithm.drf, false);
        this.basicEnsemble("./smalldata/iris/iris_wheader.csv", null, new PrepData(){

            @Override
            int prep(Frame fr) {
                return fr.find("class");
            }
        }, false, DistributionFamily.multinomial, Metalearner.Algorithm.drf, false);
        this.basicEnsemble("./smalldata/logreg/prostate_train.csv", "./smalldata/logreg/prostate_test.csv", new PrepData(){

            @Override
            int prep(Frame fr) {
                return fr.find("CAPSULE");
            }
        }, false, DistributionFamily.bernoulli, Metalearner.Algorithm.drf, false);
    }

    @Test
    public void testBasicEnsembleDeepLearningMetalearner() {
        this.basicEnsemble("./smalldata/junit/cars.csv", null, new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("name").remove();
                return ~fr.find("economy (mpg)");
            }
        }, false, DistributionFamily.gaussian, Metalearner.Algorithm.deeplearning, false);
        this.basicEnsemble("./smalldata/airlines/allyears2k_headers.zip", null, new PrepData(){

            @Override
            int prep(Frame fr) {
                for (String s : ignored_aircols) {
                    fr.remove(s).remove();
                }
                return fr.find("IsArrDelayed");
            }
        }, false, DistributionFamily.bernoulli, Metalearner.Algorithm.deeplearning, false);
        this.basicEnsemble("./smalldata/iris/iris_wheader.csv", null, new PrepData(){

            @Override
            int prep(Frame fr) {
                return fr.find("class");
            }
        }, false, DistributionFamily.multinomial, Metalearner.Algorithm.deeplearning, false);
        this.basicEnsemble("./smalldata/logreg/prostate_train.csv", "./smalldata/logreg/prostate_test.csv", new PrepData(){

            @Override
            int prep(Frame fr) {
                return fr.find("CAPSULE");
            }
        }, false, DistributionFamily.bernoulli, Metalearner.Algorithm.deeplearning, false);
    }

    @Test
    public void testBasicEnsembleGLMMetalearner() {
        this.basicEnsemble("./smalldata/junit/cars.csv", null, new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("name").remove();
                return ~fr.find("economy (mpg)");
            }
        }, false, DistributionFamily.gaussian, Metalearner.Algorithm.glm, false);
        this.basicEnsemble("./smalldata/junit/test_tree_minmax.csv", null, new PrepData(){

            @Override
            int prep(Frame fr) {
                return fr.find("response");
            }
        }, false, DistributionFamily.bernoulli, Metalearner.Algorithm.glm, false);
        this.basicEnsemble("./smalldata/logreg/prostate.csv", null, new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("ID").remove();
                return fr.find("CAPSULE");
            }
        }, false, DistributionFamily.bernoulli, Metalearner.Algorithm.glm, false);
        this.basicEnsemble("./smalldata/logreg/prostate_train.csv", "./smalldata/logreg/prostate_test.csv", new PrepData(){

            @Override
            int prep(Frame fr) {
                return fr.find("CAPSULE");
            }
        }, false, DistributionFamily.bernoulli, Metalearner.Algorithm.glm, false);
        this.basicEnsemble("./smalldata/gbm_test/alphabet_cattest.csv", null, new PrepData(){

            @Override
            int prep(Frame fr) {
                return fr.find("y");
            }
        }, false, DistributionFamily.bernoulli, Metalearner.Algorithm.glm, false);
        this.basicEnsemble("./smalldata/airlines/allyears2k_headers.zip", null, new PrepData(){

            @Override
            int prep(Frame fr) {
                for (String s : ignored_aircols) {
                    fr.remove(s).remove();
                }
                return fr.find("IsArrDelayed");
            }
        }, false, DistributionFamily.bernoulli, Metalearner.Algorithm.glm, false);
        this.basicEnsemble("./smalldata/logreg/prostate.csv", null, new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("ID").remove();
                return fr.find("RACE");
            }
        }, false, DistributionFamily.multinomial, Metalearner.Algorithm.glm, false);
        this.basicEnsemble("./smalldata/junit/cars.csv", null, new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("name").remove();
                return fr.find("cylinders");
            }
        }, false, DistributionFamily.multinomial, Metalearner.Algorithm.glm, false);
        this.basicEnsemble("./smalldata/iris/iris_wheader.csv", null, new PrepData(){

            @Override
            int prep(Frame fr) {
                return fr.find("class");
            }
        }, false, DistributionFamily.multinomial, Metalearner.Algorithm.glm, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPubDev6157() {
        try {
            Scope.enter();
            Vec v = Vec.makeConN((long)100000L, (int)(H2O.ARGS.nthreads * 4));
            Scope.track((Vec)v);
            int nclasses = 4;
            byte[] types = new byte[]{3, 4};
            String[][] domains = new String[types.length][];
            domains[domains.length - 1] = new String[4];
            for (int i = 0; i < 4; ++i) {
                domains[domains.length - 1][i] = "Level" + i;
            }
            final Frame training = new Pubdev6157MRTask(4).doAll(types, new Vec[]{v}).outputFrame(Key.make(), null, domains);
            Scope.track((Frame[])new Frame[]{training});
            GLMModel.GLMParameters parms = new GLMModel.GLMParameters();
            parms._train = training._key;
            parms._response_column = training.lastVecName();
            parms._family = GLMModel.GLMParameters.Family.multinomial;
            parms._max_iterations = 1;
            parms._seed = 42L;
            parms._auto_rebalance = false;
            GLM glm = new GLM(parms);
            final GLMModel model = (GLMModel)glm.trainModelOnH2ONode().get();
            Scope.track_generic((Keyed)model);
            Assert.assertNotNull((Object)model);
            final Job j = new Job(Key.make(), parms.javaName(), parms.algoName());
            j.start(new H2O.H2OCountedCompleter(){

                public void compute2() {
                    GLMHelper.runBigScore(model, training, false, false, j);
                    this.tryComplete();
                }
            }, 1L).get();
            this.basicEnsemble("./smalldata/iris/iris_wheader.csv", null, new PrepData(){

                @Override
                int prep(Frame fr) {
                    return fr.find("class");
                }
            }, false, DistributionFamily.multinomial, Metalearner.Algorithm.glm, false);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    @Test
    public void testBlending() {
        this.basicEnsemble("./smalldata/junit/cars.csv", null, new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("name").remove();
                return ~fr.find("economy (mpg)");
            }
        }, false, DistributionFamily.gaussian, Metalearner.Algorithm.AUTO, true);
        this.basicEnsemble("./smalldata/airlines/allyears2k_headers.zip", null, new PrepData(){

            @Override
            int prep(Frame fr) {
                for (String s : ignored_aircols) {
                    fr.remove(s).remove();
                }
                return fr.find("IsArrDelayed");
            }
        }, false, DistributionFamily.bernoulli, Metalearner.Algorithm.AUTO, true);
        this.basicEnsemble("./smalldata/iris/iris_wheader.csv", null, new PrepData(){

            @Override
            int prep(Frame fr) {
                return fr.find("class");
            }
        }, false, DistributionFamily.multinomial, Metalearner.Algorithm.AUTO, true);
        this.basicEnsemble("./smalldata/logreg/prostate_train.csv", "./smalldata/logreg/prostate_test.csv", new PrepData(){

            @Override
            int prep(Frame fr) {
                return fr.find("CAPSULE");
            }
        }, false, DistributionFamily.bernoulli, Metalearner.Algorithm.AUTO, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBaseModelPredictionsCaching() {
        Grid grid = null;
        ArrayList<StackedEnsembleModel> seModels = new ArrayList<StackedEnsembleModel>();
        ArrayList<Frame> frames = new ArrayList<Frame>();
        try {
            Object[] first_se_pred_keys;
            Scope.enter();
            long seed = 24576L;
            Frame train = StackedEnsembleTest.parse_test_file((String)"./smalldata/junit/cars.csv");
            String target = "economy (mpg)";
            Frame[] splits = ShuffleSplitFrame.shuffleSplitFrame((Frame)train, (Key[])new Key[]{Key.make((String)(train._key + "_train")), Key.make((String)(train._key + "_blending")), Key.make((String)(train._key + "_valid"))}, (double[])new double[]{0.5, 0.3, 0.2}, (long)seed);
            train.remove();
            train = splits[0];
            Frame blend = splits[1];
            Frame valid = splits[2];
            frames.addAll(Arrays.asList(train, blend, valid));
            GBMModel.GBMParameters params = new GBMModel.GBMParameters();
            params._distribution = DistributionFamily.gaussian;
            params._train = train._key;
            params._response_column = target;
            params._seed = seed;
            Job gridSearch = GridSearch.startGridSearch(null, (Model.Parameters)params, (Map)new HashMap<String, Object[]>(){
                {
                    this.put("_ntrees", new Integer[]{3, 5});
                    this.put("_learn_rate", new Double[]{0.1, 0.2});
                }
            });
            grid = (Grid)gridSearch.get();
            Model[] models = grid.getModels();
            Assert.assertEquals((long)4L, (long)models.length);
            StackedEnsembleModel.StackedEnsembleParameters seParams = new StackedEnsembleModel.StackedEnsembleParameters();
            seParams._distribution = DistributionFamily.bernoulli;
            seParams._train = train._key;
            seParams._blending = blend._key;
            seParams._response_column = target;
            seParams._base_models = grid.getModelKeys();
            seParams._seed = seed;
            seParams._keep_base_model_predictions = false;
            StackedEnsemble seJob = new StackedEnsemble(seParams);
            StackedEnsembleModel seModel = (StackedEnsembleModel)seJob.trainModel().get();
            seModels.add(seModel);
            Assert.assertNull((Object)((StackedEnsembleModel.StackedEnsembleOutput)seModel._output)._base_model_predictions_keys);
            seParams._keep_base_model_predictions = true;
            seJob = new StackedEnsemble(seParams);
            seModel = (StackedEnsembleModel)seJob.trainModel().get();
            seModels.add(seModel);
            Assert.assertNotNull((Object)((StackedEnsembleModel.StackedEnsembleOutput)seModel._output)._base_model_predictions_keys);
            Assert.assertEquals((long)models.length, (long)((StackedEnsembleModel.StackedEnsembleOutput)seModel._output)._base_model_predictions_keys.length);
            for (Key key : first_se_pred_keys = ((StackedEnsembleModel.StackedEnsembleOutput)seModel._output)._base_model_predictions_keys) {
                Assert.assertNotNull((String)"prediction key is not stored in DKV", (Object)DKV.get((Key)key));
            }
            seParams._keep_base_model_predictions = true;
            seJob = new StackedEnsemble(seParams);
            seModel = (StackedEnsembleModel)seJob.trainModel().get();
            seModels.add(seModel);
            Assert.assertNotNull((Object)((StackedEnsembleModel.StackedEnsembleOutput)seModel._output)._base_model_predictions_keys);
            Assert.assertEquals((long)models.length, (long)((StackedEnsembleModel.StackedEnsembleOutput)seModel._output)._base_model_predictions_keys.length);
            Assert.assertArrayEquals((Object[])first_se_pred_keys, (Object[])((StackedEnsembleModel.StackedEnsembleOutput)seModel._output)._base_model_predictions_keys);
            seParams._keep_base_model_predictions = true;
            seParams._valid = valid._key;
            seJob = new StackedEnsemble(seParams);
            seModel = (StackedEnsembleModel)seJob.trainModel().get();
            seModels.add(seModel);
            Assert.assertNotNull((Object)((StackedEnsembleModel.StackedEnsembleOutput)seModel._output)._base_model_predictions_keys);
            Assert.assertEquals((long)(models.length * 2), (long)((StackedEnsembleModel.StackedEnsembleOutput)seModel._output)._base_model_predictions_keys.length);
            for (Object object : first_se_pred_keys) {
                Assert.assertTrue((boolean)ArrayUtils.contains((Object[])((StackedEnsembleModel.StackedEnsembleOutput)seModel._output)._base_model_predictions_keys, (Object)object));
            }
            seModel.deleteBaseModelPredictions();
            Assert.assertNull((Object)((StackedEnsembleModel.StackedEnsembleOutput)seModel._output)._base_model_predictions_keys);
            for (Object object : first_se_pred_keys) {
                Assert.assertNull((Object)DKV.get((Key)object));
            }
        }
        finally {
            Scope.exit((Key[])new Key[0]);
            if (grid != null) {
                grid.delete();
            }
            for (Model model : seModels) {
                model.delete();
            }
            for (Frame frame : frames) {
                frame.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_SE_scoring_with_blending() {
        ArrayList<Object> deletables = new ArrayList<Object>();
        try {
            int seed = 62832;
            Frame frame = StackedEnsembleTest.parse_test_file((String)"./smalldata/logreg/prostate_train.csv");
            deletables.add(frame);
            Frame test = StackedEnsembleTest.parse_test_file((String)"./smalldata/logreg/prostate_test.csv");
            deletables.add(test);
            String target = "CAPSULE";
            int tidx = frame.find("CAPSULE");
            frame.replace(tidx, frame.vec(tidx).toCategoricalVec()).remove();
            DKV.put((Keyed)frame);
            test.replace(tidx, test.vec(tidx).toCategoricalVec()).remove();
            DKV.put((Keyed)test);
            SplitFrame sf = new SplitFrame(frame, new double[]{0.7, 0.3}, null);
            sf.exec().get();
            Key[] ksplits = sf._destination_frames;
            Frame train = (Frame)ksplits[0].get();
            deletables.add(train);
            Frame blending = (Frame)ksplits[1].get();
            deletables.add(blending);
            GBMModel.GBMParameters params = new GBMModel.GBMParameters();
            params._train = train._key;
            params._response_column = "CAPSULE";
            params._seed = 62832L;
            Job gridSearch = GridSearch.startGridSearch(null, (Model.Parameters)params, (Map)new HashMap<String, Object[]>(){
                {
                    this.put("_ntrees", new Integer[]{3, 5});
                    this.put("_learn_rate", new Double[]{0.1, 0.2});
                }
            });
            Grid grid = (Grid)gridSearch.get();
            deletables.add(grid);
            Model[] gridModels = grid.getModels();
            deletables.addAll(Arrays.asList(gridModels));
            Assert.assertEquals((long)4L, (long)gridModels.length);
            StackedEnsembleModel.StackedEnsembleParameters seParams = new StackedEnsembleModel.StackedEnsembleParameters();
            seParams._train = train._key;
            seParams._blending = blending._key;
            seParams._response_column = "CAPSULE";
            seParams._base_models = grid.getModelKeys();
            seParams._seed = 62832L;
            StackedEnsembleModel se = (StackedEnsembleModel)new StackedEnsemble(seParams).trainModel().get();
            deletables.add(se);
            Frame predictions = se.score(test);
            deletables.add(predictions);
            Assert.assertEquals((long)3L, (long)predictions.numCols());
            Assert.assertEquals((long)test.numRows(), (long)predictions.numRows());
        }
        finally {
            for (Lockable lockable : deletables) {
                if (lockable instanceof Model) {
                    ((Model)lockable).deleteCrossValidationPreds();
                }
                lockable.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_SE_with_GLM_can_do_predictions_on_frames_with_unseen_categorical_values() {
        ArrayList<Object> deletables = new ArrayList<Object>();
        try {
            int seed = 62832;
            Frame frame = StackedEnsembleTest.parse_test_file((String)"./smalldata/testng/cars_train.csv");
            deletables.add(frame);
            Frame test = StackedEnsembleTest.parse_test_file((String)"./smalldata/testng/cars_test.csv");
            deletables.add(test);
            String target = "economy (mpg)";
            int cyl_idx = test.find("cylinders");
            Assert.assertTrue((boolean)test.vec(cyl_idx).isInt());
            Vec cyl_test = test.vec(cyl_idx);
            cyl_test.set(cyl_test.length() - 1L, 7L);
            test.replace(cyl_idx, cyl_test.toCategoricalVec()).remove();
            DKV.put((Keyed)test);
            Assert.assertTrue((boolean)test.vec(cyl_idx).isCategorical());
            frame.replace(cyl_idx, frame.vec(cyl_idx).toCategoricalVec()).remove();
            DKV.put((Keyed)frame);
            GBMModel.GBMParameters params = new GBMModel.GBMParameters();
            params._train = frame._key;
            params._response_column = "economy (mpg)";
            params._seed = 62832L;
            params._keep_cross_validation_models = false;
            params._keep_cross_validation_predictions = true;
            params._fold_assignment = Model.Parameters.FoldAssignmentScheme.Modulo;
            params._nfolds = 5;
            Job gridSearch = GridSearch.startGridSearch(null, (Model.Parameters)params, (Map)new HashMap<String, Object[]>(){
                {
                    this.put("_ntrees", new Integer[]{3, 5});
                    this.put("_learn_rate", new Double[]{0.1, 0.2});
                }
            });
            Grid grid = (Grid)gridSearch.get();
            deletables.add(grid);
            Model[] gridModels = grid.getModels();
            deletables.addAll(Arrays.asList(gridModels));
            Assert.assertEquals((long)4L, (long)gridModels.length);
            GLMModel.GLMParameters glm_params = new GLMModel.GLMParameters();
            glm_params._train = frame._key;
            glm_params._response_column = "economy (mpg)";
            glm_params._seed = 62832L;
            glm_params._keep_cross_validation_models = false;
            glm_params._keep_cross_validation_predictions = true;
            glm_params._fold_assignment = Model.Parameters.FoldAssignmentScheme.Modulo;
            glm_params._nfolds = 5;
            glm_params._alpha = new double[]{0.1, 0.2, 0.4};
            glm_params._lambda_search = true;
            GLMModel glm = (GLMModel)new GLM(glm_params).trainModel().get();
            deletables.add(glm);
            StackedEnsembleModel.StackedEnsembleParameters seParams = new StackedEnsembleModel.StackedEnsembleParameters();
            seParams._train = frame._key;
            seParams._response_column = "economy (mpg)";
            seParams._base_models = (Key[])ArrayUtils.append((Object[])grid.getModelKeys(), (Object[])new Key[]{glm._key});
            seParams._seed = 62832L;
            StackedEnsembleModel se = (StackedEnsembleModel)new StackedEnsemble(seParams).trainModel().get();
            deletables.add(se);
            Frame predictions = se.score(test);
            deletables.add(predictions);
            Assert.assertTrue((predictions.vec(0).at(cyl_test.length() - 1L) > 0.0 ? 1 : 0) != 0);
        }
        finally {
            for (Lockable lockable : deletables) {
                if (lockable instanceof Model) {
                    ((Model)lockable).deleteCrossValidationPreds();
                }
                lockable.delete();
            }
        }
    }

    @Test
    public void testKeepLevelOneFrameCVMode() {
        this.testSEModelCanBeSafelyRemoved(true, false);
    }

    @Test
    public void testDoNotKeepLevelOneFrameCVMode() {
        this.testSEModelCanBeSafelyRemoved(false, false);
    }

    @Test
    public void testKeepLevelOneFrameBlendingMode() {
        this.testSEModelCanBeSafelyRemoved(true, true);
    }

    @Test
    public void testDoNotKeepLevelOneFrameBlendingMode() {
        this.testSEModelCanBeSafelyRemoved(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSEModelCanBeSafelyRemoved(boolean keepLevelOneFrame, boolean blending) {
        ArrayList<Object> deletables = new ArrayList<Object>();
        try {
            boolean seed = true;
            Frame frame = StackedEnsembleTest.parse_test_file((String)"./smalldata/logreg/prostate_train.csv");
            deletables.add(frame);
            Frame test = StackedEnsembleTest.parse_test_file((String)"./smalldata/logreg/prostate_test.csv");
            deletables.add(test);
            String target = "CAPSULE";
            int tidx = frame.find("CAPSULE");
            frame.replace(tidx, frame.vec(tidx).toCategoricalVec()).remove();
            DKV.put((Keyed)frame);
            test.replace(tidx, test.vec(tidx).toCategoricalVec()).remove();
            DKV.put((Keyed)test);
            GBMModel.GBMParameters params = new GBMModel.GBMParameters();
            params._train = frame._key;
            params._response_column = "CAPSULE";
            params._seed = 1L;
            if (!blending) {
                params._nfolds = 3;
                params._keep_cross_validation_models = false;
                params._keep_cross_validation_predictions = true;
                params._fold_assignment = Model.Parameters.FoldAssignmentScheme.Modulo;
            }
            Job gridSearch = GridSearch.startGridSearch(null, (Model.Parameters)params, (Map)new HashMap<String, Object[]>(){
                {
                    this.put("_ntrees", new Integer[]{3, 5});
                    this.put("_learn_rate", new Double[]{0.1, 0.2});
                }
            });
            Grid grid = (Grid)gridSearch.get();
            deletables.add(grid);
            Model[] gridModels = grid.getModels();
            deletables.addAll(Arrays.asList(gridModels));
            Assert.assertEquals((long)4L, (long)gridModels.length);
            StackedEnsembleModel.StackedEnsembleParameters seParams = new StackedEnsembleModel.StackedEnsembleParameters();
            seParams._train = frame._key;
            seParams._response_column = "CAPSULE";
            seParams._base_models = grid.getModelKeys();
            seParams._seed = 1L;
            seParams._keep_levelone_frame = keepLevelOneFrame;
            if (blending) {
                seParams._blending = test._key;
            }
            StackedEnsembleModel se1 = (StackedEnsembleModel)new StackedEnsemble(seParams).trainModel().get();
            deletables.add(se1);
            Frame predictions = se1.score(test);
            deletables.add(predictions);
            if (keepLevelOneFrame) {
                Assert.assertEquals((long)(gridModels.length + 1), (long)((StackedEnsembleModel.StackedEnsembleOutput)se1._output)._levelone_frame_id.numCols());
                if (blending) {
                    Assert.assertEquals((long)test.numRows(), (long)((StackedEnsembleModel.StackedEnsembleOutput)se1._output)._levelone_frame_id.numRows());
                    TestUtil.assertBitIdentical((Frame)new Frame(new Vec[]{test.vec("CAPSULE")}), (Frame)new Frame(new Vec[]{((StackedEnsembleModel.StackedEnsembleOutput)se1._output)._levelone_frame_id.vec("CAPSULE")}));
                } else {
                    Assert.assertEquals((long)frame.numRows(), (long)((StackedEnsembleModel.StackedEnsembleOutput)se1._output)._levelone_frame_id.numRows());
                    TestUtil.assertBitIdentical((Frame)new Frame(new Vec[]{frame.vec("CAPSULE")}), (Frame)new Frame(new Vec[]{((StackedEnsembleModel.StackedEnsembleOutput)se1._output)._levelone_frame_id.vec("CAPSULE")}));
                }
            } else {
                Assert.assertNull((Object)((StackedEnsembleModel.StackedEnsembleOutput)se1._output)._levelone_frame_id);
            }
            se1.delete();
            GBMModel gbm = (GBMModel)new GBM(params).trainModel().get();
            deletables.add(gbm);
            StackedEnsembleModel se2 = (StackedEnsembleModel)new StackedEnsemble(seParams).trainModel().get();
            deletables.add(se2);
        }
        finally {
            for (Lockable lockable : deletables) {
                if (lockable instanceof Model) {
                    ((Model)lockable).deleteCrossValidationPreds();
                }
                lockable.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StackedEnsembleModel.StackedEnsembleOutput basicEnsemble(String training_file, String validation_file, PrepData prep, boolean dupeTrainingFrameToValidationFrame, DistributionFamily family, Metalearner.Algorithm metalearner_algo, boolean blending_mode) {
        StackedEnsembleModel.StackedEnsembleOutput stackedEnsembleOutput;
        Frame preds;
        Frame blending_frame;
        Frame validation_frame;
        StackedEnsembleModel stackedEnsembleModel;
        DRFModel drf;
        GBMModel gbm;
        HashSet<Frame> framesBefore;
        block33: {
            framesBefore = new HashSet<Frame>();
            framesBefore.addAll(Arrays.asList(Frame.fetchAll()));
            gbm = null;
            drf = null;
            stackedEnsembleModel = null;
            Frame training_frame = null;
            validation_frame = null;
            blending_frame = null;
            preds = null;
            long seed = 1764L;
            try {
                Scope.enter();
                training_frame = StackedEnsembleTest.parse_test_file((String)training_file);
                if (null != validation_file) {
                    validation_frame = StackedEnsembleTest.parse_test_file((String)validation_file);
                }
                int idx = prep.prep(training_frame);
                if (null != validation_frame) {
                    prep.prep(validation_frame);
                }
                if (blending_mode) {
                    Frame[] splits = ShuffleSplitFrame.shuffleSplitFrame((Frame)training_frame, (Key[])new Key[]{Key.make((String)(training_frame._key + "_train")), Key.make((String)(training_frame._key + "_blending"))}, (double[])new double[]{0.6, 0.4}, (long)seed);
                    training_frame.remove();
                    training_frame = splits[0];
                    blending_frame = splits[1];
                }
                if (!(family != DistributionFamily.bernoulli && family != DistributionFamily.multinomial && family != DistributionFamily.modified_huber || training_frame.vecs()[idx].isCategorical())) {
                    Scope.track((Vec)training_frame.replace(idx, training_frame.vecs()[idx].toCategoricalVec()));
                    if (null != validation_frame) {
                        Scope.track((Vec)validation_frame.replace(idx, validation_frame.vecs()[idx].toCategoricalVec()));
                    }
                    if (null != blending_frame) {
                        Scope.track((Vec)blending_frame.replace(idx, blending_frame.vecs()[idx].toCategoricalVec()));
                    }
                }
                DKV.put((Keyed)training_frame);
                if (null != validation_frame) {
                    DKV.put((Keyed)validation_frame);
                }
                if (null != blending_frame) {
                    DKV.put(blending_frame);
                }
                GBMModel.GBMParameters gbmParameters = new GBMModel.GBMParameters();
                if (idx < 0) {
                    idx ^= 0xFFFFFFFF;
                }
                gbmParameters._train = training_frame._key;
                gbmParameters._valid = validation_frame == null ? null : validation_frame._key;
                gbmParameters._response_column = training_frame._names[idx];
                gbmParameters._ntrees = 5;
                gbmParameters._distribution = family;
                gbmParameters._max_depth = 4;
                gbmParameters._min_rows = 1.0;
                gbmParameters._nbins = 50;
                gbmParameters._learn_rate = 0.2f;
                gbmParameters._score_each_iteration = true;
                gbmParameters._fold_assignment = Model.Parameters.FoldAssignmentScheme.Modulo;
                gbmParameters._keep_cross_validation_predictions = true;
                gbmParameters._nfolds = 5;
                gbmParameters._seed = seed;
                if (dupeTrainingFrameToValidationFrame) {
                    validation_frame = new Frame(training_frame);
                    DKV.put((Keyed)validation_frame);
                    gbmParameters._valid = validation_frame._key;
                }
                GBM gbmJob = new GBM(gbmParameters);
                gbm = (GBMModel)gbmJob.trainModel().get();
                Assert.assertTrue((boolean)gbmJob.isStopped());
                DRFModel.DRFParameters drfParameters = new DRFModel.DRFParameters();
                drfParameters._train = training_frame._key;
                drfParameters._valid = validation_frame == null ? null : validation_frame._key;
                drfParameters._response_column = training_frame._names[idx];
                drfParameters._distribution = family;
                drfParameters._ntrees = 5;
                drfParameters._max_depth = 4;
                drfParameters._min_rows = 1.0;
                drfParameters._nbins = 50;
                drfParameters._score_each_iteration = true;
                drfParameters._seed = seed;
                if (!blending_mode) {
                    drfParameters._fold_assignment = Model.Parameters.FoldAssignmentScheme.Modulo;
                    drfParameters._keep_cross_validation_predictions = true;
                    drfParameters._nfolds = 5;
                }
                DRF drfJob = new DRF(drfParameters);
                drf = (DRFModel)drfJob.trainModel().get();
                Assert.assertTrue((boolean)drfJob.isStopped());
                StackedEnsembleModel.StackedEnsembleParameters stackedEnsembleParameters = new StackedEnsembleModel.StackedEnsembleParameters();
                stackedEnsembleParameters._train = training_frame._key;
                stackedEnsembleParameters._valid = validation_frame == null ? null : validation_frame._key;
                stackedEnsembleParameters._blending = blending_frame == null ? null : blending_frame._key;
                stackedEnsembleParameters._response_column = training_frame._names[idx];
                stackedEnsembleParameters._metalearner_algorithm = metalearner_algo;
                stackedEnsembleParameters._base_models = new Key[]{gbm._key, drf._key};
                stackedEnsembleParameters._seed = seed;
                StackedEnsemble stackedEnsembleJob = new StackedEnsemble(stackedEnsembleParameters);
                stackedEnsembleModel = (StackedEnsembleModel)stackedEnsembleJob.trainModel().get();
                Frame training_clone = new Frame(training_frame);
                DKV.put((Keyed)training_clone);
                preds = stackedEnsembleModel.score(training_clone);
                boolean predsTheSame = stackedEnsembleModel.testJavaScoring(training_clone, preds, 1.0E-15, 0.01);
                Assert.assertTrue((boolean)predsTheSame);
                Assert.assertTrue((boolean)stackedEnsembleJob.isStopped());
                ModelMetrics training_metrics = ((StackedEnsembleModel.StackedEnsembleOutput)stackedEnsembleModel._output)._training_metrics;
                ModelMetrics training_clone_metrics = ModelMetrics.getFromDKV((Model)stackedEnsembleModel, (Frame)training_clone);
                Assert.assertEquals((double)training_metrics.mse(), (double)training_clone_metrics.mse(), (double)1.0E-15);
                training_clone.remove();
                if (validation_frame != null) {
                    ModelMetrics validation_metrics = ((StackedEnsembleModel.StackedEnsembleOutput)stackedEnsembleModel._output)._validation_metrics;
                    Key[] validation_clone = new Frame(validation_frame);
                    DKV.put((Keyed)validation_clone);
                    stackedEnsembleModel.score((Frame)validation_clone).remove();
                    ModelMetrics validation_clone_metrics = ModelMetrics.getFromDKV((Model)stackedEnsembleModel, (Frame)validation_clone);
                    Assert.assertEquals((double)validation_metrics.mse(), (double)validation_clone_metrics.mse(), (double)1.0E-15);
                    validation_clone.remove();
                }
                stackedEnsembleOutput = (StackedEnsembleModel.StackedEnsembleOutput)stackedEnsembleModel._output;
                if (training_frame == null) break block33;
            }
            catch (Throwable throwable) {
                if (training_frame != null) {
                    training_frame.remove();
                }
                if (validation_frame != null) {
                    validation_frame.remove();
                }
                if (blending_frame != null) {
                    blending_frame.remove();
                }
                if (gbm != null) {
                    gbm.delete();
                    for (Key k : ((GBMModel.GBMOutput)gbm._output)._cross_validation_predictions) {
                        k.remove();
                    }
                    ((GBMModel.GBMOutput)gbm._output)._cross_validation_holdout_predictions_frame_id.remove();
                    gbm.deleteCrossValidationModels();
                }
                if (drf != null) {
                    drf.delete();
                    if (!blending_mode) {
                        for (Key k : ((DRFModel.DRFOutput)drf._output)._cross_validation_predictions) {
                            k.remove();
                        }
                        ((DRFModel.DRFOutput)drf._output)._cross_validation_holdout_predictions_frame_id.remove();
                        drf.deleteCrossValidationModels();
                    }
                }
                if (preds != null) {
                    preds.delete();
                }
                HashSet framesAfter = new HashSet(framesBefore);
                framesAfter.removeAll(Arrays.asList(Frame.fetchAll()));
                Assert.assertEquals((String)("finish with the same number of Frames as we started: " + framesAfter), (long)0L, (long)framesAfter.size());
                if (stackedEnsembleModel != null) {
                    stackedEnsembleModel.delete();
                    ((StackedEnsembleModel.StackedEnsembleOutput)stackedEnsembleModel._output)._metalearner.delete();
                }
                Scope.exit((Key[])new Key[0]);
                throw throwable;
            }
            training_frame.remove();
        }
        if (validation_frame != null) {
            validation_frame.remove();
        }
        if (blending_frame != null) {
            blending_frame.remove();
        }
        if (gbm != null) {
            gbm.delete();
            for (Key k : ((GBMModel.GBMOutput)gbm._output)._cross_validation_predictions) {
                k.remove();
            }
            ((GBMModel.GBMOutput)gbm._output)._cross_validation_holdout_predictions_frame_id.remove();
            gbm.deleteCrossValidationModels();
        }
        if (drf != null) {
            drf.delete();
            if (!blending_mode) {
                for (Key k : ((DRFModel.DRFOutput)drf._output)._cross_validation_predictions) {
                    k.remove();
                }
                ((DRFModel.DRFOutput)drf._output)._cross_validation_holdout_predictions_frame_id.remove();
                drf.deleteCrossValidationModels();
            }
        }
        if (preds != null) {
            preds.delete();
        }
        HashSet framesAfter = new HashSet(framesBefore);
        framesAfter.removeAll(Arrays.asList(Frame.fetchAll()));
        Assert.assertEquals((String)("finish with the same number of Frames as we started: " + framesAfter), (long)0L, (long)framesAfter.size());
        if (stackedEnsembleModel != null) {
            stackedEnsembleModel.delete();
            ((StackedEnsembleModel.StackedEnsembleOutput)stackedEnsembleModel._output)._metalearner.delete();
        }
        Scope.exit((Key[])new Key[0]);
        return stackedEnsembleOutput;
    }

    @Test
    public void test_SE_scoring_with_missing_response_column() {
        for (Metalearner.Algorithm algo : Metalearner.Algorithm.values()) {
            try {
                this.test_SE_scoring_with_missing_response_column(algo);
            }
            catch (Exception e) {
                Log.err((Throwable)e);
                Assert.fail((String)("StackedEnsemble scoring failed with algo " + algo + ": " + e.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test_SE_scoring_with_missing_response_column(Metalearner.Algorithm algo) {
        ArrayList<Object> deletables = new ArrayList<Object>();
        try {
            boolean seed = true;
            Frame frame = StackedEnsembleTest.parse_test_file((String)"./smalldata/testng/prostate_train.csv");
            deletables.add(frame);
            Frame test = StackedEnsembleTest.parse_test_file((String)"./smalldata/testng/prostate_test.csv");
            deletables.add(test);
            String target = "CAPSULE";
            int target_idx = frame.find("CAPSULE");
            frame.replace(target_idx, frame.vec(target_idx).toCategoricalVec()).remove();
            DKV.put((Keyed)frame);
            test.remove(target_idx).remove();
            DKV.put((Keyed)test);
            GBMModel.GBMParameters params = new GBMModel.GBMParameters();
            params._train = frame._key;
            params._response_column = "CAPSULE";
            params._seed = 1L;
            params._keep_cross_validation_models = false;
            params._keep_cross_validation_predictions = true;
            params._fold_assignment = Model.Parameters.FoldAssignmentScheme.Modulo;
            params._nfolds = 5;
            Job gridSearch = GridSearch.startGridSearch(null, (Model.Parameters)params, (Map)new HashMap<String, Object[]>(){
                {
                    this.put("_ntrees", new Integer[]{3, 5});
                    this.put("_learn_rate", new Double[]{0.1, 0.2});
                }
            });
            Grid grid = (Grid)gridSearch.get();
            deletables.add(grid);
            Model[] gridModels = grid.getModels();
            deletables.addAll(Arrays.asList(gridModels));
            Assert.assertEquals((long)4L, (long)gridModels.length);
            GLMModel.GLMParameters glm_params = new GLMModel.GLMParameters();
            glm_params._train = frame._key;
            glm_params._response_column = "CAPSULE";
            glm_params._family = GLMModel.GLMParameters.Family.binomial;
            glm_params._seed = 1L;
            glm_params._keep_cross_validation_models = false;
            glm_params._keep_cross_validation_predictions = true;
            glm_params._fold_assignment = Model.Parameters.FoldAssignmentScheme.Modulo;
            glm_params._nfolds = 5;
            glm_params._alpha = new double[]{0.1, 0.2, 0.4};
            glm_params._lambda_search = true;
            GLMModel glm = (GLMModel)new GLM(glm_params).trainModel().get();
            deletables.add(glm);
            Frame glmPredictions = glm.score(test);
            deletables.add(glmPredictions);
            StackedEnsembleModel.StackedEnsembleParameters seParams = new StackedEnsembleModel.StackedEnsembleParameters();
            seParams._train = frame._key;
            seParams._response_column = "CAPSULE";
            seParams._base_models = (Key[])ArrayUtils.append((Object[])grid.getModelKeys(), (Object[])new Key[0]);
            seParams._metalearner_algorithm = algo;
            seParams._seed = 1L;
            StackedEnsembleModel se = (StackedEnsembleModel)new StackedEnsemble(seParams).trainModel().get();
            deletables.add(se);
            Frame predictions = se.score(test);
            deletables.add(predictions);
            List<Double> allowedResponses = Arrays.asList(0.0, 1.0);
            double lastPrediction = predictions.vec(0).at(test.vec(0).length() - 1L);
            Assert.assertTrue((allowedResponses.indexOf(lastPrediction) >= 0 ? 1 : 0) != 0);
        }
        finally {
            for (Lockable lockable : deletables) {
                if (lockable instanceof Model) {
                    ((Model)lockable).deleteCrossValidationPreds();
                }
                lockable.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMissingFoldColumn_trainingFrame() {
        GBMModel gbmModel = null;
        try {
            Scope.enter();
            Frame trainingFrame = TestUtil.parse_test_file((String)"./smalldata/iris/iris_wheader.csv");
            Scope.track((Frame[])new Frame[]{trainingFrame});
            Frame partialFrame = TestUtil.parse_test_file((String)"./smalldata/iris/iris_wheader.csv", (int[])new int[]{4});
            Scope.track((Frame[])new Frame[]{partialFrame});
            GBMModel.GBMParameters parameters = new GBMModel.GBMParameters();
            parameters._train = trainingFrame._key;
            parameters._fold_column = "class";
            parameters._seed = 65261L;
            parameters._response_column = "petal_len";
            parameters._ntrees = 1;
            parameters._keep_cross_validation_predictions = true;
            GBM gbm = new GBM(parameters);
            gbmModel = (GBMModel)gbm.trainModel().get();
            Assert.assertNotNull((Object)gbmModel);
            StackedEnsembleModel.StackedEnsembleParameters seParams = new StackedEnsembleModel.StackedEnsembleParameters();
            seParams._train = partialFrame._key;
            seParams._response_column = "petal_len";
            seParams._metalearner_algorithm = Metalearner.Algorithm.AUTO;
            seParams._base_models = new Key[]{gbmModel._key};
            seParams._seed = 65261L;
            seParams._metalearner_fold_column = "class";
            this.expectedException.expect(IllegalArgumentException.class);
            this.expectedException.expectMessage("Specified fold column 'class' not found in one of the supplied data frames. Available column names are: [sepal_len, sepal_wid, petal_wid, petal_len]");
            StackedEnsemble stackedEnsemble = new StackedEnsemble(seParams);
            Assert.fail((String)"Expected the Stack Ensemble Model never to be initialized successfully.");
        }
        finally {
            Scope.exit((Key[])new Key[0]);
            if (gbmModel != null) {
                gbmModel.deleteCrossValidationModels();
                gbmModel.deleteCrossValidationPreds();
                gbmModel.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMissingFoldColumn_validationFrame() {
        GBMModel gbmModel = null;
        try {
            Scope.enter();
            Frame trainingFrame = TestUtil.parse_test_file((String)"./smalldata/iris/iris_wheader.csv");
            Scope.track((Frame[])new Frame[]{trainingFrame});
            Frame partialFrame = TestUtil.parse_test_file((String)"./smalldata/iris/iris_wheader.csv", (int[])new int[]{4});
            Scope.track((Frame[])new Frame[]{partialFrame});
            GBMModel.GBMParameters parameters = new GBMModel.GBMParameters();
            parameters._train = trainingFrame._key;
            parameters._valid = trainingFrame._key;
            parameters._fold_column = "class";
            parameters._seed = 65261L;
            parameters._response_column = "petal_len";
            parameters._ntrees = 1;
            parameters._keep_cross_validation_predictions = true;
            GBM gbm = new GBM(parameters);
            gbmModel = (GBMModel)gbm.trainModel().get();
            Assert.assertNotNull((Object)gbmModel);
            StackedEnsembleModel.StackedEnsembleParameters seParams = new StackedEnsembleModel.StackedEnsembleParameters();
            seParams._train = trainingFrame._key;
            seParams._valid = partialFrame._key;
            seParams._response_column = "petal_len";
            seParams._metalearner_algorithm = Metalearner.Algorithm.AUTO;
            seParams._base_models = new Key[]{gbmModel._key};
            seParams._seed = 65261L;
            seParams._metalearner_fold_column = "class";
            this.expectedException.expect(IllegalArgumentException.class);
            this.expectedException.expectMessage("Specified fold column 'class' not found in one of the supplied data frames. Available column names are: [sepal_len, sepal_wid, petal_len, petal_wid]");
            StackedEnsemble stackedEnsemble = new StackedEnsemble(seParams);
            Assert.fail((String)"Expected the Stack Ensemble Model never to be initialized successfully.");
        }
        finally {
            Scope.exit((Key[])new Key[0]);
            if (gbmModel != null) {
                gbmModel.deleteCrossValidationModels();
                gbmModel.deleteCrossValidationPreds();
                gbmModel.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMissingFoldColumn_blendingFrame() {
        GBMModel gbmModel = null;
        try {
            Scope.enter();
            Frame trainingFrame = TestUtil.parse_test_file((String)"./smalldata/iris/iris_wheader.csv");
            Scope.track((Frame[])new Frame[]{trainingFrame});
            Frame partialFrame = TestUtil.parse_test_file((String)"./smalldata/iris/iris_wheader.csv", (int[])new int[]{4});
            Scope.track((Frame[])new Frame[]{partialFrame});
            GBMModel.GBMParameters parameters = new GBMModel.GBMParameters();
            parameters._train = trainingFrame._key;
            parameters._fold_column = "class";
            parameters._seed = 65261L;
            parameters._response_column = "petal_len";
            parameters._ntrees = 1;
            parameters._keep_cross_validation_predictions = true;
            GBM gbm = new GBM(parameters);
            gbmModel = (GBMModel)gbm.trainModel().get();
            Assert.assertNotNull((Object)gbmModel);
            StackedEnsembleModel.StackedEnsembleParameters seParams = new StackedEnsembleModel.StackedEnsembleParameters();
            seParams._train = trainingFrame._key;
            seParams._blending = partialFrame._key;
            seParams._response_column = "petal_len";
            seParams._metalearner_algorithm = Metalearner.Algorithm.AUTO;
            seParams._base_models = new Key[]{gbmModel._key};
            seParams._seed = 65261L;
            seParams._metalearner_fold_column = "class";
            this.expectedException.expect(IllegalArgumentException.class);
            this.expectedException.expectMessage("Specified fold column 'class' not found in one of the supplied data frames. Available column names are: [sepal_len, sepal_wid, petal_len, petal_wid]");
            StackedEnsemble stackedEnsemble = new StackedEnsemble(seParams);
            Assert.fail((String)"Expected the Stack Ensemble Model never to be initialized successfully.");
        }
        finally {
            Scope.exit((Key[])new Key[0]);
            if (gbmModel != null) {
                gbmModel.deleteCrossValidationModels();
                gbmModel.deleteCrossValidationPreds();
                gbmModel.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidFoldColumn_trainingFrame() {
        GBMModel gbmModel = null;
        try {
            Scope.enter();
            Frame trainingFrame = TestUtil.parse_test_file((String)"./smalldata/iris/iris_wheader.csv");
            Scope.track((Frame[])new Frame[]{trainingFrame});
            GBMModel.GBMParameters parameters = new GBMModel.GBMParameters();
            parameters._train = trainingFrame._key;
            parameters._fold_column = "class";
            parameters._seed = 65261L;
            parameters._response_column = "petal_len";
            parameters._ntrees = 1;
            parameters._keep_cross_validation_predictions = true;
            GBM gbm = new GBM(parameters);
            gbmModel = (GBMModel)gbm.trainModel().get();
            Assert.assertNotNull((Object)gbmModel);
            Frame seTrain = new Frame(Key.make(), trainingFrame.names(), trainingFrame.vecs());
            Vec foldVec = seTrain.remove("class");
            seTrain.add("class", foldVec.toStringVec());
            DKV.put((Keyed)seTrain);
            Scope.track((Frame[])new Frame[]{seTrain});
            StackedEnsembleModel.StackedEnsembleParameters seParams = new StackedEnsembleModel.StackedEnsembleParameters();
            seParams._train = seTrain._key;
            seParams._response_column = "petal_len";
            seParams._metalearner_algorithm = Metalearner.Algorithm.AUTO;
            seParams._base_models = new Key[]{gbmModel._key};
            seParams._seed = 24301L;
            seParams._metalearner_fold_column = "class";
            this.expectedException.expect(IllegalArgumentException.class);
            this.expectedException.expectMessage("Specified fold column 'class' not found in one of the supplied data frames. Available column names are: [sepal_len, sepal_wid, petal_wid, petal_len]");
            new StackedEnsemble(seParams);
            Assert.fail((String)"Expected the Stack Ensemble Model never to be initialized successfully.");
        }
        finally {
            Scope.exit((Key[])new Key[0]);
            if (gbmModel != null) {
                gbmModel.deleteCrossValidationModels();
                gbmModel.deleteCrossValidationPreds();
                gbmModel.remove();
            }
        }
    }

    public static class Pubdev6157MRTask
    extends MRTask {
        private final int nclasses;

        Pubdev6157MRTask(int nclasses) {
            this.nclasses = nclasses;
        }

        public void map(Chunk[] cs, NewChunk[] ncs) {
            Random r = new Random();
            NewChunk predictor = ncs[0];
            NewChunk response = ncs[1];
            for (int i = 0; i < cs[0]._len; ++i) {
                long rowNum = cs[0].start() + (long)i;
                predictor.addNum(r.nextDouble());
                long respValue = rowNum % 2L == 0L ? (long)(this.nclasses - 1) : rowNum % (long)this.nclasses;
                response.addNum((double)respValue);
            }
        }
    }

    private abstract class PrepData {
        private PrepData() {
        }

        abstract int prep(Frame var1);
    }
}

