/*
 * Decompiled with CFR 0.152.
 */
package hex.deepwater;

import deepwater.backends.BackendModel;
import deepwater.backends.BackendParams;
import deepwater.backends.BackendTrain;
import deepwater.backends.RuntimeOptions;
import deepwater.datasets.ImageDataSet;
import hex.FrameSplitter;
import hex.Model;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsMultinomial;
import hex.deepwater.DeepWater;
import hex.deepwater.DeepWaterModel;
import hex.deepwater.DeepWaterModelInfo;
import hex.deepwater.DeepWaterModelOutput;
import hex.deepwater.DeepWaterParameters;
import hex.genmodel.algos.deepwater.DeepwaterMojoModel;
import hex.splitframe.ShuffleSplitFrame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import water.AutoBuffer;
import water.DKV;
import water.Freezable;
import water.Iced;
import water.IcedUtils;
import water.Job;
import water.Key;
import water.Keyed;
import water.Scope;
import water.TestUtil;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Frame;
import water.fvec.NFSFileVec;
import water.fvec.Vec;
import water.parser.ParseDataset;
import water.util.FileUtils;
import water.util.Log;
import water.util.StringUtils;
import water.util.TwoDimTable;

public abstract class DeepWaterAbstractIntegrationTest
extends TestUtil {
    protected BackendTrain backend;

    abstract DeepWaterParameters.Backend getBackend();

    @BeforeClass
    public static void stall() {
        DeepWaterAbstractIntegrationTest.stall_till_cloudsize((int)1);
    }

    @BeforeClass
    public static void checkBackend() {
        Assume.assumeTrue((boolean)DeepWater.haveBackend());
    }

    @Before
    public void createBackend() throws Exception {
        this.backend = DeepwaterMojoModel.createDeepWaterBackend((String)this.getBackend().toString());
        Assert.assertTrue((this.backend != null ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void memoryLeakTest() {
        DeepWaterModel m = null;
        Frame tr = null;
        int counter = 3;
        while (counter-- > 0) {
            try {
                DeepWaterParameters p = new DeepWaterParameters();
                p._backend = this.getBackend();
                tr = DeepWaterAbstractIntegrationTest.parse_test_file((String)"bigdata/laptop/deepwater/imagenet/cat_dog_mouse.csv");
                p._train = tr._key;
                p._response_column = "C2";
                p._network = DeepWaterParameters.Network.vgg;
                p._learning_rate = 1.0E-4;
                p._mini_batch_size = 8;
                p._train_samples_per_iteration = 8L;
                p._epochs = 0.001;
                m = (DeepWaterModel)new DeepWater(p).trainModel().get();
                Log.info((Object[])new Object[]{m});
            }
            finally {
                if (m != null) {
                    m.delete();
                }
                if (tr == null) continue;
                tr.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void trainSamplesPerIteration(int samples, int expected) {
        DeepWaterModel m = null;
        Frame tr = null;
        try {
            DeepWaterParameters p = new DeepWaterParameters();
            p._backend = this.getBackend();
            tr = DeepWaterAbstractIntegrationTest.parse_test_file((String)"bigdata/laptop/deepwater/imagenet/cat_dog_mouse.csv");
            p._train = tr._key;
            p._response_column = "C2";
            p._learning_rate = 0.001;
            p._epochs = 3.0;
            p._train_samples_per_iteration = samples;
            m = (DeepWaterModel)new DeepWater(p).trainModel().get();
            Assert.assertEquals((long)expected, (long)m.iterations);
        }
        finally {
            if (m != null) {
                m.delete();
            }
            if (tr != null) {
                tr.remove();
            }
        }
    }

    @Test
    public void trainSamplesPerIteration0() {
        this.trainSamplesPerIteration(0, 3);
    }

    @Test
    public void trainSamplesPerIteration_auto() {
        this.trainSamplesPerIteration(-2, 1);
    }

    @Test
    public void trainSamplesPerIteration_neg1() {
        this.trainSamplesPerIteration(-1, 3);
    }

    @Test
    public void trainSamplesPerIteration_32() {
        this.trainSamplesPerIteration(32, 26);
    }

    @Test
    public void trainSamplesPerIteration_1000() {
        this.trainSamplesPerIteration(1000, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void overWriteWithBestModel() {
        DeepWaterModel m = null;
        Frame tr = null;
        try {
            DeepWaterParameters p = new DeepWaterParameters();
            p._backend = this.getBackend();
            tr = DeepWaterAbstractIntegrationTest.parse_test_file((String)"bigdata/laptop/deepwater/imagenet/cat_dog_mouse.csv");
            p._train = tr._key;
            p._response_column = "C2";
            p._epochs = 50.0;
            p._learning_rate = 0.01;
            p._momentum_start = 0.5;
            p._momentum_stable = 0.5;
            p._stopping_rounds = 0;
            p._image_shape = new int[]{28, 28};
            p._network = DeepWaterParameters.Network.lenet;
            p._problem_type = DeepWaterParameters.ProblemType.image;
            p._train_samples_per_iteration = p._mini_batch_size;
            p._score_duty_cycle = 1.0;
            p._score_interval = 0.0;
            p._overwrite_with_best_model = true;
            m = (DeepWaterModel)new DeepWater(p).trainModel().get();
            Log.info((Object[])new Object[]{m});
            Assert.assertTrue((((ModelMetricsMultinomial)((DeepWaterModelOutput)m._output)._training_metrics).logloss() < 2.0 ? 1 : 0) != 0);
        }
        finally {
            if (m != null) {
                m.remove();
            }
            if (tr != null) {
                tr.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkConvergence(int channels, DeepWaterParameters.Network network, int epochs) {
        DeepWaterModel m = null;
        Frame tr = null;
        try {
            DeepWaterParameters p = new DeepWaterParameters();
            p._backend = this.getBackend();
            tr = DeepWaterAbstractIntegrationTest.parse_test_file((String)"bigdata/laptop/deepwater/imagenet/cat_dog_mouse.csv");
            p._train = tr._key;
            p._response_column = "C2";
            p._network = network;
            p._learning_rate = 0.001;
            p._epochs = epochs;
            p._channels = channels;
            if (network == DeepWaterParameters.Network.vgg) {
                p._mini_batch_size = 8;
            } else if (network == DeepWaterParameters.Network.resnet) {
                p._mini_batch_size = 16;
                p._learning_rate = 1.0E-4;
            } else if (network == DeepWaterParameters.Network.alexnet) {
                p._mini_batch_size = 128;
                p._learning_rate = 1.0E-4;
            } else {
                p._mini_batch_size = 32;
            }
            p._problem_type = DeepWaterParameters.ProblemType.image;
            m = (DeepWaterModel)new DeepWater(p).trainModel().get();
            Log.info((Object[])new Object[]{m});
            System.out.println("Accuracy " + ((DeepWaterModelOutput)m._output)._training_metrics.cm().accuracy());
            Assert.assertTrue((((DeepWaterModelOutput)m._output)._training_metrics.cm().accuracy() > 0.9 ? 1 : 0) != 0);
        }
        finally {
            if (m != null) {
                m.delete();
            }
            if (tr != null) {
                tr.remove();
            }
        }
    }

    @Test
    public void convergenceInceptionColor() {
        this.checkConvergence(3, DeepWaterParameters.Network.inception_bn, 150);
    }

    @Test
    public void convergenceInceptionGrayScale() {
        this.checkConvergence(1, DeepWaterParameters.Network.inception_bn, 150);
    }

    @Test
    public void convergenceGoogleNetColor() {
        this.checkConvergence(3, DeepWaterParameters.Network.googlenet, 150);
    }

    @Test
    public void convergenceGoogleNetGrayScale() {
        this.checkConvergence(1, DeepWaterParameters.Network.googlenet, 150);
    }

    @Test
    public void convergenceLenetColor() {
        this.checkConvergence(3, DeepWaterParameters.Network.lenet, 300);
    }

    @Test
    public void convergenceLenetGrayScale() {
        this.checkConvergence(1, DeepWaterParameters.Network.lenet, 150);
    }

    @Test
    public void convergenceVGGColor() {
        this.checkConvergence(3, DeepWaterParameters.Network.vgg, 150);
    }

    @Test
    public void convergenceVGGGrayScale() {
        this.checkConvergence(1, DeepWaterParameters.Network.vgg, 150);
    }

    @Test
    public void convergenceResnetColor() {
        this.checkConvergence(3, DeepWaterParameters.Network.resnet, 150);
    }

    @Test
    public void convergenceResnetGrayScale() {
        this.checkConvergence(1, DeepWaterParameters.Network.resnet, 150);
    }

    @Test
    public void convergenceAlexnetColor() {
        this.checkConvergence(3, DeepWaterParameters.Network.alexnet, 150);
    }

    @Test
    public void convergenceAlexnetGrayScale() {
        this.checkConvergence(1, DeepWaterParameters.Network.alexnet, 150);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void reproInitialDistribution() {
        int i;
        int REPS = 3;
        double[] values = new double[3];
        for (i = 0; i < 3; ++i) {
            DeepWaterModel m = null;
            Frame tr = null;
            try {
                DeepWaterParameters p = new DeepWaterParameters();
                p._backend = this.getBackend();
                tr = DeepWaterAbstractIntegrationTest.parse_test_file((String)"bigdata/laptop/deepwater/imagenet/cat_dog_mouse.csv");
                p._train = tr._key;
                p._response_column = "C2";
                p._learning_rate = 0.0;
                p._seed = 1234L;
                p._epochs = 1.0;
                p._channels = 1;
                p._train_samples_per_iteration = 0L;
                m = (DeepWaterModel)new DeepWater(p).trainModel().get();
                Log.info((Object[])new Object[]{m});
                values[i] = ((ModelMetricsMultinomial)((DeepWaterModelOutput)m._output)._training_metrics).logloss();
                continue;
            }
            finally {
                if (m != null) {
                    m.delete();
                }
                if (tr != null) {
                    tr.remove();
                }
            }
        }
        for (i = 1; i < 3; ++i) {
            Assert.assertEquals((double)values[0], (double)values[i], (double)(1.0E-5 * values[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void reproInitialDistributionNegativeTest() {
        int i;
        int REPS = 3;
        double[] values = new double[3];
        for (i = 0; i < 3; ++i) {
            DeepWaterModel m = null;
            Frame tr = null;
            try {
                DeepWaterParameters p = new DeepWaterParameters();
                p._backend = this.getBackend();
                tr = DeepWaterAbstractIntegrationTest.parse_test_file((String)"bigdata/laptop/deepwater/imagenet/cat_dog_mouse.csv");
                p._train = tr._key;
                p._response_column = "C2";
                p._learning_rate = 0.0;
                p._seed = i;
                p._epochs = 1.0;
                p._channels = 1;
                p._train_samples_per_iteration = 0L;
                m = (DeepWaterModel)new DeepWater(p).trainModel().get();
                Log.info((Object[])new Object[]{m});
                values[i] = ((ModelMetricsMultinomial)((DeepWaterModelOutput)m._output)._training_metrics).logloss();
                continue;
            }
            finally {
                if (m != null) {
                    m.delete();
                }
                if (tr != null) {
                    tr.remove();
                }
            }
        }
        for (i = 1; i < 3; ++i) {
            Assert.assertNotEquals((double)values[0], (double)values[i], (double)(1.0E-5 * values[0]));
        }
    }

    @Ignore
    @Test
    public void settingModelInfoAll() {
        for (DeepWaterParameters.Network network : DeepWaterParameters.Network.values()) {
            if (network == DeepWaterParameters.Network.user || network == DeepWaterParameters.Network.auto) continue;
            this.settingModelInfo(network);
        }
    }

    @Test
    public void settingModelInfoAlexnet() {
        this.settingModelInfo(DeepWaterParameters.Network.alexnet);
    }

    @Test
    public void settingModelInfoLenet() {
        this.settingModelInfo(DeepWaterParameters.Network.lenet);
    }

    @Test
    public void settingModelInfoVGG() {
        this.settingModelInfo(DeepWaterParameters.Network.vgg);
    }

    @Test
    public void settingModelInfoInception() {
        this.settingModelInfo(DeepWaterParameters.Network.inception_bn);
    }

    @Test
    public void settingModelInfoResnet() {
        this.settingModelInfo(DeepWaterParameters.Network.resnet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void settingModelInfo(DeepWaterParameters.Network network) {
        DeepWaterModel m1 = null;
        DeepWaterModel m2 = null;
        Frame tr = null;
        try {
            DeepWaterParameters p = new DeepWaterParameters();
            p._backend = this.getBackend();
            tr = DeepWaterAbstractIntegrationTest.parse_test_file((String)"bigdata/laptop/deepwater/imagenet/cat_dog_mouse.csv");
            p._train = tr._key;
            p._response_column = "C2";
            p._network = network;
            p._mini_batch_size = 2;
            p._epochs = 0.01;
            p._seed = 1234L;
            p._score_training_samples = 0L;
            p._train_samples_per_iteration = p._mini_batch_size;
            p._problem_type = DeepWaterParameters.ProblemType.image;
            Job j1 = new DeepWater(p).trainModel();
            m1 = (DeepWaterModel)j1.get();
            int h1 = Arrays.hashCode(m1.model_info()._modelparams);
            m1.doScoring(tr, null, j1._key, m1.iterations, true);
            double l1 = m1.loss();
            p._seed = 4321L;
            Job j2 = new DeepWater(p).trainModel();
            m2 = (DeepWaterModel)j2.get();
            int h2 = Arrays.hashCode(m2.model_info()._modelparams);
            m2.removeNativeState();
            DeepWaterModelInfo mi = (DeepWaterModelInfo)IcedUtils.deepCopy((Iced)m1.model_info());
            m2.set_model_info(mi);
            m2.doScoring(tr, null, j2._key, m2.iterations, true);
            double l3 = m2.loss();
            int h3 = Arrays.hashCode(m2.model_info()._modelparams);
            Log.info((Object[])new Object[]{"Checking assertions for network: " + network});
            Assert.assertNotEquals((long)h1, (long)h2);
            Assert.assertEquals((long)h1, (long)h3);
            Assert.assertEquals((double)l1, (double)l3, (double)(1.0E-5 * l1));
        }
        finally {
            if (m1 != null) {
                m1.delete();
            }
            if (m2 != null) {
                m2.delete();
            }
            if (tr != null) {
                tr.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void reproTraining() {
        int i;
        int REPS = 3;
        double[] values = new double[3];
        for (i = 0; i < 3; ++i) {
            DeepWaterModel m = null;
            Frame tr = null;
            try {
                DeepWaterParameters p = new DeepWaterParameters();
                p._backend = this.getBackend();
                tr = DeepWaterAbstractIntegrationTest.parse_test_file((String)"bigdata/laptop/deepwater/imagenet/cat_dog_mouse.csv");
                p._train = tr._key;
                p._response_column = "C2";
                p._learning_rate = 1.0E-4;
                p._seed = 1234L;
                p._epochs = 1.0;
                p._channels = 1;
                p._train_samples_per_iteration = 0L;
                m = (DeepWaterModel)new DeepWater(p).trainModel().get();
                Log.info((Object[])new Object[]{m});
                values[i] = ((ModelMetricsMultinomial)((DeepWaterModelOutput)m._output)._training_metrics).logloss();
                continue;
            }
            finally {
                if (m != null) {
                    m.delete();
                }
                if (tr != null) {
                    tr.remove();
                }
            }
        }
        for (i = 1; i < 3; ++i) {
            Assert.assertEquals((double)values[0], (double)values[i], (double)(1.0E-5 * values[0]));
        }
    }

    @Ignore
    @Test
    public void deepWaterLoadSaveTestAll() {
        for (DeepWaterParameters.Network network : DeepWaterParameters.Network.values()) {
            if (network == DeepWaterParameters.Network.auto || network == DeepWaterParameters.Network.user) continue;
            this.deepWaterLoadSaveTest(network);
        }
    }

    @Test
    public void deepWaterLoadSaveTestAlexnet() {
        this.deepWaterLoadSaveTest(DeepWaterParameters.Network.alexnet);
    }

    @Test
    public void deepWaterLoadSaveTestLenet() {
        this.deepWaterLoadSaveTest(DeepWaterParameters.Network.lenet);
    }

    @Test
    public void deepWaterLoadSaveTestVGG() {
        this.deepWaterLoadSaveTest(DeepWaterParameters.Network.vgg);
    }

    @Test
    public void deepWaterLoadSaveTestInception() {
        this.deepWaterLoadSaveTest(DeepWaterParameters.Network.inception_bn);
    }

    @Test
    public void deepWaterLoadSaveTestResnet() {
        this.deepWaterLoadSaveTest(DeepWaterParameters.Network.resnet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deepWaterLoadSaveTest(DeepWaterParameters.Network network) {
        DeepWaterModel m = null;
        Frame tr = null;
        try {
            DeepWaterParameters p = new DeepWaterParameters();
            p._backend = this.getBackend();
            tr = DeepWaterAbstractIntegrationTest.parse_test_file((String)"bigdata/laptop/deepwater/imagenet/cat_dog_mouse.csv");
            p._train = tr._key;
            p._response_column = "C2";
            p._network = network;
            p._mini_batch_size = 2;
            p._epochs = 0.01;
            p._seed = 1234L;
            p._score_training_samples = 0L;
            p._train_samples_per_iteration = p._mini_batch_size;
            p._problem_type = DeepWaterParameters.ProblemType.image;
            m = (DeepWaterModel)new DeepWater(p).trainModel().get();
            Log.info((Object[])new Object[]{m});
            Assert.assertTrue((m.model_info()._backend == null ? 1 : 0) != 0);
            int hashCodeNetwork = Arrays.hashCode(m.model_info()._network);
            int hashCodeParams = Arrays.hashCode(m.model_info()._modelparams);
            Log.info((Object[])new Object[]{"Hash code for original network: " + hashCodeNetwork});
            Log.info((Object[])new Object[]{"Hash code for original parameters: " + hashCodeParams});
            m.removeNativeState();
            m.model_info().javaToNative();
            m.model_info().nativeToJava();
            int hashCodeNetwork2 = Arrays.hashCode(m.model_info()._network);
            int hashCodeParams2 = Arrays.hashCode(m.model_info()._modelparams);
            Log.info((Object[])new Object[]{"Hash code for restored network: " + hashCodeNetwork2});
            Log.info((Object[])new Object[]{"Hash code for restored parameters: " + hashCodeParams2});
            Assert.assertEquals((long)hashCodeNetwork, (long)hashCodeNetwork2);
            Assert.assertEquals((long)hashCodeParams, (long)hashCodeParams2);
        }
        finally {
            if (m != null) {
                m.delete();
            }
            if (tr != null) {
                tr.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void deepWaterCV() {
        DeepWaterModel m = null;
        Frame tr = null;
        Frame preds = null;
        try {
            DeepWaterParameters p = new DeepWaterParameters();
            p._backend = this.getBackend();
            tr = DeepWaterAbstractIntegrationTest.parse_test_file((String)"bigdata/laptop/deepwater/imagenet/cat_dog_mouse.csv");
            p._train = tr._key;
            p._response_column = "C2";
            p._network = DeepWaterParameters.Network.lenet;
            p._nfolds = 3;
            p._epochs = 2.0;
            m = (DeepWaterModel)new DeepWater(p).trainModel().get();
            preds = m.score((Frame)p._train.get());
            Assert.assertTrue((boolean)m.testJavaScoring((Frame)p._train.get(), preds, 0.001));
            Log.info((Object[])new Object[]{m});
        }
        finally {
            if (m != null) {
                m.deleteCrossValidationModels();
            }
            if (m != null) {
                m.delete();
            }
            if (tr != null) {
                tr.remove();
            }
            if (preds != null) {
                preds.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void deepWaterCVRegression() {
        DeepWaterModel m = null;
        Frame tr = null;
        Frame preds = null;
        try {
            DeepWaterParameters p = new DeepWaterParameters();
            p._backend = this.getBackend();
            tr = DeepWaterAbstractIntegrationTest.parse_test_file((String)"bigdata/laptop/deepwater/imagenet/cat_dog_mouse.csv");
            p._train = tr._key;
            p._response_column = "C2";
            for (String col : new String[]{p._response_column}) {
                Vec v = tr.remove(col);
                tr.add(col, v.toNumericVec());
                v.remove();
            }
            DKV.put((Keyed)tr);
            p._network = DeepWaterParameters.Network.lenet;
            p._nfolds = 3;
            p._epochs = 2.0;
            m = (DeepWaterModel)new DeepWater(p).trainModel().get();
            preds = m.score((Frame)p._train.get());
            Assert.assertTrue((boolean)m.testJavaScoring((Frame)p._train.get(), preds, 0.001));
            Log.info((Object[])new Object[]{m});
        }
        finally {
            if (m != null) {
                m.deleteCrossValidationModels();
            }
            if (m != null) {
                m.delete();
            }
            if (tr != null) {
                tr.remove();
            }
            if (preds != null) {
                preds.remove();
            }
        }
    }

    @Ignore
    @Test
    public void restoreStateAll() {
        for (DeepWaterParameters.Network network : DeepWaterParameters.Network.values()) {
            if (network == DeepWaterParameters.Network.user || network == DeepWaterParameters.Network.auto) continue;
            this.restoreState(network);
        }
    }

    @Test
    public void restoreStateAlexnet() {
        this.restoreState(DeepWaterParameters.Network.alexnet);
    }

    @Test
    public void restoreStateLenet() {
        this.restoreState(DeepWaterParameters.Network.lenet);
    }

    @Test
    public void restoreStateVGG() {
        this.restoreState(DeepWaterParameters.Network.vgg);
    }

    @Test
    public void restoreStateInception() {
        this.restoreState(DeepWaterParameters.Network.inception_bn);
    }

    @Test
    public void restoreStateResnet() {
        this.restoreState(DeepWaterParameters.Network.resnet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreState(DeepWaterParameters.Network network) {
        DeepWaterModel m1 = null;
        DeepWaterModel m2 = null;
        Frame tr = null;
        Frame pred = null;
        try {
            DeepWaterParameters p = new DeepWaterParameters();
            p._backend = this.getBackend();
            tr = DeepWaterAbstractIntegrationTest.parse_test_file((String)"bigdata/laptop/deepwater/imagenet/cat_dog_mouse.csv");
            p._train = tr._key;
            p._network = network;
            p._response_column = "C2";
            p._mini_batch_size = 2;
            p._train_samples_per_iteration = p._mini_batch_size;
            p._learning_rate = 0.0;
            p._seed = 12345L;
            p._epochs = 0.01;
            p._quiet_mode = true;
            p._problem_type = DeepWaterParameters.ProblemType.image;
            m1 = (DeepWaterModel)new DeepWater(p).trainModel().get();
            Log.info((Object[])new Object[]{"Scoring the original model."});
            pred = m1.score(tr);
            pred.remove(0).remove();
            ModelMetricsMultinomial mm1 = ModelMetricsMultinomial.make((Frame)pred, (Vec)tr.vec(p._response_column));
            Log.info((Object[])new Object[]{"Original LL: " + ((ModelMetricsMultinomial)((DeepWaterModelOutput)m1._output)._training_metrics).logloss()});
            Log.info((Object[])new Object[]{"Scored   LL: " + mm1.logloss()});
            pred.remove();
            Log.info((Object[])new Object[]{"Keeping the raw byte[] of the model."});
            byte[] raw = new AutoBuffer().put((Freezable)m1).buf();
            Log.info((Object[])new Object[]{"Removing the model from the DKV."});
            m1.remove();
            Log.info((Object[])new Object[]{"Restoring the model from the raw byte[]."});
            m2 = (DeepWaterModel)new AutoBuffer(raw).get();
            Log.info((Object[])new Object[]{"Scoring the restored model."});
            pred = m2.score(tr);
            pred.remove(0).remove();
            ModelMetricsMultinomial mm2 = ModelMetricsMultinomial.make((Frame)pred, (Vec)tr.vec(p._response_column));
            Log.info((Object[])new Object[]{"Restored LL: " + mm2.logloss()});
            double precision = 1.0E-5;
            Assert.assertEquals((double)((ModelMetricsMultinomial)((DeepWaterModelOutput)m1._output)._training_metrics).logloss(), (double)mm1.logloss(), (double)(precision * mm1.logloss()));
            Assert.assertEquals((double)mm1.logloss(), (double)mm2.logloss(), (double)(precision * mm1.logloss()));
        }
        finally {
            if (m1 != null) {
                m1.delete();
            }
            if (m2 != null) {
                m2.delete();
            }
            if (tr != null) {
                tr.remove();
            }
            if (pred != null) {
                pred.remove();
            }
        }
    }

    @Test
    public void trainLoop() throws InterruptedException {
        int batch_size = 64;
        BackendModel m = this.buildLENET();
        float[] data = new float[784 * batch_size];
        float[] labels = new float[batch_size];
        int count = 0;
        while (count++ < 1000) {
            Log.info((Object[])new Object[]{"Iteration: " + count});
            this.backend.train(m, data, labels);
        }
    }

    private BackendModel buildLENET() {
        int batch_size = 64;
        int classes = 10;
        ImageDataSet dataset = new ImageDataSet(28, 28, 1, classes);
        RuntimeOptions opts = new RuntimeOptions();
        opts.setUseGPU(true);
        opts.setSeed(1234L);
        opts.setDeviceID(new int[]{0});
        BackendParams bparm = new BackendParams();
        bparm.set("mini_batch_size", (Object)batch_size);
        return this.backend.buildNet(dataset, opts, bparm, classes, "lenet");
    }

    @Test
    public void saveLoop() throws IOException {
        BackendModel m = this.buildLENET();
        File f = File.createTempFile("saveLoop", ".tmp");
        for (int count = 0; count < 3; ++count) {
            Log.info((Object[])new Object[]{"Iteration: " + count});
            this.backend.saveParam(m, f.getAbsolutePath());
        }
        this.backend.deleteSavedParam(f.getAbsolutePath());
    }

    @Test
    public void predictLoop() {
        BackendModel m = this.buildLENET();
        int batch_size = 64;
        float[] data = new float[784 * batch_size];
        int count = 0;
        while (count++ < 3) {
            Log.info((Object[])new Object[]{"Iteration: " + count});
            this.backend.predict(m, data);
        }
    }

    @Test
    public void trainPredictLoop() {
        int batch_size = 64;
        BackendModel m = this.buildLENET();
        float[] data = new float[784 * batch_size];
        float[] labels = new float[batch_size];
        int count = 0;
        while (count++ < 1000) {
            Log.info((Object[])new Object[]{"Iteration: " + count});
            this.backend.train(m, data, labels);
            float[] fArray = this.backend.predict(m, data);
        }
    }

    @Test
    public void scoreLoop() {
        DeepWaterParameters p = new DeepWaterParameters();
        p._backend = this.getBackend();
        Frame tr = DeepWaterAbstractIntegrationTest.parse_test_file((String)"bigdata/laptop/deepwater/imagenet/cat_dog_mouse.csv");
        p._train = tr._key;
        p._network = DeepWaterParameters.Network.lenet;
        p._response_column = "C2";
        p._mini_batch_size = 4;
        p._train_samples_per_iteration = p._mini_batch_size;
        p._learning_rate = 0.0;
        p._seed = 12345L;
        p._epochs = 0.01;
        p._quiet_mode = true;
        DeepWater j = new DeepWater(p);
        DeepWaterModel m = (DeepWaterModel)j.trainModel().get();
        int count = 0;
        while (count++ < 100) {
            Log.info((Object[])new Object[]{"Iteration: " + count});
            m.doScoring(tr, null, j._job._key, m.iterations, true);
        }
        tr.remove();
        m.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void prostateClassification() {
        Frame tr = null;
        DeepWaterModel m = null;
        try {
            DeepWaterParameters p = new DeepWaterParameters();
            p._backend = this.getBackend();
            tr = DeepWaterAbstractIntegrationTest.parse_test_file((String)"smalldata/prostate/prostate.csv");
            p._train = tr._key;
            p._response_column = "CAPSULE";
            p._ignored_columns = new String[]{"ID"};
            for (String col : new String[]{"RACE", "DPROS", "DCAPS", "CAPSULE", "GLEASON"}) {
                Vec v = tr.remove(col);
                tr.add(col, v.toCategoricalVec());
                v.remove();
            }
            DKV.put((Keyed)tr);
            p._seed = 1234L;
            p._epochs = 500.0;
            DeepWater j = new DeepWater(p);
            m = (DeepWaterModel)j.trainModel().get();
            Assert.assertTrue((((DeepWaterModelOutput)m._output)._training_metrics.auc_obj()._auc > 0.9 ? 1 : 0) != 0);
        }
        finally {
            if (tr != null) {
                tr.remove();
            }
            if (m != null) {
                m.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void prostateRegression() {
        Frame tr = null;
        Frame preds = null;
        DeepWaterModel m = null;
        try {
            DeepWaterParameters p = new DeepWaterParameters();
            p._backend = this.getBackend();
            tr = DeepWaterAbstractIntegrationTest.parse_test_file((String)"smalldata/prostate/prostate.csv");
            p._train = tr._key;
            p._response_column = "AGE";
            p._ignored_columns = new String[]{"ID"};
            for (String col : new String[]{"RACE", "DPROS", "DCAPS", "CAPSULE", "GLEASON"}) {
                Vec v = tr.remove(col);
                tr.add(col, v.toCategoricalVec());
                v.remove();
            }
            DKV.put((Keyed)tr);
            p._seed = 1234L;
            p._epochs = 1000.0;
            DeepWater j = new DeepWater(p);
            m = (DeepWaterModel)j.trainModel().get();
            Assert.assertTrue((((DeepWaterModelOutput)m._output)._training_metrics.rmse() < 5.0 ? 1 : 0) != 0);
            preds = m.score((Frame)p._train.get());
            Assert.assertTrue((boolean)m.testJavaScoring((Frame)p._train.get(), preds, 0.001));
        }
        finally {
            if (tr != null) {
                tr.remove();
            }
            if (m != null) {
                m.remove();
            }
            if (preds != null) {
                preds.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void imageURLs() {
        Frame tr = null;
        Frame preds = null;
        DeepWaterModel m = null;
        try {
            DeepWaterParameters p = new DeepWaterParameters();
            p._backend = this.getBackend();
            tr = DeepWaterAbstractIntegrationTest.parse_test_file((String)"smalldata/deepwater/imagenet/binomial_image_urls.csv");
            p._train = tr._key;
            p._response_column = "C2";
            p._network = DeepWaterParameters.Network.lenet;
            p._epochs = 500.0;
            p._seed = 1234L;
            DeepWater j = new DeepWater(p);
            m = (DeepWaterModel)j.trainModel().get();
            Assert.assertTrue((((DeepWaterModelOutput)m._output)._training_metrics.auc_obj()._auc > 0.85 ? 1 : 0) != 0);
            preds = m.score((Frame)p._train.get());
            Assert.assertTrue((boolean)m.testJavaScoring((Frame)p._train.get(), preds, 0.001, 1.0E-5, 1.0));
        }
        finally {
            if (tr != null) {
                tr.remove();
            }
            if (preds != null) {
                preds.remove();
            }
            if (m != null) {
                m.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void categorical() {
        Frame tr = null;
        DeepWaterModel m = null;
        try {
            DeepWaterParameters p = new DeepWaterParameters();
            p._backend = this.getBackend();
            tr = DeepWaterAbstractIntegrationTest.parse_test_file((String)"smalldata/gbm_test/alphabet_cattest.csv");
            p._train = tr._key;
            p._response_column = "y";
            for (String col : new String[]{"y"}) {
                Vec v = tr.remove(col);
                tr.add(col, v.toCategoricalVec());
                v.remove();
            }
            DKV.put((Keyed)tr);
            DeepWater j = new DeepWater(p);
            m = (DeepWaterModel)j.trainModel().get();
            Assert.assertTrue((((DeepWaterModelOutput)m._output)._training_metrics.auc_obj()._auc > 0.9 ? 1 : 0) != 0);
        }
        finally {
            if (tr != null) {
                tr.remove();
            }
            if (m != null) {
                m.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MNISTLenet() {
        Frame tr = null;
        Frame va = null;
        DeepWaterModel m = null;
        try {
            DeepWaterParameters p = new DeepWaterParameters();
            File file = FileUtils.locateFile((String)"bigdata/laptop/mnist/train.csv.gz");
            File valid = FileUtils.locateFile((String)"bigdata/laptop/mnist/test.csv.gz");
            if (file != null) {
                p._response_column = "C785";
                NFSFileVec trainfv = NFSFileVec.make((File)file);
                tr = ParseDataset.parse((Key)Key.make(), (Key[])new Key[]{trainfv._key});
                NFSFileVec validfv = NFSFileVec.make((File)valid);
                va = ParseDataset.parse((Key)Key.make(), (Key[])new Key[]{validfv._key});
                for (String col : new String[]{p._response_column}) {
                    Vec v = tr.remove(col);
                    tr.add(col, v.toCategoricalVec());
                    v.remove();
                    v = va.remove(col);
                    va.add(col, v.toCategoricalVec());
                    v.remove();
                }
                DKV.put((Keyed)tr);
                DKV.put((Keyed)va);
                p._backend = this.getBackend();
                p._train = tr._key;
                p._valid = va._key;
                p._image_shape = new int[]{28, 28};
                p._ignore_const_cols = false;
                p._channels = 1;
                p._network = DeepWaterParameters.Network.lenet;
                DeepWater j = new DeepWater(p);
                m = (DeepWaterModel)j.trainModel().get();
                Assert.assertTrue((((ModelMetricsMultinomial)((DeepWaterModelOutput)m._output)._validation_metrics).mean_per_class_error() < 0.05 ? 1 : 0) != 0);
            }
        }
        finally {
            if (tr != null) {
                tr.remove();
            }
            if (va != null) {
                va.remove();
            }
            if (m != null) {
                m.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MNISTSparse() {
        Frame tr = null;
        Frame va = null;
        DeepWaterModel m = null;
        try {
            DeepWaterParameters p = new DeepWaterParameters();
            File file = FileUtils.locateFile((String)"bigdata/laptop/mnist/train.csv.gz");
            File valid = FileUtils.locateFile((String)"bigdata/laptop/mnist/test.csv.gz");
            if (file != null) {
                p._response_column = "C785";
                NFSFileVec trainfv = NFSFileVec.make((File)file);
                tr = ParseDataset.parse((Key)Key.make(), (Key[])new Key[]{trainfv._key});
                NFSFileVec validfv = NFSFileVec.make((File)valid);
                va = ParseDataset.parse((Key)Key.make(), (Key[])new Key[]{validfv._key});
                for (String col : new String[]{p._response_column}) {
                    Vec v = tr.remove(col);
                    tr.add(col, v.toCategoricalVec());
                    v.remove();
                    v = va.remove(col);
                    va.add(col, v.toCategoricalVec());
                    v.remove();
                }
                DKV.put((Keyed)tr);
                DKV.put((Keyed)va);
                p._backend = this.getBackend();
                p._train = tr._key;
                p._valid = va._key;
                p._learning_rate = 0.005;
                p._hidden = new int[]{500, 500};
                p._sparse = true;
                DeepWater j = new DeepWater(p);
                m = (DeepWaterModel)j.trainModel().get();
                Assert.assertTrue((((ModelMetricsMultinomial)((DeepWaterModelOutput)m._output)._validation_metrics).mean_per_class_error() < 0.05 ? 1 : 0) != 0);
            }
        }
        finally {
            if (tr != null) {
                tr.remove();
            }
            if (va != null) {
                va.remove();
            }
            if (m != null) {
                m.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MNISTHinton() {
        Frame tr = null;
        Frame va = null;
        DeepWaterModel m = null;
        try {
            DeepWaterParameters p = new DeepWaterParameters();
            File file = FileUtils.locateFile((String)"bigdata/laptop/mnist/train.csv.gz");
            File valid = FileUtils.locateFile((String)"bigdata/laptop/mnist/test.csv.gz");
            if (file != null) {
                p._response_column = "C785";
                NFSFileVec trainfv = NFSFileVec.make((File)file);
                tr = ParseDataset.parse((Key)Key.make(), (Key[])new Key[]{trainfv._key});
                NFSFileVec validfv = NFSFileVec.make((File)valid);
                va = ParseDataset.parse((Key)Key.make(), (Key[])new Key[]{validfv._key});
                for (String col : new String[]{p._response_column}) {
                    Vec v = tr.remove(col);
                    tr.add(col, v.toCategoricalVec());
                    v.remove();
                    v = va.remove(col);
                    va.add(col, v.toCategoricalVec());
                    v.remove();
                }
                DKV.put((Keyed)tr);
                DKV.put((Keyed)va);
                p._backend = this.getBackend();
                p._hidden = new int[]{1024, 1024, 2048};
                p._input_dropout_ratio = 0.1;
                p._hidden_dropout_ratios = new double[]{0.5, 0.5, 0.5};
                p._stopping_rounds = 0;
                p._learning_rate = 0.001;
                p._mini_batch_size = 32;
                p._epochs = 20.0;
                p._train = tr._key;
                p._valid = va._key;
                DeepWater j = new DeepWater(p);
                m = (DeepWaterModel)j.trainModel().get();
                Assert.assertTrue((((ModelMetricsMultinomial)((DeepWaterModelOutput)m._output)._validation_metrics).mean_per_class_error() < 0.05 ? 1 : 0) != 0);
            }
        }
        finally {
            if (tr != null) {
                tr.remove();
            }
            if (va != null) {
                va.remove();
            }
            if (m != null) {
                m.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void Airlines() {
        Frame tr = null;
        DeepWaterModel m = null;
        Frame[] splits = null;
        try {
            DeepWaterParameters p = new DeepWaterParameters();
            File file = FileUtils.locateFile((String)"smalldata/airlines/allyears2k_headers.zip");
            if (file != null) {
                p._response_column = "IsDepDelayed";
                p._ignored_columns = new String[]{"DepTime", "ArrTime", "Cancelled", "CancellationCode", "Diverted", "CarrierDelay", "WeatherDelay", "NASDelay", "SecurityDelay", "LateAircraftDelay", "IsArrDelayed"};
                NFSFileVec trainfv = NFSFileVec.make((File)file);
                tr = ParseDataset.parse((Key)Key.make(), (Key[])new Key[]{trainfv._key});
                for (String col : new String[]{p._response_column, "UniqueCarrier", "Origin", "Dest"}) {
                    Vec v = tr.remove(col);
                    tr.add(col, v.toCategoricalVec());
                    v.remove();
                }
                DKV.put((Keyed)tr);
                double[] dArray = DeepWaterAbstractIntegrationTest.ard((double[])new double[]{0.5, 0.5});
                Key[] keys = (Key[])DeepWaterAbstractIntegrationTest.aro((Object[])new Key[]{Key.make((String)"test.hex"), Key.make((String)"train.hex")});
                splits = ShuffleSplitFrame.shuffleSplitFrame((Frame)tr, (Key[])keys, (double[])dArray, (long)42L);
                p._backend = this.getBackend();
                p._train = keys[0];
                p._valid = keys[1];
                DeepWater j = new DeepWater(p);
                m = (DeepWaterModel)j.trainModel().get();
                Assert.assertTrue((((ModelMetricsBinomial)((DeepWaterModelOutput)m._output)._validation_metrics).auc() > 0.65 ? 1 : 0) != 0);
            }
        }
        finally {
            if (tr != null) {
                tr.remove();
            }
            if (m != null) {
                m.remove();
            }
            if (splits != null) {
                for (void var7_12 : splits) {
                    var7_12.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void MOJOTestImage(DeepWaterParameters.Network network) {
        Frame tr = null;
        DeepWaterModel m = null;
        Frame preds = null;
        try {
            DeepWaterParameters p = new DeepWaterParameters();
            p._backend = this.getBackend();
            tr = DeepWaterAbstractIntegrationTest.parse_test_file((String)"bigdata/laptop/deepwater/imagenet/cat_dog_mouse.csv");
            p._train = tr._key;
            p._response_column = "C2";
            p._learning_rate = 1.0E-4;
            p._network = network;
            p._mini_batch_size = 4;
            p._train_samples_per_iteration = 8L;
            p._epochs = 0.001;
            m = (DeepWaterModel)new DeepWater(p).trainModel().get();
            preds = m.score(tr);
            Assert.assertTrue((boolean)m.testJavaScoring(tr, preds, 0.001));
            preds.remove(0).remove();
            double logloss = ModelMetricsMultinomial.make((Frame)preds, (Vec)tr.vec(p._response_column)).logloss();
            Assert.assertTrue((Math.abs(logloss - ((ModelMetricsMultinomial)((DeepWaterModelOutput)m._output)._training_metrics).logloss()) < 0.001 ? 1 : 0) != 0);
        }
        finally {
            if (tr != null) {
                tr.remove();
            }
            if (m != null) {
                m.remove();
            }
            if (preds != null) {
                preds.remove();
            }
        }
    }

    @Test
    public void MOJOTestImageLenet() {
        this.MOJOTestImage(DeepWaterParameters.Network.lenet);
    }

    @Test
    public void MOJOTestImageInception() {
        this.MOJOTestImage(DeepWaterParameters.Network.inception_bn);
    }

    @Test
    public void MOJOTestImageAlexnet() {
        this.MOJOTestImage(DeepWaterParameters.Network.alexnet);
    }

    @Ignore
    @Test
    public void MOJOTestImageResnet() {
        this.MOJOTestImage(DeepWaterParameters.Network.resnet);
    }

    @Test
    public void MOJOTestImageVGG() {
        this.MOJOTestImage(DeepWaterParameters.Network.vgg);
    }

    @Ignore
    @Test
    public void MOJOTestImageGooglenet() {
        this.MOJOTestImage(DeepWaterParameters.Network.googlenet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void MOJOTest(Model.Parameters.CategoricalEncodingScheme categoricalEncodingScheme, boolean enumCols, boolean standardize) {
        Frame tr = null;
        Frame tr2 = null;
        Frame tr3 = null;
        DeepWaterModel m = null;
        Frame preds = null;
        Frame preds2 = null;
        Frame preds3 = null;
        try {
            Vec v;
            DeepWaterParameters p = new DeepWaterParameters();
            tr = DeepWaterAbstractIntegrationTest.parse_test_file((String)"smalldata/prostate/prostate.csv");
            p._response_column = "CAPSULE";
            for (String col : new String[]{p._response_column}) {
                v = tr.remove(col);
                tr.add(col, v.toCategoricalVec());
                v.remove();
            }
            if (enumCols) {
                for (String col : new String[]{"RACE", "DPROS", "DCAPS", "GLEASON"}) {
                    v = tr.remove(col);
                    tr.add(col, v.toCategoricalVec());
                    v.remove();
                }
            }
            DKV.put((Keyed)tr);
            p._train = tr._key;
            p._ignored_columns = new String[]{"ID"};
            p._backend = this.getBackend();
            p._seed = 12345L;
            p._epochs = 50.0;
            p._categorical_encoding = categoricalEncodingScheme;
            p._standardize = standardize;
            p._hidden = new int[]{50, 50};
            m = (DeepWaterModel)new DeepWater(p).trainModel().get();
            preds = m.score(tr);
            Assert.assertTrue((boolean)m.testJavaScoring(tr, preds, 0.001));
            double auc = ModelMetricsBinomial.make((Vec)preds.vec(2), (Vec)tr.vec(p._response_column)).auc();
            Assert.assertTrue((Math.abs(auc - ((ModelMetricsBinomial)((DeepWaterModelOutput)m._output)._training_metrics).auc()) < 0.001 ? 1 : 0) != 0);
            if (standardize) {
                Assert.assertTrue((auc > 0.7 ? 1 : 0) != 0);
            }
            tr2 = DeepWaterAbstractIntegrationTest.parse_test_file((String)"smalldata/prostate/prostate.csv");
            for (String col : new String[]{p._response_column}) {
                tr2.add(col, tr2.remove(col));
            }
            if (enumCols) {
                for (String col : new String[]{"RACE", "DPROS", "DCAPS", "GLEASON"}) {
                    tr2.add(col, tr2.remove(col));
                }
            }
            Assert.assertTrue((Math.abs((auc = ModelMetricsBinomial.make((Vec)(preds2 = m.score(tr2)).vec(2), (Vec)tr2.vec(p._response_column)).auc()) - ((ModelMetricsBinomial)((DeepWaterModelOutput)m._output)._training_metrics).auc()) < 0.001 ? 1 : 0) != 0);
            if (standardize) {
                Assert.assertTrue((auc > 0.7 ? 1 : 0) != 0);
            }
            Assert.assertTrue((Math.abs((auc = ModelMetricsBinomial.make((Vec)(preds3 = m.score(tr3 = DeepWaterAbstractIntegrationTest.parse_test_file((String)"smalldata/prostate/prostate.csv"))).vec(2), (Vec)tr3.vec(p._response_column)).auc()) - ((ModelMetricsBinomial)((DeepWaterModelOutput)m._output)._training_metrics).auc()) < 0.001 ? 1 : 0) != 0);
            if (standardize) {
                Assert.assertTrue((auc > 0.7 ? 1 : 0) != 0);
            }
        }
        finally {
            if (tr != null) {
                tr.remove();
            }
            if (tr2 != null) {
                tr2.remove();
            }
            if (tr3 != null) {
                tr3.remove();
            }
            if (m != null) {
                m.remove();
            }
            if (preds != null) {
                preds.remove();
            }
            if (preds2 != null) {
                preds2.remove();
            }
            if (preds3 != null) {
                preds3.remove();
            }
        }
    }

    @Test
    public void MOJOTestNumericNonStandardized() {
        this.MOJOTest(Model.Parameters.CategoricalEncodingScheme.AUTO, false, false);
    }

    @Test
    public void MOJOTestNumeric() {
        this.MOJOTest(Model.Parameters.CategoricalEncodingScheme.AUTO, false, true);
    }

    @Test
    public void MOJOTestCatInternal() {
        this.MOJOTest(Model.Parameters.CategoricalEncodingScheme.OneHotInternal, true, true);
    }

    @Test
    public void MOJOTestCatExplicit() {
        this.MOJOTest(Model.Parameters.CategoricalEncodingScheme.OneHotExplicit, true, true);
    }

    @Test
    public void MOJOTestCatEigen() {
        this.MOJOTest(Model.Parameters.CategoricalEncodingScheme.Eigen, true, true);
    }

    @Test
    public void MOJOTestCatBinary() {
        this.MOJOTest(Model.Parameters.CategoricalEncodingScheme.Binary, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckpointForwards() {
        Frame tfr = null;
        DeepWaterModel dl = null;
        DeepWaterModel dl2 = null;
        try {
            tfr = DeepWaterAbstractIntegrationTest.parse_test_file((String)"./smalldata/iris/iris.csv");
            DeepWaterParameters p = new DeepWaterParameters();
            p._backend = this.getBackend();
            p._train = tfr._key;
            p._epochs = 10.0;
            p._response_column = "C5";
            p._hidden = new int[]{2, 2};
            p._seed = 912559L;
            p._stopping_rounds = 0;
            dl = (DeepWaterModel)new DeepWater(p).trainModel().get();
            DeepWaterParameters parms2 = (DeepWaterParameters)p.clone();
            parms2._epochs = 20.0;
            parms2._checkpoint = dl._key;
            dl2 = (DeepWaterModel)new DeepWater(parms2).trainModel().get();
            Assert.assertTrue((dl2.epoch_counter > 20.0 ? 1 : 0) != 0);
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (dl != null) {
                dl.delete();
            }
            if (dl2 != null) {
                dl2.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckpointBackwards() {
        Frame tfr = null;
        DeepWaterModel dl = null;
        DeepWaterModel dl2 = null;
        try {
            tfr = DeepWaterAbstractIntegrationTest.parse_test_file((String)"./smalldata/iris/iris.csv");
            DeepWaterParameters p = new DeepWaterParameters();
            p._backend = this.getBackend();
            p._train = tfr._key;
            p._epochs = 10.0;
            p._response_column = "C5";
            p._hidden = new int[]{2, 2};
            p._seed = 912559L;
            dl = (DeepWaterModel)new DeepWater(p).trainModel().get();
            DeepWaterParameters parms2 = (DeepWaterParameters)p.clone();
            parms2._epochs = 9.0;
            parms2._checkpoint = dl._key;
            try {
                dl2 = (DeepWaterModel)new DeepWater(parms2).trainModel().get();
                Assert.fail((String)"Should toss exception instead of reaching here");
            }
            catch (H2OIllegalArgumentException h2OIllegalArgumentException) {
                // empty catch block
            }
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (dl != null) {
                dl.delete();
            }
            if (dl2 != null) {
                dl2.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void checkpointReporting() {
        Scope.enter();
        Frame frame = null;
        try {
            File file = FileUtils.locateFile((String)"smalldata/logreg/prostate.csv");
            NFSFileVec trainfv = NFSFileVec.make((File)file);
            frame = ParseDataset.parse((Key)Key.make(), (Key[])new Key[]{trainfv._key});
            DeepWaterParameters p = new DeepWaterParameters();
            p._backend = this.getBackend();
            p._train = frame._key;
            p._response_column = "CAPSULE";
            p._activation = DeepWaterParameters.Activation.Rectifier;
            p._epochs = 4.0;
            p._train_samples_per_iteration = -1L;
            p._mini_batch_size = 1;
            p._score_duty_cycle = 1.0;
            p._score_interval = 0.0;
            p._overwrite_with_best_model = false;
            p._seed = 1234L;
            int ci = frame.find("CAPSULE");
            Scope.track((Vec)frame.replace(ci, frame.vecs()[ci].toCategoricalVec()));
            DKV.put((Keyed)frame);
            long start = System.currentTimeMillis();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            DeepWaterModel model = (DeepWaterModel)new DeepWater(p).trainModel().get();
            long sleepTime = 5L;
            try {
                Thread.sleep(sleepTime * 1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            DeepWaterParameters p2 = (DeepWaterParameters)p.clone();
            p2._checkpoint = model._key;
            p2._epochs *= 2.0;
            DeepWaterModel model2 = null;
            try {
                model2 = (DeepWaterModel)new DeepWater(p2).trainModel().get();
                long end = System.currentTimeMillis();
                TwoDimTable table = ((DeepWaterModelOutput)model2._output)._scoring_history;
                double priorDurationDouble = 0.0;
                long priorTimeStampLong = 0L;
                DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
                for (int i = 0; i < table.getRowDim(); ++i) {
                    String timestamp = (String)table.get(i, 0);
                    long timeStampLong = fmt.parseMillis(timestamp);
                    Assert.assertTrue((String)"Timestamp must be later than outside timer start", (timeStampLong >= start ? 1 : 0) != 0);
                    Assert.assertTrue((String)"Timestamp must be earlier than outside timer end", (timeStampLong <= end ? 1 : 0) != 0);
                    Assert.assertTrue((String)"Timestamp must increase", (timeStampLong >= priorTimeStampLong ? 1 : 0) != 0);
                    priorTimeStampLong = timeStampLong;
                    String duration = (String)table.get(i, 1);
                    duration = duration.substring(0, duration.length() - 4);
                    try {
                        double durationDouble = Double.parseDouble(duration);
                        Assert.assertTrue((String)("Duration must be >0: " + durationDouble), (durationDouble >= 0.0 ? 1 : 0) != 0);
                        Assert.assertTrue((String)("Duration must increase: " + priorDurationDouble + " -> " + durationDouble), (durationDouble >= priorDurationDouble ? 1 : 0) != 0);
                        Assert.assertTrue((String)"Duration cannot be more than outside timer delta", (durationDouble <= (double)(end - start) / 1000.0 ? 1 : 0) != 0);
                        priorDurationDouble = durationDouble;
                    }
                    catch (NumberFormatException durationDouble) {
                        // empty catch block
                    }
                    Assert.assertTrue((String)"Epoch counter must be contiguous", ((Double)table.get(i, 3) == (double)i ? 1 : 0) != 0);
                    Assert.assertTrue((String)"Iteration counter must match epochs", ((Integer)table.get(i, 4) == i ? 1 : 0) != 0);
                }
                try {
                    String durationBefore = (String)table.get((int)p._epochs, 1);
                    durationBefore = durationBefore.substring(0, durationBefore.length() - 4);
                    String durationAfter = (String)table.get((int)(p._epochs + 1.0), 1);
                    durationAfter = durationAfter.substring(0, durationAfter.length() - 4);
                    Assert.assertTrue((String)"Duration must be smooth", (Double.parseDouble(durationAfter) - Double.parseDouble(durationBefore) < (double)(sleepTime + 1L) ? 1 : 0) != 0);
                    String timeStampBefore = (String)table.get((int)p._epochs, 0);
                    long timeStampBeforeLong = fmt.parseMillis(timeStampBefore);
                    String timeStampAfter = (String)table.get((int)(p._epochs + 1.0), 0);
                    long timeStampAfterLong = fmt.parseMillis(timeStampAfter);
                    Assert.assertTrue((String)"Time stamp must experience a delay", (timeStampAfterLong - timeStampBeforeLong >= (sleepTime - 1L) * 1000L ? 1 : 0) != 0);
                    String speedBefore = (String)table.get((int)p._epochs, 2);
                    speedBefore = speedBefore.substring(0, speedBefore.length() - 9);
                    double speedBeforeDouble = Double.parseDouble(speedBefore);
                    String speedAfter = (String)table.get((int)(p._epochs + 1.0), 2);
                    speedAfter = speedAfter.substring(0, speedAfter.length() - 9);
                    double speedAfterDouble = Double.parseDouble(speedAfter);
                    Assert.assertTrue((String)"Speed shouldn't change more than 50%", (Math.abs(speedAfterDouble - speedBeforeDouble) / speedBeforeDouble < 0.5 ? 1 : 0) != 0);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            finally {
                if (model != null) {
                    model.delete();
                }
                if (model2 != null) {
                    model2.delete();
                }
            }
        }
        finally {
            if (frame != null) {
                frame.remove();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNumericalExplosion() {
        for (boolean ae : new boolean[]{false}) {
            Frame tfr = null;
            DeepWaterModel dl = null;
            Frame pred = null;
            try {
                tfr = DeepWaterAbstractIntegrationTest.parse_test_file((String)"./smalldata/junit/two_spiral.csv");
                for (String s : new String[]{"Class"}) {
                    Vec resp = tfr.vec(s).toCategoricalVec();
                    tfr.remove(s).remove();
                    tfr.add(s, resp);
                    DKV.put((Keyed)tfr);
                }
                DeepWaterParameters parms = new DeepWaterParameters();
                parms._backend = this.getBackend();
                parms._train = tfr._key;
                parms._epochs = 100.0;
                parms._response_column = "Class";
                parms._autoencoder = ae;
                parms._train_samples_per_iteration = 10L;
                parms._hidden = new int[]{10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10};
                parms._learning_rate = 1.0E10;
                parms._standardize = false;
                DeepWater job = new DeepWater(parms);
                try {
                    dl = (DeepWaterModel)job.trainModel().get();
                    Assert.fail((String)"Should toss exception instead of reaching here");
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                dl = (DeepWaterModel)DKV.getGet((Key)job.dest());
                try {
                    pred = dl.score(tfr);
                    Assert.fail((String)"Should toss exception instead of reaching here");
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                try {
                    dl.getMojo();
                    Assert.fail((String)"Should toss exception instead of reaching here");
                }
                catch (RuntimeException ex) {
                    System.err.println(ex.getMessage());
                }
                Assert.assertTrue((boolean)dl.model_info()._unstable);
                Assert.assertTrue((boolean)((DeepWaterModelOutput)dl._output)._job.isCrashed());
            }
            finally {
                if (tfr != null) {
                    tfr.delete();
                }
                if (dl != null) {
                    dl.delete();
                }
                if (pred != null) {
                    pred.delete();
                }
            }
        }
    }

    @Test
    public void textsToArrayTest() throws IOException {
        ArrayList<String> texts = new ArrayList<String>();
        ArrayList<String> labels = new ArrayList<String>();
        texts.add("the rock is destined to be the 21st century's new \" conan \" and that he's going to make a splash even greater than arnold schwarzenegger , jean-claud van damme or steven segal .");
        texts.add("the gorgeously elaborate continuation of \" the lord of the rings \" trilogy is so huge that a column of words cannot adequately describe co-writer/director peter jackson's expanded vision of j . r . r . tolkien's middle-earth .");
        texts.add("effective but too-tepid biopic");
        labels.add("pos");
        labels.add("pos");
        labels.add("pos");
        texts.add("simplistic , silly and tedious .");
        texts.add("it's so laddish and juvenile , only teenage boys could possibly find it funny .");
        texts.add("exploitative and largely devoid of the depth or sophistication that would make watching such a graphic treatment of the crimes bearable .");
        labels.add("neg");
        labels.add("neg");
        labels.add("neg");
        ArrayList coded = StringUtils.texts2array(texts);
        for (int[] a : coded) {
            System.out.println(Arrays.toString(a));
        }
        System.out.println("rows " + coded.size() + " cols " + ((int[])coded.get(0)).length);
        Assert.assertEquals((long)6L, (long)coded.size());
        Assert.assertEquals((long)38L, (long)((int[])coded.get(0)).length);
    }

    @Ignore
    @Test
    public void tweetsToArrayTest() throws IOException {
        String line;
        ArrayList<String> texts = new ArrayList<String>();
        ArrayList<String> labels = new ArrayList<String>();
        FileInputStream is = new FileInputStream("/home/magnus/tweets.txt");
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        while ((line = br.readLine()) != null) {
            texts.add(line);
        }
        is.close();
        is = new FileInputStream("/home/magnus/labels.txt");
        br = new BufferedReader(new InputStreamReader(is));
        while ((line = br.readLine()) != null) {
            labels.add(line);
        }
        is.close();
        ArrayList coded = StringUtils.texts2array(texts);
        System.out.println("rows " + coded.size() + " cols " + ((int[])coded.get(0)).length);
        Assert.assertEquals((long)1390L, (long)coded.size());
        Assert.assertEquals((long)35L, (long)((int[])coded.get(0)).length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckpointOverwriteWithBestModel() {
        Frame tfr = null;
        DeepWaterModel dl = null;
        DeepWaterModel dl2 = null;
        Frame train = null;
        Frame valid = null;
        try {
            tfr = DeepWaterAbstractIntegrationTest.parse_test_file((String)"./smalldata/iris/iris.csv");
            FrameSplitter fs = new FrameSplitter(tfr, new double[]{0.8}, new Key[]{Key.make((String)"train"), Key.make((String)"valid")}, null);
            fs.compute2();
            train = fs.getResult()[0];
            valid = fs.getResult()[1];
            DeepWaterParameters parms = new DeepWaterParameters();
            parms._backend = this.getBackend();
            parms._train = train._key;
            parms._valid = valid._key;
            parms._epochs = 1.0;
            parms._response_column = "C5";
            parms._hidden = new int[]{50, 50};
            parms._seed = 912559L;
            parms._train_samples_per_iteration = 0L;
            parms._score_duty_cycle = 1.0;
            parms._score_interval = 0.0;
            parms._stopping_rounds = 0;
            parms._overwrite_with_best_model = true;
            dl = (DeepWaterModel)new DeepWater(parms).trainModel().get();
            double ll1 = ((ModelMetricsMultinomial)((DeepWaterModelOutput)dl._output)._validation_metrics).logloss();
            DeepWaterParameters parms2 = (DeepWaterParameters)parms.clone();
            parms2._epochs = 10.0;
            parms2._checkpoint = dl._key;
            dl2 = (DeepWaterModel)new DeepWater(parms2).trainModel().get();
            double ll2 = ((ModelMetricsMultinomial)((DeepWaterModelOutput)dl2._output)._validation_metrics).logloss();
            Assert.assertTrue((ll2 <= ll1 ? 1 : 0) != 0);
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (dl != null) {
                dl.delete();
            }
            if (dl2 != null) {
                dl2.delete();
            }
            if (train != null) {
                train.delete();
            }
            if (valid != null) {
                valid.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckpointOverwriteWithBestModel2() {
        Frame tfr = null;
        DeepWaterModel dl = null;
        DeepWaterModel dl2 = null;
        Frame train = null;
        Frame valid = null;
        try {
            tfr = DeepWaterAbstractIntegrationTest.parse_test_file((String)"./smalldata/iris/iris.csv");
            FrameSplitter fs = new FrameSplitter(tfr, new double[]{0.8}, new Key[]{Key.make((String)"train"), Key.make((String)"valid")}, null);
            fs.compute2();
            train = fs.getResult()[0];
            valid = fs.getResult()[1];
            DeepWaterParameters parms = new DeepWaterParameters();
            parms._backend = this.getBackend();
            parms._train = train._key;
            parms._valid = valid._key;
            parms._epochs = 10.0;
            parms._response_column = "C5";
            parms._hidden = new int[]{50, 50};
            parms._seed = 912559L;
            parms._train_samples_per_iteration = 0L;
            parms._score_duty_cycle = 1.0;
            parms._score_interval = 0.0;
            parms._stopping_rounds = 0;
            parms._overwrite_with_best_model = true;
            dl = (DeepWaterModel)new DeepWater(parms).trainModel().get();
            double ll1 = ((ModelMetricsMultinomial)((DeepWaterModelOutput)dl._output)._validation_metrics).logloss();
            DeepWaterParameters parms2 = (DeepWaterParameters)parms.clone();
            parms2._epochs = 20.0;
            parms2._checkpoint = dl._key;
            dl2 = (DeepWaterModel)new DeepWater(parms2).trainModel().get();
            double ll2 = ((ModelMetricsMultinomial)((DeepWaterModelOutput)dl2._output)._validation_metrics).logloss();
            Assert.assertTrue((ll2 <= ll1 ? 1 : 0) != 0);
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (dl != null) {
                dl.delete();
            }
            if (dl2 != null) {
                dl2.delete();
            }
            if (train != null) {
                train.delete();
            }
            if (valid != null) {
                valid.delete();
            }
        }
    }
}

