/*
 * Decompiled with CFR 0.152.
 */
package hex.deeplearning;

import hex.deeplearning.Neurons;
import hex.deeplearning.Storage;
import java.util.Random;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import water.TestUtil;
import water.util.ArrayUtils;
import water.util.PrettyPrint;

public class NeuronsTest
extends TestUtil {
    @BeforeClass
    public static void setup() {
        NeuronsTest.stall_till_cloudsize((int)1);
    }

    @Ignore
    @Test
    public void matrixVecTest() {
        int l;
        int l2;
        int rows = 2048;
        int cols = 8192;
        int loops = 5;
        int warmup_loops = 5;
        long seed = 21309L;
        float nnz_ratio_vec = 0.01f;
        float nnz_ratio_mat = 0.1f;
        float[] a = new float[rows * cols];
        double[] x = new double[cols];
        double[] y = new double[rows];
        double[] res = new double[rows];
        byte[] bits = new byte[rows];
        for (int row = 0; row < rows; ++row) {
            y[row] = 0.0;
            res[row] = 0.0;
            bits[row] = (byte)"abcdefghijklmnopqrstuvwxyz".toCharArray()[row % 26];
        }
        Random rng = new Random(seed);
        for (int col = 0; col < cols; ++col) {
            if (!(rng.nextFloat() < nnz_ratio_vec)) continue;
            x[col] = (float)col / (float)cols;
        }
        for (int row = 0; row < rows; ++row) {
            int off = row * cols;
            for (int col = 0; col < cols; ++col) {
                if (!(rng.nextFloat() < nnz_ratio_mat)) continue;
                a[off + col] = (float)(row + col) / (float)cols;
            }
        }
        Storage.DenseRowMatrix dra = new Storage.DenseRowMatrix(a, rows, cols);
        Storage.DenseColMatrix dca = new Storage.DenseColMatrix(dra, rows, cols);
        Storage.SparseRowMatrix sra = new Storage.SparseRowMatrix((Storage.Matrix)dra, rows, cols);
        Storage.SparseColMatrix sca = new Storage.SparseColMatrix((Storage.Matrix)dca, rows, cols);
        Storage.DenseVector dx = new Storage.DenseVector(x);
        Storage.DenseVector dy = new Storage.DenseVector(y);
        Storage.DenseVector dres = new Storage.DenseVector(res);
        System.out.println("warming up.");
        float sum = 0.0f;
        for (l2 = 0; l2 < warmup_loops; ++l2) {
            Neurons.gemv_naive((double[])res, (float[])a, (double[])x, (double[])y, (byte[])bits);
            sum = (float)((double)sum + res[rows / 2]);
        }
        for (l2 = 0; l2 < warmup_loops; ++l2) {
            Neurons.gemv_naive((Storage.DenseVector)dres, (Storage.DenseRowMatrix)dra, (Storage.DenseVector)dx, (Storage.DenseVector)dy, (byte[])bits);
            sum = (float)((double)sum + res[rows / 2]);
        }
        for (l2 = 0; l2 < warmup_loops; ++l2) {
            Neurons.gemv_row_optimized((double[])res, (float[])a, (double[])x, (double[])y, (byte[])bits);
            sum = (float)((double)sum + res[rows / 2]);
        }
        System.out.println("\nstarting naive.");
        sum = 0.0f;
        long start = System.currentTimeMillis();
        for (l = 0; l < loops; ++l) {
            Neurons.gemv_naive((double[])res, (float[])a, (double[])x, (double[])y, (byte[])bits);
            sum = (float)((double)sum + res[rows / 2]);
        }
        System.out.println("result: " + sum + " and " + ArrayUtils.sum((double[])res));
        System.out.println("naive time: " + PrettyPrint.msecs((long)(System.currentTimeMillis() - start), (boolean)true));
        System.out.println("\nstarting dense row * dense.");
        sum = 0.0f;
        start = System.currentTimeMillis();
        for (l = 0; l < loops; ++l) {
            Neurons.gemv_naive((Storage.DenseVector)dres, (Storage.DenseRowMatrix)dra, (Storage.DenseVector)dx, (Storage.DenseVector)dy, (byte[])bits);
            sum = (float)((double)sum + res[rows / 2]);
        }
        System.out.println("result: " + sum + " and " + ArrayUtils.sum((double[])res));
        System.out.println("dense row * dense time: " + PrettyPrint.msecs((long)(System.currentTimeMillis() - start), (boolean)true));
        System.out.println("\nstarting optimized dense row * dense.");
        sum = 0.0f;
        start = System.currentTimeMillis();
        for (l = 0; l < loops; ++l) {
            Neurons.gemv_row_optimized((double[])res, (float[])a, (double[])x, (double[])y, (byte[])bits);
            sum = (float)((double)sum + res[rows / 2]);
        }
        System.out.println("result: " + sum + " and " + ArrayUtils.sum((double[])res));
        System.out.println("optimized dense row * dense time: " + PrettyPrint.msecs((long)(System.currentTimeMillis() - start), (boolean)true));
    }
}

