/*
 * Decompiled with CFR 0.152.
 */
package hex.deeplearning;

import hex.deeplearning.Dropout;
import hex.deeplearning.Storage;
import java.util.Arrays;
import java.util.Random;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import water.TestUtil;
import water.util.ArrayUtils;

public class DropoutTest
extends TestUtil {
    @BeforeClass
    public static void setup() {
        DropoutTest.stall_till_cloudsize((int)1);
    }

    @Test
    public void test() throws Exception {
        int units = 1000;
        Storage.DenseVector a = new Storage.DenseVector(1000);
        double sum1 = 0.0;
        double sum2 = 0.0;
        double sum3 = 0.0;
        double sum4 = 0.0;
        int loops = 10000;
        for (int l = 0; l < 10000; ++l) {
            long seed = new Random().nextLong();
            Dropout d = new Dropout(1000, 0.3);
            Arrays.fill(a.raw(), 1.0);
            d.randomlySparsifyActivation((Storage.Vector)a, seed);
            sum1 += ArrayUtils.sum((double[])a.raw());
            d = new Dropout(1000, 0.0);
            Arrays.fill(a.raw(), 1.0);
            d.randomlySparsifyActivation((Storage.Vector)a, seed + 1L);
            sum2 += ArrayUtils.sum((double[])a.raw());
            d = new Dropout(1000, 1.0);
            Arrays.fill(a.raw(), 1.0);
            d.randomlySparsifyActivation((Storage.Vector)a, seed + 2L);
            sum3 += ArrayUtils.sum((double[])a.raw());
            d = new Dropout(1000, 0.314);
            d.fillBytes(seed + 3L);
            for (int i = 0; i < 1000; ++i) {
                if (d.unit_active(i)) {
                    sum4 += 1.0;
                    assert (d.unit_active(i));
                    continue;
                }
                assert (!d.unit_active(i));
            }
        }
        Assert.assertTrue((Math.abs((sum1 /= 10000.0) - 700.0) < 1.0 ? 1 : 0) != 0);
        Assert.assertTrue(((sum2 /= 10000.0) == 1000.0 ? 1 : 0) != 0);
        Assert.assertTrue(((sum3 /= 10000.0) == 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs((sum4 /= 10000.0) - 686.0) < 1.0 ? 1 : 0) != 0);
    }
}

