/*
 * Decompiled with CFR 0.152.
 */
package hex.deeplearning;

import hex.CreateFrame;
import hex.FrameSplitter;
import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsAutoEncoder;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsMultinomial;
import hex.ModelMetricsRegression;
import hex.ScoreKeeper;
import hex.deeplearning.DeepLearning;
import hex.deeplearning.DeepLearningModel;
import hex.genmodel.utils.DistributionFamily;
import java.io.File;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import water.DKV;
import water.Iced;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.Scope;
import water.TestUtil;
import water.exceptions.H2OIllegalArgumentException;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NFSFileVec;
import water.fvec.Vec;
import water.parser.ParseDataset;
import water.util.ArrayUtils;
import water.util.FileUtils;
import water.util.FrameUtils;
import water.util.Log;
import water.util.MathUtils;
import water.util.RandomUtils;

public class DeepLearningTest
extends TestUtil {
    @BeforeClass
    public static void stall() {
        DeepLearningTest.stall_till_cloudsize((int)1);
    }

    static String[] s(String ... arr) {
        return arr;
    }

    static long[] a(long ... arr) {
        return arr;
    }

    static long[][] a(long[] ... arr) {
        return arr;
    }

    @Test
    public void testClassIris1() throws Throwable {
        this.basicDLTest_Classification("./smalldata/iris/iris.csv", "iris.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                return fr.numCols() - 1;
            }
        }, 1, DeepLearningTest.ard((double[][])new double[][]{DeepLearningTest.ard((double[])new double[]{27.0, 16.0, 7.0}), DeepLearningTest.ard((double[])new double[]{0.0, 4.0, 46.0}), DeepLearningTest.ard((double[])new double[]{0.0, 3.0, 47.0})}), DeepLearningTest.s("Iris-setosa", "Iris-versicolor", "Iris-virginica"), DeepLearningModel.DeepLearningParameters.Activation.Rectifier);
    }

    @Test
    public void testClassIris5() throws Throwable {
        this.basicDLTest_Classification("./smalldata/iris/iris.csv", "iris5.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                return fr.numCols() - 1;
            }
        }, 5, DeepLearningTest.ard((double[][])new double[][]{DeepLearningTest.ard((double[])new double[]{50.0, 0.0, 0.0}), DeepLearningTest.ard((double[])new double[]{0.0, 39.0, 11.0}), DeepLearningTest.ard((double[])new double[]{0.0, 8.0, 42.0})}), DeepLearningTest.s("Iris-setosa", "Iris-versicolor", "Iris-virginica"), DeepLearningModel.DeepLearningParameters.Activation.Rectifier);
    }

    @Test
    public void testClassCars1() throws Throwable {
        this.basicDLTest_Classification("./smalldata/junit/cars.csv", "cars.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("name").remove();
                return fr.find("cylinders");
            }
        }, 1, DeepLearningTest.ard((double[][])new double[][]{DeepLearningTest.ard((double[])new double[]{0.0, 4.0, 0.0, 0.0, 0.0}), DeepLearningTest.ard((double[])new double[]{0.0, 193.0, 5.0, 9.0, 0.0}), DeepLearningTest.ard((double[])new double[]{0.0, 2.0, 1.0, 0.0, 0.0}), DeepLearningTest.ard((double[])new double[]{0.0, 65.0, 3.0, 16.0, 0.0}), DeepLearningTest.ard((double[])new double[]{0.0, 11.0, 0.0, 7.0, 90.0})}), DeepLearningTest.s("3", "4", "5", "6", "8"), DeepLearningModel.DeepLearningParameters.Activation.Rectifier);
    }

    @Test
    public void testClassCars5() throws Throwable {
        this.basicDLTest_Classification("./smalldata/junit/cars.csv", "cars5.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("name").remove();
                return fr.find("cylinders");
            }
        }, 5, DeepLearningTest.ard((double[][])new double[][]{DeepLearningTest.ard((double[])new double[]{0.0, 4.0, 0.0, 0.0, 0.0}), DeepLearningTest.ard((double[])new double[]{0.0, 206.0, 0.0, 1.0, 0.0}), DeepLearningTest.ard((double[])new double[]{0.0, 2.0, 0.0, 1.0, 0.0}), DeepLearningTest.ard((double[])new double[]{0.0, 14.0, 0.0, 69.0, 1.0}), DeepLearningTest.ard((double[])new double[]{0.0, 0.0, 0.0, 6.0, 102.0})}), DeepLearningTest.s("3", "4", "5", "6", "8"), DeepLearningModel.DeepLearningParameters.Activation.Rectifier);
    }

    @Test
    public void testConstantCols() throws Throwable {
        try {
            this.basicDLTest_Classification("./smalldata/poker/poker100", "poker.hex", new PrepData(){

                @Override
                int prep(Frame fr) {
                    for (int i = 0; i < 7; ++i) {
                        Vec v = fr.remove(3);
                        if (v == null) continue;
                        v.remove();
                    }
                    return 3;
                }
            }, 1, null, null, DeepLearningModel.DeepLearningParameters.Activation.Rectifier);
            Assert.fail();
        }
        catch (H2OModelBuilderIllegalArgumentException h2OModelBuilderIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testBadData() throws Throwable {
        this.basicDLTest_Classification("./smalldata/junit/drf_infinities.csv", "infinitys.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                return fr.find("DateofBirth");
            }
        }, 1, DeepLearningTest.ard((double[][])new double[][]{DeepLearningTest.ard((double[])new double[]{0.0, 17.0}), DeepLearningTest.ard((double[])new double[]{0.0, 17.0})}), DeepLearningTest.s("0", "1"), DeepLearningModel.DeepLearningParameters.Activation.Rectifier);
    }

    @Test
    public void testCreditProstate1() throws Throwable {
        this.basicDLTest_Classification("./smalldata/logreg/prostate.csv", "prostate.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("ID").remove();
                return fr.find("CAPSULE");
            }
        }, 1, DeepLearningTest.ard((double[][])new double[][]{DeepLearningTest.ard((double[])new double[]{97.0, 130.0}), DeepLearningTest.ard((double[])new double[]{28.0, 125.0})}), DeepLearningTest.s("0", "1"), DeepLearningModel.DeepLearningParameters.Activation.Rectifier);
    }

    @Test
    public void testCreditProstateReLUDropout() throws Throwable {
        this.basicDLTest_Classification("./smalldata/logreg/prostate.csv", "prostateReLUDropout.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("ID").remove();
                return fr.find("CAPSULE");
            }
        }, 1, DeepLearningTest.ard((double[][])new double[][]{DeepLearningTest.ard((double[])new double[]{4.0, 223.0}), DeepLearningTest.ard((double[])new double[]{0.0, 153.0})}), DeepLearningTest.s("0", "1"), DeepLearningModel.DeepLearningParameters.Activation.RectifierWithDropout);
    }

    @Test
    public void testCreditProstateTanh() throws Throwable {
        this.basicDLTest_Classification("./smalldata/logreg/prostate.csv", "prostateTanh.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("ID").remove();
                return fr.find("CAPSULE");
            }
        }, 1, DeepLearningTest.ard((double[][])new double[][]{DeepLearningTest.ard((double[])new double[]{141.0, 86.0}), DeepLearningTest.ard((double[])new double[]{25.0, 128.0})}), DeepLearningTest.s("0", "1"), DeepLearningModel.DeepLearningParameters.Activation.Tanh);
    }

    @Test
    public void testCreditProstateTanhDropout() throws Throwable {
        this.basicDLTest_Classification("./smalldata/logreg/prostate.csv", "prostateTanhDropout.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("ID").remove();
                return fr.find("CAPSULE");
            }
        }, 1, DeepLearningTest.ard((double[][])new double[][]{DeepLearningTest.ard((double[])new double[]{110.0, 117.0}), DeepLearningTest.ard((double[])new double[]{23.0, 130.0})}), DeepLearningTest.s("0", "1"), DeepLearningModel.DeepLearningParameters.Activation.TanhWithDropout);
    }

    @Test
    public void testCreditProstateMaxout() throws Throwable {
        this.basicDLTest_Classification("./smalldata/logreg/prostate.csv", "prostateMaxout.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("ID").remove();
                return fr.find("CAPSULE");
            }
        }, 100, DeepLearningTest.ard((double[][])new double[][]{DeepLearningTest.ard((double[])new double[]{189.0, 38.0}), DeepLearningTest.ard((double[])new double[]{30.0, 123.0})}), DeepLearningTest.s("0", "1"), DeepLearningModel.DeepLearningParameters.Activation.Maxout);
    }

    @Test
    public void testCreditProstateMaxoutDropout() throws Throwable {
        this.basicDLTest_Classification("./smalldata/logreg/prostate.csv", "prostateMaxoutDropout.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("ID").remove();
                return fr.find("CAPSULE");
            }
        }, 100, DeepLearningTest.ard((double[][])new double[][]{DeepLearningTest.ard((double[])new double[]{183.0, 44.0}), DeepLearningTest.ard((double[])new double[]{40.0, 113.0})}), DeepLearningTest.s("0", "1"), DeepLearningModel.DeepLearningParameters.Activation.MaxoutWithDropout);
    }

    @Test
    public void testCreditProstateRegression1() throws Throwable {
        this.basicDLTest_Regression("./smalldata/logreg/prostate.csv", "prostateRegression.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("ID").remove();
                return fr.find("AGE");
            }
        }, 1, 46.26952683659, DeepLearningModel.DeepLearningParameters.Activation.Rectifier);
    }

    @Test
    public void testCreditProstateRegressionTanh() throws Throwable {
        this.basicDLTest_Regression("./smalldata/logreg/prostate.csv", "prostateRegressionTanh.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("ID").remove();
                return fr.find("AGE");
            }
        }, 1, 43.457087913127, DeepLearningModel.DeepLearningParameters.Activation.Tanh);
    }

    @Test
    public void testCreditProstateRegressionMaxout() throws Throwable {
        this.basicDLTest_Regression("./smalldata/logreg/prostate.csv", "prostateRegressionMaxout.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("ID").remove();
                return fr.find("AGE");
            }
        }, 100, 32.81408434266, DeepLearningModel.DeepLearningParameters.Activation.Maxout);
    }

    @Test
    public void testCreditProstateRegression5() throws Throwable {
        this.basicDLTest_Regression("./smalldata/logreg/prostate.csv", "prostateRegression5.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("ID").remove();
                return fr.find("AGE");
            }
        }, 5, 41.8498354737908, DeepLearningModel.DeepLearningParameters.Activation.Rectifier);
    }

    @Test
    public void testCreditProstateRegression50() throws Throwable {
        this.basicDLTest_Regression("./smalldata/logreg/prostate.csv", "prostateRegression50.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("ID").remove();
                return fr.find("AGE");
            }
        }, 50, 37.93380250522667, DeepLearningModel.DeepLearningParameters.Activation.Rectifier);
    }

    @Test
    public void testAlphabet() throws Throwable {
        this.basicDLTest_Classification("./smalldata/gbm_test/alphabet_cattest.csv", "alphabetClassification.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                return fr.find("y");
            }
        }, 10, DeepLearningTest.ard((double[][])new double[][]{DeepLearningTest.ard((double[])new double[]{2080.0, 0.0}), DeepLearningTest.ard((double[])new double[]{0.0, 2080.0})}), DeepLearningTest.s("0", "1"), DeepLearningModel.DeepLearningParameters.Activation.Rectifier);
    }

    @Test
    public void testAlphabetRegression() throws Throwable {
        this.basicDLTest_Regression("./smalldata/gbm_test/alphabet_cattest.csv", "alphabetRegression.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                return fr.find("y");
            }
        }, 10, 4.975570190016591E-6, DeepLearningModel.DeepLearningParameters.Activation.Rectifier);
    }

    @Ignore
    @Test
    public void testAirlines() throws Throwable {
        this.basicDLTest_Classification("./smalldata/airlines/allyears2k_headers.zip", "airlines.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                for (String s : new String[]{"DepTime", "ArrTime", "ActualElapsedTime", "AirTime", "ArrDelay", "DepDelay", "Cancelled", "CancellationCode", "CarrierDelay", "WeatherDelay", "NASDelay", "SecurityDelay", "LateAircraftDelay", "IsArrDelayed", "TailNum"}) {
                    fr.remove(s).remove();
                }
                return fr.find("IsDepDelayed");
            }
        }, 7, DeepLearningTest.ard((double[][])new double[][]{DeepLearningTest.ard((double[])new double[]{9251.0, 11636.0}), DeepLearningTest.ard((double[])new double[]{3053.0, 200038.0})}), DeepLearningTest.s("NO", "YES"), DeepLearningModel.DeepLearningParameters.Activation.Rectifier);
    }

    @Ignore
    @Test
    public void testCzechboard() throws Throwable {
        this.basicDLTest_Classification("./smalldata/gbm_test/czechboard_300x300.csv", "czechboard_300x300.hex", new PrepData(){

            @Override
            int prep(Frame fr) {
                Vec resp = fr.remove("C2");
                fr.add("C2", resp.toCategoricalVec());
                resp.remove();
                return fr.find("C3");
            }
        }, 1, DeepLearningTest.ard((double[][])new double[][]{DeepLearningTest.ard((double[])new double[]{7.0, 44993.0}), DeepLearningTest.ard((double[])new double[]{2.0, 44998.0})}), DeepLearningTest.s("0", "1"), DeepLearningModel.DeepLearningParameters.Activation.Tanh);
    }

    static Vec unifyFrame(DeepLearningModel.DeepLearningParameters drf, Frame fr, PrepData prep, boolean classification) {
        int idx = prep.prep(fr);
        if (idx < 0) {
            idx ^= 0xFFFFFFFF;
        }
        String rname = fr._names[idx];
        drf._response_column = fr.names()[idx];
        Vec resp = fr.vecs()[idx];
        Vec ret = null;
        if (classification) {
            ret = fr.remove(idx);
            fr.add(rname, resp.toCategoricalVec());
        } else {
            fr.remove(idx);
            fr.add(rname, resp);
        }
        return ret;
    }

    public void basicDLTest_Classification(String fnametrain, String hexnametrain, PrepData prep, int epochs, double[][] expCM, String[] expRespDom, DeepLearningModel.DeepLearningParameters.Activation activation) throws Throwable {
        this.basicDL(fnametrain, hexnametrain, null, prep, epochs, expCM, expRespDom, -1.0, new int[]{10, 10}, 1.0E-5, true, activation);
    }

    public void basicDLTest_Regression(String fnametrain, String hexnametrain, PrepData prep, int epochs, double expMSE, DeepLearningModel.DeepLearningParameters.Activation activation) throws Throwable {
        this.basicDL(fnametrain, hexnametrain, null, prep, epochs, null, null, expMSE, new int[]{10, 10}, 1.0E-5, false, activation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicDL(String fnametrain, String hexnametrain, String fnametest, PrepData prep, int epochs, double[][] expCM, String[] expRespDom, double expMSE, int[] hidden, double l1, boolean classification, DeepLearningModel.DeepLearningParameters.Activation activation) throws Throwable {
        Scope.enter();
        DeepLearningModel.DeepLearningParameters dl = new DeepLearningModel.DeepLearningParameters();
        Frame frTest = null;
        Frame pred = null;
        Frame frTrain = null;
        Frame test = null;
        Frame res = null;
        DeepLearningModel model = null;
        try {
            ModelMetrics mm;
            frTrain = DeepLearningTest.parse_test_file((String)fnametrain);
            Vec removeme = DeepLearningTest.unifyFrame(dl, frTrain, prep, classification);
            if (removeme != null) {
                Scope.track((Vec)removeme);
            }
            DKV.put((Key)frTrain._key, (Iced)frTrain);
            dl._train = frTrain._key;
            dl._response_column = ((Frame)DKV.getGet((Key)dl._train)).lastVecName();
            dl._seed = 0x100000002L;
            dl._reproducible = true;
            dl._epochs = epochs;
            dl._stopping_rounds = 0;
            dl._activation = activation;
            dl._export_weights_and_biases = RandomUtils.getRNG((long[])new long[]{fnametrain.hashCode()}).nextBoolean();
            dl._hidden = hidden;
            dl._l1 = l1;
            dl._elastic_averaging = false;
            DeepLearning job = new DeepLearning(dl, Key.make((String)("DL_model_" + hexnametrain)));
            model = (DeepLearningModel)job.trainModel().get();
            Log.info((Object[])new Object[]{model._output});
            Assert.assertTrue((boolean)job.isStopped());
            if (fnametest != null) {
                frTest = DeepLearningTest.parse_test_file((String)fnametest);
                pred = model.score(frTest);
                mm = ModelMetrics.getFromDKV((Model)model, (Frame)frTest);
            } else {
                pred = model.score(frTrain);
                mm = ModelMetrics.getFromDKV((Model)model, (Frame)frTrain);
            }
            test = DeepLearningTest.parse_test_file((String)fnametrain);
            res = model.score(test);
            if (classification) {
                Assert.assertTrue((String)("Expected: " + Arrays.deepToString((Object[])expCM) + ", Got: " + Arrays.deepToString((Object[])mm.cm()._cm)), (boolean)Arrays.deepEquals((Object[])mm.cm()._cm, (Object[])expCM));
                Object[] cmDom = ((DeepLearningModel.DeepLearningModelOutput)model._output)._domains[((DeepLearningModel.DeepLearningModelOutput)model._output)._domains.length - 1];
                Assert.assertArrayEquals((String)"CM domain differs!", (Object[])expRespDom, (Object[])cmDom);
                Log.info((Object[])new Object[]{"\nTraining CM:\n" + mm.cm().toASCII()});
                Log.info((Object[])new Object[]{"\nTraining CM:\n" + ModelMetrics.getFromDKV((Model)model, (Frame)test).cm().toASCII()});
            } else {
                Assert.assertTrue((String)("Expected: " + expMSE + ", Got: " + mm.mse()), (boolean)MathUtils.compare((double)expMSE, (double)mm.mse(), (double)1.0E-8, (double)1.0E-8));
                Log.info((Object[])new Object[]{"\nOOB Training MSE: " + mm.mse()});
                Log.info((Object[])new Object[]{"\nTraining MSE: " + ModelMetrics.getFromDKV((Model)model, (Frame)test).mse()});
            }
            ModelMetrics.getFromDKV((Model)model, (Frame)test);
            Assert.assertTrue((boolean)model.testJavaScoring(test, res, 1.0E-5));
        }
        finally {
            if (frTrain != null) {
                frTrain.remove();
            }
            if (frTest != null) {
                frTest.remove();
            }
            if (model != null) {
                model.delete();
            }
            if (pred != null) {
                pred.delete();
            }
            if (test != null) {
                test.delete();
            }
            if (res != null) {
                res.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void elasticAveragingTrivial() {
        int i;
        int N = 2;
        DeepLearningModel[] models = new DeepLearningModel[N];
        DeepLearningModel.DeepLearningParameters dl = new DeepLearningModel.DeepLearningParameters();
        Scope.enter();
        try {
            for (i = 0; i < N; ++i) {
                Frame frTrain = DeepLearningTest.parse_test_file((String)"./smalldata/covtype/covtype.20k.data");
                Vec resp = frTrain.lastVec().toCategoricalVec();
                frTrain.remove(frTrain.vecs().length - 1).remove();
                frTrain.add("Response", resp);
                DKV.put((Keyed)frTrain);
                dl._train = frTrain._key;
                dl._response_column = ((Frame)DKV.getGet((Key)dl._train)).lastVecName();
                dl._export_weights_and_biases = true;
                dl._hidden = new int[]{17, 11};
                dl._quiet_mode = false;
                dl._seed = 1234L;
                dl._reproducible = true;
                dl._epochs = 1.0;
                dl._train_samples_per_iteration = -1L;
                if (i == 0) {
                    dl._elastic_averaging = false;
                    dl._elastic_averaging_moving_rate = 0.5;
                    dl._elastic_averaging_regularization = 0.9;
                } else {
                    dl._elastic_averaging = true;
                    dl._elastic_averaging_moving_rate = 0.5;
                    dl._elastic_averaging_regularization = 0.1;
                }
                DeepLearning job = new DeepLearning(dl);
                models[i] = (DeepLearningModel)job.trainModel().get();
                frTrain.remove();
            }
            for (i = 0; i < N; ++i) {
                Log.info((Object[])new Object[]{((DeepLearningModel.DeepLearningModelOutput)models[i]._output)._training_metrics.cm().table().toString()});
                Assert.assertEquals((double)((DeepLearningModel.DeepLearningModelOutput)models[i]._output)._training_metrics._MSE, (double)((DeepLearningModel.DeepLearningModelOutput)models[0]._output)._training_metrics._MSE, (double)1.0E-6);
            }
        }
        finally {
            for (i = 0; i < N; ++i) {
                if (models[i] == null) continue;
                models[i].delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void elasticAveraging() {
        int i;
        Vec resp;
        Frame frTrain;
        int N = 2;
        DeepLearningModel[] models = new DeepLearningModel[N];
        DeepLearningModel.DeepLearningParameters dl = new DeepLearningModel.DeepLearningParameters();
        Scope.enter();
        boolean covtype = true;
        if (covtype) {
            frTrain = DeepLearningTest.parse_test_file((String)"./smalldata/covtype/covtype.20k.data");
            resp = frTrain.lastVec().toCategoricalVec();
            frTrain.remove(frTrain.vecs().length - 1).remove();
            frTrain.add("Response", resp);
        } else {
            frTrain = DeepLearningTest.parse_test_file((String)"./bigdata/server/HIGGS.csv");
            resp = frTrain.vecs()[0].toCategoricalVec();
            frTrain.remove(0).remove();
            frTrain.prepend("Response", resp);
        }
        DKV.put((Keyed)frTrain);
        try {
            for (i = 0; i < N; ++i) {
                dl._train = frTrain._key;
                String[] n = ((Frame)DKV.getGet((Key)dl._train)).names();
                if (covtype) {
                    dl._response_column = n[n.length - 1];
                    dl._ignored_columns = null;
                } else {
                    dl._response_column = n[0];
                    dl._ignored_columns = new String[]{n[22], n[23], n[24], n[25], n[26], n[27], n[28]};
                }
                dl._export_weights_and_biases = true;
                dl._hidden = new int[]{64, 64};
                dl._quiet_mode = false;
                dl._max_w2 = 10.0f;
                dl._l1 = 1.0E-5;
                dl._reproducible = false;
                dl._replicate_training_data = false;
                dl._force_load_balance = true;
                dl._epochs = 10.0;
                dl._train_samples_per_iteration = frTrain.numRows() / 100L;
                dl._elastic_averaging = i == 1;
                dl._elastic_averaging_moving_rate = 0.999;
                dl._elastic_averaging_regularization = 1.0E-4;
                DeepLearning job = new DeepLearning(dl);
                models[i] = (DeepLearningModel)job.trainModel().get();
            }
            for (i = 0; i < N; ++i) {
                if (models[i] == null) continue;
                Log.info((Object[])new Object[]{((DeepLearningModel.DeepLearningModelOutput)models[i]._output)._training_metrics.cm().table().toString()});
            }
            if (models[0] != null) {
                Log.info((Object[])new Object[]{"Without elastic averaging: error=" + ((DeepLearningModel.DeepLearningModelOutput)models[0]._output)._training_metrics.cm().err()});
            }
            if (models[1] != null) {
                Log.info((Object[])new Object[]{"With elastic averaging:    error=" + ((DeepLearningModel.DeepLearningModelOutput)models[1]._output)._training_metrics.cm().err()});
            }
        }
        finally {
            frTrain.remove();
            for (i = 0; i < N; ++i) {
                if (models[i] == null) continue;
                models[i].delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoRowWeights() {
        Frame tfr = null;
        Object vfr = null;
        Frame pred = null;
        Frame fr2 = null;
        Scope.enter();
        try {
            tfr = DeepLearningTest.parse_test_file((String)"smalldata/junit/no_weights.csv");
            DKV.put((Keyed)tfr);
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._response_column = "response";
            parms._reproducible = true;
            parms._seed = 912559L;
            parms._l1 = 0.1;
            parms._epochs = 1.0;
            parms._hidden = new int[]{1};
            parms._classification_stop = -1.0;
            DeepLearningModel dl = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            pred = dl.score(parms.train());
            ModelMetricsBinomial mm = ModelMetricsBinomial.getFromDKV((Model)dl, (Frame)parms.train());
            Assert.assertEquals((double)0.7592592592592592, (double)mm.auc_obj()._auc, (double)1.0E-8);
            double mse = ((DeepLearningModel.DeepLearningModelOutput)dl._output)._training_metrics.mse();
            Assert.assertEquals((double)0.314813341867078, (double)mse, (double)1.0E-8);
            fr2 = dl.score(tfr);
            Assert.assertTrue((boolean)dl.testJavaScoring(tfr, fr2, 1.0E-5));
            dl.delete();
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (vfr != null) {
                vfr.remove();
            }
            if (pred != null) {
                pred.remove();
            }
            if (fr2 != null) {
                fr2.remove();
            }
        }
        Scope.exit((Key[])new Key[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRowWeightsOne() {
        Frame tfr = null;
        Object vfr = null;
        Frame pred = null;
        Object fr2 = null;
        Scope.enter();
        try {
            tfr = DeepLearningTest.parse_test_file((String)"smalldata/junit/weights_all_ones.csv");
            DKV.put((Keyed)tfr);
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._response_column = "response";
            parms._weights_column = "weight";
            parms._reproducible = true;
            parms._seed = 912559L;
            parms._classification_stop = -1.0;
            parms._l1 = 0.1;
            parms._hidden = new int[]{1};
            parms._epochs = 1.0;
            DeepLearningModel dl = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            pred = dl.score(parms.train());
            ModelMetricsBinomial mm = ModelMetricsBinomial.getFromDKV((Model)dl, (Frame)parms.train());
            Assert.assertEquals((double)0.7592592592592592, (double)mm.auc_obj()._auc, (double)1.0E-8);
            double mse = ((DeepLearningModel.DeepLearningModelOutput)dl._output)._training_metrics.mse();
            Assert.assertEquals((double)0.3148133418670781, (double)mse, (double)1.0E-8);
            dl.delete();
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (vfr != null) {
                vfr.remove();
            }
            if (pred != null) {
                pred.remove();
            }
            if (fr2 != null) {
                fr2.remove();
            }
        }
        Scope.exit((Key[])new Key[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoRowWeightsShuffled() {
        Frame tfr = null;
        Object vfr = null;
        Frame pred = null;
        Frame fr2 = null;
        Scope.enter();
        try {
            tfr = DeepLearningTest.parse_test_file((String)"smalldata/junit/no_weights_shuffled.csv");
            DKV.put((Keyed)tfr);
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._response_column = "response";
            parms._reproducible = true;
            parms._seed = 912559L;
            parms._l1 = 0.1;
            parms._epochs = 1.0;
            parms._hidden = new int[]{1};
            parms._classification_stop = -1.0;
            DeepLearningModel dl = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            pred = dl.score(parms.train());
            ModelMetricsBinomial mm = ModelMetricsBinomial.getFromDKV((Model)dl, (Frame)parms.train());
            Assert.assertEquals((double)0.7222222222222222, (double)mm.auc_obj()._auc, (double)1.0E-8);
            double mse = ((DeepLearningModel.DeepLearningModelOutput)dl._output)._training_metrics.mse();
            Assert.assertEquals((double)0.31643071339946, (double)mse, (double)1.0E-8);
            fr2 = dl.score(tfr);
            Assert.assertTrue((boolean)dl.testJavaScoring(tfr, fr2, 1.0E-5));
            dl.delete();
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (vfr != null) {
                vfr.remove();
            }
            if (pred != null) {
                pred.remove();
            }
            if (fr2 != null) {
                fr2.remove();
            }
        }
        Scope.exit((Key[])new Key[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRowWeights() {
        Frame tfr = null;
        Frame pred = null;
        Scope.enter();
        try {
            tfr = DeepLearningTest.parse_test_file((String)"smalldata/junit/weights.csv");
            DKV.put((Keyed)tfr);
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._response_column = "response";
            parms._weights_column = "weight";
            parms._reproducible = true;
            parms._seed = 912559L;
            parms._classification_stop = -1.0;
            parms._l1 = 0.1;
            parms._hidden = new int[]{1};
            parms._epochs = 10.0;
            DeepLearningModel dl = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            pred = dl.score(parms.train());
            ModelMetricsBinomial mm = ModelMetricsBinomial.getFromDKV((Model)dl, (Frame)parms.train());
            Assert.assertEquals((double)0.7592592592592592, (double)mm.auc_obj()._auc, (double)1.0E-8);
            double mse = ((DeepLearningModel.DeepLearningModelOutput)dl._output)._training_metrics.mse();
            Assert.assertEquals((double)0.3116490253190556, (double)mse, (double)1.0E-8);
            dl.delete();
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (pred != null) {
                pred.remove();
            }
        }
        Scope.exit((Key[])new Key[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void testWhatever() {
        Object first1kSVM = null;
        Object second1kSVM = null;
        Object third1kSVM = null;
        Frame first1kCSV = null;
        Object second1kCSV = null;
        Object third1kCSV = null;
        DeepLearningModel model = null;
        DeepLearningModel.DeepLearningParameters dl = new DeepLearningModel.DeepLearningParameters();
        Scope.enter();
        try {
            first1kCSV = DeepLearningTest.parse_test_file((String)"/users/arno/first1k.csv");
            Vec response = first1kCSV.remove(first1kCSV.find("C2"));
            Vec responseFactor = response.toCategoricalVec();
            response.remove();
            first1kCSV.prepend("C2", responseFactor);
            DKV.put((Keyed)first1kCSV);
            dl._train = first1kCSV._key;
            dl._ignored_columns = new String[]{"C1"};
            dl._response_column = "C2";
            dl._epochs = 10.0;
            dl._reproducible = true;
            dl._seed = 1234L;
            dl._ignore_const_cols = false;
            dl._sparse = true;
            dl._hidden = new int[]{10, 10};
            DeepLearning job = new DeepLearning(dl);
            model = (DeepLearningModel)job.trainModel().get();
            Log.info((Object[])new Object[]{model._output});
            Frame pred = null;
            Log.info((Object[])new Object[]{"POJO CSV Train Check"});
            DKV.remove((Key)model._key);
            model._key = Key.make();
            DKV.put((Keyed)model);
            pred = model.score(first1kCSV);
            Assert.assertTrue((boolean)model.testJavaScoring(first1kCSV, pred, 1.0E-5));
            pred.remove();
            Assert.assertTrue((boolean)job.isStopped());
        }
        finally {
            if (first1kSVM != null) {
                first1kSVM.remove();
            }
            if (second1kSVM != null) {
                second1kSVM.remove();
            }
            if (third1kSVM != null) {
                third1kSVM.remove();
            }
            if (first1kCSV != null) {
                first1kCSV.remove();
            }
            if (second1kCSV != null) {
                second1kCSV.remove();
            }
            if (third1kCSV != null) {
                third1kCSV.remove();
            }
            if (model != null) {
                model.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLossFunctions() {
        Frame tfr = null;
        Object vfr = null;
        Frame fr2 = null;
        DeepLearningModel dl = null;
        for (DeepLearningModel.DeepLearningParameters.Loss loss : new DeepLearningModel.DeepLearningParameters.Loss[]{DeepLearningModel.DeepLearningParameters.Loss.Automatic, DeepLearningModel.DeepLearningParameters.Loss.Quadratic, DeepLearningModel.DeepLearningParameters.Loss.Huber, DeepLearningModel.DeepLearningParameters.Loss.Absolute, DeepLearningModel.DeepLearningParameters.Loss.Quantile}) {
            Scope.enter();
            try {
                tfr = DeepLearningTest.parse_test_file((String)"smalldata/glm_test/cancar_logIn.csv");
                for (String s : new String[]{"Merit", "Class"}) {
                    Scope.track((Vec)tfr.replace(tfr.find(s), tfr.vec(s).toCategoricalVec()));
                }
                DKV.put((Keyed)tfr);
                DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
                parms._train = tfr._key;
                parms._epochs = 1.0;
                parms._reproducible = true;
                parms._hidden = new int[]{50, 50};
                parms._response_column = "Cost";
                parms._seed = 912559L;
                parms._loss = loss;
                DeepLearning job = new DeepLearning(parms);
                dl = (DeepLearningModel)job.trainModel().get();
                ModelMetricsRegression mm = (ModelMetricsRegression)((DeepLearningModel.DeepLearningModelOutput)dl._output)._training_metrics;
                if (loss == DeepLearningModel.DeepLearningParameters.Loss.Automatic || loss == DeepLearningModel.DeepLearningParameters.Loss.Quadratic) {
                    Assert.assertEquals((double)mm._mean_residual_deviance, (double)mm._MSE, (double)1.0E-6);
                } else {
                    Assert.assertTrue((mm._mean_residual_deviance != mm._MSE ? 1 : 0) != 0);
                }
                fr2 = dl.score(tfr);
                Assert.assertTrue((boolean)dl.testJavaScoring(tfr, fr2, 1.0E-5));
            }
            finally {
                if (tfr != null) {
                    tfr.remove();
                }
                if (dl != null) {
                    dl.delete();
                }
                if (fr2 != null) {
                    fr2.remove();
                }
                Scope.exit((Key[])new Key[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDistributions() {
        Frame tfr = null;
        Object vfr = null;
        Frame fr2 = null;
        DeepLearningModel dl = null;
        for (DistributionFamily dist : new DistributionFamily[]{DistributionFamily.AUTO, DistributionFamily.gaussian, DistributionFamily.poisson, DistributionFamily.gamma, DistributionFamily.tweedie}) {
            Scope.enter();
            try {
                tfr = DeepLearningTest.parse_test_file((String)"smalldata/glm_test/cancar_logIn.csv");
                for (String s : new String[]{"Merit", "Class"}) {
                    Scope.track((Vec)tfr.replace(tfr.find(s), tfr.vec(s).toCategoricalVec()));
                }
                DKV.put((Keyed)tfr);
                DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
                parms._train = tfr._key;
                parms._epochs = 1.0;
                parms._reproducible = true;
                parms._hidden = new int[]{50, 50};
                parms._response_column = "Cost";
                parms._seed = 912559L;
                parms._distribution = dist;
                DeepLearning job = new DeepLearning(parms);
                dl = (DeepLearningModel)job.trainModel().get();
                ModelMetricsRegression mm = (ModelMetricsRegression)((DeepLearningModel.DeepLearningModelOutput)dl._output)._training_metrics;
                if (dist == DistributionFamily.gaussian || dist == DistributionFamily.AUTO) {
                    Assert.assertEquals((double)mm._mean_residual_deviance, (double)mm._MSE, (double)1.0E-6);
                } else {
                    Assert.assertTrue((mm._mean_residual_deviance != mm._MSE ? 1 : 0) != 0);
                }
                fr2 = dl.score(tfr);
                Assert.assertTrue((boolean)dl.testJavaScoring(tfr, fr2, 1.0E-5));
            }
            finally {
                if (tfr != null) {
                    tfr.remove();
                }
                if (dl != null) {
                    dl.delete();
                }
                if (fr2 != null) {
                    fr2.delete();
                }
                Scope.exit((Key[])new Key[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoEncoder() {
        Frame tfr = null;
        Object vfr = null;
        Frame fr2 = null;
        DeepLearningModel dl = null;
        Scope.enter();
        try {
            tfr = DeepLearningTest.parse_test_file((String)"smalldata/glm_test/cancar_logIn.csv");
            for (String s : new String[]{"Merit", "Class"}) {
                Scope.track((Vec)tfr.replace(tfr.find(s), tfr.vec(s).toCategoricalVec()));
            }
            DKV.put((Keyed)tfr);
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._epochs = 100.0;
            parms._reproducible = true;
            parms._hidden = new int[]{5, 5, 5};
            parms._response_column = "Cost";
            parms._seed = 912559L;
            parms._autoencoder = true;
            parms._input_dropout_ratio = 0.1;
            parms._activation = DeepLearningModel.DeepLearningParameters.Activation.Tanh;
            dl = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            ModelMetricsAutoEncoder mm = (ModelMetricsAutoEncoder)((DeepLearningModel.DeepLearningModelOutput)dl._output)._training_metrics;
            Assert.assertEquals((double)0.0712931422088762, (double)mm._MSE, (double)0.01);
            fr2 = dl.score(tfr);
            Assert.assertTrue((boolean)dl.testJavaScoring(tfr, fr2, 1.0E-5));
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (dl != null) {
                dl.delete();
            }
            if (fr2 != null) {
                fr2.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNumericalExplosion() {
        for (boolean ae : new boolean[]{true, false}) {
            Frame tfr = null;
            DeepLearningModel dl = null;
            Frame pred = null;
            try {
                tfr = DeepLearningTest.parse_test_file((String)"./smalldata/junit/two_spiral.csv");
                for (String s : new String[]{"Class"}) {
                    Vec resp = tfr.vec(s).toCategoricalVec();
                    tfr.remove(s).remove();
                    tfr.add(s, resp);
                    DKV.put((Keyed)tfr);
                }
                DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
                parms._train = tfr._key;
                parms._epochs = 100.0;
                parms._response_column = "Class";
                parms._autoencoder = ae;
                parms._reproducible = true;
                parms._train_samples_per_iteration = 10L;
                parms._hidden = new int[]{10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10};
                parms._initial_weight_distribution = DeepLearningModel.DeepLearningParameters.InitialWeightDistribution.Uniform;
                parms._initial_weight_scale = 1.0E20;
                parms._seed = 912559L;
                parms._max_w2 = 1.0E20f;
                DeepLearning job = new DeepLearning(parms);
                try {
                    dl = (DeepLearningModel)job.trainModel().get();
                    Assert.fail((String)"Should toss exception instead of reaching here");
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                dl = (DeepLearningModel)DKV.getGet((Key)job.dest());
                try {
                    pred = dl.score(tfr);
                    Assert.fail((String)"Should toss exception instead of reaching here");
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                Assert.assertTrue((boolean)dl.model_info().isUnstable());
                Assert.assertTrue((boolean)((DeepLearningModel.DeepLearningModelOutput)dl._output)._job.isCrashed());
            }
            finally {
                if (tfr != null) {
                    tfr.delete();
                }
                if (dl != null) {
                    dl.delete();
                }
                if (pred != null) {
                    pred.delete();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEarlyStopping() {
        Frame tfr = null;
        DeepLearningModel dl = null;
        try {
            tfr = DeepLearningTest.parse_test_file((String)"./smalldata/junit/two_spiral.csv");
            for (String s : new String[]{"Class"}) {
                Vec resp = tfr.vec(s).toCategoricalVec();
                tfr.remove(s).remove();
                tfr.add(s, resp);
                DKV.put((Keyed)tfr);
            }
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._epochs = 100.0;
            parms._response_column = "Class";
            parms._reproducible = true;
            parms._classification_stop = 0.7;
            parms._score_duty_cycle = 1.0;
            parms._score_interval = 0.0;
            parms._hidden = new int[]{100, 100};
            parms._seed = 912559L;
            dl = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            Assert.assertTrue((boolean)dl.stopped_early);
            Assert.assertTrue((dl.epoch_counter < 100.0 ? 1 : 0) != 0);
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (dl != null) {
                dl.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVarimp() {
        Frame tfr = null;
        DeepLearningModel dl = null;
        try {
            tfr = DeepLearningTest.parse_test_file((String)"./smalldata/iris/iris.csv");
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._epochs = 100.0;
            parms._response_column = "C5";
            parms._reproducible = true;
            parms._classification_stop = 0.7;
            parms._score_duty_cycle = 1.0;
            parms._score_interval = 0.0;
            parms._hidden = new int[]{100, 100};
            parms._seed = 912559L;
            parms._variable_importances = true;
            dl = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            Assert.assertTrue((dl.varImp()._varimp != null ? 1 : 0) != 0);
            Log.info((Object[])new Object[]{dl.model_info().toStringAll()});
            Assert.assertTrue(((double)ArrayUtils.minValue((float[])dl.varImp()._varimp) > 0.5 ? 1 : 0) != 0);
            Assert.assertTrue((ArrayUtils.maxValue((float[])dl.varImp()._varimp) <= 1.0f ? 1 : 0) != 0);
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (dl != null) {
                dl.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckpointSameEpochs() {
        Frame tfr = null;
        DeepLearningModel dl = null;
        DeepLearningModel dl2 = null;
        try {
            tfr = DeepLearningTest.parse_test_file((String)"./smalldata/iris/iris.csv");
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._epochs = 10.0;
            parms._response_column = "C5";
            parms._reproducible = true;
            parms._hidden = new int[]{2, 2};
            parms._seed = 912559L;
            parms._variable_importances = true;
            dl = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            DeepLearningModel.DeepLearningParameters parms2 = (DeepLearningModel.DeepLearningParameters)parms.clone();
            parms2._epochs = 10.0;
            parms2._checkpoint = dl._key;
            try {
                dl2 = (DeepLearningModel)new DeepLearning(parms2).trainModel().get();
                Assert.fail((String)"Should toss exception instead of reaching here");
            }
            catch (H2OIllegalArgumentException h2OIllegalArgumentException) {
                // empty catch block
            }
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (dl != null) {
                dl.delete();
            }
            if (dl2 != null) {
                dl2.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckpointBackwards() {
        Frame tfr = null;
        DeepLearningModel dl = null;
        DeepLearningModel dl2 = null;
        try {
            tfr = DeepLearningTest.parse_test_file((String)"./smalldata/iris/iris.csv");
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._epochs = 10.0;
            parms._response_column = "C5";
            parms._reproducible = true;
            parms._hidden = new int[]{2, 2};
            parms._seed = 912559L;
            parms._variable_importances = true;
            dl = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            DeepLearningModel.DeepLearningParameters parms2 = (DeepLearningModel.DeepLearningParameters)parms.clone();
            parms2._epochs = 9.0;
            parms2._checkpoint = dl._key;
            try {
                dl2 = (DeepLearningModel)new DeepLearning(parms2).trainModel().get();
                Assert.fail((String)"Should toss exception instead of reaching here");
            }
            catch (H2OIllegalArgumentException h2OIllegalArgumentException) {
                // empty catch block
            }
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (dl != null) {
                dl.delete();
            }
            if (dl2 != null) {
                dl2.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConvergenceLogloss() {
        Frame tfr = null;
        DeepLearningModel dl = null;
        Object dl2 = null;
        try {
            tfr = DeepLearningTest.parse_test_file((String)"./smalldata/iris/iris.csv");
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._epochs = 1000000.0;
            parms._response_column = "C5";
            parms._reproducible = true;
            parms._hidden = new int[]{2, 2};
            parms._seed = 912559L;
            parms._variable_importances = true;
            parms._score_duty_cycle = 0.1;
            parms._score_interval = 0.0;
            parms._classification_stop = -1.0;
            parms._stopping_rounds = 5;
            parms._stopping_metric = ScoreKeeper.StoppingMetric.logloss;
            parms._stopping_tolerance = 0.03;
            dl = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            Assert.assertTrue((dl.epoch_counter < parms._epochs ? 1 : 0) != 0);
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (dl != null) {
                dl.delete();
            }
            if (dl2 != null) {
                dl2.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConvergenceMisclassification() {
        Frame tfr = null;
        DeepLearningModel dl = null;
        Object dl2 = null;
        try {
            tfr = DeepLearningTest.parse_test_file((String)"./smalldata/iris/iris.csv");
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._epochs = 1000000.0;
            parms._response_column = "C5";
            parms._reproducible = true;
            parms._hidden = new int[]{2, 2};
            parms._seed = 912559L;
            parms._variable_importances = true;
            parms._score_duty_cycle = 1.0;
            parms._score_interval = 0.0;
            parms._classification_stop = -1.0;
            parms._stopping_rounds = 2;
            parms._stopping_metric = ScoreKeeper.StoppingMetric.misclassification;
            parms._stopping_tolerance = 0.0;
            dl = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            Assert.assertTrue((dl.epoch_counter < parms._epochs ? 1 : 0) != 0);
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (dl != null) {
                dl.delete();
            }
            if (dl2 != null) {
                dl2.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConvergenceDeviance() {
        Frame tfr = null;
        DeepLearningModel dl = null;
        Object dl2 = null;
        try {
            tfr = DeepLearningTest.parse_test_file((String)"./smalldata/logreg/prostate.csv");
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._epochs = 1000000.0;
            parms._response_column = "AGE";
            parms._reproducible = true;
            parms._hidden = new int[]{2, 2};
            parms._seed = 912559L;
            parms._variable_importances = true;
            parms._score_duty_cycle = 1.0;
            parms._score_interval = 0.0;
            parms._classification_stop = -1.0;
            parms._stopping_rounds = 2;
            parms._stopping_metric = ScoreKeeper.StoppingMetric.deviance;
            parms._stopping_tolerance = 0.0;
            dl = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            Assert.assertTrue((dl.epoch_counter < parms._epochs ? 1 : 0) != 0);
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (dl != null) {
                dl.delete();
            }
            if (dl2 != null) {
                dl2.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConvergenceAUC() {
        Frame tfr = null;
        DeepLearningModel dl = null;
        Object dl2 = null;
        try {
            tfr = DeepLearningTest.parse_test_file((String)"./smalldata/logreg/prostate.csv");
            for (String s : new String[]{"CAPSULE"}) {
                Vec resp = tfr.vec(s).toCategoricalVec();
                tfr.remove(s).remove();
                tfr.add(s, resp);
                DKV.put((Keyed)tfr);
            }
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._epochs = 1000000.0;
            parms._response_column = "CAPSULE";
            parms._reproducible = true;
            parms._hidden = new int[]{2, 2};
            parms._seed = 912559L;
            parms._variable_importances = true;
            parms._score_duty_cycle = 1.0;
            parms._score_interval = 0.0;
            parms._classification_stop = -1.0;
            parms._stopping_rounds = 2;
            parms._stopping_metric = ScoreKeeper.StoppingMetric.AUC;
            parms._stopping_tolerance = 0.0;
            dl = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            Assert.assertTrue((dl.epoch_counter < parms._epochs ? 1 : 0) != 0);
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (dl != null) {
                dl.delete();
            }
            if (dl2 != null) {
                dl2.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoHiddenLayerRegression() {
        Frame tfr = null;
        DeepLearningModel dl = null;
        Object dl2 = null;
        try {
            tfr = DeepLearningTest.parse_test_file((String)"./smalldata/logreg/prostate.csv");
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._epochs = 1000.0;
            parms._response_column = "AGE";
            parms._hidden = new int[0];
            dl = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            Frame res = dl.score(tfr);
            Assert.assertTrue((boolean)dl.testJavaScoring(tfr, res, 1.0E-5));
            res.remove();
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (dl != null) {
                dl.delete();
            }
            if (dl2 != null) {
                dl2.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoHiddenLayerClassification() {
        Frame tfr = null;
        DeepLearningModel dl = null;
        Object dl2 = null;
        try {
            tfr = DeepLearningTest.parse_test_file((String)"./smalldata/logreg/prostate.csv");
            for (String s : new String[]{"CAPSULE"}) {
                Vec resp = tfr.vec(s).toCategoricalVec();
                tfr.remove(s).remove();
                tfr.add(s, resp);
                DKV.put((Keyed)tfr);
            }
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._epochs = 1000.0;
            parms._response_column = "CAPSULE";
            parms._hidden = null;
            dl = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            Frame res = dl.score(tfr);
            Assert.assertTrue((boolean)dl.testJavaScoring(tfr, res, 1.0E-5));
            res.remove();
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (dl != null) {
                dl.delete();
            }
            if (dl2 != null) {
                dl2.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    public void testConvergenceAUC_ModifiedHuber() {
        Frame tfr = null;
        DeepLearningModel dl = null;
        Object dl2 = null;
        try {
            tfr = DeepLearningTest.parse_test_file((String)"./smalldata/logreg/prostate.csv");
            for (String s : new String[]{"CAPSULE"}) {
                Vec resp = tfr.vec(s).toCategoricalVec();
                tfr.remove(s).remove();
                tfr.add(s, resp);
                DKV.put((Keyed)tfr);
            }
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._epochs = 1000000.0;
            parms._response_column = "CAPSULE";
            parms._reproducible = true;
            parms._hidden = new int[]{2, 2};
            parms._seed = 912559L;
            parms._variable_importances = true;
            parms._distribution = DistributionFamily.modified_huber;
            parms._score_duty_cycle = 1.0;
            parms._score_interval = 0.0;
            parms._classification_stop = -1.0;
            parms._stopping_rounds = 2;
            parms._stopping_metric = ScoreKeeper.StoppingMetric.AUC;
            parms._stopping_tolerance = 0.0;
            dl = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            Assert.assertTrue((dl.epoch_counter < parms._epochs ? 1 : 0) != 0);
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (dl != null) {
                dl.delete();
            }
            if (dl2 != null) {
                dl2.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCrossValidation() {
        Frame tfr = null;
        DeepLearningModel dl = null;
        try {
            tfr = DeepLearningTest.parse_test_file((String)"./smalldata/gbm_test/BostonHousing.csv");
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._response_column = tfr.lastVecName();
            parms._reproducible = true;
            parms._hidden = new int[]{20, 20};
            parms._seed = 912559L;
            parms._nfolds = 4;
            dl = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            Assert.assertEquals((double)12.959355363801334, (double)((DeepLearningModel.DeepLearningModelOutput)dl._output)._training_metrics._MSE, (double)1.0E-6);
            Assert.assertEquals((double)17.296871012606317, (double)((DeepLearningModel.DeepLearningModelOutput)dl._output)._cross_validation_metrics._MSE, (double)1.0E-6);
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (dl != null) {
                dl.deleteCrossValidationModels();
            }
            if (dl != null) {
                dl.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMiniBatch1() {
        Frame tfr = null;
        DeepLearningModel dl = null;
        try {
            tfr = DeepLearningTest.parse_test_file((String)"./smalldata/gbm_test/BostonHousing.csv");
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._response_column = tfr.lastVecName();
            parms._reproducible = true;
            parms._hidden = new int[]{20, 20};
            parms._seed = 912559L;
            parms._mini_batch_size = 1;
            dl = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            Assert.assertEquals((double)12.938076268040659, (double)((DeepLearningModel.DeepLearningModelOutput)dl._output)._training_metrics._MSE, (double)1.0E-6);
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (dl != null) {
                dl.deleteCrossValidationModels();
            }
            if (dl != null) {
                dl.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMiniBatch50() {
        Frame tfr = null;
        DeepLearningModel dl = null;
        try {
            tfr = DeepLearningTest.parse_test_file((String)"./smalldata/gbm_test/BostonHousing.csv");
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._response_column = tfr.lastVecName();
            parms._reproducible = true;
            parms._hidden = new int[]{20, 20};
            parms._seed = 912559L;
            parms._mini_batch_size = 50;
            dl = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            Assert.assertEquals((double)12.938076268040659, (double)((DeepLearningModel.DeepLearningModelOutput)dl._output)._training_metrics._MSE, (double)1.0E-6);
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (dl != null) {
                dl.deleteCrossValidationModels();
            }
            if (dl != null) {
                dl.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPretrainedAE() {
        Frame tfr = null;
        DeepLearningModel dl1 = null;
        DeepLearningModel dl2 = null;
        DeepLearningModel ae = null;
        try {
            tfr = DeepLearningTest.parse_test_file((String)"./smalldata/gbm_test/BostonHousing.csv");
            Vec r = tfr.remove("chas");
            tfr.add("chas", r.toCategoricalVec());
            DKV.put((Keyed)tfr);
            r.remove();
            Key key = Key.make((String)"ae_model");
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._ignored_columns = new String[]{"chas"};
            parms._activation = DeepLearningModel.DeepLearningParameters.Activation.TanhWithDropout;
            parms._reproducible = true;
            parms._hidden = new int[]{20, 20};
            parms._input_dropout_ratio = 0.1;
            parms._hidden_dropout_ratios = new double[]{0.2, 0.1};
            parms._autoencoder = true;
            parms._seed = 912559L;
            ae = (DeepLearningModel)new DeepLearning(parms, key).trainModel().get();
            Frame res = ae.score(tfr);
            Assert.assertTrue((boolean)ae.testJavaScoring(tfr, res, 1.0E-5));
            res.remove();
            parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._response_column = "chas";
            parms._activation = DeepLearningModel.DeepLearningParameters.Activation.TanhWithDropout;
            parms._reproducible = true;
            parms._hidden = new int[]{20, 20};
            parms._input_dropout_ratio = 0.1;
            parms._hidden_dropout_ratios = new double[]{0.2, 0.1};
            parms._seed = 912557L;
            parms._pretrained_autoencoder = key;
            parms._rate_decay = 1.0;
            parms._adaptive_rate = false;
            parms._rate_annealing = 0.001;
            parms._loss = DeepLearningModel.DeepLearningParameters.Loss.CrossEntropy;
            dl1 = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            res = dl1.score(tfr);
            Assert.assertTrue((boolean)dl1.testJavaScoring(tfr, res, 1.0E-5));
            res.remove();
            parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._response_column = "chas";
            parms._activation = DeepLearningModel.DeepLearningParameters.Activation.TanhWithDropout;
            parms._reproducible = true;
            parms._hidden = new int[]{20, 20};
            parms._input_dropout_ratio = 0.1;
            parms._hidden_dropout_ratios = new double[]{0.2, 0.1};
            parms._seed = 912557L;
            parms._rate_decay = 1.0;
            parms._adaptive_rate = false;
            parms._rate_annealing = 0.001;
            dl2 = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            res = dl2.score(tfr);
            Assert.assertTrue((boolean)dl2.testJavaScoring(tfr, res, 1.0E-5));
            res.remove();
            Log.info((Object[])new Object[]{"pretrained  : MSE=" + ((DeepLearningModel.DeepLearningModelOutput)dl1._output)._training_metrics.mse()});
            Log.info((Object[])new Object[]{"from scratch: MSE=" + ((DeepLearningModel.DeepLearningModelOutput)dl2._output)._training_metrics.mse()});
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (ae != null) {
                ae.delete();
            }
            if (dl1 != null) {
                dl1.delete();
            }
            if (dl2 != null) {
                dl2.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitialWeightsAndBiases() {
        Frame tfr = null;
        DeepLearningModel dl1 = null;
        DeepLearningModel dl2 = null;
        try {
            tfr = DeepLearningTest.parse_test_file((String)"./smalldata/gbm_test/BostonHousing.csv");
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._response_column = tfr.lastVecName();
            parms._activation = DeepLearningModel.DeepLearningParameters.Activation.Tanh;
            parms._reproducible = true;
            parms._hidden = new int[]{20, 20};
            parms._seed = 912557L;
            parms._export_weights_and_biases = true;
            dl1 = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._response_column = tfr.lastVecName();
            parms._activation = DeepLearningModel.DeepLearningParameters.Activation.Tanh;
            parms._reproducible = true;
            parms._hidden = new int[]{20, 20};
            parms._seed = 912557L;
            parms._initial_weights = ((DeepLearningModel.DeepLearningModelOutput)dl1._output).weights;
            parms._initial_biases = ((DeepLearningModel.DeepLearningModelOutput)dl1._output).biases;
            parms._epochs = 0.0;
            dl2 = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            Log.info((Object[])new Object[]{"dl1  : MSE=" + ((DeepLearningModel.DeepLearningModelOutput)dl1._output)._training_metrics.mse()});
            Log.info((Object[])new Object[]{"dl2  : MSE=" + ((DeepLearningModel.DeepLearningModelOutput)dl2._output)._training_metrics.mse()});
            Assert.assertTrue((Math.abs(((DeepLearningModel.DeepLearningModelOutput)dl1._output)._training_metrics.mse() - ((DeepLearningModel.DeepLearningModelOutput)dl2._output)._training_metrics.mse()) < 1.0E-6 ? 1 : 0) != 0);
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (dl1 != null) {
                dl1.delete();
            }
            if (dl2 != null) {
                dl2.delete();
            }
            for (Key f : ((DeepLearningModel.DeepLearningModelOutput)dl1._output).weights) {
                f.remove();
            }
            for (Key f : ((DeepLearningModel.DeepLearningModelOutput)dl1._output).biases) {
                f.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitialWeightsAndBiasesPartial() {
        Frame tfr = null;
        DeepLearningModel dl1 = null;
        DeepLearningModel dl2 = null;
        try {
            tfr = DeepLearningTest.parse_test_file((String)"./smalldata/gbm_test/BostonHousing.csv");
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._response_column = tfr.lastVecName();
            parms._activation = DeepLearningModel.DeepLearningParameters.Activation.Tanh;
            parms._reproducible = true;
            parms._hidden = new int[]{20, 20};
            parms._seed = 912557L;
            parms._export_weights_and_biases = true;
            dl1 = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._response_column = tfr.lastVecName();
            parms._activation = DeepLearningModel.DeepLearningParameters.Activation.Tanh;
            parms._reproducible = true;
            parms._hidden = new int[]{20, 20};
            parms._seed = 912557L;
            parms._initial_weights = ((DeepLearningModel.DeepLearningModelOutput)dl1._output).weights;
            parms._initial_biases = ((DeepLearningModel.DeepLearningModelOutput)dl1._output).biases;
            parms._initial_weights[1].remove();
            parms._initial_weights[1] = null;
            parms._initial_biases[0].remove();
            parms._initial_biases[0] = null;
            parms._epochs = 10.0;
            dl2 = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            Log.info((Object[])new Object[]{"dl1  : MSE=" + ((DeepLearningModel.DeepLearningModelOutput)dl1._output)._training_metrics.mse()});
            Log.info((Object[])new Object[]{"dl2  : MSE=" + ((DeepLearningModel.DeepLearningModelOutput)dl2._output)._training_metrics.mse()});
            Assert.assertTrue((((DeepLearningModel.DeepLearningModelOutput)dl1._output)._training_metrics.mse() > ((DeepLearningModel.DeepLearningModelOutput)dl2._output)._training_metrics.mse() ? 1 : 0) != 0);
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (dl1 != null) {
                dl1.delete();
            }
            if (dl2 != null) {
                dl2.delete();
            }
            for (Key f : ((DeepLearningModel.DeepLearningModelOutput)dl1._output).weights) {
                if (f == null) continue;
                f.remove();
            }
            for (Key f : ((DeepLearningModel.DeepLearningModelOutput)dl1._output).biases) {
                if (f == null) continue;
                f.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLaplace() {
        Frame tfr = null;
        DeepLearningModel dl = null;
        try {
            tfr = DeepLearningTest.parse_test_file((String)"./smalldata/gbm_test/BostonHousing.csv");
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._response_column = tfr.lastVecName();
            parms._reproducible = true;
            parms._hidden = new int[]{20, 20};
            parms._seed = 912559L;
            parms._distribution = DistributionFamily.laplace;
            dl = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            Assert.assertEquals((double)2.31398, (double)((ModelMetricsRegression)((DeepLearningModel.DeepLearningModelOutput)dl._output)._training_metrics)._mean_residual_deviance, (double)1.0E-5);
            Assert.assertEquals((double)14.889, (double)((ModelMetricsRegression)((DeepLearningModel.DeepLearningModelOutput)dl._output)._training_metrics)._MSE, (double)0.001);
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (dl != null) {
                dl.deleteCrossValidationModels();
            }
            if (dl != null) {
                dl.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGaussian() {
        Frame tfr = null;
        DeepLearningModel dl = null;
        try {
            tfr = DeepLearningTest.parse_test_file((String)"./smalldata/gbm_test/BostonHousing.csv");
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._response_column = tfr.lastVecName();
            parms._reproducible = true;
            parms._hidden = new int[]{20, 20};
            parms._seed = 912559L;
            parms._distribution = DistributionFamily.gaussian;
            dl = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            Assert.assertEquals((double)12.93808, (double)((ModelMetricsRegression)((DeepLearningModel.DeepLearningModelOutput)dl._output)._training_metrics)._mean_residual_deviance, (double)1.0E-5);
            Assert.assertEquals((double)12.93808, (double)((ModelMetricsRegression)((DeepLearningModel.DeepLearningModelOutput)dl._output)._training_metrics)._MSE, (double)1.0E-5);
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (dl != null) {
                dl.deleteCrossValidationModels();
            }
            if (dl != null) {
                dl.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHuberDeltaLarge() {
        Frame tfr = null;
        DeepLearningModel dl = null;
        try {
            tfr = DeepLearningTest.parse_test_file((String)"./smalldata/gbm_test/BostonHousing.csv");
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._response_column = tfr.lastVecName();
            parms._reproducible = true;
            parms._hidden = new int[]{20, 20};
            parms._seed = 912559L;
            parms._distribution = DistributionFamily.huber;
            parms._huber_alpha = 1.0;
            dl = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            Assert.assertEquals((double)12.93808, (double)((ModelMetricsRegression)((DeepLearningModel.DeepLearningModelOutput)dl._output)._training_metrics)._mean_residual_deviance, (double)0.7);
            Assert.assertEquals((double)12.93808, (double)((ModelMetricsRegression)((DeepLearningModel.DeepLearningModelOutput)dl._output)._training_metrics)._MSE, (double)0.7);
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (dl != null) {
                dl.deleteCrossValidationModels();
            }
            if (dl != null) {
                dl.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHuberDeltaTiny() {
        Frame tfr = null;
        DeepLearningModel dl = null;
        try {
            tfr = DeepLearningTest.parse_test_file((String)"./smalldata/gbm_test/BostonHousing.csv");
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._response_column = tfr.lastVecName();
            parms._reproducible = true;
            parms._hidden = new int[]{20, 20};
            parms._seed = 912559L;
            parms._distribution = DistributionFamily.huber;
            parms._huber_alpha = 0.01;
            dl = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            double delta = 0.011996;
            Assert.assertEquals((double)((4.62796 - delta) * delta), (double)((ModelMetricsRegression)((DeepLearningModel.DeepLearningModelOutput)dl._output)._training_metrics)._mean_residual_deviance, (double)0.02);
            Assert.assertEquals((double)19.856, (double)((ModelMetricsRegression)((DeepLearningModel.DeepLearningModelOutput)dl._output)._training_metrics)._MSE, (double)0.001);
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (dl != null) {
                dl.deleteCrossValidationModels();
            }
            if (dl != null) {
                dl.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHuber() {
        Frame tfr = null;
        DeepLearningModel dl = null;
        try {
            tfr = DeepLearningTest.parse_test_file((String)"./smalldata/gbm_test/BostonHousing.csv");
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._response_column = tfr.lastVecName();
            parms._reproducible = true;
            parms._hidden = new int[]{20, 20};
            parms._seed = 912559L;
            parms._distribution = DistributionFamily.huber;
            dl = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            Assert.assertEquals((double)6.4964976811, (double)((ModelMetricsRegression)((DeepLearningModel.DeepLearningModelOutput)dl._output)._training_metrics)._mean_residual_deviance, (double)1.0E-5);
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (dl != null) {
                dl.deleteCrossValidationModels();
            }
            if (dl != null) {
                dl.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCategoricalEncodingAUTO() {
        Frame tfr = null;
        DeepLearningModel dl = null;
        try {
            tfr = DeepLearningTest.parse_test_file((String)"./smalldata/junit/titanic_alt.csv");
            Vec v = tfr.remove("survived");
            tfr.add("survived", v.toCategoricalVec());
            v.remove();
            DKV.put((Keyed)tfr);
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._valid = tfr._key;
            parms._response_column = "survived";
            parms._reproducible = true;
            parms._hidden = new int[]{20, 20};
            parms._seed = 912559L;
            parms._nfolds = 3;
            parms._distribution = DistributionFamily.bernoulli;
            parms._categorical_encoding = Model.Parameters.CategoricalEncodingScheme.AUTO;
            dl = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            Assert.assertEquals((double)0.97329, (double)((ModelMetricsBinomial)((DeepLearningModel.DeepLearningModelOutput)dl._output)._training_metrics)._auc._auc, (double)0.001);
            Assert.assertEquals((double)0.97329, (double)((ModelMetricsBinomial)((DeepLearningModel.DeepLearningModelOutput)dl._output)._validation_metrics)._auc._auc, (double)0.001);
            Assert.assertEquals((double)0.93152, (double)((ModelMetricsBinomial)((DeepLearningModel.DeepLearningModelOutput)dl._output)._cross_validation_metrics)._auc._auc, (double)0.001);
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (dl != null) {
                dl.deleteCrossValidationModels();
            }
            if (dl != null) {
                dl.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCategoricalEncodingBinary() {
        Frame tfr = null;
        DeepLearningModel dl = null;
        try {
            String response = "survived";
            tfr = DeepLearningTest.parse_test_file((String)"./smalldata/junit/titanic_alt.csv");
            if (tfr.vec(response).isBinary()) {
                Vec v = tfr.remove(response);
                tfr.add(response, v.toCategoricalVec());
                v.remove();
            }
            DKV.put((Keyed)tfr);
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._valid = tfr._key;
            parms._response_column = response;
            parms._reproducible = true;
            parms._hidden = new int[]{20, 20};
            parms._seed = 912559L;
            parms._nfolds = 3;
            parms._categorical_encoding = Model.Parameters.CategoricalEncodingScheme.Binary;
            dl = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            Assert.assertEquals((double)0.94696, (double)((ModelMetricsBinomial)((DeepLearningModel.DeepLearningModelOutput)dl._output)._training_metrics)._auc._auc, (double)1.0E-4);
            Assert.assertEquals((double)0.94696, (double)((ModelMetricsBinomial)((DeepLearningModel.DeepLearningModelOutput)dl._output)._validation_metrics)._auc._auc, (double)1.0E-4);
            Assert.assertEquals((double)0.86556613, (double)((ModelMetricsBinomial)((DeepLearningModel.DeepLearningModelOutput)dl._output)._cross_validation_metrics)._auc._auc, (double)1.0E-4);
            int auc_row = Arrays.binarySearch(((DeepLearningModel.DeepLearningModelOutput)dl._output)._cross_validation_metrics_summary.getRowHeaders(), "auc");
            Assert.assertEquals((double)0.86556613, (double)Double.parseDouble((String)((DeepLearningModel.DeepLearningModelOutput)dl._output)._cross_validation_metrics_summary.get(auc_row, 0)), (double)0.01);
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (dl != null) {
                dl.deleteCrossValidationModels();
            }
            if (dl != null) {
                dl.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCategoricalEncodingEigen() {
        Frame tfr = null;
        Frame vfr = null;
        DeepLearningModel dl = null;
        try {
            Vec v;
            String response = "survived";
            tfr = DeepLearningTest.parse_test_file((String)"./smalldata/junit/titanic_alt.csv");
            vfr = DeepLearningTest.parse_test_file((String)"./smalldata/junit/titanic_alt.csv");
            if (tfr.vec(response).isBinary()) {
                v = tfr.remove(response);
                tfr.add(response, v.toCategoricalVec());
                v.remove();
            }
            if (vfr.vec(response).isBinary()) {
                v = vfr.remove(response);
                vfr.add(response, v.toCategoricalVec());
                v.remove();
            }
            DKV.put((Keyed)tfr);
            DKV.put((Keyed)vfr);
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._valid = vfr._key;
            parms._response_column = response;
            parms._reproducible = true;
            parms._hidden = new int[]{20, 20};
            parms._seed = 912559L;
            parms._categorical_encoding = Model.Parameters.CategoricalEncodingScheme.Eigen;
            parms._score_training_samples = 0L;
            dl = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            Assert.assertEquals((double)((ModelMetricsBinomial)((DeepLearningModel.DeepLearningModelOutput)dl._output)._training_metrics)._logloss, (double)((ModelMetricsBinomial)((DeepLearningModel.DeepLearningModelOutput)dl._output)._validation_metrics)._logloss, (double)1.0E-8);
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (vfr != null) {
                vfr.remove();
            }
            if (dl != null) {
                dl.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCategoricalEncodingEigenCV() {
        Frame tfr = null;
        DeepLearningModel dl = null;
        try {
            String response = "survived";
            tfr = DeepLearningTest.parse_test_file((String)"./smalldata/junit/titanic_alt.csv");
            if (tfr.vec(response).isBinary()) {
                Vec v = tfr.remove(response);
                tfr.add(response, v.toCategoricalVec());
                v.remove();
            }
            DKV.put((Keyed)tfr);
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._valid = tfr._key;
            parms._response_column = response;
            parms._reproducible = true;
            parms._hidden = new int[]{20, 20};
            parms._seed = 912559L;
            parms._nfolds = 3;
            parms._categorical_encoding = Model.Parameters.CategoricalEncodingScheme.Eigen;
            parms._score_training_samples = 0L;
            dl = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            Assert.assertEquals((double)0.9521718170580964, (double)((ModelMetricsBinomial)((DeepLearningModel.DeepLearningModelOutput)dl._output)._training_metrics)._auc._auc, (double)1.0E-4);
            Assert.assertEquals((double)0.9521656365883807, (double)((ModelMetricsBinomial)((DeepLearningModel.DeepLearningModelOutput)dl._output)._validation_metrics)._auc._auc, (double)1.0E-4);
            Assert.assertEquals((double)0.9115080346106303, (double)((ModelMetricsBinomial)((DeepLearningModel.DeepLearningModelOutput)dl._output)._cross_validation_metrics)._auc._auc, (double)1.0E-4);
            int auc_row = Arrays.binarySearch(((DeepLearningModel.DeepLearningModelOutput)dl._output)._cross_validation_metrics_summary.getRowHeaders(), "auc");
            Assert.assertEquals((double)0.913637, (double)Double.parseDouble((String)((DeepLearningModel.DeepLearningModelOutput)dl._output)._cross_validation_metrics_summary.get(auc_row, 0)), (double)1.0E-4);
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (dl != null) {
                dl.deleteCrossValidationModels();
            }
            if (dl != null) {
                dl.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCategoricalEncodingRegressionHuber() {
        Frame tfr = null;
        DeepLearningModel dl = null;
        try {
            String response = "age";
            tfr = DeepLearningTest.parse_test_file((String)"./smalldata/junit/titanic_alt.csv");
            if (tfr.vec(response).isBinary()) {
                Vec v = tfr.remove(response);
                tfr.add(response, v.toCategoricalVec());
                v.remove();
            }
            DKV.put((Keyed)tfr);
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = tfr._key;
            parms._valid = tfr._key;
            parms._response_column = response;
            parms._reproducible = true;
            parms._hidden = new int[]{20, 20};
            parms._seed = 912559L;
            parms._nfolds = 3;
            parms._distribution = DistributionFamily.huber;
            parms._categorical_encoding = Model.Parameters.CategoricalEncodingScheme.Binary;
            dl = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            Assert.assertEquals((double)87.26206135855, (double)((ModelMetricsRegression)((DeepLearningModel.DeepLearningModelOutput)dl._output)._training_metrics)._mean_residual_deviance, (double)1.0E-4);
            Assert.assertEquals((double)87.26206135855, (double)((ModelMetricsRegression)((DeepLearningModel.DeepLearningModelOutput)dl._output)._validation_metrics)._mean_residual_deviance, (double)1.0E-4);
            Assert.assertEquals((double)117.8014, (double)((ModelMetricsRegression)((DeepLearningModel.DeepLearningModelOutput)dl._output)._cross_validation_metrics)._mean_residual_deviance, (double)1.0E-4);
            int mean_residual_deviance_row = Arrays.binarySearch(((DeepLearningModel.DeepLearningModelOutput)dl._output)._cross_validation_metrics_summary.getRowHeaders(), "mean_residual_deviance");
            Assert.assertEquals((double)117.8014, (double)Double.parseDouble((String)((DeepLearningModel.DeepLearningModelOutput)dl._output)._cross_validation_metrics_summary.get(mean_residual_deviance_row, 0)), (double)1.0);
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (dl != null) {
                dl.deleteCrossValidationModels();
            }
            if (dl != null) {
                dl.delete();
            }
        }
    }

    @Ignore
    @Test
    public void testMultinomialMNIST() {
        Frame train = null;
        Frame preds = null;
        Frame small = null;
        Frame large = null;
        DeepLearningModel model = null;
        Scope.enter();
        try {
            File file = FileUtils.locateFile((String)"bigdata/laptop/mnist/train.csv.gz");
            if (file != null) {
                NFSFileVec trainfv = NFSFileVec.make((File)file);
                train = ParseDataset.parse((Key)Key.make(), (Key[])new Key[]{trainfv._key});
                int ci = train.find("C785");
                Scope.track((Vec)train.replace(ci, train.vecs()[ci].toCategoricalVec()));
                DKV.put((Keyed)train);
                DeepLearningModel.DeepLearningParameters p = new DeepLearningModel.DeepLearningParameters();
                p._train = train._key;
                p._response_column = "C785";
                p._activation = DeepLearningModel.DeepLearningParameters.Activation.RectifierWithDropout;
                p._hidden = new int[]{50, 50};
                p._epochs = 1.0;
                p._adaptive_rate = false;
                p._rate = 0.005;
                p._sparse = true;
                model = (DeepLearningModel)new DeepLearning(p).trainModel().get();
                FrameSplitter fs = new FrameSplitter(train, new double[]{1.0E-4}, new Key[]{Key.make((String)"small"), Key.make((String)"large")}, null);
                fs.compute2();
                small = fs.getResult()[0];
                large = fs.getResult()[1];
                preds = model.score(small);
                preds.remove(0);
                Vec labels = small.vec("C785");
                String[] fullDomain = train.vec("C785").domain();
                ModelMetricsMultinomial mm = ModelMetricsMultinomial.make((Frame)preds, (Vec)labels, (String[])fullDomain);
                Log.info((Object[])new Object[]{mm.toString()});
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
        finally {
            if (model != null) {
                model.delete();
            }
            if (preds != null) {
                preds.remove();
            }
            if (train != null) {
                train.remove();
            }
            if (small != null) {
                small.delete();
            }
            if (large != null) {
                large.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultinomial() {
        Frame train = null;
        Frame preds = null;
        DeepLearningModel model = null;
        Scope.enter();
        try {
            train = DeepLearningTest.parse_test_file((String)"./smalldata/junit/titanic_alt.csv");
            Vec v = train.remove("pclass");
            train.add("pclass", v.toCategoricalVec());
            v.remove();
            DKV.put((Keyed)train);
            DeepLearningModel.DeepLearningParameters p = new DeepLearningModel.DeepLearningParameters();
            p._train = train._key;
            p._response_column = "pclass";
            p._activation = DeepLearningModel.DeepLearningParameters.Activation.RectifierWithDropout;
            p._hidden = new int[]{50, 50};
            p._epochs = 1.0;
            p._adaptive_rate = false;
            p._rate = 0.005;
            p._sparse = true;
            model = (DeepLearningModel)new DeepLearning(p).trainModel().get();
            preds = model.score(train);
            preds.remove(0);
            Vec labels = train.vec("pclass");
            String[] fullDomain = train.vec("pclass").domain();
            ModelMetricsMultinomial mm = ModelMetricsMultinomial.make((Frame)preds, (Vec)labels, (String[])fullDomain);
            Log.info((Object[])new Object[]{mm.toString()});
        }
        finally {
            if (model != null) {
                model.delete();
            }
            if (preds != null) {
                preds.remove();
            }
            if (train != null) {
                train.remove();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    @Test
    public void testBinomial() {
        Frame train = null;
        Frame preds = null;
        Frame small = null;
        Frame large = null;
        DeepLearningModel model = null;
        Scope.enter();
        try {
            train = DeepLearningTest.parse_test_file((String)"./smalldata/junit/titanic_alt.csv");
            Vec v = train.remove("survived");
            train.add("survived", v.toCategoricalVec());
            v.remove();
            DKV.put((Keyed)train);
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = train._key;
            parms._response_column = "survived";
            parms._reproducible = true;
            parms._hidden = new int[]{20, 20};
            parms._seed = 912559L;
            model = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            FrameSplitter fs = new FrameSplitter(train, new double[]{0.002}, new Key[]{Key.make((String)"small"), Key.make((String)"large")}, null);
            fs.compute2();
            small = fs.getResult()[0];
            large = fs.getResult()[1];
            preds = model.score(small);
            Vec labels = small.vec("survived");
            String[] fullDomain = train.vec("survived").domain();
            ModelMetricsBinomial mm = ModelMetricsBinomial.make((Vec)preds.vec(2), (Vec)labels, (String[])fullDomain);
            Log.info((Object[])new Object[]{mm.toString()});
            mm = ModelMetricsBinomial.make((Vec)preds.vec(2), (Vec)labels, (String[])new String[]{"0", "1"});
            Log.info((Object[])new Object[]{mm.toString()});
            mm = ModelMetricsBinomial.make((Vec)preds.vec(2), (Vec)labels);
            Log.info((Object[])new Object[]{mm.toString()});
            try {
                mm = ModelMetricsBinomial.make((Vec)preds.vec(2), (Vec)labels, (String[])new String[]{"a", "b"});
                Log.info((Object[])new Object[]{mm.toString()});
                Assert.assertFalse((boolean)true);
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
        finally {
            if (model != null) {
                model.delete();
            }
            if (preds != null) {
                preds.remove();
            }
            if (train != null) {
                train.remove();
            }
            if (small != null) {
                small.delete();
            }
            if (large != null) {
                large.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    @Test
    public void testRegression() {
        Frame train = null;
        Frame preds = null;
        DeepLearningModel model = null;
        Scope.enter();
        try {
            train = DeepLearningTest.parse_test_file((String)"./smalldata/junit/titanic_alt.csv");
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = train._key;
            parms._response_column = "age";
            parms._reproducible = true;
            parms._hidden = new int[]{20, 20};
            parms._distribution = DistributionFamily.laplace;
            parms._seed = 912559L;
            model = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            preds = model.score(train);
            Vec targets = train.vec("age");
            ModelMetricsRegression mm = ModelMetricsRegression.make((Vec)preds.vec(0), (Vec)targets, (DistributionFamily)parms._distribution);
            Log.info((Object[])new Object[]{mm.toString()});
            mm = ModelMetricsRegression.make((Vec)preds.vec(0), (Vec)targets, (DistributionFamily)DistributionFamily.gaussian);
            Log.info((Object[])new Object[]{mm.toString()});
            mm = ModelMetricsRegression.make((Vec)preds.vec(0), (Vec)targets, (DistributionFamily)DistributionFamily.poisson);
            Log.info((Object[])new Object[]{mm.toString()});
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
        finally {
            if (model != null) {
                model.delete();
            }
            if (preds != null) {
                preds.remove();
            }
            if (train != null) {
                train.remove();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    @Test
    public void testEigenEncodingLogic() {
        int numNoncatColumns = 1;
        int[] catSizes = new int[]{16};
        String[] catNames = new String[]{"sixteen"};
        Assert.assertEquals((long)catSizes.length, (long)catNames.length);
        int totalExpectedColumns = numNoncatColumns + catSizes.length;
        double[] expectedMean = new double[]{0.0453};
        Key frameKey = Key.make();
        CreateFrame cf = new CreateFrame(frameKey);
        cf.rows = 100000L;
        cf.cols = numNoncatColumns;
        cf.categorical_fraction = 0.0;
        cf.seed = 1234L;
        cf.integer_fraction = 0.3;
        cf.binary_fraction = 0.1;
        cf.time_fraction = 0.2;
        cf.string_fraction = 0.1;
        Frame mainFrame = (Frame)cf.execImpl().get();
        assert (mainFrame != null) : "Unable to create a frame";
        Frame[] auxFrames = new Frame[catSizes.length];
        Frame transformedFrame = null;
        try {
            int i;
            for (int i2 = 0; i2 < catSizes.length; ++i2) {
                CreateFrame ccf = new CreateFrame();
                ccf.rows = 100000L;
                ccf.cols = 1;
                ccf.categorical_fraction = 1.0;
                ccf.integer_fraction = 0.0;
                ccf.binary_fraction = 0.0;
                ccf.seed = 1234L;
                ccf.time_fraction = 0.0;
                ccf.string_fraction = 0.0;
                ccf.factors = catSizes[i2];
                auxFrames[i2] = (Frame)ccf.execImpl().get();
                auxFrames[i2]._names[0] = catNames[i2];
                mainFrame.add(auxFrames[i2]);
            }
            Log.info((Object[])new Object[]{mainFrame, 0, 100});
            Frame[] cbed = new FrameUtils.CategoricalEigenEncoder(new DeepLearning(new DeepLearningModel.DeepLearningParameters()).getToEigenVec(), mainFrame, null);
            transformedFrame = (Frame)cbed.exec().get();
            assert (transformedFrame != null) : "Unable to transform a frame";
            Assert.assertEquals((String)"Wrong number of columns after converting to eigen encoding", (long)totalExpectedColumns, (long)transformedFrame.numCols());
            for (i = 0; i < numNoncatColumns; ++i) {
                Assert.assertEquals((Object)mainFrame.name(i), (Object)transformedFrame.name(i));
                Assert.assertEquals((long)mainFrame.types()[i], (long)transformedFrame.types()[i]);
            }
            for (i = numNoncatColumns; i < transformedFrame.numCols(); ++i) {
                Assert.assertTrue((String)("A categorical column should be transformed into one numeric one (col " + i + ")"), (boolean)transformedFrame.vec(i).isNumeric());
                Assert.assertEquals((String)"Transformed categorical column should carry the name of the original column", (Object)transformedFrame.name(i), (Object)(mainFrame.name(i) + ".Eigen"));
                Assert.assertEquals((String)"Transformed categorical column should have the correct mean value", (double)expectedMean[i - numNoncatColumns], (double)transformedFrame.vec(i).mean(), (double)5.0E-4);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            mainFrame.delete();
            if (transformedFrame != null) {
                transformedFrame.delete();
            }
            for (Frame f : auxFrames) {
                if (f == null) continue;
                f.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckpointOverwriteWithBestModel() {
        Frame tfr = null;
        DeepLearningModel dl = null;
        DeepLearningModel dl2 = null;
        Frame train = null;
        Frame valid = null;
        try {
            tfr = DeepLearningTest.parse_test_file((String)"./smalldata/iris/iris.csv");
            FrameSplitter fs = new FrameSplitter(tfr, new double[]{0.8}, new Key[]{Key.make((String)"train"), Key.make((String)"valid")}, null);
            fs.compute2();
            train = fs.getResult()[0];
            valid = fs.getResult()[1];
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = train._key;
            parms._valid = valid._key;
            parms._epochs = 1.0;
            parms._response_column = "C5";
            parms._reproducible = true;
            parms._hidden = new int[]{50, 50};
            parms._seed = 912559L;
            parms._train_samples_per_iteration = 0L;
            parms._score_duty_cycle = 1.0;
            parms._score_interval = 0.0;
            parms._stopping_rounds = 0;
            parms._overwrite_with_best_model = true;
            dl = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            double ll1 = ((ModelMetricsMultinomial)((DeepLearningModel.DeepLearningModelOutput)dl._output)._validation_metrics).logloss();
            DeepLearningModel.DeepLearningParameters parms2 = (DeepLearningModel.DeepLearningParameters)parms.clone();
            parms2._epochs = 10.0;
            parms2._checkpoint = dl._key;
            dl2 = (DeepLearningModel)new DeepLearning(parms2).trainModel().get();
            double ll2 = ((ModelMetricsMultinomial)((DeepLearningModel.DeepLearningModelOutput)dl2._output)._validation_metrics).logloss();
            Assert.assertTrue((ll2 <= ll1 ? 1 : 0) != 0);
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (dl != null) {
                dl.delete();
            }
            if (dl2 != null) {
                dl2.delete();
            }
            if (train != null) {
                train.delete();
            }
            if (valid != null) {
                valid.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckpointOverwriteWithBestModel2() {
        Frame tfr = null;
        DeepLearningModel dl = null;
        DeepLearningModel dl2 = null;
        Frame train = null;
        Frame valid = null;
        try {
            tfr = DeepLearningTest.parse_test_file((String)"./smalldata/iris/iris.csv");
            FrameSplitter fs = new FrameSplitter(tfr, new double[]{0.8}, new Key[]{Key.make((String)"train"), Key.make((String)"valid")}, null);
            fs.compute2();
            train = fs.getResult()[0];
            valid = fs.getResult()[1];
            DeepLearningModel.DeepLearningParameters parms = new DeepLearningModel.DeepLearningParameters();
            parms._train = train._key;
            parms._valid = valid._key;
            parms._epochs = 10.0;
            parms._response_column = "C5";
            parms._reproducible = true;
            parms._hidden = new int[]{50, 50};
            parms._seed = 912559L;
            parms._train_samples_per_iteration = 0L;
            parms._score_duty_cycle = 1.0;
            parms._score_interval = 0.0;
            parms._stopping_rounds = 0;
            parms._overwrite_with_best_model = true;
            dl = (DeepLearningModel)new DeepLearning(parms).trainModel().get();
            double ll1 = ((ModelMetricsMultinomial)((DeepLearningModel.DeepLearningModelOutput)dl._output)._validation_metrics).logloss();
            DeepLearningModel.DeepLearningParameters parms2 = (DeepLearningModel.DeepLearningParameters)parms.clone();
            parms2._epochs = 20.0;
            parms2._checkpoint = dl._key;
            dl2 = (DeepLearningModel)new DeepLearning(parms2).trainModel().get();
            double ll2 = ((ModelMetricsMultinomial)((DeepLearningModel.DeepLearningModelOutput)dl2._output)._validation_metrics).logloss();
            Assert.assertTrue((ll2 <= ll1 ? 1 : 0) != 0);
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (dl != null) {
                dl.delete();
            }
            if (dl2 != null) {
                dl2.delete();
            }
            if (train != null) {
                train.delete();
            }
            if (valid != null) {
                valid.delete();
            }
        }
    }

    static class PrintEntries
    extends MRTask<PrintEntries> {
        PrintEntries() {
        }

        public void map(Chunk[] cs) {
            StringBuilder sb = new StringBuilder();
            for (int r = 0; r < cs[0].len(); ++r) {
                sb.append("Row " + (cs[0].start() + (long)r) + ": ");
                for (int i = 0; i < cs.length; ++i) {
                    if (i == 0) {
                        sb.append("response: " + this._fr.vec(i).domain()[(int)cs[i].at8(r)] + " ");
                    }
                    if (cs[i].atd(r) == 0.0) continue;
                    sb.append(i + ":" + cs[i].atd(r) + " ");
                }
                sb.append("\n");
            }
            Log.info((Object[])new Object[]{sb});
        }
    }

    static abstract class PrepData {
        PrepData() {
        }

        abstract int prep(Frame var1);
    }
}

