/*
 * Decompiled with CFR 0.152.
 */
package hex.deeplearning;

import hex.Model;
import hex.ModelMetricsBinomial;
import hex.ScoreKeeper;
import hex.deeplearning.DeepLearning;
import hex.deeplearning.DeepLearningModel;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import water.DKV;
import water.Key;
import water.Keyed;
import water.Scope;
import water.TestUtil;
import water.fvec.Frame;
import water.fvec.NFSFileVec;
import water.fvec.Vec;
import water.parser.ParseDataset;
import water.util.Log;

public class DeepLearningSpiralsTest
extends TestUtil {
    @BeforeClass
    public static void setup() {
        DeepLearningSpiralsTest.stall_till_cloudsize((int)1);
    }

    @Test
    public void run() {
        Scope.enter();
        NFSFileVec nfs = TestUtil.makeNfsFileVec((String)"smalldata/junit/two_spiral.csv");
        Frame frame = ParseDataset.parse((Key)Key.make(), (Key[])new Key[]{nfs._key});
        Log.info((Object[])new Object[]{frame});
        int resp = frame.names().length - 1;
        for (boolean sparse : new boolean[]{true, false}) {
            for (boolean col_major : new boolean[]{false}) {
                if (!sparse && col_major) continue;
                Key model_id = Key.make();
                DeepLearningModel.DeepLearningParameters p = new DeepLearningModel.DeepLearningParameters();
                p._epochs = 5000.0;
                p._hidden = new int[]{100};
                p._sparse = sparse;
                p._col_major = col_major;
                p._activation = DeepLearningModel.DeepLearningParameters.Activation.Tanh;
                p._initial_weight_distribution = DeepLearningModel.DeepLearningParameters.InitialWeightDistribution.Normal;
                p._initial_weight_scale = 2.5;
                p._loss = DeepLearningModel.DeepLearningParameters.Loss.CrossEntropy;
                p._train = frame._key;
                p._response_column = frame.names()[resp];
                Scope.track((Vec)frame.replace(resp, frame.vecs()[resp].toCategoricalVec()));
                DKV.put((Keyed)frame);
                p._rho = 0.99;
                p._epsilon = 0.005;
                p._classification_stop = 0.0;
                p._train_samples_per_iteration = 10000L;
                p._stopping_rounds = 5;
                p._stopping_metric = ScoreKeeper.StoppingMetric.misclassification;
                p._score_each_iteration = true;
                p._reproducible = true;
                p._seed = 1234L;
                new DeepLearning(p, model_id).trainModel().get();
                DeepLearningModel mymodel = (DeepLearningModel)DKV.getGet((Key)model_id);
                Frame pred = mymodel.score(frame);
                ModelMetricsBinomial mm = ModelMetricsBinomial.getFromDKV((Model)mymodel, (Frame)frame);
                double error = mm._auc.defaultErr();
                Log.info((Object[])new Object[]{"Error: " + error});
                if (error > 0.1) {
                    Assert.fail((String)("Test classification error is not <= 0.1, but " + error + "."));
                }
                Assert.assertTrue((boolean)mymodel.testJavaScoring(frame, pred, 1.0E-6));
                pred.delete();
                mymodel.delete();
            }
        }
        frame.delete();
        Scope.exit((Key[])new Key[0]);
    }
}

