/*
 * Decompiled with CFR 0.152.
 */
package hex.deeplearning;

import hex.deeplearning.DeepLearning;
import hex.deeplearning.DeepLearningModel;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import water.DKV;
import water.H2O;
import water.Key;
import water.TestUtil;
import water.fvec.Frame;
import water.fvec.NFSFileVec;
import water.fvec.RebalanceDataSet;
import water.fvec.Vec;
import water.parser.ParseDataset;

public class DeepLearningScoreTest
extends TestUtil {
    @BeforeClass
    public static void setup() {
        DeepLearningScoreTest.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPubDev928() {
        Key rebalancedKey = Key.make((String)"rebalanced");
        NFSFileVec nfs = TestUtil.makeNfsFileVec((String)"smalldata/logreg/prostate.csv");
        Frame fr = ParseDataset.parse((Key)Key.make(), (Key[])new Key[]{nfs._key});
        RebalanceDataSet rb = new RebalanceDataSet(fr, rebalancedKey, (int)(fr.numRows() + 1L));
        H2O.submitTask((H2O.H2OCountedCompleter)rb);
        rb.join();
        Frame rebalanced = (Frame)DKV.get((Key)rebalancedKey).get();
        this.assertZeroLengthChunk("Rebalanced dataset should contain at least one 0-len chunk!", rebalanced.anyVec());
        DeepLearningModel dlModel = null;
        try {
            DeepLearningModel.DeepLearningParameters dlParams = new DeepLearningModel.DeepLearningParameters();
            dlParams._train = rebalancedKey;
            dlParams._epochs = 5.0;
            dlParams._response_column = "CAPSULE";
            dlModel = (DeepLearningModel)new DeepLearning(dlParams).trainModel().get();
        }
        finally {
            fr.delete();
            rebalanced.delete();
            if (dlModel != null) {
                dlModel.delete();
            }
        }
    }

    private void assertZeroLengthChunk(String msg, Vec v) {
        boolean hasZeroLenChunk = false;
        for (int i = 0; i < v.nChunks(); ++i) {
            hasZeroLenChunk |= v.chunkForChunkIdx(i).len() == 0;
            System.out.println(v.chunkForChunkIdx(i).len());
        }
        Assert.assertTrue((String)msg, (boolean)hasZeroLenChunk);
    }
}

