/*
 * Decompiled with CFR 0.152.
 */
package hex.deeplearning;

import hex.deeplearning.DeepLearning;
import hex.deeplearning.DeepLearningModel;
import java.util.Arrays;
import java.util.TreeMap;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import water.DKV;
import water.Key;
import water.Keyed;
import water.Scope;
import water.TestUtil;
import water.fvec.Frame;
import water.fvec.NFSFileVec;
import water.fvec.Vec;
import water.parser.ParseDataset;
import water.util.FrameUtils;
import water.util.Log;

public class DeepLearningReproducibilityTest
extends TestUtil {
    @BeforeClass
    public static void setup() {
        DeepLearningReproducibilityTest.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Test
    public void run() {
        NFSFileVec ff = TestUtil.makeNfsFileVec((String)"smalldata/junit/weather.csv");
        Frame golden = ParseDataset.parse((Key)Key.make((String)"golden.hex"), (Key[])new Key[]{ff._key});
        DeepLearningModel mymodel = null;
        Frame train = null;
        Frame test = null;
        Frame data = null;
        TreeMap<Integer, Float> repeatErrs = new TreeMap<Integer, Float>();
        int N = 3;
        StringBuilder sb = new StringBuilder();
        float repro_error = 0.0f;
        for (boolean repro : new boolean[]{true, false}) {
            void var18_20;
            Scope.enter();
            Frame[] preds = new Frame[N];
            long[] checksums = new long[N];
            double[] numbers = new double[N];
            boolean bl = false;
            while (var18_20 < N) {
                try {
                    NFSFileVec file = TestUtil.makeNfsFileVec((String)"smalldata/junit/weather.csv");
                    data = ParseDataset.parse((Key)Key.make((String)"data.hex"), (Key[])new Key[]{file._key});
                    TestUtil.assertBitIdentical((Frame)data, (Frame)golden);
                    train = data;
                    test = data;
                    DeepLearningModel.DeepLearningParameters p = new DeepLearningModel.DeepLearningParameters();
                    p._train = train._key;
                    p._valid = test._key;
                    p._response_column = train.names()[train.names().length - 1];
                    int n = train.names().length - 1;
                    Scope.track((Vec)train.replace(n, train.vecs()[n].toCategoricalVec()));
                    DKV.put((Keyed)train);
                    p._ignored_columns = new String[]{"EvapMM", "RISK_MM"};
                    p._activation = DeepLearningModel.DeepLearningParameters.Activation.RectifierWithDropout;
                    p._hidden = new int[]{32, 58};
                    p._l1 = 1.0E-5;
                    p._l2 = 3.0E-5;
                    p._seed = 48830L;
                    p._loss = DeepLearningModel.DeepLearningParameters.Loss.CrossEntropy;
                    p._input_dropout_ratio = 0.2;
                    p._train_samples_per_iteration = 3L;
                    p._hidden_dropout_ratios = new double[]{0.4, 0.1};
                    p._epochs = 1.32;
                    p._quiet_mode = true;
                    p._reproducible = repro;
                    DeepLearning dl = new DeepLearning(p);
                    mymodel = (DeepLearningModel)dl.trainModel().get();
                    preds[var18_20] = mymodel.score(test);
                    for (int i = 0; i < 5; ++i) {
                        Frame tmp = mymodel.score(test);
                        DeepLearningReproducibilityTest.assertBitIdentical((Frame)preds[var18_20], (Frame)tmp);
                        tmp.delete();
                    }
                    Log.info((Object[])new Object[]{"Prediction:\n" + FrameUtils.chunkSummary((Frame)preds[var18_20]).toString()});
                    numbers[var18_20] = mymodel.model_info().get_weights(0).get(23, 4);
                    checksums[var18_20] = mymodel.model_info().checksum_impl();
                    repeatErrs.put((int)var18_20, Float.valueOf(mymodel.loss()));
                }
                finally {
                    if (mymodel != null) {
                        mymodel.delete();
                    }
                    if (train != null) {
                        train.delete();
                    }
                    if (test != null) {
                        test.delete();
                    }
                    if (data != null) {
                        data.delete();
                    }
                }
                ++var18_20;
            }
            sb.append("Reproducibility: ").append(repro ? "on" : "off").append("\n");
            sb.append("Repeat # --> Validation Loss\n");
            for (String string : Arrays.toString(repeatErrs.entrySet().toArray()).split(",")) {
                sb.append(string.replace("=", " --> ")).append("\n");
            }
            sb.append('\n');
            Log.info((Object[])new Object[]{sb.toString()});
            try {
                if (repro) {
                    int p;
                    double[] dArray = numbers;
                    int file = dArray.length;
                    for (p = 0; p < file; ++p) {
                        double d = dArray[p];
                        Assert.assertTrue((String)Arrays.toString(numbers), (d == numbers[0] ? 1 : 0) != 0);
                    }
                    for (Float error : repeatErrs.values()) {
                        Assert.assertTrue((boolean)error.equals(repeatErrs.get(0)));
                    }
                    for (long l : checksums) {
                        Assert.assertTrue((l == checksums[0] ? 1 : 0) != 0);
                    }
                    Frame[] frameArray = preds;
                    int n = frameArray.length;
                    for (p = 0; p < n; ++p) {
                        Frame frame = frameArray[p];
                        for (int i = 0; i < frame.vecs().length; ++i) {
                            TestUtil.assertVecEquals((Vec)frame.vecs()[i], (Vec)preds[0].vecs()[i], (double)1.0E-5);
                        }
                    }
                    repro_error = ((Float)repeatErrs.get(0)).floatValue();
                } else {
                    double d = 0.0;
                    for (Float f : repeatErrs.values()) {
                        d += (double)f.floatValue();
                    }
                    d /= (double)N;
                    for (int i = 1; i < N; ++i) {
                        Assert.assertTrue((repeatErrs.get(i) != repeatErrs.get(0) ? 1 : 0) != 0);
                    }
                    Log.info((Object[])new Object[]{"mean error: " + d});
                    double stddev = 0.0;
                    for (Float error : repeatErrs.values()) {
                        stddev += ((double)error.floatValue() - d) * ((double)error.floatValue() - d);
                    }
                    stddev /= (double)N;
                    stddev = Math.sqrt(stddev);
                    Log.info((Object[])new Object[]{"standard deviation: " + stddev});
                    Log.info((Object[])new Object[]{"difference to reproducible mode: " + Math.abs(d - (double)repro_error) / stddev + " standard deviations"});
                }
            }
            finally {
                for (Frame frame : preds) {
                    if (frame == null) continue;
                    frame.delete();
                }
            }
            Scope.exit((Key[])new Key[0]);
        }
        golden.delete();
    }
}

