/*
 * Decompiled with CFR 0.152.
 */
package hex.deeplearning;

import hex.deeplearning.DeepLearningModel;
import hex.genmodel.GenModel;
import java.text.DecimalFormat;
import java.util.Random;
import org.junit.Ignore;
import water.util.ArrayUtils;
import water.util.RandomUtils;

@Ignore
public class DeepLearningMLPReference {
    static final DecimalFormat _format = new DecimalFormat("0.000");
    double[][] _trainData;
    double[][] _testData;
    NeuralNetwork _nn;

    public void init(DeepLearningModel.DeepLearningParameters.Activation activation, Random rand, double holdout_ratio, int numHidden) {
        double[][] ds = new double[150][];
        int r = 0;
        ds[r++] = new double[]{5.1, 3.5, 1.4, 0.2, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{4.9, 3.0, 1.4, 0.2, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{4.7, 3.2, 1.3, 0.2, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{4.6, 3.1, 1.5, 0.2, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{5.0, 3.6, 1.4, 0.2, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{5.4, 3.9, 1.7, 0.4, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{4.6, 3.4, 1.4, 0.3, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{5.0, 3.4, 1.5, 0.2, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{4.4, 2.9, 1.4, 0.2, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{4.9, 3.1, 1.5, 0.1, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{5.4, 3.7, 1.5, 0.2, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{4.8, 3.4, 1.6, 0.2, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{4.8, 3.0, 1.4, 0.1, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{4.3, 3.0, 1.1, 0.1, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{5.8, 4.0, 1.2, 0.2, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{5.7, 4.4, 1.5, 0.4, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{5.4, 3.9, 1.3, 0.4, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{5.1, 3.5, 1.4, 0.3, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{5.7, 3.8, 1.7, 0.3, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{5.1, 3.8, 1.5, 0.3, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{5.4, 3.4, 1.7, 0.2, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{5.1, 3.7, 1.5, 0.4, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{4.6, 3.6, 1.0, 0.2, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{5.1, 3.3, 1.7, 0.5, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{4.8, 3.4, 1.9, 0.2, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{5.0, 3.0, 1.6, 0.2, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{5.0, 3.4, 1.6, 0.4, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{5.2, 3.5, 1.5, 0.2, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{5.2, 3.4, 1.4, 0.2, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{4.7, 3.2, 1.6, 0.2, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{4.8, 3.1, 1.6, 0.2, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{5.4, 3.4, 1.5, 0.4, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{5.2, 4.1, 1.5, 0.1, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{5.5, 4.2, 1.4, 0.2, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{4.9, 3.1, 1.5, 0.1, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{5.0, 3.2, 1.2, 0.2, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{5.5, 3.5, 1.3, 0.2, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{4.9, 3.1, 1.5, 0.1, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{4.4, 3.0, 1.3, 0.2, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{5.1, 3.4, 1.5, 0.2, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{5.0, 3.5, 1.3, 0.3, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{4.5, 2.3, 1.3, 0.3, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{4.4, 3.2, 1.3, 0.2, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{5.0, 3.5, 1.6, 0.6, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{5.1, 3.8, 1.9, 0.4, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{4.8, 3.0, 1.4, 0.3, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{5.1, 3.8, 1.6, 0.2, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{4.6, 3.2, 1.4, 0.2, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{5.3, 3.7, 1.5, 0.2, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{5.0, 3.3, 1.4, 0.2, 0.0, 0.0, 1.0};
        ds[r++] = new double[]{7.0, 3.2, 4.7, 1.4, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{6.4, 3.2, 4.5, 1.5, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{6.9, 3.1, 4.9, 1.5, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{5.5, 2.3, 4.0, 1.3, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{6.5, 2.8, 4.6, 1.5, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{5.7, 2.8, 4.5, 1.3, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{6.3, 3.3, 4.7, 1.6, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{4.9, 2.4, 3.3, 1.0, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{6.6, 2.9, 4.6, 1.3, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{5.2, 2.7, 3.9, 1.4, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{5.0, 2.0, 3.5, 1.0, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{5.9, 3.0, 4.2, 1.5, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{6.0, 2.2, 4.0, 1.0, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{6.1, 2.9, 4.7, 1.4, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{5.6, 2.9, 3.6, 1.3, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{6.7, 3.1, 4.4, 1.4, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{5.6, 3.0, 4.5, 1.5, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{5.8, 2.7, 4.1, 1.0, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{6.2, 2.2, 4.5, 1.5, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{5.6, 2.5, 3.9, 1.1, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{5.9, 3.2, 4.8, 1.8, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{6.1, 2.8, 4.0, 1.3, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{6.3, 2.5, 4.9, 1.5, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{6.1, 2.8, 4.7, 1.2, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{6.4, 2.9, 4.3, 1.3, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{6.6, 3.0, 4.4, 1.4, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{6.8, 2.8, 4.8, 1.4, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{6.7, 3.0, 5.0, 1.7, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{6.0, 2.9, 4.5, 1.5, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{5.7, 2.6, 3.5, 1.0, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{5.5, 2.4, 3.8, 1.1, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{5.5, 2.4, 3.7, 1.0, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{5.8, 2.7, 3.9, 1.2, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{6.0, 2.7, 5.1, 1.6, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{5.4, 3.0, 4.5, 1.5, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{6.0, 3.4, 4.5, 1.6, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{6.7, 3.1, 4.7, 1.5, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{6.3, 2.3, 4.4, 1.3, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{5.6, 3.0, 4.1, 1.3, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{5.5, 2.5, 4.0, 1.3, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{5.5, 2.6, 4.4, 1.2, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{6.1, 3.0, 4.6, 1.4, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{5.8, 2.6, 4.0, 1.2, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{5.0, 2.3, 3.3, 1.0, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{5.6, 2.7, 4.2, 1.3, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{5.7, 3.0, 4.2, 1.2, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{5.7, 2.9, 4.2, 1.3, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{6.2, 2.9, 4.3, 1.3, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{5.1, 2.5, 3.0, 1.1, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{5.7, 2.8, 4.1, 1.3, 0.0, 1.0, 0.0};
        ds[r++] = new double[]{6.3, 3.3, 6.0, 2.5, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{5.8, 2.7, 5.1, 1.9, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{7.1, 3.0, 5.9, 2.1, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{6.3, 2.9, 5.6, 1.8, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{6.5, 3.0, 5.8, 2.2, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{7.6, 3.0, 6.6, 2.1, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{4.9, 2.5, 4.5, 1.7, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{7.3, 2.9, 6.3, 1.8, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{6.7, 2.5, 5.8, 1.8, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{7.2, 3.6, 6.1, 2.5, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{6.5, 3.2, 5.1, 2.0, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{6.4, 2.7, 5.3, 1.9, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{6.8, 3.0, 5.5, 2.1, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{5.7, 2.5, 5.0, 2.0, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{5.8, 2.8, 5.1, 2.4, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{6.4, 3.2, 5.3, 2.3, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{6.5, 3.0, 5.5, 1.8, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{7.7, 3.8, 6.7, 2.2, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{7.7, 2.6, 6.9, 2.3, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{6.0, 2.2, 5.0, 1.5, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{6.9, 3.2, 5.7, 2.3, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{5.6, 2.8, 4.9, 2.0, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{7.7, 2.8, 6.7, 2.0, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{6.3, 2.7, 4.9, 1.8, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{6.7, 3.3, 5.7, 2.1, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{7.2, 3.2, 6.0, 1.8, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{6.2, 2.8, 4.8, 1.8, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{6.1, 3.0, 4.9, 1.8, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{6.4, 2.8, 5.6, 2.1, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{7.2, 3.0, 5.8, 1.6, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{7.4, 2.8, 6.1, 1.9, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{7.9, 3.8, 6.4, 2.0, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{6.4, 2.8, 5.6, 2.2, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{6.3, 2.8, 5.1, 1.5, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{6.1, 2.6, 5.6, 1.4, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{7.7, 3.0, 6.1, 2.3, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{6.3, 3.4, 5.6, 2.4, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{6.4, 3.1, 5.5, 1.8, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{6.0, 3.0, 4.8, 1.8, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{6.9, 3.1, 5.4, 2.1, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{6.7, 3.1, 5.6, 2.4, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{6.9, 3.1, 5.1, 2.3, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{5.8, 2.7, 5.1, 1.9, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{6.8, 3.2, 5.9, 2.3, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{6.7, 3.3, 5.7, 2.5, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{6.7, 3.0, 5.2, 2.3, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{6.3, 2.5, 5.0, 1.9, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{6.5, 3.0, 5.2, 2.0, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{6.2, 3.4, 5.4, 2.3, 1.0, 0.0, 0.0};
        ds[r++] = new double[]{5.9, 3.0, 5.1, 1.8, 1.0, 0.0, 0.0};
        double[][] allData = new double[ds.length][ds[0].length];
        for (int j = 0; j < allData.length; ++j) {
            for (int i = 0; i < allData[j].length; ++i) {
                allData[j][i] = ds[j][i];
            }
            allData[j][4] = ds[j][6];
            allData[j][5] = ds[j][5];
            allData[j][6] = ds[j][4];
        }
        int trainRows = (int)((double)allData.length * holdout_ratio);
        int testRows = allData.length - trainRows;
        this._trainData = new double[trainRows][];
        this._testData = new double[testRows][];
        this.MakeTrainTest(allData, this._trainData, this._testData, rand);
        for (int i = 0; i < 4; ++i) {
            int n;
            double mean = 0.0;
            for (int n2 = 0; n2 < this._trainData.length; ++n2) {
                mean += this._trainData[n2][i];
            }
            mean /= (double)this._trainData.length;
            double sigma = 0.0;
            for (n = 0; n < this._trainData.length; ++n) {
                double d = this._trainData[n][i] - mean;
                sigma += d * d;
            }
            sigma = Math.sqrt(sigma / (double)(this._trainData.length - 1));
            for (n = 0; n < this._trainData.length; ++n) {
                double[] dArray = this._trainData[n];
                int n3 = i;
                dArray[n3] = dArray[n3] - mean;
                double[] dArray2 = this._trainData[n];
                int n4 = i;
                dArray2[n4] = dArray2[n4] / sigma;
            }
            for (n = 0; n < this._testData.length; ++n) {
                double[] dArray = this._testData[n];
                int n5 = i;
                dArray[n5] = dArray[n5] - mean;
                double[] dArray3 = this._testData[n];
                int n6 = i;
                dArray3[n6] = dArray3[n6] / sigma;
            }
        }
        int numInput = 4;
        int numOutput = 3;
        this._nn = new NeuralNetwork(activation, numInput, numHidden, numOutput);
        this._nn.InitializeWeights();
    }

    void train(int maxEpochs, double learnRate, double momentum, DeepLearningModel.DeepLearningParameters.Loss loss, long seed) {
        this._nn.Train(this._trainData, maxEpochs, learnRate, momentum, loss, seed);
    }

    void MakeTrainTest(double[][] allData, double[][] trainData, double[][] testData, Random rand) {
        int idx;
        int si;
        int numCols = allData[0].length;
        int[] shuffle = new int[allData.length];
        for (int i = 0; i < shuffle.length; ++i) {
            shuffle[i] = i;
        }
        NeuralNetwork.shuffle(shuffle, rand);
        int j = 0;
        for (si = 0; si < trainData.length; ++si) {
            trainData[j] = new double[numCols];
            idx = shuffle[si];
            System.arraycopy(allData[idx], 0, trainData[j], 0, numCols);
            ++j;
        }
        j = 0;
        while (si < allData.length) {
            testData[j] = new double[numCols];
            idx = shuffle[si];
            System.arraycopy(allData[idx], 0, testData[j], 0, numCols);
            ++j;
            ++si;
        }
    }

    static void Normalize(double[][] dataMatrix, int[] cols) {
    }

    static void ShowVector(double[] vector, int valsPerRow, int decimals, boolean newLine) {
        for (int i = 0; i < vector.length; ++i) {
            if (i % valsPerRow == 0) {
                System.out.println("");
            }
            System.out.print(_format.format(vector[i]) + " ");
        }
        if (newLine) {
            System.out.println("");
        }
    }

    static void ShowMatrix(double[][] matrix, int numRows, int decimals, boolean newLine) {
        for (int i = 0; i < numRows; ++i) {
            System.out.print(i + ": ");
            for (int j = 0; j < matrix[i].length; ++j) {
                if (matrix[i][j] >= 0.0) {
                    System.out.print(" ");
                } else {
                    System.out.print("-");
                }
                System.out.print(_format.format(Math.abs(matrix[i][j])) + " ");
            }
            System.out.println("");
        }
        if (newLine) {
            System.out.println("");
        }
    }

    public static class NeuralNetwork {
        DeepLearningModel.DeepLearningParameters.Activation activation = DeepLearningModel.DeepLearningParameters.Activation.Tanh;
        int numInput;
        int numHidden;
        int numOutput;
        double[] inputs;
        float[][] ihWeights;
        double[] hBiases;
        double[] hOutputs;
        float[][] hoWeights;
        double[] oBiases;
        double[] outputs;
        double[] oGrads;
        double[] hGrads;
        float[][] ihPrevWeightsDelta;
        double[] hPrevBiasesDelta;
        float[][] hoPrevWeightsDelta;
        double[] oPrevBiasesDelta;

        public NeuralNetwork(DeepLearningModel.DeepLearningParameters.Activation activationType, int numInput, int numHidden, int numOutput) {
            this.activation = activationType;
            this.numInput = numInput;
            this.numHidden = numHidden;
            this.numOutput = numOutput;
            this.inputs = new double[numInput];
            this.ihWeights = NeuralNetwork.MakeMatrixFloat(numInput, numHidden);
            this.hBiases = new double[numHidden];
            this.hOutputs = new double[numHidden];
            this.hoWeights = NeuralNetwork.MakeMatrixFloat(numHidden, numOutput);
            this.oBiases = new double[numOutput];
            this.outputs = new double[numOutput];
            this.hGrads = new double[numHidden];
            this.oGrads = new double[numOutput];
            this.ihPrevWeightsDelta = NeuralNetwork.MakeMatrixFloat(numInput, numHidden);
            this.hPrevBiasesDelta = new double[numHidden];
            this.hoPrevWeightsDelta = NeuralNetwork.MakeMatrixFloat(numHidden, numOutput);
            this.oPrevBiasesDelta = new double[numOutput];
        }

        private static double[][] MakeMatrix(int rows, int cols) {
            double[][] result = new double[rows][];
            for (int r = 0; r < result.length; ++r) {
                result[r] = new double[cols];
            }
            return result;
        }

        private static float[][] MakeMatrixFloat(int rows, int cols) {
            float[][] result = new float[rows][];
            for (int r = 0; r < result.length; ++r) {
                result[r] = new float[cols];
            }
            return result;
        }

        public String toString() {
            int j;
            int i;
            String s = "";
            s = s + "===============================\n";
            s = s + "numInput = " + this.numInput + " numHidden = " + this.numHidden + " numOutput = " + this.numOutput + "\n\n";
            s = s + "inputs: \n";
            for (i = 0; i < this.inputs.length; ++i) {
                s = s + this.inputs[i] + " ";
            }
            s = s + "\n\n";
            s = s + "ihWeights: \n";
            for (i = 0; i < this.ihWeights.length; ++i) {
                for (j = 0; j < this.ihWeights[i].length; ++j) {
                    s = s + this.ihWeights[i][j] + " ";
                }
                s = s + "\n";
            }
            s = s + "\n";
            s = s + "hBiases: \n";
            for (i = 0; i < this.hBiases.length; ++i) {
                s = s + this.hBiases[i] + " ";
            }
            s = s + "\n\n";
            s = s + "hOutputs: \n";
            for (i = 0; i < this.hOutputs.length; ++i) {
                s = s + this.hOutputs[i] + " ";
            }
            s = s + "\n\n";
            s = s + "hoWeights: \n";
            for (i = 0; i < this.hoWeights.length; ++i) {
                for (j = 0; j < this.hoWeights[i].length; ++j) {
                    s = s + this.hoWeights[i][j] + " ";
                }
                s = s + "\n";
            }
            s = s + "\n";
            s = s + "oBiases: \n";
            for (i = 0; i < this.oBiases.length; ++i) {
                s = s + this.oBiases[i] + " ";
            }
            s = s + "\n\n";
            s = s + "hGrads: \n";
            for (i = 0; i < this.hGrads.length; ++i) {
                s = s + this.hGrads[i] + " ";
            }
            s = s + "\n\n";
            s = s + "oGrads: \n";
            for (i = 0; i < this.oGrads.length; ++i) {
                s = s + this.oGrads[i] + " ";
            }
            s = s + "\n\n";
            s = s + "ihPrevWeightsDelta: \n";
            for (i = 0; i < this.ihPrevWeightsDelta.length; ++i) {
                for (j = 0; j < this.ihPrevWeightsDelta[i].length; ++j) {
                    s = s + this.ihPrevWeightsDelta[i][j] + " ";
                }
                s = s + "\n";
            }
            s = s + "\n";
            s = s + "hPrevBiasesDelta: \n";
            for (i = 0; i < this.hPrevBiasesDelta.length; ++i) {
                s = s + this.hPrevBiasesDelta[i] + " ";
            }
            s = s + "\n\n";
            s = s + "hoPrevWeightsDelta: \n";
            for (i = 0; i < this.hoPrevWeightsDelta.length; ++i) {
                for (j = 0; j < this.hoPrevWeightsDelta[i].length; ++j) {
                    s = s + this.hoPrevWeightsDelta[i][j] + " ";
                }
                s = s + "\n";
            }
            s = s + "\n";
            s = s + "oPrevBiasesDelta: \n";
            for (i = 0; i < this.oPrevBiasesDelta.length; ++i) {
                s = s + this.oPrevBiasesDelta[i] + " ";
            }
            s = s + "\n\n";
            s = s + "outputs: \n";
            for (i = 0; i < this.outputs.length; ++i) {
                s = s + this.outputs[i] + " ";
            }
            s = s + "\n\n";
            s = s + "===============================\n";
            return s;
        }

        public void SetWeights(float[] weights) {
            int j;
            int i;
            int numWeights = this.numInput * this.numHidden + this.numHidden * this.numOutput + this.numHidden + this.numOutput;
            if (weights.length != numWeights) {
                throw new RuntimeException("Bad weights array length: ");
            }
            int k = 0;
            for (i = 0; i < this.numInput; ++i) {
                for (j = 0; j < this.numHidden; ++j) {
                    this.ihWeights[i][j] = weights[k++];
                }
            }
            for (i = 0; i < this.numHidden; ++i) {
                this.hBiases[i] = weights[k++];
            }
            for (i = 0; i < this.numHidden; ++i) {
                for (j = 0; j < this.numOutput; ++j) {
                    this.hoWeights[i][j] = weights[k++];
                }
            }
            for (i = 0; i < this.numOutput; ++i) {
                this.oBiases[i] = weights[k++];
            }
        }

        public void InitializeWeights() {
            int numWeights = this.numInput * this.numHidden + this.numHidden * this.numOutput + this.numHidden + this.numOutput;
            float[] initialWeights = new float[numWeights];
            double lo = -0.01f;
            double hi = 0.01f;
            Random rnd = new Random(0L);
            for (int i = 0; i < initialWeights.length; ++i) {
                initialWeights[i] = (float)((hi - lo) * (double)rnd.nextFloat() + lo);
            }
            this.SetWeights(initialWeights);
        }

        public double[] GetWeights() {
            int j;
            int i;
            int numWeights = this.numInput * this.numHidden + this.numHidden * this.numOutput + this.numHidden + this.numOutput;
            double[] result = new double[numWeights];
            int k = 0;
            for (i = 0; i < this.ihWeights.length; ++i) {
                for (j = 0; j < this.ihWeights[0].length; ++j) {
                    result[k++] = this.ihWeights[i][j];
                }
            }
            for (i = 0; i < this.hBiases.length; ++i) {
                result[k++] = this.hBiases[i];
            }
            for (i = 0; i < this.hoWeights.length; ++i) {
                for (j = 0; j < this.hoWeights[0].length; ++j) {
                    result[k++] = this.hoWeights[i][j];
                }
            }
            for (i = 0; i < this.oBiases.length; ++i) {
                result[k++] = this.oBiases[i];
            }
            return result;
        }

        public double[] ComputeOutputs(double[] xValues) {
            int i;
            int j;
            int i2;
            if (xValues.length != this.numInput) {
                throw new RuntimeException("Bad xValues array length");
            }
            double[] hSums = new double[this.numHidden];
            double[] oSums = new double[this.numOutput];
            for (i2 = 0; i2 < xValues.length; ++i2) {
                this.inputs[i2] = xValues[i2];
            }
            for (j = 0; j < this.numHidden; ++j) {
                for (i = 0; i < this.numInput; ++i) {
                    int n = j;
                    hSums[n] = hSums[n] + this.inputs[i] * (double)this.ihWeights[i][j];
                }
            }
            for (i2 = 0; i2 < this.numHidden; ++i2) {
                int n = i2;
                hSums[n] = hSums[n] + this.hBiases[i2];
            }
            for (i2 = 0; i2 < this.numHidden; ++i2) {
                if (this.activation == DeepLearningModel.DeepLearningParameters.Activation.Tanh || this.activation == DeepLearningModel.DeepLearningParameters.Activation.TanhWithDropout) {
                    this.hOutputs[i2] = NeuralNetwork.HyperTanFunction(hSums[i2]);
                    continue;
                }
                if (this.activation == DeepLearningModel.DeepLearningParameters.Activation.Rectifier || this.activation == DeepLearningModel.DeepLearningParameters.Activation.RectifierWithDropout) {
                    this.hOutputs[i2] = NeuralNetwork.Rectifier(hSums[i2]);
                    continue;
                }
                throw new RuntimeException("invalid activation.");
            }
            for (j = 0; j < this.numOutput; ++j) {
                for (i = 0; i < this.numHidden; ++i) {
                    int n = j;
                    oSums[n] = oSums[n] + this.hOutputs[i] * (double)this.hoWeights[i][j];
                }
            }
            for (i2 = 0; i2 < this.numOutput; ++i2) {
                int n = i2;
                oSums[n] = oSums[n] + this.oBiases[i2];
            }
            double[] softOut = NeuralNetwork.Softmax(oSums);
            System.arraycopy(softOut, 0, this.outputs, 0, softOut.length);
            double[] retResult = new double[this.numOutput];
            System.arraycopy(this.outputs, 0, retResult, 0, retResult.length);
            return retResult;
        }

        private static double HyperTanFunction(double x) {
            return Math.tanh(x);
        }

        private static double Rectifier(double x) {
            return Math.max(x, 0.0);
        }

        private static double[] Softmax(double[] oSums) {
            int i;
            double max = oSums[0];
            for (int i2 = 0; i2 < oSums.length; ++i2) {
                if (!(oSums[i2] > max)) continue;
                max = oSums[i2];
            }
            double[] result = new double[oSums.length];
            double scale = 0.0;
            for (i = 0; i < result.length; ++i) {
                result[i] = Math.exp(oSums[i] - max);
                scale += result[i];
            }
            i = 0;
            while (i < result.length) {
                int n = i++;
                result[n] = result[n] / scale;
            }
            return result;
        }

        private void UpdateWeights(double[] tValues, double learnRate, double momentum, DeepLearningModel.DeepLearningParameters.Loss loss) {
            double delta;
            double derivative;
            int i;
            if (tValues.length != this.numOutput) {
                throw new RuntimeException("target values not same length as output in UpdateWeights");
            }
            for (i = 0; i < this.oGrads.length; ++i) {
                derivative = (1.0 - this.outputs[i]) * this.outputs[i];
                if (loss == DeepLearningModel.DeepLearningParameters.Loss.CrossEntropy) {
                    this.oGrads[i] = tValues[i] - this.outputs[i];
                    continue;
                }
                if (loss == DeepLearningModel.DeepLearningParameters.Loss.Quadratic) {
                    this.oGrads[i] = derivative * (tValues[i] - this.outputs[i]);
                    continue;
                }
                throw new RuntimeException("invalid loss function");
            }
            for (i = 0; i < this.hGrads.length; ++i) {
                derivative = 1.0;
                if (this.activation == DeepLearningModel.DeepLearningParameters.Activation.Tanh || this.activation == DeepLearningModel.DeepLearningParameters.Activation.TanhWithDropout) {
                    derivative = (1.0 - this.hOutputs[i]) * (1.0 + this.hOutputs[i]);
                } else if (this.activation == DeepLearningModel.DeepLearningParameters.Activation.Rectifier || this.activation == DeepLearningModel.DeepLearningParameters.Activation.RectifierWithDropout) {
                    derivative = this.hOutputs[i] <= 0.0 ? 0.0 : 1.0;
                } else {
                    throw new RuntimeException("invalid activation.");
                }
                double sum = 0.0;
                for (int j = 0; j < this.numOutput; ++j) {
                    double x = this.oGrads[j] * (double)this.hoWeights[i][j];
                    sum += x;
                }
                this.hGrads[i] = derivative * sum;
            }
            for (i = 0; i < this.ihWeights.length; ++i) {
                for (int j = 0; j < this.ihWeights[0].length; ++j) {
                    delta = learnRate * this.hGrads[j] * this.inputs[i];
                    float[] fArray = this.ihWeights[i];
                    int n = j;
                    fArray[n] = (float)((double)fArray[n] + delta);
                    float[] fArray2 = this.ihWeights[i];
                    int n2 = j;
                    fArray2[n2] = (float)((double)fArray2[n2] + momentum * (double)this.ihPrevWeightsDelta[i][j]);
                    this.ihPrevWeightsDelta[i][j] = (float)delta;
                }
            }
            for (i = 0; i < this.hBiases.length; ++i) {
                double delta2 = learnRate * this.hGrads[i] * 1.0;
                int n = i;
                this.hBiases[n] = this.hBiases[n] + delta2;
                int n3 = i;
                this.hBiases[n3] = this.hBiases[n3] + momentum * this.hPrevBiasesDelta[i];
                this.hPrevBiasesDelta[i] = delta2;
            }
            for (i = 0; i < this.hoWeights.length; ++i) {
                for (int j = 0; j < this.hoWeights[0].length; ++j) {
                    delta = learnRate * this.oGrads[j] * this.hOutputs[i];
                    float[] fArray = this.hoWeights[i];
                    int n = j;
                    fArray[n] = (float)((double)fArray[n] + delta);
                    float[] fArray3 = this.hoWeights[i];
                    int n4 = j;
                    fArray3[n4] = (float)((double)fArray3[n4] + momentum * (double)this.hoPrevWeightsDelta[i][j]);
                    this.hoPrevWeightsDelta[i][j] = (float)delta;
                }
            }
            for (i = 0; i < this.oBiases.length; ++i) {
                double delta3 = learnRate * this.oGrads[i] * 1.0;
                int n = i;
                this.oBiases[n] = this.oBiases[n] + delta3;
                int n5 = i;
                this.oBiases[n5] = this.oBiases[n5] + momentum * this.oPrevBiasesDelta[i];
                this.oPrevBiasesDelta[i] = delta3;
            }
        }

        public void Train(double[][] trainData, int maxEprochs, double learnRate, double momentum, DeepLearningModel.DeepLearningParameters.Loss loss, long seed) {
            double[] xValues = new double[this.numInput];
            double[] tValues = new double[this.numOutput];
            for (int epoch = 0; epoch < maxEprochs; ++epoch) {
                int i;
                long chunkSeed = (-8704322056524490956L + (seed + (long)(epoch * trainData.length))) * ((long)(epoch + 1) + -7484065362112007133L);
                Random skip_rng = RandomUtils.getRNG((long[])new long[]{chunkSeed});
                int[] sequence = new int[trainData.length];
                for (i = 0; i < sequence.length; ++i) {
                    sequence[i] = i;
                }
                ArrayUtils.shuffleArray((int[])sequence, (Random)skip_rng);
                for (i = 0; i < trainData.length; ++i) {
                    int idx = sequence[i];
                    System.arraycopy(trainData[idx], 0, xValues, 0, this.numInput);
                    System.arraycopy(trainData[idx], this.numInput, tValues, 0, this.numOutput);
                    this.ComputeOutputs(xValues);
                    this.UpdateWeights(tValues, learnRate, momentum, loss);
                }
            }
        }

        static void shuffle(int[] sequence, Random rand) {
            for (int i = sequence.length - 1; i >= 0; --i) {
                int r = rand.nextInt(i + 1);
                int tmp = sequence[r];
                sequence[r] = sequence[i];
                sequence[i] = tmp;
            }
        }

        public double Accuracy(double[][] testData) {
            int numCorrect = 0;
            int numWrong = 0;
            double[] xValues = new double[this.numInput];
            double[] tValues = new double[this.numOutput];
            for (int i = 0; i < testData.length; ++i) {
                System.arraycopy(testData[i], 0, xValues, 0, this.numInput);
                System.arraycopy(testData[i], this.numInput, tValues, 0, this.numOutput);
                double[] yValues = this.ComputeOutputs(xValues);
                double[] preds = new double[yValues.length + 1];
                for (int j = 0; j < yValues.length; ++j) {
                    preds[j + 1] = (float)yValues[j];
                }
                preds[0] = GenModel.getPrediction((double[])preds, null, (double[])xValues, (double)0.5);
                if (tValues[(int)preds[0]] == 1.0) {
                    ++numCorrect;
                    continue;
                }
                ++numWrong;
            }
            return (double)numWrong / (double)(numCorrect + numWrong);
        }

        private static int MaxIndex(double[] vector) {
            int bigIndex = 0;
            double biggestVal = vector[0];
            for (int i = 0; i < vector.length; ++i) {
                if (!(vector[i] > biggestVal)) continue;
                biggestVal = vector[i];
                bigIndex = i;
            }
            return bigIndex;
        }
    }
}

