/*
 * Decompiled with CFR 0.152.
 */
package hex.deeplearning;

import hex.deeplearning.DeepLearning;
import hex.deeplearning.DeepLearningModel;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import water.DKV;
import water.H2O;
import water.Key;
import water.Keyed;
import water.Scope;
import water.TestUtil;
import water.fvec.Frame;
import water.fvec.NFSFileVec;
import water.fvec.Vec;
import water.parser.ParseDataset;
import water.util.TwoDimTable;

public class DeepLearningCheckpointReporting
extends TestUtil {
    @BeforeClass
    public static void setup() {
        DeepLearningCheckpointReporting.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void run() {
        Scope.enter();
        Frame frame = null;
        try {
            NFSFileVec trainfv = TestUtil.makeNfsFileVec((String)"smalldata/logreg/prostate.csv");
            frame = ParseDataset.parse((Key)Key.make(), (Key[])new Key[]{trainfv._key});
            DeepLearningModel.DeepLearningParameters p = new DeepLearningModel.DeepLearningParameters();
            p._train = frame._key;
            p._response_column = "CAPSULE";
            p._activation = DeepLearningModel.DeepLearningParameters.Activation.Rectifier;
            p._epochs = 4.0;
            p._train_samples_per_iteration = -1L;
            p._score_duty_cycle = 1.0;
            p._score_interval = 0.0;
            p._overwrite_with_best_model = false;
            p._classification_stop = -1.0;
            p._seed = 1234L;
            p._reproducible = true;
            int ci = frame.find("CAPSULE");
            Scope.track((Vec)frame.replace(ci, frame.vecs()[ci].toCategoricalVec()));
            DKV.put((Keyed)frame);
            long start = System.currentTimeMillis();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            DeepLearningModel model = (DeepLearningModel)new DeepLearning(p).trainModel().get();
            long sleepTime = 5L;
            try {
                Thread.sleep(sleepTime * 1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            DeepLearningModel.DeepLearningParameters p2 = (DeepLearningModel.DeepLearningParameters)p.clone();
            p2._checkpoint = model._key;
            p2._epochs *= 2.0;
            DeepLearningModel model2 = null;
            try {
                model2 = (DeepLearningModel)new DeepLearning(p2).trainModel().get();
                long end = System.currentTimeMillis();
                TwoDimTable table = ((DeepLearningModel.DeepLearningModelOutput)model2._output)._scoring_history;
                double priorDurationDouble = 0.0;
                long priorTimeStampLong = 0L;
                DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
                for (int i = 0; i < table.getRowDim(); ++i) {
                    String timestamp = (String)table.get(i, 0);
                    long timeStampLong = fmt.parseMillis(timestamp);
                    Assert.assertTrue((String)"Timestamp must be later than outside timer start", (timeStampLong >= start ? 1 : 0) != 0);
                    Assert.assertTrue((String)"Timestamp must be earlier than outside timer end", (timeStampLong <= end ? 1 : 0) != 0);
                    Assert.assertTrue((String)"Timestamp must increase", (timeStampLong >= priorTimeStampLong ? 1 : 0) != 0);
                    priorTimeStampLong = timeStampLong;
                    String duration = (String)table.get(i, 1);
                    duration = duration.substring(0, duration.length() - 4);
                    try {
                        double durationDouble = Double.parseDouble(duration);
                        Assert.assertTrue((String)("Duration must be >0: " + durationDouble), (durationDouble >= 0.0 ? 1 : 0) != 0);
                        Assert.assertTrue((String)("Duration must increase: " + priorDurationDouble + " -> " + durationDouble), (durationDouble >= priorDurationDouble ? 1 : 0) != 0);
                        Assert.assertTrue((String)"Duration cannot be more than outside timer delta", (durationDouble <= (double)(end - start) / 1000.0 ? 1 : 0) != 0);
                        priorDurationDouble = durationDouble;
                    }
                    catch (NumberFormatException durationDouble) {
                        // empty catch block
                    }
                    Assert.assertTrue((String)"Epoch counter must be contiguous", ((Double)table.get(i, 3) == (double)i ? 1 : 0) != 0);
                    Assert.assertTrue((String)"Iteration counter must match epochs", ((Integer)table.get(i, 4) == i ? 1 : 0) != 0);
                }
                try {
                    String durationBefore = (String)table.get((int)p._epochs, 1);
                    durationBefore = durationBefore.substring(0, durationBefore.length() - 4);
                    String durationAfter = (String)table.get((int)(p._epochs + 1.0), 1);
                    durationAfter = durationAfter.substring(0, durationAfter.length() - 4);
                    double diff = Double.parseDouble(durationAfter) - Double.parseDouble(durationBefore);
                    if (H2O.getCloudSize() == 1) {
                        Assert.assertTrue((String)("Duration must be smooth; actual " + diff + ", expected at most " + sleepTime + " (before=" + durationBefore + ", after=" + durationAfter + ")"), (diff < (double)(sleepTime + 1L) ? 1 : 0) != 0);
                    }
                    String timeStampBefore = (String)table.get((int)p._epochs, 0);
                    long timeStampBeforeLong = fmt.parseMillis(timeStampBefore);
                    String timeStampAfter = (String)table.get((int)(p._epochs + 1.0), 0);
                    long timeStampAfterLong = fmt.parseMillis(timeStampAfter);
                    Assert.assertTrue((String)"Time stamp must experience a delay", (timeStampAfterLong - timeStampBeforeLong >= (sleepTime - 1L) * 1000L ? 1 : 0) != 0);
                    String speedBefore = (String)table.get((int)p._epochs, 2);
                    speedBefore = speedBefore.substring(0, speedBefore.length() - 9);
                    double speedBeforeDouble = Double.parseDouble(speedBefore);
                    String speedAfter = (String)table.get((int)(p._epochs + 1.0), 2);
                    speedAfter = speedAfter.substring(0, speedAfter.length() - 9);
                    double speedAfterDouble = Double.parseDouble(speedAfter);
                    Assert.assertTrue((String)"Speed shouldn't change more than 50%", (Math.abs(speedAfterDouble - speedBeforeDouble) / speedBeforeDouble < 0.5 ? 1 : 0) != 0);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            finally {
                if (model != null) {
                    model.delete();
                }
                if (model2 != null) {
                    model2.delete();
                }
            }
        }
        finally {
            if (frame != null) {
                frame.remove();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }
}

