/*
 * Decompiled with CFR 0.152.
 */
package hex.deeplearning;

import hex.deeplearning.DeepLearning;
import hex.deeplearning.DeepLearningModel;
import hex.genmodel.GenModel;
import hex.genmodel.algos.deeplearning.DeeplearningMojoModel;
import hex.genmodel.easy.EasyPredictModelWrapper;
import hex.genmodel.easy.RowData;
import hex.genmodel.easy.exception.PredictException;
import hex.genmodel.easy.prediction.AutoEncoderModelPrediction;
import java.io.IOException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import water.Key;
import water.TestUtil;
import water.fvec.Frame;
import water.fvec.NFSFileVec;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.parser.ParseDataset;
import water.util.Log;

public class DeepLearningAutoEncoderCategoricalTest
extends TestUtil {
    static final String PATH = "smalldata/airlines/AirlinesTrain.csv.zip";

    @BeforeClass
    public static void setup() {
        DeepLearningAutoEncoderCategoricalTest.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void run() {
        long seed = 912559L;
        Frame train = null;
        try {
            NFSFileVec nfs = TestUtil.makeNfsFileVec((String)PATH);
            train = ParseDataset.parse((Key)Key.make((String)"train.hex"), (Key[])new Key[]{nfs._key});
            DeepLearningModel.DeepLearningParameters p = new DeepLearningModel.DeepLearningParameters();
            p._train = train._key;
            p._autoencoder = true;
            p._response_column = train.names()[train.names().length - 1];
            p._seed = seed;
            p._hidden = new int[]{10, 5, 3};
            p._adaptive_rate = true;
            p._l1 = 1.0E-4;
            p._activation = DeepLearningModel.DeepLearningParameters.Activation.Tanh;
            p._max_w2 = 10.0f;
            p._train_samples_per_iteration = -1L;
            p._loss = DeepLearningModel.DeepLearningParameters.Loss.Huber;
            p._epochs = 0.2;
            p._force_load_balance = true;
            p._score_training_samples = 0L;
            p._score_validation_samples = 0L;
            p._reproducible = true;
            Frame recon_train = null;
            Frame l2 = null;
            Frame df1 = null;
            Frame df2 = null;
            Frame df3 = null;
            DeepLearningModel mymodel = null;
            StringBuilder sb = new StringBuilder();
            try {
                DeepLearning dl = new DeepLearning(p);
                mymodel = (DeepLearningModel)dl.trainModel().get();
                sb.append("Verifying results.\n");
                sb.append("Reported mean reconstruction error: " + mymodel.mse() + "\n");
                Frame rec = mymodel.scoreAutoEncoder(train, Key.make(), true);
                sb.append("Reconstruction error per feature: " + rec.toString() + "\n");
                rec.remove();
                l2 = mymodel.scoreAutoEncoder(train, Key.make(), false);
                Vec l2vec = l2.anyVec();
                sb.append("Actual   mean reconstruction error: " + l2vec.mean() + "\n");
                double quantile = 1.0 - 5.0 / (double)train.numRows();
                sb.append("The following training points are reconstructed with an error above the " + quantile * 100.0 + "-th percentile - potential \"outliers\" in testing data.\n");
                double thresh = mymodel.calcOutlierThreshold(l2vec, quantile);
                for (long i = 0L; i < l2vec.length(); ++i) {
                    if (!(l2vec.at(i) > thresh)) continue;
                    sb.append(String.format("row %d : l2vec error = %5f\n", i, l2vec.at(i)));
                }
                Log.info((Object[])new Object[]{sb.toString()});
                Assert.assertEquals((double)l2vec.mean(), (double)mymodel.mse(), (double)(1.0E-8 * mymodel.mse()));
                Log.info((Object[])new Object[]{"Creating full reconstruction."});
                recon_train = mymodel.score(train);
                Assert.assertTrue((boolean)mymodel.testJavaScoring(train, recon_train, 1.0E-5));
                df1 = mymodel.scoreDeepFeatures(train, 0);
                Assert.assertEquals((long)10L, (long)df1.numCols());
                Assert.assertEquals((long)train.numRows(), (long)df1.numRows());
                df2 = mymodel.scoreDeepFeatures(train, 1);
                Assert.assertEquals((long)5L, (long)df2.numCols());
                Assert.assertEquals((long)train.numRows(), (long)df2.numRows());
                df3 = mymodel.scoreDeepFeatures(train, 2);
                Assert.assertEquals((long)3L, (long)df3.numCols());
                Assert.assertEquals((long)train.numRows(), (long)df3.numRows());
                try {
                    DeeplearningMojoModel mojoModel = (DeeplearningMojoModel)mymodel.toMojo();
                    EasyPredictModelWrapper model = new EasyPredictModelWrapper((GenModel)mojoModel);
                    double calcNormMse = 0.0;
                    int r = 0;
                    while ((long)r < train.numRows()) {
                        RowData tmpRow = new RowData();
                        BufferedString bStr = new BufferedString();
                        for (int c = 0; c < train.numCols(); ++c) {
                            if (train.vec(c).isCategorical()) {
                                tmpRow.put((Object)train.names()[c], (Object)train.vec(c).atStr(bStr, (long)r).toString());
                                continue;
                            }
                            tmpRow.put((Object)train.names()[c], (Object)train.vec(c).at((long)r));
                        }
                        AutoEncoderModelPrediction tmpPrediction = model.predictAutoEncoder(tmpRow);
                        calcNormMse += tmpPrediction.mse;
                        ++r;
                    }
                    double mojoMeanError = calcNormMse / (double)train.numRows();
                    sb.append("Mojo mean reconstruction error (train): ").append(mojoMeanError).append("\n");
                    sb.append("Mean reconstruction error should be the same from model compare to mojo model reconstruction error: ");
                    sb.append(mymodel.mse()).append(" == ").append(mojoMeanError).append("\n");
                    Assert.assertEquals((double)mymodel.mse(), (double)mojoMeanError, (double)1.0E-7);
                }
                catch (IOException error) {
                    Assert.fail((String)error.getStackTrace().toString());
                }
                catch (PredictException error) {
                    Assert.fail((String)error.getStackTrace().toString());
                }
            }
            catch (Throwable throwable) {
                Log.info((Object[])new Object[]{sb});
                if (recon_train != null) {
                    recon_train.delete();
                }
                if (l2 != null) {
                    l2.delete();
                }
                if (mymodel != null) {
                    mymodel.delete();
                }
                if (df1 != null) {
                    df1.delete();
                }
                if (df2 != null) {
                    df2.delete();
                }
                if (df3 != null) {
                    df3.delete();
                }
                throw throwable;
            }
            Log.info((Object[])new Object[]{sb});
            if (recon_train != null) {
                recon_train.delete();
            }
            if (l2 != null) {
                l2.delete();
            }
            if (mymodel != null) {
                mymodel.delete();
            }
            if (df1 != null) {
                df1.delete();
            }
            if (df2 != null) {
                df2.delete();
            }
            if (df3 != null) {
                df3.delete();
            }
        }
        finally {
            if (train != null) {
                train.delete();
            }
        }
    }
}

