/*
 * Decompiled with CFR 0.152.
 */
package hex.coxph;

import hex.coxph.Storage;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import water.Key;
import water.Scope;
import water.TestUtil;
import water.fvec.Frame;
import water.fvec.TestFrameBuilder;
import water.fvec.Vec;

public class StorageTest
extends TestUtil {
    @BeforeClass
    public static void setup() {
        StorageTest.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testToFrame() {
        try {
            Scope.enter();
            TestReadOnlyMatrix matrix = new TestReadOnlyMatrix(7, 3);
            Key key = Key.make();
            Frame f = Scope.track((Frame[])new Frame[]{matrix.toFrame(key)});
            Assert.assertEquals((Object)key, (Object)f._key);
            Frame expected = Scope.track((Frame[])new Frame[]{new TestFrameBuilder().withName("testFrame").withColNames(new String[]{"ColA", "ColB", "ColC"}).withVecTypes(new byte[]{3, 3, 3}).withDataForCol(0, StorageTest.ard((double[])new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0})).withDataForCol(1, StorageTest.ard((double[])new double[]{2.0, 4.0, 6.0, 8.0, 10.0, 12.0, 14.0})).withDataForCol(2, StorageTest.ard((double[])new double[]{3.0, 6.0, 9.0, 12.0, 15.0, 18.0, 21.0})).withChunkLayout(new long[]{2L, 2L, 2L, 1L}).build()});
            for (int i = 0; i < f.numCols(); ++i) {
                StorageTest.assertVecEquals((Vec)expected.vec(i), (Vec)f.vec(i), (double)0.0);
            }
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    static class TestReadOnlyMatrix
    extends Storage.AbstractMatrix<TestReadOnlyMatrix> {
        int _row;
        int _col;

        private TestReadOnlyMatrix(int row, int col) {
            this._row = row;
            this._col = col;
        }

        public double get(int row, int col) {
            return (row + 1) * (col + 1);
        }

        public void set(int row, int col, double val) {
            throw new UnsupportedOperationException();
        }

        public void add(int row, int col, double val) {
            throw new UnsupportedOperationException();
        }

        public int cols() {
            return this._col;
        }

        public int rows() {
            return this._row;
        }

        public long size() {
            return this._row * this._col;
        }

        public double[] raw() {
            throw new UnsupportedOperationException();
        }
    }
}

