/*
 * Decompiled with CFR 0.152.
 */
package hex.coxph;

import hex.DataInfo;
import hex.coxph.CoxPH;
import hex.coxph.CoxPHModel;
import hex.coxph.EfronDJKSetupFun;
import hex.coxph.EfronDJKTermTask;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import water.DKV;
import water.Key;
import water.Keyed;
import water.MemoryManager;
import water.Scope;
import water.TestUtil;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.TestFrameBuilder;

public class EfronDJKTermTaskTest
extends TestUtil {
    @BeforeClass
    public static void setup() {
        EfronDJKTermTaskTest.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDJKTermMatrix() throws Exception {
        try {
            Scope.enter();
            Frame fr = Scope.track((Frame[])new Frame[]{new TestFrameBuilder().withName("testFrame").withColNames(new String[]{"ColA", "ColB", "ColC", "Event", "Stop"}).withVecTypes(new byte[]{3, 4, 4, 3, 3}).withDataForCol(0, EfronDJKTermTaskTest.ard((double[])new double[]{3.2, 1.0, 2.0, 3.0, 4.0, 5.6, 7.0})).withDataForCol(1, EfronDJKTermTaskTest.ar((String[])new String[]{"A", "B", "C", "E", "F", "I", "J"})).withDataForCol(2, EfronDJKTermTaskTest.ar((String[])new String[]{"A", "B,", "A", "C", "A", "B", "A"})).withDataForCol(3, EfronDJKTermTaskTest.ard((double[])new double[]{1.0, 0.0, 2.0, 3.0, 4.0, 3.0, 1.0})).withDataForCol(4, EfronDJKTermTaskTest.ard((double[])new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0})).withChunkLayout(new long[]{7L}).build()});
            DataInfo dinfo = EfronDJKTermTaskTest.makeDataInfo(fr, 2);
            DataInfo dinfoNoResp = EfronDJKTermTaskTest.makeDataInfo(fr.subframe(new String[]{"ColA", "ColB", "ColC"}), 0);
            CoxPH.CoxPHTask coxMR = new CoxPH.CoxPHTask(dinfo, new double[dinfo.fullN()], new double[1], 0L, 0, false, null, false, CoxPHModel.CoxPHParameters.CoxPHTies.efron);
            EfronDJKSetupFun efronDJKSetupFun = new EfronDJKSetupFun();
            efronDJKSetupFun._cumsumRiskTerm = new double[]{0.0, 1.0, 2.0, 3.0, 4.0};
            efronDJKSetupFun._riskTermT2 = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
            EfronDJKTermTask djkTermTask = new EfronDJKTermTask(dinfo, coxMR, efronDJKSetupFun);
            double[][] djkTerm = MemoryManager.malloc8d((int)dinfo.fullN(), (int)dinfo.fullN());
            djkTermTask._djkTerm = djkTerm;
            djkTermTask.setupLocal();
            Chunk[] cs = EfronDJKTermTaskTest.chunks(dinfo, 0);
            Chunk[] csNoResp = EfronDJKTermTaskTest.chunks(dinfoNoResp, 0);
            double[][] expected = MemoryManager.malloc8d((int)dinfo.fullN(), (int)dinfo.fullN());
            for (int i = 0; i < cs[0]._len; ++i) {
                DataInfo.Row rowNoResp = dinfoNoResp.extractDenseRow(csNoResp, i, dinfoNoResp.newDenseRow());
                EfronDJKTermTaskTest.vvT(rowNoResp, expected);
                DataInfo.Row row = dinfo.extractDenseRow(cs, i, dinfo.newDenseRow());
                djkTermTask.processRow(row);
            }
            djkTermTask.postGlobal();
            for (int j = 0; j < expected.length; ++j) {
                Assert.assertArrayEquals((double[])expected[j], (double[])djkTerm[j], (double)1.0E-8);
            }
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    private static void vvT(DataInfo.Row row, double[][] prod) {
        double[] v = row.expandCats();
        for (int j = 0; j < v.length; ++j) {
            for (int k = 0; k < v.length; ++k) {
                double[] dArray = prod[j];
                int n = k;
                dArray[n] = dArray[n] + v[j] * v[k];
            }
        }
    }

    private static Chunk[] chunks(DataInfo dinfo, int chunkId) {
        Chunk[] cs = new Chunk[dinfo._adaptedFrame.numCols()];
        for (int i = 0; i < cs.length; ++i) {
            cs[i] = dinfo._adaptedFrame.vec(i).chunkForChunkIdx(chunkId);
        }
        return cs;
    }

    private static DataInfo makeDataInfo(Frame fr, int nResponses) {
        DataInfo dinfo = new DataInfo(fr, null, nResponses, false, DataInfo.TransformType.DEMEAN, DataInfo.TransformType.NONE, true, false, false, false, false, false, null).disableIntercept();
        Scope.track_generic((Keyed)dinfo);
        DKV.put((Keyed)dinfo);
        return dinfo;
    }
}

