/*
 * Decompiled with CFR 0.152.
 */
package hex.coxph;

import hex.StringPair;
import hex.coxph.CoxPH;
import hex.coxph.CoxPHModel;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.Scope;
import water.TestUtil;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;

public class CoxPHTest
extends TestUtil {
    @BeforeClass
    public static void setup() {
        CoxPHTest.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoxPHEfron1Var() {
        CoxPHModel model = null;
        Frame fr = null;
        try {
            fr = CoxPHTest.parse_test_file((String)"smalldata/coxph_test/heart.csv");
            CoxPHModel.CoxPHParameters parms = new CoxPHModel.CoxPHParameters();
            parms._calc_cumhaz = true;
            parms._train = fr._key;
            parms._start_column = "start";
            parms._stop_column = "stop";
            parms._response_column = "event";
            parms._ignored_columns = new String[]{"id", "year", "surgery", "transplant"};
            parms._ties = CoxPHModel.CoxPHParameters.CoxPHTies.efron;
            Assert.assertEquals((Object)"Surv(start, stop, event) ~ age", (Object)parms.toFormula(fr));
            CoxPH builder = new CoxPH(parms);
            model = (CoxPHModel)builder.trainModel().get();
            Assert.assertEquals((double)((CoxPHModel.CoxPHOutput)model._output)._coef[0], (double)0.0307077486571334, (double)1.0E-8);
            Assert.assertEquals((double)((CoxPHModel.CoxPHOutput)model._output)._var_coef[0][0], (double)2.03471477951459E-4, (double)1.0E-8);
            Assert.assertEquals((double)((CoxPHModel.CoxPHOutput)model._output)._null_loglik, (double)-298.121355672984, (double)1.0E-8);
            Assert.assertEquals((double)((CoxPHModel.CoxPHOutput)model._output)._loglik, (double)-295.536762216228, (double)1.0E-8);
            Assert.assertEquals((double)((CoxPHModel.CoxPHOutput)model._output)._score_test, (double)4.64097294749287, (double)1.0E-8);
            Assert.assertTrue((((CoxPHModel.CoxPHOutput)model._output)._iter >= 1 ? 1 : 0) != 0);
            Assert.assertEquals((double)((CoxPHModel.CoxPHOutput)model._output)._x_mean_num[0][0], (double)-2.48402655078554, (double)1.0E-8);
            Assert.assertEquals((long)((CoxPHModel.CoxPHOutput)model._output)._n, (long)172L);
            Assert.assertEquals((long)((CoxPHModel.CoxPHOutput)model._output)._total_event, (long)75L);
            Assert.assertEquals((double)((CoxPHModel.CoxPHOutput)model._output)._wald_test, (double)4.6343882547245, (double)1.0E-8);
            Assert.assertEquals((long)((CoxPHModel.CoxPHOutput)model._output)._var_cumhaz_2_matrix.rows(), (long)110L);
        }
        finally {
            if (fr != null) {
                fr.delete();
            }
            if (model != null) {
                model.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoxPHEfron1VarScoring() {
        try {
            Scope.enter();
            Frame fr = Scope.track((Frame[])new Frame[]{CoxPHTest.parse_test_file((String)"smalldata/coxph_test/heart.csv")});
            CoxPHModel.CoxPHParameters parms = new CoxPHModel.CoxPHParameters();
            parms._calc_cumhaz = true;
            parms._train = fr._key;
            parms._start_column = "start";
            parms._stop_column = "stop";
            parms._response_column = "event";
            parms._ignored_columns = new String[]{"id", "year", "surgery", "transplant"};
            parms._ties = CoxPHModel.CoxPHParameters.CoxPHTies.efron;
            Assert.assertEquals((Object)"Surv(start, stop, event) ~ age", (Object)parms.toFormula(fr));
            CoxPH builder = new CoxPH(parms);
            CoxPHModel model = (CoxPHModel)Scope.track_generic((Keyed)builder.trainModel().get());
            Assert.assertNotNull((Object)model);
            Frame linearPredictors = Scope.track((Frame[])new Frame[]{model.score(fr)});
            Assert.assertEquals((long)fr.numRows(), (long)linearPredictors.numRows());
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoxPHBreslow1Var() {
        CoxPHModel model = null;
        Frame fr = null;
        try {
            fr = CoxPHTest.parse_test_file((String)"smalldata/coxph_test/heart.csv");
            CoxPHModel.CoxPHParameters parms = new CoxPHModel.CoxPHParameters();
            parms._calc_cumhaz = true;
            parms._train = fr._key;
            parms._start_column = "start";
            parms._stop_column = "stop";
            parms._response_column = "event";
            parms._ignored_columns = new String[]{"id", "year", "surgery", "transplant"};
            parms._ties = CoxPHModel.CoxPHParameters.CoxPHTies.breslow;
            Assert.assertEquals((Object)"Surv(start, stop, event) ~ age", (Object)parms.toFormula(fr));
            CoxPH builder = new CoxPH(parms);
            model = (CoxPHModel)builder.trainModel().get();
            Assert.assertEquals((double)((CoxPHModel.CoxPHOutput)model._output)._coef[0], (double)0.0306910411003801, (double)1.0E-8);
            Assert.assertEquals((double)((CoxPHModel.CoxPHOutput)model._output)._var_coef[0][0], (double)2.03592486905101E-4, (double)1.0E-8);
            Assert.assertEquals((double)((CoxPHModel.CoxPHOutput)model._output)._null_loglik, (double)-298.325606736463, (double)1.0E-8);
            Assert.assertEquals((double)((CoxPHModel.CoxPHOutput)model._output)._loglik, (double)-295.745227177782, (double)1.0E-8);
            Assert.assertEquals((double)((CoxPHModel.CoxPHOutput)model._output)._score_test, (double)4.63317821557301, (double)1.0E-8);
            Assert.assertTrue((((CoxPHModel.CoxPHOutput)model._output)._iter >= 1 ? 1 : 0) != 0);
            Assert.assertEquals((double)((CoxPHModel.CoxPHOutput)model._output)._x_mean_num[0][0], (double)-2.48402655078554, (double)1.0E-8);
            Assert.assertEquals((long)((CoxPHModel.CoxPHOutput)model._output)._n, (long)172L);
            Assert.assertEquals((long)((CoxPHModel.CoxPHOutput)model._output)._total_event, (long)75L);
            Assert.assertEquals((double)((CoxPHModel.CoxPHOutput)model._output)._wald_test, (double)4.62659510743282, (double)1.0E-8);
            Assert.assertEquals((long)((CoxPHModel.CoxPHOutput)model._output)._var_cumhaz_2_matrix.rows(), (long)110L);
        }
        finally {
            if (fr != null) {
                fr.delete();
            }
            if (model != null) {
                model.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoxPHEfron1VarNoStart() {
        CoxPHModel model = null;
        Frame fr = null;
        try {
            fr = CoxPHTest.parse_test_file((String)"smalldata/coxph_test/heart.csv");
            CoxPHModel.CoxPHParameters parms = new CoxPHModel.CoxPHParameters();
            parms._calc_cumhaz = true;
            parms._train = fr._key;
            parms._start_column = null;
            parms._stop_column = "stop";
            parms._response_column = "event";
            parms._ignored_columns = new String[]{"id", "year", "surgery", "transplant", "start"};
            parms._ties = CoxPHModel.CoxPHParameters.CoxPHTies.efron;
            Assert.assertEquals((Object)"Surv(stop, event) ~ age", (Object)parms.toFormula(fr));
            CoxPH builder = new CoxPH(parms);
            model = (CoxPHModel)builder.trainModel().get();
            Assert.assertEquals((double)((CoxPHModel.CoxPHOutput)model._output)._coef[0], (double)0.0289468187293998, (double)1.0E-8);
            Assert.assertEquals((double)((CoxPHModel.CoxPHOutput)model._output)._var_coef[0][0], (double)2.10975113029285E-4, (double)1.0E-8);
            Assert.assertEquals((double)((CoxPHModel.CoxPHOutput)model._output)._null_loglik, (double)-314.148170059513, (double)1.0E-8);
            Assert.assertEquals((double)((CoxPHModel.CoxPHOutput)model._output)._loglik, (double)-311.946958322919, (double)1.0E-8);
            Assert.assertEquals((double)((CoxPHModel.CoxPHOutput)model._output)._score_test, (double)3.97716015008595, (double)1.0E-8);
            Assert.assertTrue((((CoxPHModel.CoxPHOutput)model._output)._iter >= 1 ? 1 : 0) != 0);
            Assert.assertEquals((double)((CoxPHModel.CoxPHOutput)model._output)._x_mean_num[0][0], (double)-2.48402655078554, (double)1.0E-8);
            Assert.assertEquals((long)((CoxPHModel.CoxPHOutput)model._output)._n, (long)172L);
            Assert.assertEquals((long)((CoxPHModel.CoxPHOutput)model._output)._total_event, (long)75L);
            Assert.assertEquals((double)((CoxPHModel.CoxPHOutput)model._output)._wald_test, (double)3.97164529276219, (double)1.0E-8);
            Assert.assertEquals((long)((CoxPHModel.CoxPHOutput)model._output)._var_cumhaz_2_matrix.rows(), (long)110L);
        }
        finally {
            if (fr != null) {
                fr.delete();
            }
            if (model != null) {
                model.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoxPHBreslow1VarNoStart() {
        CoxPHModel model = null;
        Frame fr = null;
        try {
            fr = CoxPHTest.parse_test_file((String)"smalldata/coxph_test/heart.csv");
            CoxPHModel.CoxPHParameters parms = new CoxPHModel.CoxPHParameters();
            parms._calc_cumhaz = true;
            parms._train = fr._key;
            parms._start_column = null;
            parms._stop_column = "stop";
            parms._response_column = "event";
            parms._ignored_columns = new String[]{"id", "year", "surgery", "transplant", "start"};
            parms._ties = CoxPHModel.CoxPHParameters.CoxPHTies.breslow;
            Assert.assertEquals((Object)"Surv(stop, event) ~ age", (Object)parms.toFormula(fr));
            CoxPH builder = new CoxPH(parms);
            model = (CoxPHModel)builder.trainModel().get();
            Assert.assertEquals((double)((CoxPHModel.CoxPHOutput)model._output)._coef[0], (double)0.0289484855901731, (double)1.0E-8);
            Assert.assertEquals((double)((CoxPHModel.CoxPHOutput)model._output)._var_coef[0][0], (double)2.11028794751156E-4, (double)1.0E-8);
            Assert.assertEquals((double)((CoxPHModel.CoxPHOutput)model._output)._null_loglik, (double)-314.2964933669, (double)1.0E-8);
            Assert.assertEquals((double)((CoxPHModel.CoxPHOutput)model._output)._loglik, (double)-312.095342077591, (double)1.0E-8);
            Assert.assertEquals((double)((CoxPHModel.CoxPHOutput)model._output)._score_test, (double)3.97665282498882, (double)1.0E-8);
            Assert.assertTrue((((CoxPHModel.CoxPHOutput)model._output)._iter >= 1 ? 1 : 0) != 0);
            Assert.assertEquals((double)((CoxPHModel.CoxPHOutput)model._output)._x_mean_num[0][0], (double)-2.48402655078554, (double)1.0E-8);
            Assert.assertEquals((long)((CoxPHModel.CoxPHOutput)model._output)._n, (long)172L);
            Assert.assertEquals((long)((CoxPHModel.CoxPHOutput)model._output)._total_event, (long)75L);
            Assert.assertEquals((double)((CoxPHModel.CoxPHOutput)model._output)._wald_test, (double)3.97109228128153, (double)1.0E-8);
            Assert.assertEquals((long)((CoxPHModel.CoxPHOutput)model._output)._var_cumhaz_2_matrix.rows(), (long)110L);
        }
        finally {
            if (fr != null) {
                fr.delete();
            }
            if (model != null) {
                model.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoxPHEfron1Interaction() {
        try {
            Scope.enter();
            Frame fr = Scope.track((Frame[])new Frame[]{CoxPHTest.parse_test_file((String)"smalldata/coxph_test/heart.csv")});
            Frame ext = new MRTask(){

                public void map(Chunk c, NewChunk nc0, NewChunk nc1) {
                    for (int i = 0; i < c._len; ++i) {
                        double v = c.atd(i);
                        if (i % 2 == 0) {
                            nc0.addNum(v);
                            nc1.addNum(1.0);
                            continue;
                        }
                        nc0.addNum(1.0);
                        nc1.addNum(v);
                    }
                }
            }.doAll(new byte[]{3, 3}, new Vec[]{fr.vec("age")}).outputFrame(Key.make(), new String[]{"age1", "age2"}, (String[][])null);
            Scope.track((Frame[])new Frame[]{ext});
            fr.add(ext);
            CoxPHModel.CoxPHParameters parms = new CoxPHModel.CoxPHParameters();
            parms._calc_cumhaz = true;
            parms._train = fr._key;
            parms._start_column = "start";
            parms._stop_column = "stop";
            parms._response_column = "event";
            parms._interaction_pairs = new StringPair[]{new StringPair("age1", "age2")};
            parms._interactions_only = new String[]{"age1", "age2"};
            parms._ignored_columns = new String[]{"id", "year", "surgery", "transplant", "age"};
            parms._ties = CoxPHModel.CoxPHParameters.CoxPHTies.efron;
            Assert.assertEquals((Object)"Surv(start, stop, event) ~ age1:age2", (Object)parms.toFormula(fr));
            CoxPH builder = new CoxPH(parms);
            CoxPHModel model = (CoxPHModel)Scope.track_generic((Keyed)builder.trainModel().get());
            Assert.assertEquals((double)((CoxPHModel.CoxPHOutput)model._output)._coef[0], (double)0.0307077486571334, (double)1.0E-8);
            Assert.assertEquals((double)((CoxPHModel.CoxPHOutput)model._output)._var_coef[0][0], (double)2.03471477951459E-4, (double)1.0E-8);
            Assert.assertEquals((double)((CoxPHModel.CoxPHOutput)model._output)._null_loglik, (double)-298.121355672984, (double)1.0E-8);
            Assert.assertEquals((double)((CoxPHModel.CoxPHOutput)model._output)._loglik, (double)-295.536762216228, (double)1.0E-8);
            Assert.assertEquals((double)((CoxPHModel.CoxPHOutput)model._output)._score_test, (double)4.64097294749287, (double)1.0E-8);
            Assert.assertTrue((((CoxPHModel.CoxPHOutput)model._output)._iter >= 1 ? 1 : 0) != 0);
            Assert.assertEquals((double)((CoxPHModel.CoxPHOutput)model._output)._x_mean_num[0][0], (double)-2.48402655078554, (double)1.0E-8);
            Assert.assertEquals((long)((CoxPHModel.CoxPHOutput)model._output)._n, (long)172L);
            Assert.assertEquals((long)((CoxPHModel.CoxPHOutput)model._output)._total_event, (long)75L);
            Assert.assertEquals((double)((CoxPHModel.CoxPHOutput)model._output)._wald_test, (double)4.6343882547245, (double)1.0E-8);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }
}

