/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.tree.drf.DRFModel;
import java.util.Arrays;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import water.TestUtil;
import water.fvec.Frame;

public class ModelParametersChecksumTest
extends TestUtil {
    @BeforeClass
    public static void setup() {
        ModelParametersChecksumTest.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPubDev2075() {
        Frame fr = null;
        try {
            fr = ModelParametersChecksumTest.parse_test_file((String)"smalldata/junit/cars_20mpg.csv");
            fr.replace(fr.find("cylinders"), fr.vec("cylinders").toCategoricalVec()).remove();
            DRFModel.DRFParameters p1 = new DRFModel.DRFParameters();
            p1._train = fr._key;
            p1._response_column = "economy_20mpg";
            p1._ignored_columns = new String[]{"name", "columns", "cylinders"};
            p1._ntrees = 2;
            p1._max_depth = 5;
            p1._nbins = 6;
            p1._mtries = 2;
            p1._seed = 8887264963748798740L;
            DRFModel.DRFParameters p2 = new DRFModel.DRFParameters();
            p2._train = fr._key;
            p2._response_column = "economy_20mpg";
            p2._ignored_columns = new String[]{"name", "columns", "cylinders"};
            p2._ntrees = 5;
            p2._max_depth = 1;
            p2._nbins = 3;
            p2._mtries = 4;
            p2._seed = 8887264963748798740L;
            Assert.assertNotEquals((long)p1.checksum(), (long)p2.checksum());
        }
        finally {
            if (fr != null) {
                fr.delete();
            }
        }
    }

    @Test
    public void testIgnoredFields() {
        DRFModel.DRFParameters p1 = new DRFModel.DRFParameters();
        p1._response_column = "economy_20mpg";
        p1._ignored_columns = new String[]{"name", "columns", "cylinders"};
        p1._ntrees = 2;
        p1._max_depth = 5;
        p1._nbins = 6;
        p1._mtries = 2;
        p1._seed = 65261L;
        p1._export_checkpoints_dir = "/any/folder";
        DRFModel.DRFParameters p2 = new DRFModel.DRFParameters();
        p2._response_column = "economy_20mpg";
        p2._ignored_columns = new String[]{"name", "columns", "cylinders"};
        p2._ntrees = 2;
        p2._max_depth = 5;
        p2._nbins = 6;
        p2._mtries = 2;
        p2._seed = 65261L;
        p2._export_checkpoints_dir = null;
        Assert.assertEquals((long)p1.checksum(new HashSet<String>(Arrays.asList("_export_checkpoints_dir"))), (long)p2.checksum(new HashSet<String>(Arrays.asList("_export_checkpoints_dir"))));
        Assert.assertNotEquals((long)p1.checksum(new HashSet<String>(Arrays.asList("_export_checkpoints_dir"))), (long)p2.checksum());
    }
}

