/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.DataInfo;
import hex.Model;
import hex.glm.GLMModel;
import hex.splitframe.ShuffleSplitFrame;
import java.util.Random;
import org.junit.BeforeClass;
import org.junit.Test;
import water.Key;
import water.MRTask;
import water.TestUtil;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;

public class DataInfoTestAdapt
extends TestUtil {
    @BeforeClass
    public static void setup() {
        DataInfoTestAdapt.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInteractionTrainTestSplitAdapt() {
        DataInfo dinfo = null;
        DataInfo scoreInfo = null;
        Frame fr = null;
        Frame expanded = null;
        Frame[] frSplits = null;
        Frame[] expandSplits = null;
        Model.InteractionSpec interactions = Model.InteractionSpec.allPairwise((String[])new String[]{"class", "sepal_len"});
        boolean useAll = false;
        boolean standardize = false;
        boolean skipMissing = true;
        try {
            fr = DataInfoTestAdapt.parse_test_file((Key)Key.make((String)"a.hex"), (String)"smalldata/iris/iris_wheader.csv");
            fr.swap(3, 4);
            expanded = GLMModel.GLMOutput.expand((Frame)fr, (Model.InteractionSpec)interactions, (boolean)useAll, (boolean)standardize, (boolean)skipMissing);
            long seed = new Random().nextLong();
            frSplits = ShuffleSplitFrame.shuffleSplitFrame((Frame)fr, (Key[])new Key[]{Key.make(), Key.make()}, (double[])new double[]{0.8, 0.2}, (long)seed);
            expandSplits = ShuffleSplitFrame.shuffleSplitFrame((Frame)expanded, (Key[])new Key[]{Key.make(), Key.make()}, (double[])new double[]{0.8, 0.2}, (long)seed);
            this.checkSplits(frSplits, expandSplits, interactions, useAll, standardize);
            dinfo = DataInfoTestAdapt.makeInfo(frSplits[0], interactions, useAll, standardize);
            GLMModel.GLMParameters parms = new GLMModel.GLMParameters();
            parms._response_column = "petal_wid";
            Model.InteractionBuilder interactionBldr = DataInfoTestAdapt.interactionBuilder(dinfo);
            Model.adaptTestForTrain((Frame)frSplits[1], null, (String[][])null, (String[])dinfo._adaptedFrame.names(), (String[][])dinfo._adaptedFrame.domains(), (Model.Parameters)parms, (boolean)true, (boolean)false, (Model.InteractionBuilder)interactionBldr, null, null, (boolean)false);
            scoreInfo = dinfo.scoringInfo(dinfo._adaptedFrame._names, frSplits[1]);
            this.checkFrame(scoreInfo, expandSplits[1]);
        }
        catch (Throwable throwable) {
            this.cleanup(fr, expanded);
            this.cleanup(frSplits);
            this.cleanup(expandSplits);
            this.cleanup(dinfo, scoreInfo);
            throw throwable;
        }
        this.cleanup(fr, expanded);
        this.cleanup(frSplits);
        this.cleanup(expandSplits);
        this.cleanup(dinfo, scoreInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInteractionTrainTestSplitAdaptAirlines() {
        DataInfo dinfo = null;
        DataInfo scoreInfo = null;
        Frame frA = null;
        Frame fr = null;
        Frame expanded = null;
        Frame[] frSplits = null;
        Frame[] expandSplits = null;
        Model.InteractionSpec interactions = Model.InteractionSpec.allPairwise((String[])new String[]{"CRSDepTime", "Origin"});
        String[] keepColumns = new String[]{"Year", "Month", "DayofMonth", "DayOfWeek", "CRSDepTime", "CRSArrTime", "UniqueCarrier", "CRSElapsedTime", "Origin", "Dest", "Distance", "IsDepDelayed"};
        boolean useAll = false;
        boolean standardize = false;
        boolean skipMissing = false;
        try {
            frA = DataInfoTestAdapt.parse_test_file((Key)Key.make((String)"a.hex"), (String)"smalldata/airlines/allyears2k_headers.zip");
            fr = frA.subframe(keepColumns);
            expanded = GLMModel.GLMOutput.expand((Frame)fr, (Model.InteractionSpec)interactions, (boolean)useAll, (boolean)standardize, (boolean)skipMissing);
            long seed = new Random().nextLong();
            frSplits = ShuffleSplitFrame.shuffleSplitFrame((Frame)fr, (Key[])new Key[]{Key.make(), Key.make()}, (double[])new double[]{0.8, 0.2}, (long)seed);
            expandSplits = ShuffleSplitFrame.shuffleSplitFrame((Frame)expanded, (Key[])new Key[]{Key.make(), Key.make()}, (double[])new double[]{0.8, 0.2}, (long)seed);
            this.checkSplits(frSplits, expandSplits, interactions, useAll, standardize, skipMissing);
            dinfo = DataInfoTestAdapt.makeInfo(frSplits[0], interactions, useAll, standardize, skipMissing);
            GLMModel.GLMParameters parms = new GLMModel.GLMParameters();
            parms._response_column = "IsDepDelayed";
            Model.InteractionBuilder interactionBldr = DataInfoTestAdapt.interactionBuilder(dinfo);
            Model.adaptTestForTrain((Frame)frSplits[1], null, (String[][])null, (String[])dinfo._adaptedFrame.names(), (String[][])dinfo._adaptedFrame.domains(), (Model.Parameters)parms, (boolean)true, (boolean)false, (Model.InteractionBuilder)interactionBldr, null, null, (boolean)false);
            scoreInfo = dinfo.scoringInfo(dinfo._adaptedFrame._names, frSplits[1]);
            this.checkFrame(scoreInfo, expandSplits[1], skipMissing);
        }
        catch (Throwable throwable) {
            this.cleanup(fr, frA, expanded);
            this.cleanup(frSplits);
            this.cleanup(expandSplits);
            this.cleanup(dinfo, scoreInfo);
            throw throwable;
        }
        this.cleanup(fr, frA, expanded);
        this.cleanup(frSplits);
        this.cleanup(expandSplits);
        this.cleanup(dinfo, scoreInfo);
    }

    private void cleanup(Frame ... fr) {
        for (Frame f : fr) {
            if (null == f) continue;
            f.delete();
        }
    }

    private void cleanup(DataInfo ... di) {
        for (DataInfo d : di) {
            if (null == d) continue;
            d.dropInteractions();
            d.remove();
        }
    }

    private void checkSplits(Frame[] frSplits, Frame[] goldSplits, Model.InteractionSpec interactions, boolean useAll, boolean standardize) {
        this.checkSplits(frSplits, goldSplits, interactions, useAll, standardize, false);
    }

    private void checkSplits(Frame[] frSplits, Frame[] goldSplits, Model.InteractionSpec interactions, boolean useAll, boolean standardize, boolean skipMissing) {
        for (int i = 0; i < frSplits.length; ++i) {
            this.checkFrame(DataInfoTestAdapt.makeInfo(frSplits[i], interactions, useAll, standardize, skipMissing), goldSplits[i], skipMissing);
        }
    }

    private static DataInfo makeInfo(Frame fr, Model.InteractionSpec interactions, boolean useAll, boolean standardize) {
        return DataInfoTestAdapt.makeInfo(fr, interactions, useAll, standardize, true);
    }

    private static DataInfo makeInfo(Frame fr, Model.InteractionSpec interactions, boolean useAll, boolean standardize, boolean skipMissing) {
        return new DataInfo(fr, null, 1, useAll, standardize ? DataInfo.TransformType.STANDARDIZE : DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, skipMissing, false, false, false, false, false, interactions);
    }

    private void checkFrame(final Frame checkMe, Frame gold) {
        Vec[] vecs = new Vec[checkMe.numCols() + gold.numCols()];
        new MRTask(){

            public void map(Chunk[] cs) {
                int off = checkMe.numCols();
                for (int i = 0; i < off; ++i) {
                    for (int r = 0; r < cs[0]._len; ++r) {
                        double gold;
                        double check = cs[i].atd(r);
                        if (!(Math.abs(check - (gold = cs[i + off].atd(r))) > 1.0E-12)) continue;
                        throw new RuntimeException("bonk");
                    }
                }
            }
        }.doAll(vecs);
    }

    private void checkFrame(DataInfo di, Frame gold) {
        this.checkFrame(di, gold, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFrame(final DataInfo di, Frame gold, final boolean skipMissing) {
        try {
            Vec[] vecs = new Vec[di._adaptedFrame.numCols() + gold.numCols()];
            System.arraycopy(di._adaptedFrame.vecs(), 0, vecs, 0, di._adaptedFrame.numCols());
            System.arraycopy(gold.vecs(), 0, vecs, di._adaptedFrame.numCols(), gold.numCols());
            new MRTask(){

                public void map(Chunk[] cs) {
                    int off = di._adaptedFrame.numCols();
                    DataInfo.Row r = di.newDenseRow();
                    for (int i = 0; i < cs[0]._len; ++i) {
                        di.extractDenseRow(cs, i, r);
                        if (skipMissing && r.isBad()) continue;
                        for (int j = 0; j < di.fullN(); ++j) {
                            double thisValue;
                            double goldValue = cs[off + j].atd(i);
                            double diff = Math.abs(goldValue - (thisValue = r.get(j)));
                            if (!(diff > 1.0E-12)) continue;
                            if (!skipMissing && diff < 10.0) {
                                System.out.println("row mismatch: " + i + " column= " + j + "; diff= " + diff + " but not skipping missing, so due to discrepancies in taking mean on split frames");
                                continue;
                            }
                            throw new RuntimeException("bonk");
                        }
                    }
                }
            }.doAll(vecs);
        }
        finally {
            di.dropInteractions();
            di.remove();
        }
    }

    private static Model.InteractionBuilder interactionBuilder(final DataInfo dataInfo) {
        return new Model.InteractionBuilder(){

            public Frame makeInteractions(Frame f) {
                Model.InteractionPair[] interactionPairs = dataInfo._interactionSpec.makeInteractionPairs(f);
                f.add(Model.makeInteractions((Frame)f, (boolean)false, (Model.InteractionPair[])interactionPairs, (boolean)true, (boolean)true, (boolean)false));
                return f;
            }
        };
    }
}

