/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.DataInfo;
import hex.Model;
import hex.StringPair;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import water.AutoBuffer;
import water.DKV;
import water.H2O;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.Scope;
import water.TestFrameCatalog;
import water.TestUtil;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.InteractionWrappedVec;
import water.fvec.RebalanceDataSet;
import water.fvec.Vec;

public class DataInfoTest
extends TestUtil {
    @BeforeClass
    public static void setup() {
        DataInfoTest.stall_till_cloudsize((int)1);
    }

    @Test
    public void testAirlines1() {
        Frame fr = DataInfoTest.parse_test_file((Key)Key.make((String)"a.hex"), (String)"smalldata/airlines/allyears2k_headers.zip");
        try {
            DataInfo dinfo = new DataInfo((Frame)fr.clone(), null, 1, true, DataInfo.TransformType.STANDARDIZE, DataInfo.TransformType.NONE, true, false, false, false, false, false, Model.InteractionSpec.allPairwise((String[])new String[]{fr.name(8), fr.name(16), fr.name(2)}));
            dinfo.dropInteractions();
            dinfo.remove();
        }
        finally {
            fr.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAirlines2() {
        Frame fr = DataInfoTest.parse_test_file((Key)Key.make((String)"a.hex"), (String)"smalldata/airlines/allyears2k_headers.zip");
        try {
            Frame interactions = Model.makeInteractions((Frame)fr, (boolean)false, (Model.InteractionPair[])Model.InteractionPair.generatePairwiseInteractionsFromList((int[])new int[]{8, 16, 2}), (boolean)true, (boolean)true, (boolean)true);
            int len = 0;
            for (Vec v : interactions.vecs()) {
                len += ((InteractionWrappedVec)v).expandedLength();
            }
            interactions.delete();
            Assert.assertTrue((len == 432 ? 1 : 0) != 0);
            DataInfo dinfo__noInteractions = new DataInfo((Frame)fr.clone(), null, 1, true, DataInfo.TransformType.STANDARDIZE, DataInfo.TransformType.NONE, true, false, false, false, false, false, null);
            System.out.println(dinfo__noInteractions.fullN());
            System.out.println(dinfo__noInteractions.numNums());
            DataInfo dinfo__withInteractions = new DataInfo((Frame)fr.clone(), null, 1, true, DataInfo.TransformType.STANDARDIZE, DataInfo.TransformType.NONE, true, false, false, false, false, false, Model.InteractionSpec.allPairwise((String[])new String[]{fr.name(8), fr.name(16), fr.name(2)}));
            System.out.println(dinfo__withInteractions.fullN());
            Assert.assertTrue((dinfo__withInteractions.fullN() == dinfo__noInteractions.fullN() + len ? 1 : 0) != 0);
            dinfo__withInteractions.dropInteractions();
            dinfo__noInteractions.remove();
            dinfo__withInteractions.remove();
        }
        finally {
            fr.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAirlines3() {
        Frame fr = DataInfoTest.parse_test_file((Key)Key.make((String)"a.hex"), (String)"smalldata/airlines/allyears2k_headers.zip");
        try {
            Frame interactions = Model.makeInteractions((Frame)fr, (boolean)false, (Model.InteractionPair[])Model.InteractionPair.generatePairwiseInteractionsFromList((int[])new int[]{8, 16, 2}), (boolean)false, (boolean)true, (boolean)true);
            int len = 0;
            for (Vec v : interactions.vecs()) {
                len += ((InteractionWrappedVec)v).expandedLength();
            }
            interactions.delete();
            Assert.assertTrue((len == 426 ? 1 : 0) != 0);
            DataInfo dinfo__noInteractions = new DataInfo((Frame)fr.clone(), null, 1, false, DataInfo.TransformType.STANDARDIZE, DataInfo.TransformType.NONE, true, false, false, false, false, false, null);
            System.out.println(dinfo__noInteractions.fullN());
            DataInfo dinfo__withInteractions = new DataInfo((Frame)fr.clone(), null, 1, false, DataInfo.TransformType.STANDARDIZE, DataInfo.TransformType.NONE, true, false, false, false, false, false, Model.InteractionSpec.allPairwise((String[])new String[]{fr.name(8), fr.name(16), fr.name(2)}));
            System.out.println(dinfo__withInteractions.fullN());
            Assert.assertTrue((dinfo__withInteractions.fullN() == dinfo__noInteractions.fullN() + len ? 1 : 0) != 0);
            dinfo__withInteractions.dropInteractions();
            dinfo__noInteractions.remove();
            dinfo__withInteractions.remove();
        }
        finally {
            fr.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAirlinesInteractionSpec() {
        try {
            Scope.enter();
            Frame fr = Scope.track((Frame[])new Frame[]{DataInfoTest.parse_test_file((Key)Key.make((String)"a.hex"), (String)"smalldata/airlines/allyears2k_headers.zip")});
            Model.InteractionSpec interactionSpec = Model.InteractionSpec.create(null, (StringPair[])new StringPair[]{new StringPair("UniqueCarrier", "Origin"), new StringPair("Origin", "DayofMonth")}, (String[])new String[]{"UniqueCarrier"});
            DataInfo dinfo = new DataInfo((Frame)fr.clone(), null, 1, false, DataInfo.TransformType.STANDARDIZE, DataInfo.TransformType.NONE, true, false, false, false, false, false, interactionSpec);
            Scope.track_generic((Keyed)dinfo);
            Assert.assertArrayEquals((Object[])new String[]{"TailNum", "UniqueCarrier_Origin", "Dest", "Origin", "CancellationCode", "IsArrDelayed", "Origin_DayofMonth", "Year", "Month", "DayofMonth", "DayOfWeek", "DepTime", "CRSDepTime", "ArrTime", "CRSArrTime", "FlightNum", "ActualElapsedTime", "CRSElapsedTime", "AirTime", "ArrDelay", "DepDelay", "Distance", "TaxiIn", "TaxiOut", "Cancelled", "Diverted", "CarrierDelay", "WeatherDelay", "NASDelay", "SecurityDelay", "LateAircraftDelay", "IsDepDelayed"}, (Object[])dinfo._adaptedFrame._names);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIris1() {
        Frame fr = DataInfoTest.parse_test_file((Key)Key.make((String)"a.hex"), (String)"smalldata/iris/iris_wheader.csv");
        fr.swap(1, 4);
        Model.InteractionPair[] ips = Model.InteractionPair.generatePairwiseInteractionsFromList((int[])new int[]{0, 1});
        DataInfo di = null;
        try {
            di = new DataInfo((Frame)fr.clone(), null, 1, true, DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, true, false, false, false, false, false, Model.InteractionSpec.allPairwise((String[])new String[]{fr.name(0), fr.name(1)}));
            DataInfoTest.checker(di, false);
        }
        finally {
            fr.delete();
            if (di != null) {
                di.dropInteractions();
                di.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIris2() {
        Frame fr = DataInfoTest.parse_test_file((Key)Key.make((String)"a.hex"), (String)"smalldata/iris/iris_wheader.csv");
        fr.swap(1, 4);
        Model.InteractionPair[] ips = Model.InteractionPair.generatePairwiseInteractionsFromList((int[])new int[]{0, 1});
        DataInfo di = null;
        try {
            di = new DataInfo((Frame)fr.clone(), null, 1, true, DataInfo.TransformType.STANDARDIZE, DataInfo.TransformType.NONE, true, false, false, false, false, false, Model.InteractionSpec.allPairwise((String[])new String[]{fr.name(0), fr.name(1)}));
            DataInfoTest.checker(di, true);
        }
        finally {
            fr.delete();
            if (di != null) {
                di.dropInteractions();
                di.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIris3() {
        Frame fr = DataInfoTest.parse_test_file((Key)Key.make((String)"a.hex"), (String)"smalldata/iris/iris_wheader.csv");
        fr.swap(2, 4);
        Model.InteractionPair[] ips = Model.InteractionPair.generatePairwiseInteractionsFromList((int[])new int[]{0, 1, 2, 3});
        DataInfo di = null;
        try {
            di = new DataInfo((Frame)fr.clone(), null, 1, true, DataInfo.TransformType.STANDARDIZE, DataInfo.TransformType.NONE, true, false, false, false, false, false, Model.InteractionSpec.allPairwise((String[])new String[]{fr.name(0), fr.name(1), fr.name(2), fr.name(3)}));
            DataInfoTest.checker(di, true);
        }
        finally {
            fr.delete();
            if (di != null) {
                di.dropInteractions();
                di.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAirlines4() {
        Frame fr = DataInfoTest.parse_test_file((Key)Key.make((String)"a0.hex"), (String)"smalldata/airlines/allyears2k_headers.zip");
        Key k = Key.make((String)"a.hex");
        ((RebalanceDataSet)H2O.submitTask((H2O.H2OCountedCompleter)new RebalanceDataSet(fr, k, 1))).join();
        fr.delete();
        fr = (Frame)DKV.getGet((Key)k);
        Model.InteractionPair[] ips = Model.InteractionPair.generatePairwiseInteractionsFromList((int[])new int[]{8, 16, 2});
        DataInfo di = null;
        try {
            di = new DataInfo((Frame)fr.clone(), null, 1, true, DataInfo.TransformType.STANDARDIZE, DataInfo.TransformType.NONE, true, false, false, false, false, false, Model.InteractionSpec.allPairwise((String[])new String[]{fr.name(8), fr.name(16), fr.name(2)}));
            DataInfoTest.checker(di, true);
        }
        finally {
            fr.delete();
            if (di != null) {
                di.dropInteractions();
                di.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAirlines5() {
        Frame fr = DataInfoTest.parse_test_file((Key)Key.make((String)"a0.hex"), (String)"smalldata/airlines/allyears2k_headers.zip");
        Key k = Key.make((String)"a.hex");
        ((RebalanceDataSet)H2O.submitTask((H2O.H2OCountedCompleter)new RebalanceDataSet(fr, k, 1))).join();
        fr.delete();
        fr = (Frame)DKV.getGet((Key)k);
        Model.InteractionPair[] ips = Model.InteractionPair.generatePairwiseInteractionsFromList((int[])new int[]{8, 16, 2});
        DataInfo di = null;
        try {
            di = new DataInfo((Frame)fr.clone(), null, 1, false, DataInfo.TransformType.STANDARDIZE, DataInfo.TransformType.NONE, true, false, false, false, false, false, Model.InteractionSpec.allPairwise((String[])new String[]{fr.name(8), fr.name(16), fr.name(2)}));
            DataInfoTest.checker(di, true);
        }
        finally {
            fr.delete();
            if (di != null) {
                di.dropInteractions();
                di.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoefNames() throws IOException {
        Frame fr = DataInfoTest.parse_test_file((Key)Key.make((String)"a.hex"), (String)"smalldata/airlines/allyears2k_headers.zip");
        DataInfo dinfo = null;
        try {
            dinfo = new DataInfo((Frame)fr.clone(), null, 1, true, DataInfo.TransformType.STANDARDIZE, DataInfo.TransformType.NONE, true, false, false, false, false, false, Model.InteractionSpec.allPairwise((String[])new String[]{fr.name(8), fr.name(16), fr.name(2)}));
            Assert.assertNull((Object)dinfo._coefNames);
            Object[] cn = dinfo.coefNames();
            Assert.assertNotNull((Object)cn);
            Assert.assertArrayEquals((Object[])cn, (Object[])dinfo._coefNames);
            DKV.put((Keyed)dinfo);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            dinfo.writeAll(new AutoBuffer((OutputStream)baos, true)).close();
            baos.close();
            ByteArrayInputStream input = new ByteArrayInputStream(baos.toByteArray());
            DataInfo deserialized = (DataInfo)Keyed.readAll((AutoBuffer)new AutoBuffer((InputStream)input));
            Assert.assertNotNull((Object)deserialized);
            Assert.assertArrayEquals((Object[])cn, (Object[])deserialized._coefNames);
        }
        finally {
            if (dinfo != null) {
                dinfo.dropInteractions();
                dinfo.remove();
            }
            fr.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInteractionsForcedAllFactors() {
        try {
            Scope.enter();
            Frame fr = Scope.track((Frame[])new Frame[]{DataInfoTest.parse_test_file((Key)Key.make((String)"a.hex"), (String)"smalldata/airlines/allyears2k_headers.zip")});
            Frame sfr = fr.subframe(new String[]{"Origin", "Distance"});
            Model.InteractionSpec interactionSpec = Model.InteractionSpec.create((String[])new String[]{"Origin", "Distance"}, null, (String[])new String[]{"Distance"});
            DataInfo dinfo = new DataInfo(sfr, null, 1, false, DataInfo.TransformType.STANDARDIZE, DataInfo.TransformType.NONE, true, false, false, false, false, false, interactionSpec);
            Assert.assertEquals((long)fr.vec("Origin").domain().length, (long)dinfo.coefNames().length);
            Object[] expected = new String[dinfo.coefNames().length];
            for (int i = 0; i < expected.length; ++i) {
                expected[i] = "Origin_Distance." + sfr.vec("Origin").domain()[i];
            }
            Assert.assertArrayEquals((Object[])expected, (Object[])dinfo.coefNames());
            dinfo.dropInteractions();
            dinfo.remove();
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInteractionsSkip1stFactor() {
        try {
            Scope.enter();
            Frame fr = Scope.track((Frame[])new Frame[]{DataInfoTest.parse_test_file((Key)Key.make((String)"a.hex"), (String)"smalldata/airlines/allyears2k_headers.zip")});
            Frame sfr = fr.subframe(new String[]{"Origin", "Distance", "IsDepDelayed"});
            Model.InteractionSpec interactionSpec = Model.InteractionSpec.create((String[])new String[]{"Origin", "Distance"}, null, (String[])new String[]{"Origin"});
            DataInfo dinfo = new DataInfo(sfr, null, 1, false, DataInfo.TransformType.STANDARDIZE, DataInfo.TransformType.NONE, true, false, false, false, false, false, interactionSpec);
            Assert.assertEquals((long)fr.vec("Origin").domain().length, (long)dinfo.coefNames().length);
            Object[] expected = new String[dinfo.coefNames().length];
            expected[expected.length - 1] = "Distance";
            for (int i = 0; i < expected.length - 1; ++i) {
                expected[i] = "Origin_Distance." + fr.vec("Origin").domain()[i + 1];
            }
            Assert.assertArrayEquals((Object[])expected, (Object[])dinfo.coefNames());
            for (int j = 1; j < dinfo._adaptedFrame.vec(0).domain().length; ++j) {
                if (dinfo.getCategoricalIdFromInteraction(0, j) >= 0) continue;
                Assert.fail((String)("Categorical value should be recognized: " + j));
            }
            dinfo._valid = true;
            Assert.assertEquals((long)fr.vec("Origin").mode(), (long)dinfo.getCategoricalIdFromInteraction(0, dinfo._adaptedFrame.vec(0).domain().length));
            dinfo.dropInteractions();
            dinfo.remove();
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetCategoricalIdFromInteraction() {
        try {
            Scope.enter();
            Frame fr = Scope.track((Frame[])new Frame[]{DataInfoTest.parse_test_file((Key)Key.make((String)"a.hex"), (String)"smalldata/airlines/allyears2k_headers.zip")});
            Frame sfr = fr.subframe(new String[]{"Origin", "Distance", "IsDepDelayed"});
            Model.InteractionSpec interactionSpec = Model.InteractionSpec.create((String[])new String[]{"Origin", "Distance"}, null, (String[])new String[]{"Origin"});
            DataInfo dinfo = new DataInfo(sfr, null, 1, false, DataInfo.TransformType.STANDARDIZE, DataInfo.TransformType.NONE, true, false, false, false, false, false, interactionSpec);
            for (int j = 1; j < dinfo._adaptedFrame.vec(0).domain().length; ++j) {
                if (dinfo.getCategoricalIdFromInteraction(0, j) >= 0) continue;
                Assert.fail((String)("Categorical value should be recognized: " + j));
            }
            dinfo._valid = true;
            Assert.assertEquals((long)fr.vec("Origin").mode(), (long)dinfo.getCategoricalIdFromInteraction(0, dinfo._adaptedFrame.vec(0).domain().length));
            dinfo.dropInteractions();
            dinfo.remove();
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    private static DataInfo.Row[] makeRowsOpsTestData() {
        Frame f = TestFrameCatalog.oneChunkFewRows();
        DataInfo di = new DataInfo(f, null, 1, true, DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, true, false, false, false, false, false, null).disableIntercept();
        Chunk[] chks = new Chunk[f.numCols()];
        for (int i = 0; i < chks.length; ++i) {
            chks[i] = di._adaptedFrame.vec(i).chunkForChunkIdx(0);
        }
        return new DataInfo.Row[]{di.extractDenseRow(chks, 0, di.newDenseRow()), di.extractDenseRow(chks, 1, di.newDenseRow()), di.extractDenseRow(chks, 2, di.newDenseRow())};
    }

    @Test
    public void testInnerProduct() {
        Scope.enter();
        try {
            DataInfo.Row[] rs = DataInfoTest.makeRowsOpsTestData();
            Assert.assertEquals((double)3.44, (double)rs[0].innerProduct(rs[0]), (double)0.0);
            Assert.assertEquals((double)4.08, (double)rs[0].innerProduct(rs[1]), (double)0.0);
            Assert.assertEquals((double)6.72, (double)rs[0].innerProduct(rs[2]), (double)0.0);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    @Test
    public void testTwoNormSq() {
        Scope.enter();
        try {
            DataInfo.Row[] rs = DataInfoTest.makeRowsOpsTestData();
            Assert.assertEquals((double)3.44, (double)rs[0].twoNormSq(), (double)0.0);
            Assert.assertEquals((double)rs[1].innerProduct(rs[1]), (double)rs[1].twoNormSq(), (double)0.0);
            Assert.assertEquals((double)rs[2].innerProduct(rs[2]), (double)rs[2].twoNormSq(), (double)0.0);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    private static void printVals(DataInfo di, DataInfo.Row denseRow, DataInfo.Row sparseRow) {
        System.out.println("col|dense|sparse|sparseScaled");
        for (int i = 0; i < di.fullN(); ++i) {
            double sparseScaled = sparseRow.get(i);
            if (i >= di.numStart()) {
                sparseScaled -= di._normSub[i - di.numStart()] * di._normMul[i - di.numStart()];
            }
            String line = i + "|" + denseRow.get(i) + "|" + sparseRow.get(i) + "|" + sparseScaled;
            if (!(Math.abs(denseRow.get(i) - sparseScaled) > 1.0E-14)) continue;
            System.out.println(">" + line + "<");
        }
    }

    private static void checker(final DataInfo di, final boolean standardize) {
        new MRTask(){

            public void map(Chunk[] cs) {
                if (cs[0].start() == 23889L) {
                    System.out.println("haha");
                }
                DataInfo.Row[] sparseRows = di.extractSparseRows(cs);
                DataInfo.Row r = di.newDenseRow();
                for (int i = 0; i < cs[0]._len; ++i) {
                    di.extractDenseRow(cs, i, r);
                    for (int j = 0; j < di.fullN(); ++j) {
                        double sparseDoubleScaled = sparseRows[i].get(j);
                        if (j >= di.numStart()) {
                            sparseDoubleScaled -= standardize ? di._normSub[j - di.numStart()] * di._normMul[j - di.numStart()] : 0.0;
                        }
                        if (r.isBad() || sparseRows[i].isBad()) {
                            if (sparseRows[i].isBad() && r.isBad()) continue;
                            throw new RuntimeException("dense row was " + (r.isBad() ? "bad" : "not bad") + "; but sparse row was " + (sparseRows[i].isBad() ? "bad" : "not bad"));
                        }
                        if (!(Math.abs(r.get(j) - sparseDoubleScaled) > 1.0E-10)) continue;
                        DataInfoTest.printVals(di, r, sparseRows[i]);
                        throw new RuntimeException("Row mismatch on row " + i);
                    }
                }
            }
        }.doAll(di._adaptedFrame);
    }
}

