/*
 * Decompiled with CFR 0.152.
 */
package hex.DTMatrix;

import hex.DMatrix;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import water.Key;
import water.TestUtil;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;

public class DMatrixTest
extends TestUtil {
    public static final double TOLERANCE = 1.0E-6;

    @BeforeClass
    public static void setup() {
        DMatrixTest.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMatrixMultiply() throws InterruptedException, ExecutionException {
        Frame train = null;
        Frame tTrain = null;
        Frame productF = null;
        try {
            train = ArrayUtils.frame((String[])DMatrixTest.ar((String[])new String[]{"A", "B"}), (double[][])new double[][]{DMatrixTest.ard((double[])new double[]{1.0, 2.0}), DMatrixTest.ard((double[])new double[]{3.0, 4.3}), DMatrixTest.ard((double[])new double[]{5.0, 6.0})});
            tTrain = ArrayUtils.frame((String[])DMatrixTest.ar((String[])new String[]{"A", "B", "C"}), (double[][])new double[][]{DMatrixTest.ard((double[])new double[]{4.0, 2.0, 5.0}), DMatrixTest.ard((double[])new double[]{3.0, 1.0, 6.0})});
            double[][] answer = DMatrixTest.ard((double[][])new double[][]{DMatrixTest.ard((double[])new double[]{10.0, 4.0, 17.0}), DMatrixTest.ard((double[])new double[]{24.9, 10.3, 40.8}), DMatrixTest.ard((double[])new double[]{38.0, 16.0, 61.0})});
            productF = DMatrix.mmul((Frame)train, (Frame)tTrain);
            Assert.assertEquals((long)train.numRows(), (long)productF.numRows());
            Assert.assertEquals((long)tTrain.numCols(), (long)productF.numCols());
            Assert.assertTrue((Math.abs(productF.vec(0).at(0L) - answer[0][0]) < 1.0E-10 ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs(productF.vec(1).at(0L) - answer[0][1]) < 1.0E-10 ? 1 : 0) != 0);
        }
        finally {
            if (train != null) {
                train.delete();
            }
            if (tTrain != null) {
                tTrain.delete();
            }
            if (productF != null) {
                productF.delete();
            }
        }
    }

    @Test
    public void testMatrixTransposeNA() throws InterruptedException, ExecutionException {
        Frame train = null;
        Frame tTrain = null;
        try {
            train = DMatrixTest.parse_test_file((Key)Key.make((String)"prostate_cat.hex"), (String)"smalldata/pca_test/decathlon.csv");
            train.remove(12).remove();
            train.remove(11).remove();
            train.remove(10).remove();
            tTrain = DMatrix.transpose((Frame)train);
            Assert.assertEquals((long)train.numCols(), (long)tTrain.numRows());
            Assert.assertEquals((long)train.numRows(), (long)tTrain.numCols());
            Assert.assertEquals((double)train.vec(2).at(8L), (double)tTrain.vec(8).at(2L), (double)1.0E-10);
            Assert.assertTrue((Math.abs(train.vec(4).at(18L) - tTrain.vec(18).at(4L)) < 1.0E-10 ? 1 : 0) != 0);
        }
        finally {
            if (train != null) {
                train.delete();
            }
            if (tTrain != null) {
                tTrain.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMatrixTransposeSparse() throws InterruptedException, ExecutionException {
        Frame train = null;
        Frame tTrain = null;
        try {
            int i;
            double[] vals1 = new double[1024];
            double[] vals2 = new double[1024];
            double[] vals3 = new double[1024];
            double[] vals4 = new double[1024];
            Random rnd = new Random();
            for (i = 0; i < 96; ++i) {
                vals1[rnd.nextInt((int)vals1.length)] = rnd.nextInt(100);
                vals3[rnd.nextInt((int)vals3.length)] = rnd.nextFloat();
            }
            for (i = 0; i < vals2.length; ++i) {
                vals2[i] = rnd.nextDouble();
                vals4[i] = rnd.nextInt();
            }
            Vec.VectorGroup vg = Vec.VectorGroup.VG_LEN1;
            Vec v1 = Vec.makeCon((Key)vg.addVec(), (double[])vals1);
            Vec v2 = Vec.makeCon((Key)vg.addVec(), (double[])vals2);
            Vec v3 = Vec.makeCon((Key)vg.addVec(), (double[])vals3);
            Vec v4 = Vec.makeCon((Key)vg.addVec(), (double[])vals4);
            train = new Frame(new Vec[]{v1, v2, v3, v4});
            tTrain = DMatrix.transpose((Frame)train);
            Assert.assertEquals((long)vals1.length, (long)tTrain.numCols());
            for (int i2 = 0; i2 < vals1.length; ++i2) {
                Vec x = tTrain.vec(i2);
                Assert.assertEquals((double)vals1[i2], (double)x.at(0L), (double)0.0);
                Assert.assertEquals((double)vals2[i2], (double)x.at(1L), (double)0.0);
                Assert.assertEquals((double)vals3[i2], (double)x.at(2L), (double)0.0);
                Assert.assertEquals((double)vals4[i2], (double)x.at(3L), (double)0.0);
            }
        }
        finally {
            if (train != null) {
                train.delete();
            }
            if (tTrain != null) {
                tTrain.delete();
            }
        }
    }
}

