/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.Model;
import hex.genmodel.utils.DistributionFamily;
import hex.naivebayes.NaiveBayes;
import hex.naivebayes.NaiveBayesModel;
import hex.tree.gbm.GBM;
import hex.tree.gbm.GBMModel;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import water.DKV;
import water.DKVManager;
import water.Key;
import water.Keyed;
import water.Scope;
import water.TestUtil;
import water.Value;
import water.fvec.Frame;
import water.fvec.TestFrameBuilder;
import water.fvec.Vec;
import water.fvec.VecHelper;

public class DKVManagerTest
extends TestUtil {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @BeforeClass
    public static void setup() {
        DKVManagerTest.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNaiveBayesModel() {
        NaiveBayesModel model = null;
        Frame trainingFrame = null;
        Frame preds = null;
        try {
            trainingFrame = DKVManagerTest.parse_test_file((String)"./smalldata/iris/iris_wheader.csv");
            ArrayList<Key> retainedKeys = new ArrayList<Key>();
            retainedKeys.add(trainingFrame._key);
            DKVManagerTest.testRetainFrame(trainingFrame);
            NaiveBayesModel.NaiveBayesParameters parms = new NaiveBayesModel.NaiveBayesParameters();
            parms._train = trainingFrame._key;
            parms._laplace = 0.0;
            parms._response_column = trainingFrame._names[4];
            parms._compute_metrics = false;
            model = (NaiveBayesModel)new NaiveBayes(parms).trainModel().get();
            Assert.assertNotNull((Object)model);
            preds = model.score(trainingFrame);
            Assert.assertNotNull((Object)preds);
            DKVManagerTest.testRetainModel((Model)model, trainingFrame);
            DKVManagerTest.testModelDeletion((Model)model);
        }
        finally {
            if (trainingFrame != null) {
                trainingFrame.delete();
            }
            if (preds != null) {
                preds.delete();
            }
            if (model != null) {
                model.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGBM() {
        GBMModel model = null;
        Frame trainingFrame = null;
        Frame preds = null;
        try {
            trainingFrame = DKVManagerTest.parse_test_file((String)"./smalldata/gbm_test/Mfgdata_gaussian_GBM_testing.csv");
            DKVManagerTest.testRetainFrame(trainingFrame);
            GBMModel.GBMParameters parms = new GBMModel.GBMParameters();
            parms._train = trainingFrame._key;
            parms._distribution = DistributionFamily.AUTO;
            parms._response_column = trainingFrame._names[1];
            parms._ntrees = 1;
            parms._max_depth = 1;
            parms._min_rows = 1.0;
            parms._nbins = 20;
            parms._learn_rate = 1.0;
            parms._score_each_iteration = true;
            GBM job = new GBM(parms);
            model = (GBMModel)job.trainModel().get();
            Assert.assertNotNull((Object)model);
            preds = model.score(trainingFrame);
            Assert.assertNotNull((Object)preds);
            DKVManagerTest.testRetainModel((Model)model, trainingFrame);
            DKVManagerTest.testModelDeletion((Model)model);
        }
        finally {
            if (trainingFrame != null) {
                trainingFrame.remove();
            }
            if (preds != null) {
                preds.remove();
            }
            if (model != null) {
                model.remove();
            }
        }
    }

    @Test
    public void testRetainSharedVecs() {
        try {
            Scope.enter();
            Frame f1 = new TestFrameBuilder().withVecTypes(new byte[]{3, 3}).withDataForCol(0, DKVManagerTest.ar((long[])new long[]{0L, 1L})).withDataForCol(1, DKVManagerTest.ar((long[])new long[]{2L, 3L})).build();
            Frame f2 = new Frame(Key.make());
            f2.add("vec_shared_with_f1", f1.vec(1));
            DKV.put((Keyed)f2);
            Scope.track((Frame[])new Frame[]{f2});
            DKVManager.retain((Key[])new Key[]{f1._key});
            Assert.assertNotNull((Object)f1._key.get());
            Assert.assertNotNull((Object)f1.vec(1).chunkForChunkIdx(0));
            Assert.assertNull((Object)f2._key.get());
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    @Test
    public void testRetain_badKey() {
        try {
            Scope.enter();
            Frame f1 = new TestFrameBuilder().withVecTypes(new byte[]{3, 3}).withDataForCol(0, DKVManagerTest.ar((long[])new long[]{0L, 1L})).withDataForCol(1, DKVManagerTest.ar((long[])new long[]{2L, 3L})).build();
            this.expectedException.expect(IllegalArgumentException.class);
            this.expectedException.expectMessage("Please provide only Model and Frame keys.");
            DKVManager.retain((Key[])new Key[]{f1.vec((int)0)._key});
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRetainModels_sharedFrames() {
        try {
            Scope.enter();
            Frame trainingFrame = DKVManagerTest.parse_test_file((String)"./smalldata/iris/iris_wheader.csv");
            Scope.track((Frame[])new Frame[]{trainingFrame});
            NaiveBayesModel.NaiveBayesParameters parms = new NaiveBayesModel.NaiveBayesParameters();
            parms._train = trainingFrame._key;
            parms._valid = trainingFrame._key;
            parms._laplace = 0.0;
            parms._response_column = trainingFrame._names[4];
            parms._compute_metrics = false;
            Model model = (Model)new NaiveBayes(parms).trainModel().get();
            Scope.track_generic((Keyed)model);
            DKVManager.retain((Key[])new Key[]{model._key});
            Value value = DKV.get((Key)trainingFrame._key);
            Assert.assertNotNull((Object)value);
            Assert.assertTrue((boolean)value.isFrame());
            Assert.assertFalse((boolean)value.isDeleted());
            Assert.assertNotNull((Object)value.get());
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRetainModels_sharedVecs() {
        try {
            Scope.enter();
            Frame trainingFrame = DKVManagerTest.parse_test_file((String)"./smalldata/iris/iris_wheader.csv");
            Scope.track((Frame[])new Frame[]{trainingFrame});
            Frame sharedFrame = new Frame(Key.make((String)"sharedFrame"));
            sharedFrame.add("borrowedCol", trainingFrame.vec(0));
            DKV.put((Keyed)sharedFrame);
            Scope.track((Frame[])new Frame[]{sharedFrame});
            NaiveBayesModel.NaiveBayesParameters parms = new NaiveBayesModel.NaiveBayesParameters();
            parms._train = trainingFrame._key;
            parms._valid = trainingFrame._key;
            parms._laplace = 0.0;
            parms._response_column = trainingFrame._names[4];
            parms._compute_metrics = false;
            Model model = (Model)new NaiveBayes(parms).trainModel().get();
            Scope.track_generic((Keyed)model);
            DKVManager.retain((Key[])new Key[]{model._key});
            Value sharedFrameVal = DKV.get((Key)sharedFrame._key);
            Assert.assertNull((Object)sharedFrameVal);
            Value trainVal = DKV.get((Key)trainingFrame._key);
            Assert.assertNotNull((Object)trainVal);
            Assert.assertTrue((boolean)trainVal.isFrame());
            Assert.assertFalse((boolean)trainVal.isDeleted());
            Assert.assertNotNull((Object)trainVal.get());
            for (Key k : trainingFrame.keys()) {
                Assert.assertNotNull((Object)DKV.get((Key)k));
            }
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testdeleteModel_retainFrame() {
        try {
            Scope.enter();
            Frame trainingFrame = DKVManagerTest.parse_test_file((String)"./smalldata/iris/iris_wheader.csv");
            Scope.track((Frame[])new Frame[]{trainingFrame});
            NaiveBayesModel.NaiveBayesParameters parms = new NaiveBayesModel.NaiveBayesParameters();
            parms._train = trainingFrame._key;
            parms._laplace = 0.0;
            parms._response_column = trainingFrame._names[4];
            parms._compute_metrics = false;
            Model model = (Model)new NaiveBayes(parms).trainModel().get();
            Scope.track_generic((Keyed)model);
            DKVManager.retain((Key[])new Key[]{trainingFrame._key});
            Value value = DKV.get((Key)trainingFrame._key);
            Assert.assertNotNull((Object)value);
            Assert.assertTrue((boolean)value.isFrame());
            Assert.assertFalse((boolean)value.isDeleted());
            Assert.assertNotNull((Object)value.get());
            Assert.assertNull((Object)DKV.get((Key)model._key));
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRetainFrame() {
        Frame frame = null;
        try {
            frame = TestUtil.parse_test_file((String)"./smalldata/testng/airlines_train.csv");
            DKVManager.retain((Key[])new Key[]{frame._key});
            Assert.assertNotNull((Object)DKV.get((Key)frame._key));
            for (Vec vec : frame.vecs()) {
                Assert.assertNotNull((Object)vec._key);
                for (int i = 0; i < vec.nChunks(); ++i) {
                    Assert.assertNotNull((Object)DKV.get((Key)vec.chunkKey(i)));
                }
            }
        }
        finally {
            if (frame != null) {
                frame.delete();
            }
        }
    }

    @Test
    public void testRetainNothing() throws InterruptedException {
        Frame frame = null;
        try {
            frame = TestUtil.parse_test_file((String)"smalldata/testng/airlines_train.csv");
            DKVManager.retain((Key[])new Key[0]);
            Assert.assertNull((Object)DKV.get((Key)frame._key));
        }
        finally {
            if (frame != null) {
                frame.delete();
            }
        }
    }

    private static void testRetainFrame(Frame trainingFrame) {
        DKVManager.retain((Key[])new Key[]{trainingFrame._key});
        Assert.assertNotNull((Object)DKV.get((Key)trainingFrame._key));
        for (Vec vec : trainingFrame.vecs()) {
            Assert.assertNotNull((Object)DKV.get((Key)vec._key));
            for (int i = 0; i < vec.nChunks(); ++i) {
                Assert.assertNotNull((Object)VecHelper.vecChunkIdx((Vec)vec, (int)i));
            }
        }
    }

    private static void testRetainModel(Model model, Frame trainingFrame) {
        Assert.assertNotNull((Object)DKV.get((Key)model._key));
        DKVManager.retain((Key[])new Key[]{model._key});
        Assert.assertNotNull((Object)DKV.get((Key)model._key));
    }

    private static void testModelDeletion(Model model) {
        DKVManager.retain((Key[])new Key[0]);
        Assert.assertNull((Object)DKV.get((Key)model._key));
    }
}

